// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/identity/accesscontextmanager/v1/access_level.proto

package accesscontextmanager

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_type "google.golang.org/genproto/googleapis/identity/accesscontextmanager/type"
	expr "google.golang.org/genproto/googleapis/type/expr"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Options for how the `conditions` list should be combined to determine if
// this `AccessLevel` is applied. Default is AND.
type BasicLevel_ConditionCombiningFunction int32

const (
	// All `Conditions` must be true for the `BasicLevel` to be true.
	BasicLevel_AND BasicLevel_ConditionCombiningFunction = 0
	// If at least one `Condition` is true, then the `BasicLevel` is true.
	BasicLevel_OR BasicLevel_ConditionCombiningFunction = 1
)

var BasicLevel_ConditionCombiningFunction_name = map[int32]string{
	0: "AND",
	1: "OR",
}

var BasicLevel_ConditionCombiningFunction_value = map[string]int32{
	"AND": 0,
	"OR":  1,
}

func (x BasicLevel_ConditionCombiningFunction) String() string {
	return proto.EnumName(BasicLevel_ConditionCombiningFunction_name, int32(x))
}

func (BasicLevel_ConditionCombiningFunction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{1, 0}
}

// An `AccessLevel` is a label that can be applied to requests to Google Cloud
// services, along with a list of requirements necessary for the label to be
// applied.
type AccessLevel struct {
	// Required. Resource name for the Access Level. The `short_name` component
	// must begin with a letter and only include alphanumeric and '_'. Format:
	// `accessPolicies/{policy_id}/accessLevels/{short_name}`. The maximum length
	// of the `short_name` component is 50 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable title. Must be unique within the Policy.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Description of the `AccessLevel` and its use. Does not affect behavior.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Describes the necessary conditions for the level to apply.
	//
	// Types that are valid to be assigned to Level:
	//	*AccessLevel_Basic
	//	*AccessLevel_Custom
	Level isAccessLevel_Level `protobuf_oneof:"level"`
	// Output only. Time the `AccessLevel` was created in UTC.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the `AccessLevel` was updated in UTC.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *AccessLevel) Reset()         { *m = AccessLevel{} }
func (m *AccessLevel) String() string { return proto.CompactTextString(m) }
func (*AccessLevel) ProtoMessage()    {}
func (*AccessLevel) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{0}
}

func (m *AccessLevel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccessLevel.Unmarshal(m, b)
}
func (m *AccessLevel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccessLevel.Marshal(b, m, deterministic)
}
func (m *AccessLevel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccessLevel.Merge(m, src)
}
func (m *AccessLevel) XXX_Size() int {
	return xxx_messageInfo_AccessLevel.Size(m)
}
func (m *AccessLevel) XXX_DiscardUnknown() {
	xxx_messageInfo_AccessLevel.DiscardUnknown(m)
}

var xxx_messageInfo_AccessLevel proto.InternalMessageInfo

func (m *AccessLevel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AccessLevel) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *AccessLevel) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isAccessLevel_Level interface {
	isAccessLevel_Level()
}

type AccessLevel_Basic struct {
	Basic *BasicLevel `protobuf:"bytes,4,opt,name=basic,proto3,oneof"`
}

type AccessLevel_Custom struct {
	Custom *CustomLevel `protobuf:"bytes,5,opt,name=custom,proto3,oneof"`
}

func (*AccessLevel_Basic) isAccessLevel_Level() {}

func (*AccessLevel_Custom) isAccessLevel_Level() {}

func (m *AccessLevel) GetLevel() isAccessLevel_Level {
	if m != nil {
		return m.Level
	}
	return nil
}

func (m *AccessLevel) GetBasic() *BasicLevel {
	if x, ok := m.GetLevel().(*AccessLevel_Basic); ok {
		return x.Basic
	}
	return nil
}

func (m *AccessLevel) GetCustom() *CustomLevel {
	if x, ok := m.GetLevel().(*AccessLevel_Custom); ok {
		return x.Custom
	}
	return nil
}

func (m *AccessLevel) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *AccessLevel) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AccessLevel) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AccessLevel_Basic)(nil),
		(*AccessLevel_Custom)(nil),
	}
}

// `BasicLevel` is an `AccessLevel` using a set of recommended features.
type BasicLevel struct {
	// Required. A list of requirements for the `AccessLevel` to be granted.
	Conditions []*Condition `protobuf:"bytes,1,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// How the `conditions` list should be combined to determine if a request is
	// granted this `AccessLevel`. If AND is used, each `Condition` in
	// `conditions` must be satisfied for the `AccessLevel` to be applied. If OR
	// is used, at least one `Condition` in `conditions` must be satisfied for the
	// `AccessLevel` to be applied. Default behavior is AND.
	CombiningFunction    BasicLevel_ConditionCombiningFunction `protobuf:"varint,2,opt,name=combining_function,json=combiningFunction,proto3,enum=google.identity.accesscontextmanager.v1.BasicLevel_ConditionCombiningFunction" json:"combining_function,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *BasicLevel) Reset()         { *m = BasicLevel{} }
func (m *BasicLevel) String() string { return proto.CompactTextString(m) }
func (*BasicLevel) ProtoMessage()    {}
func (*BasicLevel) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{1}
}

func (m *BasicLevel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicLevel.Unmarshal(m, b)
}
func (m *BasicLevel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicLevel.Marshal(b, m, deterministic)
}
func (m *BasicLevel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicLevel.Merge(m, src)
}
func (m *BasicLevel) XXX_Size() int {
	return xxx_messageInfo_BasicLevel.Size(m)
}
func (m *BasicLevel) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicLevel.DiscardUnknown(m)
}

var xxx_messageInfo_BasicLevel proto.InternalMessageInfo

func (m *BasicLevel) GetConditions() []*Condition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

func (m *BasicLevel) GetCombiningFunction() BasicLevel_ConditionCombiningFunction {
	if m != nil {
		return m.CombiningFunction
	}
	return BasicLevel_AND
}

// A condition necessary for an `AccessLevel` to be granted. The Condition is an
// AND over its fields. So a Condition is true if: 1) the request IP is from one
// of the listed subnetworks AND 2) the originating device complies with the
// listed device policy AND 3) all listed access levels are granted AND 4) the
// request was sent at a time allowed by the DateTimeRestriction.
type Condition struct {
	// CIDR block IP subnetwork specification. May be IPv4 or IPv6. Note that for
	// a CIDR IP address block, the specified IP address portion must be properly
	// truncated (i.e. all the host bits must be zero) or the input is considered
	// malformed. For example, "192.0.2.0/24" is accepted but "192.0.2.1/24" is
	// not. Similarly, for IPv6, "2001:db8::/32" is accepted whereas
	// "2001:db8::1/32" is not. The originating IP of a request must be in one of
	// the listed subnets in order for this Condition to be true. If empty, all IP
	// addresses are allowed.
	IpSubnetworks []string `protobuf:"bytes,1,rep,name=ip_subnetworks,json=ipSubnetworks,proto3" json:"ip_subnetworks,omitempty"`
	// Device specific restrictions, all restrictions must hold for the
	// Condition to be true. If not specified, all devices are allowed.
	DevicePolicy *DevicePolicy `protobuf:"bytes,2,opt,name=device_policy,json=devicePolicy,proto3" json:"device_policy,omitempty"`
	// A list of other access levels defined in the same `Policy`, referenced by
	// resource name. Referencing an `AccessLevel` which does not exist is an
	// error. All access levels listed must be granted for the Condition
	// to be true. Example:
	// "`accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"`
	RequiredAccessLevels []string `protobuf:"bytes,3,rep,name=required_access_levels,json=requiredAccessLevels,proto3" json:"required_access_levels,omitempty"`
	// Whether to negate the Condition. If true, the Condition becomes a NAND over
	// its non-empty fields, each field must be false for the Condition overall to
	// be satisfied. Defaults to false.
	Negate bool `protobuf:"varint,5,opt,name=negate,proto3" json:"negate,omitempty"`
	// The request must be made by one of the provided user or service
	// accounts. Groups are not supported.
	// Syntax:
	// `user:{emailid}`
	// `serviceAccount:{emailid}`
	// If not specified, a request may come from any user.
	Members []string `protobuf:"bytes,6,rep,name=members,proto3" json:"members,omitempty"`
	// The request must originate from one of the provided countries/regions.
	// Must be valid ISO 3166-1 alpha-2 codes.
	Regions              []string `protobuf:"bytes,7,rep,name=regions,proto3" json:"regions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Condition) Reset()         { *m = Condition{} }
func (m *Condition) String() string { return proto.CompactTextString(m) }
func (*Condition) ProtoMessage()    {}
func (*Condition) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{2}
}

func (m *Condition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Condition.Unmarshal(m, b)
}
func (m *Condition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Condition.Marshal(b, m, deterministic)
}
func (m *Condition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Condition.Merge(m, src)
}
func (m *Condition) XXX_Size() int {
	return xxx_messageInfo_Condition.Size(m)
}
func (m *Condition) XXX_DiscardUnknown() {
	xxx_messageInfo_Condition.DiscardUnknown(m)
}

var xxx_messageInfo_Condition proto.InternalMessageInfo

func (m *Condition) GetIpSubnetworks() []string {
	if m != nil {
		return m.IpSubnetworks
	}
	return nil
}

func (m *Condition) GetDevicePolicy() *DevicePolicy {
	if m != nil {
		return m.DevicePolicy
	}
	return nil
}

func (m *Condition) GetRequiredAccessLevels() []string {
	if m != nil {
		return m.RequiredAccessLevels
	}
	return nil
}

func (m *Condition) GetNegate() bool {
	if m != nil {
		return m.Negate
	}
	return false
}

func (m *Condition) GetMembers() []string {
	if m != nil {
		return m.Members
	}
	return nil
}

func (m *Condition) GetRegions() []string {
	if m != nil {
		return m.Regions
	}
	return nil
}

// `CustomLevel` is an `AccessLevel` using the Cloud Common Expression Language
// to represent the necessary conditions for the level to apply to a request.
// See CEL spec at: https://github.com/google/cel-spec
type CustomLevel struct {
	// Required. A Cloud CEL expression evaluating to a boolean.
	Expr                 *expr.Expr `protobuf:"bytes,1,opt,name=expr,proto3" json:"expr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CustomLevel) Reset()         { *m = CustomLevel{} }
func (m *CustomLevel) String() string { return proto.CompactTextString(m) }
func (*CustomLevel) ProtoMessage()    {}
func (*CustomLevel) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{3}
}

func (m *CustomLevel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomLevel.Unmarshal(m, b)
}
func (m *CustomLevel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomLevel.Marshal(b, m, deterministic)
}
func (m *CustomLevel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomLevel.Merge(m, src)
}
func (m *CustomLevel) XXX_Size() int {
	return xxx_messageInfo_CustomLevel.Size(m)
}
func (m *CustomLevel) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomLevel.DiscardUnknown(m)
}

var xxx_messageInfo_CustomLevel proto.InternalMessageInfo

func (m *CustomLevel) GetExpr() *expr.Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

// `DevicePolicy` specifies device specific restrictions necessary to acquire a
// given access level. A `DevicePolicy` specifies requirements for requests from
// devices to be granted access levels, it does not do any enforcement on the
// device. `DevicePolicy` acts as an AND over all specified fields, and each
// repeated field is an OR over its elements. Any unset fields are ignored. For
// example, if the proto is { os_type : DESKTOP_WINDOWS, os_type :
// DESKTOP_LINUX, encryption_status: ENCRYPTED}, then the DevicePolicy will be
// true for requests originating from encrypted Linux desktops and encrypted
// Windows desktops.
type DevicePolicy struct {
	// Whether or not screenlock is required for the DevicePolicy to be true.
	// Defaults to `false`.
	RequireScreenlock bool `protobuf:"varint,1,opt,name=require_screenlock,json=requireScreenlock,proto3" json:"require_screenlock,omitempty"`
	// Allowed encryptions statuses, an empty list allows all statuses.
	AllowedEncryptionStatuses []_type.DeviceEncryptionStatus `protobuf:"varint,2,rep,packed,name=allowed_encryption_statuses,json=allowedEncryptionStatuses,proto3,enum=google.identity.accesscontextmanager.type.DeviceEncryptionStatus" json:"allowed_encryption_statuses,omitempty"`
	// Allowed OS versions, an empty list allows all types and all versions.
	OsConstraints []*OsConstraint `protobuf:"bytes,3,rep,name=os_constraints,json=osConstraints,proto3" json:"os_constraints,omitempty"`
	// Allowed device management levels, an empty list allows all management
	// levels.
	AllowedDeviceManagementLevels []_type.DeviceManagementLevel `protobuf:"varint,6,rep,packed,name=allowed_device_management_levels,json=allowedDeviceManagementLevels,proto3,enum=google.identity.accesscontextmanager.type.DeviceManagementLevel" json:"allowed_device_management_levels,omitempty"`
	// Whether the device needs to be approved by the customer admin.
	RequireAdminApproval bool `protobuf:"varint,7,opt,name=require_admin_approval,json=requireAdminApproval,proto3" json:"require_admin_approval,omitempty"`
	// Whether the device needs to be corp owned.
	RequireCorpOwned     bool     `protobuf:"varint,8,opt,name=require_corp_owned,json=requireCorpOwned,proto3" json:"require_corp_owned,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DevicePolicy) Reset()         { *m = DevicePolicy{} }
func (m *DevicePolicy) String() string { return proto.CompactTextString(m) }
func (*DevicePolicy) ProtoMessage()    {}
func (*DevicePolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{4}
}

func (m *DevicePolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DevicePolicy.Unmarshal(m, b)
}
func (m *DevicePolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DevicePolicy.Marshal(b, m, deterministic)
}
func (m *DevicePolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DevicePolicy.Merge(m, src)
}
func (m *DevicePolicy) XXX_Size() int {
	return xxx_messageInfo_DevicePolicy.Size(m)
}
func (m *DevicePolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_DevicePolicy.DiscardUnknown(m)
}

var xxx_messageInfo_DevicePolicy proto.InternalMessageInfo

func (m *DevicePolicy) GetRequireScreenlock() bool {
	if m != nil {
		return m.RequireScreenlock
	}
	return false
}

func (m *DevicePolicy) GetAllowedEncryptionStatuses() []_type.DeviceEncryptionStatus {
	if m != nil {
		return m.AllowedEncryptionStatuses
	}
	return nil
}

func (m *DevicePolicy) GetOsConstraints() []*OsConstraint {
	if m != nil {
		return m.OsConstraints
	}
	return nil
}

func (m *DevicePolicy) GetAllowedDeviceManagementLevels() []_type.DeviceManagementLevel {
	if m != nil {
		return m.AllowedDeviceManagementLevels
	}
	return nil
}

func (m *DevicePolicy) GetRequireAdminApproval() bool {
	if m != nil {
		return m.RequireAdminApproval
	}
	return false
}

func (m *DevicePolicy) GetRequireCorpOwned() bool {
	if m != nil {
		return m.RequireCorpOwned
	}
	return false
}

// A restriction on the OS type and version of devices making requests.
type OsConstraint struct {
	// Required. The allowed OS type.
	OsType _type.OsType `protobuf:"varint,1,opt,name=os_type,json=osType,proto3,enum=google.identity.accesscontextmanager.type.OsType" json:"os_type,omitempty"`
	// The minimum allowed OS version. If not set, any version of this OS
	// satisfies the constraint. Format: `"major.minor.patch"`.
	// Examples: `"10.5.301"`, `"9.2.1"`.
	MinimumVersion string `protobuf:"bytes,2,opt,name=minimum_version,json=minimumVersion,proto3" json:"minimum_version,omitempty"`
	// Only allows requests from devices with a verified Chrome OS.
	// Verifications includes requirements that the device is enterprise-managed,
	// conformant to domain policies, and the caller has permission to call
	// the API targeted by the request.
	RequireVerifiedChromeOs bool     `protobuf:"varint,3,opt,name=require_verified_chrome_os,json=requireVerifiedChromeOs,proto3" json:"require_verified_chrome_os,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *OsConstraint) Reset()         { *m = OsConstraint{} }
func (m *OsConstraint) String() string { return proto.CompactTextString(m) }
func (*OsConstraint) ProtoMessage()    {}
func (*OsConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4cb12241c5e4d8, []int{5}
}

func (m *OsConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OsConstraint.Unmarshal(m, b)
}
func (m *OsConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OsConstraint.Marshal(b, m, deterministic)
}
func (m *OsConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OsConstraint.Merge(m, src)
}
func (m *OsConstraint) XXX_Size() int {
	return xxx_messageInfo_OsConstraint.Size(m)
}
func (m *OsConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_OsConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_OsConstraint proto.InternalMessageInfo

func (m *OsConstraint) GetOsType() _type.OsType {
	if m != nil {
		return m.OsType
	}
	return _type.OsType_OS_UNSPECIFIED
}

func (m *OsConstraint) GetMinimumVersion() string {
	if m != nil {
		return m.MinimumVersion
	}
	return ""
}

func (m *OsConstraint) GetRequireVerifiedChromeOs() bool {
	if m != nil {
		return m.RequireVerifiedChromeOs
	}
	return false
}

func init() {
	proto.RegisterEnum("google.identity.accesscontextmanager.v1.BasicLevel_ConditionCombiningFunction", BasicLevel_ConditionCombiningFunction_name, BasicLevel_ConditionCombiningFunction_value)
	proto.RegisterType((*AccessLevel)(nil), "google.identity.accesscontextmanager.v1.AccessLevel")
	proto.RegisterType((*BasicLevel)(nil), "google.identity.accesscontextmanager.v1.BasicLevel")
	proto.RegisterType((*Condition)(nil), "google.identity.accesscontextmanager.v1.Condition")
	proto.RegisterType((*CustomLevel)(nil), "google.identity.accesscontextmanager.v1.CustomLevel")
	proto.RegisterType((*DevicePolicy)(nil), "google.identity.accesscontextmanager.v1.DevicePolicy")
	proto.RegisterType((*OsConstraint)(nil), "google.identity.accesscontextmanager.v1.OsConstraint")
}

func init() {
	proto.RegisterFile("google/identity/accesscontextmanager/v1/access_level.proto", fileDescriptor_5f4cb12241c5e4d8)
}

var fileDescriptor_5f4cb12241c5e4d8 = []byte{
	// 943 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4d, 0x6f, 0x23, 0x35,
	0x18, 0xde, 0x4c, 0xd2, 0x24, 0x75, 0xda, 0xd0, 0x5a, 0xab, 0x32, 0x04, 0x10, 0x51, 0xa4, 0x55,
	0x2b, 0x60, 0x13, 0x25, 0x5b, 0x2e, 0xe9, 0x65, 0xd3, 0xec, 0xb2, 0x7c, 0xb5, 0xa9, 0xa6, 0xab,
	0x1c, 0x96, 0x4a, 0x23, 0xc7, 0xf3, 0x76, 0xb0, 0x76, 0xc6, 0x1e, 0x6c, 0x27, 0x6d, 0x0e, 0x1c,
	0x38, 0x72, 0x01, 0x7e, 0x03, 0x07, 0x0e, 0xfc, 0x0a, 0xce, 0xfc, 0x14, 0xfe, 0x01, 0x37, 0x34,
	0x1e, 0x4f, 0x3a, 0x5a, 0x05, 0x6d, 0xca, 0x29, 0xf1, 0xfb, 0x3e, 0xcf, 0xe3, 0xf7, 0xd3, 0x09,
	0x1a, 0x86, 0x42, 0x84, 0x11, 0xf4, 0x58, 0x00, 0x5c, 0x33, 0xbd, 0xec, 0x11, 0x4a, 0x41, 0x29,
	0x2a, 0xb8, 0x86, 0x5b, 0x1d, 0x13, 0x4e, 0x42, 0x90, 0xbd, 0x45, 0xdf, 0xda, 0xfd, 0x08, 0x16,
	0x10, 0x75, 0x13, 0x29, 0xb4, 0xc0, 0x87, 0x19, 0xb7, 0x9b, 0x73, 0xbb, 0xeb, 0xb8, 0xdd, 0x45,
	0xbf, 0xf5, 0x74, 0xa3, 0x4b, 0xf4, 0x32, 0x81, 0x5e, 0x00, 0x0b, 0x46, 0xc1, 0x97, 0xa0, 0xc4,
	0x5c, 0x52, 0x50, 0xd9, 0x55, 0xad, 0x8f, 0xac, 0x82, 0x39, 0xcd, 0xe6, 0xd7, 0x3d, 0xcd, 0x62,
	0x50, 0x9a, 0xc4, 0x89, 0x05, 0x1c, 0x58, 0x80, 0x11, 0x81, 0xdb, 0x44, 0x5a, 0xfb, 0x07, 0xd6,
	0x4e, 0x12, 0xd6, 0x23, 0x9c, 0x0b, 0x4d, 0x34, 0x13, 0xdc, 0xca, 0x76, 0xfe, 0x71, 0x50, 0x63,
	0x64, 0x62, 0xf9, 0x26, 0xcd, 0x0b, 0x63, 0x54, 0xe1, 0x24, 0x06, 0xb7, 0xd4, 0x2e, 0x1d, 0x6d,
	0x7b, 0xe6, 0x3b, 0x7e, 0x88, 0xb6, 0x34, 0xd3, 0x11, 0xb8, 0x8e, 0x31, 0x66, 0x07, 0xdc, 0x46,
	0x8d, 0x00, 0x14, 0x95, 0x2c, 0x49, 0xf5, 0xdc, 0xb2, 0xf1, 0x15, 0x4d, 0xf8, 0x6b, 0xb4, 0x35,
	0x23, 0x8a, 0x51, 0xb7, 0xd2, 0x2e, 0x1d, 0x35, 0x06, 0x4f, 0xba, 0x1b, 0x56, 0xab, 0x7b, 0x9a,
	0xb2, 0x4c, 0x3c, 0x5f, 0x3c, 0xf0, 0x32, 0x0d, 0x7c, 0x8e, 0xaa, 0x74, 0xae, 0xb4, 0x88, 0xdd,
	0x2d, 0xa3, 0x76, 0xbc, 0xb1, 0xda, 0xd8, 0xd0, 0x72, 0x39, 0xab, 0x82, 0x4f, 0x50, 0x83, 0x4a,
	0x20, 0x1a, 0xfc, 0xb4, 0x90, 0x6e, 0xd5, 0x88, 0xb6, 0x72, 0xd1, 0xbc, 0xca, 0xdd, 0x97, 0x79,
	0x95, 0x3d, 0x94, 0xc1, 0x53, 0x43, 0x4a, 0x9e, 0x27, 0xc1, 0x8a, 0x5c, 0x7b, 0x3b, 0x39, 0x83,
	0xa7, 0x86, 0xd3, 0x1a, 0xda, 0x32, 0x33, 0xd4, 0xf9, 0xd9, 0x41, 0xe8, 0x2e, 0x55, 0xec, 0x21,
	0x44, 0x05, 0x0f, 0x98, 0x69, 0x8f, 0x5b, 0x6a, 0x97, 0x8f, 0x1a, 0x83, 0xc1, 0xe6, 0x59, 0xe6,
	0x54, 0xaf, 0xa0, 0x82, 0x7f, 0x40, 0x98, 0x8a, 0x78, 0xc6, 0x38, 0xe3, 0xa1, 0x7f, 0x3d, 0xe7,
	0xd4, 0xf4, 0x2a, 0xed, 0x63, 0x73, 0x70, 0xfe, 0x3f, 0xfa, 0x71, 0x77, 0xcd, 0x38, 0x97, 0xfd,
	0xdc, 0xaa, 0x7a, 0xfb, 0xf4, 0x4d, 0x53, 0xe7, 0x31, 0x6a, 0xfd, 0x37, 0x01, 0xd7, 0x50, 0x79,
	0x74, 0xfe, 0x6c, 0xef, 0x01, 0xae, 0x22, 0x67, 0xe2, 0xed, 0x95, 0x3a, 0xbf, 0x3a, 0x68, 0x7b,
	0x85, 0xc7, 0x8f, 0x50, 0x93, 0x25, 0xbe, 0x9a, 0xcf, 0x38, 0xe8, 0x1b, 0x21, 0x5f, 0x67, 0x35,
	0xd9, 0xf6, 0x76, 0x59, 0x72, 0x79, 0x67, 0xc4, 0xaf, 0xd0, 0xae, 0x5d, 0x99, 0x44, 0x44, 0x8c,
	0x2e, 0x4d, 0x76, 0x8d, 0xc1, 0x67, 0x1b, 0x67, 0xf7, 0xcc, 0xb0, 0x2f, 0x0c, 0xd9, 0xdb, 0x09,
	0x0a, 0x27, 0x7c, 0x8c, 0x0e, 0x24, 0x7c, 0x3f, 0x67, 0x12, 0x02, 0xbf, 0xb8, 0xfe, 0xca, 0x2d,
	0x9b, 0x50, 0x1e, 0xe6, 0xde, 0xc2, 0x0a, 0x29, 0x7c, 0x80, 0xaa, 0x1c, 0x42, 0xa2, 0xc1, 0x8c,
	0x6a, 0xdd, 0xb3, 0x27, 0xec, 0xa2, 0x5a, 0x0c, 0xf1, 0x0c, 0xa4, 0x72, 0xab, 0x86, 0x9e, 0x1f,
	0x53, 0x8f, 0x84, 0xd0, 0xf4, 0xbd, 0x96, 0x79, 0xec, 0xb1, 0x73, 0x8c, 0x1a, 0x85, 0xf9, 0xc5,
	0x8f, 0x50, 0x25, 0x5d, 0x6d, 0xb3, 0x9e, 0x8d, 0xc1, 0x7e, 0x9e, 0x63, 0xba, 0xf3, 0xdd, 0xe7,
	0xb7, 0x89, 0xf4, 0x8c, 0xbb, 0xf3, 0x4b, 0x05, 0xed, 0x14, 0xd3, 0xc2, 0x8f, 0x11, 0xb6, 0xa1,
	0xfa, 0x8a, 0x4a, 0x00, 0x1e, 0x09, 0xfa, 0xda, 0xa8, 0xd4, 0xbd, 0x7d, 0xeb, 0xb9, 0x5c, 0x39,
	0xf0, 0x8f, 0x25, 0xf4, 0x3e, 0x89, 0x22, 0x71, 0x03, 0x81, 0x0f, 0x9c, 0xca, 0xa5, 0x59, 0x68,
	0x5f, 0x69, 0xa2, 0xe7, 0x0a, 0x94, 0xeb, 0xb4, 0xcb, 0x47, 0xcd, 0xc1, 0x68, 0xb3, 0x12, 0x9b,
	0xe0, 0xb2, 0x68, 0x9e, 0xaf, 0xb4, 0x2e, 0x8d, 0x94, 0xf7, 0x9e, 0xbd, 0xe5, 0x4d, 0x07, 0x28,
	0x7c, 0x85, 0x9a, 0x42, 0xf9, 0x54, 0x70, 0xa5, 0x25, 0x61, 0x5c, 0x67, 0x35, 0xbf, 0x4f, 0x63,
	0x27, 0x6a, 0xbc, 0x62, 0x7b, 0xbb, 0xa2, 0x70, 0x52, 0xf8, 0xa7, 0x12, 0x6a, 0xe7, 0x19, 0xda,
	0xf1, 0xc9, 0x98, 0x31, 0x70, 0x9d, 0x37, 0xb9, 0x6a, 0xd2, 0x7c, 0x7a, 0xef, 0x34, 0xcf, 0x56,
	0x4a, 0xa6, 0x6b, 0xde, 0x87, 0xf6, 0xa6, 0xb5, 0x5e, 0x55, 0x98, 0x32, 0x9f, 0x04, 0x31, 0xe3,
	0x3e, 0x49, 0x12, 0x29, 0x16, 0x24, 0x32, 0x0f, 0x4b, 0x7d, 0x35, 0x65, 0xa3, 0xd4, 0x39, 0xb2,
	0x3e, 0xfc, 0xe9, 0x5d, 0x4b, 0xa9, 0x90, 0x89, 0x2f, 0x6e, 0x38, 0x04, 0x6e, 0xdd, 0x30, 0xf6,
	0xac, 0x67, 0x2c, 0x64, 0x32, 0x49, 0xed, 0x9d, 0x3f, 0x4b, 0x68, 0xa7, 0x58, 0x0f, 0xfc, 0x15,
	0xaa, 0x09, 0xe5, 0xa7, 0x41, 0x9b, 0x31, 0x68, 0x0e, 0xfa, 0xf7, 0x48, 0x73, 0xa2, 0x5e, 0x2e,
	0x13, 0xf0, 0xaa, 0xc2, 0x7c, 0xe2, 0x43, 0xf4, 0x4e, 0xcc, 0x38, 0x8b, 0xe7, 0xb1, 0xbf, 0x00,
	0xa9, 0xf2, 0x27, 0x66, 0xdb, 0x6b, 0x5a, 0xf3, 0x34, 0xb3, 0xe2, 0x13, 0xd4, 0xca, 0x63, 0x5e,
	0x80, 0x64, 0xd7, 0x0c, 0x02, 0x9f, 0x7e, 0x27, 0x45, 0x0c, 0xbe, 0x50, 0xe6, 0x27, 0xa4, 0xee,
	0xbd, 0x6b, 0x11, 0x53, 0x0b, 0x18, 0x1b, 0xff, 0x44, 0x9d, 0xfe, 0xee, 0xa0, 0x4f, 0xa8, 0x88,
	0x37, 0x6d, 0xff, 0xe9, 0x5e, 0x61, 0x29, 0x2f, 0xd2, 0x27, 0xf9, 0xa2, 0xf4, 0xea, 0x5b, 0x4b,
	0x0e, 0x45, 0x44, 0x78, 0xd8, 0x15, 0x32, 0xec, 0x85, 0xc0, 0xcd, 0x83, 0xdd, 0xcb, 0x5c, 0x24,
	0x61, 0xea, 0xad, 0xff, 0x05, 0x4e, 0xd6, 0xd9, 0x7f, 0x73, 0x2a, 0x2f, 0x46, 0xe3, 0xb3, 0x3f,
	0x9c, 0xc3, 0x17, 0xd9, 0x25, 0x5f, 0xe6, 0x11, 0x66, 0x81, 0x8c, 0x33, 0xf4, 0x99, 0x8d, 0x70,
	0xda, 0xff, 0x2b, 0x47, 0x5e, 0xe5, 0xc8, 0xab, 0x75, 0xc8, 0xab, 0x69, 0xff, 0x6f, 0xe7, 0xe3,
	0x0c, 0x39, 0x1c, 0xe6, 0xd0, 0xe1, 0x70, 0x1d, 0x76, 0x38, 0x9c, 0xf6, 0x67, 0x55, 0x93, 0xcf,
	0x93, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xfb, 0xcf, 0xd0, 0x7f, 0xda, 0x08, 0x00, 0x00,
}
