// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1beta1/finding.proto

package securitycenter

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The state of the finding.
type Finding_State int32

const (
	// Unspecified state.
	Finding_STATE_UNSPECIFIED Finding_State = 0
	// The finding requires attention and has not been addressed yet.
	Finding_ACTIVE Finding_State = 1
	// The finding has been fixed, triaged as a non-issue or otherwise addressed
	// and is no longer active.
	Finding_INACTIVE Finding_State = 2
)

var Finding_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "INACTIVE",
}

var Finding_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"INACTIVE":          2,
}

func (x Finding_State) String() string {
	return proto.EnumName(Finding_State_name, int32(x))
}

func (Finding_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_da6ee7073afacba3, []int{0, 0}
}

// Cloud Security Command Center (Cloud SCC) finding.
//
// A finding is a record of assessment data (security, risk, health or privacy)
// ingested into Cloud SCC for presentation, notification, analysis,
// policy testing, and enforcement. For example, an XSS vulnerability in an
// App Engine application is a finding.
type Finding struct {
	// The relative resource name of this finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/{organization_id}/sources/{source_id}/findings/{finding_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The relative resource name of the source the finding belongs to. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// This field is immutable after creation time.
	// For example:
	// "organizations/{organization_id}/sources/{source_id}"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// For findings on Google Cloud Platform (GCP) resources, the full resource
	// name of the GCP resource this finding is for. See:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	// When the finding is for a non-GCP resource, the resourceName can be a
	// customer or partner defined string.
	// This field is immutable after creation time.
	ResourceName string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The state of the finding.
	State Finding_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.securitycenter.v1beta1.Finding_State" json:"state,omitempty"`
	// The additional taxonomy group within findings from a given source.
	// This field is immutable after creation time.
	// Example: "XSS_FLASH_INJECTION"
	Category string `protobuf:"bytes,5,opt,name=category,proto3" json:"category,omitempty"`
	// The URI that, if available, points to a web page outside of Cloud SCC
	// where additional information about the finding can be found. This field is
	// guaranteed to be either empty or a well formed URL.
	ExternalUri string `protobuf:"bytes,6,opt,name=external_uri,json=externalUri,proto3" json:"external_uri,omitempty"`
	// Source specific properties. These properties are managed by the source
	// that writes the finding. The key names in the source_properties map must be
	// between 1 and 255 characters, and must start with a letter and contain
	// alphanumeric characters or underscores only.
	SourceProperties map[string]*_struct.Value `protobuf:"bytes,7,rep,name=source_properties,json=sourceProperties,proto3" json:"source_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. User specified security marks. These marks are entirely
	// managed by the user and come from the SecurityMarks resource that belongs
	// to the finding.
	SecurityMarks *SecurityMarks `protobuf:"bytes,8,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The time at which the event took place. For example, if the finding
	// represents an open firewall it would capture the time the detector believes
	// the firewall became open. The accuracy is determined by the detector.
	EventTime *timestamp.Timestamp `protobuf:"bytes,9,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// The time at which the finding was created in Cloud SCC.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Finding) Reset()         { *m = Finding{} }
func (m *Finding) String() string { return proto.CompactTextString(m) }
func (*Finding) ProtoMessage()    {}
func (*Finding) Descriptor() ([]byte, []int) {
	return fileDescriptor_da6ee7073afacba3, []int{0}
}

func (m *Finding) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Finding.Unmarshal(m, b)
}
func (m *Finding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Finding.Marshal(b, m, deterministic)
}
func (m *Finding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Finding.Merge(m, src)
}
func (m *Finding) XXX_Size() int {
	return xxx_messageInfo_Finding.Size(m)
}
func (m *Finding) XXX_DiscardUnknown() {
	xxx_messageInfo_Finding.DiscardUnknown(m)
}

var xxx_messageInfo_Finding proto.InternalMessageInfo

func (m *Finding) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Finding) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Finding) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Finding) GetState() Finding_State {
	if m != nil {
		return m.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (m *Finding) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *Finding) GetExternalUri() string {
	if m != nil {
		return m.ExternalUri
	}
	return ""
}

func (m *Finding) GetSourceProperties() map[string]*_struct.Value {
	if m != nil {
		return m.SourceProperties
	}
	return nil
}

func (m *Finding) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *Finding) GetEventTime() *timestamp.Timestamp {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *Finding) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.securitycenter.v1beta1.Finding_State", Finding_State_name, Finding_State_value)
	proto.RegisterType((*Finding)(nil), "google.cloud.securitycenter.v1beta1.Finding")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1beta1.Finding.SourcePropertiesEntry")
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1beta1/finding.proto", fileDescriptor_da6ee7073afacba3)
}

var fileDescriptor_da6ee7073afacba3 = []byte{
	// 594 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xd1, 0x4f, 0x13, 0x4f,
	0x10, 0xfe, 0x1d, 0xa5, 0x05, 0xa6, 0x40, 0xca, 0x26, 0xfc, 0x72, 0x56, 0x13, 0x2a, 0xc4, 0xd8,
	0x07, 0x73, 0x1b, 0xea, 0x0b, 0xc2, 0x8b, 0x05, 0x4b, 0xec, 0x83, 0x04, 0xaf, 0x85, 0x07, 0x4d,
	0x6c, 0xb6, 0xc7, 0x70, 0x6e, 0xb8, 0xdb, 0xbd, 0xec, 0xed, 0x35, 0x56, 0x82, 0x7f, 0x96, 0x7f,
	0x8f, 0xcf, 0xfe, 0x15, 0xe6, 0xf6, 0xf6, 0x10, 0xaa, 0xd1, 0xfa, 0x36, 0xf3, 0xcd, 0x7c, 0xdf,
	0x4e, 0xbf, 0x99, 0x1e, 0xec, 0x86, 0x52, 0x86, 0x11, 0xd2, 0x20, 0x92, 0xd9, 0x05, 0x4d, 0x31,
	0xc8, 0x14, 0xd7, 0xd3, 0x00, 0x85, 0x46, 0x45, 0x27, 0xbb, 0x63, 0xd4, 0x6c, 0x97, 0x5e, 0x72,
	0x71, 0xc1, 0x45, 0xe8, 0x25, 0x4a, 0x6a, 0x49, 0x76, 0x0a, 0x8a, 0x67, 0x28, 0xde, 0x7d, 0x8a,
	0x67, 0x29, 0xcd, 0x2d, 0xab, 0xcb, 0x12, 0x4e, 0x2f, 0x39, 0x46, 0x17, 0xa3, 0x31, 0x7e, 0x64,
	0x13, 0x2e, 0x55, 0xa1, 0xd2, 0x7c, 0x70, 0xa7, 0x41, 0x61, 0x2a, 0x33, 0x15, 0xa0, 0x2d, 0xed,
	0xcd, 0x33, 0x53, 0x09, 0x8f, 0x62, 0xa6, 0xae, 0x52, 0xcb, 0x7c, 0x64, 0x99, 0x26, 0x1b, 0x67,
	0x97, 0x34, 0xd5, 0x2a, 0x0b, 0xb4, 0xad, 0x6e, 0xcd, 0x56, 0x35, 0x8f, 0x31, 0xd5, 0x2c, 0x4e,
	0x66, 0xe8, 0xf9, 0x4c, 0x4c, 0x08, 0xa9, 0x99, 0xe6, 0x52, 0x58, 0xf1, 0xed, 0xaf, 0x35, 0x58,
	0x3a, 0x2e, 0x9c, 0x20, 0x04, 0x16, 0x05, 0x8b, 0xd1, 0x75, 0x5a, 0x4e, 0x7b, 0xc5, 0x37, 0x31,
	0x79, 0x08, 0xb5, 0x84, 0x29, 0x14, 0xda, 0x5d, 0xc8, 0xd1, 0xc3, 0xca, 0xb7, 0x6e, 0xd5, 0xb7,
	0x10, 0xd9, 0x81, 0xb5, 0xf2, 0x57, 0x8e, 0x0c, 0xb3, 0x62, 0x98, 0xab, 0x25, 0x78, 0x92, 0x2b,
	0xbc, 0x86, 0x6a, 0xaa, 0x99, 0x46, 0x77, 0xb1, 0xe5, 0xb4, 0xd7, 0x3b, 0x1d, 0x6f, 0x0e, 0xa7,
	0x3d, 0x3b, 0x92, 0x37, 0xc8, 0x99, 0x7e, 0x21, 0x40, 0x9a, 0xb0, 0x1c, 0x30, 0x8d, 0xa1, 0x54,
	0x53, 0xb7, 0x6a, 0x5e, 0xba, 0xcd, 0xc9, 0x63, 0x58, 0xc5, 0x4f, 0x1a, 0x95, 0x60, 0xd1, 0x28,
	0x53, 0xdc, 0xad, 0x99, 0x7a, 0xbd, 0xc4, 0xce, 0x14, 0x27, 0x12, 0x36, 0xec, 0xac, 0x89, 0x92,
	0x09, 0x2a, 0xcd, 0x31, 0x75, 0x97, 0x5a, 0x95, 0x76, 0xbd, 0x73, 0xf8, 0x6f, 0x43, 0x19, 0x95,
	0xd3, 0x5b, 0x91, 0x9e, 0xd0, 0x6a, 0xea, 0x37, 0xd2, 0x19, 0x98, 0x7c, 0x80, 0xf5, 0xfb, 0x0b,
	0x75, 0x97, 0x5b, 0x4e, 0xbb, 0x3e, 0xa7, 0x05, 0x03, 0x0b, 0xbf, 0xc9, 0x99, 0xb9, 0xef, 0x15,
	0x7f, 0x2d, 0xbd, 0x8b, 0x91, 0x17, 0x00, 0x38, 0x41, 0xa1, 0x47, 0xf9, 0xca, 0xdd, 0x15, 0xa3,
	0xdd, 0x2c, 0xb5, 0xcb, 0x7b, 0xf0, 0x86, 0xe5, 0x3d, 0xf8, 0x2b, 0xa6, 0x3b, 0xcf, 0xc9, 0x01,
	0xd4, 0x03, 0x85, 0x4c, 0x63, 0xc1, 0x85, 0xbf, 0x72, 0xa1, 0x68, 0xcf, 0x81, 0xe6, 0x7b, 0xd8,
	0xfc, 0xad, 0x05, 0xa4, 0x01, 0x95, 0x2b, 0x9c, 0xda, 0xfb, 0xc9, 0x43, 0xf2, 0x0c, 0xaa, 0x13,
	0x16, 0x65, 0x68, 0xae, 0xa7, 0xde, 0xf9, 0xff, 0x97, 0x17, 0xce, 0xf3, 0xaa, 0x5f, 0x34, 0xed,
	0x2f, 0xec, 0x39, 0xdb, 0x7b, 0x50, 0x35, 0x4b, 0x27, 0x9b, 0xb0, 0x31, 0x18, 0x76, 0x87, 0xbd,
	0xd1, 0xd9, 0xc9, 0xe0, 0xb4, 0x77, 0xd4, 0x3f, 0xee, 0xf7, 0x5e, 0x35, 0xfe, 0x23, 0x00, 0xb5,
	0xee, 0xd1, 0xb0, 0x7f, 0xde, 0x6b, 0x38, 0x64, 0x15, 0x96, 0xfb, 0x27, 0x36, 0x5b, 0xd8, 0x8f,
	0xbe, 0x77, 0x39, 0x3c, 0x99, 0x71, 0xb3, 0x78, 0x8f, 0x25, 0x3c, 0xf5, 0x02, 0x19, 0xd3, 0xf2,
	0xd4, 0x5f, 0x4a, 0x15, 0x32, 0xc1, 0x3f, 0x17, 0xff, 0x05, 0x7a, 0x7d, 0x37, 0xbd, 0xa1, 0xc5,
	0x26, 0x53, 0x7a, 0x5d, 0x04, 0x37, 0xe5, 0xb7, 0x22, 0xa5, 0xd7, 0x36, 0xba, 0x39, 0xfc, 0x02,
	0x4f, 0x03, 0x19, 0xcf, 0xb3, 0xc9, 0x53, 0xe7, 0xdd, 0x5b, 0xdb, 0x16, 0xca, 0x88, 0x89, 0xd0,
	0x93, 0x2a, 0xa4, 0x21, 0x0a, 0x63, 0x02, 0xfd, 0x39, 0xe1, 0x1f, 0xbf, 0x0d, 0x07, 0xf7, 0xe1,
	0x71, 0xcd, 0xb0, 0x9f, 0xff, 0x08, 0x00, 0x00, 0xff, 0xff, 0x51, 0x30, 0x40, 0x3f, 0xec, 0x04,
	0x00, 0x00,
}
