How to Use Open vSwitch with KVM
=================================

This document describes how to use Open vSwitch with the Kernel-based
Virtual Machine (KVM). This document assumes that you have read and
followed [INSTALL.md] to get Open vSwitch setup on your Linux system.

Setup
-----

First, follow the setup instructions in [INSTALL.md] to get a working
Open vSwitch installation.

KVM uses tunctl to handle various bridging modes, which you can 
install with the Debian/Ubuntu package uml-utilities.

      % apt-get install uml-utilities

Next, you will need to modify or create custom versions of the qemu-ifup
and qemu-ifdown scripts. In this guide, we'll create custom versions
that make use of example Open vSwitch bridges that we'll describe in this
guide.

Create the following two files and store them in known locations.

For example /etc/ovs-ifup and /etc/ovs-ifdown

/etc/ovs-ifup

```
#!/bin/sh

switch='br0'
/sbin/ifconfig $1 0.0.0.0 up
ovs-vsctl add-port ${switch} $1
```

/etc/ovs-ifdown

```
#!/bin/sh

switch='br0'
/sbin/ifconfig $1 0.0.0.0 down
ovs-vsctl del-port ${switch} $1
```

At the end of [INSTALL.md], it describes basic usage of creating
bridges and ports. If you haven't already, create a bridge named
br0 with the following command:

      % ovs-vsctl add-br br0

Then, add a port to the bridge for the NIC that you want your guests
to communicate over (e.g. eth0):

      % ovs-vsctl add-port br0 eth0

Please refer to ovs-vsctl(8) for more details.

Next, we'll start a guest that will use our ifup and ifdown scripts.

      % kvm -m 512 -net nic,macaddr=00:11:22:EE:EE:EE -net \
        tap,script=/etc/ovs-ifup,downscript=/etc/ovs-ifdown -drive \
        file=/path/to/disk-image,boot=on

This will start the guest and associate a tap device with it. The 
ovs-ifup script will add a port on the br0 bridge so that the
guest will be able to communicate over that bridge.

To get some more information and for debugging you can use Open
vSwitch utilities such as ovs-dpctl and ovs-ofctl, For example:

      % ovs-dpctl show
      % ovs-ofctl show br0

You should see tap devices for each KVM guest added as ports to 
the bridge (e.g. tap0)

Please refer to ovs-dpctl(8) and ovs-ofctl(8) for more details.

Bug Reporting
-------------

Please report problems to bugs@openvswitch.org.

[INSTALL.md]:INSTALL.md
