// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/printsetup.h>
#include <gtkmm/private/printsetup_p.h>


/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

namespace
{
} // anonymous namespace


/* Why reinterpret_cast<PrintSetup*>(gobject) is needed:
 *
 * A PrintSetup instance is in fact always a GtkPrintSetup instance.
 * Unfortunately, GtkPrintSetup cannot be a member of PrintSetup,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because PrintSetup does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gtk::PrintSetup> wrap(GtkPrintSetup* object, bool take_copy)
{
  if(take_copy && object)
    gtk_print_setup_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gtk::PrintSetup>(reinterpret_cast<Gtk::PrintSetup*>(object));
}

} // namespace Glib


namespace Gtk
{

void PrintSetup::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_print_setup_ref(reinterpret_cast<GtkPrintSetup*>(const_cast<PrintSetup*>(this)));
}

void PrintSetup::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gtk_print_setup_unref(reinterpret_cast<GtkPrintSetup*>(const_cast<PrintSetup*>(this)));
}

GtkPrintSetup* PrintSetup::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GtkPrintSetup*>(this);
}

const GtkPrintSetup* PrintSetup::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GtkPrintSetup*>(this);
}

GtkPrintSetup* PrintSetup::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GtkPrintSetup*>(const_cast<PrintSetup*>(this));
  gtk_print_setup_ref(gobject);
  return gobject;
}


Glib::RefPtr<PrintSettings> PrintSetup::get_print_settings()
{
  auto retvalue = Glib::wrap(gtk_print_setup_get_print_settings(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const PrintSettings> PrintSetup::get_print_settings() const
{
  return const_cast<PrintSetup*>(this)->get_print_settings();
}

Glib::RefPtr<PageSetup> PrintSetup::get_page_setup()
{
  auto retvalue = Glib::wrap(gtk_print_setup_get_page_setup(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const PageSetup> PrintSetup::get_page_setup() const
{
  return const_cast<PrintSetup*>(this)->get_page_setup();
}


} // namespace Gtk


