GQuark  bd_nvdimm_error_quark (void) {
        return g_quark_from_static_string ("g-bd-nvdimm-error-quark");
}

/**
 * BDNVDIMMNamespaceInfo:
 * @dev: namespace device name ("namespaceX.Y")
 * @mode: mode of the namespace (BDNVDIMMNamespaceMode)
 * @size: size of the namespace
 * @uuid: UUID of the namespace
 * @sector_size: sector size of the namespace (0 for non-sector namespaces)
 * @blockdev: name of the block device for the namespace
 * @enabled: whether the namespace is enabled or not
 */
/**
 * bd_nvdimm_namespace_info_free: (skip)
 * @info: (nullable): %BDNVDIMMNamespaceInfo to free
 *
 * Frees @info.
 */
void  bd_nvdimm_namespace_info_free (BDNVDIMMNamespaceInfo *info) {
        if (info == NULL)
        return;

    g_free (info->dev);
    g_free (info->uuid);
    g_free (info->blockdev);
    g_free (info);
}

/**
 * bd_nvdimm_namespace_info_copy: (skip)
 * @info: (nullable): %BDNVDIMMNamespaceInfo to copy
 *
 * Creates a new copy of @info.
 */
BDNVDIMMNamespaceInfo* bd_nvdimm_namespace_info_copy (BDNVDIMMNamespaceInfo *info) {
        if (info == NULL)
        return NULL;

    BDNVDIMMNamespaceInfo *new_info = g_new0 (BDNVDIMMNamespaceInfo, 1);

    new_info->dev = info->dev;
    new_info->mode = info->mode;
    new_info->size = info->size;
    new_info->uuid = g_strdup (info->uuid);
    new_info->sector_size = info->sector_size;
    new_info->blockdev = g_strdup (info->blockdev);
    new_info->enabled = info->enabled;

    return new_info;
}

GType  bd_nvdimm_namespace_info_get_type () {
        static GType type = 0;

    if (G_UNLIKELY(type == 0)) {
        type = g_boxed_type_register_static("BDNVDIMMNamespaceInfo",
                                            (GBoxedCopyFunc) bd_nvdimm_namespace_info_copy,
                                            (GBoxedFreeFunc) bd_nvdimm_namespace_info_free);
    }

    return type;
}

static gboolean  bd_nvdimm_is_tech_avail_stub (BDNVDIMMTech tech G_GNUC_UNUSED, guint64 mode G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_is_tech_avail' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_is_tech_avail' called, but not implemented!");
    return FALSE;
}

static gboolean  (*_bd_nvdimm_is_tech_avail) (BDNVDIMMTech tech, guint64 mode, GError **error) = bd_nvdimm_is_tech_avail_stub;

/**
 * bd_nvdimm_is_tech_avail:
 * @tech: the queried tech
 * @mode: a bit mask of queried modes of operation (#BDNVDIMMTechMode) for @tech
 * @error: (out) (optional): place to store error (details about why the @tech-@mode combination is not available)
 *
 * Returns: whether the @tech-@mode combination is available -- supported by the
 *          plugin implementation and having all the runtime dependencies available
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
gboolean  bd_nvdimm_is_tech_avail (BDNVDIMMTech tech, guint64 mode, GError **error) {
    return _bd_nvdimm_is_tech_avail (tech, mode, error);
}


static BDNVDIMMNamespaceMode  bd_nvdimm_namespace_get_mode_from_str_stub (const gchar *mode_str G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_get_mode_from_str' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_get_mode_from_str' called, but not implemented!");
    return 0;
}

static BDNVDIMMNamespaceMode  (*_bd_nvdimm_namespace_get_mode_from_str) (const gchar *mode_str, GError **error) = bd_nvdimm_namespace_get_mode_from_str_stub;

/**
 * bd_nvdimm_namespace_get_mode_from_str:
 * @mode_str: string representation of mode
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: mode matching the @mode_str given or %BD_NVDIMM_NAMESPACE_MODE_UNKNOWN in case of no match
 *
 * Tech category: always available
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
BDNVDIMMNamespaceMode  bd_nvdimm_namespace_get_mode_from_str (const gchar *mode_str, GError **error) {
    return _bd_nvdimm_namespace_get_mode_from_str (mode_str, error);
}


static const gchar* bd_nvdimm_namespace_get_mode_str_stub (BDNVDIMMNamespaceMode mode G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_get_mode_str' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_get_mode_str' called, but not implemented!");
    return NULL;
}

static const gchar* (*_bd_nvdimm_namespace_get_mode_str) (BDNVDIMMNamespaceMode mode, GError **error) = bd_nvdimm_namespace_get_mode_str_stub;

/**
 * bd_nvdimm_namespace_get_mode_str:
 * @mode: mode to get string representation of
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: (transfer none): string representation of @mode or %NULL in case of error
 *
 * Tech category: always available
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
const gchar* bd_nvdimm_namespace_get_mode_str (BDNVDIMMNamespaceMode mode, GError **error) {
    return _bd_nvdimm_namespace_get_mode_str (mode, error);
}


static gchar* bd_nvdimm_namespace_get_devname_stub (const gchar *device G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_get_devname' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_get_devname' called, but not implemented!");
    return NULL;
}

static gchar* (*_bd_nvdimm_namespace_get_devname) (const gchar *device, GError **error) = bd_nvdimm_namespace_get_devname_stub;

/**
 * bd_nvdimm_namespace_get_devname:
 * @device: name or path of a block device (e.g. "/dev/pmem0")
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: (transfer full): namespace device name (e.g. "namespaceX.Y") for @device
 *                           or %NULL if @device is not a NVDIMM namespace
 *                           (@error may be set to indicate error)
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_QUERY
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
gchar* bd_nvdimm_namespace_get_devname (const gchar *device, GError **error) {
    return _bd_nvdimm_namespace_get_devname (device, error);
}


static gboolean  bd_nvdimm_namespace_enable_stub (const gchar *namespace G_GNUC_UNUSED, const BDExtraArg **extra G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_enable' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_enable' called, but not implemented!");
    return FALSE;
}

static gboolean  (*_bd_nvdimm_namespace_enable) (const gchar *namespace, const BDExtraArg **extra, GError **error) = bd_nvdimm_namespace_enable_stub;

/**
 * bd_nvdimm_namespace_enable:
 * @namespace: name of the namespace to enable
 * @extra: (nullable) (array zero-terminated=1): extra options (currently unused)
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: whether the @namespace was successfully enabled or not
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_ACTIVATE_DEACTIVATE
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
gboolean  bd_nvdimm_namespace_enable (const gchar *namespace, const BDExtraArg **extra, GError **error) {
    return _bd_nvdimm_namespace_enable (namespace, extra, error);
}


static gboolean  bd_nvdimm_namespace_disable_stub (const gchar *namespace G_GNUC_UNUSED, const BDExtraArg **extra G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_disable' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_disable' called, but not implemented!");
    return FALSE;
}

static gboolean  (*_bd_nvdimm_namespace_disable) (const gchar *namespace, const BDExtraArg **extra, GError **error) = bd_nvdimm_namespace_disable_stub;

/**
 * bd_nvdimm_namespace_disable:
 * @namespace: name of the namespace to disable
 * @extra: (nullable) (array zero-terminated=1): extra options (currently unused)
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: whether the @namespace was successfully disabled or not
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_ACTIVATE_DEACTIVATE
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
gboolean  bd_nvdimm_namespace_disable (const gchar *namespace, const BDExtraArg **extra, GError **error) {
    return _bd_nvdimm_namespace_disable (namespace, extra, error);
}


static BDNVDIMMNamespaceInfo* bd_nvdimm_namespace_info_stub (const gchar *namespace G_GNUC_UNUSED, const BDExtraArg **extra G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_info' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_info' called, but not implemented!");
    return NULL;
}

static BDNVDIMMNamespaceInfo* (*_bd_nvdimm_namespace_info) (const gchar *namespace, const BDExtraArg **extra, GError **error) = bd_nvdimm_namespace_info_stub;

/**
 * bd_nvdimm_namespace_info:
 * @namespace: namespace to get information about
 * @extra: (nullable) (array zero-terminated=1): extra options (currently unused)
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: (transfer full): information about given namespace or %NULL if no such
 *                           namespace was found (@error may be set to indicate error)
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_QUERY
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
BDNVDIMMNamespaceInfo* bd_nvdimm_namespace_info (const gchar *namespace, const BDExtraArg **extra, GError **error) {
    return _bd_nvdimm_namespace_info (namespace, extra, error);
}


static BDNVDIMMNamespaceInfo** bd_nvdimm_list_namespaces_stub (const gchar *bus G_GNUC_UNUSED, const gchar *region G_GNUC_UNUSED, gboolean idle G_GNUC_UNUSED, const BDExtraArg **extra G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_list_namespaces' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_list_namespaces' called, but not implemented!");
    return NULL;
}

static BDNVDIMMNamespaceInfo** (*_bd_nvdimm_list_namespaces) (const gchar *bus, const gchar *region, gboolean idle, const BDExtraArg **extra, GError **error) = bd_nvdimm_list_namespaces_stub;

/**
 * bd_nvdimm_list_namespaces:
 * @bus: (nullable): return only namespaces on given bus (specified by name),
 *                     %NULL may be specified to return namespaces from all buses
 * @region: (nullable): return only namespaces on given region (specified by regionX name or region id),
 *                        %NULL may be specified to return namespaces from all regions
 * @idle: whether to list idle (not enabled) namespaces too
 * @extra: (nullable) (array zero-terminated=1): extra options for the creation (right now
 *                                                 passed to the 'ndctl' utility)
 * @error: (out) (optional): place to store error (if any)
 *
 * Returns: (array zero-terminated=1): information about the namespaces on @bus and @region or
 *                                     %NULL if no namespaces were found (@error may be set to indicate error)
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_QUERY
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
BDNVDIMMNamespaceInfo** bd_nvdimm_list_namespaces (const gchar *bus, const gchar *region, gboolean idle, const BDExtraArg **extra, GError **error) {
    return _bd_nvdimm_list_namespaces (bus, region, idle, extra, error);
}


static gboolean  bd_nvdimm_namespace_reconfigure_stub (const gchar* namespace G_GNUC_UNUSED, BDNVDIMMNamespaceMode mode G_GNUC_UNUSED, gboolean force G_GNUC_UNUSED, const BDExtraArg **extra G_GNUC_UNUSED, GError** error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_reconfigure' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_reconfigure' called, but not implemented!");
    return FALSE;
}

static gboolean  (*_bd_nvdimm_namespace_reconfigure) (const gchar* namespace, BDNVDIMMNamespaceMode mode, gboolean force, const BDExtraArg **extra, GError** error) = bd_nvdimm_namespace_reconfigure_stub;

/**
 * bd_nvdimm_namespace_reconfigure:
 * @namespace: name of the namespace to reconfigure
 * @mode: mode type to set (memory/sector/raw/dax)
 * @force: whether to use force to reconfigure an active namespace
 * @error: (out) (optional): place to store error if any
 * @extra: (nullable) (array zero-terminated=1): extra options for the creation (right now
 *                                                 passed to the 'ndctl' utility)
 *
 * Returns: whether @namespace was successfully reconfigured or not
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
gboolean  bd_nvdimm_namespace_reconfigure (const gchar* namespace, BDNVDIMMNamespaceMode mode, gboolean force, const BDExtraArg **extra, GError** error) {
    return _bd_nvdimm_namespace_reconfigure (namespace, mode, force, extra, error);
}


static const guint64 * bd_nvdimm_namespace_get_supported_sector_sizes_stub (BDNVDIMMNamespaceMode mode G_GNUC_UNUSED, GError **error) {
    bd_utils_log_format (BD_UTILS_LOG_CRIT, "The function 'bd_nvdimm_namespace_get_supported_sector_sizes' called, but not implemented!");
    g_set_error (error, BD_INIT_ERROR, BD_INIT_ERROR_NOT_IMPLEMENTED,
                "The function 'bd_nvdimm_namespace_get_supported_sector_sizes' called, but not implemented!");
    return 0;
}

static const guint64 * (*_bd_nvdimm_namespace_get_supported_sector_sizes) (BDNVDIMMNamespaceMode mode, GError **error) = bd_nvdimm_namespace_get_supported_sector_sizes_stub;

/**
 * bd_nvdimm_namespace_get_supported_sector_sizes:
 * @mode: namespace mode
 * @error: (out) (optional): place to store error if any
 *
 * Returns: (transfer none) (array zero-terminated=1): list of supported sector sizes for @mode
 *
 * Tech category: %BD_NVDIMM_TECH_NAMESPACE-%BD_NVDIMM_TECH_MODE_QUERY
 *
 * Deprecated: 3.1: NVDIMM plugin will be removed in the next major release
 */
const guint64 * bd_nvdimm_namespace_get_supported_sector_sizes (BDNVDIMMNamespaceMode mode, GError **error) {
    return _bd_nvdimm_namespace_get_supported_sector_sizes (mode, error);
}


static gpointer load_nvdimm_from_plugin(const gchar *so_name) {
    void *handle = NULL;
    char *error = NULL;
    gboolean (*init_fn) (void) = NULL;

    handle = dlopen(so_name, RTLD_LAZY);
    if (!handle) {
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load module nvdimm: %s", dlerror());
        return NULL;
    }

    dlerror();
    * (void**) (&init_fn) = dlsym(handle, "bd_nvdimm_init");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_DEBUG, "failed to load the init() function for nvdimm: %s", error);
    /* coverity[dead_error_condition] */
    if (init_fn && !init_fn()) {
        dlclose(handle);
        return NULL;
    }
    init_fn = NULL;

    dlerror();
    * (void**) (&_bd_nvdimm_is_tech_avail) = dlsym(handle, "bd_nvdimm_is_tech_avail");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_is_tech_avail: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_get_mode_from_str) = dlsym(handle, "bd_nvdimm_namespace_get_mode_from_str");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_get_mode_from_str: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_get_mode_str) = dlsym(handle, "bd_nvdimm_namespace_get_mode_str");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_get_mode_str: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_get_devname) = dlsym(handle, "bd_nvdimm_namespace_get_devname");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_get_devname: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_enable) = dlsym(handle, "bd_nvdimm_namespace_enable");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_enable: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_disable) = dlsym(handle, "bd_nvdimm_namespace_disable");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_disable: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_info) = dlsym(handle, "bd_nvdimm_namespace_info");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_info: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_list_namespaces) = dlsym(handle, "bd_nvdimm_list_namespaces");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_list_namespaces: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_reconfigure) = dlsym(handle, "bd_nvdimm_namespace_reconfigure");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_reconfigure: %s", error);

    dlerror();
    * (void**) (&_bd_nvdimm_namespace_get_supported_sector_sizes) = dlsym(handle, "bd_nvdimm_namespace_get_supported_sector_sizes");
    if ((error = dlerror()) != NULL)
        bd_utils_log_format (BD_UTILS_LOG_WARNING, "failed to load bd_nvdimm_namespace_get_supported_sector_sizes: %s", error);

    return handle;
}

static gboolean unload_nvdimm (gpointer handle) {
    char *error = NULL;
    gboolean (*close_fn) (void) = NULL;

    _bd_nvdimm_is_tech_avail = bd_nvdimm_is_tech_avail_stub;
    _bd_nvdimm_namespace_get_mode_from_str = bd_nvdimm_namespace_get_mode_from_str_stub;
    _bd_nvdimm_namespace_get_mode_str = bd_nvdimm_namespace_get_mode_str_stub;
    _bd_nvdimm_namespace_get_devname = bd_nvdimm_namespace_get_devname_stub;
    _bd_nvdimm_namespace_enable = bd_nvdimm_namespace_enable_stub;
    _bd_nvdimm_namespace_disable = bd_nvdimm_namespace_disable_stub;
    _bd_nvdimm_namespace_info = bd_nvdimm_namespace_info_stub;
    _bd_nvdimm_list_namespaces = bd_nvdimm_list_namespaces_stub;
    _bd_nvdimm_namespace_reconfigure = bd_nvdimm_namespace_reconfigure_stub;
    _bd_nvdimm_namespace_get_supported_sector_sizes = bd_nvdimm_namespace_get_supported_sector_sizes_stub;

    dlerror();
    * (void**) (&close_fn) = dlsym(handle, "bd_nvdimm_close");
    if (((error = dlerror()) != NULL) || !close_fn)
        bd_utils_log_format (BD_UTILS_LOG_DEBUG, "failed to load the close_plugin() function for nvdimm: %s", error);
    /* coverity[dead_error_condition] */
    if (close_fn) {
        close_fn();
    }

    return dlclose(handle) == 0;
}

