/*
 * (C) Copyright 2002, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * @file XMLNode.hpp
 * @version @$Id: XMLNode.hpp,v 1.9.2.1 2003/04/22 15:24:39 spabsurd Exp $
 * @author Schlund + Partner AG
 * @brief *ps*
 *
 * (C) Copyright by Schlund+Partner AG
 *
 * Synopsis: @#include <sp-gxmlcpp/XMLNode.hpp>
 *
 */

#ifndef SP_GXML_XMLNODE_HPP
#define SP_GXML_XMLNODE_HPP

// STDC++
#include <string>

// C libraries
#include <libxslt/xsltInternals.h>
#include <libxml/xpath.h>
#include <libxml/tree.h>

namespace SP {
namespace GXML {

class XMLNode
{
public:
	XMLNode();
	XMLNode( const xmlNodePtr node );
	~XMLNode();

	enum Exceptions
	{
		NO_NODE=1,        // NodePtr is NULL
		LAST_NODE,        // node has no following sibling
		FIRST_NODE,       // node has no preceding sibling
		DOC_NODE,         // node is document node (has no parent)
		NO_CHILD,         // node has no children
		NO_CONTENT,       // node has no content (no child text-node)
		NO_ATTRIBUTES,    // node has no attributes
		NO_VALUE          // attribute has no value (should never happen)
	};
	// XMLTree getDoc(); makes no sense till there is a doc-object
	////////////////////////////////////////////////////////////////////////
	// hint:
	// EVERY group of spcaes or characters is contained within a invisible
	// text-node.
	// i.e. <node/>  <node/> expands to <node/><text>  </text><node/>
	// return next node in order (every space between tags is a text node!)
	// throws LAST_NODE if no following sibling exists
	XMLNode getNext();
	// return previous node in order
	// throws FIRST_NODE if no preceding sibling exists
	XMLNode getPrev();
	// return parent of current node
	// throws DOC_NODE if no parent exists
	XMLNode getParent();
	// return first child of node (text-node if node has content)
	// throws
	XMLNode getChild();
	// return last child of node
	XMLNode getLast();

	// return node type (i.e. XML_ELEMENT_NODE, XML_ATTRIBUTE_NODE,
	// XML_TEXT_NODE, ... )
	int getType();
	// return name of node-tag
	std::string getName();
	// return content of node (which is the content of the first child text-node)
	std::string getContent();
	// return attribute value by name
	std::string getAttribute( const std::string& name );
	// XMLAttributeSet getAttributeSet( XMLNode* node );

	// returns XML subtree of node
	std::string getNodeDump();

	xmlNodePtr getNodePtr();

private:
	xmlNodePtr node_;
};

}}
#endif
