% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.r
\name{lims}
\alias{lims}
\alias{xlim}
\alias{ylim}
\title{Convenience functions to set the axis limits.}
\usage{
lims(...)

xlim(...)

ylim(...)
}
\arguments{
\item{...}{If numeric, will create a continuous scale, if factor or
character, will create a discrete scale.  For \code{lims}, every
argument must be named.}
}
\description{
Observations not in this range will be dropped completely and
not passed to any other layers.  If a NA value is substituted for one of the
limits that limit is automatically calculated.
}
\examples{
# xlim
xlim(15, 20)
xlim(20, 15)
xlim(c(10, 20))
xlim("a", "b", "c")

ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  xlim(15, 20)
# with automatic lower limit
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  xlim(NA, 20)

# Change both xlim and ylim
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  lims(x = c(10, 20), y = c(3, 5))
}
\seealso{
For changing x or y axis limits \strong{without} dropping data
  observations, see \code{\link{coord_cartesian}}.
}

