% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-bar.r, R/stat-count.r
\name{geom_bar}
\alias{geom_bar}
\alias{stat_count}
\title{Bars, rectangles with bases on x-axis}
\usage{
geom_bar(mapping = NULL, data = NULL, stat = "count",
  position = "stack", width = NULL, binwidth = NULL, ..., na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)

stat_count(mapping = NULL, data = NULL, geom = "bar",
  position = "stack", width = NULL, ..., na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}

\item{binwidth}{\code{geom_bar} no longer has a binwidth argument - if
you use it you'll get an warning telling to you use
\code{\link{geom_histogram}} instead.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{geom, stat}{Override the default connection between \code{geom_bar} and
\code{stat_count}.}
}
\description{
There are two types of bar charts, determined by what is mapped to bar
height. By default, \code{geom_bar} uses \code{stat="count"} which makes the
height of the bar proportion to the number of cases in each group (or if the
\code{weight} aethetic is supplied, the sum of the weights). If you want the
heights of the bars to represent values in the data, use
\code{stat="identity"} and map a variable to the \code{y} aesthetic.

\code{stat_count} counts the number of cases at each x position. If you want
to bin the data in ranges, you should use \code{\link{stat_bin}} instead.
}
\details{
A bar chart maps the height of the bar to a variable, and so the base of the
bar must always be shown to produce a valid visual comparison. Naomi Robbins
has a nice
\href{http://www.b-eye-network.com/view/index.php?cid=2468}{article on this
topic}. This is why it doesn't make sense to use a log-scaled y axis with a
bar chart.

By default, multiple x's occurring in the same place will be stacked atop one
another by \code{\link{position_stack}}. If you want them to be dodged
side-to-side, see \code{\link{position_dodge}}. Finally,
\code{\link{position_fill}} shows relative proportions at each x by stacking
the bars and then stretching or squashing to the same height.
}
\section{Aesthetics}{

  \Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "bar")}
}

\section{Computed variables}{

\describe{
  \item{count}{number of points in bin}
  \item{prop}{groupwise proportion}
}
}
\examples{
# geom_bar is designed to make it easy to create bar charts that show
# counts (or sums of weights)
g <- ggplot(mpg, aes(class))
# Number of cars in each class:
g + geom_bar()
# Total engine displacement of each class
g + geom_bar(aes(weight = displ))

# To show (e.g.) means, you need stat = "identity"
df <- data.frame(trt = c("a", "b", "c"), outcome = c(2.3, 1.9, 3.2))
ggplot(df, aes(trt, outcome)) +
  geom_bar(stat = "identity")
# But geom_point() display exactly the same information and doesn't
# require the y-axis to touch zero.
ggplot(df, aes(trt, outcome)) +
  geom_point()

# You can also use geom_bar() with continuous data, in which case
# it will show counts at unique locations
df <- data.frame(x = rep(c(2.9, 3.1, 4.5), c(5, 10, 4)))
ggplot(df, aes(x)) + geom_bar()
# cf. a histogram of the same data
ggplot(df, aes(x)) + geom_histogram(binwidth = 0.5)

\donttest{
# Bar charts are automatically stacked when multiple bars are placed
# at the same location
g + geom_bar(aes(fill = drv))

# You can instead dodge, or fill them
g + geom_bar(aes(fill = drv), position = "dodge")
g + geom_bar(aes(fill = drv), position = "fill")

# To change plot order of bars, change levels in underlying factor
reorder_size <- function(x) {
  factor(x, levels = names(sort(table(x))))
}
ggplot(mpg, aes(reorder_size(class))) + geom_bar()
}
}
\seealso{
\code{\link{geom_histogram}} for continuous data,
  \code{\link{position_dodge}} for creating side-by-side barcharts.

\code{\link{stat_bin}}, which bins data in ranges and counts the
  cases in each range. It differs from \code{stat_count}, which counts the
  number of cases at each x position (without binning into ranges).
  \code{\link{stat_bin}} requires continuous x data, whereas
  \code{stat_count} can be used for both discrete and continuous x data.
}

