# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._default_accounts_operations import build_get_request, build_remove_request, build_set_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DefaultAccountsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.purview.aio.PurviewManagementClient`'s
        :attr:`default_accounts` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self,
        scope_tenant_id: str,
        scope_type: Union[str, _models.ScopeType],
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> _models.DefaultAccountPayload:
        """Gets the default account information set for the scope.

        Get the default account for the scope.

        :param scope_tenant_id: The tenant ID. Required.
        :type scope_tenant_id: str
        :param scope_type: The scope for the default account. Known values are: "Tenant" and
         "Subscription". Required.
        :type scope_type: str or ~azure.mgmt.purview.models.ScopeType
        :param scope: The Id of the scope object, for example if the scope is "Subscription" then it is
         the ID of that subscription. Default value is None.
        :type scope: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefaultAccountPayload or the result of cls(response)
        :rtype: ~azure.mgmt.purview.models.DefaultAccountPayload
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-07-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DefaultAccountPayload]

        request = build_get_request(
            scope_tenant_id=scope_tenant_id,
            scope_type=scope_type,
            scope=scope,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseModel, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DefaultAccountPayload", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/providers/Microsoft.Purview/getDefaultAccount"}  # type: ignore

    @overload
    async def set(
        self,
        default_account_payload: _models.DefaultAccountPayload,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DefaultAccountPayload:
        """Sets the default account for the scope.

        Sets the default account for the scope.

        :param default_account_payload: The payload containing the default account information and the
         scope. Required.
        :type default_account_payload: ~azure.mgmt.purview.models.DefaultAccountPayload
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefaultAccountPayload or the result of cls(response)
        :rtype: ~azure.mgmt.purview.models.DefaultAccountPayload
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set(
        self, default_account_payload: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DefaultAccountPayload:
        """Sets the default account for the scope.

        Sets the default account for the scope.

        :param default_account_payload: The payload containing the default account information and the
         scope. Required.
        :type default_account_payload: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefaultAccountPayload or the result of cls(response)
        :rtype: ~azure.mgmt.purview.models.DefaultAccountPayload
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set(
        self, default_account_payload: Union[_models.DefaultAccountPayload, IO], **kwargs: Any
    ) -> _models.DefaultAccountPayload:
        """Sets the default account for the scope.

        Sets the default account for the scope.

        :param default_account_payload: The payload containing the default account information and the
         scope. Is either a model type or a IO type. Required.
        :type default_account_payload: ~azure.mgmt.purview.models.DefaultAccountPayload or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DefaultAccountPayload or the result of cls(response)
        :rtype: ~azure.mgmt.purview.models.DefaultAccountPayload
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-07-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.DefaultAccountPayload]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(default_account_payload, (IO, bytes)):
            _content = default_account_payload
        else:
            _json = self._serialize.body(default_account_payload, "DefaultAccountPayload")

        request = build_set_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.set.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseModel, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DefaultAccountPayload", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    set.metadata = {"url": "/providers/Microsoft.Purview/setDefaultAccount"}  # type: ignore

    @distributed_trace_async
    async def remove(  # pylint: disable=inconsistent-return-statements
        self,
        scope_tenant_id: str,
        scope_type: Union[str, _models.ScopeType],
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Removes the default account from the scope.

        Removes the default account from the scope.

        :param scope_tenant_id: The tenant ID. Required.
        :type scope_tenant_id: str
        :param scope_type: The scope for the default account. Known values are: "Tenant" and
         "Subscription". Required.
        :type scope_type: str or ~azure.mgmt.purview.models.ScopeType
        :param scope: The Id of the scope object, for example if the scope is "Subscription" then it is
         the ID of that subscription. Default value is None.
        :type scope: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-07-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_remove_request(
            scope_tenant_id=scope_tenant_id,
            scope_type=scope_type,
            scope=scope,
            api_version=api_version,
            template_url=self.remove.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseModel, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    remove.metadata = {"url": "/providers/Microsoft.Purview/removeDefaultAccount"}  # type: ignore
