/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.io.Reader;
import java.io.Writer;

/**
 * This interfaces defines how an XmlRpcServer should handle reading
 * the method name from a socket and invoking it with a ParamIterator.
 * Register handlers to make it do something useful.  The implementation
 * should be thread-safe, meaning that multiple threads can call any
 * method and not create a race-condition.
 */
public interface XmlRpcServer {

	/**
	 * This constant is used to register a default handler.  A handler,
	 * if registered under this name, should handle all requests that do
	 * not have a known method name.  It is of course optional that a
	 * implementing class use this constant.
	 */
	String DEFAULT_HANDLER = "";

	/** 
	 * Register a handler object with this name. 
	 * Methods of this object will be callable over Xml-Rpc as
	 * <code>handlername.methodname</code>. 
	 * Use the Invoker adapter to register a generic object.
	 * @see Invoker
	 * @param handlerName handler name that will invoke this handler
	 * @param handler object which will handle the requests
	 */
	void addHandler(String handlerName, XmlRpcHandler handler);

	/**
	 * Remove a handler object that was previously registered with this
	 * server.
	 * @param handlerName registered handler to remove 
	 */
	void removeHandler(String handlerName);

	/**
	 * From your servlet, or other locality, call this method to handle
	 * an Xml-Rpc request.  The input and output streams should 
	 * buffer data sent and received for better performance.
	 * The streams do not need to be closed after this method is called.
	 *
	 * @throws XmlRpcException if sort of exceptional condition occured
	 * @throws NoHandlerException if no appropriate handler is available
	 * @param in input stream
	 * @param out output stream
	 */
	void accept(Reader in, Writer out) 
		throws XmlRpcException;
	
}  // XmlRpcServer
