/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

/**
 * This is thrown on various errors.  This exception may contain a
 * wrapped Throwable object.
 * <p>
 * @author Elias Ross
 * @version 1.0
 */
public class XmlRpcException 
	extends Exception 
{

	private static final long serialVersionUID = 3881836903351454422L;

	/**
	 * The fault code of the exception. For servers based on this
	 * library, this will always be 0.  (If there are predefined error
	 * codes, they should be in the Xml-Rpc spec.)
	 */
	int code;

	/**
	 * Root cause.
	 */
	Throwable cause;
	
	/**
	 * Construct an XmlRpcException with a message.
	 * @param message message to display.
	 */
	public XmlRpcException(String message) 
	{
		super(message);
		this.code = 0;
	}

	/**
	 * Construct an XmlRpcException with a message and code and wrapped
	 * Throwable.
	 * @param message message to display.
	 * @param code this should be zero, unless a standard code was assigned
	 * @param cause reason for this XmlRpcException
	 */
	public XmlRpcException(int code, String message, Throwable cause) 
	{
		super(message, cause);
		this.code = code;
	}

	/**
	 * Gets the code of this exception, if any.
	 * @return code
	 */
	public int getCode() { 
		return code; 
	}
}
