/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;

/**
 * This class is for unit testing HttpVersionImpl.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class HttpVersionTest
	extends junit.framework.TestCase
{
	public HttpVersionTest(String name) {
		super(name);
	}

  /*
	public static junit.framework.TestSuite suite() {
		return new org.hansel.CoverageDecorator(HttpVersionTest.class,
			new Class[] { HttpVersionImpl.class });
	} 
  */

	public static void main(String[] args) {
		junit.textui.TestRunner.run(HttpVersionTest.class);
	}

	public void testBad()
		throws IOException
	{
    try {
      new HttpVersion(null);
      fail("null argument");
    } catch (IllegalArgumentException e) {
    }
    try {
      new HttpVersion("blah");
      fail("invalid prefix");
    } catch (HttpException e) {
    }
    try {
      new HttpVersion("HTTP/1");
      fail("invalid number");
    } catch (HttpException e) {
    }
    try {
      new HttpVersion("HTTP/A.B");
      fail("invalid integer");
    } catch (HttpException e) {
    }
  }

	public void testVersion()
		throws IOException
	{
    String h11 = "HTTP/1.1";
    String h12 = "HTTP/1.2";
    assertEquals(new HttpVersion(h11), HttpVersion.HTTP11);
    assertEquals(h11, new HttpVersion(h11).toString());
    assertEquals(h12, new HttpVersion(h12).toString());

    assertEquals(new HttpVersion("HTTP/1.0"), HttpVersion.HTTP10);
    assertEquals(new HttpVersion(h12), new HttpVersion(1, 2));
    HttpVersion v = HttpVersion.HTTP11;
    assertEquals(v.hashCode(), new HttpVersion(1,1).hashCode());
	}


}
