/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/**
 * Basic (mostly dummy) implementation of HTTP session.
 * 
 * @author Elias Ross
 */
@SuppressWarnings("deprecation")
public class BasicHttpSession implements HttpSession {
	
	private Map<String, Object> attributes = new HashMap<String, Object>();
	private Map<String, Object> values = new HashMap<String, Object>();
	private long time = System.currentTimeMillis();
	private String id = Long.toHexString(time);
	private int inactiveInterval = 0;

	/**
	 * Returns attribute value by name.
	 */
	public Object getAttribute(String name) {
		return attributes.get(name);
	}

	/**
	 * Returns attribute enumeration.
	 */
	public Enumeration<String> getAttributeNames() {
		return Collections.enumeration(attributes.keySet());
	}

	/**
	 * Returns time this object was created.
	 */
	public long getCreationTime() {
		return time;
	}

	/**
	 * Returns ID based on timestamp.
	 */
	public String getId() {
		return id;
	}

	/**
	 * Returns zero.
	 */
	public long getLastAccessedTime() {
		return 0;
	}

	/**
	 * Returns zero.
	 */
	public int getMaxInactiveInterval() {
		return inactiveInterval;
	}

	/**
	 * Returns null.
	 */
	public ServletContext getServletContext() {
		return null;
	}

	/**
	 * Returns null.
	 */
	public HttpSessionContext getSessionContext() {
		return null;
	}

	/**
	 * Returns the value of the attribute.
	 */
	public Object getValue(String name) {
		return values.get(name);
	}

	/**
	 * Returns the value names.
	 */
	public String[] getValueNames() {
		return values.keySet().toArray(new String[0]);
	}

	/**
	 * Clears attributes.
	 */
	public void invalidate() {
		attributes.clear();
	}

	/**
	 * Returns true.
	 */
	public boolean isNew() {
		return true;
	}

	/**
	 * Puts the value.
	 */
	public void putValue(String name, Object value) {
		values.put(name, value);
	}

	/**
	 * Removes an attribute by name.
	 */
	public void removeAttribute(String name) {
		attributes.remove(name);
	}

	/**
	 * Removes a value by name.
	 */
	public void removeValue(String name) {
		values.remove(name);
	}

	/**
	 * Sets an attribute.
	 */
	public void setAttribute(String name, Object arg1) {
		attributes.put(name, arg1);
	}

	/**
	 * Sets inactive interval.
	 */
	public void setMaxInactiveInterval(int arg0) {
		this.inactiveInterval = arg0;
	}

}
