/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

class TokenUtil
{
	private static final char separators[] = {
		'(' , ')' , '<' , '>' , 
		'@', ',' , ';' , ':' , '\\' , 
		'<', '>', '/' , '[' , ']' , 
		'?' , '=', '{' , '}' , ' ' , '\t'
	};

	public static final boolean isTokenChar(char c) {
		if (c < 31 || c == 127)
			return false;
		for (int i = 0; i < separators.length; i++)
			if (c == separators[i])
				return false;
		return true;
	}

	public static boolean isValidToken(String s) {
		for (int i = 0; i < s.length(); i++)
			if (!isTokenChar(s.charAt(i)))
				return false;
		return true;
	}
}
