// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appintegrationsserviceiface provides an interface to enable mocking the Amazon AppIntegrations Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appintegrationsserviceiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/appintegrationsservice"
)

// AppIntegrationsServiceAPI provides an interface to enable mocking the
// appintegrationsservice.AppIntegrationsService service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon AppIntegrations Service.
//	func myFunc(svc appintegrationsserviceiface.AppIntegrationsServiceAPI) bool {
//	    // Make svc.CreateApplication request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := appintegrationsservice.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockAppIntegrationsServiceClient struct {
//	    appintegrationsserviceiface.AppIntegrationsServiceAPI
//	}
//	func (m *mockAppIntegrationsServiceClient) CreateApplication(input *appintegrationsservice.CreateApplicationInput) (*appintegrationsservice.CreateApplicationOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockAppIntegrationsServiceClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppIntegrationsServiceAPI interface {
	CreateApplication(*appintegrationsservice.CreateApplicationInput) (*appintegrationsservice.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *appintegrationsservice.CreateApplicationInput, ...request.Option) (*appintegrationsservice.CreateApplicationOutput, error)
	CreateApplicationRequest(*appintegrationsservice.CreateApplicationInput) (*request.Request, *appintegrationsservice.CreateApplicationOutput)

	CreateDataIntegration(*appintegrationsservice.CreateDataIntegrationInput) (*appintegrationsservice.CreateDataIntegrationOutput, error)
	CreateDataIntegrationWithContext(aws.Context, *appintegrationsservice.CreateDataIntegrationInput, ...request.Option) (*appintegrationsservice.CreateDataIntegrationOutput, error)
	CreateDataIntegrationRequest(*appintegrationsservice.CreateDataIntegrationInput) (*request.Request, *appintegrationsservice.CreateDataIntegrationOutput)

	CreateEventIntegration(*appintegrationsservice.CreateEventIntegrationInput) (*appintegrationsservice.CreateEventIntegrationOutput, error)
	CreateEventIntegrationWithContext(aws.Context, *appintegrationsservice.CreateEventIntegrationInput, ...request.Option) (*appintegrationsservice.CreateEventIntegrationOutput, error)
	CreateEventIntegrationRequest(*appintegrationsservice.CreateEventIntegrationInput) (*request.Request, *appintegrationsservice.CreateEventIntegrationOutput)

	DeleteDataIntegration(*appintegrationsservice.DeleteDataIntegrationInput) (*appintegrationsservice.DeleteDataIntegrationOutput, error)
	DeleteDataIntegrationWithContext(aws.Context, *appintegrationsservice.DeleteDataIntegrationInput, ...request.Option) (*appintegrationsservice.DeleteDataIntegrationOutput, error)
	DeleteDataIntegrationRequest(*appintegrationsservice.DeleteDataIntegrationInput) (*request.Request, *appintegrationsservice.DeleteDataIntegrationOutput)

	DeleteEventIntegration(*appintegrationsservice.DeleteEventIntegrationInput) (*appintegrationsservice.DeleteEventIntegrationOutput, error)
	DeleteEventIntegrationWithContext(aws.Context, *appintegrationsservice.DeleteEventIntegrationInput, ...request.Option) (*appintegrationsservice.DeleteEventIntegrationOutput, error)
	DeleteEventIntegrationRequest(*appintegrationsservice.DeleteEventIntegrationInput) (*request.Request, *appintegrationsservice.DeleteEventIntegrationOutput)

	GetApplication(*appintegrationsservice.GetApplicationInput) (*appintegrationsservice.GetApplicationOutput, error)
	GetApplicationWithContext(aws.Context, *appintegrationsservice.GetApplicationInput, ...request.Option) (*appintegrationsservice.GetApplicationOutput, error)
	GetApplicationRequest(*appintegrationsservice.GetApplicationInput) (*request.Request, *appintegrationsservice.GetApplicationOutput)

	GetDataIntegration(*appintegrationsservice.GetDataIntegrationInput) (*appintegrationsservice.GetDataIntegrationOutput, error)
	GetDataIntegrationWithContext(aws.Context, *appintegrationsservice.GetDataIntegrationInput, ...request.Option) (*appintegrationsservice.GetDataIntegrationOutput, error)
	GetDataIntegrationRequest(*appintegrationsservice.GetDataIntegrationInput) (*request.Request, *appintegrationsservice.GetDataIntegrationOutput)

	GetEventIntegration(*appintegrationsservice.GetEventIntegrationInput) (*appintegrationsservice.GetEventIntegrationOutput, error)
	GetEventIntegrationWithContext(aws.Context, *appintegrationsservice.GetEventIntegrationInput, ...request.Option) (*appintegrationsservice.GetEventIntegrationOutput, error)
	GetEventIntegrationRequest(*appintegrationsservice.GetEventIntegrationInput) (*request.Request, *appintegrationsservice.GetEventIntegrationOutput)

	ListApplications(*appintegrationsservice.ListApplicationsInput) (*appintegrationsservice.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *appintegrationsservice.ListApplicationsInput, ...request.Option) (*appintegrationsservice.ListApplicationsOutput, error)
	ListApplicationsRequest(*appintegrationsservice.ListApplicationsInput) (*request.Request, *appintegrationsservice.ListApplicationsOutput)

	ListApplicationsPages(*appintegrationsservice.ListApplicationsInput, func(*appintegrationsservice.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *appintegrationsservice.ListApplicationsInput, func(*appintegrationsservice.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListDataIntegrationAssociations(*appintegrationsservice.ListDataIntegrationAssociationsInput) (*appintegrationsservice.ListDataIntegrationAssociationsOutput, error)
	ListDataIntegrationAssociationsWithContext(aws.Context, *appintegrationsservice.ListDataIntegrationAssociationsInput, ...request.Option) (*appintegrationsservice.ListDataIntegrationAssociationsOutput, error)
	ListDataIntegrationAssociationsRequest(*appintegrationsservice.ListDataIntegrationAssociationsInput) (*request.Request, *appintegrationsservice.ListDataIntegrationAssociationsOutput)

	ListDataIntegrationAssociationsPages(*appintegrationsservice.ListDataIntegrationAssociationsInput, func(*appintegrationsservice.ListDataIntegrationAssociationsOutput, bool) bool) error
	ListDataIntegrationAssociationsPagesWithContext(aws.Context, *appintegrationsservice.ListDataIntegrationAssociationsInput, func(*appintegrationsservice.ListDataIntegrationAssociationsOutput, bool) bool, ...request.Option) error

	ListDataIntegrations(*appintegrationsservice.ListDataIntegrationsInput) (*appintegrationsservice.ListDataIntegrationsOutput, error)
	ListDataIntegrationsWithContext(aws.Context, *appintegrationsservice.ListDataIntegrationsInput, ...request.Option) (*appintegrationsservice.ListDataIntegrationsOutput, error)
	ListDataIntegrationsRequest(*appintegrationsservice.ListDataIntegrationsInput) (*request.Request, *appintegrationsservice.ListDataIntegrationsOutput)

	ListDataIntegrationsPages(*appintegrationsservice.ListDataIntegrationsInput, func(*appintegrationsservice.ListDataIntegrationsOutput, bool) bool) error
	ListDataIntegrationsPagesWithContext(aws.Context, *appintegrationsservice.ListDataIntegrationsInput, func(*appintegrationsservice.ListDataIntegrationsOutput, bool) bool, ...request.Option) error

	ListEventIntegrationAssociations(*appintegrationsservice.ListEventIntegrationAssociationsInput) (*appintegrationsservice.ListEventIntegrationAssociationsOutput, error)
	ListEventIntegrationAssociationsWithContext(aws.Context, *appintegrationsservice.ListEventIntegrationAssociationsInput, ...request.Option) (*appintegrationsservice.ListEventIntegrationAssociationsOutput, error)
	ListEventIntegrationAssociationsRequest(*appintegrationsservice.ListEventIntegrationAssociationsInput) (*request.Request, *appintegrationsservice.ListEventIntegrationAssociationsOutput)

	ListEventIntegrationAssociationsPages(*appintegrationsservice.ListEventIntegrationAssociationsInput, func(*appintegrationsservice.ListEventIntegrationAssociationsOutput, bool) bool) error
	ListEventIntegrationAssociationsPagesWithContext(aws.Context, *appintegrationsservice.ListEventIntegrationAssociationsInput, func(*appintegrationsservice.ListEventIntegrationAssociationsOutput, bool) bool, ...request.Option) error

	ListEventIntegrations(*appintegrationsservice.ListEventIntegrationsInput) (*appintegrationsservice.ListEventIntegrationsOutput, error)
	ListEventIntegrationsWithContext(aws.Context, *appintegrationsservice.ListEventIntegrationsInput, ...request.Option) (*appintegrationsservice.ListEventIntegrationsOutput, error)
	ListEventIntegrationsRequest(*appintegrationsservice.ListEventIntegrationsInput) (*request.Request, *appintegrationsservice.ListEventIntegrationsOutput)

	ListEventIntegrationsPages(*appintegrationsservice.ListEventIntegrationsInput, func(*appintegrationsservice.ListEventIntegrationsOutput, bool) bool) error
	ListEventIntegrationsPagesWithContext(aws.Context, *appintegrationsservice.ListEventIntegrationsInput, func(*appintegrationsservice.ListEventIntegrationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*appintegrationsservice.ListTagsForResourceInput) (*appintegrationsservice.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *appintegrationsservice.ListTagsForResourceInput, ...request.Option) (*appintegrationsservice.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*appintegrationsservice.ListTagsForResourceInput) (*request.Request, *appintegrationsservice.ListTagsForResourceOutput)

	TagResource(*appintegrationsservice.TagResourceInput) (*appintegrationsservice.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *appintegrationsservice.TagResourceInput, ...request.Option) (*appintegrationsservice.TagResourceOutput, error)
	TagResourceRequest(*appintegrationsservice.TagResourceInput) (*request.Request, *appintegrationsservice.TagResourceOutput)

	UntagResource(*appintegrationsservice.UntagResourceInput) (*appintegrationsservice.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *appintegrationsservice.UntagResourceInput, ...request.Option) (*appintegrationsservice.UntagResourceOutput, error)
	UntagResourceRequest(*appintegrationsservice.UntagResourceInput) (*request.Request, *appintegrationsservice.UntagResourceOutput)

	UpdateApplication(*appintegrationsservice.UpdateApplicationInput) (*appintegrationsservice.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *appintegrationsservice.UpdateApplicationInput, ...request.Option) (*appintegrationsservice.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*appintegrationsservice.UpdateApplicationInput) (*request.Request, *appintegrationsservice.UpdateApplicationOutput)

	UpdateDataIntegration(*appintegrationsservice.UpdateDataIntegrationInput) (*appintegrationsservice.UpdateDataIntegrationOutput, error)
	UpdateDataIntegrationWithContext(aws.Context, *appintegrationsservice.UpdateDataIntegrationInput, ...request.Option) (*appintegrationsservice.UpdateDataIntegrationOutput, error)
	UpdateDataIntegrationRequest(*appintegrationsservice.UpdateDataIntegrationInput) (*request.Request, *appintegrationsservice.UpdateDataIntegrationOutput)

	UpdateEventIntegration(*appintegrationsservice.UpdateEventIntegrationInput) (*appintegrationsservice.UpdateEventIntegrationOutput, error)
	UpdateEventIntegrationWithContext(aws.Context, *appintegrationsservice.UpdateEventIntegrationInput, ...request.Option) (*appintegrationsservice.UpdateEventIntegrationOutput, error)
	UpdateEventIntegrationRequest(*appintegrationsservice.UpdateEventIntegrationInput) (*request.Request, *appintegrationsservice.UpdateEventIntegrationOutput)
}

var _ AppIntegrationsServiceAPI = (*appintegrationsservice.AppIntegrationsService)(nil)
