// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package directconnect

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/private/signer/v4"
)

// AWS Direct Connect makes it easy to establish a dedicated network connection
// from your premises to Amazon Web Services (AWS). Using AWS Direct Connect,
// you can establish private connectivity between AWS and your data center,
// office, or colocation environment, which in many cases can reduce your network
// costs, increase bandwidth throughput, and provide a more consistent network
// experience than Internet-based connections.
//
// The AWS Direct Connect API Reference provides descriptions, syntax, and
// usage examples for each of the actions and data types for AWS Direct Connect.
// Use the following links to get started using the AWS Direct Connect API Reference:
//
//  Actions (http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Operations.html):
// An alphabetical list of all AWS Direct Connect actions. Data Types (http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Types.html):
// An alphabetical list of all AWS Direct Connect data types. Common Query Parameters
// (http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonParameters.html):
// Parameters that all Query actions can use. Common Errors (http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonErrors.html):
// Client and server errors that all actions can return.
//The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
type DirectConnect struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// A ServiceName is the name of the service the client will make API calls to.
const ServiceName = "directconnect"

// New creates a new instance of the DirectConnect client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a DirectConnect client from just a session.
//     svc := directconnect.New(mySession)
//
//     // Create a DirectConnect client with additional configuration
//     svc := directconnect.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *DirectConnect {
	c := p.ClientConfig(ServiceName, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion string) *DirectConnect {
	svc := &DirectConnect{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2012-10-25",
				JSONVersion:   "1.1",
				TargetPrefix:  "OvertureService",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBack(v4.Sign)
	svc.Handlers.Build.PushBack(jsonrpc.Build)
	svc.Handlers.Unmarshal.PushBack(jsonrpc.Unmarshal)
	svc.Handlers.UnmarshalMeta.PushBack(jsonrpc.UnmarshalMeta)
	svc.Handlers.UnmarshalError.PushBack(jsonrpc.UnmarshalError)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a DirectConnect operation and runs any
// custom request initialization.
func (c *DirectConnect) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
