# Security Policy


## Versioning and Backwards Compatibility

_cattrs_ follows [*CalVer*](https://calver.org) and we only support the latest PyPI version, due to limited resources.
We aim to support all Python versions that are not end-of-life; older versions will be dropped to ease the maintenance burden.

Our goal is to never undertake major breaking changes (the kinds that would necessitate a v2 if we were following SemVer).
Minor breaking changes may be undertaken to improve the developer experience and robustness of the library.
All breaking changes are prominently called out in the changelog, alongside any customization steps that may be used to restore previous behavior, when applicable.

APIs may be marked as provisional.
These are not guaranteed to be stable and may change or be removed without prior notice.

## Security Contact Information

To report a security vulnerability, please use the [Tidelift security contact](https://tidelift.com/security).
Tidelift will coordinate the fix and disclosure.
