# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementAttachedDatabaseConfigurationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_attached_database_configurations_check_name_availability(self, resource_group):
        response = self.client.attached_database_configurations.check_name_availability(
            resource_group_name=resource_group.name,
            cluster_name="str",
            resource_name={"name": "str", "type": "Microsoft.Kusto/clusters/attachedDatabaseConfigurations"},
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_attached_database_configurations_list_by_cluster(self, resource_group):
        response = self.client.attached_database_configurations.list_by_cluster(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_attached_database_configurations_get(self, resource_group):
        response = self.client.attached_database_configurations.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            attached_database_configuration_name="str",
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_attached_database_configurations_begin_create_or_update(self, resource_group):
        response = self.client.attached_database_configurations.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            attached_database_configuration_name="str",
            parameters={
                "attachedDatabaseNames": ["str"],
                "clusterResourceId": "str",
                "databaseName": "str",
                "databaseNameOverride": "str",
                "databaseNamePrefix": "str",
                "defaultPrincipalsModificationKind": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "tableLevelSharingProperties": {
                    "externalTablesToExclude": ["str"],
                    "externalTablesToInclude": ["str"],
                    "functionsToExclude": ["str"],
                    "functionsToInclude": ["str"],
                    "materializedViewsToExclude": ["str"],
                    "materializedViewsToInclude": ["str"],
                    "tablesToExclude": ["str"],
                    "tablesToInclude": ["str"],
                },
                "type": "str",
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_attached_database_configurations_begin_delete(self, resource_group):
        response = self.client.attached_database_configurations.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            attached_database_configuration_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
