# Copyright (C) 2006-2025 Simon Josefsson
#
# This file is part of GNU SASL.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

manual_title = Simple Authentication and Security Layer
gendocs_options_ = -I ../examples

old_NEWS_hash = 4423c4c8600231c5cb8d72794af454d0

guix = $(shell command -v guix > /dev/null && echo ,guix)
bootstrap-tools = gnulib,autoconf,automake,libtoolize,make,makeinfo,help2man,gperf,gengetopt,gtkdocize,tar,gzip$(guix)

update-copyright-env = \
	UPDATE_COPYRIGHT_HOLDER="Simon Josefsson"	\
	UPDATE_COPYRIGHT_USE_INTERVALS=2		\
	UPDATE_COPYRIGHT_FORCE=1

review-tag ?= $(shell git describe --abbrev=0)
review-diff:
	git diff $(review-tag).. \
	| grep -v -e '^index' -e '^deleted file mode' -e '^new file mode' \
	| filterdiff -p 1 -x 'gl/*' -x 'm4/*' -x 'lib/gl/*' -x 'lib/m4/*' -x 'po/*' -x 'maint.mk' -x '.gitignore' -x '.x-sc*' -x ChangeLog -x GNUmakefile -x ABOUT-NLS -x .prev-version -x .gitlab-ci.yml -x bootstrap -x bootstrap-funclib.sh \
	| less

my-update-copyright: update-copyright
	perl -pi -e "s/2002-20.. Simon Josefsson/2002-`(date +%Y)` Simon Josefsson/" doc/Makefile.am

# syntax-check
local-checks-to-skip = \
	sc_error_message_uppercase	\
	sc_prohibit_gnu_make_extensions	\
	sc_prohibit_strcmp
exclude_file_name_regexp--sc_GPL_version = ^m4/pkg.m4|lib/.*$$
exclude_file_name_regexp--sc_bindtextdomain = ^doc/print-errors.c|examples/.*|lib/digest-md5/test-parser.c|lib/tests/test-error.c|tests/.*$$
exclude_file_name_regexp--sc_file_system = ^doc/doxygen/Doxyfile.*$$
exclude_file_name_regexp--sc_fsf_postal = ^m4/pkg.m4$$
exclude_file_name_regexp--sc_prohibit_always_true_header_tests = ^lib/win32/include/config.h$$
exclude_file_name_regexp--sc_prohibit_empty_lines_at_EOF = ^gl/0001-Fix-export-symbols-and-export-symbols-regex-support-.patch|doc/gsasl-[2a-z]*.(dia|png)|tests/gssapi.tkt$$
exclude_file_name_regexp--sc_prohibit_magic_number_exit = ^doc/gsasl.texi|examples/(openid20|saml20)/.*.php$$
exclude_file_name_regexp--sc_require_config_h = ^lib/src/doxygen.c$$
exclude_file_name_regexp--sc_space_tab = ^doc/gsasl-controlflow.pdf$$
exclude_file_name_regexp--sc_trailing_blank = ^m4/pkg.m4|po/.*po.in|gl/0001-Fix-export-symbols-and-export-symbols-regex-support-.patch|doc/gsasl-[2a-z]*.(eps|png|pdf|dia)|doc/doxygen/Doxyfile.*|gl/doc/gendocs_template.diff|gl/top/README-release.diff$$
exclude_file_name_regexp--sc_unmarked_diagnostics = ^examples/.*|src/gsasl.c$$
exclude_file_name_regexp--sc_unportable_grep_q = ^tests/gsasl-dovecot-gssapi.sh|tests/gsasl-mailutils-cram.sh|tests/gsasl-mailutils-gs2krb5-gssapi.sh|tests/gsasl-mailutils-tls.sh|tests/gsasl-scram-pbkdf2.sh$$

TAR_OPTIONS += --mode=go+u,go-w --mtime=$(abs_top_srcdir)/NEWS

announce_gen_args = --cksum-checksums
url_dir_list = https://ftp.gnu.org/gnu/$(PACKAGE)

DIST_ARCHIVES += $(shell \
	if test -e $(srcdir)/.git && command -v git > /dev/null; then \
		echo $(PACKAGE)-v$(VERSION)-src.tar.gz; \
	fi)

update-po: refresh-po
	rm -fv po/*.po.in
	for f in `ls po/*.po | grep -v quot.po`; do \
		cp $$f $$f.in; \
	done
	git add po/*.po.in
	git commit po/*.po.in \
		-m "maint: Run 'make update-po' for new translations."

codespell_ignore_words_list = ba,ans
exclude_file_name_regexp--sc_codespell = ^po/.*.po(.in|)|doc/.*.pdf$$
codespell_extra_args = --count

codespell_args ?= --ignore-words-list $(codespell_ignore_words_list) \
	$(codespell_extra_args)
sc_codespell:
	@if ! command -v codespell > /dev/null; then			\
	   echo 1>&2 '$(ME): sc_codespell: codespell is missing';	\
	else								\
	   codespell $(codespell_args) $$($(VC_LIST_EXCEPT));		\
	fi
