
use builtin;
use str;

set edit:completion:arg-completer[bite] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'bite'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'bite'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand bugzilla 'bugzilla service support'
            cand github 'github service support'
            cand redmine 'redmine service support'
            cand completion 'generate shell completion'
            cand show 'show service information'
        }
        &'bite;bugzilla'= {
            cand -c 'service connection'
            cand --connection 'service connection'
            cand -C 'concurrent requests limit'
            cand --concurrent 'concurrent requests limit'
            cand --certificate 'custom root certificate'
            cand --proxy 'custom proxy'
            cand -t 'request timeout in seconds'
            cand --timeout 'request timeout in seconds'
            cand -k 'API key'
            cand --key 'API key'
            cand -u 'username'
            cand --user 'username'
            cand -p 'password'
            cand --password 'password'
            cand --insecure 'ignore invalid service certificates'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand attachment 'Attachment commands'
            cand a 'Attachment commands'
            cand comment 'Get bug comments'
            cand create 'Create bug'
            cand c 'Create bug'
            cand fields 'Get bugzilla fields'
            cand get 'Get bugs'
            cand g 'Get bugs'
            cand history 'Get bug changes'
            cand search 'Search bugs'
            cand s 'Search bugs'
            cand update 'Update bugs'
            cand u 'Update bugs'
            cand version 'Get bugzilla version'
        }
        &'bite;bugzilla;attachment'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand create 'Create attachments'
            cand c 'Create attachments'
            cand get 'Get attachments'
            cand g 'Get attachments'
            cand update 'Update attachments'
            cand u 'Update attachments'
        }
        &'bite;bugzilla;a'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand create 'Create attachments'
            cand c 'Create attachments'
            cand get 'Get attachments'
            cand g 'Get attachments'
            cand update 'Update attachments'
            cand u 'Update attachments'
        }
        &'bite;bugzilla;attachment;create'= {
            cand -c 'attachment comment'
            cand --comment 'attachment comment'
            cand -d 'attachment description'
            cand --description 'attachment description'
            cand -f 'attachment flags'
            cand --flags 'attachment flags'
            cand -m 'attachment MIME type'
            cand --mime 'attachment MIME type'
            cand -n 'attachment file name'
            cand --name 'attachment file name'
            cand -p 'attachment is a patch'
            cand --patch 'attachment is a patch'
            cand -P 'attachment is private'
            cand --private 'attachment is private'
            cand -C 'compress attachment'
            cand --compress 'compress attachment'
            cand --auto-compress 'auto-compress attachment'
            cand --auto-truncate 'auto-truncate text attachment'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;attachment;c'= {
            cand -c 'attachment comment'
            cand --comment 'attachment comment'
            cand -d 'attachment description'
            cand --description 'attachment description'
            cand -f 'attachment flags'
            cand --flags 'attachment flags'
            cand -m 'attachment MIME type'
            cand --mime 'attachment MIME type'
            cand -n 'attachment file name'
            cand --name 'attachment file name'
            cand -p 'attachment is a patch'
            cand --patch 'attachment is a patch'
            cand -P 'attachment is private'
            cand --private 'attachment is private'
            cand -C 'compress attachment'
            cand --compress 'compress attachment'
            cand --auto-compress 'auto-compress attachment'
            cand --auto-truncate 'auto-truncate text attachment'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;create'= {
            cand -c 'attachment comment'
            cand --comment 'attachment comment'
            cand -d 'attachment description'
            cand --description 'attachment description'
            cand -f 'attachment flags'
            cand --flags 'attachment flags'
            cand -m 'attachment MIME type'
            cand --mime 'attachment MIME type'
            cand -n 'attachment file name'
            cand --name 'attachment file name'
            cand -p 'attachment is a patch'
            cand --patch 'attachment is a patch'
            cand -P 'attachment is private'
            cand --private 'attachment is private'
            cand -C 'compress attachment'
            cand --compress 'compress attachment'
            cand --auto-compress 'auto-compress attachment'
            cand --auto-truncate 'auto-truncate text attachment'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;c'= {
            cand -c 'attachment comment'
            cand --comment 'attachment comment'
            cand -d 'attachment description'
            cand --description 'attachment description'
            cand -f 'attachment flags'
            cand --flags 'attachment flags'
            cand -m 'attachment MIME type'
            cand --mime 'attachment MIME type'
            cand -n 'attachment file name'
            cand --name 'attachment file name'
            cand -p 'attachment is a patch'
            cand --patch 'attachment is a patch'
            cand -P 'attachment is private'
            cand --private 'attachment is private'
            cand -C 'compress attachment'
            cand --compress 'compress attachment'
            cand --auto-compress 'auto-compress attachment'
            cand --auto-truncate 'auto-truncate text attachment'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;attachment;get'= {
            cand -o 'output attachment data'
            cand --output 'output attachment data'
            cand -d 'save attachments into a base directory'
            cand --dir 'save attachments into a base directory'
            cand -l 'list attachment metadata'
            cand --list 'list attachment metadata'
            cand -O 'include outdated attachments'
            cand --outdated 'include outdated attachments'
            cand -i 'request attachments from bug IDs or aliases'
            cand --item-ids 'request attachments from bug IDs or aliases'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;attachment;g'= {
            cand -o 'output attachment data'
            cand --output 'output attachment data'
            cand -d 'save attachments into a base directory'
            cand --dir 'save attachments into a base directory'
            cand -l 'list attachment metadata'
            cand --list 'list attachment metadata'
            cand -O 'include outdated attachments'
            cand --outdated 'include outdated attachments'
            cand -i 'request attachments from bug IDs or aliases'
            cand --item-ids 'request attachments from bug IDs or aliases'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;get'= {
            cand -o 'output attachment data'
            cand --output 'output attachment data'
            cand -d 'save attachments into a base directory'
            cand --dir 'save attachments into a base directory'
            cand -l 'list attachment metadata'
            cand --list 'list attachment metadata'
            cand -O 'include outdated attachments'
            cand --outdated 'include outdated attachments'
            cand -i 'request attachments from bug IDs or aliases'
            cand --item-ids 'request attachments from bug IDs or aliases'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;g'= {
            cand -o 'output attachment data'
            cand --output 'output attachment data'
            cand -d 'save attachments into a base directory'
            cand --dir 'save attachments into a base directory'
            cand -l 'list attachment metadata'
            cand --list 'list attachment metadata'
            cand -O 'include outdated attachments'
            cand --outdated 'include outdated attachments'
            cand -i 'request attachments from bug IDs or aliases'
            cand --item-ids 'request attachments from bug IDs or aliases'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;attachment;update'= {
            cand -c 'update comment'
            cand --comment 'update comment'
            cand -d 'update description'
            cand --description 'update description'
            cand -f 'update flags'
            cand --flags 'update flags'
            cand -m 'update MIME type'
            cand --mime 'update MIME type'
            cand -n 'update file name'
            cand --name 'update file name'
            cand -o 'update obsolete status'
            cand --obsolete 'update obsolete status'
            cand -p 'update patch status'
            cand --patch 'update patch status'
            cand -P 'update private status'
            cand --private 'update private status'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;attachment;u'= {
            cand -c 'update comment'
            cand --comment 'update comment'
            cand -d 'update description'
            cand --description 'update description'
            cand -f 'update flags'
            cand --flags 'update flags'
            cand -m 'update MIME type'
            cand --mime 'update MIME type'
            cand -n 'update file name'
            cand --name 'update file name'
            cand -o 'update obsolete status'
            cand --obsolete 'update obsolete status'
            cand -p 'update patch status'
            cand --patch 'update patch status'
            cand -P 'update private status'
            cand --private 'update private status'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;update'= {
            cand -c 'update comment'
            cand --comment 'update comment'
            cand -d 'update description'
            cand --description 'update description'
            cand -f 'update flags'
            cand --flags 'update flags'
            cand -m 'update MIME type'
            cand --mime 'update MIME type'
            cand -n 'update file name'
            cand --name 'update file name'
            cand -o 'update obsolete status'
            cand --obsolete 'update obsolete status'
            cand -p 'update patch status'
            cand --patch 'update patch status'
            cand -P 'update private status'
            cand --private 'update private status'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;a;u'= {
            cand -c 'update comment'
            cand --comment 'update comment'
            cand -d 'update description'
            cand --description 'update description'
            cand -f 'update flags'
            cand --flags 'update flags'
            cand -m 'update MIME type'
            cand --mime 'update MIME type'
            cand -n 'update file name'
            cand --name 'update file name'
            cand -o 'update obsolete status'
            cand --obsolete 'update obsolete status'
            cand -p 'update patch status'
            cand --patch 'update patch status'
            cand -P 'update private status'
            cand --private 'update private status'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;comment'= {
            cand -a 'comment includes attachment'
            cand --attachment 'comment includes attachment'
            cand -c 'comment created at this time or later'
            cand --created 'comment created at this time or later'
            cand -R 'user who commented'
            cand --creator 'user who commented'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;create'= {
            cand --from-bug 'read attributes from an existing bug'
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -A 'set aliases'
            cand --alias 'set aliases'
            cand -a 'set assignee'
            cand --assignee 'set assignee'
            cand -b 'set blockers'
            cand --blocks 'set blockers'
            cand --cc 'set CC users'
            cand -C 'set component'
            cand --component 'set component'
            cand --cf 'set custom field'
            cand -d 'set dependencies'
            cand --depends 'set dependencies'
            cand -D 'set description'
            cand --description 'set description'
            cand -F 'set flags'
            cand --flags 'set flags'
            cand -g 'set groups'
            cand --groups 'set groups'
            cand -k 'set keywords'
            cand --keywords 'set keywords'
            cand --os 'set operating system'
            cand --platform 'set platform'
            cand --priority 'set priority'
            cand -p 'set product'
            cand --product 'set product'
            cand --qa 'set QA contact'
            cand -r 'set resolution'
            cand --resolution 'set resolution'
            cand -U 'set external bug URLs'
            cand --see-also 'set external bug URLs'
            cand --severity 'set severity'
            cand -s 'set status'
            cand --status 'set status'
            cand -S 'set summary'
            cand --summary 'set summary'
            cand -T 'set target milestone'
            cand --target 'set target milestone'
            cand -u 'set URL'
            cand --url 'set URL'
            cand -V 'set version'
            cand --version 'set version'
            cand -w 'set whiteboard'
            cand --whiteboard 'set whiteboard'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;c'= {
            cand --from-bug 'read attributes from an existing bug'
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -A 'set aliases'
            cand --alias 'set aliases'
            cand -a 'set assignee'
            cand --assignee 'set assignee'
            cand -b 'set blockers'
            cand --blocks 'set blockers'
            cand --cc 'set CC users'
            cand -C 'set component'
            cand --component 'set component'
            cand --cf 'set custom field'
            cand -d 'set dependencies'
            cand --depends 'set dependencies'
            cand -D 'set description'
            cand --description 'set description'
            cand -F 'set flags'
            cand --flags 'set flags'
            cand -g 'set groups'
            cand --groups 'set groups'
            cand -k 'set keywords'
            cand --keywords 'set keywords'
            cand --os 'set operating system'
            cand --platform 'set platform'
            cand --priority 'set priority'
            cand -p 'set product'
            cand --product 'set product'
            cand --qa 'set QA contact'
            cand -r 'set resolution'
            cand --resolution 'set resolution'
            cand -U 'set external bug URLs'
            cand --see-also 'set external bug URLs'
            cand --severity 'set severity'
            cand -s 'set status'
            cand --status 'set status'
            cand -S 'set summary'
            cand --summary 'set summary'
            cand -T 'set target milestone'
            cand --target 'set target milestone'
            cand -u 'set URL'
            cand --url 'set URL'
            cand -V 'set version'
            cand --version 'set version'
            cand -w 'set whiteboard'
            cand --whiteboard 'set whiteboard'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;fields'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;get'= {
            cand -A 'disable attachments'
            cand --no-attachments 'disable attachments'
            cand -C 'disable comments'
            cand --no-comments 'disable comments'
            cand -H 'disable history'
            cand --no-history 'disable history'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;g'= {
            cand -A 'disable attachments'
            cand --no-attachments 'disable attachments'
            cand -C 'disable comments'
            cand --no-comments 'disable comments'
            cand -H 'disable history'
            cand --no-history 'disable history'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;history'= {
            cand -c 'event occurred at this time or later'
            cand --created 'event occurred at this time or later'
            cand -R 'user who made change'
            cand --creator 'user who made change'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;search'= {
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -f 'fields to output'
            cand --fields 'fields to output'
            cand -l 'limit result count'
            cand --limit 'limit result count'
            cand -O 'result starting position'
            cand --offset 'result starting position'
            cand -o 'order query results'
            cand --order 'order query results'
            cand -S 'search using quicksearch syntax'
            cand --quicksearch 'search using quicksearch syntax'
            cand -A 'restrict by alias'
            cand --alias 'restrict by alias'
            cand -@ 'restrict by attachments'
            cand --attachments 'restrict by attachments'
            cand -B 'restrict by blockers'
            cand --blocks 'restrict by blockers'
            cand -C 'restrict by component'
            cand --component 'restrict by component'
            cand --cf 'restrict by custom field'
            cand -D 'restrict by dependencies'
            cand --depends 'restrict by dependencies'
            cand -F 'restrict by flag'
            cand --flags 'restrict by flag'
            cand -g 'restrict by group'
            cand --groups 'restrict by group'
            cand --id 'restrict by ID'
            cand -k 'restrict by keyword'
            cand --keywords 'restrict by keyword'
            cand --os 'restrict by operating system'
            cand --platform 'restrict by platform'
            cand --priority 'restrict by priority'
            cand -p 'restrict by product'
            cand --product 'restrict by product'
            cand -r 'restrict by resolution'
            cand --resolution 'restrict by resolution'
            cand -U 'restrict by tracker URLs'
            cand --see-also 'restrict by tracker URLs'
            cand --severity 'restrict by severity'
            cand -s 'restrict by status'
            cand --status 'restrict by status'
            cand -t 'restrict by personal tags'
            cand --tags 'restrict by personal tags'
            cand -T 'restrict by target milestone'
            cand --target 'restrict by target milestone'
            cand --url 'restrict by URL'
            cand -V 'restrict by version'
            cand --version 'restrict by version'
            cand -w 'restrict by whiteboard'
            cand --whiteboard 'restrict by whiteboard'
            cand --attachment-description 'restrict by description'
            cand --attachment-filename 'restrict by file name'
            cand --attachment-mime 'restrict by MIME type'
            cand --attachment-is-obsolete 'restrict by obsolete status'
            cand --attachment-is-patch 'restrict by patch status'
            cand --attachment-is-private 'restrict by private status'
            cand --comments 'restrict by comment count'
            cand --votes 'restrict by vote count'
            cand --changed 'fields changed within time interval'
            cand --changed-by 'fields changed by users'
            cand --changed-from 'fields changed from value'
            cand --changed-to 'fields changed to value'
            cand -c 'restrict by creation time'
            cand --created 'restrict by creation time'
            cand -u 'restrict by update time'
            cand --updated 'restrict by update time'
            cand --closed 'restrict by closed time'
            cand -a 'user is assignee'
            cand --assignee 'user is assignee'
            cand --attacher 'user created attachment'
            cand --cc 'user in CC list'
            cand --commenter 'user who commented'
            cand --flagger 'user who set flag'
            cand --qa 'user is QA contact'
            cand -R 'user who reported'
            cand --reporter 'user who reported'
            cand --comment 'restrict by comment content'
            cand --comment-is-private 'restrict by private status'
            cand --comment-tag 'restrict by tag'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand --json 'output in JSON format'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand --paged 'enable paging support'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;s'= {
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -f 'fields to output'
            cand --fields 'fields to output'
            cand -l 'limit result count'
            cand --limit 'limit result count'
            cand -O 'result starting position'
            cand --offset 'result starting position'
            cand -o 'order query results'
            cand --order 'order query results'
            cand -S 'search using quicksearch syntax'
            cand --quicksearch 'search using quicksearch syntax'
            cand -A 'restrict by alias'
            cand --alias 'restrict by alias'
            cand -@ 'restrict by attachments'
            cand --attachments 'restrict by attachments'
            cand -B 'restrict by blockers'
            cand --blocks 'restrict by blockers'
            cand -C 'restrict by component'
            cand --component 'restrict by component'
            cand --cf 'restrict by custom field'
            cand -D 'restrict by dependencies'
            cand --depends 'restrict by dependencies'
            cand -F 'restrict by flag'
            cand --flags 'restrict by flag'
            cand -g 'restrict by group'
            cand --groups 'restrict by group'
            cand --id 'restrict by ID'
            cand -k 'restrict by keyword'
            cand --keywords 'restrict by keyword'
            cand --os 'restrict by operating system'
            cand --platform 'restrict by platform'
            cand --priority 'restrict by priority'
            cand -p 'restrict by product'
            cand --product 'restrict by product'
            cand -r 'restrict by resolution'
            cand --resolution 'restrict by resolution'
            cand -U 'restrict by tracker URLs'
            cand --see-also 'restrict by tracker URLs'
            cand --severity 'restrict by severity'
            cand -s 'restrict by status'
            cand --status 'restrict by status'
            cand -t 'restrict by personal tags'
            cand --tags 'restrict by personal tags'
            cand -T 'restrict by target milestone'
            cand --target 'restrict by target milestone'
            cand --url 'restrict by URL'
            cand -V 'restrict by version'
            cand --version 'restrict by version'
            cand -w 'restrict by whiteboard'
            cand --whiteboard 'restrict by whiteboard'
            cand --attachment-description 'restrict by description'
            cand --attachment-filename 'restrict by file name'
            cand --attachment-mime 'restrict by MIME type'
            cand --attachment-is-obsolete 'restrict by obsolete status'
            cand --attachment-is-patch 'restrict by patch status'
            cand --attachment-is-private 'restrict by private status'
            cand --comments 'restrict by comment count'
            cand --votes 'restrict by vote count'
            cand --changed 'fields changed within time interval'
            cand --changed-by 'fields changed by users'
            cand --changed-from 'fields changed from value'
            cand --changed-to 'fields changed to value'
            cand -c 'restrict by creation time'
            cand --created 'restrict by creation time'
            cand -u 'restrict by update time'
            cand --updated 'restrict by update time'
            cand --closed 'restrict by closed time'
            cand -a 'user is assignee'
            cand --assignee 'user is assignee'
            cand --attacher 'user created attachment'
            cand --cc 'user in CC list'
            cand --commenter 'user who commented'
            cand --flagger 'user who set flag'
            cand --qa 'user is QA contact'
            cand -R 'user who reported'
            cand --reporter 'user who reported'
            cand --comment 'restrict by comment content'
            cand --comment-is-private 'restrict by private status'
            cand --comment-tag 'restrict by tag'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand --json 'output in JSON format'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand --paged 'enable paging support'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;update'= {
            cand -R 'reply to specific comments'
            cand --reply 'reply to specific comments'
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -A 'add/remove/set aliases'
            cand --alias 'add/remove/set aliases'
            cand -a 'update assignee'
            cand --assignee 'update assignee'
            cand -b 'add/remove/set blockers'
            cand --blocks 'add/remove/set blockers'
            cand --cc 'add/remove CC users'
            cand -c 'add comment'
            cand --comment 'add comment'
            cand -F 'add comment from file'
            cand --comment-from 'add comment from file'
            cand --comment-privacy 'update comment privacy'
            cand -C 'update component'
            cand --component 'update component'
            cand --cf 'update custom field'
            cand -d 'add/remove/set dependencies'
            cand --depends 'add/remove/set dependencies'
            cand -D 'mark bug as duplicate'
            cand --duplicate-of 'mark bug as duplicate'
            cand -f 'add/remove flags'
            cand --flags 'add/remove flags'
            cand -g 'add/remove groups'
            cand --groups 'add/remove groups'
            cand -k 'add/remove/set keywords'
            cand --keywords 'add/remove/set keywords'
            cand --os 'update operating system'
            cand --platform 'update platform'
            cand --priority 'update priority'
            cand -p 'update product'
            cand --product 'update product'
            cand --qa 'update QA contact'
            cand -r 'update resolution'
            cand --resolution 'update resolution'
            cand -U 'add/remove bug URLs'
            cand --see-also 'add/remove bug URLs'
            cand --severity 'update severity'
            cand -s 'update status'
            cand --status 'update status'
            cand -S 'update summary'
            cand --summary 'update summary'
            cand -T 'update target milestone'
            cand --target 'update target milestone'
            cand -u 'update URL'
            cand --url 'update URL'
            cand -V 'update version'
            cand --version 'update version'
            cand -w 'update whiteboard'
            cand --whiteboard 'update whiteboard'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -P 'enable comment privacy'
            cand --comment-is-private 'enable comment privacy'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;u'= {
            cand -R 'reply to specific comments'
            cand --reply 'reply to specific comments'
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -A 'add/remove/set aliases'
            cand --alias 'add/remove/set aliases'
            cand -a 'update assignee'
            cand --assignee 'update assignee'
            cand -b 'add/remove/set blockers'
            cand --blocks 'add/remove/set blockers'
            cand --cc 'add/remove CC users'
            cand -c 'add comment'
            cand --comment 'add comment'
            cand -F 'add comment from file'
            cand --comment-from 'add comment from file'
            cand --comment-privacy 'update comment privacy'
            cand -C 'update component'
            cand --component 'update component'
            cand --cf 'update custom field'
            cand -d 'add/remove/set dependencies'
            cand --depends 'add/remove/set dependencies'
            cand -D 'mark bug as duplicate'
            cand --duplicate-of 'mark bug as duplicate'
            cand -f 'add/remove flags'
            cand --flags 'add/remove flags'
            cand -g 'add/remove groups'
            cand --groups 'add/remove groups'
            cand -k 'add/remove/set keywords'
            cand --keywords 'add/remove/set keywords'
            cand --os 'update operating system'
            cand --platform 'update platform'
            cand --priority 'update priority'
            cand -p 'update product'
            cand --product 'update product'
            cand --qa 'update QA contact'
            cand -r 'update resolution'
            cand --resolution 'update resolution'
            cand -U 'add/remove bug URLs'
            cand --see-also 'add/remove bug URLs'
            cand --severity 'update severity'
            cand -s 'update status'
            cand --status 'update status'
            cand -S 'update summary'
            cand --summary 'update summary'
            cand -T 'update target milestone'
            cand --target 'update target milestone'
            cand -u 'update URL'
            cand --url 'update URL'
            cand -V 'update version'
            cand --version 'update version'
            cand -w 'update whiteboard'
            cand --whiteboard 'update whiteboard'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -P 'enable comment privacy'
            cand --comment-is-private 'enable comment privacy'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;bugzilla;version'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;github'= {
            cand -c 'service connection'
            cand --connection 'service connection'
            cand -C 'concurrent requests limit'
            cand --concurrent 'concurrent requests limit'
            cand --certificate 'custom root certificate'
            cand --proxy 'custom proxy'
            cand -t 'request timeout in seconds'
            cand --timeout 'request timeout in seconds'
            cand -k 'GitHub personal access token'
            cand --key 'GitHub personal access token'
            cand -u 'username'
            cand --user 'username'
            cand --insecure 'ignore invalid service certificates'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand get 'Get issues'
            cand g 'Get issues'
            cand search 'Search issues'
            cand s 'Search issues'
        }
        &'bite;github;get'= {
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;github;g'= {
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;github;search'= {
            cand -F 'fields to output'
            cand --fields 'fields to output'
            cand -S 'sorting order for search query'
            cand --order 'sorting order for search query'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;github;s'= {
            cand -F 'fields to output'
            cand --fields 'fields to output'
            cand -S 'sorting order for search query'
            cand --order 'sorting order for search query'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;redmine'= {
            cand -c 'service connection'
            cand --connection 'service connection'
            cand -C 'concurrent requests limit'
            cand --concurrent 'concurrent requests limit'
            cand --certificate 'custom root certificate'
            cand --proxy 'custom proxy'
            cand -t 'request timeout in seconds'
            cand --timeout 'request timeout in seconds'
            cand -k 'API key'
            cand --key 'API key'
            cand -u 'username'
            cand --user 'username'
            cand -p 'password'
            cand --password 'password'
            cand --insecure 'ignore invalid service certificates'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand get 'Get issues'
            cand g 'Get issues'
            cand search 'Search issues'
            cand s 'Search issues'
        }
        &'bite;redmine;get'= {
            cand -C 'disable comments'
            cand --no-comments 'disable comments'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;redmine;g'= {
            cand -C 'disable comments'
            cand --no-comments 'disable comments'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;redmine;search'= {
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -f 'fields to output'
            cand --fields 'fields to output'
            cand -l 'limit result count'
            cand --limit 'limit result count'
            cand -O 'result starting position'
            cand --offset 'result starting position'
            cand -o 'order query results'
            cand --order 'order query results'
            cand --paged 'enable paging support'
            cand -a 'restrict by assignee status'
            cand --assignee 'restrict by assignee status'
            cand -@ 'restrict by attachments'
            cand --attachments 'restrict by attachments'
            cand -B 'restrict by blockers'
            cand --blocks 'restrict by blockers'
            cand -D 'restrict by dependencies'
            cand --blocked 'restrict by dependencies'
            cand -R 'restrict by relations'
            cand --relates 'restrict by relations'
            cand --id 'restrict by ID'
            cand -s 'restrict by status'
            cand --status 'restrict by status'
            cand -c 'restrict by creation time'
            cand --created 'restrict by creation time'
            cand -u 'restrict by update time'
            cand --updated 'restrict by update time'
            cand -C 'restrict by closed time'
            cand --closed 'restrict by closed time'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand --json 'output in JSON format'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;redmine;s'= {
            cand --from 'read attributes from templates'
            cand --to 'write attributes to template'
            cand -f 'fields to output'
            cand --fields 'fields to output'
            cand -l 'limit result count'
            cand --limit 'limit result count'
            cand -O 'result starting position'
            cand --offset 'result starting position'
            cand -o 'order query results'
            cand --order 'order query results'
            cand --paged 'enable paging support'
            cand -a 'restrict by assignee status'
            cand --assignee 'restrict by assignee status'
            cand -@ 'restrict by attachments'
            cand --attachments 'restrict by attachments'
            cand -B 'restrict by blockers'
            cand --blocks 'restrict by blockers'
            cand -D 'restrict by dependencies'
            cand --blocked 'restrict by dependencies'
            cand -R 'restrict by relations'
            cand --relates 'restrict by relations'
            cand --id 'restrict by ID'
            cand -s 'restrict by status'
            cand --status 'restrict by status'
            cand -c 'restrict by creation time'
            cand --created 'restrict by creation time'
            cand -u 'restrict by update time'
            cand --updated 'restrict by update time'
            cand -C 'restrict by closed time'
            cand --closed 'restrict by closed time'
            cand -b 'open in browser'
            cand --browser 'open in browser'
            cand --json 'output in JSON format'
            cand -n 'skip service interaction'
            cand --dry-run 'skip service interaction'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;completion'= {
            cand -d 'Target directory for completion files'
            cand --dir 'Target directory for completion files'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;show'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
            cand connections 'Show available connections'
            cand services 'Show available services'
        }
        &'bite;show;connections'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'bite;show;services'= {
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
