﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeguruprofiler/model/MetricType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CodeGuruProfiler {
namespace Model {
namespace MetricTypeMapper {

static const int AggregatedRelativeTotalTime_HASH = HashingUtils::HashString("AggregatedRelativeTotalTime");

MetricType GetMetricTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == AggregatedRelativeTotalTime_HASH) {
    return MetricType::AggregatedRelativeTotalTime;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<MetricType>(hashCode);
  }

  return MetricType::NOT_SET;
}

Aws::String GetNameForMetricType(MetricType enumValue) {
  switch (enumValue) {
    case MetricType::NOT_SET:
      return {};
    case MetricType::AggregatedRelativeTotalTime:
      return "AggregatedRelativeTotalTime";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace MetricTypeMapper
}  // namespace Model
}  // namespace CodeGuruProfiler
}  // namespace Aws
