﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class ListSharedProjectsResult {
 public:
  AWS_CODEBUILD_API ListSharedProjectsResult() = default;
  AWS_CODEBUILD_API ListSharedProjectsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API ListSharedProjectsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> During a previous call, the maximum number of items that can be returned is
   * the value specified in <code>maxResults</code>. If there more items in the list,
   * then a unique string called a <i>nextToken</i> is returned. To get the next
   * batch of items in the list, call this operation again, adding the next token to
   * the call. To get all of the items in the list, keep calling this operation with
   * each subsequent next token that is returned, until no more next tokens are
   * returned. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSharedProjectsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The list of ARNs for the build projects shared with the current Amazon Web
   * Services account or user. </p>
   */
  inline const Aws::Vector<Aws::String>& GetProjects() const { return m_projects; }
  template <typename ProjectsT = Aws::Vector<Aws::String>>
  void SetProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects = std::forward<ProjectsT>(value);
  }
  template <typename ProjectsT = Aws::Vector<Aws::String>>
  ListSharedProjectsResult& WithProjects(ProjectsT&& value) {
    SetProjects(std::forward<ProjectsT>(value));
    return *this;
  }
  template <typename ProjectsT = Aws::String>
  ListSharedProjectsResult& AddProjects(ProjectsT&& value) {
    m_projectsHasBeenSet = true;
    m_projects.emplace_back(std::forward<ProjectsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSharedProjectsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::Vector<Aws::String> m_projects;
  bool m_projectsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
