/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.util.ArraySupport;
import org.jruby.util.unsafe.UnsafeHolder;

public class NonvolatileVariableAccessor
extends VariableAccessor {
    public NonvolatileVariableAccessor(RubyClass realClass, String name2, int index2, int classId) {
        super(realClass, name2, index2, classId);
    }

    @Override
    public void set(Object object, Object value2) {
        ((RubyBasicObject)object).ensureInstanceVariablesSettable();
        NonvolatileVariableAccessor.setVariable((RubyBasicObject)object, this.realClass, this.index, value2);
    }

    public static void setVariableChecked(RubyBasicObject self2, RubyClass realClass, int index2, Object value2) {
        self2.ensureInstanceVariablesSettable();
        NonvolatileVariableAccessor.setVariable(self2, realClass, index2, value2);
    }

    public static void setVariable(RubyBasicObject self2, RubyClass realClass, int index2, Object value2) {
        Object[] currentTable;
        int currentStamp;
        while (((currentStamp = self2.varTableStamp) & 1) != 0 || ((currentTable = (Object[])UnsafeHolder.U.getObjectVolatile(self2, RubyBasicObject.VAR_TABLE_OFFSET)) == null || index2 >= currentTable.length ? !NonvolatileVariableAccessor.createTableUnsafe(self2, currentStamp, realClass, currentTable, index2, value2) : !NonvolatileVariableAccessor.updateTable(self2, currentStamp, currentTable, index2, value2))) {
        }
    }

    private static boolean createTableUnsafe(RubyBasicObject self2, int currentStamp, RubyClass realClass, Object[] currentTable, int index2, Object value2) {
        if (!UnsafeHolder.U.compareAndSwapInt(self2, RubyBasicObject.STAMP_OFFSET, currentStamp++, currentStamp)) {
            return false;
        }
        Object[] newTable = new Object[realClass.getVariableTableSizeWithExtras()];
        if (currentTable != null) {
            ArraySupport.copy(currentTable, 0, newTable, 0, currentTable.length);
        }
        newTable[index2] = value2;
        UnsafeHolder.U.putOrderedObject(self2, RubyBasicObject.VAR_TABLE_OFFSET, newTable);
        self2.varTableStamp = currentStamp + 1;
        return true;
    }

    private static boolean updateTable(RubyBasicObject self2, int currentStamp, Object[] currentTable, int index2, Object value2) {
        currentTable[index2] = value2;
        return self2.varTableStamp == currentStamp;
    }
}

