/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import sun.net.httpserver.ChunkedInputStream;
import sun.net.httpserver.ChunkedOutputStream;
import sun.net.httpserver.Code;
import sun.net.httpserver.FixedLengthInputStream;
import sun.net.httpserver.FixedLengthOutputStream;
import sun.net.httpserver.HttpConnection;
import sun.net.httpserver.HttpContextImpl;
import sun.net.httpserver.HttpExchangeImpl;
import sun.net.httpserver.HttpsExchangeImpl;
import sun.net.httpserver.LeftOverInputStream;
import sun.net.httpserver.PlaceholderOutputStream;
import sun.net.httpserver.Request;
import sun.net.httpserver.ServerImpl;
import sun.net.httpserver.UndefLengthOutputStream;
import sun.net.httpserver.UnmodifiableHeaders;
import sun.net.httpserver.WriteFinishedEvent;

class ExchangeImpl {
    Headers reqHdrs;
    Headers rspHdrs;
    Request req;
    String method;
    URI uri;
    HttpConnection connection;
    int reqContentLen;
    long rspContentLen;
    InputStream ris;
    OutputStream ros;
    Thread thread;
    boolean close;
    boolean closed;
    boolean http10 = false;
    static TimeZone tz;
    static DateFormat df;
    InputStream uis;
    OutputStream uos;
    LeftOverInputStream uis_orig;
    PlaceholderOutputStream uos_orig;
    boolean sentHeaders;
    Map<String, Object> attributes;
    int rcode = -1;
    HttpPrincipal principal;
    ServerImpl server;
    private byte[] rspbuf = new byte[128];

    ExchangeImpl(String string, URI uRI, Request request, int n, HttpConnection httpConnection) throws IOException {
        this.req = request;
        this.reqHdrs = request.headers();
        this.rspHdrs = new Headers();
        this.method = string;
        this.uri = uRI;
        this.connection = httpConnection;
        this.reqContentLen = n;
        this.ros = request.outputStream();
        this.ris = request.inputStream();
        this.server = this.getServerImpl();
        this.server.startExchange();
    }

    public Headers getRequestHeaders() {
        return new UnmodifiableHeaders(this.reqHdrs);
    }

    public Headers getResponseHeaders() {
        return this.rspHdrs;
    }

    public URI getRequestURI() {
        return this.uri;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public HttpContextImpl getHttpContext() {
        return this.connection.getHttpContext();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.uis_orig == null || this.uos == null) {
                this.connection.close();
                return;
            }
            if (!this.uos_orig.isWrapped()) {
                this.connection.close();
                return;
            }
            if (!this.uis_orig.isClosed()) {
                this.uis_orig.close();
            }
            this.uos.close();
        }
        catch (IOException iOException) {
            this.connection.close();
        }
    }

    public InputStream getRequestBody() {
        if (this.uis != null) {
            return this.uis;
        }
        if (this.reqContentLen == -1) {
            this.uis_orig = new ChunkedInputStream(this, this.ris);
            this.uis = this.uis_orig;
        } else {
            this.uis_orig = new FixedLengthInputStream(this, this.ris, this.reqContentLen);
            this.uis = this.uis_orig;
        }
        return this.uis;
    }

    LeftOverInputStream getOriginalInputStream() {
        return this.uis_orig;
    }

    public int getResponseCode() {
        return this.rcode;
    }

    public OutputStream getResponseBody() {
        if (this.uos == null) {
            this.uos_orig = new PlaceholderOutputStream(null);
            this.uos = this.uos_orig;
        }
        return this.uos;
    }

    PlaceholderOutputStream getPlaceholderResponseBody() {
        this.getResponseBody();
        return this.uos_orig;
    }

    public void sendResponseHeaders(int n, long l) throws IOException {
        if (this.sentHeaders) {
            throw new IOException("headers already sent");
        }
        this.rcode = n;
        String string = "HTTP/1.1 " + n + Code.msg(n) + "\r\n";
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.ros);
        PlaceholderOutputStream placeholderOutputStream = this.getPlaceholderResponseBody();
        ((OutputStream)bufferedOutputStream).write(this.bytes(string, 0), 0, string.length());
        boolean bl = false;
        this.rspHdrs.set("Date", df.format(new Date()));
        if (l == 0L) {
            if (this.http10) {
                placeholderOutputStream.setWrappedStream(new UndefLengthOutputStream(this, this.ros));
                this.close = true;
            } else {
                this.rspHdrs.set("Transfer-encoding", "chunked");
                placeholderOutputStream.setWrappedStream(new ChunkedOutputStream(this, this.ros));
            }
        } else {
            if (l == -1L) {
                bl = true;
                l = 0L;
            }
            if (this.rspHdrs.getFirst("Content-length") == null) {
                this.rspHdrs.set("Content-length", Long.toString(l));
            }
            placeholderOutputStream.setWrappedStream(new FixedLengthOutputStream(this, this.ros, l));
        }
        this.write(this.rspHdrs, bufferedOutputStream);
        this.rspContentLen = l;
        ((OutputStream)bufferedOutputStream).flush();
        bufferedOutputStream = null;
        this.sentHeaders = true;
        if (bl) {
            WriteFinishedEvent writeFinishedEvent = new WriteFinishedEvent(this);
            this.server.addEvent(writeFinishedEvent);
            this.closed = true;
        }
        this.server.logReply(n, this.req.requestLine(), null);
    }

    void write(Headers headers, OutputStream outputStream) throws IOException {
        Set<Map.Entry<String, List<String>>> set = headers.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            for (String string2 : list) {
                int n = string.length();
                byte[] byArray = this.bytes(string, 2);
                byArray[n++] = 58;
                byArray[n++] = 32;
                outputStream.write(byArray, 0, n);
                byArray = this.bytes(string2, 2);
                n = string2.length();
                byArray[n++] = 13;
                byArray[n++] = 10;
                outputStream.write(byArray, 0, n);
            }
        }
        outputStream.write(13);
        outputStream.write(10);
    }

    private byte[] bytes(String string, int n) {
        int n2 = string.length();
        if (n2 + n > this.rspbuf.length) {
            int n3 = n2 + n - this.rspbuf.length;
            this.rspbuf = new byte[2 * (this.rspbuf.length + n3)];
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            this.rspbuf[i] = (byte)cArray[i];
        }
        return this.rspbuf;
    }

    public InetSocketAddress getRemoteAddress() {
        Socket socket = this.connection.getChannel().socket();
        InetAddress inetAddress = socket.getInetAddress();
        int n = socket.getPort();
        return new InetSocketAddress(inetAddress, n);
    }

    public InetSocketAddress getLocalAddress() {
        Socket socket = this.connection.getChannel().socket();
        InetAddress inetAddress = socket.getLocalAddress();
        int n = socket.getLocalPort();
        return new InetSocketAddress(inetAddress, n);
    }

    public String getProtocol() {
        String string = this.req.requestLine();
        int n = string.lastIndexOf(32);
        return string.substring(n + 1);
    }

    public SSLSession getSSLSession() {
        SSLEngine sSLEngine = this.connection.getSSLEngine();
        if (sSLEngine == null) {
            return null;
        }
        return sSLEngine.getSession();
    }

    public Object getAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = this.getHttpContext().getAttributes();
        }
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = this.getHttpContext().getAttributes();
        }
        this.attributes.put(string, object);
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream) {
        assert (this.uis != null);
        if (inputStream != null) {
            this.uis = inputStream;
        }
        if (outputStream != null) {
            this.uos = outputStream;
        }
    }

    HttpConnection getConnection() {
        return this.connection;
    }

    ServerImpl getServerImpl() {
        return this.getHttpContext().getServerImpl();
    }

    public HttpPrincipal getPrincipal() {
        return this.principal;
    }

    void setPrincipal(HttpPrincipal httpPrincipal) {
        this.principal = httpPrincipal;
    }

    static ExchangeImpl get(HttpExchange httpExchange) {
        if (httpExchange instanceof HttpExchangeImpl) {
            return ((HttpExchangeImpl)httpExchange).getExchangeImpl();
        }
        assert (httpExchange instanceof HttpsExchangeImpl);
        return ((HttpsExchangeImpl)httpExchange).getExchangeImpl();
    }

    static {
        String string = "EEE, dd MMM yyyy HH:mm:ss zzz";
        tz = TimeZone.getTimeZone("GMT");
        df = new SimpleDateFormat(string, Locale.US);
        df.setTimeZone(tz);
    }
}

