/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.deploy.DeploymentMgr;
import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentSupport;
import com.sun.appserv.management.util.misc.TypeCast;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;

public class DeployNotificationListener
implements NotificationListener {
    private final Object mDeployID;
    private boolean mIsCompleted;
    private DeploymentStatus mDeploymentStatus;
    private DeploymentProgress mDeploymentProgress;
    private final DeploymentMgr mDeploymentMgr;

    public DeployNotificationListener(DeploymentMgr deploymentMgr, Object deployID) {
        if (deploymentMgr == null || deployID == null) {
            throw new IllegalArgumentException();
        }
        this.mIsCompleted = false;
        this.mDeploymentStatus = null;
        this.mDeploymentProgress = null;
        this.mDeploymentMgr = deploymentMgr;
        this.mDeployID = deployID;
        this.mDeploymentMgr.addNotificationListener(this, null, null);
    }

    public DeploymentMgr getDeploymentMgr() {
        return this.mDeploymentMgr;
    }

    public Object getDeployID() {
        return this.mDeployID;
    }

    public boolean isCompleted() {
        return this.mIsCompleted;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.mDeploymentStatus;
    }

    public DeploymentProgress getDeploymentProgress() {
        return this.mDeploymentProgress;
    }

    @Override
    public synchronized void handleNotification(Notification notif, Object handback) {
        try {
            this.realHandleNotification(notif, handback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deploymentDone(Notification notif, DeploymentStatus status) {
        this.mIsCompleted = true;
        this.mDeploymentStatus = status;
    }

    protected void deploymentAborted(Notification notif, DeploymentStatus status) {
        this.mIsCompleted = true;
        this.mDeploymentStatus = status;
    }

    protected void deploymentProgress(Notification notif, DeploymentProgress status) {
        this.mDeploymentProgress = status;
    }

    protected void deploymentStarted(Notification notif) {
    }

    public void cleanup() {
        try {
            this.mDeploymentMgr.removeNotificationListener(this, null, null);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void realHandleNotification(Notification notif, Object handback) {
        String type = notif.getType();
        Map m = TypeCast.asMap(notif.getUserData());
        Object deployID = m.get("X-DeploymentMgr.DeploymentID");
        if (deployID.equals(this.mDeployID)) {
            if (type.equals("X-DeploymentMgr.DeploymentStarted")) {
                this.deploymentStarted(notif);
            } else if (type.equals("X-DeploymentMgr.DeploymentAborted")) {
                try {
                    this.deploymentAborted(notif, null);
                }
                finally {
                    this.cleanup();
                }
            } else if (type.equals("X-DeploymentMgr.DeploymentCompleted")) {
                Map statusData = (Map)((Object)Util.getAMXNotificationValue(notif, "X-DeploymentMgr.DeploymentCompletedStatus"));
                DeploymentStatus status = DeploymentSupport.mapToDeploymentStatus(statusData);
                try {
                    this.deploymentDone(notif, status);
                }
                finally {
                    this.cleanup();
                }
            } else if (type.equals("X-DeploymentMgr.DeploymentProgress")) {
                Map statusData = (Map)((Object)Util.getAMXNotificationValue(notif, "X-DeploymentMgr.DeploymentProgress"));
                DeploymentProgress progress = DeploymentSupport.mapToDeploymentProgress(statusData);
                this.deploymentProgress(notif, progress);
            }
        }
    }
}

