/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.Constraint;
import edu.jhu.htm.core.Convex;
import edu.jhu.htm.core.HTMfunc;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.QuadNode;
import edu.jhu.htm.core.Sign;
import edu.jhu.htm.core.Vector3d;
import java.util.ArrayList;
import java.util.List;

public class Convex
extends Sign {
    List constraints_ = new ArrayList();
    List corners_ = new ArrayList();
    Constraint boundingCircle_;
    protected int olevel = 20;

    public Convex() {
    }

    public Convex(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = vector3d2.cross(vector3d3);
        Vector3d vector3d5 = vector3d3.cross(vector3d);
        Vector3d vector3d6 = vector3d.cross(vector3d2);
        double d = vector3d4.mul(vector3d);
        double d2 = vector3d5.mul(vector3d2);
        double d3 = vector3d6.mul(vector3d3);
        if (d * d2 * d3 > 0.0) {
            if (d < 0.0) {
                vector3d4 = vector3d4.mul(-1.0);
            }
            if (d2 < 0.0) {
                vector3d5 = vector3d5.mul(-1.0);
            }
            if (d3 < 0.0) {
                vector3d6 = vector3d6.mul(-1.0);
            }
            this.constraints_.add(new Constraint(vector3d4, 0.0));
            this.constraints_.add(new Constraint(vector3d5, 0.0));
            this.constraints_.add(new Constraint(vector3d6, 0.0));
        }
        this.sign_ = 1;
        this.simplify();
    }

    public Convex(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        Vector3d[] vector3dArray = new Vector3d[]{vector3d, vector3d2, vector3d3, vector3d4};
        Vector3d[] vector3dArray2 = new Vector3d[6];
        double[][] dArray = new double[6][2];
        int n = 0;
        int n2 = 0;
        while (n < 4) {
            int n3 = n + 1;
            while (n3 < 4) {
                vector3dArray2[n2] = vector3dArray[n].cross(vector3dArray[n3]);
                vector3dArray2[n2].normalize();
                int n4 = 0;
                int n5 = 0;
                while (n4 < 4) {
                    if (n4 != n && n4 != n3) {
                        dArray[n2][n5++] = vector3dArray2[n2].mul(vector3dArray[n4]);
                    }
                    ++n4;
                }
                ++n3;
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < 6) {
            if (dArray[n][0] * dArray[n][1] > 0.0) {
                this.constraints_.add(new Constraint(dArray[n][0] > 0.0 ? vector3dArray2[n] : vector3dArray2[n].mul(-1.0), 0.0));
            }
            ++n;
        }
        if (this.constraints_.size() == 2) {
            n = 0;
            while (n < 6) {
                if (dArray[n][0] == 0.0 || dArray[n][1] == 0.0) {
                    this.constraints_.add(new Constraint(dArray[n][0] + dArray[n][1] > 0.0 ? vector3dArray2[n] : vector3dArray2[n].mul(-1.0), 0.0));
                    break;
                }
                ++n;
            }
        }
        this.sign_ = 1;
        this.simplify();
    }

    public void add(Constraint constraint) {
        this.constraints_.add(constraint);
        int n = this.constraints_.size() - 1;
        while (n > 0) {
            Constraint constraint2 = this.getConstraint(n);
            Constraint constraint3 = this.getConstraint(n - 1);
            if (constraint2.s_ < constraint3.s_) {
                this.constraints_.set(n, constraint3);
                this.constraints_.set(n - 1, constraint2);
            }
            --n;
        }
        if (this.constraints_.size() == 1) {
            this.sign_ = constraint.sign_;
            return;
        }
        switch (this.sign_) {
            case 0: {
                if (constraint.sign_ != 2) break;
                this.sign_ = (short)3;
                break;
            }
            case 2: {
                if (constraint.sign_ != 0) break;
                this.sign_ = (short)3;
                break;
            }
            case 1: {
                this.sign_ = constraint.sign_;
            }
        }
    }

    void simplify0() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (HTMfunc.verbose) {
            System.out.println("Simplif0 : " + this.constraints_.size());
        }
        if (this.constraints_.size() == 1) {
            this.boundingCircle_ = this.getConstraint(0);
            return;
        }
        if (this.constraints_.size() == 2) {
            if (((Constraint)this.constraints_.get(0)).v().equal(((Constraint)this.constraints_.get(1)).v())) {
                this.constraints_.remove(1);
                this.boundingCircle_ = (Constraint)this.constraints_.get(0);
                return;
            }
            if (((Constraint)this.constraints_.get(0)).v().equal(((Constraint)this.constraints_.get(1)).v().mul(-1.0))) {
                this.constraints_.remove(0);
                this.constraints_.remove(1);
                return;
            }
            Vector3d vector3d = new Vector3d(this.getConstraint(0).v().add(this.getConstraint(1).v()));
            vector3d.normalize();
            if (HTMfunc.verbose) {
                System.out.println("2Constr bounding circle: " + vector3d.toString());
            }
            this.boundingCircle_ = new Constraint(vector3d, 0.0);
        }
        Vector3d vector3d = null;
        Vector3d vector3d2 = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Vector3d> arrayList4 = new ArrayList<Vector3d>();
        int n8 = 0;
        while (n8 < this.constraints_.size() - 1) {
            n7 = 1;
            n6 = n8 + 1;
            while (n6 < this.constraints_.size()) {
                vector3d = this.getConstraint((int)n8).a_.cross(this.getConstraint((int)n6).a_);
                if (vector3d.length() == 0.0) break;
                vector3d.normalize();
                vector3d2 = vector3d.mul(-1.0);
                n5 = 1;
                n4 = 1;
                n3 = 0;
                while (n3 < this.constraints_.size()) {
                    if (n3 != n8 && n3 != n6) {
                        Constraint constraint = this.getConstraint(n3);
                        if (n5 != 0 && vector3d.mul(constraint.a_) <= 0.0) {
                            n5 = 0;
                        }
                        if (n4 != 0 && vector3d2.mul(constraint.a_) <= 0.0) {
                            n4 = 0;
                        }
                        if (n5 == 0 && n4 == 0) break;
                    }
                    ++n3;
                }
                if (n5 != 0) {
                    arrayList4.add(vector3d);
                    arrayList.add(new Integer(n8));
                    arrayList2.add(new Integer(n6));
                    n7 = 0;
                }
                if (n4 != 0) {
                    arrayList4.add(vector3d2);
                    arrayList.add(new Integer(n8));
                    arrayList2.add(new Integer(n6));
                    n7 = 0;
                }
                ++n6;
            }
            if (n7 != 0) {
                arrayList3.add(new Integer(n8));
            }
            ++n8;
        }
        this.corners_.clear();
        this.corners_.add(arrayList4.get(0));
        n8 = (Integer)arrayList.get(0);
        n6 = (Integer)arrayList2.get(0);
        n7 = 0;
        n5 = 0;
        n4 = 0;
        int n9 = 0;
        n3 = 1;
        while (n3 < arrayList.size()) {
            if ((Integer)arrayList.get(n3) == n8) {
                vector3d = (Vector3d)arrayList4.get(n3);
                n7 = (Integer)arrayList2.get(n3);
                n4 = n3;
            }
            if ((Integer)arrayList2.get(n3) == n8) {
                vector3d = (Vector3d)arrayList4.get(n3);
                n7 = (Integer)arrayList.get(n3);
                n4 = n3;
            }
            if ((Integer)arrayList.get(n3) == n6) {
                vector3d2 = (Vector3d)arrayList4.get(n3);
                n5 = (Integer)arrayList2.get(n3);
                n9 = n3;
            }
            if ((Integer)arrayList2.get(n3) == n6) {
                vector3d2 = (Vector3d)arrayList4.get(n3);
                n5 = (Integer)arrayList.get(n3);
                n9 = n3;
            }
            ++n3;
        }
        if (vector3d.sub((Vector3d)arrayList4.get(0)).cross(this.getConstraint((int)n8).a_).mul((Vector3d)arrayList4.get(0)) > 0.0) {
            this.corners_.add(vector3d);
            n2 = n7;
            n = n4;
        } else {
            this.corners_.add(vector3d2);
            n2 = n5;
            n = n9;
        }
        block4: while (n != 0) {
            n3 = 0;
            while (n3 < arrayList.size()) {
                if (n3 != n) {
                    if ((Integer)arrayList.get(n3) == n2) {
                        n = n3;
                        if (n == 0) continue block4;
                        this.corners_.add(arrayList4.get(n3));
                        n2 = (Integer)arrayList2.get(n3);
                        continue block4;
                    }
                    if ((Integer)arrayList2.get(n3) == n2) {
                        n = n3;
                        if (n == 0) continue block4;
                        this.corners_.add(arrayList4.get(n3));
                        n2 = (Integer)arrayList.get(n3);
                        continue block4;
                    }
                }
                ++n3;
            }
        }
        n8 = 0;
        while (n8 < arrayList3.size()) {
            this.constraints_.remove((Integer)arrayList3.get(n8));
            ++n8;
        }
        if (this.constraints_.size() >= 3) {
            this.boundingCircle_ = new Constraint(1.0);
            n8 = 0;
            while (n8 < this.corners_.size()) {
                n6 = n8 + 1;
                while (n6 < this.corners_.size()) {
                    n3 = n6 + 1;
                    while (n3 < this.corners_.size()) {
                        Vector3d vector3d3 = this.getCorner(n6).sub(this.getCorner(n8)).cross(this.getCorner(n3).sub(this.getCorner(n6)));
                        vector3d3.normalize();
                        double d = vector3d3.mul(this.getCorner(n8));
                        if (this.boundingCircle_.d_ > d) {
                            this.boundingCircle_ = new Constraint(vector3d3, d);
                        }
                        ++n3;
                    }
                    ++n6;
                }
                ++n8;
            }
        }
    }

    public void simplify() {
        int n;
        if (this.sign_ == 1) {
            this.simplify0();
            if (HTMfunc.verbose) {
                System.out.println(" simplify0 ");
            }
            return;
        }
        boolean bl = true;
        block5: while (bl) {
            bl = false;
            int n2 = this.constraints_.size();
            n = 0;
            while (n < n2) {
                int n3 = 0;
                while (n3 < n) {
                    block21: {
                        int n4;
                        Constraint constraint;
                        Constraint constraint2;
                        block25: {
                            block27: {
                                block26: {
                                    block22: {
                                        block24: {
                                            block23: {
                                                constraint2 = this.getConstraint(n);
                                                constraint = this.getConstraint(n3);
                                                if (constraint2.sign_ == 1 && constraint.sign_ == 1) break block21;
                                                if (constraint2.sign_ != 2 && constraint2.sign_ != 1 || constraint.sign_ != 2 && constraint.sign_ != 1) break block22;
                                                n4 = this.testConstraints(n, n3);
                                                if (n4 == 0) break block21;
                                                if (n4 < 0) {
                                                    this.constraints_.clear();
                                                    return;
                                                }
                                                if (n4 != 1) break block23;
                                                this.constraints_.remove(n3);
                                                break block24;
                                            }
                                            if (n4 != 2) break block21;
                                            this.constraints_.remove(n);
                                        }
                                        bl = true;
                                        break;
                                        break block21;
                                    }
                                    if (constraint2.sign_ != 0 || constraint.sign_ != 0) break block25;
                                    n4 = this.testConstraints(n, n3);
                                    if (n4 <= 0) break block21;
                                    if (n4 != 1) break block26;
                                    this.constraints_.remove(n3);
                                    break block27;
                                }
                                if (n4 != 2) break block21;
                                this.constraints_.remove(n);
                            }
                            bl = true;
                            break;
                            break block21;
                        }
                        n4 = this.testConstraints(n, n3);
                        if (n4 != 0) {
                            if (n4 < 0) {
                                if (constraint2.sign_ == 0) {
                                    this.constraints_.remove(n);
                                } else {
                                    this.constraints_.remove(n3);
                                }
                                bl = true;
                                break;
                            }
                            if (!(constraint2.sign_ == 0 && n4 == 2 || constraint.sign_ == 0 && n4 == 1)) {
                                this.constraints_.clear();
                                return;
                            }
                        }
                    }
                    ++n3;
                }
                if (bl) continue block5;
                ++n;
            }
        }
        this.sign_ = this.getConstraint((int)0).sign_;
        n = 1;
        while (n < this.constraints_.size()) {
            Constraint constraint = this.getConstraint(n);
            switch (this.sign_) {
                case 0: {
                    if (constraint.sign_ != 2) break;
                    this.sign_ = (short)3;
                    break;
                }
                case 2: {
                    if (constraint.sign_ != 0) break;
                    this.sign_ = (short)3;
                    break;
                }
                case 1: {
                    this.sign_ = constraint.sign_;
                }
            }
            ++n;
        }
    }

    int testConstraints(int n, int n2) {
        double d;
        Constraint constraint = this.getConstraint(n);
        Constraint constraint2 = this.getConstraint(n2);
        double d2 = (constraint.sign_ == 0 ? constraint.a_.mul(-1.0) : constraint.a_).mul(constraint2.sign_ == 0 ? constraint2.a_.mul(-1.0) : constraint2.a_);
        d2 = d2 <= -1.0 + HTMfunc.gEpsilon ? HTMfunc.Pi : Math.acos(d2);
        double d3 = constraint.sign_ == 2 ? constraint.s_ : HTMfunc.Pi - constraint.s_;
        double d4 = d = constraint2.sign_ == 2 ? constraint2.s_ : HTMfunc.Pi - constraint2.s_;
        if (d2 > d3 + d) {
            return -1;
        }
        if (d3 > d2 + d) {
            return 1;
        }
        if (d > d2 + d3) {
            return 2;
        }
        return 0;
    }

    public void intersect(HTMindexImp hTMindexImp, HTMrange hTMrange, boolean bl) {
        if (this.constraints_.size() == 0) {
            return;
        }
        int n = 1;
        while (n <= 8) {
            this.testTrixel(n, hTMindexImp, hTMrange, bl);
            ++n;
        }
    }

    protected void saveTrixel(long l, HTMrange hTMrange, boolean bl) {
        long l2;
        long l3;
        if (bl) {
            hTMrange.mergeRange(l, l);
            return;
        }
        int n = 0;
        while (n < 64) {
            if ((l << n & Long.MIN_VALUE) != 0L) break;
            n += 2;
        }
        int n2 = 64 - n >>> 1;
        if ((n2 -= 2) < this.olevel) {
            int n3 = this.olevel - n2 << 1;
            l3 = l << n3;
            l2 = l3 + (1L << n3) - 1L;
        } else {
            l3 = l2 = l;
        }
        hTMrange.mergeRange(l3, l2);
    }

    short testTrixel(int n, HTMindexImp hTMindexImp, HTMrange hTMrange, boolean bl) {
        QuadNode quadNode = (QuadNode)hTMindexImp.nodes_.get(n);
        short s = this.testNode(n, hTMindexImp);
        switch (s) {
            case 2: {
                long l = quadNode.id_;
                this.saveTrixel(l, hTMrange, bl);
                return s;
            }
            case 3: {
                long l = quadNode.id_;
                return s;
            }
        }
        int n2 = quadNode.childID_[0];
        if (n2 != 0) {
            long l = quadNode.id_;
            n2 = quadNode.childID_[0];
            this.testTrixel(n2, hTMindexImp, hTMrange, bl);
            n2 = quadNode.childID_[1];
            this.testTrixel(n2, hTMindexImp, hTMrange, bl);
            n2 = quadNode.childID_[2];
            this.testTrixel(n2, hTMindexImp, hTMrange, bl);
            n2 = quadNode.childID_[3];
            this.testTrixel(n2, hTMindexImp, hTMrange, bl);
        } else if (hTMindexImp.addlevel_ > 0) {
            this.testPartial(hTMindexImp.addlevel_, quadNode.id_, hTMindexImp.getVertex(quadNode.v_[0]), hTMindexImp.getVertex(quadNode.v_[1]), hTMindexImp.getVertex(quadNode.v_[2]), 0, hTMindexImp, hTMrange, bl);
        } else {
            this.saveTrixel(quadNode.id_, hTMrange, bl);
        }
        return s;
    }

    void testPartial(int n, long l, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n2, HTMindexImp hTMindexImp, HTMrange hTMrange, boolean bl) {
        long l2;
        long[] lArray = new long[4];
        short[] sArray = new short[4];
        int n3 = 0;
        int n4 = 0;
        Vector3d vector3d4 = vector3d2.add(vector3d3);
        vector3d4.normalize();
        Vector3d vector3d5 = vector3d.add(vector3d3);
        vector3d5.normalize();
        Vector3d vector3d6 = vector3d2.add(vector3d);
        vector3d6.normalize();
        lArray[0] = l2 = l << 2;
        lArray[1] = l2 + 1L;
        lArray[2] = l2 + 2L;
        lArray[3] = l2 + 3L;
        sArray[0] = this.testNode(vector3d, vector3d6, vector3d5);
        sArray[1] = this.testNode(vector3d2, vector3d4, vector3d6);
        sArray[2] = this.testNode(vector3d3, vector3d5, vector3d4);
        sArray[3] = this.testNode(vector3d4, vector3d5, vector3d6);
        int n5 = 0;
        while (n5 < 4) {
            if (sArray[n5] == 2) {
                ++n4;
            }
            if (sArray[n5] == 1) {
                ++n3;
            }
            ++n5;
        }
        if (n-- <= 0 || n3 == 4 || n4 >= 2 || n3 == 3 && n4 == 1 || n3 > 1 && n2 == 3) {
            this.saveTrixel(l, hTMrange, bl);
            return;
        }
        int n6 = 0;
        while (n6 < 4) {
            if (sArray[n6] == 2) {
                this.saveTrixel(lArray[n6], hTMrange, bl);
            }
            ++n6;
        }
        if (sArray[0] == 1) {
            this.testPartial(n, lArray[0], vector3d, vector3d6, vector3d5, n3, hTMindexImp, hTMrange, bl);
        }
        if (sArray[1] == 1) {
            this.testPartial(n, lArray[1], vector3d2, vector3d4, vector3d6, n3, hTMindexImp, hTMrange, bl);
        }
        if (sArray[2] == 1) {
            this.testPartial(n, lArray[2], vector3d3, vector3d5, vector3d4, n3, hTMindexImp, hTMrange, bl);
        }
        if (sArray[3] == 1) {
            this.testPartial(n, lArray[3], vector3d4, vector3d5, vector3d6, n3, hTMindexImp, hTMrange, bl);
        }
    }

    short testNode(int n, HTMindexImp hTMindexImp) {
        QuadNode quadNode = hTMindexImp.getNode(n);
        Vector3d vector3d = hTMindexImp.getVertex(quadNode.v_[0]);
        Vector3d vector3d2 = hTMindexImp.getVertex(quadNode.v_[1]);
        Vector3d vector3d3 = hTMindexImp.getVertex(quadNode.v_[2]);
        int n2 = this.testVertex(vector3d) + this.testVertex(vector3d2) + this.testVertex(vector3d3);
        if (HTMfunc.verbose) {
            try {
                System.out.println(HTMfunc.idToName(hTMindexImp.getNode((int)n).id_));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        short s = this.testTriangle(vector3d, vector3d2, vector3d3, n2);
        if (quadNode.childID_[0] == 0 && s == 0) {
            s = 1;
        }
        if (HTMfunc.verbose) {
            System.out.println(" Mark = " + Convex.printMark(s));
            System.out.println(vector3d.toString() + " ; " + vector3d2.toString() + " ; " + vector3d3.toString());
        }
        return s;
    }

    short testNode(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        int n = this.testVertex(vector3d) + this.testVertex(vector3d2) + this.testVertex(vector3d3);
        short s = this.testTriangle(vector3d, vector3d2, vector3d3, n);
        if (s == 0) {
            s = 1;
        }
        return s;
    }

    short testTriangle(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n) {
        if (n == 1 || n == 2) {
            return 1;
        }
        if (n == 3) {
            if (this.sign_ == 2 || this.sign_ == 1) {
                return 2;
            }
            if (this.testHole(vector3d, vector3d2, vector3d3)) {
                return 1;
            }
            if (this.testEdge(vector3d, vector3d2, vector3d3)) {
                return 1;
            }
            return 2;
        }
        if (HTMfunc.verbose) {
            System.out.println(" vsum = 0 ");
        }
        if (!this.testBoundingCircle(vector3d, vector3d2, vector3d3)) {
            return 3;
        }
        if (this.sign_ == 2 || this.sign_ == 3 || this.sign_ == 1 && this.constraints_.size() == 2) {
            if (this.testEdgeConstraint(vector3d, vector3d2, vector3d3, 0)) {
                int n2 = this.testOtherPosNone(vector3d, vector3d2, vector3d3);
                if (n2 > 0) {
                    if (this.testConstraintInside(vector3d, vector3d2, vector3d3, n2)) {
                        return 1;
                    }
                    if (this.getConstraint(n2).contains(vector3d)) {
                        return 1;
                    }
                    return 3;
                }
                if (this.sign_ == 2 || this.sign_ == 1) {
                    return 1;
                }
                return 0;
            }
            if (this.sign_ == 2 || this.sign_ == 1) {
                if (this.testConstraintInside(vector3d, vector3d2, vector3d3, 0)) {
                    return 1;
                }
                return 3;
            }
            return 0;
        }
        if (this.sign_ == 1) {
            if (this.corners_.size() > 0 && this.testEdge0(vector3d, vector3d2, vector3d3)) {
                return 1;
            }
            return 3;
        }
        return 1;
    }

    int testVertex(Vector3d vector3d) {
        int n = 0;
        while (n < this.constraints_.size()) {
            Constraint constraint = this.getConstraint(n);
            if (constraint.a_.mul(vector3d) < constraint.d_) {
                return 0;
            }
            ++n;
        }
        return 1;
    }

    boolean testHole(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        boolean bl = false;
        int n = 0;
        while (n < this.constraints_.size()) {
            Constraint constraint = this.getConstraint(n);
            if (!(constraint.sign_ != 0 || vector3d.cross(vector3d2).mul(constraint.a_) > 0.0 || vector3d2.cross(vector3d3).mul(constraint.a_) > 0.0 || vector3d3.cross(vector3d).mul(constraint.a_) > 0.0)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    boolean testEdge0(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        class EdgeStruct {
            Vector3d e;
            double l;
            Vector3d e1;
            Vector3d e2;
            private final /* synthetic */ Convex this$0;

            EdgeStruct(Convex convex) {
                this.this$0 = convex;
            }
        }
        EdgeStruct[] edgeStructArray = new EdgeStruct[3];
        int n = 0;
        while (n < 3) {
            edgeStructArray[n] = new EdgeStruct(this);
            ++n;
        }
        edgeStructArray[0].e = vector3d.cross(vector3d2);
        edgeStructArray[0].e1 = vector3d;
        edgeStructArray[0].e2 = vector3d2;
        edgeStructArray[1].e = vector3d2.cross(vector3d3);
        edgeStructArray[1].e1 = vector3d2;
        edgeStructArray[1].e2 = vector3d3;
        edgeStructArray[2].e = vector3d3.cross(vector3d);
        edgeStructArray[2].e1 = vector3d3;
        edgeStructArray[2].e2 = vector3d;
        edgeStructArray[0].l = Math.acos(vector3d.mul(vector3d2));
        edgeStructArray[1].l = Math.acos(vector3d2.mul(vector3d3));
        edgeStructArray[2].l = Math.acos(vector3d3.mul(vector3d));
        int n2 = 0;
        while (n2 < this.corners_.size()) {
            int n3 = 0;
            if (n2 < this.corners_.size() - 1) {
                n3 = n2 + 1;
            }
            Vector3d vector3d4 = this.getCorner(n2);
            Vector3d vector3d5 = this.getCorner(n3);
            double d = Math.acos(vector3d4.mul(vector3d5));
            if (HTMfunc.verbose) {
                System.out.println(" corners =  " + this.corners_.size());
            }
            int n4 = 0;
            while (n4 < 3) {
                Vector3d vector3d6 = edgeStructArray[n4].e.cross(vector3d4.cross(vector3d5));
                vector3d6.normalize();
                int n5 = 0;
                while (n5 < 2) {
                    double d2 = Math.acos(vector3d4.mul(vector3d6));
                    double d3 = Math.acos(vector3d5.mul(vector3d6));
                    if (d2 - d <= HTMfunc.gEpsilon && d3 - d <= HTMfunc.gEpsilon) {
                        d2 = Math.acos(edgeStructArray[n4].e1.mul(vector3d6));
                        d3 = Math.acos(edgeStructArray[n4].e2.mul(vector3d6));
                        if (d2 - edgeStructArray[n4].l <= HTMfunc.gEpsilon && d3 - edgeStructArray[n4].l <= HTMfunc.gEpsilon) {
                            return true;
                        }
                    }
                    vector3d6 = vector3d6.mul(-1.0);
                    ++n5;
                }
                ++n4;
            }
            ++n2;
        }
        return this.testVectorInside(vector3d, vector3d2, vector3d3, this.getCorner(0));
    }

    boolean testEdge(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        int n = 0;
        while (n < this.constraints_.size()) {
            if (this.getConstraint((int)n).sign_ == 0) {
                if (this.eSolve(vector3d, vector3d2, n)) {
                    return true;
                }
                if (this.eSolve(vector3d2, vector3d3, n)) {
                    return true;
                }
                if (this.eSolve(vector3d3, vector3d, n)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    boolean eSolve(Vector3d vector3d, Vector3d vector3d2, int n) {
        double d;
        double d2;
        Constraint constraint = this.getConstraint(n);
        double d3 = vector3d.mul(constraint.a_);
        double d4 = vector3d2.mul(constraint.a_);
        double d5 = vector3d.mul(vector3d2);
        double d6 = (1.0 - d5) / (1.0 + d5);
        double d7 = d3 * (d6 - 1.0) + d4 * (d6 + 1.0);
        double d8 = d7 * d7 - 4.0 * (d2 = -d6 * (d3 + constraint.d_)) * (d = d3 - constraint.d_);
        if (d8 < 0.0) {
            return false;
        }
        double d9 = -0.5 * (d7 + (double)(d7 < 0.0 ? -1 : (d7 > 0.0 ? 1 : 0)) * Math.sqrt(d8));
        double d10 = -1.0;
        double d11 = -1.0;
        int n2 = 0;
        if (d2 > HTMfunc.gEpsilon || d2 < -HTMfunc.gEpsilon) {
            d10 = d9 / d2;
            ++n2;
        }
        if (d9 > HTMfunc.gEpsilon || d9 < -HTMfunc.gEpsilon) {
            d11 = d / d9;
            ++n2;
        }
        if (n2 == 0) {
            return false;
        }
        if (d10 >= 0.0 && d10 <= 1.0) {
            return true;
        }
        return n2 == 2 && (d10 >= 0.0 && d10 <= 1.0 || d11 >= 0.0 && d11 <= 1.0);
    }

    boolean testBoundingCircle(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = vector3d2.sub(vector3d).cross(vector3d3.sub(vector3d2));
        vector3d4.normalize();
        double d = Math.acos(vector3d4.mul(vector3d));
        if (this.sign_ == 1) {
            double d2 = vector3d4.mul(this.boundingCircle_.a_);
            double d3 = d2 < -1.0 + HTMfunc.gEpsilon ? HTMfunc.Pi : Math.acos(d2);
            return !(d3 > d + this.boundingCircle_.s_);
        }
        int n = 0;
        while (n < this.constraints_.size()) {
            Constraint constraint = this.getConstraint(n);
            double d4 = vector3d4.mul(constraint.a_);
            double d5 = d4 < -1.0 + HTMfunc.gEpsilon ? HTMfunc.Pi : Math.acos(d4);
            if (d5 > d + constraint.s_) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean testEdgeConstraint(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n) {
        if (this.eSolve(vector3d, vector3d2, n)) {
            return true;
        }
        if (this.eSolve(vector3d2, vector3d3, n)) {
            return true;
        }
        return this.eSolve(vector3d3, vector3d, n);
    }

    int testOtherPosNone(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        int n = 1;
        if (this.constraints_.size() > 1) {
            while (n < this.constraints_.size() && this.getConstraint((int)n).sign_ == 2) {
                if (!this.testEdgeConstraint(vector3d, vector3d2, vector3d3, n)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    boolean testConstraintInside(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int n) {
        return this.testVectorInside(vector3d, vector3d2, vector3d3, this.getConstraint((int)n).a_);
    }

    boolean testVectorInside(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        return !(vector3d.cross(vector3d2).mul(vector3d4) < 0.0) && !(vector3d2.cross(vector3d3).mul(vector3d4) < 0.0) && !(vector3d3.cross(vector3d).mul(vector3d4) < 0.0);
    }

    public Constraint getConstraint(int n) {
        return (Constraint)this.constraints_.get(n);
    }

    public int getNumberOfConstraints() {
        return this.constraints_.size();
    }

    public Vector3d getCorner(int n) {
        return (Vector3d)this.corners_.get(n);
    }

    int NC(HTMindexImp hTMindexImp, int n, int n2) {
        return hTMindexImp.getNode((int)n).childID_[n2];
    }

    public String toString() {
        String string = "#CONVEX\n" + this.constraints_.size() + " " + this.printSign() + '\n';
        int n = 0;
        while (n < this.constraints_.size()) {
            string = string + this.getConstraint(n).toString() + '\n';
            ++n;
        }
        return string;
    }

    public static String printMark(short s) {
        switch (s) {
            case 0: {
                return " dONTKNOW";
            }
            case 1: {
                return " pARTIAL";
            }
            case 2: {
                return " fULL";
            }
            case 3: {
                return " rEJECT";
            }
        }
        return "";
    }

    public void setOlevel(int n) {
        this.olevel = n;
    }

    public int getOlevel() {
        return this.olevel;
    }

    public boolean contains(Vector3d vector3d) {
        boolean bl = false;
        int n = 0;
        while (n < this.constraints_.size()) {
            if (this.getConstraint(n).contains(vector3d)) {
                return true;
            }
            ++n;
        }
        return bl;
    }
}

