# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementDatabaseAdvisorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_database_advisors_list_by_database(self, resource_group):
        response = await self.client.database_advisors.list_by_database(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_database_advisors_get(self, resource_group):
        response = await self.client.database_advisors.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            advisor_name="str",
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_database_advisors_update(self, resource_group):
        response = await self.client.database_advisors.update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            advisor_name="str",
            parameters={
                "advisorStatus": "str",
                "autoExecuteStatus": "str",
                "autoExecuteStatusInheritedFrom": "str",
                "id": "str",
                "kind": "str",
                "lastChecked": "2020-02-20 00:00:00",
                "location": "str",
                "name": "str",
                "recommendationsStatus": "str",
                "recommendedActions": [
                    {
                        "details": {"str": {}},
                        "errorDetails": {"errorCode": "str", "isRetryable": "str"},
                        "estimatedImpact": [
                            {
                                "absoluteValue": 0.0,
                                "changeValueAbsolute": 0.0,
                                "changeValueRelative": 0.0,
                                "dimensionName": "str",
                                "unit": "str",
                            }
                        ],
                        "executeActionDuration": "1 day, 0:00:00",
                        "executeActionInitiatedBy": "str",
                        "executeActionInitiatedTime": "2020-02-20 00:00:00",
                        "executeActionStartTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "implementationDetails": {"method": "str", "script": "str"},
                        "isArchivedAction": bool,
                        "isExecutableAction": bool,
                        "isRevertableAction": bool,
                        "kind": "str",
                        "lastRefresh": "2020-02-20 00:00:00",
                        "linkedObjects": ["str"],
                        "location": "str",
                        "name": "str",
                        "observedImpact": [
                            {
                                "absoluteValue": 0.0,
                                "changeValueAbsolute": 0.0,
                                "changeValueRelative": 0.0,
                                "dimensionName": "str",
                                "unit": "str",
                            }
                        ],
                        "recommendationReason": "str",
                        "revertActionDuration": "1 day, 0:00:00",
                        "revertActionInitiatedBy": "str",
                        "revertActionInitiatedTime": "2020-02-20 00:00:00",
                        "revertActionStartTime": "2020-02-20 00:00:00",
                        "score": 0,
                        "state": {
                            "currentValue": "str",
                            "actionInitiatedBy": "str",
                            "lastModified": "2020-02-20 00:00:00",
                        },
                        "timeSeries": [
                            {
                                "metricName": "str",
                                "startTime": "2020-02-20 00:00:00",
                                "timeGrain": "str",
                                "unit": "str",
                                "value": 0.0,
                            }
                        ],
                        "type": "str",
                        "validSince": "2020-02-20 00:00:00",
                    }
                ],
                "type": "str",
            },
            api_version="2024-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...
