/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Negative binomial distributed pseudorandom numbers.
*
* @module @stdlib/random/base/negative-binomial
*
* @example
* var negativeBinomial = require( '@stdlib/random/base/negative-binomial' );
*
* var v = negativeBinomial( 20, 0.5 );
* // returns <number>
*
* @example
* var factory = require( '@stdlib/random/base/negative-binomial' ).factory;
* var negativeBinomial = factory( 10, 0.3, {
*     'seed': 297
* });
*
* var v = negativeBinomial();
* // returns <number>
*
* @example
* var factory = require( '@stdlib/random/base/negative-binomial' ).factory;
* var negativeBinomial = factory({
*     'seed': 297
* });
*
* var v = negativeBinomial( 10, 0.67 );
* // returns <number>
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-nonenumerable-read-only-property' );
var negativeBinomial = require( './main.js' );
var factory = require( './factory.js' );


// MAIN //

setReadOnly( negativeBinomial, 'factory', factory );


// EXPORTS //

module.exports = negativeBinomial;
