/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/**
* Natural logarithm of the smallest normalized double-precision floating-point number.
*
* @example
* var min = FLOAT64_MIN_LN;
* // returns -708.3964185322641
*/
declare const FLOAT64_MIN_LN: number;


// EXPORTS //

export = FLOAT64_MIN_LN;
