
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsXmlInputAttributes.h
    \\brief Definition of EpsXmlInput Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "EpsXmlInputWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



EpsXmlInputWrapper::EpsXmlInputWrapper(): epsxmlinput_(new EpsXmlInput())


{


	

}
EpsXmlInputWrapper::EpsXmlInputWrapper(EpsXmlInput* epsxmlinput): epsxmlinput_(epsxmlinput)
{

	
}

EpsXmlInputWrapper::~EpsXmlInputWrapper()
{

}

void EpsXmlInputWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("EPSXML_INPUT_FILENAME") ) {
		string path_value = request("EPSXML_INPUT_FILENAME");
		epsxmlinput_->path_ = path_value;
		}
	if  (request.countValues("EPSXML_PARAMETER") ) {
		string param_value = request("EPSXML_PARAMETER");
		epsxmlinput_->param_ = param_value;
		}
	if  (request.countValues("EPSXML_LONG_TITLE") ) {
		string long_title_value = request("EPSXML_LONG_TITLE");
		
		epsxmlinput_->long_title_ = MagTranslator<string, bool>()(long_title_value);
		
		}
	if  (request.countValues("EPSXML_TITLE") ) {
		string short_title_value = request("EPSXML_TITLE");
		
		epsxmlinput_->short_title_ = MagTranslator<string, bool>()(short_title_value);
		
		}
	
	
}

void EpsXmlInputWrapper::print(ostream& out)  const
{
	out << "EpsXmlInputWrapper[]";
}


