
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileCurveAttributes.h
    \brief Definition of Curve Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef CurveAttributes_H
#define CurveAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class CurveAttributes 
{
public:
//  --  constructor
    CurveAttributes();
    
//  --  destructor
    virtual ~CurveAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CurveAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool line_;
	int thickness_;
	bool symbol_;
	int symbol_marker_;
	double symbol_height_;
	bool outline_;
	int outline_thickness_;
	double x_below_;
	double x_above_;
	double y_below_;
	double y_above_;
	string missing_mode_;
	int missing_thickness_;
	string plot_method_;
	string style_setting_;
	string style_key_;
	stringarray style_keys_;
	stringarray style_list_;
	string colour_key_;
	stringarray colour_keys_;
	stringarray colour_list_;
	string thickness_key_;
	stringarray thickness_keys_;
	intarray thickness_list_;
	LineStyle style_;
	unique_ptr<Colour> colour_;
	unique_ptr<Colour> symbol_colour_;
	unique_ptr<Colour> outline_colour_;
	LineStyle outline_style_;
	LineStyle missing_style_;
	unique_ptr<Colour> missing_colour_;
	ListPolicy style_policy_;
	ListPolicy colour_policy_;
	ListPolicy thickness_policy_;
	 

private:
	friend ostream& operator<<(ostream& s,const CurveAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

