/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DetachedDockView;
import com.vldocking.swing.docking.DockTabbedPane;
import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.DockViewTitleBar;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableContainerFactory;
import com.vldocking.swing.docking.FloatingDialog;
import com.vldocking.swing.docking.FloatingDockableContainer;
import com.vldocking.swing.docking.MaximizedDockView;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.docking.TabbedDockView;
import com.vldocking.swing.docking.TabbedDockableContainer;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

public class DefaultDockableContainerFactory
extends DockableContainerFactory {
    @Override
    public SingleDockableContainer createDockableContainer(Dockable dockable, DockableContainerFactory.ParentType parentType) {
        switch (parentType) {
            case PARENT_TABBED_CONTAINER: {
                return new TabbedDockView(dockable);
            }
            case PARENT_DESKTOP: {
                return new MaximizedDockView(dockable);
            }
            case PARENT_SPLIT_CONTAINER: {
                return new DockView(dockable);
            }
            case PARENT_DETACHED_WINDOW: {
                return new DetachedDockView(dockable);
            }
        }
        throw new RuntimeException("Wrong dockable container type");
    }

    @Override
    public TabbedDockableContainer createTabbedDockableContainer() {
        return new DockTabbedPane();
    }

    @Override
    public FloatingDockableContainer createFloatingDockableContainer(Window owner) {
        if (owner instanceof Dialog) {
            return new FloatingDialog((Dialog)owner);
        }
        return new FloatingDialog((Frame)owner);
    }

    @Override
    public DockViewTitleBar createTitleBar() {
        return new DockViewTitleBar();
    }
}

