=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'spec_helper'
require 'json'

# Unit tests for OpenbaoClient::SystemApi
# Automatically generated by openapi-generator (https://openapi-generator.tech)
# Please update as you see appropriate
describe 'SystemApi' do
  before do
    # run before each test
    @api_instance = OpenbaoClient::SystemApi.new
  end

  after do
    # run after each test
  end

  describe 'test an instance of SystemApi' do
    it 'should create an instance of SystemApi' do
      expect(@api_instance).to be_instance_of(OpenbaoClient::SystemApi)
    end
  end

  # unit tests for auditing_calculate_hash
  # @param path The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
  # @param auditing_calculate_hash_request 
  # @param [Hash] opts the optional parameters
  # @return [AuditingCalculateHashResponse]
  describe 'auditing_calculate_hash test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_disable_device
  # Disable the audit device at the given path.
  # @param path The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_disable_device test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_disable_request_header
  # Disable auditing of the given request header.
  # @param header 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_disable_request_header test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_enable_device
  # Enable a new audit device at the supplied path.
  # @param path The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
  # @param auditing_enable_device_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_enable_device test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_enable_request_header
  # Enable auditing of a header.
  # @param header 
  # @param auditing_enable_request_header_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_enable_request_header test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_list_enabled_devices
  # List the enabled audit devices.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_list_enabled_devices test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_list_request_headers
  # List the request headers that are configured to be audited.
  # @param [Hash] opts the optional parameters
  # @return [AuditingListRequestHeadersResponse]
  describe 'auditing_list_request_headers test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auditing_read_request_header_information
  # List the information for the given request header.
  # @param header 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auditing_read_request_header_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_disable_method
  # Disable the auth method at the given auth path
  # @param path The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auth_disable_method test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_enable_method
  # Enables a new auth method.
  # After enabling, the auth method can be accessed and configured via the auth path specified as part of the URL. This auth path will be nested under the auth prefix.  For example, enable the \&quot;foo\&quot; auth method will make it accessible at /auth/foo.
  # @param path The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
  # @param auth_enable_method_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auth_enable_method test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_list_enabled_methods
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auth_list_enabled_methods test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_read_configuration
  # Read the configuration of the auth engine at the given path.
  # @param path The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
  # @param [Hash] opts the optional parameters
  # @return [AuthReadConfigurationResponse]
  describe 'auth_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_read_tuning_information
  # Reads the given auth path&#39;s configuration.
  # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via &#x60;sys/mounts/auth/[auth-path]/tune&#x60;.
  # @param path Tune the configuration parameters for an auth path.
  # @param [Hash] opts the optional parameters
  # @return [AuthReadTuningInformationResponse]
  describe 'auth_read_tuning_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for auth_tune_configuration_parameters
  # Tune configuration parameters for a given auth path.
  # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via &#x60;sys/mounts/auth/[auth-path]/tune&#x60;.
  # @param path Tune the configuration parameters for an auth path.
  # @param auth_tune_configuration_parameters_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'auth_tune_configuration_parameters test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for collect_host_information
  # Information about the host instance that this OpenBao server is running on.
  # Information about the host instance that this OpenBao server is running on.   The information that gets collected includes host hardware information, and CPU,   disk, and memory utilization
  # @param [Hash] opts the optional parameters
  # @return [CollectHostInformationResponse]
  describe 'collect_host_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for collect_in_flight_request_information
  # reports in-flight requests
  # This path responds to the following HTTP methods.   GET /    Returns a map of in-flight requests.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'collect_in_flight_request_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for cors_configure
  # Configure the CORS settings.
  # @param cors_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'cors_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for cors_delete_configuration
  # Remove any CORS settings.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'cors_delete_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for cors_read_configuration
  # Return the current CORS settings.
  # @param [Hash] opts the optional parameters
  # @return [CorsReadConfigurationResponse]
  describe 'cors_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for decode
  # Decodes the encoded token with the otp.
  # @param decode_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'decode test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for encryption_key_configure_rotation
  # @param encryption_key_configure_rotation_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'encryption_key_configure_rotation test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for encryption_key_read_rotation_configuration
  # @param [Hash] opts the optional parameters
  # @return [EncryptionKeyReadRotationConfigurationResponse]
  describe 'encryption_key_read_rotation_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for encryption_key_rotate
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'encryption_key_rotate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for encryption_key_status
  # Provides information about the backend encryption key.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'encryption_key_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_hash
  # @param generate_hash_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateHashResponse]
  describe 'generate_hash test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_hash_with_algorithm
  # @param urlalgorithm Algorithm to use (POST URL parameter)
  # @param generate_hash_with_algorithm_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateHashWithAlgorithmResponse]
  describe 'generate_hash_with_algorithm test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_random
  # @param generate_random_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateRandomResponse]
  describe 'generate_random test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_random_with_bytes
  # @param urlbytes The number of bytes to generate (POST URL parameter)
  # @param generate_random_with_bytes_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateRandomWithBytesResponse]
  describe 'generate_random_with_bytes test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_random_with_source
  # @param source Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
  # @param generate_random_with_source_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateRandomWithSourceResponse]
  describe 'generate_random_with_source test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for generate_random_with_source_and_bytes
  # @param source Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
  # @param urlbytes The number of bytes to generate (POST URL parameter)
  # @param generate_random_with_source_and_bytes_request 
  # @param [Hash] opts the optional parameters
  # @return [GenerateRandomWithSourceAndBytesResponse]
  describe 'generate_random_with_source_and_bytes test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ha_status
  # Check the HA status of an OpenBao cluster
  # @param [Hash] opts the optional parameters
  # @return [HaStatusResponse]
  describe 'ha_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for initialize_system
  # Initialize a new OpenBao instance.
  # The OpenBao instance must not have been previously initialized. The recovery options, as well as the stored shares option, are only available when using OpenBao HSM.
  # @param initialize_system_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'initialize_system test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_count_entities
  # Backwards compatibility is not guaranteed for this API
  # @param [Hash] opts the optional parameters
  # @return [InternalCountEntitiesResponse]
  describe 'internal_count_entities test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_count_requests
  # Backwards compatibility is not guaranteed for this API
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'internal_count_requests test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_count_tokens
  # Backwards compatibility is not guaranteed for this API
  # @param [Hash] opts the optional parameters
  # @return [InternalCountTokensResponse]
  describe 'internal_count_tokens test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_generate_open_api_document
  # @param [Hash] opts the optional parameters
  # @option opts [Boolean] :generic_mount_paths Use generic mount paths
  # @return [nil]
  describe 'internal_generate_open_api_document test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_generate_open_api_document_with_parameters
  # @param internal_generate_open_api_document_with_parameters_request 
  # @param [Hash] opts the optional parameters
  # @option opts [Boolean] :generic_mount_paths Use generic mount paths
  # @return [nil]
  describe 'internal_generate_open_api_document_with_parameters test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_inspect_router
  # Expose the route entry and mount entry tables present in the router
  # @param tag Name of subtree being observed
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'internal_inspect_router test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_ui_list_enabled_feature_flags
  # Lists enabled feature flags.
  # @param [Hash] opts the optional parameters
  # @return [InternalUiListEnabledFeatureFlagsResponse]
  describe 'internal_ui_list_enabled_feature_flags test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_ui_list_enabled_visible_mounts
  # Lists all enabled and visible auth and secrets mounts.
  # @param [Hash] opts the optional parameters
  # @return [InternalUiListEnabledVisibleMountsResponse]
  describe 'internal_ui_list_enabled_visible_mounts test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_ui_list_namespaces
  # Backwards compatibility is not guaranteed for this API
  # @param [Hash] opts the optional parameters
  # @return [InternalUiListNamespacesResponse]
  describe 'internal_ui_list_namespaces test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_ui_read_mount_information
  # Return information about the given mount.
  # @param path The path of the mount.
  # @param [Hash] opts the optional parameters
  # @return [InternalUiReadMountInformationResponse]
  describe 'internal_ui_read_mount_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for internal_ui_read_resultant_acl
  # Backwards compatibility is not guaranteed for this API
  # @param [Hash] opts the optional parameters
  # @return [InternalUiReadResultantAclResponse]
  describe 'internal_ui_read_resultant_acl test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leader_status
  # Returns the high availability status and current leader instance of OpenBao.
  # @param [Hash] opts the optional parameters
  # @return [LeaderStatusResponse]
  describe 'leader_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_count
  # @param [Hash] opts the optional parameters
  # @return [LeasesCountResponse]
  describe 'leases_count test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_force_revoke_lease_with_prefix
  # Revokes all secrets or tokens generated under a given prefix immediately
  # Unlike &#x60;/sys/leases/revoke-prefix&#x60;, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
  # @param prefix The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_force_revoke_lease_with_prefix test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_force_revoke_lease_with_prefix2
  # Revokes all secrets or tokens generated under a given prefix immediately
  # Unlike &#x60;/sys/leases/revoke-prefix&#x60;, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
  # @param prefix The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_force_revoke_lease_with_prefix2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_list
  # @param [Hash] opts the optional parameters
  # @return [LeasesListResponse]
  describe 'leases_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_look_up
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [LeasesLookUpResponse]
  describe 'leases_look_up test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_look_up_with_prefix
  # @param prefix The path to list leases under. Example: \&quot;aws/creds/deploy\&quot;
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [LeasesLookUpWithPrefixResponse]
  describe 'leases_look_up_with_prefix test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_read_lease
  # @param leases_read_lease_request 
  # @param [Hash] opts the optional parameters
  # @return [LeasesReadLeaseResponse]
  describe 'leases_read_lease test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_renew_lease
  # Renews a lease, requesting to extend the lease.
  # @param leases_renew_lease_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_renew_lease test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_renew_lease2
  # Renews a lease, requesting to extend the lease.
  # @param leases_renew_lease2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_renew_lease2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_renew_lease_with_id
  # Renews a lease, requesting to extend the lease.
  # @param url_lease_id The lease identifier to renew. This is included with a lease.
  # @param leases_renew_lease_with_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_renew_lease_with_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_renew_lease_with_id2
  # Renews a lease, requesting to extend the lease.
  # @param url_lease_id The lease identifier to renew. This is included with a lease.
  # @param leases_renew_lease_with_id2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_renew_lease_with_id2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease
  # Revokes a lease immediately.
  # @param leases_revoke_lease_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease2
  # Revokes a lease immediately.
  # @param leases_revoke_lease2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease_with_id
  # Revokes a lease immediately.
  # @param url_lease_id The lease identifier to renew. This is included with a lease.
  # @param leases_revoke_lease_with_id_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease_with_id test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease_with_id2
  # Revokes a lease immediately.
  # @param url_lease_id The lease identifier to renew. This is included with a lease.
  # @param leases_revoke_lease_with_id2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease_with_id2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease_with_prefix
  # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens&#39; path property) generated under a given prefix immediately.
  # @param prefix The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
  # @param leases_revoke_lease_with_prefix_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease_with_prefix test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_revoke_lease_with_prefix2
  # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens&#39; path property) generated under a given prefix immediately.
  # @param prefix The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
  # @param leases_revoke_lease_with_prefix2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_revoke_lease_with_prefix2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for leases_tidy
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'leases_tidy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for locked_users_list
  # Report the locked user count metrics, for this namespace and all child namespaces.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'locked_users_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for locked_users_unlock
  # Unlocks the user with given mount_accessor and alias_identifier
  # @param alias_identifier It is the name of the alias (user). For example, if the alias belongs to userpass backend, the name should be a valid username within userpass auth method. If the alias belongs to an approle auth method, the name should be a valid RoleID
  # @param mount_accessor MountAccessor is the identifier of the mount entry to which the user belongs
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'locked_users_unlock test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_read_verbosity_level
  # Read the log level for all existing loggers.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_read_verbosity_level test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_read_verbosity_level_for
  # Read the log level for a single logger.
  # @param name The name of the logger to be modified.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_read_verbosity_level_for test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_revert_verbosity_level
  # Revert the all loggers to use log level provided in config.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_revert_verbosity_level test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_revert_verbosity_level_for
  # Revert a single logger to use log level provided in config.
  # @param name The name of the logger to be modified.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_revert_verbosity_level_for test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_update_verbosity_level
  # Modify the log level for all existing loggers.
  # @param loggers_update_verbosity_level_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_update_verbosity_level test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for loggers_update_verbosity_level_for
  # Modify the log level of a single logger.
  # @param name The name of the logger to be modified.
  # @param loggers_update_verbosity_level_for_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'loggers_update_verbosity_level_for test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for metrics
  # @param [Hash] opts the optional parameters
  # @option opts [String] :format Format to export metrics into. Currently accepts only \&quot;prometheus\&quot;.
  # @return [nil]
  describe 'metrics test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mfa_validate
  # Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
  # @param mfa_validate_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'mfa_validate test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for monitor
  # @param [Hash] opts the optional parameters
  # @option opts [String] :log_format Output format of logs. Supported values are \&quot;standard\&quot; and \&quot;json\&quot;. The default is \&quot;standard\&quot;.
  # @option opts [String] :log_level Log level to view system logs at. Currently supported values are \&quot;trace\&quot;, \&quot;debug\&quot;, \&quot;info\&quot;, \&quot;warn\&quot;, \&quot;error\&quot;.
  # @return [nil]
  describe 'monitor test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_disable_secrets_engine
  # Disable the mount point specified at the given path.
  # @param path The path to mount to. Example: \&quot;aws/east\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'mounts_disable_secrets_engine test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_enable_secrets_engine
  # Enable a new secrets engine at the given path.
  # @param path The path to mount to. Example: \&quot;aws/east\&quot;
  # @param mounts_enable_secrets_engine_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'mounts_enable_secrets_engine test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_list_secrets_engines
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'mounts_list_secrets_engines test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_read_configuration
  # Read the configuration of the secret engine at the given path.
  # @param path The path to mount to. Example: \&quot;aws/east\&quot;
  # @param [Hash] opts the optional parameters
  # @return [MountsReadConfigurationResponse]
  describe 'mounts_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_read_tuning_information
  # @param path The path to mount to. Example: \&quot;aws/east\&quot;
  # @param [Hash] opts the optional parameters
  # @return [MountsReadTuningInformationResponse]
  describe 'mounts_read_tuning_information test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for mounts_tune_configuration_parameters
  # @param path The path to mount to. Example: \&quot;aws/east\&quot;
  # @param mounts_tune_configuration_parameters_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'mounts_tune_configuration_parameters test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_list_plugins
  # @param [Hash] opts the optional parameters
  # @return [PluginsCatalogListPluginsResponse]
  describe 'plugins_catalog_list_plugins test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_list_plugins_with_type
  # List the plugins in the catalog.
  # @param type The type of the plugin, may be auth, secret, or database
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PluginsCatalogListPluginsWithTypeResponse]
  describe 'plugins_catalog_list_plugins_with_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_read_plugin_configuration
  # Return the configuration data for the plugin with the given name.
  # @param name The name of the plugin
  # @param [Hash] opts the optional parameters
  # @return [PluginsCatalogReadPluginConfigurationResponse]
  describe 'plugins_catalog_read_plugin_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_read_plugin_configuration_with_type
  # Return the configuration data for the plugin with the given name.
  # @param name The name of the plugin
  # @param type The type of the plugin, may be auth, secret, or database
  # @param [Hash] opts the optional parameters
  # @return [PluginsCatalogReadPluginConfigurationWithTypeResponse]
  describe 'plugins_catalog_read_plugin_configuration_with_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_register_plugin
  # Register a new plugin, or updates an existing one with the supplied name.
  # @param name The name of the plugin
  # @param plugins_catalog_register_plugin_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'plugins_catalog_register_plugin test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_register_plugin_with_type
  # Register a new plugin, or updates an existing one with the supplied name.
  # @param name The name of the plugin
  # @param type The type of the plugin, may be auth, secret, or database
  # @param plugins_catalog_register_plugin_with_type_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'plugins_catalog_register_plugin_with_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_remove_plugin
  # Remove the plugin with the given name.
  # @param name The name of the plugin
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'plugins_catalog_remove_plugin test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_catalog_remove_plugin_with_type
  # Remove the plugin with the given name.
  # @param name The name of the plugin
  # @param type The type of the plugin, may be auth, secret, or database
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'plugins_catalog_remove_plugin_with_type test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for plugins_reload_backends
  # Reload mounted plugin backends.
  # Either the plugin name (&#x60;plugin&#x60;) or the desired plugin backend mounts (&#x60;mounts&#x60;) must be provided, but not both. In the case that the plugin name is provided, all mounted paths that use that plugin backend will be reloaded.  If (&#x60;scope&#x60;) is provided and is (&#x60;global&#x60;), the plugin(s) are reloaded globally.
  # @param plugins_reload_backends_request 
  # @param [Hash] opts the optional parameters
  # @return [PluginsReloadBackendsResponse]
  describe 'plugins_reload_backends test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_delete_acl_policy
  # Delete the ACL policy with the given name.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_delete_acl_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_delete_acl_policy2
  # Delete the policy with the given name.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_delete_acl_policy2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_delete_password_policy
  # Delete a password policy.
  # @param name The name of the password policy.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_delete_password_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_generate_password_from_password_policy
  # Generate a password from an existing password policy.
  # @param name The name of the password policy.
  # @param [Hash] opts the optional parameters
  # @return [PoliciesGeneratePasswordFromPasswordPolicyResponse]
  describe 'policies_generate_password_from_password_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_list
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [PoliciesListResponse]
  describe 'policies_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_list_acl_policies
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PoliciesListAclPoliciesResponse]
  describe 'policies_list_acl_policies test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_list_password_policies
  # List the existing password policies.
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [PoliciesListPasswordPoliciesResponse]
  describe 'policies_list_password_policies test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_read_acl_policy
  # Retrieve information about the named ACL policy.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [PoliciesReadAclPolicyResponse]
  describe 'policies_read_acl_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_read_acl_policy2
  # Retrieve the policy body for the named policy.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param [Hash] opts the optional parameters
  # @return [PoliciesReadAclPolicy2Response]
  describe 'policies_read_acl_policy2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_read_password_policy
  # Retrieve an existing password policy.
  # @param name The name of the password policy.
  # @param [Hash] opts the optional parameters
  # @return [PoliciesReadPasswordPolicyResponse]
  describe 'policies_read_password_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_write_acl_policy
  # Add a new or update an existing ACL policy.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param policies_write_acl_policy_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_write_acl_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_write_acl_policy2
  # Add a new or update an existing policy.
  # @param name The name of the policy. Example: \&quot;ops\&quot;
  # @param policies_write_acl_policy2_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_write_acl_policy2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for policies_write_password_policy
  # Add a new or update an existing password policy.
  # @param name The name of the password policy.
  # @param policies_write_password_policy_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'policies_write_password_policy test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_blocking
  # Returns stack traces that led to blocking on synchronization primitives
  # Returns stack traces that led to blocking on synchronization primitives
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_blocking test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_command_line
  # Returns the running program&#39;s command line.
  # Returns the running program&#39;s command line, with arguments separated by NUL bytes.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_command_line test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_cpu_profile
  # Returns a pprof-formatted cpu profile payload.
  # Returns a pprof-formatted cpu profile payload. Profiling lasts for duration specified in seconds GET parameter, or for 30 seconds if not specified.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_cpu_profile test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_execution_trace
  # Returns the execution trace in binary form.
  # Returns  the execution trace in binary form. Tracing lasts for duration specified in seconds GET parameter, or for 1 second if not specified.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_execution_trace test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_goroutines
  # Returns stack traces of all current goroutines.
  # Returns stack traces of all current goroutines.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_goroutines test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_index
  # Returns an HTML page listing the available profiles.
  # Returns an HTML page listing the available  profiles. This should be mainly accessed via browsers or applications that can  render pages.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_index test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_memory_allocations
  # Returns a sampling of all past memory allocations.
  # Returns a sampling of all past memory allocations.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_memory_allocations test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_memory_allocations_live
  # Returns a sampling of memory allocations of live object.
  # Returns a sampling of memory allocations of live object.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_memory_allocations_live test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_mutexes
  # Returns stack traces of holders of contended mutexes
  # Returns stack traces of holders of contended mutexes
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_mutexes test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_symbols
  # Returns the program counters listed in the request.
  # Returns the program counters listed in the request.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_symbols test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for pprof_thread_creations
  # Returns stack traces that led to the creation of new OS threads
  # Returns stack traces that led to the creation of new OS threads
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'pprof_thread_creations test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for query_token_accessor_capabilities
  # @param query_token_accessor_capabilities_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'query_token_accessor_capabilities test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for query_token_capabilities
  # @param query_token_capabilities_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'query_token_capabilities test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for query_token_self_capabilities
  # @param query_token_self_capabilities_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'query_token_self_capabilities test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_configure
  # @param rate_limit_quotas_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rate_limit_quotas_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_delete
  # @param name Name of the quota rule.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rate_limit_quotas_delete test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_list
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [RateLimitQuotasListResponse]
  describe 'rate_limit_quotas_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_read
  # @param name Name of the quota rule.
  # @param [Hash] opts the optional parameters
  # @return [RateLimitQuotasReadResponse]
  describe 'rate_limit_quotas_read test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_read_configuration
  # @param [Hash] opts the optional parameters
  # @return [RateLimitQuotasReadConfigurationResponse]
  describe 'rate_limit_quotas_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rate_limit_quotas_write
  # @param name Name of the quota rule.
  # @param rate_limit_quotas_write_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rate_limit_quotas_write test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_delete
  # Delete the key with given path.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'raw_delete test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_delete_path
  # Delete the key with given path.
  # @param path 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'raw_delete_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_read
  # Read the value of the key at the given path.
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [RawReadResponse]
  describe 'raw_read test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_read_path
  # Read the value of the key at the given path.
  # @param path 
  # @param [Hash] opts the optional parameters
  # @option opts [String] :list Return a list if &#x60;true&#x60;
  # @return [RawReadPathResponse]
  describe 'raw_read_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_write
  # Update the value of the key at the given path.
  # @param raw_write_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'raw_write test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for raw_write_path
  # Update the value of the key at the given path.
  # @param path 
  # @param raw_write_path_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'raw_write_path test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for read_health_status
  # Returns the health status of OpenBao.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'read_health_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for read_initialization_status
  # Returns the initialization status of OpenBao.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'read_initialization_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for read_sanitized_configuration_state
  # Return a sanitized version of the OpenBao server configuration.
  # The sanitized output strips configuration values in the storage, HA storage, and seals stanzas, which may contain sensitive values such as API tokens. It also removes any token or secret fields in other stanzas, such as the circonus_api_token from telemetry.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'read_sanitized_configuration_state test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for read_wrapping_properties
  # Look up wrapping properties for the given token.
  # @param read_wrapping_properties_request 
  # @param [Hash] opts the optional parameters
  # @return [ReadWrappingPropertiesResponse]
  describe 'read_wrapping_properties test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for read_wrapping_properties2
  # Look up wrapping properties for the requester&#39;s token.
  # @param [Hash] opts the optional parameters
  # @return [ReadWrappingProperties2Response]
  describe 'read_wrapping_properties2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_attempt_cancel
  # Cancels any in-progress rekey.
  # This clears the rekey settings as well as any progress made. This must be called to change the parameters of the rekey. Note: verification is still a part of a rekey. If rekeying is canceled during the verification flow, the current unseal keys remain valid.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rekey_attempt_cancel test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_attempt_initialize
  # Initializes a new rekey attempt.
  # Only a single rekey attempt can take place at a time, and changing the parameters of a rekey requires canceling and starting a new rekey, which will also provide a new nonce.
  # @param rekey_attempt_initialize_request 
  # @param [Hash] opts the optional parameters
  # @return [RekeyAttemptInitializeResponse]
  describe 'rekey_attempt_initialize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_attempt_read_progress
  # Reads the configuration and progress of the current rekey attempt.
  # @param [Hash] opts the optional parameters
  # @return [RekeyAttemptReadProgressResponse]
  describe 'rekey_attempt_read_progress test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_attempt_update
  # Enter a single unseal key share to progress the rekey of the OpenBao.
  # @param rekey_attempt_update_request 
  # @param [Hash] opts the optional parameters
  # @return [RekeyAttemptUpdateResponse]
  describe 'rekey_attempt_update test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_delete_backup_key
  # Delete the backup copy of PGP-encrypted unseal keys.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rekey_delete_backup_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_delete_backup_recovery_key
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rekey_delete_backup_recovery_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_read_backup_key
  # Return the backup copy of PGP-encrypted unseal keys.
  # @param [Hash] opts the optional parameters
  # @return [RekeyReadBackupKeyResponse]
  describe 'rekey_read_backup_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_read_backup_recovery_key
  # @param [Hash] opts the optional parameters
  # @return [RekeyReadBackupRecoveryKeyResponse]
  describe 'rekey_read_backup_recovery_key test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_verification_cancel
  # Cancel any in-progress rekey verification operation.
  # This clears any progress made and resets the nonce. Unlike a &#x60;DELETE&#x60; against &#x60;sys/rekey/init&#x60;, this only resets the current verification operation, not the entire rekey atttempt.
  # @param [Hash] opts the optional parameters
  # @return [RekeyVerificationCancelResponse]
  describe 'rekey_verification_cancel test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_verification_read_progress
  # Read the configuration and progress of the current rekey verification attempt.
  # @param [Hash] opts the optional parameters
  # @return [RekeyVerificationReadProgressResponse]
  describe 'rekey_verification_read_progress test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rekey_verification_update
  # Enter a single new key share to progress the rekey verification operation.
  # @param rekey_verification_update_request 
  # @param [Hash] opts the optional parameters
  # @return [RekeyVerificationUpdateResponse]
  describe 'rekey_verification_update test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for reload_subsystem
  # Reload the given subsystem
  # @param subsystem 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'reload_subsystem test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for remount
  # Initiate a mount migration
  # @param remount_request 
  # @param [Hash] opts the optional parameters
  # @return [RemountResponse]
  describe 'remount test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for remount_status
  # Check status of a mount migration
  # @param migration_id The ID of the migration operation
  # @param [Hash] opts the optional parameters
  # @return [RemountStatusResponse]
  describe 'remount_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for rewrap
  # @param rewrap_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'rewrap test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_cancel
  # Cancels any in-progress root generation attempt.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'root_token_generation_cancel test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_cancel2
  # Cancels any in-progress root generation attempt.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'root_token_generation_cancel2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_initialize
  # Initializes a new root generation attempt.
  # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
  # @param root_token_generation_initialize_request 
  # @param [Hash] opts the optional parameters
  # @return [RootTokenGenerationInitializeResponse]
  describe 'root_token_generation_initialize test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_initialize2
  # Initializes a new root generation attempt.
  # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
  # @param root_token_generation_initialize2_request 
  # @param [Hash] opts the optional parameters
  # @return [RootTokenGenerationInitialize2Response]
  describe 'root_token_generation_initialize2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_read_progress
  # Read the configuration and progress of the current root generation attempt.
  # @param [Hash] opts the optional parameters
  # @return [RootTokenGenerationReadProgressResponse]
  describe 'root_token_generation_read_progress test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_read_progress2
  # Read the configuration and progress of the current root generation attempt.
  # @param [Hash] opts the optional parameters
  # @return [RootTokenGenerationReadProgress2Response]
  describe 'root_token_generation_read_progress2 test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for root_token_generation_update
  # Enter a single unseal key share to progress the root generation attempt.
  # If the threshold number of unseal key shares is reached, OpenBao will complete the root generation and issue the new token. Otherwise, this API must be called multiple times until that threshold is met. The attempt nonce must be provided with each call.
  # @param root_token_generation_update_request 
  # @param [Hash] opts the optional parameters
  # @return [RootTokenGenerationUpdateResponse]
  describe 'root_token_generation_update test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for seal
  # Seal the OpenBao instance.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'seal test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for seal_status
  # Check the seal status of an OpenBao instance.
  # @param [Hash] opts the optional parameters
  # @return [SealStatusResponse]
  describe 'seal_status test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for step_down_leader
  # Cause the node to give up active status.
  # This endpoint forces the node to give up active status. If the node does not have active status, this endpoint does nothing. Note that the node will sleep for ten seconds before attempting to grab the active lock again, but if no standby nodes grab the active lock in the interim, the same node may become the active node again.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'step_down_leader test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ui_headers_configure
  # Configure the values to be returned for the UI header.
  # @param header The name of the header.
  # @param ui_headers_configure_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ui_headers_configure test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ui_headers_delete_configuration
  # Remove a UI header.
  # @param header The name of the header.
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'ui_headers_delete_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ui_headers_list
  # Return a list of configured UI headers.
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [UiHeadersListResponse]
  describe 'ui_headers_list test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for ui_headers_read_configuration
  # Return the given UI header&#39;s configuration
  # @param header The name of the header.
  # @param [Hash] opts the optional parameters
  # @return [UiHeadersReadConfigurationResponse]
  describe 'ui_headers_read_configuration test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for unseal
  # Unseal the OpenBao instance.
  # @param unseal_request 
  # @param [Hash] opts the optional parameters
  # @return [UnsealResponse]
  describe 'unseal test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for unwrap
  # @param unwrap_request 
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'unwrap test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for version_history
  # Returns map of historical version change entries
  # @param list Must be set to &#x60;true&#x60;
  # @param [Hash] opts the optional parameters
  # @return [VersionHistoryResponse]
  describe 'version_history test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

  # unit tests for wrap
  # @param [Hash] opts the optional parameters
  # @return [nil]
  describe 'wrap test' do
    it 'should work' do
      # assertion here. ref: https://rspec.info/features/3-12/rspec-expectations/built-in-matchers/
    end
  end

end
