/*
 * --- GSMP-COPYRIGHT-NOTE-BEGIN ---
 * 
 * This copyright note is auto-generated by ./scripts/Create-CopyPatch.
 * Please add additional copyright information _after_ the line containing
 * the GSMP-COPYRIGHT-NOTE-END tag. Otherwise it might get removed by
 * the ./scripts/Create-CopyPatch script. Do not edit this copyright text!
 * 
 * GSMP: utility/tests/Logging.cc
 * General Sound Manipulation Program is Copyright (C) 2000 - 2004
 *   Valentin Ziegler and René Rebe
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2. A copy of the GNU General
 * Public License can be found in the file LICENSE.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
 * ABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * --- GSMP-COPYRIGHT-NOTE-END ---
 */
#include "Logger.hh"

using namespace Utility;
using namespace std;

class stdoutLogDestinationConfig : public LogDestinationConfig
{
public:
  static const bool echo_log_stdout = true;
  static const bool log_to_file = false;
};

class bothLogDestinationsConfig : public LogDestinationConfig
{
public:
  static const bool echo_log_stdout = true;
};


typedef stdoutLogDestinationConfig SC;
typedef bothLogDestinationsConfig BC;
typedef LogDestinationConfig LC;


ofstream lfile ("test.log");
LogDevice <> logA (lfile);
LogDevice <> logB;

LogDestination <LogDestinationConfig, LogDeviceConfig> logDst ("test", logB);

class ObjWLog
{
public:
  ObjWLog ()
    : m_logger (logDst, this)
  { }

  ObjectLogger <LogDestinationConfig, LogDeviceConfig, WL_Verbose, ObjWLog> m_logger;
};


int main ()
{

  logA.SplitLog <LC> () << "This should be file only" << endl;
  logA.SplitLog <SC> () << "This should be stdout only" << endl;
  logA.SplitLog <BC> () << "This should be both file and stdout" << endl;
  logA.SplitLog <BC> () << "There should be no timestamp..." << endl;
  logA.SplitLog <BC> () << "... here neither" << endl;
  logB.SplitLog <LC> () << "but here..." << endl;
  logB.SplitLog <BC> () << "stdout only" << endl;
  logB.SplitLog <SC> () << "stdout only" << endl;



  logA.NoLogFile ();
  logB.SwitchLogFile (lfile);

  logA.SplitLog <LC> () << "file (not really)" << endl;
  logA.SplitLog <SC> () << "stdout" << endl;
  logA.SplitLog <BC> () << "both (means stdout)" << endl;
  logB.SplitLog <LC> () << "file" << endl;
  logB.SplitLog <BC> () << "both" << endl;
  logB.SplitLog <SC> () << "stdout" << endl;


 
  logDst.Log () << "logging" << endl;
  logDst.Warn () << "warning" << endl;

  Logger <LogDestinationConfig, LogDeviceConfig, WL_Verbose> logger (logDst);
  
  Q_LOG(logger) << "logger logging" << endl;
  Q_WARN(logger) << "logger warning" << endl;

  ObjWLog ol;
  Q_LOG(ol.m_logger) << "some logging" << endl;
  Q_WARN(ol.m_logger) << "some warning" << endl;

  return 0;
};
