/*******************************************************************************
 * Copyright (c) 2010 Google, Inc and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * 	  Sergey Prigogin (Google) - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.debug.core.sourcelookup;

import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;

/**
 * A source container that maps some filesystem locations to other filesystem locations.
 * @since 7.1
 */
public interface IMappingSourceContainer extends ISourceContainer {

	/**
	 * Returns path to the file as it appears in the debug information generated by the C/C++
	 * compiler.
	 * @param sourceName absolute filesystem path to a source or header file.
	 * @return path to the file as it appears in the debug information generated by the compiler.
	 */
	public IPath getCompilationPath(String sourceName);
}