/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tools.pixelprobe;

/**
 * This enum contains the list of blending modes commonly supported
 * by graphics applications and image formats.
 */
public enum BlendMode {
    PASS_THROUGH,
    NORMAL,
    DISSOLVE,
    DARKEN,
    MULTIPLY,
    COLOR_BURN,
    LINEAR_BURN,
    DARKER_COLOR,
    LIGHTEN,
    SCREEN,
    COLOR_DODGE,
    LINEAR_DODGE,
    LIGHTER_COLOR,
    OVERLAY,
    SOFT_LIGHT,
    HARD_LIGHT,
    VIVID_LIGHT,
    LINEAR_LIGHT,
    PIN_LIGHT,
    HARD_MIX,
    DIFFERENCE,
    EXCLUSION,
    SUBTRACT,
    DIVIDE,
    HUE,
    SATURATION,
    COLOR,
    LUMINOSITY
}
