/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.closurerunner;

import com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;
import org.angularjs.closurerunner.MinerrPass;

public class NgClosureRunner
extends CommandLineRunner {
    private boolean minerrPass;
    private String minerrErrors;
    private String minerrUrl;
    private String minerrSeparator;
    private String minerrJsResourcePath;
    private Compiler cachedCompiler;

    protected NgClosureRunner(String[] args, boolean minerrPass, String minerrErrors, String minerrUrl, String minerrSeparator, String minerrJsResourcePath) {
        super(args);
        this.minerrPass = minerrPass;
        this.minerrSeparator = minerrSeparator;
        this.minerrJsResourcePath = minerrJsResourcePath;
        this.minerrErrors = minerrErrors != null ? minerrErrors : "errors.json";
        this.minerrUrl = minerrUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTextResource(String asset) throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(asset);
        int size = stream.available();
        Scanner input = new Scanner(stream);
        StringBuilder buf = new StringBuilder(size);
        String lineSeparator = System.getProperty("line.separator");
        try {
            while (input.hasNextLine()) {
                buf.append(input.nextLine() + lineSeparator);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            input.close();
        }
    }

    private CompilerPass createMinerrPass() throws IOException {
        Compiler compiler = this.createCompiler();
        PrintStream output = new PrintStream(this.minerrErrors);
        String code = this.loadTextResource(this.minerrJsResourcePath);
        if (this.minerrUrl != null) {
            return new MinerrPass((AbstractCompiler)compiler, output, MinerrPass.substituteInCode(code, this.minerrUrl, this.minerrSeparator));
        }
        return new MinerrPass((AbstractCompiler)compiler, output);
    }

    protected CompilerOptions createOptions() {
        CompilerOptions options = super.createOptions();
        if (this.minerrPass) {
            if (options.customPasses == null) {
                options.customPasses = ArrayListMultimap.create();
            }
            try {
                options.customPasses.put((Object)CustomPassExecutionTime.BEFORE_OPTIMIZATIONS, (Object)this.createMinerrPass());
            }
            catch (IOException e) {
                System.err.println(e);
                System.exit(1);
            }
        }
        return options;
    }

    protected Compiler createCompiler() {
        if (this.cachedCompiler != null) {
            return this.cachedCompiler;
        }
        this.cachedCompiler = super.createCompiler();
        return this.cachedCompiler;
    }

    public static void main(String[] args) {
        boolean minerrPass = false;
        String minerrErrors = "errors.json";
        String minerrUrl = null;
        String minerrSeparator = "/";
        String minerrJsResourcePath = "minErr.js";
        ArrayList<String> passthruArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--minerr_pass")) {
                minerrPass = true;
                continue;
            }
            if (arg.equals("--minerr_errors")) {
                minerrErrors = args[++i];
                continue;
            }
            if (arg.equals("--minerr_url")) {
                minerrUrl = args[++i];
                continue;
            }
            if (arg.equals("--minerr_separate_with_colon")) {
                minerrSeparator = ":";
                continue;
            }
            if (arg.equals("--minerr_js_resource_path")) {
                minerrJsResourcePath = args[++i];
                continue;
            }
            passthruArgs.add(arg);
        }
        NgClosureRunner runner = new NgClosureRunner(passthruArgs.toArray(new String[0]), minerrPass, minerrErrors, minerrUrl, minerrSeparator, minerrJsResourcePath);
        if (runner.shouldRunCompiler()) {
            runner.run();
        } else {
            System.exit(-1);
        }
    }
}

