static PyMethodDef methods_cv[] = {
    {"AKAZE_create", (PyCFunction)pyopencv_cv_AKAZE_create, METH_VARARGS | METH_KEYWORDS, "AKAZE_create([, descriptor_type[, descriptor_size[, descriptor_channels[, threshold[, nOctaves[, nOctaveLayers[, diffusivity]]]]]]]) -> retval\n.   @brief The AKAZE constructor\n.   \n.   @param descriptor_type Type of the extracted descriptor: DESCRIPTOR_KAZE,\n.   DESCRIPTOR_KAZE_UPRIGHT, DESCRIPTOR_MLDB or DESCRIPTOR_MLDB_UPRIGHT.\n.   @param descriptor_size Size of the descriptor in bits. 0 -\\> Full size\n.   @param descriptor_channels Number of channels in the descriptor (1, 2, 3)\n.   @param threshold Detector response threshold to accept point\n.   @param nOctaves Maximum octave evolution of the image\n.   @param nOctaveLayers Default number of sublevels per scale level\n.   @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.   DIFF_CHARBONNIER"},
    {"AgastFeatureDetector_create", (PyCFunction)pyopencv_cv_AgastFeatureDetector_create, METH_VARARGS | METH_KEYWORDS, "AgastFeatureDetector_create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"BFMatcher_create", (PyCFunction)pyopencv_cv_BFMatcher_create, METH_VARARGS | METH_KEYWORDS, "BFMatcher_create([, normType[, crossCheck]]) -> retval\n.   @brief Brute-force matcher create method.\n.   @param normType One of NORM_L1, NORM_L2, NORM_HAMMING, NORM_HAMMING2. L1 and L2 norms are\n.   preferable choices for SIFT and SURF descriptors, NORM_HAMMING should be used with ORB, BRISK and\n.   BRIEF, NORM_HAMMING2 should be used with ORB when WTA_K==3 or 4 (see ORB::ORB constructor\n.   description).\n.   @param crossCheck If it is false, this is will be default BFMatcher behaviour when it finds the k\n.   nearest neighbors for each query descriptor. If crossCheck==true, then the knnMatch() method with\n.   k=1 will only return pairs (i,j) such that for i-th query descriptor the j-th descriptor in the\n.   matcher's collection is the nearest and vice versa, i.e. the BFMatcher will only return consistent\n.   pairs. Such technique usually produces best results with minimal number of outliers when there are\n.   enough matches. This is alternative to the ratio test, used by D. Lowe in SIFT paper."},
    {"BRISK_create", (PyCFunction)pyopencv_cv_BRISK_create, METH_VARARGS | METH_KEYWORDS, "BRISK_create([, thresh[, octaves[, patternScale]]]) -> retval\n.   @brief The BRISK constructor\n.   \n.   @param thresh AGAST detection threshold score.\n.   @param octaves detection octaves. Use 0 to do single scale.\n.   @param patternScale apply this scale to the pattern used for sampling the neighbourhood of a\n.   keypoint.\n\n\n\nBRISK_create(radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern\n.   \n.   @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.   keypoint scale 1).\n.   @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.   size as radiusList..\n.   @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.   scale 1).\n.   @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.   keypoint scale 1).\n.   @param indexChange index remapping of the bits.\n\n\n\nBRISK_create(thresh, octaves, radiusList, numberList[, dMax[, dMin[, indexChange]]]) -> retval\n.   @brief The BRISK constructor for a custom pattern, detection threshold and octaves\n.   \n.   @param thresh AGAST detection threshold score.\n.   @param octaves detection octaves. Use 0 to do single scale.\n.   @param radiusList defines the radii (in pixels) where the samples around a keypoint are taken (for\n.   keypoint scale 1).\n.   @param numberList defines the number of sampling points on the sampling circle. Must be the same\n.   size as radiusList..\n.   @param dMax threshold for the short pairings used for descriptor formation (in pixels for keypoint\n.   scale 1).\n.   @param dMin threshold for the long pairings used for orientation determination (in pixels for\n.   keypoint scale 1).\n.   @param indexChange index remapping of the bits."},
    {"CamShift", (PyCFunction)pyopencv_cv_CamShift, METH_VARARGS | METH_KEYWORDS, "CamShift(probImage, window, criteria) -> retval, window\n.   @brief Finds an object center, size, and orientation.\n.   \n.   @param probImage Back projection of the object histogram. See calcBackProject.\n.   @param window Initial search window.\n.   @param criteria Stop criteria for the underlying meanShift.\n.   returns\n.   (in old interfaces) Number of iterations CAMSHIFT took to converge\n.   The function implements the CAMSHIFT object tracking algorithm @cite Bradski98 . First, it finds an\n.   object center using meanShift and then adjusts the window size and finds the optimal rotation. The\n.   function returns the rotated rectangle structure that includes the object position, size, and\n.   orientation. The next position of the search window can be obtained with RotatedRect::boundingRect()\n.   \n.   See the OpenCV sample camshiftdemo.c that tracks colored objects.\n.   \n.   @note\n.   -   (Python) A sample explaining the camshift tracking algorithm can be found at\n.   opencv_source_code/samples/python/camshift.py"},
    {"Canny", (PyCFunction)pyopencv_cv_Canny, METH_VARARGS | METH_KEYWORDS, "Canny(image, threshold1, threshold2[, edges[, apertureSize[, L2gradient]]]) -> edges\n.   @brief Finds edges in an image using the Canny algorithm @cite Canny86 .\n.   \n.   The function finds edges in the input image and marks them in the output map edges using the\n.   Canny algorithm. The smallest value between threshold1 and threshold2 is used for edge linking. The\n.   largest value is used to find initial segments of strong edges. See\n.   <http://en.wikipedia.org/wiki/Canny_edge_detector>\n.   \n.   @param image 8-bit input image.\n.   @param edges output edge map; single channels 8-bit image, which has the same size as image .\n.   @param threshold1 first threshold for the hysteresis procedure.\n.   @param threshold2 second threshold for the hysteresis procedure.\n.   @param apertureSize aperture size for the Sobel operator.\n.   @param L2gradient a flag, indicating whether a more accurate \\f$L_2\\f$ norm\n.   \\f$=\\sqrt{(dI/dx)^2 + (dI/dy)^2}\\f$ should be used to calculate the image gradient magnitude (\n.   L2gradient=true ), or whether the default \\f$L_1\\f$ norm \\f$=|dI/dx|+|dI/dy|\\f$ is enough (\n.   L2gradient=false ).\n\n\n\nCanny(dx, dy, threshold1, threshold2[, edges[, L2gradient]]) -> edges\n.   \\overload\n.   \n.   Finds edges in an image using the Canny algorithm with custom image gradient.\n.   \n.   @param dx 16-bit x derivative of input image (CV_16SC1 or CV_16SC3).\n.   @param dy 16-bit y derivative of input image (same type as dx).\n.   @param edges output edge map; single channels 8-bit image, which has the same size as image .\n.   @param threshold1 first threshold for the hysteresis procedure.\n.   @param threshold2 second threshold for the hysteresis procedure.\n.   @param L2gradient a flag, indicating whether a more accurate \\f$L_2\\f$ norm\n.   \\f$=\\sqrt{(dI/dx)^2 + (dI/dy)^2}\\f$ should be used to calculate the image gradient magnitude (\n.   L2gradient=true ), or whether the default \\f$L_1\\f$ norm \\f$=|dI/dx|+|dI/dy|\\f$ is enough (\n.   L2gradient=false )."},
    {"CascadeClassifier_convert", (PyCFunction)pyopencv_cv_CascadeClassifier_convert, METH_VARARGS | METH_KEYWORDS, "CascadeClassifier_convert(oldcascade, newcascade) -> retval\n."},
    {"DescriptorMatcher_create", (PyCFunction)pyopencv_cv_DescriptorMatcher_create, METH_VARARGS | METH_KEYWORDS, "DescriptorMatcher_create(descriptorMatcherType) -> retval\n.   @brief Creates a descriptor matcher of a given type with the default parameters (using default\n.   constructor).\n.   \n.   @param descriptorMatcherType Descriptor matcher type. Now the following matcher types are\n.   supported:\n.   -   `BruteForce` (it uses L2 )\n.   -   `BruteForce-L1`\n.   -   `BruteForce-Hamming`\n.   -   `BruteForce-Hamming(2)`\n.   -   `FlannBased`\n\n\n\nDescriptorMatcher_create(matcherType) -> retval\n."},
    {"DualTVL1OpticalFlow_create", (PyCFunction)pyopencv_cv_DualTVL1OpticalFlow_create, METH_VARARGS | METH_KEYWORDS, "DualTVL1OpticalFlow_create([, tau[, lambda[, theta[, nscales[, warps[, epsilon[, innnerIterations[, outerIterations[, scaleStep[, gamma[, medianFiltering[, useInitialFlow]]]]]]]]]]]]) -> retval\n.   @brief Creates instance of cv::DualTVL1OpticalFlow"},
    {"EMD", (PyCFunction)pyopencv_cv_EMD, METH_VARARGS | METH_KEYWORDS, "EMD(signature1, signature2, distType[, cost[, lowerBound[, flow]]]) -> retval, lowerBound, flow\n.   @brief Computes the \"minimal work\" distance between two weighted point configurations.\n.   \n.   The function computes the earth mover distance and/or a lower boundary of the distance between the\n.   two weighted point configurations. One of the applications described in @cite RubnerSept98,\n.   @cite Rubner2000 is multi-dimensional histogram comparison for image retrieval. EMD is a transportation\n.   problem that is solved using some modification of a simplex algorithm, thus the complexity is\n.   exponential in the worst case, though, on average it is much faster. In the case of a real metric\n.   the lower boundary can be calculated even faster (using linear-time algorithm) and it can be used\n.   to determine roughly whether the two signatures are far enough so that they cannot relate to the\n.   same object.\n.   \n.   @param signature1 First signature, a \\f$\\texttt{size1}\\times \\texttt{dims}+1\\f$ floating-point matrix.\n.   Each row stores the point weight followed by the point coordinates. The matrix is allowed to have\n.   a single column (weights only) if the user-defined cost matrix is used. The weights must be\n.   non-negative and have at least one non-zero value.\n.   @param signature2 Second signature of the same format as signature1 , though the number of rows\n.   may be different. The total weights may be different. In this case an extra \"dummy\" point is added\n.   to either signature1 or signature2. The weights must be non-negative and have at least one non-zero\n.   value.\n.   @param distType Used metric. See #DistanceTypes.\n.   @param cost User-defined \\f$\\texttt{size1}\\times \\texttt{size2}\\f$ cost matrix. Also, if a cost matrix\n.   is used, lower boundary lowerBound cannot be calculated because it needs a metric function.\n.   @param lowerBound Optional input/output parameter: lower boundary of a distance between the two\n.   signatures that is a distance between mass centers. The lower boundary may not be calculated if\n.   the user-defined cost matrix is used, the total weights of point configurations are not equal, or\n.   if the signatures consist of weights only (the signature matrices have a single column). You\n.   **must** initialize \\*lowerBound . If the calculated distance between mass centers is greater or\n.   equal to \\*lowerBound (it means that the signatures are far enough), the function does not\n.   calculate EMD. In any case \\*lowerBound is set to the calculated distance between mass centers on\n.   return. Thus, if you want to calculate both distance between mass centers and EMD, \\*lowerBound\n.   should be set to 0.\n.   @param flow Resultant \\f$\\texttt{size1} \\times \\texttt{size2}\\f$ flow matrix: \\f$\\texttt{flow}_{i,j}\\f$ is\n.   a flow from \\f$i\\f$ -th point of signature1 to \\f$j\\f$ -th point of signature2 ."},
    {"FarnebackOpticalFlow_create", (PyCFunction)pyopencv_cv_FarnebackOpticalFlow_create, METH_VARARGS | METH_KEYWORDS, "FarnebackOpticalFlow_create([, numLevels[, pyrScale[, fastPyramids[, winSize[, numIters[, polyN[, polySigma[, flags]]]]]]]]) -> retval\n."},
    {"FastFeatureDetector_create", (PyCFunction)pyopencv_cv_FastFeatureDetector_create, METH_VARARGS | METH_KEYWORDS, "FastFeatureDetector_create([, threshold[, nonmaxSuppression[, type]]]) -> retval\n."},
    {"FlannBasedMatcher_create", (PyCFunction)pyopencv_cv_FlannBasedMatcher_create, METH_VARARGS | METH_KEYWORDS, "FlannBasedMatcher_create() -> retval\n."},
    {"GFTTDetector_create", (PyCFunction)pyopencv_cv_GFTTDetector_create, METH_VARARGS | METH_KEYWORDS, "GFTTDetector_create([, maxCorners[, qualityLevel[, minDistance[, blockSize[, useHarrisDetector[, k]]]]]]) -> retval\n.   \n\n\n\nGFTTDetector_create(maxCorners, qualityLevel, minDistance, blockSize, gradiantSize[, useHarrisDetector[, k]]) -> retval\n."},
    {"GaussianBlur", (PyCFunction)pyopencv_cv_GaussianBlur, METH_VARARGS | METH_KEYWORDS, "GaussianBlur(src, ksize, sigmaX[, dst[, sigmaY[, borderType]]]) -> dst\n.   @brief Blurs an image using a Gaussian filter.\n.   \n.   The function convolves the source image with the specified Gaussian kernel. In-place filtering is\n.   supported.\n.   \n.   @param src input image; the image can have any number of channels, which are processed\n.   independently, but the depth should be CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param ksize Gaussian kernel size. ksize.width and ksize.height can differ but they both must be\n.   positive and odd. Or, they can be zero's and then they are computed from sigma.\n.   @param sigmaX Gaussian kernel standard deviation in X direction.\n.   @param sigmaY Gaussian kernel standard deviation in Y direction; if sigmaY is zero, it is set to be\n.   equal to sigmaX, if both sigmas are zeros, they are computed from ksize.width and ksize.height,\n.   respectively (see #getGaussianKernel for details); to fully control the result regardless of\n.   possible future modifications of all this semantics, it is recommended to specify all of ksize,\n.   sigmaX, and sigmaY.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   \n.   @sa  sepFilter2D, filter2D, blur, boxFilter, bilateralFilter, medianBlur"},
    {"HOGDescriptor_getDaimlerPeopleDetector", (PyCFunction)pyopencv_cv_HOGDescriptor_getDaimlerPeopleDetector, METH_VARARGS | METH_KEYWORDS, "HOGDescriptor_getDaimlerPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 48x96 windows)."},
    {"HOGDescriptor_getDefaultPeopleDetector", (PyCFunction)pyopencv_cv_HOGDescriptor_getDefaultPeopleDetector, METH_VARARGS | METH_KEYWORDS, "HOGDescriptor_getDefaultPeopleDetector() -> retval\n.   @brief Returns coefficients of the classifier trained for people detection (for 64x128 windows)."},
    {"HoughCircles", (PyCFunction)pyopencv_cv_HoughCircles, METH_VARARGS | METH_KEYWORDS, "HoughCircles(image, method, dp, minDist[, circles[, param1[, param2[, minRadius[, maxRadius]]]]]) -> circles\n.   @brief Finds circles in a grayscale image using the Hough transform.\n.   \n.   The function finds circles in a grayscale image using a modification of the Hough transform.\n.   \n.   Example: :\n.   @code\n.   #include <opencv2/imgproc.hpp>\n.   #include <opencv2/highgui.hpp>\n.   #include <math.h>\n.   \n.   using namespace cv;\n.   using namespace std;\n.   \n.   int main(int argc, char** argv)\n.   {\n.   Mat img, gray;\n.   if( argc != 2 || !(img=imread(argv[1], 1)).data)\n.   return -1;\n.   cvtColor(img, gray, COLOR_BGR2GRAY);\n.   // smooth it, otherwise a lot of false circles may be detected\n.   GaussianBlur( gray, gray, Size(9, 9), 2, 2 );\n.   vector<Vec3f> circles;\n.   HoughCircles(gray, circles, HOUGH_GRADIENT,\n.   2, gray.rows/4, 200, 100 );\n.   for( size_t i = 0; i < circles.size(); i++ )\n.   {\n.   Point center(cvRound(circles[i][0]), cvRound(circles[i][1]));\n.   int radius = cvRound(circles[i][2]);\n.   // draw the circle center\n.   circle( img, center, 3, Scalar(0,255,0), -1, 8, 0 );\n.   // draw the circle outline\n.   circle( img, center, radius, Scalar(0,0,255), 3, 8, 0 );\n.   }\n.   namedWindow( \"circles\", 1 );\n.   imshow( \"circles\", img );\n.   \n.   waitKey(0);\n.   return 0;\n.   }\n.   @endcode\n.   \n.   @note Usually the function detects the centers of circles well. However, it may fail to find correct\n.   radii. You can assist to the function by specifying the radius range ( minRadius and maxRadius ) if\n.   you know it. Or, you may set maxRadius to a negative number to return centers only without radius\n.   search, and find the correct radius using an additional procedure.\n.   \n.   @param image 8-bit, single-channel, grayscale input image.\n.   @param circles Output vector of found circles. Each vector is encoded as a 3-element\n.   floating-point vector \\f$(x, y, radius)\\f$ .\n.   @param method Detection method, see #HoughModes. Currently, the only implemented method is #HOUGH_GRADIENT\n.   @param dp Inverse ratio of the accumulator resolution to the image resolution. For example, if\n.   dp=1 , the accumulator has the same resolution as the input image. If dp=2 , the accumulator has\n.   half as big width and height.\n.   @param minDist Minimum distance between the centers of the detected circles. If the parameter is\n.   too small, multiple neighbor circles may be falsely detected in addition to a true one. If it is\n.   too large, some circles may be missed.\n.   @param param1 First method-specific parameter. In case of #HOUGH_GRADIENT , it is the higher\n.   threshold of the two passed to the Canny edge detector (the lower one is twice smaller).\n.   @param param2 Second method-specific parameter. In case of #HOUGH_GRADIENT , it is the\n.   accumulator threshold for the circle centers at the detection stage. The smaller it is, the more\n.   false circles may be detected. Circles, corresponding to the larger accumulator values, will be\n.   returned first.\n.   @param minRadius Minimum circle radius.\n.   @param maxRadius Maximum circle radius. If <= 0, uses the maximum image dimension. If < 0, returns\n.   centers without finding the radius.\n.   \n.   @sa fitEllipse, minEnclosingCircle"},
    {"HoughLines", (PyCFunction)pyopencv_cv_HoughLines, METH_VARARGS | METH_KEYWORDS, "HoughLines(image, rho, theta, threshold[, lines[, srn[, stn[, min_theta[, max_theta]]]]]) -> lines\n.   @brief Finds lines in a binary image using the standard Hough transform.\n.   \n.   The function implements the standard or standard multi-scale Hough transform algorithm for line\n.   detection. See <http://homepages.inf.ed.ac.uk/rbf/HIPR2/hough.htm> for a good explanation of Hough\n.   transform.\n.   \n.   @param image 8-bit, single-channel binary source image. The image may be modified by the function.\n.   @param lines Output vector of lines. Each line is represented by a two-element vector\n.   \\f$(\\rho, \\theta)\\f$ . \\f$\\rho\\f$ is the distance from the coordinate origin \\f$(0,0)\\f$ (top-left corner of\n.   the image). \\f$\\theta\\f$ is the line rotation angle in radians (\n.   \\f$0 \\sim \\textrm{vertical line}, \\pi/2 \\sim \\textrm{horizontal line}\\f$ ).\n.   @param rho Distance resolution of the accumulator in pixels.\n.   @param theta Angle resolution of the accumulator in radians.\n.   @param threshold Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ ).\n.   @param srn For the multi-scale Hough transform, it is a divisor for the distance resolution rho .\n.   The coarse accumulator distance resolution is rho and the accurate accumulator resolution is\n.   rho/srn . If both srn=0 and stn=0 , the classical Hough transform is used. Otherwise, both these\n.   parameters should be positive.\n.   @param stn For the multi-scale Hough transform, it is a divisor for the distance resolution theta.\n.   @param min_theta For standard and multi-scale Hough transform, minimum angle to check for lines.\n.   Must fall between 0 and max_theta.\n.   @param max_theta For standard and multi-scale Hough transform, maximum angle to check for lines.\n.   Must fall between min_theta and CV_PI."},
    {"HoughLinesP", (PyCFunction)pyopencv_cv_HoughLinesP, METH_VARARGS | METH_KEYWORDS, "HoughLinesP(image, rho, theta, threshold[, lines[, minLineLength[, maxLineGap]]]) -> lines\n.   @brief Finds line segments in a binary image using the probabilistic Hough transform.\n.   \n.   The function implements the probabilistic Hough transform algorithm for line detection, described\n.   in @cite Matas00\n.   \n.   See the line detection example below:\n.   \n.   @code\n.   #include <opencv2/imgproc.hpp>\n.   #include <opencv2/highgui.hpp>\n.   \n.   using namespace cv;\n.   using namespace std;\n.   \n.   int main(int argc, char** argv)\n.   {\n.   Mat src, dst, color_dst;\n.   if( argc != 2 || !(src=imread(argv[1], 0)).data)\n.   return -1;\n.   \n.   Canny( src, dst, 50, 200, 3 );\n.   cvtColor( dst, color_dst, COLOR_GRAY2BGR );\n.   \n.   #if 0\n.   vector<Vec2f> lines;\n.   HoughLines( dst, lines, 1, CV_PI/180, 100 );\n.   \n.   for( size_t i = 0; i < lines.size(); i++ )\n.   {\n.   float rho = lines[i][0];\n.   float theta = lines[i][1];\n.   double a = cos(theta), b = sin(theta);\n.   double x0 = a*rho, y0 = b*rho;\n.   Point pt1(cvRound(x0 + 1000*(-b)),\n.   cvRound(y0 + 1000*(a)));\n.   Point pt2(cvRound(x0 - 1000*(-b)),\n.   cvRound(y0 - 1000*(a)));\n.   line( color_dst, pt1, pt2, Scalar(0,0,255), 3, 8 );\n.   }\n.   #else\n.   vector<Vec4i> lines;\n.   HoughLinesP( dst, lines, 1, CV_PI/180, 80, 30, 10 );\n.   for( size_t i = 0; i < lines.size(); i++ )\n.   {\n.   line( color_dst, Point(lines[i][0], lines[i][1]),\n.   Point(lines[i][2], lines[i][3]), Scalar(0,0,255), 3, 8 );\n.   }\n.   #endif\n.   namedWindow( \"Source\", 1 );\n.   imshow( \"Source\", src );\n.   \n.   namedWindow( \"Detected Lines\", 1 );\n.   imshow( \"Detected Lines\", color_dst );\n.   \n.   waitKey(0);\n.   return 0;\n.   }\n.   @endcode\n.   This is a sample picture the function parameters have been tuned for:\n.   \n.   ![image](pics/building.jpg)\n.   \n.   And this is the output of the above program in case of the probabilistic Hough transform:\n.   \n.   ![image](pics/houghp.png)\n.   \n.   @param image 8-bit, single-channel binary source image. The image may be modified by the function.\n.   @param lines Output vector of lines. Each line is represented by a 4-element vector\n.   \\f$(x_1, y_1, x_2, y_2)\\f$ , where \\f$(x_1,y_1)\\f$ and \\f$(x_2, y_2)\\f$ are the ending points of each detected\n.   line segment.\n.   @param rho Distance resolution of the accumulator in pixels.\n.   @param theta Angle resolution of the accumulator in radians.\n.   @param threshold Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ ).\n.   @param minLineLength Minimum line length. Line segments shorter than that are rejected.\n.   @param maxLineGap Maximum allowed gap between points on the same line to link them.\n.   \n.   @sa LineSegmentDetector"},
    {"HoughLinesPointSet", (PyCFunction)pyopencv_cv_HoughLinesPointSet, METH_VARARGS | METH_KEYWORDS, "HoughLinesPointSet(_point, lines_max, threshold, min_rho, max_rho, rho_step, min_theta, max_theta, theta_step[, _lines]) -> _lines\n.   @brief Finds lines in a set of points using the standard Hough transform.\n.   \n.   The function finds lines in a set of points using a modification of the Hough transform.\n.   @include snippets/imgproc_HoughLinesPointSet.cpp\n.   @param _point Input vector of points. Each vector must be encoded as a Point vector \\f$(x,y)\\f$. Type must be CV_32FC2 or CV_32SC2.\n.   @param _lines Output vector of found lines. Each vector is encoded as a vector<Vec3d> \\f$(votes, rho, theta)\\f$.\n.   The larger the value of 'votes', the higher the reliability of the Hough line.\n.   @param lines_max Max count of hough lines.\n.   @param threshold Accumulator threshold parameter. Only those lines are returned that get enough\n.   votes ( \\f$>\\texttt{threshold}\\f$ )\n.   @param min_rho Minimum Distance value of the accumulator in pixels.\n.   @param max_rho Maximum Distance value of the accumulator in pixels.\n.   @param rho_step Distance resolution of the accumulator in pixels.\n.   @param min_theta Minimum angle value of the accumulator in radians.\n.   @param max_theta Maximum angle value of the accumulator in radians.\n.   @param theta_step Angle resolution of the accumulator in radians."},
    {"HuMoments", (PyCFunction)pyopencv_cv_HuMoments, METH_VARARGS | METH_KEYWORDS, "HuMoments(m[, hu]) -> hu\n.   @overload"},
    {"KAZE_create", (PyCFunction)pyopencv_cv_KAZE_create, METH_VARARGS | METH_KEYWORDS, "KAZE_create([, extended[, upright[, threshold[, nOctaves[, nOctaveLayers[, diffusivity]]]]]]) -> retval\n.   @brief The KAZE constructor\n.   \n.   @param extended Set to enable extraction of extended (128-byte) descriptor.\n.   @param upright Set to enable use of upright descriptors (non rotation-invariant).\n.   @param threshold Detector response threshold to accept point\n.   @param nOctaves Maximum octave evolution of the image\n.   @param nOctaveLayers Default number of sublevels per scale level\n.   @param diffusivity Diffusivity type. DIFF_PM_G1, DIFF_PM_G2, DIFF_WEICKERT or\n.   DIFF_CHARBONNIER"},
    {"KeyPoint_convert", (PyCFunction)pyopencv_cv_KeyPoint_convert, METH_VARARGS | METH_KEYWORDS, "KeyPoint_convert(keypoints[, keypointIndexes]) -> points2f\n.   This method converts vector of keypoints to vector of points or the reverse, where each keypoint is\n.   assigned the same size and the same orientation.\n.   \n.   @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.   @param points2f Array of (x,y) coordinates of each keypoint\n.   @param keypointIndexes Array of indexes of keypoints to be converted to points. (Acts like a mask to\n.   convert only specified keypoints)\n\n\n\nKeyPoint_convert(points2f[, size[, response[, octave[, class_id]]]]) -> keypoints\n.   @overload\n.   @param points2f Array of (x,y) coordinates of each keypoint\n.   @param keypoints Keypoints obtained from any feature detection algorithm like SIFT/SURF/ORB\n.   @param size keypoint diameter\n.   @param response keypoint detector response on the keypoint (that is, strength of the keypoint)\n.   @param octave pyramid octave in which the keypoint has been detected\n.   @param class_id object id"},
    {"KeyPoint_overlap", (PyCFunction)pyopencv_cv_KeyPoint_overlap, METH_VARARGS | METH_KEYWORDS, "KeyPoint_overlap(kp1, kp2) -> retval\n.   This method computes overlap for pair of keypoints. Overlap is the ratio between area of keypoint\n.   regions' intersection and area of keypoint regions' union (considering keypoint region as circle).\n.   If they don't overlap, we get zero. If they coincide at same location with same size, we get 1.\n.   @param kp1 First keypoint\n.   @param kp2 Second keypoint"},
    {"LUT", (PyCFunction)pyopencv_cv_LUT, METH_VARARGS | METH_KEYWORDS, "LUT(src, lut[, dst]) -> dst\n.   @brief Performs a look-up table transform of an array.\n.   \n.   The function LUT fills the output array with values from the look-up table. Indices of the entries\n.   are taken from the input array. That is, the function processes each element of src as follows:\n.   \\f[\\texttt{dst} (I)  \\leftarrow \\texttt{lut(src(I) + d)}\\f]\n.   where\n.   \\f[d =  \\fork{0}{if \\(\\texttt{src}\\) has depth \\(\\texttt{CV_8U}\\)}{128}{if \\(\\texttt{src}\\) has depth \\(\\texttt{CV_8S}\\)}\\f]\n.   @param src input array of 8-bit elements.\n.   @param lut look-up table of 256 elements; in case of multi-channel input array, the table should\n.   either have a single channel (in this case the same table is used for all channels) or the same\n.   number of channels as in the input array.\n.   @param dst output array of the same size and number of channels as src, and the same depth as lut.\n.   @sa  convertScaleAbs, Mat::convertTo"},
    {"Laplacian", (PyCFunction)pyopencv_cv_Laplacian, METH_VARARGS | METH_KEYWORDS, "Laplacian(src, ddepth[, dst[, ksize[, scale[, delta[, borderType]]]]]) -> dst\n.   @brief Calculates the Laplacian of an image.\n.   \n.   The function calculates the Laplacian of the source image by adding up the second x and y\n.   derivatives calculated using the Sobel operator:\n.   \n.   \\f[\\texttt{dst} =  \\Delta \\texttt{src} =  \\frac{\\partial^2 \\texttt{src}}{\\partial x^2} +  \\frac{\\partial^2 \\texttt{src}}{\\partial y^2}\\f]\n.   \n.   This is done when `ksize > 1`. When `ksize == 1`, the Laplacian is computed by filtering the image\n.   with the following \\f$3 \\times 3\\f$ aperture:\n.   \n.   \\f[\\vecthreethree {0}{1}{0}{1}{-4}{1}{0}{1}{0}\\f]\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same size and the same number of channels as src .\n.   @param ddepth Desired depth of the destination image.\n.   @param ksize Aperture size used to compute the second-derivative filters. See #getDerivKernels for\n.   details. The size must be positive and odd.\n.   @param scale Optional scale factor for the computed Laplacian values. By default, no scaling is\n.   applied. See #getDerivKernels for details.\n.   @param delta Optional delta value that is added to the results prior to storing them in dst .\n.   @param borderType Pixel extrapolation method, see #BorderTypes\n.   @sa  Sobel, Scharr"},
    {"MSER_create", (PyCFunction)pyopencv_cv_MSER_create, METH_VARARGS | METH_KEYWORDS, "MSER_create([, _delta[, _min_area[, _max_area[, _max_variation[, _min_diversity[, _max_evolution[, _area_threshold[, _min_margin[, _edge_blur_size]]]]]]]]]) -> retval\n.   @brief Full consturctor for %MSER detector\n.   \n.   @param _delta it compares \\f$(size_{i}-size_{i-delta})/size_{i-delta}\\f$\n.   @param _min_area prune the area which smaller than minArea\n.   @param _max_area prune the area which bigger than maxArea\n.   @param _max_variation prune the area have similar size to its children\n.   @param _min_diversity for color image, trace back to cut off mser with diversity less than min_diversity\n.   @param _max_evolution  for color image, the evolution steps\n.   @param _area_threshold for color image, the area threshold to cause re-initialize\n.   @param _min_margin for color image, ignore too small margin\n.   @param _edge_blur_size for color image, the aperture size for edge blur"},
    {"Mahalanobis", (PyCFunction)pyopencv_cv_Mahalanobis, METH_VARARGS | METH_KEYWORDS, "Mahalanobis(v1, v2, icovar) -> retval\n.   @brief Calculates the Mahalanobis distance between two vectors.\n.   \n.   The function cv::Mahalanobis calculates and returns the weighted distance between two vectors:\n.   \\f[d( \\texttt{vec1} , \\texttt{vec2} )= \\sqrt{\\sum_{i,j}{\\texttt{icovar(i,j)}\\cdot(\\texttt{vec1}(I)-\\texttt{vec2}(I))\\cdot(\\texttt{vec1(j)}-\\texttt{vec2(j)})} }\\f]\n.   The covariance matrix may be calculated using the #calcCovarMatrix function and then inverted using\n.   the invert function (preferably using the #DECOMP_SVD method, as the most accurate).\n.   @param v1 first 1D input vector.\n.   @param v2 second 1D input vector.\n.   @param icovar inverse covariance matrix."},
    {"MultiTracker_create", (PyCFunction)pyopencv_cv_MultiTracker_create, METH_VARARGS | METH_KEYWORDS, "MultiTracker_create() -> retval\n.   * \\brief Returns a pointer to a new instance of MultiTracker"},
    {"ORB_create", (PyCFunction)pyopencv_cv_ORB_create, METH_VARARGS | METH_KEYWORDS, "ORB_create([, nfeatures[, scaleFactor[, nlevels[, edgeThreshold[, firstLevel[, WTA_K[, scoreType[, patchSize[, fastThreshold]]]]]]]]]) -> retval\n.   @brief The ORB constructor\n.   \n.   @param nfeatures The maximum number of features to retain.\n.   @param scaleFactor Pyramid decimation ratio, greater than 1. scaleFactor==2 means the classical\n.   pyramid, where each next level has 4x less pixels than the previous, but such a big scale factor\n.   will degrade feature matching scores dramatically. On the other hand, too close to 1 scale factor\n.   will mean that to cover certain scale range you will need more pyramid levels and so the speed\n.   will suffer.\n.   @param nlevels The number of pyramid levels. The smallest level will have linear size equal to\n.   input_image_linear_size/pow(scaleFactor, nlevels - firstLevel).\n.   @param edgeThreshold This is size of the border where the features are not detected. It should\n.   roughly match the patchSize parameter.\n.   @param firstLevel The level of pyramid to put source image to. Previous layers are filled\n.   with upscaled source image.\n.   @param WTA_K The number of points that produce each element of the oriented BRIEF descriptor. The\n.   default value 2 means the BRIEF where we take a random point pair and compare their brightnesses,\n.   so we get 0/1 response. Other possible values are 3 and 4. For example, 3 means that we take 3\n.   random points (of course, those point coordinates are random, but they are generated from the\n.   pre-defined seed, so each element of BRIEF descriptor is computed deterministically from the pixel\n.   rectangle), find point of maximum brightness and output index of the winner (0, 1 or 2). Such\n.   output will occupy 2 bits, and therefore it will need a special variant of Hamming distance,\n.   denoted as NORM_HAMMING2 (2 bits per bin). When WTA_K=4, we take 4 random points to compute each\n.   bin (that will also occupy 2 bits with possible values 0, 1, 2 or 3).\n.   @param scoreType The default HARRIS_SCORE means that Harris algorithm is used to rank features\n.   (the score is written to KeyPoint::score and is used to retain best nfeatures features);\n.   FAST_SCORE is alternative value of the parameter that produces slightly less stable keypoints,\n.   but it is a little faster to compute.\n.   @param patchSize size of the patch used by the oriented BRIEF descriptor. Of course, on smaller\n.   pyramid layers the perceived image area covered by a feature will be larger.\n.   @param fastThreshold"},
    {"PCABackProject", (PyCFunction)pyopencv_cv_PCABackProject, METH_VARARGS | METH_KEYWORDS, "PCABackProject(data, mean, eigenvectors[, result]) -> result\n.   wrap PCA::backProject"},
    {"PCACompute", (PyCFunction)pyopencv_cv_PCACompute, METH_VARARGS | METH_KEYWORDS, "PCACompute(data, mean[, eigenvectors[, maxComponents]]) -> mean, eigenvectors\n.   wrap PCA::operator()\n\n\n\nPCACompute(data, mean, retainedVariance[, eigenvectors]) -> mean, eigenvectors\n.   wrap PCA::operator()"},
    {"PCAProject", (PyCFunction)pyopencv_cv_PCAProject, METH_VARARGS | METH_KEYWORDS, "PCAProject(data, mean, eigenvectors[, result]) -> result\n.   wrap PCA::project"},
    {"PSNR", (PyCFunction)pyopencv_cv_PSNR, METH_VARARGS | METH_KEYWORDS, "PSNR(src1, src2) -> retval\n.   @brief Computes the Peak Signal-to-Noise Ratio (PSNR) image quality metric.\n.   \n.   This function calculates the Peak Signal-to-Noise Ratio (PSNR) image quality metric in decibels (dB), between two input arrays src1 and src2. Arrays must have depth CV_8U.\n.   \n.   The PSNR is calculated as follows:\n.   \n.   \\f[\n.   \\texttt{PSNR} = 10 \\cdot \\log_{10}{\\left( \\frac{R^2}{MSE} \\right) }\n.   \\f]\n.   \n.   where R is the maximum integer value of depth CV_8U (255) and MSE is the mean squared error between the two arrays.\n.   \n.   @param src1 first input array.\n.   @param src2 second input array of the same size as src1."},
    {"RQDecomp3x3", (PyCFunction)pyopencv_cv_RQDecomp3x3, METH_VARARGS | METH_KEYWORDS, "RQDecomp3x3(src[, mtxR[, mtxQ[, Qx[, Qy[, Qz]]]]]) -> retval, mtxR, mtxQ, Qx, Qy, Qz\n.   @brief Computes an RQ decomposition of 3x3 matrices.\n.   \n.   @param src 3x3 input matrix.\n.   @param mtxR Output 3x3 upper-triangular matrix.\n.   @param mtxQ Output 3x3 orthogonal matrix.\n.   @param Qx Optional output 3x3 rotation matrix around x-axis.\n.   @param Qy Optional output 3x3 rotation matrix around y-axis.\n.   @param Qz Optional output 3x3 rotation matrix around z-axis.\n.   \n.   The function computes a RQ decomposition using the given rotations. This function is used in\n.   decomposeProjectionMatrix to decompose the left 3x3 submatrix of a projection matrix into a camera\n.   and a rotation matrix.\n.   \n.   It optionally returns three rotation matrices, one for each axis, and the three Euler angles in\n.   degrees (as the return value) that could be used in OpenGL. Note, there is always more than one\n.   sequence of rotations about the three principal axes that results in the same orientation of an\n.   object, e.g. see @cite Slabaugh . Returned tree rotation matrices and corresponding three Euler angles\n.   are only one of the possible solutions."},
    {"Rodrigues", (PyCFunction)pyopencv_cv_Rodrigues, METH_VARARGS | METH_KEYWORDS, "Rodrigues(src[, dst[, jacobian]]) -> dst, jacobian\n.   @brief Converts a rotation matrix to a rotation vector or vice versa.\n.   \n.   @param src Input rotation vector (3x1 or 1x3) or rotation matrix (3x3).\n.   @param dst Output rotation matrix (3x3) or rotation vector (3x1 or 1x3), respectively.\n.   @param jacobian Optional output Jacobian matrix, 3x9 or 9x3, which is a matrix of partial\n.   derivatives of the output array components with respect to the input array components.\n.   \n.   \\f[\\begin{array}{l} \\theta \\leftarrow norm(r) \\\\ r  \\leftarrow r/ \\theta \\\\ R =  \\cos{\\theta} I + (1- \\cos{\\theta} ) r r^T +  \\sin{\\theta} \\vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} \\end{array}\\f]\n.   \n.   Inverse transformation can be also done easily, since\n.   \n.   \\f[\\sin ( \\theta ) \\vecthreethree{0}{-r_z}{r_y}{r_z}{0}{-r_x}{-r_y}{r_x}{0} = \\frac{R - R^T}{2}\\f]\n.   \n.   A rotation vector is a convenient and most compact representation of a rotation matrix (since any\n.   rotation matrix has just 3 degrees of freedom). The representation is used in the global 3D geometry\n.   optimization procedures like calibrateCamera, stereoCalibrate, or solvePnP ."},
    {"SVBackSubst", (PyCFunction)pyopencv_cv_SVBackSubst, METH_VARARGS | METH_KEYWORDS, "SVBackSubst(w, u, vt, rhs[, dst]) -> dst\n.   wrap SVD::backSubst"},
    {"SVDecomp", (PyCFunction)pyopencv_cv_SVDecomp, METH_VARARGS | METH_KEYWORDS, "SVDecomp(src[, w[, u[, vt[, flags]]]]) -> w, u, vt\n.   wrap SVD::compute"},
    {"Scharr", (PyCFunction)pyopencv_cv_Scharr, METH_VARARGS | METH_KEYWORDS, "Scharr(src, ddepth, dx, dy[, dst[, scale[, delta[, borderType]]]]) -> dst\n.   @brief Calculates the first x- or y- image derivative using Scharr operator.\n.   \n.   The function computes the first x- or y- spatial image derivative using the Scharr operator. The\n.   call\n.   \n.   \\f[\\texttt{Scharr(src, dst, ddepth, dx, dy, scale, delta, borderType)}\\f]\n.   \n.   is equivalent to\n.   \n.   \\f[\\texttt{Sobel(src, dst, ddepth, dx, dy, CV_SCHARR, scale, delta, borderType)} .\\f]\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src.\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"\n.   @param dx order of the derivative x.\n.   @param dy order of the derivative y.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see #getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   @sa  cartToPolar"},
    {"SimpleBlobDetector_create", (PyCFunction)pyopencv_cv_SimpleBlobDetector_create, METH_VARARGS | METH_KEYWORDS, "SimpleBlobDetector_create([, parameters]) -> retval\n."},
    {"Sobel", (PyCFunction)pyopencv_cv_Sobel, METH_VARARGS | METH_KEYWORDS, "Sobel(src, ddepth, dx, dy[, dst[, ksize[, scale[, delta[, borderType]]]]]) -> dst\n.   @brief Calculates the first, second, third, or mixed image derivatives using an extended Sobel operator.\n.   \n.   In all cases except one, the \\f$\\texttt{ksize} \\times \\texttt{ksize}\\f$ separable kernel is used to\n.   calculate the derivative. When \\f$\\texttt{ksize = 1}\\f$, the \\f$3 \\times 1\\f$ or \\f$1 \\times 3\\f$\n.   kernel is used (that is, no Gaussian smoothing is done). `ksize = 1` can only be used for the first\n.   or the second x- or y- derivatives.\n.   \n.   There is also the special value `ksize = #CV_SCHARR (-1)` that corresponds to the \\f$3\\times3\\f$ Scharr\n.   filter that may give more accurate results than the \\f$3\\times3\\f$ Sobel. The Scharr aperture is\n.   \n.   \\f[\\vecthreethree{-3}{0}{3}{-10}{0}{10}{-3}{0}{3}\\f]\n.   \n.   for the x-derivative, or transposed for the y-derivative.\n.   \n.   The function calculates an image derivative by convolving the image with the appropriate kernel:\n.   \n.   \\f[\\texttt{dst} =  \\frac{\\partial^{xorder+yorder} \\texttt{src}}{\\partial x^{xorder} \\partial y^{yorder}}\\f]\n.   \n.   The Sobel operators combine Gaussian smoothing and differentiation, so the result is more or less\n.   resistant to the noise. Most often, the function is called with ( xorder = 1, yorder = 0, ksize = 3)\n.   or ( xorder = 0, yorder = 1, ksize = 3) to calculate the first x- or y- image derivative. The first\n.   case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{0}{1}{-2}{0}{2}{-1}{0}{1}\\f]\n.   \n.   The second case corresponds to a kernel of:\n.   \n.   \\f[\\vecthreethree{-1}{-2}{-1}{0}{0}{0}{1}{2}{1}\\f]\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src .\n.   @param ddepth output image depth, see @ref filter_depths \"combinations\"; in the case of\n.   8-bit input images it will result in truncated derivatives.\n.   @param dx order of the derivative x.\n.   @param dy order of the derivative y.\n.   @param ksize size of the extended Sobel kernel; it must be 1, 3, 5, or 7.\n.   @param scale optional scale factor for the computed derivative values; by default, no scaling is\n.   applied (see #getDerivKernels for details).\n.   @param delta optional delta value that is added to the results prior to storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   @sa  Scharr, Laplacian, sepFilter2D, filter2D, GaussianBlur, cartToPolar"},
    {"SparsePyrLKOpticalFlow_create", (PyCFunction)pyopencv_cv_SparsePyrLKOpticalFlow_create, METH_VARARGS | METH_KEYWORDS, "SparsePyrLKOpticalFlow_create([, winSize[, maxLevel[, crit[, flags[, minEigThreshold]]]]]) -> retval\n."},
    {"StereoBM_create", (PyCFunction)pyopencv_cv_StereoBM_create, METH_VARARGS | METH_KEYWORDS, "StereoBM_create([, numDisparities[, blockSize]]) -> retval\n.   @brief Creates StereoBM object\n.   \n.   @param numDisparities the disparity search range. For each pixel algorithm will find the best\n.   disparity from 0 (default minimum disparity) to numDisparities. The search range can then be\n.   shifted by changing the minimum disparity.\n.   @param blockSize the linear size of the blocks compared by the algorithm. The size should be odd\n.   (as the block is centered at the current pixel). Larger block size implies smoother, though less\n.   accurate disparity map. Smaller block size gives more detailed disparity map, but there is higher\n.   chance for algorithm to find a wrong correspondence.\n.   \n.   The function create StereoBM object. You can then call StereoBM::compute() to compute disparity for\n.   a specific stereo pair."},
    {"StereoSGBM_create", (PyCFunction)pyopencv_cv_StereoSGBM_create, METH_VARARGS | METH_KEYWORDS, "StereoSGBM_create([, minDisparity[, numDisparities[, blockSize[, P1[, P2[, disp12MaxDiff[, preFilterCap[, uniquenessRatio[, speckleWindowSize[, speckleRange[, mode]]]]]]]]]]]) -> retval\n.   @brief Creates StereoSGBM object\n.   \n.   @param minDisparity Minimum possible disparity value. Normally, it is zero but sometimes\n.   rectification algorithms can shift images, so this parameter needs to be adjusted accordingly.\n.   @param numDisparities Maximum disparity minus minimum disparity. The value is always greater than\n.   zero. In the current implementation, this parameter must be divisible by 16.\n.   @param blockSize Matched block size. It must be an odd number \\>=1 . Normally, it should be\n.   somewhere in the 3..11 range.\n.   @param P1 The first parameter controlling the disparity smoothness. See below.\n.   @param P2 The second parameter controlling the disparity smoothness. The larger the values are,\n.   the smoother the disparity is. P1 is the penalty on the disparity change by plus or minus 1\n.   between neighbor pixels. P2 is the penalty on the disparity change by more than 1 between neighbor\n.   pixels. The algorithm requires P2 \\> P1 . See stereo_match.cpp sample where some reasonably good\n.   P1 and P2 values are shown (like 8\\*number_of_image_channels\\*SADWindowSize\\*SADWindowSize and\n.   32\\*number_of_image_channels\\*SADWindowSize\\*SADWindowSize , respectively).\n.   @param disp12MaxDiff Maximum allowed difference (in integer pixel units) in the left-right\n.   disparity check. Set it to a non-positive value to disable the check.\n.   @param preFilterCap Truncation value for the prefiltered image pixels. The algorithm first\n.   computes x-derivative at each pixel and clips its value by [-preFilterCap, preFilterCap] interval.\n.   The result values are passed to the Birchfield-Tomasi pixel cost function.\n.   @param uniquenessRatio Margin in percentage by which the best (minimum) computed cost function\n.   value should \"win\" the second best value to consider the found match correct. Normally, a value\n.   within the 5-15 range is good enough.\n.   @param speckleWindowSize Maximum size of smooth disparity regions to consider their noise speckles\n.   and invalidate. Set it to 0 to disable speckle filtering. Otherwise, set it somewhere in the\n.   50-200 range.\n.   @param speckleRange Maximum disparity variation within each connected component. If you do speckle\n.   filtering, set the parameter to a positive value, it will be implicitly multiplied by 16.\n.   Normally, 1 or 2 is good enough.\n.   @param mode Set it to StereoSGBM::MODE_HH to run the full-scale two-pass dynamic programming\n.   algorithm. It will consume O(W\\*H\\*numDisparities) bytes, which is large for 640x480 stereo and\n.   huge for HD-size pictures. By default, it is set to false .\n.   \n.   The first constructor initializes StereoSGBM with all the default parameters. So, you only have to\n.   set StereoSGBM::numDisparities at minimum. The second constructor enables you to set each parameter\n.   to a custom value."},
    {"TrackerBoosting_create", (PyCFunction)pyopencv_cv_TrackerBoosting_create, METH_VARARGS | METH_KEYWORDS, "TrackerBoosting_create() -> retval\n.   @brief Constructor\n.   @param parameters BOOSTING parameters TrackerBoosting::Params"},
    {"TrackerCSRT_create", (PyCFunction)pyopencv_cv_TrackerCSRT_create, METH_VARARGS | METH_KEYWORDS, "TrackerCSRT_create() -> retval\n.   @brief Constructor\n.   @param parameters CSRT parameters TrackerCSRT::Params"},
    {"TrackerGOTURN_create", (PyCFunction)pyopencv_cv_TrackerGOTURN_create, METH_VARARGS | METH_KEYWORDS, "TrackerGOTURN_create() -> retval\n.   @brief Constructor\n.   @param parameters GOTURN parameters TrackerGOTURN::Params"},
    {"TrackerKCF_create", (PyCFunction)pyopencv_cv_TrackerKCF_create, METH_VARARGS | METH_KEYWORDS, "TrackerKCF_create() -> retval\n.   @brief Constructor\n.   @param parameters KCF parameters TrackerKCF::Params"},
    {"TrackerMIL_create", (PyCFunction)pyopencv_cv_TrackerMIL_create, METH_VARARGS | METH_KEYWORDS, "TrackerMIL_create() -> retval\n.   @brief Constructor\n.   @param parameters MIL parameters TrackerMIL::Params"},
    {"TrackerMOSSE_create", (PyCFunction)pyopencv_cv_TrackerMOSSE_create, METH_VARARGS | METH_KEYWORDS, "TrackerMOSSE_create() -> retval\n.   @brief Constructor"},
    {"TrackerMedianFlow_create", (PyCFunction)pyopencv_cv_TrackerMedianFlow_create, METH_VARARGS | METH_KEYWORDS, "TrackerMedianFlow_create() -> retval\n.   @brief Constructor\n.   @param parameters Median Flow parameters TrackerMedianFlow::Params"},
    {"TrackerTLD_create", (PyCFunction)pyopencv_cv_TrackerTLD_create, METH_VARARGS | METH_KEYWORDS, "TrackerTLD_create() -> retval\n.   @brief Constructor\n.   @param parameters TLD parameters TrackerTLD::Params"},
    {"VideoWriter_fourcc", (PyCFunction)pyopencv_cv_VideoWriter_fourcc, METH_VARARGS | METH_KEYWORDS, "VideoWriter_fourcc(c1, c2, c3, c4) -> retval\n.   @brief Concatenates 4 chars to a fourcc code\n.   \n.   @return a fourcc code\n.   \n.   This static method constructs the fourcc code of the codec to be used in the constructor\n.   VideoWriter::VideoWriter or VideoWriter::open."},
    {"absdiff", (PyCFunction)pyopencv_cv_absdiff, METH_VARARGS | METH_KEYWORDS, "absdiff(src1, src2[, dst]) -> dst\n.   @brief Calculates the per-element absolute difference between two arrays or between an array and a scalar.\n.   \n.   The function cv::absdiff calculates:\n.   *   Absolute difference between two arrays when they have the same\n.   size and type:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{src2}(I)|)\\f]\n.   *   Absolute difference between an array and a scalar when the second\n.   array is constructed from Scalar or has as many elements as the\n.   number of channels in `src1`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1}(I) -  \\texttt{src2} |)\\f]\n.   *   Absolute difference between a scalar and an array when the first\n.   array is constructed from Scalar or has as many elements as the\n.   number of channels in `src2`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} (| \\texttt{src1} -  \\texttt{src2}(I) |)\\f]\n.   where I is a multi-dimensional index of array elements. In case of\n.   multi-channel arrays, each channel is processed independently.\n.   @note Saturation is not applied when the arrays have the depth CV_32S.\n.   You may even get a negative value in the case of overflow.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as input arrays.\n.   @sa cv::abs(const Mat&)"},
    {"accumulate", (PyCFunction)pyopencv_cv_accumulate, METH_VARARGS | METH_KEYWORDS, "accumulate(src, dst[, mask]) -> dst\n.   @brief Adds an image to the accumulator image.\n.   \n.   The function adds src or some of its elements to dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   The function cv::accumulate can be used, for example, to collect statistics of a scene background\n.   viewed by a still camera and for the further foreground-background segmentation.\n.   \n.   @param src Input image of type CV_8UC(n), CV_16UC(n), CV_32FC(n) or CV_64FC(n), where n is a positive integer.\n.   @param dst %Accumulator image with the same number of channels as input image, and a depth of CV_32F or CV_64F.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulateSquare, accumulateProduct, accumulateWeighted"},
    {"accumulateProduct", (PyCFunction)pyopencv_cv_accumulateProduct, METH_VARARGS | METH_KEYWORDS, "accumulateProduct(src1, src2, dst[, mask]) -> dst\n.   @brief Adds the per-element product of two input images to the accumulator image.\n.   \n.   The function adds the product of two images or their selected regions to the accumulator dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src1} (x,y)  \\cdot \\texttt{src2} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src1 First input image, 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param src2 Second input image of the same type and the same size as src1 .\n.   @param dst %Accumulator image with the same number of channels as input images, 32-bit or 64-bit\n.   floating-point.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulate, accumulateSquare, accumulateWeighted"},
    {"accumulateSquare", (PyCFunction)pyopencv_cv_accumulateSquare, METH_VARARGS | METH_KEYWORDS, "accumulateSquare(src, dst[, mask]) -> dst\n.   @brief Adds the square of a source image to the accumulator image.\n.   \n.   The function adds the input image src or its selected region, raised to a power of 2, to the\n.   accumulator dst :\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow \\texttt{dst} (x,y) +  \\texttt{src} (x,y)^2  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src Input image as 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param dst %Accumulator image with the same number of channels as input image, 32-bit or 64-bit\n.   floating-point.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulateSquare, accumulateProduct, accumulateWeighted"},
    {"accumulateWeighted", (PyCFunction)pyopencv_cv_accumulateWeighted, METH_VARARGS | METH_KEYWORDS, "accumulateWeighted(src, dst, alpha[, mask]) -> dst\n.   @brief Updates a running average.\n.   \n.   The function calculates the weighted sum of the input image src and the accumulator dst so that dst\n.   becomes a running average of a frame sequence:\n.   \n.   \\f[\\texttt{dst} (x,y)  \\leftarrow (1- \\texttt{alpha} )  \\cdot \\texttt{dst} (x,y) +  \\texttt{alpha} \\cdot \\texttt{src} (x,y)  \\quad \\text{if} \\quad \\texttt{mask} (x,y)  \\ne 0\\f]\n.   \n.   That is, alpha regulates the update speed (how fast the accumulator \"forgets\" about earlier images).\n.   The function supports multi-channel images. Each channel is processed independently.\n.   \n.   @param src Input image as 1- or 3-channel, 8-bit or 32-bit floating point.\n.   @param dst %Accumulator image with the same number of channels as input image, 32-bit or 64-bit\n.   floating-point.\n.   @param alpha Weight of the input image.\n.   @param mask Optional operation mask.\n.   \n.   @sa  accumulate, accumulateSquare, accumulateProduct"},
    {"adaptiveThreshold", (PyCFunction)pyopencv_cv_adaptiveThreshold, METH_VARARGS | METH_KEYWORDS, "adaptiveThreshold(src, maxValue, adaptiveMethod, thresholdType, blockSize, C[, dst]) -> dst\n.   @brief Applies an adaptive threshold to an array.\n.   \n.   The function transforms a grayscale image to a binary image according to the formulae:\n.   -   **THRESH_BINARY**\n.   \\f[dst(x,y) =  \\fork{\\texttt{maxValue}}{if \\(src(x,y) > T(x,y)\\)}{0}{otherwise}\\f]\n.   -   **THRESH_BINARY_INV**\n.   \\f[dst(x,y) =  \\fork{0}{if \\(src(x,y) > T(x,y)\\)}{\\texttt{maxValue}}{otherwise}\\f]\n.   where \\f$T(x,y)\\f$ is a threshold calculated individually for each pixel (see adaptiveMethod parameter).\n.   \n.   The function can process the image in-place.\n.   \n.   @param src Source 8-bit single-channel image.\n.   @param dst Destination image of the same size and the same type as src.\n.   @param maxValue Non-zero value assigned to the pixels for which the condition is satisfied\n.   @param adaptiveMethod Adaptive thresholding algorithm to use, see #AdaptiveThresholdTypes.\n.   The #BORDER_REPLICATE | #BORDER_ISOLATED is used to process boundaries.\n.   @param thresholdType Thresholding type that must be either #THRESH_BINARY or #THRESH_BINARY_INV,\n.   see #ThresholdTypes.\n.   @param blockSize Size of a pixel neighborhood that is used to calculate a threshold value for the\n.   pixel: 3, 5, 7, and so on.\n.   @param C Constant subtracted from the mean or weighted mean (see the details below). Normally, it\n.   is positive but may be zero or negative as well.\n.   \n.   @sa  threshold, blur, GaussianBlur"},
    {"add", (PyCFunction)pyopencv_cv_add, METH_VARARGS | METH_KEYWORDS, "add(src1, src2[, dst[, mask[, dtype]]]) -> dst\n.   @brief Calculates the per-element sum of two arrays or an array and a scalar.\n.   \n.   The function add calculates:\n.   - Sum of two arrays when both input arrays have the same size and the same number of channels:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) +  \\texttt{src2}(I)) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Sum of an array and a scalar when src2 is constructed from Scalar or has the same number of\n.   elements as `src1.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) +  \\texttt{src2} ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Sum of a scalar and an array when src1 is constructed from Scalar or has the same number of\n.   elements as `src2.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1} +  \\texttt{src2}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   where `I` is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   \n.   The first function in the list above can be replaced with matrix expressions:\n.   @code{.cpp}\n.   dst = src1 + src2;\n.   dst += src1; // equivalent to add(dst, src1, dst);\n.   @endcode\n.   The input arrays and the output array can all have the same or different depths. For example, you\n.   can add a 16-bit unsigned array to a 8-bit signed array and store the sum as a 32-bit\n.   floating-point array. Depth of the output array is determined by the dtype parameter. In the second\n.   and third cases above, as well as in the first case, when src1.depth() == src2.depth(), dtype can\n.   be set to the default -1. In this case, the output array will have the same depth as the input\n.   array, be it src1, src2 or both.\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and number of channels as the input array(s); the\n.   depth is defined by dtype or src1/src2.\n.   @param mask optional operation mask - 8-bit single channel array, that specifies elements of the\n.   output array to be changed.\n.   @param dtype optional depth of the output array (see the discussion below).\n.   @sa subtract, addWeighted, scaleAdd, Mat::convertTo"},
    {"addText", (PyCFunction)pyopencv_cv_addText, METH_VARARGS | METH_KEYWORDS, "addText(img, text, org, nameFont[, pointSize[, color[, weight[, style[, spacing]]]]]) -> None\n.   @brief Draws a text on the image.\n.   \n.   @param img 8-bit 3-channel image where the text should be drawn.\n.   @param text Text to write on an image.\n.   @param org Point(x,y) where the text should start on an image.\n.   @param nameFont Name of the font. The name should match the name of a system font (such as\n.   *Times*). If the font is not found, a default one is used.\n.   @param pointSize Size of the font. If not specified, equal zero or negative, the point size of the\n.   font is set to a system-dependent default value. Generally, this is 12 points.\n.   @param color Color of the font in BGRA where A = 255 is fully transparent.\n.   @param weight Font weight. Available operation flags are : cv::QtFontWeights You can also specify a positive integer for better control.\n.   @param style Font style. Available operation flags are : cv::QtFontStyles\n.   @param spacing Spacing between characters. It can be negative or positive."},
    {"addWeighted", (PyCFunction)pyopencv_cv_addWeighted, METH_VARARGS | METH_KEYWORDS, "addWeighted(src1, alpha, src2, beta, gamma[, dst[, dtype]]) -> dst\n.   @brief Calculates the weighted sum of two arrays.\n.   \n.   The function addWeighted calculates the weighted sum of two arrays as follows:\n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{src1} (I)* \\texttt{alpha} +  \\texttt{src2} (I)* \\texttt{beta} +  \\texttt{gamma} )\\f]\n.   where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   The function can be replaced with a matrix expression:\n.   @code{.cpp}\n.   dst = src1*alpha + src2*beta + gamma;\n.   @endcode\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @param src1 first input array.\n.   @param alpha weight of the first array elements.\n.   @param src2 second input array of the same size and channel number as src1.\n.   @param beta weight of the second array elements.\n.   @param gamma scalar added to each sum.\n.   @param dst output array that has the same size and number of channels as the input arrays.\n.   @param dtype optional depth of the output array; when both input arrays have the same depth, dtype\n.   can be set to -1, which will be equivalent to src1.depth().\n.   @sa  add, subtract, scaleAdd, Mat::convertTo"},
    {"applyColorMap", (PyCFunction)pyopencv_cv_applyColorMap, METH_VARARGS | METH_KEYWORDS, "applyColorMap(src, colormap[, dst]) -> dst\n.   @brief Applies a GNU Octave/MATLAB equivalent colormap on a given image.\n.   \n.   @param src The source image, grayscale or colored of type CV_8UC1 or CV_8UC3.\n.   @param dst The result is the colormapped source image. Note: Mat::create is called on dst.\n.   @param colormap The colormap to apply, see #ColormapTypes\n\n\n\napplyColorMap(src, userColor[, dst]) -> dst\n.   @brief Applies a user colormap on a given image.\n.   \n.   @param src The source image, grayscale or colored of type CV_8UC1 or CV_8UC3.\n.   @param dst The result is the colormapped source image. Note: Mat::create is called on dst.\n.   @param userColor The colormap to apply of type CV_8UC1 or CV_8UC3 and size 256"},
    {"approxPolyDP", (PyCFunction)pyopencv_cv_approxPolyDP, METH_VARARGS | METH_KEYWORDS, "approxPolyDP(curve, epsilon, closed[, approxCurve]) -> approxCurve\n.   @brief Approximates a polygonal curve(s) with the specified precision.\n.   \n.   The function cv::approxPolyDP approximates a curve or a polygon with another curve/polygon with less\n.   vertices so that the distance between them is less or equal to the specified precision. It uses the\n.   Douglas-Peucker algorithm <http://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm>\n.   \n.   @param curve Input vector of a 2D point stored in std::vector or Mat\n.   @param approxCurve Result of the approximation. The type should match the type of the input curve.\n.   @param epsilon Parameter specifying the approximation accuracy. This is the maximum distance\n.   between the original curve and its approximation.\n.   @param closed If true, the approximated curve is closed (its first and last vertices are\n.   connected). Otherwise, it is not closed."},
    {"arcLength", (PyCFunction)pyopencv_cv_arcLength, METH_VARARGS | METH_KEYWORDS, "arcLength(curve, closed) -> retval\n.   @brief Calculates a contour perimeter or a curve length.\n.   \n.   The function computes a curve length or a closed contour perimeter.\n.   \n.   @param curve Input vector of 2D points, stored in std::vector or Mat.\n.   @param closed Flag indicating whether the curve is closed or not."},
    {"arrowedLine", (PyCFunction)pyopencv_cv_arrowedLine, METH_VARARGS | METH_KEYWORDS, "arrowedLine(img, pt1, pt2, color[, thickness[, line_type[, shift[, tipLength]]]]) -> img\n.   @brief Draws a arrow segment pointing from the first point to the second one.\n.   \n.   The function cv::arrowedLine draws an arrow between pt1 and pt2 points in the image. See also #line.\n.   \n.   @param img Image.\n.   @param pt1 The point the arrow starts from.\n.   @param pt2 The point the arrow points to.\n.   @param color Line color.\n.   @param thickness Line thickness.\n.   @param line_type Type of the line. See #LineTypes\n.   @param shift Number of fractional bits in the point coordinates.\n.   @param tipLength The length of the arrow tip in relation to the arrow length"},
    {"batchDistance", (PyCFunction)pyopencv_cv_batchDistance, METH_VARARGS | METH_KEYWORDS, "batchDistance(src1, src2, dtype[, dist[, nidx[, normType[, K[, mask[, update[, crosscheck]]]]]]]) -> dist, nidx\n.   @brief naive nearest neighbor finder\n.   \n.   see http://en.wikipedia.org/wiki/Nearest_neighbor_search\n.   @todo document"},
    {"bilateralFilter", (PyCFunction)pyopencv_cv_bilateralFilter, METH_VARARGS | METH_KEYWORDS, "bilateralFilter(src, d, sigmaColor, sigmaSpace[, dst[, borderType]]) -> dst\n.   @brief Applies the bilateral filter to an image.\n.   \n.   The function applies bilateral filtering to the input image, as described in\n.   http://www.dai.ed.ac.uk/CVonline/LOCAL_COPIES/MANDUCHI1/Bilateral_Filtering.html\n.   bilateralFilter can reduce unwanted noise very well while keeping edges fairly sharp. However, it is\n.   very slow compared to most filters.\n.   \n.   _Sigma values_: For simplicity, you can set the 2 sigma values to be the same. If they are small (\\<\n.   10), the filter will not have much effect, whereas if they are large (\\> 150), they will have a very\n.   strong effect, making the image look \"cartoonish\".\n.   \n.   _Filter size_: Large filters (d \\> 5) are very slow, so it is recommended to use d=5 for real-time\n.   applications, and perhaps d=9 for offline applications that need heavy noise filtering.\n.   \n.   This filter does not work inplace.\n.   @param src Source 8-bit or floating-point, 1-channel or 3-channel image.\n.   @param dst Destination image of the same size and type as src .\n.   @param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,\n.   it is computed from sigmaSpace.\n.   @param sigmaColor Filter sigma in the color space. A larger value of the parameter means that\n.   farther colors within the pixel neighborhood (see sigmaSpace) will be mixed together, resulting\n.   in larger areas of semi-equal color.\n.   @param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that\n.   farther pixels will influence each other as long as their colors are close enough (see sigmaColor\n.   ). When d\\>0, it specifies the neighborhood size regardless of sigmaSpace. Otherwise, d is\n.   proportional to sigmaSpace.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes"},
    {"bitwise_and", (PyCFunction)pyopencv_cv_bitwise_and, METH_VARARGS | METH_KEYWORDS, "bitwise_and(src1, src2[, dst[, mask]]) -> dst\n.   @brief computes bitwise conjunction of the two arrays (dst = src1 & src2)\n.   Calculates the per-element bit-wise conjunction of two arrays or an\n.   array and a scalar.\n.   \n.   The function cv::bitwise_and calculates the per-element bit-wise logical conjunction for:\n.   *   Two arrays when src1 and src2 have the same size:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\wedge \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.   the same number of elements as `src1.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\wedge \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.   the same number of elements as `src2.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\wedge \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the second and third cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_not", (PyCFunction)pyopencv_cv_bitwise_not, METH_VARARGS | METH_KEYWORDS, "bitwise_not(src[, dst[, mask]]) -> dst\n.   @brief  Inverts every bit of an array.\n.   \n.   The function cv::bitwise_not calculates per-element bit-wise inversion of the input\n.   array:\n.   \\f[\\texttt{dst} (I) =  \\neg \\texttt{src} (I)\\f]\n.   In case of a floating-point input array, its machine-specific bit\n.   representation (usually IEEE754-compliant) is used for the operation. In\n.   case of multi-channel arrays, each channel is processed independently.\n.   @param src input array.\n.   @param dst output array that has the same size and type as the input\n.   array.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_or", (PyCFunction)pyopencv_cv_bitwise_or, METH_VARARGS | METH_KEYWORDS, "bitwise_or(src1, src2[, dst[, mask]]) -> dst\n.   @brief Calculates the per-element bit-wise disjunction of two arrays or an\n.   array and a scalar.\n.   \n.   The function cv::bitwise_or calculates the per-element bit-wise logical disjunction for:\n.   *   Two arrays when src1 and src2 have the same size:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\vee \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.   the same number of elements as `src1.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\vee \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.   the same number of elements as `src2.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\vee \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the second and third cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"bitwise_xor", (PyCFunction)pyopencv_cv_bitwise_xor, METH_VARARGS | METH_KEYWORDS, "bitwise_xor(src1, src2[, dst[, mask]]) -> dst\n.   @brief Calculates the per-element bit-wise \"exclusive or\" operation on two\n.   arrays or an array and a scalar.\n.   \n.   The function cv::bitwise_xor calculates the per-element bit-wise logical \"exclusive-or\"\n.   operation for:\n.   *   Two arrays when src1 and src2 have the same size:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\oplus \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   An array and a scalar when src2 is constructed from Scalar or has\n.   the same number of elements as `src1.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\oplus \\texttt{src2} \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   *   A scalar and an array when src1 is constructed from Scalar or has\n.   the same number of elements as `src2.channels()`:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\oplus \\texttt{src2} (I) \\quad \\texttt{if mask} (I) \\ne0\\f]\n.   In case of floating-point arrays, their machine-specific bit\n.   representations (usually IEEE754-compliant) are used for the operation.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. In the 2nd and 3rd cases above, the scalar is first\n.   converted to the array type.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array that has the same size and type as the input\n.   arrays.\n.   @param mask optional operation mask, 8-bit single channel array, that\n.   specifies elements of the output array to be changed."},
    {"blur", (PyCFunction)pyopencv_cv_blur, METH_VARARGS | METH_KEYWORDS, "blur(src, ksize[, dst[, anchor[, borderType]]]) -> dst\n.   @brief Blurs an image using the normalized box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\frac{1}{\\texttt{ksize.width*ksize.height}} \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\end{bmatrix}\\f]\n.   \n.   The call `blur(src, dst, ksize, anchor, borderType)` is equivalent to `boxFilter(src, dst, src.type(),\n.   anchor, true, borderType)`.\n.   \n.   @param src input image; it can have any number of channels, which are processed independently, but\n.   the depth should be CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param ksize blurring kernel size.\n.   @param anchor anchor point; default value Point(-1,-1) means that the anchor is at the kernel\n.   center.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes\n.   @sa  boxFilter, bilateralFilter, GaussianBlur, medianBlur"},
    {"borderInterpolate", (PyCFunction)pyopencv_cv_borderInterpolate, METH_VARARGS | METH_KEYWORDS, "borderInterpolate(p, len, borderType) -> retval\n.   @brief Computes the source location of an extrapolated pixel.\n.   \n.   The function computes and returns the coordinate of a donor pixel corresponding to the specified\n.   extrapolated pixel when using the specified extrapolation border mode. For example, if you use\n.   cv::BORDER_WRAP mode in the horizontal direction, cv::BORDER_REFLECT_101 in the vertical direction and\n.   want to compute value of the \"virtual\" pixel Point(-5, 100) in a floating-point image img , it\n.   looks like:\n.   @code{.cpp}\n.   float val = img.at<float>(borderInterpolate(100, img.rows, cv::BORDER_REFLECT_101),\n.   borderInterpolate(-5, img.cols, cv::BORDER_WRAP));\n.   @endcode\n.   Normally, the function is not called directly. It is used inside filtering functions and also in\n.   copyMakeBorder.\n.   @param p 0-based coordinate of the extrapolated pixel along one of the axes, likely \\<0 or \\>= len\n.   @param len Length of the array along the corresponding axis.\n.   @param borderType Border type, one of the #BorderTypes, except for #BORDER_TRANSPARENT and\n.   #BORDER_ISOLATED . When borderType==#BORDER_CONSTANT , the function always returns -1, regardless\n.   of p and len.\n.   \n.   @sa copyMakeBorder"},
    {"boundingRect", (PyCFunction)pyopencv_cv_boundingRect, METH_VARARGS | METH_KEYWORDS, "boundingRect(points) -> retval\n.   @brief Calculates the up-right bounding rectangle of a point set.\n.   \n.   The function calculates and returns the minimal up-right bounding rectangle for the specified point set.\n.   \n.   @param points Input 2D point set, stored in std::vector or Mat."},
    {"boxFilter", (PyCFunction)pyopencv_cv_boxFilter, METH_VARARGS | METH_KEYWORDS, "boxFilter(src, ddepth, ksize[, dst[, anchor[, normalize[, borderType]]]]) -> dst\n.   @brief Blurs an image using the box filter.\n.   \n.   The function smooths an image using the kernel:\n.   \n.   \\f[\\texttt{K} =  \\alpha \\begin{bmatrix} 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1  \\\\ \\hdotsfor{6} \\\\ 1 & 1 & 1 &  \\cdots & 1 & 1 \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[\\alpha = \\fork{\\frac{1}{\\texttt{ksize.width*ksize.height}}}{when \\texttt{normalize=true}}{1}{otherwise}\\f]\n.   \n.   Unnormalized box filter is useful for computing various integral characteristics over each pixel\n.   neighborhood, such as covariance matrices of image derivatives (used in dense optical flow\n.   algorithms, and so on). If you need to compute pixel sums over variable-size windows, use #integral.\n.   \n.   @param src input image.\n.   @param dst output image of the same size and type as src.\n.   @param ddepth the output image depth (-1 to use src.depth()).\n.   @param ksize blurring kernel size.\n.   @param anchor anchor point; default value Point(-1,-1) means that the anchor is at the kernel\n.   center.\n.   @param normalize flag, specifying whether the kernel is normalized by its area or not.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes\n.   @sa  blur, bilateralFilter, GaussianBlur, medianBlur, integral"},
    {"boxPoints", (PyCFunction)pyopencv_cv_boxPoints, METH_VARARGS | METH_KEYWORDS, "boxPoints(box[, points]) -> points\n.   @brief Finds the four vertices of a rotated rect. Useful to draw the rotated rectangle.\n.   \n.   The function finds the four vertices of a rotated rectangle. This function is useful to draw the\n.   rectangle. In C++, instead of using this function, you can directly use RotatedRect::points method. Please\n.   visit the @ref tutorial_bounding_rotated_ellipses \"tutorial on Creating Bounding rotated boxes and ellipses for contours\" for more information.\n.   \n.   @param box The input rotated rectangle. It may be the output of\n.   @param points The output array of four vertices of rectangles."},
    {"buildOpticalFlowPyramid", (PyCFunction)pyopencv_cv_buildOpticalFlowPyramid, METH_VARARGS | METH_KEYWORDS, "buildOpticalFlowPyramid(img, winSize, maxLevel[, pyramid[, withDerivatives[, pyrBorder[, derivBorder[, tryReuseInputImage]]]]]) -> retval, pyramid\n.   @brief Constructs the image pyramid which can be passed to calcOpticalFlowPyrLK.\n.   \n.   @param img 8-bit input image.\n.   @param pyramid output pyramid.\n.   @param winSize window size of optical flow algorithm. Must be not less than winSize argument of\n.   calcOpticalFlowPyrLK. It is needed to calculate required padding for pyramid levels.\n.   @param maxLevel 0-based maximal pyramid level number.\n.   @param withDerivatives set to precompute gradients for the every pyramid level. If pyramid is\n.   constructed without the gradients then calcOpticalFlowPyrLK will calculate them internally.\n.   @param pyrBorder the border mode for pyramid layers.\n.   @param derivBorder the border mode for gradients.\n.   @param tryReuseInputImage put ROI of input image into the pyramid if possible. You can pass false\n.   to force data copying.\n.   @return number of levels in constructed pyramid. Can be less than maxLevel."},
    {"calcBackProject", (PyCFunction)pyopencv_cv_calcBackProject, METH_VARARGS | METH_KEYWORDS, "calcBackProject(images, channels, hist, ranges, scale[, dst]) -> dst\n.   @overload"},
    {"calcCovarMatrix", (PyCFunction)pyopencv_cv_calcCovarMatrix, METH_VARARGS | METH_KEYWORDS, "calcCovarMatrix(samples, mean, flags[, covar[, ctype]]) -> covar, mean\n.   @overload\n.   @note use #COVAR_ROWS or #COVAR_COLS flag\n.   @param samples samples stored as rows/columns of a single matrix.\n.   @param covar output covariance matrix of the type ctype and square size.\n.   @param mean input or output (depending on the flags) array as the average value of the input vectors.\n.   @param flags operation flags as a combination of #CovarFlags\n.   @param ctype type of the matrixl; it equals 'CV_64F' by default."},
    {"calcHist", (PyCFunction)pyopencv_cv_calcHist, METH_VARARGS | METH_KEYWORDS, "calcHist(images, channels, mask, histSize, ranges[, hist[, accumulate]]) -> hist\n.   @overload"},
    {"calcOpticalFlowFarneback", (PyCFunction)pyopencv_cv_calcOpticalFlowFarneback, METH_VARARGS | METH_KEYWORDS, "calcOpticalFlowFarneback(prev, next, flow, pyr_scale, levels, winsize, iterations, poly_n, poly_sigma, flags) -> flow\n.   @brief Computes a dense optical flow using the Gunnar Farneback's algorithm.\n.   \n.   @param prev first 8-bit single-channel input image.\n.   @param next second input image of the same size and the same type as prev.\n.   @param flow computed flow image that has the same size as prev and type CV_32FC2.\n.   @param pyr_scale parameter, specifying the image scale (\\<1) to build pyramids for each image;\n.   pyr_scale=0.5 means a classical pyramid, where each next layer is twice smaller than the previous\n.   one.\n.   @param levels number of pyramid layers including the initial image; levels=1 means that no extra\n.   layers are created and only the original images are used.\n.   @param winsize averaging window size; larger values increase the algorithm robustness to image\n.   noise and give more chances for fast motion detection, but yield more blurred motion field.\n.   @param iterations number of iterations the algorithm does at each pyramid level.\n.   @param poly_n size of the pixel neighborhood used to find polynomial expansion in each pixel;\n.   larger values mean that the image will be approximated with smoother surfaces, yielding more\n.   robust algorithm and more blurred motion field, typically poly_n =5 or 7.\n.   @param poly_sigma standard deviation of the Gaussian that is used to smooth derivatives used as a\n.   basis for the polynomial expansion; for poly_n=5, you can set poly_sigma=1.1, for poly_n=7, a\n.   good value would be poly_sigma=1.5.\n.   @param flags operation flags that can be a combination of the following:\n.   -   **OPTFLOW_USE_INITIAL_FLOW** uses the input flow as an initial flow approximation.\n.   -   **OPTFLOW_FARNEBACK_GAUSSIAN** uses the Gaussian \\f$\\texttt{winsize}\\times\\texttt{winsize}\\f$\n.   filter instead of a box filter of the same size for optical flow estimation; usually, this\n.   option gives z more accurate flow than with a box filter, at the cost of lower speed;\n.   normally, winsize for a Gaussian window should be set to a larger value to achieve the same\n.   level of robustness.\n.   \n.   The function finds an optical flow for each prev pixel using the @cite Farneback2003 algorithm so that\n.   \n.   \\f[\\texttt{prev} (y,x)  \\sim \\texttt{next} ( y + \\texttt{flow} (y,x)[1],  x + \\texttt{flow} (y,x)[0])\\f]\n.   \n.   @note\n.   \n.   -   An example using the optical flow algorithm described by Gunnar Farneback can be found at\n.   opencv_source_code/samples/cpp/fback.cpp\n.   -   (Python) An example using the optical flow algorithm described by Gunnar Farneback can be\n.   found at opencv_source_code/samples/python/opt_flow.py"},
    {"calcOpticalFlowPyrLK", (PyCFunction)pyopencv_cv_calcOpticalFlowPyrLK, METH_VARARGS | METH_KEYWORDS, "calcOpticalFlowPyrLK(prevImg, nextImg, prevPts, nextPts[, status[, err[, winSize[, maxLevel[, criteria[, flags[, minEigThreshold]]]]]]]) -> nextPts, status, err\n.   @brief Calculates an optical flow for a sparse feature set using the iterative Lucas-Kanade method with\n.   pyramids.\n.   \n.   @param prevImg first 8-bit input image or pyramid constructed by buildOpticalFlowPyramid.\n.   @param nextImg second input image or pyramid of the same size and the same type as prevImg.\n.   @param prevPts vector of 2D points for which the flow needs to be found; point coordinates must be\n.   single-precision floating-point numbers.\n.   @param nextPts output vector of 2D points (with single-precision floating-point coordinates)\n.   containing the calculated new positions of input features in the second image; when\n.   OPTFLOW_USE_INITIAL_FLOW flag is passed, the vector must have the same size as in the input.\n.   @param status output status vector (of unsigned chars); each element of the vector is set to 1 if\n.   the flow for the corresponding features has been found, otherwise, it is set to 0.\n.   @param err output vector of errors; each element of the vector is set to an error for the\n.   corresponding feature, type of the error measure can be set in flags parameter; if the flow wasn't\n.   found then the error is not defined (use the status parameter to find such cases).\n.   @param winSize size of the search window at each pyramid level.\n.   @param maxLevel 0-based maximal pyramid level number; if set to 0, pyramids are not used (single\n.   level), if set to 1, two levels are used, and so on; if pyramids are passed to input then\n.   algorithm will use as many levels as pyramids have but no more than maxLevel.\n.   @param criteria parameter, specifying the termination criteria of the iterative search algorithm\n.   (after the specified maximum number of iterations criteria.maxCount or when the search window\n.   moves by less than criteria.epsilon.\n.   @param flags operation flags:\n.   -   **OPTFLOW_USE_INITIAL_FLOW** uses initial estimations, stored in nextPts; if the flag is\n.   not set, then prevPts is copied to nextPts and is considered the initial estimate.\n.   -   **OPTFLOW_LK_GET_MIN_EIGENVALS** use minimum eigen values as an error measure (see\n.   minEigThreshold description); if the flag is not set, then L1 distance between patches\n.   around the original and a moved point, divided by number of pixels in a window, is used as a\n.   error measure.\n.   @param minEigThreshold the algorithm calculates the minimum eigen value of a 2x2 normal matrix of\n.   optical flow equations (this matrix is called a spatial gradient matrix in @cite Bouguet00), divided\n.   by number of pixels in a window; if this value is less than minEigThreshold, then a corresponding\n.   feature is filtered out and its flow is not processed, so it allows to remove bad points and get a\n.   performance boost.\n.   \n.   The function implements a sparse iterative version of the Lucas-Kanade optical flow in pyramids. See\n.   @cite Bouguet00 . The function is parallelized with the TBB library.\n.   \n.   @note\n.   \n.   -   An example using the Lucas-Kanade optical flow algorithm can be found at\n.   opencv_source_code/samples/cpp/lkdemo.cpp\n.   -   (Python) An example using the Lucas-Kanade optical flow algorithm can be found at\n.   opencv_source_code/samples/python/lk_track.py\n.   -   (Python) An example using the Lucas-Kanade tracker for homography matching can be found at\n.   opencv_source_code/samples/python/lk_homography.py"},
    {"calibrateCamera", (PyCFunction)pyopencv_cv_calibrateCamera, METH_VARARGS | METH_KEYWORDS, "calibrateCamera(objectPoints, imagePoints, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   @overload double calibrateCamera( InputArrayOfArrays objectPoints,\n.   InputArrayOfArrays imagePoints, Size imageSize,\n.   InputOutputArray cameraMatrix, InputOutputArray distCoeffs,\n.   OutputArrayOfArrays rvecs, OutputArrayOfArrays tvecs,\n.   OutputArray stdDeviations, OutputArray perViewErrors,\n.   int flags = 0, TermCriteria criteria = TermCriteria(\n.   TermCriteria::COUNT + TermCriteria::EPS, 30, DBL_EPSILON) )"},
    {"calibrateCameraExtended", (PyCFunction)pyopencv_cv_calibrateCameraExtended, METH_VARARGS | METH_KEYWORDS, "calibrateCameraExtended(objectPoints, imagePoints, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   @brief Finds the camera intrinsic and extrinsic parameters from several views of a calibration pattern.\n.   \n.   @param objectPoints In the new interface it is a vector of vectors of calibration pattern points in\n.   the calibration pattern coordinate space (e.g. std::vector<std::vector<cv::Vec3f>>). The outer\n.   vector contains as many elements as the number of the pattern views. If the same calibration pattern\n.   is shown in each view and it is fully visible, all the vectors will be the same. Although, it is\n.   possible to use partially occluded patterns, or even different patterns in different views. Then,\n.   the vectors will be different. The points are 3D, but since they are in a pattern coordinate system,\n.   then, if the rig is planar, it may make sense to put the model to a XY coordinate plane so that\n.   Z-coordinate of each input object point is 0.\n.   In the old interface all the vectors of object points from different views are concatenated\n.   together.\n.   @param imagePoints In the new interface it is a vector of vectors of the projections of calibration\n.   pattern points (e.g. std::vector<std::vector<cv::Vec2f>>). imagePoints.size() and\n.   objectPoints.size() and imagePoints[i].size() must be equal to objectPoints[i].size() for each i.\n.   In the old interface all the vectors of object points from different views are concatenated\n.   together.\n.   @param imageSize Size of the image used only to initialize the intrinsic camera matrix.\n.   @param cameraMatrix Output 3x3 floating-point camera matrix\n.   \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If CV\\_CALIB\\_USE\\_INTRINSIC\\_GUESS\n.   and/or CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be\n.   initialized before calling the function.\n.   @param distCoeffs Output vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements.\n.   @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each pattern view\n.   (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding\n.   k-th translation vector (see the next output parameter description) brings the calibration pattern\n.   from the model coordinate space (in which object points are specified) to the world coordinate\n.   space, that is, a real position of the calibration pattern in the k-th pattern view (k=0.. *M* -1).\n.   @param tvecs Output vector of translation vectors estimated for each pattern view.\n.   @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.   Order of deviations values:\n.   \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.   s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.   @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.   Order of deviations values: \\f$(R_1, T_1, \\dotsc , R_M, T_M)\\f$ where M is number of pattern views,\n.   \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.   @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   **CALIB_USE_INTRINSIC_GUESS** cameraMatrix contains valid initial values of\n.   fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.   center ( imageSize is used), and focal distances are computed in a least-squares fashion.\n.   Note, that if intrinsic parameters are known, there is no need to use this function just to\n.   estimate extrinsic parameters. Use solvePnP instead.\n.   -   **CALIB_FIX_PRINCIPAL_POINT** The principal point is not changed during the global\n.   optimization. It stays at the center or at a different location specified when\n.   CALIB_USE_INTRINSIC_GUESS is set too.\n.   -   **CALIB_FIX_ASPECT_RATIO** The functions considers only fy as a free parameter. The\n.   ratio fx/fy stays the same as in the input cameraMatrix . When\n.   CALIB_USE_INTRINSIC_GUESS is not set, the actual input values of fx and fy are\n.   ignored, only their ratio is computed and used further.\n.   -   **CALIB_ZERO_TANGENT_DIST** Tangential distortion coefficients \\f$(p_1, p_2)\\f$ are set\n.   to zeros and stay zero.\n.   -   **CALIB_FIX_K1,...,CALIB_FIX_K6** The corresponding radial distortion\n.   coefficient is not changed during the optimization. If CALIB_USE_INTRINSIC_GUESS is\n.   set, the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   **CALIB_RATIONAL_MODEL** Coefficients k4, k5, and k6 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the rational model and return 8 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_THIN_PRISM_MODEL** Coefficients s1, s2, s3 and s4 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the thin prism model and return 12 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_FIX_S1_S2_S3_S4** The thin prism distortion coefficients are not changed during\n.   the optimization. If CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   **CALIB_TILTED_MODEL** Coefficients tauX and tauY are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the tilted sensor model and return 14 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_FIX_TAUX_TAUY** The coefficients of the tilted sensor model are not changed during\n.   the optimization. If CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   @param criteria Termination criteria for the iterative optimization algorithm.\n.   \n.   @return the overall RMS re-projection error.\n.   \n.   The function estimates the intrinsic camera parameters and extrinsic parameters for each of the\n.   views. The algorithm is based on @cite Zhang2000 and @cite BouguetMCT . The coordinates of 3D object\n.   points and their corresponding 2D projections in each view must be specified. That may be achieved\n.   by using an object with a known geometry and easily detectable feature points. Such an object is\n.   called a calibration rig or calibration pattern, and OpenCV has built-in support for a chessboard as\n.   a calibration rig (see findChessboardCorners ). Currently, initialization of intrinsic parameters\n.   (when CALIB_USE_INTRINSIC_GUESS is not set) is only implemented for planar calibration\n.   patterns (where Z-coordinates of the object points must be all zeros). 3D calibration rigs can also\n.   be used as long as initial cameraMatrix is provided.\n.   \n.   The algorithm performs the following steps:\n.   \n.   -   Compute the initial intrinsic parameters (the option only available for planar calibration\n.   patterns) or read them from the input parameters. The distortion coefficients are all set to\n.   zeros initially unless some of CALIB_FIX_K? are specified.\n.   \n.   -   Estimate the initial camera pose as if the intrinsic parameters have been already known. This is\n.   done using solvePnP .\n.   \n.   -   Run the global Levenberg-Marquardt optimization algorithm to minimize the reprojection error,\n.   that is, the total sum of squared distances between the observed feature points imagePoints and\n.   the projected (using the current estimates for camera parameters and the poses) object points\n.   objectPoints. See projectPoints for details.\n.   \n.   @note\n.   If you use a non-square (=non-NxN) grid and findChessboardCorners for calibration, and\n.   calibrateCamera returns bad values (zero distortion coefficients, an image center very far from\n.   (w/2-0.5,h/2-0.5), and/or large differences between \\f$f_x\\f$ and \\f$f_y\\f$ (ratios of 10:1 or more)),\n.   then you have probably used patternSize=cvSize(rows,cols) instead of using\n.   patternSize=cvSize(cols,rows) in findChessboardCorners .\n.   \n.   @sa\n.   findChessboardCorners, solvePnP, initCameraMatrix2D, stereoCalibrate, undistort"},
    {"calibrationMatrixValues", (PyCFunction)pyopencv_cv_calibrationMatrixValues, METH_VARARGS | METH_KEYWORDS, "calibrationMatrixValues(cameraMatrix, imageSize, apertureWidth, apertureHeight) -> fovx, fovy, focalLength, principalPoint, aspectRatio\n.   @brief Computes useful camera characteristics from the camera matrix.\n.   \n.   @param cameraMatrix Input camera matrix that can be estimated by calibrateCamera or\n.   stereoCalibrate .\n.   @param imageSize Input image size in pixels.\n.   @param apertureWidth Physical width in mm of the sensor.\n.   @param apertureHeight Physical height in mm of the sensor.\n.   @param fovx Output field of view in degrees along the horizontal sensor axis.\n.   @param fovy Output field of view in degrees along the vertical sensor axis.\n.   @param focalLength Focal length of the lens in mm.\n.   @param principalPoint Principal point in mm.\n.   @param aspectRatio \\f$f_y/f_x\\f$\n.   \n.   The function computes various useful camera characteristics from the previously estimated camera\n.   matrix.\n.   \n.   @note\n.   Do keep in mind that the unity measure 'mm' stands for whatever unit of measure one chooses for\n.   the chessboard pitch (it can thus be any value)."},
    {"cartToPolar", (PyCFunction)pyopencv_cv_cartToPolar, METH_VARARGS | METH_KEYWORDS, "cartToPolar(x, y[, magnitude[, angle[, angleInDegrees]]]) -> magnitude, angle\n.   @brief Calculates the magnitude and angle of 2D vectors.\n.   \n.   The function cv::cartToPolar calculates either the magnitude, angle, or both\n.   for every 2D vector (x(I),y(I)):\n.   \\f[\\begin{array}{l} \\texttt{magnitude} (I)= \\sqrt{\\texttt{x}(I)^2+\\texttt{y}(I)^2} , \\\\ \\texttt{angle} (I)= \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))[ \\cdot180 / \\pi ] \\end{array}\\f]\n.   \n.   The angles are calculated with accuracy about 0.3 degrees. For the point\n.   (0,0), the angle is set to 0.\n.   @param x array of x-coordinates; this must be a single-precision or\n.   double-precision floating-point array.\n.   @param y array of y-coordinates, that must have the same size and same type as x.\n.   @param magnitude output array of magnitudes of the same size and type as x.\n.   @param angle output array of angles that has the same size and type as\n.   x; the angles are measured in radians (from 0 to 2\\*Pi) or in degrees (0 to 360 degrees).\n.   @param angleInDegrees a flag, indicating whether the angles are measured\n.   in radians (which is by default), or in degrees.\n.   @sa Sobel, Scharr"},
    {"checkHardwareSupport", (PyCFunction)pyopencv_cv_checkHardwareSupport, METH_VARARGS | METH_KEYWORDS, "checkHardwareSupport(feature) -> retval\n.   @brief Returns true if the specified feature is supported by the host hardware.\n.   \n.   The function returns true if the host hardware supports the specified feature. When user calls\n.   setUseOptimized(false), the subsequent calls to checkHardwareSupport() will return false until\n.   setUseOptimized(true) is called. This way user can dynamically switch on and off the optimized code\n.   in OpenCV.\n.   @param feature The feature of interest, one of cv::CpuFeatures"},
    {"checkRange", (PyCFunction)pyopencv_cv_checkRange, METH_VARARGS | METH_KEYWORDS, "checkRange(a[, quiet[, minVal[, maxVal]]]) -> retval, pos\n.   @brief Checks every element of an input array for invalid values.\n.   \n.   The function cv::checkRange checks that every array element is neither NaN nor infinite. When minVal \\>\n.   -DBL_MAX and maxVal \\< DBL_MAX, the function also checks that each value is between minVal and\n.   maxVal. In case of multi-channel arrays, each channel is processed independently. If some values\n.   are out of range, position of the first outlier is stored in pos (when pos != NULL). Then, the\n.   function either returns false (when quiet=true) or throws an exception.\n.   @param a input array.\n.   @param quiet a flag, indicating whether the functions quietly return false when the array elements\n.   are out of range or they throw an exception.\n.   @param pos optional output parameter, when not NULL, must be a pointer to array of src.dims\n.   elements.\n.   @param minVal inclusive lower boundary of valid values range.\n.   @param maxVal exclusive upper boundary of valid values range."},
    {"circle", (PyCFunction)pyopencv_cv_circle, METH_VARARGS | METH_KEYWORDS, "circle(img, center, radius, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a circle.\n.   \n.   The function cv::circle draws a simple or filled circle with a given center and radius.\n.   @param img Image where the circle is drawn.\n.   @param center Center of the circle.\n.   @param radius Radius of the circle.\n.   @param color Circle color.\n.   @param thickness Thickness of the circle outline, if positive. Negative values, like #FILLED,\n.   mean that a filled circle is to be drawn.\n.   @param lineType Type of the circle boundary. See #LineTypes\n.   @param shift Number of fractional bits in the coordinates of the center and in the radius value."},
    {"clipLine", (PyCFunction)pyopencv_cv_clipLine, METH_VARARGS | METH_KEYWORDS, "clipLine(imgRect, pt1, pt2) -> retval, pt1, pt2\n.   @overload\n.   @param imgRect Image rectangle.\n.   @param pt1 First line point.\n.   @param pt2 Second line point."},
    {"colorChange", (PyCFunction)pyopencv_cv_colorChange, METH_VARARGS | METH_KEYWORDS, "colorChange(src, mask[, dst[, red_mul[, green_mul[, blue_mul]]]]) -> dst\n.   @brief Given an original color image, two differently colored versions of this image can be mixed\n.   seamlessly.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param red_mul R-channel multiply factor.\n.   @param green_mul G-channel multiply factor.\n.   @param blue_mul B-channel multiply factor.\n.   \n.   Multiplication factor is between .5 to 2.5."},
    {"compare", (PyCFunction)pyopencv_cv_compare, METH_VARARGS | METH_KEYWORDS, "compare(src1, src2, cmpop[, dst]) -> dst\n.   @brief Performs the per-element comparison of two arrays or an array and scalar value.\n.   \n.   The function compares:\n.   *   Elements of two arrays when src1 and src2 have the same size:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1} (I)  \\,\\texttt{cmpop}\\, \\texttt{src2} (I)\\f]\n.   *   Elements of src1 with a scalar src2 when src2 is constructed from\n.   Scalar or has a single element:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1}(I) \\,\\texttt{cmpop}\\,  \\texttt{src2}\\f]\n.   *   src1 with elements of src2 when src1 is constructed from Scalar or\n.   has a single element:\n.   \\f[\\texttt{dst} (I) =  \\texttt{src1}  \\,\\texttt{cmpop}\\, \\texttt{src2} (I)\\f]\n.   When the comparison result is true, the corresponding element of output\n.   array is set to 255. The comparison operations can be replaced with the\n.   equivalent matrix expressions:\n.   @code{.cpp}\n.   Mat dst1 = src1 >= src2;\n.   Mat dst2 = src1 < 8;\n.   ...\n.   @endcode\n.   @param src1 first input array or a scalar; when it is an array, it must have a single channel.\n.   @param src2 second input array or a scalar; when it is an array, it must have a single channel.\n.   @param dst output array of type ref CV_8U that has the same size and the same number of channels as\n.   the input arrays.\n.   @param cmpop a flag, that specifies correspondence between the arrays (cv::CmpTypes)\n.   @sa checkRange, min, max, threshold"},
    {"compareHist", (PyCFunction)pyopencv_cv_compareHist, METH_VARARGS | METH_KEYWORDS, "compareHist(H1, H2, method) -> retval\n.   @brief Compares two histograms.\n.   \n.   The function cv::compareHist compares two dense or two sparse histograms using the specified method.\n.   \n.   The function returns \\f$d(H_1, H_2)\\f$ .\n.   \n.   While the function works well with 1-, 2-, 3-dimensional dense histograms, it may not be suitable\n.   for high-dimensional sparse histograms. In such histograms, because of aliasing and sampling\n.   problems, the coordinates of non-zero histogram bins can slightly shift. To compare such histograms\n.   or more general sparse configurations of weighted points, consider using the #EMD function.\n.   \n.   @param H1 First compared histogram.\n.   @param H2 Second compared histogram of the same size as H1 .\n.   @param method Comparison method, see #HistCompMethods"},
    {"completeSymm", (PyCFunction)pyopencv_cv_completeSymm, METH_VARARGS | METH_KEYWORDS, "completeSymm(m[, lowerToUpper]) -> m\n.   @brief Copies the lower or the upper half of a square matrix to its another half.\n.   \n.   The function cv::completeSymm copies the lower or the upper half of a square matrix to\n.   its another half. The matrix diagonal remains unchanged:\n.   - \\f$\\texttt{m}_{ij}=\\texttt{m}_{ji}\\f$ for \\f$i > j\\f$ if\n.   lowerToUpper=false\n.   - \\f$\\texttt{m}_{ij}=\\texttt{m}_{ji}\\f$ for \\f$i < j\\f$ if\n.   lowerToUpper=true\n.   \n.   @param m input-output floating-point square matrix.\n.   @param lowerToUpper operation flag; if true, the lower half is copied to\n.   the upper half. Otherwise, the upper half is copied to the lower half.\n.   @sa flip, transpose"},
    {"composeRT", (PyCFunction)pyopencv_cv_composeRT, METH_VARARGS | METH_KEYWORDS, "composeRT(rvec1, tvec1, rvec2, tvec2[, rvec3[, tvec3[, dr3dr1[, dr3dt1[, dr3dr2[, dr3dt2[, dt3dr1[, dt3dt1[, dt3dr2[, dt3dt2]]]]]]]]]]) -> rvec3, tvec3, dr3dr1, dr3dt1, dr3dr2, dr3dt2, dt3dr1, dt3dt1, dt3dr2, dt3dt2\n.   @brief Combines two rotation-and-shift transformations.\n.   \n.   @param rvec1 First rotation vector.\n.   @param tvec1 First translation vector.\n.   @param rvec2 Second rotation vector.\n.   @param tvec2 Second translation vector.\n.   @param rvec3 Output rotation vector of the superposition.\n.   @param tvec3 Output translation vector of the superposition.\n.   @param dr3dr1\n.   @param dr3dt1\n.   @param dr3dr2\n.   @param dr3dt2\n.   @param dt3dr1\n.   @param dt3dt1\n.   @param dt3dr2\n.   @param dt3dt2 Optional output derivatives of rvec3 or tvec3 with regard to rvec1, rvec2, tvec1 and\n.   tvec2, respectively.\n.   \n.   The functions compute:\n.   \n.   \\f[\\begin{array}{l} \\texttt{rvec3} =  \\mathrm{rodrigues} ^{-1} \\left ( \\mathrm{rodrigues} ( \\texttt{rvec2} )  \\cdot \\mathrm{rodrigues} ( \\texttt{rvec1} ) \\right )  \\\\ \\texttt{tvec3} =  \\mathrm{rodrigues} ( \\texttt{rvec2} )  \\cdot \\texttt{tvec1} +  \\texttt{tvec2} \\end{array} ,\\f]\n.   \n.   where \\f$\\mathrm{rodrigues}\\f$ denotes a rotation vector to a rotation matrix transformation, and\n.   \\f$\\mathrm{rodrigues}^{-1}\\f$ denotes the inverse transformation. See Rodrigues for details.\n.   \n.   Also, the functions can compute the derivatives of the output vectors with regards to the input\n.   vectors (see matMulDeriv ). The functions are used inside stereoCalibrate but can also be used in\n.   your own code where Levenberg-Marquardt or another gradient-based solver is used to optimize a\n.   function that contains a matrix multiplication."},
    {"computeCorrespondEpilines", (PyCFunction)pyopencv_cv_computeCorrespondEpilines, METH_VARARGS | METH_KEYWORDS, "computeCorrespondEpilines(points, whichImage, F[, lines]) -> lines\n.   @brief For points in an image of a stereo pair, computes the corresponding epilines in the other image.\n.   \n.   @param points Input points. \\f$N \\times 1\\f$ or \\f$1 \\times N\\f$ matrix of type CV_32FC2 or\n.   vector\\<Point2f\\> .\n.   @param whichImage Index of the image (1 or 2) that contains the points .\n.   @param F Fundamental matrix that can be estimated using findFundamentalMat or stereoRectify .\n.   @param lines Output vector of the epipolar lines corresponding to the points in the other image.\n.   Each line \\f$ax + by + c=0\\f$ is encoded by 3 numbers \\f$(a, b, c)\\f$ .\n.   \n.   For every point in one of the two images of a stereo pair, the function finds the equation of the\n.   corresponding epipolar line in the other image.\n.   \n.   From the fundamental matrix definition (see findFundamentalMat ), line \\f$l^{(2)}_i\\f$ in the second\n.   image for the point \\f$p^{(1)}_i\\f$ in the first image (when whichImage=1 ) is computed as:\n.   \n.   \\f[l^{(2)}_i = F p^{(1)}_i\\f]\n.   \n.   And vice versa, when whichImage=2, \\f$l^{(1)}_i\\f$ is computed from \\f$p^{(2)}_i\\f$ as:\n.   \n.   \\f[l^{(1)}_i = F^T p^{(2)}_i\\f]\n.   \n.   Line coefficients are defined up to a scale. They are normalized so that \\f$a_i^2+b_i^2=1\\f$ ."},
    {"connectedComponents", (PyCFunction)pyopencv_cv_connectedComponents, METH_VARARGS | METH_KEYWORDS, "connectedComponents(image[, labels[, connectivity[, ltype]]]) -> retval, labels\n.   @overload\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported."},
    {"connectedComponentsWithAlgorithm", (PyCFunction)pyopencv_cv_connectedComponentsWithAlgorithm, METH_VARARGS | METH_KEYWORDS, "connectedComponentsWithAlgorithm(image, connectivity, ltype, ccltype[, labels]) -> retval, labels\n.   @brief computes the connected components labeled image of boolean image\n.   \n.   image with 4 or 8 way connectivity - returns N, the total number of labels [0, N-1] where 0\n.   represents the background label. ltype specifies the output label image type, an important\n.   consideration based on the total number of labels or alternatively the total number of pixels in\n.   the source image. ccltype specifies the connected components labeling algorithm to use, currently\n.   Grana (BBDT) and Wu's (SAUF) algorithms are supported, see the #ConnectedComponentsAlgorithmsTypes\n.   for details. Note that SAUF algorithm forces a row major ordering of labels while BBDT does not.\n.   This function uses parallel version of both Grana and Wu's algorithms if at least one allowed\n.   parallel framework is enabled and if the rows of the image are at least twice the number returned by #getNumberOfCPUs.\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported.\n.   @param ccltype connected components algorithm type (see the #ConnectedComponentsAlgorithmsTypes)."},
    {"connectedComponentsWithStats", (PyCFunction)pyopencv_cv_connectedComponentsWithStats, METH_VARARGS | METH_KEYWORDS, "connectedComponentsWithStats(image[, labels[, stats[, centroids[, connectivity[, ltype]]]]]) -> retval, labels, stats, centroids\n.   @overload\n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param stats statistics output for each label, including the background label, see below for\n.   available statistics. Statistics are accessed via stats(label, COLUMN) where COLUMN is one of\n.   #ConnectedComponentsTypes. The data type is CV_32S.\n.   @param centroids centroid output for each label, including the background label. Centroids are\n.   accessed via centroids(label, 0) for x and centroids(label, 1) for y. The data type CV_64F.\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported."},
    {"connectedComponentsWithStatsWithAlgorithm", (PyCFunction)pyopencv_cv_connectedComponentsWithStatsWithAlgorithm, METH_VARARGS | METH_KEYWORDS, "connectedComponentsWithStatsWithAlgorithm(image, connectivity, ltype, ccltype[, labels[, stats[, centroids]]]) -> retval, labels, stats, centroids\n.   @brief computes the connected components labeled image of boolean image and also produces a statistics output for each label\n.   \n.   image with 4 or 8 way connectivity - returns N, the total number of labels [0, N-1] where 0\n.   represents the background label. ltype specifies the output label image type, an important\n.   consideration based on the total number of labels or alternatively the total number of pixels in\n.   the source image. ccltype specifies the connected components labeling algorithm to use, currently\n.   Grana's (BBDT) and Wu's (SAUF) algorithms are supported, see the #ConnectedComponentsAlgorithmsTypes\n.   for details. Note that SAUF algorithm forces a row major ordering of labels while BBDT does not.\n.   This function uses parallel version of both Grana and Wu's algorithms (statistics included) if at least one allowed\n.   parallel framework is enabled and if the rows of the image are at least twice the number returned by #getNumberOfCPUs.\n.   \n.   @param image the 8-bit single-channel image to be labeled\n.   @param labels destination labeled image\n.   @param stats statistics output for each label, including the background label, see below for\n.   available statistics. Statistics are accessed via stats(label, COLUMN) where COLUMN is one of\n.   #ConnectedComponentsTypes. The data type is CV_32S.\n.   @param centroids centroid output for each label, including the background label. Centroids are\n.   accessed via centroids(label, 0) for x and centroids(label, 1) for y. The data type CV_64F.\n.   @param connectivity 8 or 4 for 8-way or 4-way connectivity respectively\n.   @param ltype output image label type. Currently CV_32S and CV_16U are supported.\n.   @param ccltype connected components algorithm type (see #ConnectedComponentsAlgorithmsTypes)."},
    {"contourArea", (PyCFunction)pyopencv_cv_contourArea, METH_VARARGS | METH_KEYWORDS, "contourArea(contour[, oriented]) -> retval\n.   @brief Calculates a contour area.\n.   \n.   The function computes a contour area. Similarly to moments , the area is computed using the Green\n.   formula. Thus, the returned area and the number of non-zero pixels, if you draw the contour using\n.   #drawContours or #fillPoly , can be different. Also, the function will most certainly give a wrong\n.   results for contours with self-intersections.\n.   \n.   Example:\n.   @code\n.   vector<Point> contour;\n.   contour.push_back(Point2f(0, 0));\n.   contour.push_back(Point2f(10, 0));\n.   contour.push_back(Point2f(10, 10));\n.   contour.push_back(Point2f(5, 4));\n.   \n.   double area0 = contourArea(contour);\n.   vector<Point> approx;\n.   approxPolyDP(contour, approx, 5, true);\n.   double area1 = contourArea(approx);\n.   \n.   cout << \"area0 =\" << area0 << endl <<\n.   \"area1 =\" << area1 << endl <<\n.   \"approx poly vertices\" << approx.size() << endl;\n.   @endcode\n.   @param contour Input vector of 2D points (contour vertices), stored in std::vector or Mat.\n.   @param oriented Oriented area flag. If it is true, the function returns a signed area value,\n.   depending on the contour orientation (clockwise or counter-clockwise). Using this feature you can\n.   determine orientation of a contour by taking the sign of an area. By default, the parameter is\n.   false, which means that the absolute value is returned."},
    {"convertFp16", (PyCFunction)pyopencv_cv_convertFp16, METH_VARARGS | METH_KEYWORDS, "convertFp16(src[, dst]) -> dst\n.   @brief Converts an array to half precision floating number.\n.   \n.   This function converts FP32 (single precision floating point) from/to FP16 (half precision floating point).  The input array has to have type of CV_32F or\n.   CV_16S to represent the bit depth.  If the input array is neither of them, the function will raise an error.\n.   The format of half precision floating point is defined in IEEE 754-2008.\n.   \n.   @param src input array.\n.   @param dst output array."},
    {"convertMaps", (PyCFunction)pyopencv_cv_convertMaps, METH_VARARGS | METH_KEYWORDS, "convertMaps(map1, map2, dstmap1type[, dstmap1[, dstmap2[, nninterpolation]]]) -> dstmap1, dstmap2\n.   @brief Converts image transformation maps from one representation to another.\n.   \n.   The function converts a pair of maps for remap from one representation to another. The following\n.   options ( (map1.type(), map2.type()) \\f$\\rightarrow\\f$ (dstmap1.type(), dstmap2.type()) ) are\n.   supported:\n.   \n.   - \\f$\\texttt{(CV_32FC1, CV_32FC1)} \\rightarrow \\texttt{(CV_16SC2, CV_16UC1)}\\f$. This is the\n.   most frequently used conversion operation, in which the original floating-point maps (see remap )\n.   are converted to a more compact and much faster fixed-point representation. The first output array\n.   contains the rounded coordinates and the second array (created only when nninterpolation=false )\n.   contains indices in the interpolation tables.\n.   \n.   - \\f$\\texttt{(CV_32FC2)} \\rightarrow \\texttt{(CV_16SC2, CV_16UC1)}\\f$. The same as above but\n.   the original maps are stored in one 2-channel matrix.\n.   \n.   - Reverse conversion. Obviously, the reconstructed floating-point maps will not be exactly the same\n.   as the originals.\n.   \n.   @param map1 The first input map of type CV_16SC2, CV_32FC1, or CV_32FC2 .\n.   @param map2 The second input map of type CV_16UC1, CV_32FC1, or none (empty matrix),\n.   respectively.\n.   @param dstmap1 The first output map that has the type dstmap1type and the same size as src .\n.   @param dstmap2 The second output map.\n.   @param dstmap1type Type of the first output map that should be CV_16SC2, CV_32FC1, or\n.   CV_32FC2 .\n.   @param nninterpolation Flag indicating whether the fixed-point maps are used for the\n.   nearest-neighbor or for a more complex interpolation.\n.   \n.   @sa  remap, undistort, initUndistortRectifyMap"},
    {"convertPointsFromHomogeneous", (PyCFunction)pyopencv_cv_convertPointsFromHomogeneous, METH_VARARGS | METH_KEYWORDS, "convertPointsFromHomogeneous(src[, dst]) -> dst\n.   @brief Converts points from homogeneous to Euclidean space.\n.   \n.   @param src Input vector of N-dimensional points.\n.   @param dst Output vector of N-1-dimensional points.\n.   \n.   The function converts points homogeneous to Euclidean space using perspective projection. That is,\n.   each point (x1, x2, ... x(n-1), xn) is converted to (x1/xn, x2/xn, ..., x(n-1)/xn). When xn=0, the\n.   output point coordinates will be (0,0,0,...)."},
    {"convertPointsToHomogeneous", (PyCFunction)pyopencv_cv_convertPointsToHomogeneous, METH_VARARGS | METH_KEYWORDS, "convertPointsToHomogeneous(src[, dst]) -> dst\n.   @brief Converts points from Euclidean to homogeneous space.\n.   \n.   @param src Input vector of N-dimensional points.\n.   @param dst Output vector of N+1-dimensional points.\n.   \n.   The function converts points from Euclidean to homogeneous space by appending 1's to the tuple of\n.   point coordinates. That is, each point (x1, x2, ..., xn) is converted to (x1, x2, ..., xn, 1)."},
    {"convertScaleAbs", (PyCFunction)pyopencv_cv_convertScaleAbs, METH_VARARGS | METH_KEYWORDS, "convertScaleAbs(src[, dst[, alpha[, beta]]]) -> dst\n.   @brief Scales, calculates absolute values, and converts the result to 8-bit.\n.   \n.   On each element of the input array, the function convertScaleAbs\n.   performs three operations sequentially: scaling, taking an absolute\n.   value, conversion to an unsigned 8-bit type:\n.   \\f[\\texttt{dst} (I)= \\texttt{saturate\\_cast<uchar>} (| \\texttt{src} (I)* \\texttt{alpha} +  \\texttt{beta} |)\\f]\n.   In case of multi-channel arrays, the function processes each channel\n.   independently. When the output is not 8-bit, the operation can be\n.   emulated by calling the Mat::convertTo method (or by using matrix\n.   expressions) and then by calculating an absolute value of the result.\n.   For example:\n.   @code{.cpp}\n.   Mat_<float> A(30,30);\n.   randu(A, Scalar(-100), Scalar(100));\n.   Mat_<float> B = A*5 + 3;\n.   B = abs(B);\n.   // Mat_<float> B = abs(A*5+3) will also do the job,\n.   // but it will allocate a temporary matrix\n.   @endcode\n.   @param src input array.\n.   @param dst output array.\n.   @param alpha optional scale factor.\n.   @param beta optional delta added to the scaled values.\n.   @sa  Mat::convertTo, cv::abs(const Mat&)"},
    {"convexHull", (PyCFunction)pyopencv_cv_convexHull, METH_VARARGS | METH_KEYWORDS, "convexHull(points[, hull[, clockwise[, returnPoints]]]) -> hull\n.   @brief Finds the convex hull of a point set.\n.   \n.   The function cv::convexHull finds the convex hull of a 2D point set using the Sklansky's algorithm @cite Sklansky82\n.   that has *O(N logN)* complexity in the current implementation.\n.   \n.   @param points Input 2D point set, stored in std::vector or Mat.\n.   @param hull Output convex hull. It is either an integer vector of indices or vector of points. In\n.   the first case, the hull elements are 0-based indices of the convex hull points in the original\n.   array (since the set of convex hull points is a subset of the original point set). In the second\n.   case, hull elements are the convex hull points themselves.\n.   @param clockwise Orientation flag. If it is true, the output convex hull is oriented clockwise.\n.   Otherwise, it is oriented counter-clockwise. The assumed coordinate system has its X axis pointing\n.   to the right, and its Y axis pointing upwards.\n.   @param returnPoints Operation flag. In case of a matrix, when the flag is true, the function\n.   returns convex hull points. Otherwise, it returns indices of the convex hull points. When the\n.   output array is std::vector, the flag is ignored, and the output depends on the type of the\n.   vector: std::vector\\<int\\> implies returnPoints=false, std::vector\\<Point\\> implies\n.   returnPoints=true.\n.   \n.   @note `points` and `hull` should be different arrays, inplace processing isn't supported."},
    {"convexityDefects", (PyCFunction)pyopencv_cv_convexityDefects, METH_VARARGS | METH_KEYWORDS, "convexityDefects(contour, convexhull[, convexityDefects]) -> convexityDefects\n.   @brief Finds the convexity defects of a contour.\n.   \n.   The figure below displays convexity defects of a hand contour:\n.   \n.   ![image](pics/defects.png)\n.   \n.   @param contour Input contour.\n.   @param convexhull Convex hull obtained using convexHull that should contain indices of the contour\n.   points that make the hull.\n.   @param convexityDefects The output vector of convexity defects. In C++ and the new Python/Java\n.   interface each convexity defect is represented as 4-element integer vector (a.k.a. #Vec4i):\n.   (start_index, end_index, farthest_pt_index, fixpt_depth), where indices are 0-based indices\n.   in the original contour of the convexity defect beginning, end and the farthest point, and\n.   fixpt_depth is fixed-point approximation (with 8 fractional bits) of the distance between the\n.   farthest contour point and the hull. That is, to get the floating-point value of the depth will be\n.   fixpt_depth/256.0."},
    {"copyMakeBorder", (PyCFunction)pyopencv_cv_copyMakeBorder, METH_VARARGS | METH_KEYWORDS, "copyMakeBorder(src, top, bottom, left, right, borderType[, dst[, value]]) -> dst\n.   @brief Forms a border around an image.\n.   \n.   The function copies the source image into the middle of the destination image. The areas to the\n.   left, to the right, above and below the copied source image will be filled with extrapolated\n.   pixels. This is not what filtering functions based on it do (they extrapolate pixels on-fly), but\n.   what other more complex functions, including your own, may do to simplify image boundary handling.\n.   \n.   The function supports the mode when src is already in the middle of dst . In this case, the\n.   function does not copy src itself but simply constructs the border, for example:\n.   \n.   @code{.cpp}\n.   // let border be the same in all directions\n.   int border=2;\n.   // constructs a larger image to fit both the image and the border\n.   Mat gray_buf(rgb.rows + border*2, rgb.cols + border*2, rgb.depth());\n.   // select the middle part of it w/o copying data\n.   Mat gray(gray_canvas, Rect(border, border, rgb.cols, rgb.rows));\n.   // convert image from RGB to grayscale\n.   cvtColor(rgb, gray, COLOR_RGB2GRAY);\n.   // form a border in-place\n.   copyMakeBorder(gray, gray_buf, border, border,\n.   border, border, BORDER_REPLICATE);\n.   // now do some custom filtering ...\n.   ...\n.   @endcode\n.   @note When the source image is a part (ROI) of a bigger image, the function will try to use the\n.   pixels outside of the ROI to form a border. To disable this feature and always do extrapolation, as\n.   if src was not a ROI, use borderType | #BORDER_ISOLATED.\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same type as src and the size Size(src.cols+left+right,\n.   src.rows+top+bottom) .\n.   @param top\n.   @param bottom\n.   @param left\n.   @param right Parameter specifying how many pixels in each direction from the source image rectangle\n.   to extrapolate. For example, top=1, bottom=1, left=1, right=1 mean that 1 pixel-wide border needs\n.   to be built.\n.   @param borderType Border type. See borderInterpolate for details.\n.   @param value Border value if borderType==BORDER_CONSTANT .\n.   \n.   @sa  borderInterpolate"},
    {"cornerEigenValsAndVecs", (PyCFunction)pyopencv_cv_cornerEigenValsAndVecs, METH_VARARGS | METH_KEYWORDS, "cornerEigenValsAndVecs(src, blockSize, ksize[, dst[, borderType]]) -> dst\n.   @brief Calculates eigenvalues and eigenvectors of image blocks for corner detection.\n.   \n.   For every pixel \\f$p\\f$ , the function cornerEigenValsAndVecs considers a blockSize \\f$\\times\\f$ blockSize\n.   neighborhood \\f$S(p)\\f$ . It calculates the covariation matrix of derivatives over the neighborhood as:\n.   \n.   \\f[M =  \\begin{bmatrix} \\sum _{S(p)}(dI/dx)^2 &  \\sum _{S(p)}dI/dx dI/dy  \\\\ \\sum _{S(p)}dI/dx dI/dy &  \\sum _{S(p)}(dI/dy)^2 \\end{bmatrix}\\f]\n.   \n.   where the derivatives are computed using the Sobel operator.\n.   \n.   After that, it finds eigenvectors and eigenvalues of \\f$M\\f$ and stores them in the destination image as\n.   \\f$(\\lambda_1, \\lambda_2, x_1, y_1, x_2, y_2)\\f$ where\n.   \n.   -   \\f$\\lambda_1, \\lambda_2\\f$ are the non-sorted eigenvalues of \\f$M\\f$\n.   -   \\f$x_1, y_1\\f$ are the eigenvectors corresponding to \\f$\\lambda_1\\f$\n.   -   \\f$x_2, y_2\\f$ are the eigenvectors corresponding to \\f$\\lambda_2\\f$\n.   \n.   The output of the function can be used for robust edge or corner detection.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the results. It has the same size as src and the type CV_32FC(6) .\n.   @param blockSize Neighborhood size (see details below).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param borderType Pixel extrapolation method. See #BorderTypes.\n.   \n.   @sa  cornerMinEigenVal, cornerHarris, preCornerDetect"},
    {"cornerHarris", (PyCFunction)pyopencv_cv_cornerHarris, METH_VARARGS | METH_KEYWORDS, "cornerHarris(src, blockSize, ksize, k[, dst[, borderType]]) -> dst\n.   @brief Harris corner detector.\n.   \n.   The function runs the Harris corner detector on the image. Similarly to cornerMinEigenVal and\n.   cornerEigenValsAndVecs , for each pixel \\f$(x, y)\\f$ it calculates a \\f$2\\times2\\f$ gradient covariance\n.   matrix \\f$M^{(x,y)}\\f$ over a \\f$\\texttt{blockSize} \\times \\texttt{blockSize}\\f$ neighborhood. Then, it\n.   computes the following characteristic:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\mathrm{det} M^{(x,y)} - k  \\cdot \\left ( \\mathrm{tr} M^{(x,y)} \\right )^2\\f]\n.   \n.   Corners in the image can be found as the local maxima of this response map.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the Harris detector responses. It has the type CV_32FC1 and the same\n.   size as src .\n.   @param blockSize Neighborhood size (see the details on #cornerEigenValsAndVecs ).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param k Harris detector free parameter. See the formula below.\n.   @param borderType Pixel extrapolation method. See #BorderTypes."},
    {"cornerMinEigenVal", (PyCFunction)pyopencv_cv_cornerMinEigenVal, METH_VARARGS | METH_KEYWORDS, "cornerMinEigenVal(src, blockSize[, dst[, ksize[, borderType]]]) -> dst\n.   @brief Calculates the minimal eigenvalue of gradient matrices for corner detection.\n.   \n.   The function is similar to cornerEigenValsAndVecs but it calculates and stores only the minimal\n.   eigenvalue of the covariance matrix of derivatives, that is, \\f$\\min(\\lambda_1, \\lambda_2)\\f$ in terms\n.   of the formulae in the cornerEigenValsAndVecs description.\n.   \n.   @param src Input single-channel 8-bit or floating-point image.\n.   @param dst Image to store the minimal eigenvalues. It has the type CV_32FC1 and the same size as\n.   src .\n.   @param blockSize Neighborhood size (see the details on #cornerEigenValsAndVecs ).\n.   @param ksize Aperture parameter for the Sobel operator.\n.   @param borderType Pixel extrapolation method. See #BorderTypes."},
    {"cornerSubPix", (PyCFunction)pyopencv_cv_cornerSubPix, METH_VARARGS | METH_KEYWORDS, "cornerSubPix(image, corners, winSize, zeroZone, criteria) -> corners\n.   @brief Refines the corner locations.\n.   \n.   The function iterates to find the sub-pixel accurate location of corners or radial saddle points, as\n.   shown on the figure below.\n.   \n.   ![image](pics/cornersubpix.png)\n.   \n.   Sub-pixel accurate corner locator is based on the observation that every vector from the center \\f$q\\f$\n.   to a point \\f$p\\f$ located within a neighborhood of \\f$q\\f$ is orthogonal to the image gradient at \\f$p\\f$\n.   subject to image and measurement noise. Consider the expression:\n.   \n.   \\f[\\epsilon _i = {DI_{p_i}}^T  \\cdot (q - p_i)\\f]\n.   \n.   where \\f${DI_{p_i}}\\f$ is an image gradient at one of the points \\f$p_i\\f$ in a neighborhood of \\f$q\\f$ . The\n.   value of \\f$q\\f$ is to be found so that \\f$\\epsilon_i\\f$ is minimized. A system of equations may be set up\n.   with \\f$\\epsilon_i\\f$ set to zero:\n.   \n.   \\f[\\sum _i(DI_{p_i}  \\cdot {DI_{p_i}}^T) -  \\sum _i(DI_{p_i}  \\cdot {DI_{p_i}}^T  \\cdot p_i)\\f]\n.   \n.   where the gradients are summed within a neighborhood (\"search window\") of \\f$q\\f$ . Calling the first\n.   gradient term \\f$G\\f$ and the second gradient term \\f$b\\f$ gives:\n.   \n.   \\f[q = G^{-1}  \\cdot b\\f]\n.   \n.   The algorithm sets the center of the neighborhood window at this new center \\f$q\\f$ and then iterates\n.   until the center stays within a set threshold.\n.   \n.   @param image Input image.\n.   @param corners Initial coordinates of the input corners and refined coordinates provided for\n.   output.\n.   @param winSize Half of the side length of the search window. For example, if winSize=Size(5,5) ,\n.   then a \\f$5*2+1 \\times 5*2+1 = 11 \\times 11\\f$ search window is used.\n.   @param zeroZone Half of the size of the dead region in the middle of the search zone over which\n.   the summation in the formula below is not done. It is used sometimes to avoid possible\n.   singularities of the autocorrelation matrix. The value of (-1,-1) indicates that there is no such\n.   a size.\n.   @param criteria Criteria for termination of the iterative process of corner refinement. That is,\n.   the process of corner position refinement stops either after criteria.maxCount iterations or when\n.   the corner position moves by less than criteria.epsilon on some iteration."},
    {"correctMatches", (PyCFunction)pyopencv_cv_correctMatches, METH_VARARGS | METH_KEYWORDS, "correctMatches(F, points1, points2[, newPoints1[, newPoints2]]) -> newPoints1, newPoints2\n.   @brief Refines coordinates of corresponding points.\n.   \n.   @param F 3x3 fundamental matrix.\n.   @param points1 1xN array containing the first set of points.\n.   @param points2 1xN array containing the second set of points.\n.   @param newPoints1 The optimized points1.\n.   @param newPoints2 The optimized points2.\n.   \n.   The function implements the Optimal Triangulation Method (see Multiple View Geometry for details).\n.   For each given point correspondence points1[i] \\<-\\> points2[i], and a fundamental matrix F, it\n.   computes the corrected correspondences newPoints1[i] \\<-\\> newPoints2[i] that minimize the geometric\n.   error \\f$d(points1[i], newPoints1[i])^2 + d(points2[i],newPoints2[i])^2\\f$ (where \\f$d(a,b)\\f$ is the\n.   geometric distance between points \\f$a\\f$ and \\f$b\\f$ ) subject to the epipolar constraint\n.   \\f$newPoints2^T * F * newPoints1 = 0\\f$ ."},
    {"countNonZero", (PyCFunction)pyopencv_cv_countNonZero, METH_VARARGS | METH_KEYWORDS, "countNonZero(src) -> retval\n.   @brief Counts non-zero array elements.\n.   \n.   The function returns the number of non-zero elements in src :\n.   \\f[\\sum _{I: \\; \\texttt{src} (I) \\ne0 } 1\\f]\n.   @param src single-channel array.\n.   @sa  mean, meanStdDev, norm, minMaxLoc, calcCovarMatrix"},
    {"createAffineTransformer", (PyCFunction)pyopencv_cv_createAffineTransformer, METH_VARARGS | METH_KEYWORDS, "createAffineTransformer(fullAffine) -> retval\n.   Complete constructor"},
    {"createAlignMTB", (PyCFunction)pyopencv_cv_createAlignMTB, METH_VARARGS | METH_KEYWORDS, "createAlignMTB([, max_bits[, exclude_range[, cut]]]) -> retval\n.   @brief Creates AlignMTB object\n.   \n.   @param max_bits logarithm to the base 2 of maximal shift in each dimension. Values of 5 and 6 are\n.   usually good enough (31 and 63 pixels shift respectively).\n.   @param exclude_range range for exclusion bitmap that is constructed to suppress noise around the\n.   median value.\n.   @param cut if true cuts images, otherwise fills the new regions with zeros."},
    {"createBackgroundSubtractorKNN", (PyCFunction)pyopencv_cv_createBackgroundSubtractorKNN, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorKNN([, history[, dist2Threshold[, detectShadows]]]) -> retval\n.   @brief Creates KNN Background Subtractor\n.   \n.   @param history Length of the history.\n.   @param dist2Threshold Threshold on the squared distance between the pixel and the sample to decide\n.   whether a pixel is close to that sample. This parameter does not affect the background update.\n.   @param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the\n.   speed a bit, so if you do not need this feature, set the parameter to false."},
    {"createBackgroundSubtractorMOG2", (PyCFunction)pyopencv_cv_createBackgroundSubtractorMOG2, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorMOG2([, history[, varThreshold[, detectShadows]]]) -> retval\n.   @brief Creates MOG2 Background Subtractor\n.   \n.   @param history Length of the history.\n.   @param varThreshold Threshold on the squared Mahalanobis distance between the pixel and the model\n.   to decide whether a pixel is well described by the background model. This parameter does not\n.   affect the background update.\n.   @param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the\n.   speed a bit, so if you do not need this feature, set the parameter to false."},
    {"createCLAHE", (PyCFunction)pyopencv_cv_createCLAHE, METH_VARARGS | METH_KEYWORDS, "createCLAHE([, clipLimit[, tileGridSize]]) -> retval\n.   @brief Creates implementation for cv::CLAHE .\n.   \n.   @param clipLimit Threshold for contrast limiting.\n.   @param tileGridSize Size of grid for histogram equalization. Input image will be divided into\n.   equally sized rectangular tiles. tileGridSize defines the number of tiles in row and column."},
    {"createCalibrateDebevec", (PyCFunction)pyopencv_cv_createCalibrateDebevec, METH_VARARGS | METH_KEYWORDS, "createCalibrateDebevec([, samples[, lambda[, random]]]) -> retval\n.   @brief Creates CalibrateDebevec object\n.   \n.   @param samples number of pixel locations to use\n.   @param lambda smoothness term weight. Greater values produce smoother results, but can alter the\n.   response.\n.   @param random if true sample pixel locations are chosen at random, otherwise they form a\n.   rectangular grid."},
    {"createCalibrateRobertson", (PyCFunction)pyopencv_cv_createCalibrateRobertson, METH_VARARGS | METH_KEYWORDS, "createCalibrateRobertson([, max_iter[, threshold]]) -> retval\n.   @brief Creates CalibrateRobertson object\n.   \n.   @param max_iter maximal number of Gauss-Seidel solver iterations.\n.   @param threshold target difference between results of two successive steps of the minimization."},
    {"createChiHistogramCostExtractor", (PyCFunction)pyopencv_cv_createChiHistogramCostExtractor, METH_VARARGS | METH_KEYWORDS, "createChiHistogramCostExtractor([, nDummies[, defaultCost]]) -> retval\n."},
    {"createEMDHistogramCostExtractor", (PyCFunction)pyopencv_cv_createEMDHistogramCostExtractor, METH_VARARGS | METH_KEYWORDS, "createEMDHistogramCostExtractor([, flag[, nDummies[, defaultCost]]]) -> retval\n."},
    {"createEMDL1HistogramCostExtractor", (PyCFunction)pyopencv_cv_createEMDL1HistogramCostExtractor, METH_VARARGS | METH_KEYWORDS, "createEMDL1HistogramCostExtractor([, nDummies[, defaultCost]]) -> retval\n."},
    {"createHanningWindow", (PyCFunction)pyopencv_cv_createHanningWindow, METH_VARARGS | METH_KEYWORDS, "createHanningWindow(winSize, type[, dst]) -> dst\n.   @brief This function computes a Hanning window coefficients in two dimensions.\n.   \n.   See (http://en.wikipedia.org/wiki/Hann_function) and (http://en.wikipedia.org/wiki/Window_function)\n.   for more information.\n.   \n.   An example is shown below:\n.   @code\n.   // create hanning window of size 100x100 and type CV_32F\n.   Mat hann;\n.   createHanningWindow(hann, Size(100, 100), CV_32F);\n.   @endcode\n.   @param dst Destination array to place Hann coefficients in\n.   @param winSize The window size specifications (both width and height must be > 1)\n.   @param type Created array type"},
    {"createHausdorffDistanceExtractor", (PyCFunction)pyopencv_cv_createHausdorffDistanceExtractor, METH_VARARGS | METH_KEYWORDS, "createHausdorffDistanceExtractor([, distanceFlag[, rankProp]]) -> retval\n."},
    {"createLineSegmentDetector", (PyCFunction)pyopencv_cv_createLineSegmentDetector, METH_VARARGS | METH_KEYWORDS, "createLineSegmentDetector([, _refine[, _scale[, _sigma_scale[, _quant[, _ang_th[, _log_eps[, _density_th[, _n_bins]]]]]]]]) -> retval\n.   @brief Creates a smart pointer to a LineSegmentDetector object and initializes it.\n.   \n.   The LineSegmentDetector algorithm is defined using the standard values. Only advanced users may want\n.   to edit those, as to tailor it for their own application.\n.   \n.   @param _refine The way found lines will be refined, see #LineSegmentDetectorModes\n.   @param _scale The scale of the image that will be used to find the lines. Range (0..1].\n.   @param _sigma_scale Sigma for Gaussian filter. It is computed as sigma = _sigma_scale/_scale.\n.   @param _quant Bound to the quantization error on the gradient norm.\n.   @param _ang_th Gradient angle tolerance in degrees.\n.   @param _log_eps Detection threshold: -log10(NFA) \\> log_eps. Used only when advance refinement\n.   is chosen.\n.   @param _density_th Minimal density of aligned region points in the enclosing rectangle.\n.   @param _n_bins Number of bins in pseudo-ordering of gradient modulus."},
    {"createMergeDebevec", (PyCFunction)pyopencv_cv_createMergeDebevec, METH_VARARGS | METH_KEYWORDS, "createMergeDebevec() -> retval\n.   @brief Creates MergeDebevec object"},
    {"createMergeMertens", (PyCFunction)pyopencv_cv_createMergeMertens, METH_VARARGS | METH_KEYWORDS, "createMergeMertens([, contrast_weight[, saturation_weight[, exposure_weight]]]) -> retval\n.   @brief Creates MergeMertens object\n.   \n.   @param contrast_weight contrast measure weight. See MergeMertens.\n.   @param saturation_weight saturation measure weight\n.   @param exposure_weight well-exposedness measure weight"},
    {"createMergeRobertson", (PyCFunction)pyopencv_cv_createMergeRobertson, METH_VARARGS | METH_KEYWORDS, "createMergeRobertson() -> retval\n.   @brief Creates MergeRobertson object"},
    {"createNormHistogramCostExtractor", (PyCFunction)pyopencv_cv_createNormHistogramCostExtractor, METH_VARARGS | METH_KEYWORDS, "createNormHistogramCostExtractor([, flag[, nDummies[, defaultCost]]]) -> retval\n."},
    {"createOptFlow_DualTVL1", (PyCFunction)pyopencv_cv_createOptFlow_DualTVL1, METH_VARARGS | METH_KEYWORDS, "createOptFlow_DualTVL1() -> retval\n.   @brief Creates instance of cv::DenseOpticalFlow"},
    {"createShapeContextDistanceExtractor", (PyCFunction)pyopencv_cv_createShapeContextDistanceExtractor, METH_VARARGS | METH_KEYWORDS, "createShapeContextDistanceExtractor([, nAngularBins[, nRadialBins[, innerRadius[, outerRadius[, iterations[, comparer[, transformer]]]]]]]) -> retval\n."},
    {"createStitcher", (PyCFunction)pyopencv_cv_createStitcher, METH_VARARGS | METH_KEYWORDS, "createStitcher([, try_use_gpu]) -> retval\n."},
    {"createStitcherScans", (PyCFunction)pyopencv_cv_createStitcherScans, METH_VARARGS | METH_KEYWORDS, "createStitcherScans([, try_use_gpu]) -> retval\n."},
    {"createThinPlateSplineShapeTransformer", (PyCFunction)pyopencv_cv_createThinPlateSplineShapeTransformer, METH_VARARGS | METH_KEYWORDS, "createThinPlateSplineShapeTransformer([, regularizationParameter]) -> retval\n.   Complete constructor"},
    {"createTonemap", (PyCFunction)pyopencv_cv_createTonemap, METH_VARARGS | METH_KEYWORDS, "createTonemap([, gamma]) -> retval\n.   @brief Creates simple linear mapper with gamma correction\n.   \n.   @param gamma positive value for gamma correction. Gamma value of 1.0 implies no correction, gamma\n.   equal to 2.2f is suitable for most displays.\n.   Generally gamma \\> 1 brightens the image and gamma \\< 1 darkens it."},
    {"createTonemapDrago", (PyCFunction)pyopencv_cv_createTonemapDrago, METH_VARARGS | METH_KEYWORDS, "createTonemapDrago([, gamma[, saturation[, bias]]]) -> retval\n.   @brief Creates TonemapDrago object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param saturation positive saturation enhancement value. 1.0 preserves saturation, values greater\n.   than 1 increase saturation and values less than 1 decrease it.\n.   @param bias value for bias function in [0, 1] range. Values from 0.7 to 0.9 usually give best\n.   results, default value is 0.85."},
    {"createTonemapDurand", (PyCFunction)pyopencv_cv_createTonemapDurand, METH_VARARGS | METH_KEYWORDS, "createTonemapDurand([, gamma[, contrast[, saturation[, sigma_space[, sigma_color]]]]]) -> retval\n.   @brief Creates TonemapDurand object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param contrast resulting contrast on logarithmic scale, i. e. log(max / min), where max and min\n.   are maximum and minimum luminance values of the resulting image.\n.   @param saturation saturation enhancement value. See createTonemapDrago\n.   @param sigma_space bilateral filter sigma in color space\n.   @param sigma_color bilateral filter sigma in coordinate space"},
    {"createTonemapMantiuk", (PyCFunction)pyopencv_cv_createTonemapMantiuk, METH_VARARGS | METH_KEYWORDS, "createTonemapMantiuk([, gamma[, scale[, saturation]]]) -> retval\n.   @brief Creates TonemapMantiuk object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param scale contrast scale factor. HVS response is multiplied by this parameter, thus compressing\n.   dynamic range. Values from 0.6 to 0.9 produce best results.\n.   @param saturation saturation enhancement value. See createTonemapDrago"},
    {"createTonemapReinhard", (PyCFunction)pyopencv_cv_createTonemapReinhard, METH_VARARGS | METH_KEYWORDS, "createTonemapReinhard([, gamma[, intensity[, light_adapt[, color_adapt]]]]) -> retval\n.   @brief Creates TonemapReinhard object\n.   \n.   @param gamma gamma value for gamma correction. See createTonemap\n.   @param intensity result intensity in [-8, 8] range. Greater intensity produces brighter results.\n.   @param light_adapt light adaptation in [0, 1] range. If 1 adaptation is based only on pixel\n.   value, if 0 it's global, otherwise it's a weighted mean of this two cases.\n.   @param color_adapt chromatic adaptation in [0, 1] range. If 1 channels are treated independently,\n.   if 0 adaptation level is the same for each channel."},
    {"cubeRoot", (PyCFunction)pyopencv_cv_cubeRoot, METH_VARARGS | METH_KEYWORDS, "cubeRoot(val) -> retval\n.   @brief Computes the cube root of an argument.\n.   \n.   The function cubeRoot computes \\f$\\sqrt[3]{\\texttt{val}}\\f$. Negative arguments are handled correctly.\n.   NaN and Inf are not handled. The accuracy approaches the maximum possible accuracy for\n.   single-precision data.\n.   @param val A function argument."},
    {"cvtColor", (PyCFunction)pyopencv_cv_cvtColor, METH_VARARGS | METH_KEYWORDS, "cvtColor(src, code[, dst[, dstCn]]) -> dst\n.   @brief Converts an image from one color space to another.\n.   \n.   The function converts an input image from one color space to another. In case of a transformation\n.   to-from RGB color space, the order of the channels should be specified explicitly (RGB or BGR). Note\n.   that the default color format in OpenCV is often referred to as RGB but it is actually BGR (the\n.   bytes are reversed). So the first byte in a standard (24-bit) color image will be an 8-bit Blue\n.   component, the second byte will be Green, and the third byte will be Red. The fourth, fifth, and\n.   sixth bytes would then be the second pixel (Blue, then Green, then Red), and so on.\n.   \n.   The conventional ranges for R, G, and B channel values are:\n.   -   0 to 255 for CV_8U images\n.   -   0 to 65535 for CV_16U images\n.   -   0 to 1 for CV_32F images\n.   \n.   In case of linear transformations, the range does not matter. But in case of a non-linear\n.   transformation, an input RGB image should be normalized to the proper value range to get the correct\n.   results, for example, for RGB \\f$\\rightarrow\\f$ L\\*u\\*v\\* transformation. For example, if you have a\n.   32-bit floating-point image directly converted from an 8-bit image without any scaling, then it will\n.   have the 0..255 value range instead of 0..1 assumed by the function. So, before calling #cvtColor ,\n.   you need first to scale the image down:\n.   @code\n.   img *= 1./255;\n.   cvtColor(img, img, COLOR_BGR2Luv);\n.   @endcode\n.   If you use #cvtColor with 8-bit images, the conversion will have some information lost. For many\n.   applications, this will not be noticeable but it is recommended to use 32-bit images in applications\n.   that need the full range of colors or that convert an image before an operation and then convert\n.   back.\n.   \n.   If conversion adds the alpha channel, its value will set to the maximum of corresponding channel\n.   range: 255 for CV_8U, 65535 for CV_16U, 1 for CV_32F.\n.   \n.   @param src input image: 8-bit unsigned, 16-bit unsigned ( CV_16UC... ), or single-precision\n.   floating-point.\n.   @param dst output image of the same size and depth as src.\n.   @param code color space conversion code (see #ColorConversionCodes).\n.   @param dstCn number of channels in the destination image; if the parameter is 0, the number of the\n.   channels is derived automatically from src and code.\n.   \n.   @see @ref imgproc_color_conversions"},
    {"cvtColorTwoPlane", (PyCFunction)pyopencv_cv_cvtColorTwoPlane, METH_VARARGS | METH_KEYWORDS, "cvtColorTwoPlane(src1, src2, code[, dst]) -> dst\n."},
    {"dct", (PyCFunction)pyopencv_cv_dct, METH_VARARGS | METH_KEYWORDS, "dct(src[, dst[, flags]]) -> dst\n.   @brief Performs a forward or inverse discrete Cosine transform of 1D or 2D array.\n.   \n.   The function cv::dct performs a forward or inverse discrete Cosine transform (DCT) of a 1D or 2D\n.   floating-point array:\n.   -   Forward Cosine transform of a 1D vector of N elements:\n.   \\f[Y = C^{(N)}  \\cdot X\\f]\n.   where\n.   \\f[C^{(N)}_{jk}= \\sqrt{\\alpha_j/N} \\cos \\left ( \\frac{\\pi(2k+1)j}{2N} \\right )\\f]\n.   and\n.   \\f$\\alpha_0=1\\f$, \\f$\\alpha_j=2\\f$ for *j \\> 0*.\n.   -   Inverse Cosine transform of a 1D vector of N elements:\n.   \\f[X =  \\left (C^{(N)} \\right )^{-1}  \\cdot Y =  \\left (C^{(N)} \\right )^T  \\cdot Y\\f]\n.   (since \\f$C^{(N)}\\f$ is an orthogonal matrix, \\f$C^{(N)} \\cdot \\left(C^{(N)}\\right)^T = I\\f$ )\n.   -   Forward 2D Cosine transform of M x N matrix:\n.   \\f[Y = C^{(N)}  \\cdot X  \\cdot \\left (C^{(N)} \\right )^T\\f]\n.   -   Inverse 2D Cosine transform of M x N matrix:\n.   \\f[X =  \\left (C^{(N)} \\right )^T  \\cdot X  \\cdot C^{(N)}\\f]\n.   \n.   The function chooses the mode of operation by looking at the flags and size of the input array:\n.   -   If (flags & #DCT_INVERSE) == 0 , the function does a forward 1D or 2D transform. Otherwise, it\n.   is an inverse 1D or 2D transform.\n.   -   If (flags & #DCT_ROWS) != 0 , the function performs a 1D transform of each row.\n.   -   If the array is a single column or a single row, the function performs a 1D transform.\n.   -   If none of the above is true, the function performs a 2D transform.\n.   \n.   @note Currently dct supports even-size arrays (2, 4, 6 ...). For data analysis and approximation, you\n.   can pad the array when necessary.\n.   Also, the function performance depends very much, and not monotonically, on the array size (see\n.   getOptimalDFTSize ). In the current implementation DCT of a vector of size N is calculated via DFT\n.   of a vector of size N/2 . Thus, the optimal DCT size N1 \\>= N can be calculated as:\n.   @code\n.   size_t getOptimalDCTSize(size_t N) { return 2*getOptimalDFTSize((N+1)/2); }\n.   N1 = getOptimalDCTSize(N);\n.   @endcode\n.   @param src input floating-point array.\n.   @param dst output array of the same size and type as src .\n.   @param flags transformation flags as a combination of cv::DftFlags (DCT_*)\n.   @sa dft , getOptimalDFTSize , idct"},
    {"decolor", (PyCFunction)pyopencv_cv_decolor, METH_VARARGS | METH_KEYWORDS, "decolor(src[, grayscale[, color_boost]]) -> grayscale, color_boost\n.   @brief Transforms a color image to a grayscale image. It is a basic tool in digital printing, stylized\n.   black-and-white photograph rendering, and in many single channel image processing applications\n.   @cite CL12 .\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param grayscale Output 8-bit 1-channel image.\n.   @param color_boost Output 8-bit 3-channel image.\n.   \n.   This function is to be applied on color images."},
    {"decomposeEssentialMat", (PyCFunction)pyopencv_cv_decomposeEssentialMat, METH_VARARGS | METH_KEYWORDS, "decomposeEssentialMat(E[, R1[, R2[, t]]]) -> R1, R2, t\n.   @brief Decompose an essential matrix to possible rotations and translation.\n.   \n.   @param E The input essential matrix.\n.   @param R1 One possible rotation matrix.\n.   @param R2 Another possible rotation matrix.\n.   @param t One possible translation.\n.   \n.   This function decompose an essential matrix E using svd decomposition @cite HartleyZ00 . Generally 4\n.   possible poses exists for a given E. They are \\f$[R_1, t]\\f$, \\f$[R_1, -t]\\f$, \\f$[R_2, t]\\f$, \\f$[R_2, -t]\\f$. By\n.   decomposing E, you can only get the direction of the translation, so the function returns unit t."},
    {"decomposeHomographyMat", (PyCFunction)pyopencv_cv_decomposeHomographyMat, METH_VARARGS | METH_KEYWORDS, "decomposeHomographyMat(H, K[, rotations[, translations[, normals]]]) -> retval, rotations, translations, normals\n.   @brief Decompose a homography matrix to rotation(s), translation(s) and plane normal(s).\n.   \n.   @param H The input homography matrix between two images.\n.   @param K The input intrinsic camera calibration matrix.\n.   @param rotations Array of rotation matrices.\n.   @param translations Array of translation matrices.\n.   @param normals Array of plane normal matrices.\n.   \n.   This function extracts relative camera motion between two views observing a planar object from the\n.   homography H induced by the plane. The intrinsic camera matrix K must also be provided. The function\n.   may return up to four mathematical solution sets. At least two of the solutions may further be\n.   invalidated if point correspondences are available by applying positive depth constraint (all points\n.   must be in front of the camera). The decomposition method is described in detail in @cite Malis ."},
    {"decomposeProjectionMatrix", (PyCFunction)pyopencv_cv_decomposeProjectionMatrix, METH_VARARGS | METH_KEYWORDS, "decomposeProjectionMatrix(projMatrix[, cameraMatrix[, rotMatrix[, transVect[, rotMatrixX[, rotMatrixY[, rotMatrixZ[, eulerAngles]]]]]]]) -> cameraMatrix, rotMatrix, transVect, rotMatrixX, rotMatrixY, rotMatrixZ, eulerAngles\n.   @brief Decomposes a projection matrix into a rotation matrix and a camera matrix.\n.   \n.   @param projMatrix 3x4 input projection matrix P.\n.   @param cameraMatrix Output 3x3 camera matrix K.\n.   @param rotMatrix Output 3x3 external rotation matrix R.\n.   @param transVect Output 4x1 translation vector T.\n.   @param rotMatrixX Optional 3x3 rotation matrix around x-axis.\n.   @param rotMatrixY Optional 3x3 rotation matrix around y-axis.\n.   @param rotMatrixZ Optional 3x3 rotation matrix around z-axis.\n.   @param eulerAngles Optional three-element vector containing three Euler angles of rotation in\n.   degrees.\n.   \n.   The function computes a decomposition of a projection matrix into a calibration and a rotation\n.   matrix and the position of a camera.\n.   \n.   It optionally returns three rotation matrices, one for each axis, and three Euler angles that could\n.   be used in OpenGL. Note, there is always more than one sequence of rotations about the three\n.   principal axes that results in the same orientation of an object, e.g. see @cite Slabaugh . Returned\n.   tree rotation matrices and corresponding three Euler angles are only one of the possible solutions.\n.   \n.   The function is based on RQDecomp3x3 ."},
    {"demosaicing", (PyCFunction)pyopencv_cv_demosaicing, METH_VARARGS | METH_KEYWORDS, "demosaicing(_src, code[, _dst[, dcn]]) -> _dst\n."},
    {"denoise_TVL1", (PyCFunction)pyopencv_cv_denoise_TVL1, METH_VARARGS | METH_KEYWORDS, "denoise_TVL1(observations, result[, lambda[, niters]]) -> None\n.   @brief Primal-dual algorithm is an algorithm for solving special types of variational problems (that is,\n.   finding a function to minimize some functional). As the image denoising, in particular, may be seen\n.   as the variational problem, primal-dual algorithm then can be used to perform denoising and this is\n.   exactly what is implemented.\n.   \n.   It should be noted, that this implementation was taken from the July 2013 blog entry\n.   @cite MA13 , which also contained (slightly more general) ready-to-use source code on Python.\n.   Subsequently, that code was rewritten on C++ with the usage of openCV by Vadim Pisarevsky at the end\n.   of July 2013 and finally it was slightly adapted by later authors.\n.   \n.   Although the thorough discussion and justification of the algorithm involved may be found in\n.   @cite ChambolleEtAl, it might make sense to skim over it here, following @cite MA13 . To begin\n.   with, we consider the 1-byte gray-level images as the functions from the rectangular domain of\n.   pixels (it may be seen as set\n.   \\f$\\left\\{(x,y)\\in\\mathbb{N}\\times\\mathbb{N}\\mid 1\\leq x\\leq n,\\;1\\leq y\\leq m\\right\\}\\f$ for some\n.   \\f$m,\\;n\\in\\mathbb{N}\\f$) into \\f$\\{0,1,\\dots,255\\}\\f$. We shall denote the noised images as \\f$f_i\\f$ and with\n.   this view, given some image \\f$x\\f$ of the same size, we may measure how bad it is by the formula\n.   \n.   \\f[\\left\\|\\left\\|\\nabla x\\right\\|\\right\\| + \\lambda\\sum_i\\left\\|\\left\\|x-f_i\\right\\|\\right\\|\\f]\n.   \n.   \\f$\\|\\|\\cdot\\|\\|\\f$ here denotes \\f$L_2\\f$-norm and as you see, the first addend states that we want our\n.   image to be smooth (ideally, having zero gradient, thus being constant) and the second states that\n.   we want our result to be close to the observations we've got. If we treat \\f$x\\f$ as a function, this is\n.   exactly the functional what we seek to minimize and here the Primal-Dual algorithm comes into play.\n.   \n.   @param observations This array should contain one or more noised versions of the image that is to\n.   be restored.\n.   @param result Here the denoised image will be stored. There is no need to do pre-allocation of\n.   storage space, as it will be automatically allocated, if necessary.\n.   @param lambda Corresponds to \\f$\\lambda\\f$ in the formulas above. As it is enlarged, the smooth\n.   (blurred) images are treated more favorably than detailed (but maybe more noised) ones. Roughly\n.   speaking, as it becomes smaller, the result will be more blur but more sever outliers will be\n.   removed.\n.   @param niters Number of iterations that the algorithm will run. Of course, as more iterations as\n.   better, but it is hard to quantitatively refine this statement, so just use the default and\n.   increase it if the results are poor."},
    {"destroyAllWindows", (PyCFunction)pyopencv_cv_destroyAllWindows, METH_VARARGS | METH_KEYWORDS, "destroyAllWindows() -> None\n.   @brief Destroys all of the HighGUI windows.\n.   \n.   The function destroyAllWindows destroys all of the opened HighGUI windows."},
    {"destroyWindow", (PyCFunction)pyopencv_cv_destroyWindow, METH_VARARGS | METH_KEYWORDS, "destroyWindow(winname) -> None\n.   @brief Destroys the specified window.\n.   \n.   The function destroyWindow destroys the window with the given name.\n.   \n.   @param winname Name of the window to be destroyed."},
    {"detailEnhance", (PyCFunction)pyopencv_cv_detailEnhance, METH_VARARGS | METH_KEYWORDS, "detailEnhance(src[, dst[, sigma_s[, sigma_r]]]) -> dst\n.   @brief This filter enhances the details of a particular image.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param sigma_s Range between 0 to 200.\n.   @param sigma_r Range between 0 to 1."},
    {"determinant", (PyCFunction)pyopencv_cv_determinant, METH_VARARGS | METH_KEYWORDS, "determinant(mtx) -> retval\n.   @brief Returns the determinant of a square floating-point matrix.\n.   \n.   The function cv::determinant calculates and returns the determinant of the\n.   specified matrix. For small matrices ( mtx.cols=mtx.rows\\<=3 ), the\n.   direct method is used. For larger matrices, the function uses LU\n.   factorization with partial pivoting.\n.   \n.   For symmetric positively-determined matrices, it is also possible to use\n.   eigen decomposition to calculate the determinant.\n.   @param mtx input matrix that must have CV_32FC1 or CV_64FC1 type and\n.   square size.\n.   @sa trace, invert, solve, eigen, @ref MatrixExpressions"},
    {"dft", (PyCFunction)pyopencv_cv_dft, METH_VARARGS | METH_KEYWORDS, "dft(src[, dst[, flags[, nonzeroRows]]]) -> dst\n.   @brief Performs a forward or inverse Discrete Fourier transform of a 1D or 2D floating-point array.\n.   \n.   The function cv::dft performs one of the following:\n.   -   Forward the Fourier transform of a 1D vector of N elements:\n.   \\f[Y = F^{(N)}  \\cdot X,\\f]\n.   where \\f$F^{(N)}_{jk}=\\exp(-2\\pi i j k/N)\\f$ and \\f$i=\\sqrt{-1}\\f$\n.   -   Inverse the Fourier transform of a 1D vector of N elements:\n.   \\f[\\begin{array}{l} X'=  \\left (F^{(N)} \\right )^{-1}  \\cdot Y =  \\left (F^{(N)} \\right )^*  \\cdot y  \\\\ X = (1/N)  \\cdot X, \\end{array}\\f]\n.   where \\f$F^*=\\left(\\textrm{Re}(F^{(N)})-\\textrm{Im}(F^{(N)})\\right)^T\\f$\n.   -   Forward the 2D Fourier transform of a M x N matrix:\n.   \\f[Y = F^{(M)}  \\cdot X  \\cdot F^{(N)}\\f]\n.   -   Inverse the 2D Fourier transform of a M x N matrix:\n.   \\f[\\begin{array}{l} X'=  \\left (F^{(M)} \\right )^*  \\cdot Y  \\cdot \\left (F^{(N)} \\right )^* \\\\ X =  \\frac{1}{M \\cdot N} \\cdot X' \\end{array}\\f]\n.   \n.   In case of real (single-channel) data, the output spectrum of the forward Fourier transform or input\n.   spectrum of the inverse Fourier transform can be represented in a packed format called *CCS*\n.   (complex-conjugate-symmetrical). It was borrowed from IPL (Intel\\* Image Processing Library). Here\n.   is how 2D *CCS* spectrum looks:\n.   \\f[\\begin{bmatrix} Re Y_{0,0} & Re Y_{0,1} & Im Y_{0,1} & Re Y_{0,2} & Im Y_{0,2} &  \\cdots & Re Y_{0,N/2-1} & Im Y_{0,N/2-1} & Re Y_{0,N/2}  \\\\ Re Y_{1,0} & Re Y_{1,1} & Im Y_{1,1} & Re Y_{1,2} & Im Y_{1,2} &  \\cdots & Re Y_{1,N/2-1} & Im Y_{1,N/2-1} & Re Y_{1,N/2}  \\\\ Im Y_{1,0} & Re Y_{2,1} & Im Y_{2,1} & Re Y_{2,2} & Im Y_{2,2} &  \\cdots & Re Y_{2,N/2-1} & Im Y_{2,N/2-1} & Im Y_{1,N/2}  \\\\ \\hdotsfor{9} \\\\ Re Y_{M/2-1,0} &  Re Y_{M-3,1}  & Im Y_{M-3,1} &  \\hdotsfor{3} & Re Y_{M-3,N/2-1} & Im Y_{M-3,N/2-1}& Re Y_{M/2-1,N/2}  \\\\ Im Y_{M/2-1,0} &  Re Y_{M-2,1}  & Im Y_{M-2,1} &  \\hdotsfor{3} & Re Y_{M-2,N/2-1} & Im Y_{M-2,N/2-1}& Im Y_{M/2-1,N/2}  \\\\ Re Y_{M/2,0}  &  Re Y_{M-1,1} &  Im Y_{M-1,1} &  \\hdotsfor{3} & Re Y_{M-1,N/2-1} & Im Y_{M-1,N/2-1}& Re Y_{M/2,N/2} \\end{bmatrix}\\f]\n.   \n.   In case of 1D transform of a real vector, the output looks like the first row of the matrix above.\n.   \n.   So, the function chooses an operation mode depending on the flags and size of the input array:\n.   -   If #DFT_ROWS is set or the input array has a single row or single column, the function\n.   performs a 1D forward or inverse transform of each row of a matrix when #DFT_ROWS is set.\n.   Otherwise, it performs a 2D transform.\n.   -   If the input array is real and #DFT_INVERSE is not set, the function performs a forward 1D or\n.   2D transform:\n.   -   When #DFT_COMPLEX_OUTPUT is set, the output is a complex matrix of the same size as\n.   input.\n.   -   When #DFT_COMPLEX_OUTPUT is not set, the output is a real matrix of the same size as\n.   input. In case of 2D transform, it uses the packed format as shown above. In case of a\n.   single 1D transform, it looks like the first row of the matrix above. In case of\n.   multiple 1D transforms (when using the #DFT_ROWS flag), each row of the output matrix\n.   looks like the first row of the matrix above.\n.   -   If the input array is complex and either #DFT_INVERSE or #DFT_REAL_OUTPUT are not set, the\n.   output is a complex array of the same size as input. The function performs a forward or\n.   inverse 1D or 2D transform of the whole input array or each row of the input array\n.   independently, depending on the flags DFT_INVERSE and DFT_ROWS.\n.   -   When #DFT_INVERSE is set and the input array is real, or it is complex but #DFT_REAL_OUTPUT\n.   is set, the output is a real array of the same size as input. The function performs a 1D or 2D\n.   inverse transformation of the whole input array or each individual row, depending on the flags\n.   #DFT_INVERSE and #DFT_ROWS.\n.   \n.   If #DFT_SCALE is set, the scaling is done after the transformation.\n.   \n.   Unlike dct , the function supports arrays of arbitrary size. But only those arrays are processed\n.   efficiently, whose sizes can be factorized in a product of small prime numbers (2, 3, and 5 in the\n.   current implementation). Such an efficient DFT size can be calculated using the getOptimalDFTSize\n.   method.\n.   \n.   The sample below illustrates how to calculate a DFT-based convolution of two 2D real arrays:\n.   @code\n.   void convolveDFT(InputArray A, InputArray B, OutputArray C)\n.   {\n.   // reallocate the output array if needed\n.   C.create(abs(A.rows - B.rows)+1, abs(A.cols - B.cols)+1, A.type());\n.   Size dftSize;\n.   // calculate the size of DFT transform\n.   dftSize.width = getOptimalDFTSize(A.cols + B.cols - 1);\n.   dftSize.height = getOptimalDFTSize(A.rows + B.rows - 1);\n.   \n.   // allocate temporary buffers and initialize them with 0's\n.   Mat tempA(dftSize, A.type(), Scalar::all(0));\n.   Mat tempB(dftSize, B.type(), Scalar::all(0));\n.   \n.   // copy A and B to the top-left corners of tempA and tempB, respectively\n.   Mat roiA(tempA, Rect(0,0,A.cols,A.rows));\n.   A.copyTo(roiA);\n.   Mat roiB(tempB, Rect(0,0,B.cols,B.rows));\n.   B.copyTo(roiB);\n.   \n.   // now transform the padded A & B in-place;\n.   // use \"nonzeroRows\" hint for faster processing\n.   dft(tempA, tempA, 0, A.rows);\n.   dft(tempB, tempB, 0, B.rows);\n.   \n.   // multiply the spectrums;\n.   // the function handles packed spectrum representations well\n.   mulSpectrums(tempA, tempB, tempA);\n.   \n.   // transform the product back from the frequency domain.\n.   // Even though all the result rows will be non-zero,\n.   // you need only the first C.rows of them, and thus you\n.   // pass nonzeroRows == C.rows\n.   dft(tempA, tempA, DFT_INVERSE + DFT_SCALE, C.rows);\n.   \n.   // now copy the result back to C.\n.   tempA(Rect(0, 0, C.cols, C.rows)).copyTo(C);\n.   \n.   // all the temporary buffers will be deallocated automatically\n.   }\n.   @endcode\n.   To optimize this sample, consider the following approaches:\n.   -   Since nonzeroRows != 0 is passed to the forward transform calls and since A and B are copied to\n.   the top-left corners of tempA and tempB, respectively, it is not necessary to clear the whole\n.   tempA and tempB. It is only necessary to clear the tempA.cols - A.cols ( tempB.cols - B.cols)\n.   rightmost columns of the matrices.\n.   -   This DFT-based convolution does not have to be applied to the whole big arrays, especially if B\n.   is significantly smaller than A or vice versa. Instead, you can calculate convolution by parts.\n.   To do this, you need to split the output array C into multiple tiles. For each tile, estimate\n.   which parts of A and B are required to calculate convolution in this tile. If the tiles in C are\n.   too small, the speed will decrease a lot because of repeated work. In the ultimate case, when\n.   each tile in C is a single pixel, the algorithm becomes equivalent to the naive convolution\n.   algorithm. If the tiles are too big, the temporary arrays tempA and tempB become too big and\n.   there is also a slowdown because of bad cache locality. So, there is an optimal tile size\n.   somewhere in the middle.\n.   -   If different tiles in C can be calculated in parallel and, thus, the convolution is done by\n.   parts, the loop can be threaded.\n.   \n.   All of the above improvements have been implemented in #matchTemplate and #filter2D . Therefore, by\n.   using them, you can get the performance even better than with the above theoretically optimal\n.   implementation. Though, those two functions actually calculate cross-correlation, not convolution,\n.   so you need to \"flip\" the second convolution operand B vertically and horizontally using flip .\n.   @note\n.   -   An example using the discrete fourier transform can be found at\n.   opencv_source_code/samples/cpp/dft.cpp\n.   -   (Python) An example using the dft functionality to perform Wiener deconvolution can be found\n.   at opencv_source/samples/python/deconvolution.py\n.   -   (Python) An example rearranging the quadrants of a Fourier image can be found at\n.   opencv_source/samples/python/dft.py\n.   @param src input array that could be real or complex.\n.   @param dst output array whose size and type depends on the flags .\n.   @param flags transformation flags, representing a combination of the #DftFlags\n.   @param nonzeroRows when the parameter is not zero, the function assumes that only the first\n.   nonzeroRows rows of the input array (#DFT_INVERSE is not set) or only the first nonzeroRows of the\n.   output array (#DFT_INVERSE is set) contain non-zeros, thus, the function can handle the rest of the\n.   rows more efficiently and save some time; this technique is very useful for calculating array\n.   cross-correlation or convolution using DFT.\n.   @sa dct , getOptimalDFTSize , mulSpectrums, filter2D , matchTemplate , flip , cartToPolar ,\n.   magnitude , phase"},
    {"dilate", (PyCFunction)pyopencv_cv_dilate, METH_VARARGS | METH_KEYWORDS, "dilate(src, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Dilates an image by using a specific structuring element.\n.   \n.   The function dilates the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the maximum is taken:\n.   \\f[\\texttt{dst} (x,y) =  \\max _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   The function supports the in-place mode. Dilation can be applied several ( iterations ) times. In\n.   case of multi-channel images, each channel is processed independently.\n.   \n.   @param src input image; the number of channels can be arbitrary, but the depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param kernel structuring element used for dilation; if elemenat=Mat(), a 3 x 3 rectangular\n.   structuring element is used. Kernel can be created using #getStructuringElement\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times dilation is applied.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  erode, morphologyEx, getStructuringElement"},
    {"displayOverlay", (PyCFunction)pyopencv_cv_displayOverlay, METH_VARARGS | METH_KEYWORDS, "displayOverlay(winname, text[, delayms]) -> None\n.   @brief Displays a text on a window image as an overlay for a specified duration.\n.   \n.   The function displayOverlay displays useful information/tips on top of the window for a certain\n.   amount of time *delayms*. The function does not modify the image, displayed in the window, that is,\n.   after the specified delay the original content of the window is restored.\n.   \n.   @param winname Name of the window.\n.   @param text Overlay text to write on a window image.\n.   @param delayms The period (in milliseconds), during which the overlay text is displayed. If this\n.   function is called before the previous overlay text timed out, the timer is restarted and the text\n.   is updated. If this value is zero, the text never disappears."},
    {"displayStatusBar", (PyCFunction)pyopencv_cv_displayStatusBar, METH_VARARGS | METH_KEYWORDS, "displayStatusBar(winname, text[, delayms]) -> None\n.   @brief Displays a text on the window statusbar during the specified period of time.\n.   \n.   The function displayStatusBar displays useful information/tips on top of the window for a certain\n.   amount of time *delayms* . This information is displayed on the window statusbar (the window must be\n.   created with the CV_GUI_EXPANDED flags).\n.   \n.   @param winname Name of the window.\n.   @param text Text to write on the window statusbar.\n.   @param delayms Duration (in milliseconds) to display the text. If this function is called before\n.   the previous text timed out, the timer is restarted and the text is updated. If this value is\n.   zero, the text never disappears."},
    {"distanceTransform", (PyCFunction)pyopencv_cv_distanceTransform, METH_VARARGS | METH_KEYWORDS, "distanceTransform(src, distanceType, maskSize[, dst[, dstType]]) -> dst\n.   @overload\n.   @param src 8-bit, single-channel (binary) source image.\n.   @param dst Output image with calculated distances. It is a 8-bit or 32-bit floating-point,\n.   single-channel image of the same size as src .\n.   @param distanceType Type of distance, see #DistanceTypes\n.   @param maskSize Size of the distance transform mask, see #DistanceTransformMasks. In case of the\n.   #DIST_L1 or #DIST_C distance type, the parameter is forced to 3 because a \\f$3\\times 3\\f$ mask gives\n.   the same result as \\f$5\\times 5\\f$ or any larger aperture.\n.   @param dstType Type of output image. It can be CV_8U or CV_32F. Type CV_8U can be used only for\n.   the first variant of the function and distanceType == #DIST_L1."},
    {"distanceTransformWithLabels", (PyCFunction)pyopencv_cv_distanceTransformWithLabels, METH_VARARGS | METH_KEYWORDS, "distanceTransformWithLabels(src, distanceType, maskSize[, dst[, labels[, labelType]]]) -> dst, labels\n.   @brief Calculates the distance to the closest zero pixel for each pixel of the source image.\n.   \n.   The function cv::distanceTransform calculates the approximate or precise distance from every binary\n.   image pixel to the nearest zero pixel. For zero image pixels, the distance will obviously be zero.\n.   \n.   When maskSize == #DIST_MASK_PRECISE and distanceType == #DIST_L2 , the function runs the\n.   algorithm described in @cite Felzenszwalb04 . This algorithm is parallelized with the TBB library.\n.   \n.   In other cases, the algorithm @cite Borgefors86 is used. This means that for a pixel the function\n.   finds the shortest path to the nearest zero pixel consisting of basic shifts: horizontal, vertical,\n.   diagonal, or knight's move (the latest is available for a \\f$5\\times 5\\f$ mask). The overall\n.   distance is calculated as a sum of these basic distances. Since the distance function should be\n.   symmetric, all of the horizontal and vertical shifts must have the same cost (denoted as a ), all\n.   the diagonal shifts must have the same cost (denoted as `b`), and all knight's moves must have the\n.   same cost (denoted as `c`). For the #DIST_C and #DIST_L1 types, the distance is calculated\n.   precisely, whereas for #DIST_L2 (Euclidean distance) the distance can be calculated only with a\n.   relative error (a \\f$5\\times 5\\f$ mask gives more accurate results). For `a`,`b`, and `c`, OpenCV\n.   uses the values suggested in the original paper:\n.   - DIST_L1: `a = 1, b = 2`\n.   - DIST_L2:\n.   - `3 x 3`: `a=0.955, b=1.3693`\n.   - `5 x 5`: `a=1, b=1.4, c=2.1969`\n.   - DIST_C: `a = 1, b = 1`\n.   \n.   Typically, for a fast, coarse distance estimation #DIST_L2, a \\f$3\\times 3\\f$ mask is used. For a\n.   more accurate distance estimation #DIST_L2, a \\f$5\\times 5\\f$ mask or the precise algorithm is used.\n.   Note that both the precise and the approximate algorithms are linear on the number of pixels.\n.   \n.   This variant of the function does not only compute the minimum distance for each pixel \\f$(x, y)\\f$\n.   but also identifies the nearest connected component consisting of zero pixels\n.   (labelType==#DIST_LABEL_CCOMP) or the nearest zero pixel (labelType==#DIST_LABEL_PIXEL). Index of the\n.   component/pixel is stored in `labels(x, y)`. When labelType==#DIST_LABEL_CCOMP, the function\n.   automatically finds connected components of zero pixels in the input image and marks them with\n.   distinct labels. When labelType==#DIST_LABEL_CCOMP, the function scans through the input image and\n.   marks all the zero pixels with distinct labels.\n.   \n.   In this mode, the complexity is still linear. That is, the function provides a very fast way to\n.   compute the Voronoi diagram for a binary image. Currently, the second variant can use only the\n.   approximate distance transform algorithm, i.e. maskSize=#DIST_MASK_PRECISE is not supported\n.   yet.\n.   \n.   @param src 8-bit, single-channel (binary) source image.\n.   @param dst Output image with calculated distances. It is a 8-bit or 32-bit floating-point,\n.   single-channel image of the same size as src.\n.   @param labels Output 2D array of labels (the discrete Voronoi diagram). It has the type\n.   CV_32SC1 and the same size as src.\n.   @param distanceType Type of distance, see #DistanceTypes\n.   @param maskSize Size of the distance transform mask, see #DistanceTransformMasks.\n.   #DIST_MASK_PRECISE is not supported by this variant. In case of the #DIST_L1 or #DIST_C distance type,\n.   the parameter is forced to 3 because a \\f$3\\times 3\\f$ mask gives the same result as \\f$5\\times\n.   5\\f$ or any larger aperture.\n.   @param labelType Type of the label array to build, see #DistanceTransformLabelTypes."},
    {"divide", (PyCFunction)pyopencv_cv_divide, METH_VARARGS | METH_KEYWORDS, "divide(src1, src2[, dst[, scale[, dtype]]]) -> dst\n.   @brief Performs per-element division of two arrays or a scalar by an array.\n.   \n.   The function cv::divide divides one array by another:\n.   \\f[\\texttt{dst(I) = saturate(src1(I)*scale/src2(I))}\\f]\n.   or a scalar by an array when there is no src1 :\n.   \\f[\\texttt{dst(I) = saturate(scale/src2(I))}\\f]\n.   \n.   When src2(I) is zero, dst(I) will also be zero. Different channels of\n.   multi-channel arrays are processed independently.\n.   \n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param scale scalar factor.\n.   @param dst output array of the same size and type as src2.\n.   @param dtype optional depth of the output array; if -1, dst will have depth src2.depth(), but in\n.   case of an array-by-array division, you can only pass -1 when src1.depth()==src2.depth().\n.   @sa  multiply, add, subtract\n\n\n\ndivide(scale, src2[, dst[, dtype]]) -> dst\n.   @overload"},
    {"drawChessboardCorners", (PyCFunction)pyopencv_cv_drawChessboardCorners, METH_VARARGS | METH_KEYWORDS, "drawChessboardCorners(image, patternSize, corners, patternWasFound) -> image\n.   @brief Renders the detected chessboard corners.\n.   \n.   @param image Destination image. It must be an 8-bit color image.\n.   @param patternSize Number of inner corners per a chessboard row and column\n.   (patternSize = cv::Size(points_per_row,points_per_column)).\n.   @param corners Array of detected corners, the output of findChessboardCorners.\n.   @param patternWasFound Parameter indicating whether the complete board was found or not. The\n.   return value of findChessboardCorners should be passed here.\n.   \n.   The function draws individual chessboard corners detected either as red circles if the board was not\n.   found, or as colored corners connected with lines if the board was found."},
    {"drawContours", (PyCFunction)pyopencv_cv_drawContours, METH_VARARGS | METH_KEYWORDS, "drawContours(image, contours, contourIdx, color[, thickness[, lineType[, hierarchy[, maxLevel[, offset]]]]]) -> image\n.   @brief Draws contours outlines or filled contours.\n.   \n.   The function draws contour outlines in the image if \\f$\\texttt{thickness} \\ge 0\\f$ or fills the area\n.   bounded by the contours if \\f$\\texttt{thickness}<0\\f$ . The example below shows how to retrieve\n.   connected components from the binary image and label them: :\n.   @code\n.   #include \"opencv2/imgproc.hpp\"\n.   #include \"opencv2/highgui.hpp\"\n.   \n.   using namespace cv;\n.   using namespace std;\n.   \n.   int main( int argc, char** argv )\n.   {\n.   Mat src;\n.   // the first command-line parameter must be a filename of the binary\n.   // (black-n-white) image\n.   if( argc != 2 || !(src=imread(argv[1], 0)).data)\n.   return -1;\n.   \n.   Mat dst = Mat::zeros(src.rows, src.cols, CV_8UC3);\n.   \n.   src = src > 1;\n.   namedWindow( \"Source\", 1 );\n.   imshow( \"Source\", src );\n.   \n.   vector<vector<Point> > contours;\n.   vector<Vec4i> hierarchy;\n.   \n.   findContours( src, contours, hierarchy,\n.   RETR_CCOMP, CHAIN_APPROX_SIMPLE );\n.   \n.   // iterate through all the top-level contours,\n.   // draw each connected component with its own random color\n.   int idx = 0;\n.   for( ; idx >= 0; idx = hierarchy[idx][0] )\n.   {\n.   Scalar color( rand()&255, rand()&255, rand()&255 );\n.   drawContours( dst, contours, idx, color, FILLED, 8, hierarchy );\n.   }\n.   \n.   namedWindow( \"Components\", 1 );\n.   imshow( \"Components\", dst );\n.   waitKey(0);\n.   }\n.   @endcode\n.   \n.   @param image Destination image.\n.   @param contours All the input contours. Each contour is stored as a point vector.\n.   @param contourIdx Parameter indicating a contour to draw. If it is negative, all the contours are drawn.\n.   @param color Color of the contours.\n.   @param thickness Thickness of lines the contours are drawn with. If it is negative (for example,\n.   thickness=#FILLED ), the contour interiors are drawn.\n.   @param lineType Line connectivity. See #LineTypes\n.   @param hierarchy Optional information about hierarchy. It is only needed if you want to draw only\n.   some of the contours (see maxLevel ).\n.   @param maxLevel Maximal level for drawn contours. If it is 0, only the specified contour is drawn.\n.   If it is 1, the function draws the contour(s) and all the nested contours. If it is 2, the function\n.   draws the contours, all the nested contours, all the nested-to-nested contours, and so on. This\n.   parameter is only taken into account when there is hierarchy available.\n.   @param offset Optional contour shift parameter. Shift all the drawn contours by the specified\n.   \\f$\\texttt{offset}=(dx,dy)\\f$ .\n.   @note When thickness=#FILLED, the function is designed to handle connected components with holes correctly\n.   even when no hierarchy date is provided. This is done by analyzing all the outlines together\n.   using even-odd rule. This may give incorrect results if you have a joint collection of separately retrieved\n.   contours. In order to solve this problem, you need to call #drawContours separately for each sub-group\n.   of contours, or iterate over the collection using contourIdx parameter."},
    {"drawKeypoints", (PyCFunction)pyopencv_cv_drawKeypoints, METH_VARARGS | METH_KEYWORDS, "drawKeypoints(image, keypoints, outImage[, color[, flags]]) -> outImage\n.   @brief Draws keypoints.\n.   \n.   @param image Source image.\n.   @param keypoints Keypoints from the source image.\n.   @param outImage Output image. Its content depends on the flags value defining what is drawn in the\n.   output image. See possible flags bit values below.\n.   @param color Color of keypoints.\n.   @param flags Flags setting drawing features. Possible flags bit values are defined by\n.   DrawMatchesFlags. See details above in drawMatches .\n.   \n.   @note\n.   For Python API, flags are modified as cv2.DRAW_MATCHES_FLAGS_DEFAULT,\n.   cv2.DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS, cv2.DRAW_MATCHES_FLAGS_DRAW_OVER_OUTIMG,\n.   cv2.DRAW_MATCHES_FLAGS_NOT_DRAW_SINGLE_POINTS"},
    {"drawMarker", (PyCFunction)pyopencv_cv_drawMarker, METH_VARARGS | METH_KEYWORDS, "drawMarker(img, position, color[, markerType[, markerSize[, thickness[, line_type]]]]) -> img\n.   @brief Draws a marker on a predefined position in an image.\n.   \n.   The function cv::drawMarker draws a marker on a given position in the image. For the moment several\n.   marker types are supported, see #MarkerTypes for more information.\n.   \n.   @param img Image.\n.   @param position The point where the crosshair is positioned.\n.   @param color Line color.\n.   @param markerType The specific type of marker you want to use, see #MarkerTypes\n.   @param thickness Line thickness.\n.   @param line_type Type of the line, See #LineTypes\n.   @param markerSize The length of the marker axis [default = 20 pixels]"},
    {"drawMatches", (PyCFunction)pyopencv_cv_drawMatches, METH_VARARGS | METH_KEYWORDS, "drawMatches(img1, keypoints1, img2, keypoints2, matches1to2, outImg[, matchColor[, singlePointColor[, matchesMask[, flags]]]]) -> outImg\n.   @brief Draws the found matches of keypoints from two images.\n.   \n.   @param img1 First source image.\n.   @param keypoints1 Keypoints from the first source image.\n.   @param img2 Second source image.\n.   @param keypoints2 Keypoints from the second source image.\n.   @param matches1to2 Matches from the first image to the second one, which means that keypoints1[i]\n.   has a corresponding point in keypoints2[matches[i]] .\n.   @param outImg Output image. Its content depends on the flags value defining what is drawn in the\n.   output image. See possible flags bit values below.\n.   @param matchColor Color of matches (lines and connected keypoints). If matchColor==Scalar::all(-1)\n.   , the color is generated randomly.\n.   @param singlePointColor Color of single keypoints (circles), which means that keypoints do not\n.   have the matches. If singlePointColor==Scalar::all(-1) , the color is generated randomly.\n.   @param matchesMask Mask determining which matches are drawn. If the mask is empty, all matches are\n.   drawn.\n.   @param flags Flags setting drawing features. Possible flags bit values are defined by\n.   DrawMatchesFlags.\n.   \n.   This function draws matches of keypoints from two images in the output image. Match is a line\n.   connecting two keypoints (circles). See cv::DrawMatchesFlags."},
    {"drawMatchesKnn", (PyCFunction)pyopencv_cv_drawMatchesKnn, METH_VARARGS | METH_KEYWORDS, "drawMatchesKnn(img1, keypoints1, img2, keypoints2, matches1to2, outImg[, matchColor[, singlePointColor[, matchesMask[, flags]]]]) -> outImg\n.   @overload"},
    {"edgePreservingFilter", (PyCFunction)pyopencv_cv_edgePreservingFilter, METH_VARARGS | METH_KEYWORDS, "edgePreservingFilter(src[, dst[, flags[, sigma_s[, sigma_r]]]]) -> dst\n.   @brief Filtering is the fundamental operation in image and video processing. Edge-preserving smoothing\n.   filters are used in many different applications @cite EM11 .\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output 8-bit 3-channel image.\n.   @param flags Edge preserving filters:\n.   -   **RECURS_FILTER** = 1\n.   -   **NORMCONV_FILTER** = 2\n.   @param sigma_s Range between 0 to 200.\n.   @param sigma_r Range between 0 to 1."},
    {"eigen", (PyCFunction)pyopencv_cv_eigen, METH_VARARGS | METH_KEYWORDS, "eigen(src[, eigenvalues[, eigenvectors]]) -> retval, eigenvalues, eigenvectors\n.   @brief Calculates eigenvalues and eigenvectors of a symmetric matrix.\n.   \n.   The function cv::eigen calculates just eigenvalues, or eigenvalues and eigenvectors of the symmetric\n.   matrix src:\n.   @code\n.   src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()\n.   @endcode\n.   \n.   @note Use cv::eigenNonSymmetric for calculation of real eigenvalues and eigenvectors of non-symmetric matrix.\n.   \n.   @param src input matrix that must have CV_32FC1 or CV_64FC1 type, square size and be symmetrical\n.   (src ^T^ == src).\n.   @param eigenvalues output vector of eigenvalues of the same type as src; the eigenvalues are stored\n.   in the descending order.\n.   @param eigenvectors output matrix of eigenvectors; it has the same size and type as src; the\n.   eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding\n.   eigenvalues.\n.   @sa eigenNonSymmetric, completeSymm , PCA"},
    {"eigenNonSymmetric", (PyCFunction)pyopencv_cv_eigenNonSymmetric, METH_VARARGS | METH_KEYWORDS, "eigenNonSymmetric(src[, eigenvalues[, eigenvectors]]) -> eigenvalues, eigenvectors\n.   @brief Calculates eigenvalues and eigenvectors of a non-symmetric matrix (real eigenvalues only).\n.   \n.   @note Assumes real eigenvalues.\n.   \n.   The function calculates eigenvalues and eigenvectors (optional) of the square matrix src:\n.   @code\n.   src*eigenvectors.row(i).t() = eigenvalues.at<srcType>(i)*eigenvectors.row(i).t()\n.   @endcode\n.   \n.   @param src input matrix (CV_32FC1 or CV_64FC1 type).\n.   @param eigenvalues output vector of eigenvalues (type is the same type as src).\n.   @param eigenvectors output matrix of eigenvectors (type is the same type as src). The eigenvectors are stored as subsequent matrix rows, in the same order as the corresponding eigenvalues.\n.   @sa eigen"},
    {"ellipse", (PyCFunction)pyopencv_cv_ellipse, METH_VARARGS | METH_KEYWORDS, "ellipse(img, center, axes, angle, startAngle, endAngle, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a simple or thick elliptic arc or fills an ellipse sector.\n.   \n.   The function cv::ellipse with more parameters draws an ellipse outline, a filled ellipse, an elliptic\n.   arc, or a filled ellipse sector. The drawing code uses general parametric form.\n.   A piecewise-linear curve is used to approximate the elliptic arc\n.   boundary. If you need more control of the ellipse rendering, you can retrieve the curve using\n.   #ellipse2Poly and then render it with #polylines or fill it with #fillPoly. If you use the first\n.   variant of the function and want to draw the whole ellipse, not an arc, pass `startAngle=0` and\n.   `endAngle=360`. If `startAngle` is greater than `endAngle`, they are swapped. The figure below explains\n.   the meaning of the parameters to draw the blue arc.\n.   \n.   ![Parameters of Elliptic Arc](pics/ellipse.svg)\n.   \n.   @param img Image.\n.   @param center Center of the ellipse.\n.   @param axes Half of the size of the ellipse main axes.\n.   @param angle Ellipse rotation angle in degrees.\n.   @param startAngle Starting angle of the elliptic arc in degrees.\n.   @param endAngle Ending angle of the elliptic arc in degrees.\n.   @param color Ellipse color.\n.   @param thickness Thickness of the ellipse arc outline, if positive. Otherwise, this indicates that\n.   a filled ellipse sector is to be drawn.\n.   @param lineType Type of the ellipse boundary. See #LineTypes\n.   @param shift Number of fractional bits in the coordinates of the center and values of axes.\n\n\n\nellipse(img, box, color[, thickness[, lineType]]) -> img\n.   @overload\n.   @param img Image.\n.   @param box Alternative ellipse representation via RotatedRect. This means that the function draws\n.   an ellipse inscribed in the rotated rectangle.\n.   @param color Ellipse color.\n.   @param thickness Thickness of the ellipse arc outline, if positive. Otherwise, this indicates that\n.   a filled ellipse sector is to be drawn.\n.   @param lineType Type of the ellipse boundary. See #LineTypes"},
    {"ellipse2Poly", (PyCFunction)pyopencv_cv_ellipse2Poly, METH_VARARGS | METH_KEYWORDS, "ellipse2Poly(center, axes, angle, arcStart, arcEnd, delta) -> pts\n.   @brief Approximates an elliptic arc with a polyline.\n.   \n.   The function ellipse2Poly computes the vertices of a polyline that approximates the specified\n.   elliptic arc. It is used by #ellipse. If `arcStart` is greater than `arcEnd`, they are swapped.\n.   \n.   @param center Center of the arc.\n.   @param axes Half of the size of the ellipse main axes. See #ellipse for details.\n.   @param angle Rotation angle of the ellipse in degrees. See #ellipse for details.\n.   @param arcStart Starting angle of the elliptic arc in degrees.\n.   @param arcEnd Ending angle of the elliptic arc in degrees.\n.   @param delta Angle between the subsequent polyline vertices. It defines the approximation\n.   accuracy.\n.   @param pts Output vector of polyline vertices."},
    {"equalizeHist", (PyCFunction)pyopencv_cv_equalizeHist, METH_VARARGS | METH_KEYWORDS, "equalizeHist(src[, dst]) -> dst\n.   @brief Equalizes the histogram of a grayscale image.\n.   \n.   The function equalizes the histogram of the input image using the following algorithm:\n.   \n.   - Calculate the histogram \\f$H\\f$ for src .\n.   - Normalize the histogram so that the sum of histogram bins is 255.\n.   - Compute the integral of the histogram:\n.   \\f[H'_i =  \\sum _{0  \\le j < i} H(j)\\f]\n.   - Transform the image using \\f$H'\\f$ as a look-up table: \\f$\\texttt{dst}(x,y) = H'(\\texttt{src}(x,y))\\f$\n.   \n.   The algorithm normalizes the brightness and increases the contrast of the image.\n.   \n.   @param src Source 8-bit single channel image.\n.   @param dst Destination image of the same size and type as src ."},
    {"erode", (PyCFunction)pyopencv_cv_erode, METH_VARARGS | METH_KEYWORDS, "erode(src, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Erodes an image by using a specific structuring element.\n.   \n.   The function erodes the source image using the specified structuring element that determines the\n.   shape of a pixel neighborhood over which the minimum is taken:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\min _{(x',y'):  \\, \\texttt{element} (x',y') \\ne0 } \\texttt{src} (x+x',y+y')\\f]\n.   \n.   The function supports the in-place mode. Erosion can be applied several ( iterations ) times. In\n.   case of multi-channel images, each channel is processed independently.\n.   \n.   @param src input image; the number of channels can be arbitrary, but the depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst output image of the same size and type as src.\n.   @param kernel structuring element used for erosion; if `element=Mat()`, a `3 x 3` rectangular\n.   structuring element is used. Kernel can be created using #getStructuringElement.\n.   @param anchor position of the anchor within the element; default value (-1, -1) means that the\n.   anchor is at the element center.\n.   @param iterations number of times erosion is applied.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   @param borderValue border value in case of a constant border\n.   @sa  dilate, morphologyEx, getStructuringElement"},
    {"estimateAffine2D", (PyCFunction)pyopencv_cv_estimateAffine2D, METH_VARARGS | METH_KEYWORDS, "estimateAffine2D(from, to[, inliers[, method[, ransacReprojThreshold[, maxIters[, confidence[, refineIters]]]]]]) -> retval, inliers\n.   @brief Computes an optimal affine transformation between two 2D point sets.\n.   \n.   It computes\n.   \\f[\n.   \\begin{bmatrix}\n.   x\\\\\n.   y\\\\\n.   \\end{bmatrix}\n.   =\n.   \\begin{bmatrix}\n.   a_{11} & a_{12}\\\\\n.   a_{21} & a_{22}\\\\\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X\\\\\n.   Y\\\\\n.   \\end{bmatrix}\n.   +\n.   \\begin{bmatrix}\n.   b_1\\\\\n.   b_2\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   @param from First input 2D point set containing \\f$(X,Y)\\f$.\n.   @param to Second input 2D point set containing \\f$(x,y)\\f$.\n.   @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).\n.   @param method Robust method used to compute transformation. The following methods are possible:\n.   -   cv::RANSAC - RANSAC-based robust method\n.   -   cv::LMEDS - Least-Median robust method\n.   RANSAC is the default method.\n.   @param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider\n.   a point as an inlier. Applies only to RANSAC.\n.   @param maxIters The maximum number of robust method iterations.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   @param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).\n.   Passing 0 will disable refining, so the output matrix will be output of robust method.\n.   \n.   @return Output 2D affine transformation matrix \\f$2 \\times 3\\f$ or empty matrix if transformation\n.   could not be estimated. The returned matrix has the following form:\n.   \\f[\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & b_1\\\\\n.   a_{21} & a_{22} & b_2\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   The function estimates an optimal 2D affine transformation between two 2D point sets using the\n.   selected robust algorithm.\n.   \n.   The computed transformation is then refined further (using only inliers) with the\n.   Levenberg-Marquardt method to reduce the re-projection error even more.\n.   \n.   @note\n.   The RANSAC method can handle practically any ratio of outliers but needs a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers.\n.   \n.   @sa estimateAffinePartial2D, getAffineTransform"},
    {"estimateAffine3D", (PyCFunction)pyopencv_cv_estimateAffine3D, METH_VARARGS | METH_KEYWORDS, "estimateAffine3D(src, dst[, out[, inliers[, ransacThreshold[, confidence]]]]) -> retval, out, inliers\n.   @brief Computes an optimal affine transformation between two 3D point sets.\n.   \n.   It computes\n.   \\f[\n.   \\begin{bmatrix}\n.   x\\\\\n.   y\\\\\n.   z\\\\\n.   \\end{bmatrix}\n.   =\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & a_{13}\\\\\n.   a_{21} & a_{22} & a_{23}\\\\\n.   a_{31} & a_{32} & a_{33}\\\\\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X\\\\\n.   Y\\\\\n.   Z\\\\\n.   \\end{bmatrix}\n.   +\n.   \\begin{bmatrix}\n.   b_1\\\\\n.   b_2\\\\\n.   b_3\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   \n.   @param src First input 3D point set containing \\f$(X,Y,Z)\\f$.\n.   @param dst Second input 3D point set containing \\f$(x,y,z)\\f$.\n.   @param out Output 3D affine transformation matrix \\f$3 \\times 4\\f$ of the form\n.   \\f[\n.   \\begin{bmatrix}\n.   a_{11} & a_{12} & a_{13} & b_1\\\\\n.   a_{21} & a_{22} & a_{23} & b_2\\\\\n.   a_{31} & a_{32} & a_{33} & b_3\\\\\n.   \\end{bmatrix}\n.   \\f]\n.   @param inliers Output vector indicating which points are inliers (1-inlier, 0-outlier).\n.   @param ransacThreshold Maximum reprojection error in the RANSAC algorithm to consider a point as\n.   an inlier.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   \n.   The function estimates an optimal 3D affine transformation between two 3D point sets using the\n.   RANSAC algorithm."},
    {"estimateAffinePartial2D", (PyCFunction)pyopencv_cv_estimateAffinePartial2D, METH_VARARGS | METH_KEYWORDS, "estimateAffinePartial2D(from, to[, inliers[, method[, ransacReprojThreshold[, maxIters[, confidence[, refineIters]]]]]]) -> retval, inliers\n.   @brief Computes an optimal limited affine transformation with 4 degrees of freedom between\n.   two 2D point sets.\n.   \n.   @param from First input 2D point set.\n.   @param to Second input 2D point set.\n.   @param inliers Output vector indicating which points are inliers.\n.   @param method Robust method used to compute transformation. The following methods are possible:\n.   -   cv::RANSAC - RANSAC-based robust method\n.   -   cv::LMEDS - Least-Median robust method\n.   RANSAC is the default method.\n.   @param ransacReprojThreshold Maximum reprojection error in the RANSAC algorithm to consider\n.   a point as an inlier. Applies only to RANSAC.\n.   @param maxIters The maximum number of robust method iterations.\n.   @param confidence Confidence level, between 0 and 1, for the estimated transformation. Anything\n.   between 0.95 and 0.99 is usually good enough. Values too close to 1 can slow down the estimation\n.   significantly. Values lower than 0.8-0.9 can result in an incorrectly estimated transformation.\n.   @param refineIters Maximum number of iterations of refining algorithm (Levenberg-Marquardt).\n.   Passing 0 will disable refining, so the output matrix will be output of robust method.\n.   \n.   @return Output 2D affine transformation (4 degrees of freedom) matrix \\f$2 \\times 3\\f$ or\n.   empty matrix if transformation could not be estimated.\n.   \n.   The function estimates an optimal 2D affine transformation with 4 degrees of freedom limited to\n.   combinations of translation, rotation, and uniform scaling. Uses the selected algorithm for robust\n.   estimation.\n.   \n.   The computed transformation is then refined further (using only inliers) with the\n.   Levenberg-Marquardt method to reduce the re-projection error even more.\n.   \n.   Estimated transformation matrix is:\n.   \\f[ \\begin{bmatrix} \\cos(\\theta) \\cdot s & -\\sin(\\theta) \\cdot s & t_x \\\\\n.   \\sin(\\theta) \\cdot s & \\cos(\\theta) \\cdot s & t_y\n.   \\end{bmatrix} \\f]\n.   Where \\f$ \\theta \\f$ is the rotation angle, \\f$ s \\f$ the scaling factor and \\f$ t_x, t_y \\f$ are\n.   translations in \\f$ x, y \\f$ axes respectively.\n.   \n.   @note\n.   The RANSAC method can handle practically any ratio of outliers but need a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers.\n.   \n.   @sa estimateAffine2D, getAffineTransform"},
    {"estimateRigidTransform", (PyCFunction)pyopencv_cv_estimateRigidTransform, METH_VARARGS | METH_KEYWORDS, "estimateRigidTransform(src, dst, fullAffine) -> retval\n.   @brief Computes an optimal affine transformation between two 2D point sets.\n.   \n.   @param src First input 2D point set stored in std::vector or Mat, or an image stored in Mat.\n.   @param dst Second input 2D point set of the same size and the same type as A, or another image.\n.   @param fullAffine If true, the function finds an optimal affine transformation with no additional\n.   restrictions (6 degrees of freedom). Otherwise, the class of transformations to choose from is\n.   limited to combinations of translation, rotation, and uniform scaling (4 degrees of freedom).\n.   \n.   The function finds an optimal affine transform *[A|b]* (a 2 x 3 floating-point matrix) that\n.   approximates best the affine transformation between:\n.   \n.   *   Two point sets\n.   *   Two raster images. In this case, the function first finds some features in the src image and\n.   finds the corresponding features in dst image. After that, the problem is reduced to the first\n.   case.\n.   In case of point sets, the problem is formulated as follows: you need to find a 2x2 matrix *A* and\n.   2x1 vector *b* so that:\n.   \n.   \\f[[A^*|b^*] = arg  \\min _{[A|b]}  \\sum _i  \\| \\texttt{dst}[i] - A { \\texttt{src}[i]}^T - b  \\| ^2\\f]\n.   where src[i] and dst[i] are the i-th points in src and dst, respectively\n.   \\f$[A|b]\\f$ can be either arbitrary (when fullAffine=true ) or have a form of\n.   \\f[\\begin{bmatrix} a_{11} & a_{12} & b_1  \\\\ -a_{12} & a_{11} & b_2  \\end{bmatrix}\\f]\n.   when fullAffine=false.\n.   \n.   @sa\n.   estimateAffine2D, estimateAffinePartial2D, getAffineTransform, getPerspectiveTransform, findHomography"},
    {"exp", (PyCFunction)pyopencv_cv_exp, METH_VARARGS | METH_KEYWORDS, "exp(src[, dst]) -> dst\n.   @brief Calculates the exponent of every array element.\n.   \n.   The function cv::exp calculates the exponent of every element of the input\n.   array:\n.   \\f[\\texttt{dst} [I] = e^{ src(I) }\\f]\n.   \n.   The maximum relative error is about 7e-6 for single-precision input and\n.   less than 1e-10 for double-precision input. Currently, the function\n.   converts denormalized values to zeros on output. Special values (NaN,\n.   Inf) are not handled.\n.   @param src input array.\n.   @param dst output array of the same size and type as src.\n.   @sa log , cartToPolar , polarToCart , phase , pow , sqrt , magnitude"},
    {"extractChannel", (PyCFunction)pyopencv_cv_extractChannel, METH_VARARGS | METH_KEYWORDS, "extractChannel(src, coi[, dst]) -> dst\n.   @brief Extracts a single channel from src (coi is 0-based index)\n.   @param src input array\n.   @param dst output array\n.   @param coi index of channel to extract\n.   @sa mixChannels, split"},
    {"fastAtan2", (PyCFunction)pyopencv_cv_fastAtan2, METH_VARARGS | METH_KEYWORDS, "fastAtan2(y, x) -> retval\n.   @brief Calculates the angle of a 2D vector in degrees.\n.   \n.   The function fastAtan2 calculates the full-range angle of an input 2D vector. The angle is measured\n.   in degrees and varies from 0 to 360 degrees. The accuracy is about 0.3 degrees.\n.   @param x x-coordinate of the vector.\n.   @param y y-coordinate of the vector."},
    {"fastNlMeansDenoising", (PyCFunction)pyopencv_cv_fastNlMeansDenoising, METH_VARARGS | METH_KEYWORDS, "fastNlMeansDenoising(src[, dst[, h[, templateWindowSize[, searchWindowSize]]]]) -> dst\n.   @brief Perform image denoising using Non-local Means Denoising algorithm\n.   <http://www.ipol.im/pub/algo/bcm_non_local_means_denoising/> with several computational\n.   optimizations. Noise expected to be a gaussian white noise\n.   \n.   @param src Input 8-bit 1-channel, 2-channel, 3-channel or 4-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength. Big h value perfectly removes noise but also\n.   removes image details, smaller h value preserves details but also preserves some noise\n.   \n.   This function expected to be applied to grayscale images. For colored images look at\n.   fastNlMeansDenoisingColored. Advanced usage of this functions can be manual denoising of colored\n.   image in different colorspaces. Such approach is used in fastNlMeansDenoisingColored by converting\n.   image to CIELAB colorspace and then separately denoise L and AB components with different h\n.   parameter.\n\n\n\nfastNlMeansDenoising(src, h[, dst[, templateWindowSize[, searchWindowSize[, normType]]]]) -> dst\n.   @brief Perform image denoising using Non-local Means Denoising algorithm\n.   <http://www.ipol.im/pub/algo/bcm_non_local_means_denoising/> with several computational\n.   optimizations. Noise expected to be a gaussian white noise\n.   \n.   @param src Input 8-bit or 16-bit (only with NORM_L1) 1-channel,\n.   2-channel, 3-channel or 4-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Array of parameters regulating filter strength, either one\n.   parameter applied to all channels or one per channel in dst. Big h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n.   @param normType Type of norm used for weight calculation. Can be either NORM_L2 or NORM_L1\n.   \n.   This function expected to be applied to grayscale images. For colored images look at\n.   fastNlMeansDenoisingColored. Advanced usage of this functions can be manual denoising of colored\n.   image in different colorspaces. Such approach is used in fastNlMeansDenoisingColored by converting\n.   image to CIELAB colorspace and then separately denoise L and AB components with different h\n.   parameter."},
    {"fastNlMeansDenoisingColored", (PyCFunction)pyopencv_cv_fastNlMeansDenoisingColored, METH_VARARGS | METH_KEYWORDS, "fastNlMeansDenoisingColored(src[, dst[, h[, hColor[, templateWindowSize[, searchWindowSize]]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for colored images\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src .\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength for luminance component. Bigger h value perfectly\n.   removes noise but also removes image details, smaller h value preserves details but also preserves\n.   some noise\n.   @param hColor The same as h but for color components. For most images value equals 10\n.   will be enough to remove colored noise and do not distort colors\n.   \n.   The function converts image to CIELAB colorspace and then separately denoise L and AB components\n.   with given h parameters using fastNlMeansDenoising function."},
    {"fastNlMeansDenoisingColoredMulti", (PyCFunction)pyopencv_cv_fastNlMeansDenoisingColoredMulti, METH_VARARGS | METH_KEYWORDS, "fastNlMeansDenoisingColoredMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize[, dst[, h[, hColor[, templateWindowSize[, searchWindowSize]]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoisingMulti function for colored images sequences\n.   \n.   @param srcImgs Input 8-bit 3-channel images sequence. All images should have the same type and\n.   size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex - temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength for luminance component. Bigger h value perfectly\n.   removes noise but also removes image details, smaller h value preserves details but also preserves\n.   some noise.\n.   @param hColor The same as h but for color components.\n.   \n.   The function converts images to CIELAB colorspace and then separately denoise L and AB components\n.   with given h parameters using fastNlMeansDenoisingMulti function."},
    {"fastNlMeansDenoisingMulti", (PyCFunction)pyopencv_cv_fastNlMeansDenoisingMulti, METH_VARARGS | METH_KEYWORDS, "fastNlMeansDenoisingMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize[, dst[, h[, templateWindowSize[, searchWindowSize]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for images sequence where consecutive images have been\n.   captured in small period of time. For example video. This version of the function is for grayscale\n.   images or for manual manipulation with colorspaces. For more details see\n.   <http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.131.6394>\n.   \n.   @param srcImgs Input 8-bit 1-channel, 2-channel, 3-channel or\n.   4-channel images sequence. All images should have the same type and\n.   size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex - temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Parameter regulating filter strength. Bigger h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n\n\n\nfastNlMeansDenoisingMulti(srcImgs, imgToDenoiseIndex, temporalWindowSize, h[, dst[, templateWindowSize[, searchWindowSize[, normType]]]]) -> dst\n.   @brief Modification of fastNlMeansDenoising function for images sequence where consecutive images have been\n.   captured in small period of time. For example video. This version of the function is for grayscale\n.   images or for manual manipulation with colorspaces. For more details see\n.   <http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.131.6394>\n.   \n.   @param srcImgs Input 8-bit or 16-bit (only with NORM_L1) 1-channel,\n.   2-channel, 3-channel or 4-channel images sequence. All images should\n.   have the same type and size.\n.   @param imgToDenoiseIndex Target image to denoise index in srcImgs sequence\n.   @param temporalWindowSize Number of surrounding images to use for target image denoising. Should\n.   be odd. Images from imgToDenoiseIndex - temporalWindowSize / 2 to\n.   imgToDenoiseIndex - temporalWindowSize / 2 from srcImgs will be used to denoise\n.   srcImgs[imgToDenoiseIndex] image.\n.   @param dst Output image with the same size and type as srcImgs images.\n.   @param templateWindowSize Size in pixels of the template patch that is used to compute weights.\n.   Should be odd. Recommended value 7 pixels\n.   @param searchWindowSize Size in pixels of the window that is used to compute weighted average for\n.   given pixel. Should be odd. Affect performance linearly: greater searchWindowsSize - greater\n.   denoising time. Recommended value 21 pixels\n.   @param h Array of parameters regulating filter strength, either one\n.   parameter applied to all channels or one per channel in dst. Big h value\n.   perfectly removes noise but also removes image details, smaller h\n.   value preserves details but also preserves some noise\n.   @param normType Type of norm used for weight calculation. Can be either NORM_L2 or NORM_L1"},
    {"fillConvexPoly", (PyCFunction)pyopencv_cv_fillConvexPoly, METH_VARARGS | METH_KEYWORDS, "fillConvexPoly(img, points, color[, lineType[, shift]]) -> img\n.   @brief Fills a convex polygon.\n.   \n.   The function cv::fillConvexPoly draws a filled convex polygon. This function is much faster than the\n.   function #fillPoly . It can fill not only convex polygons but any monotonic polygon without\n.   self-intersections, that is, a polygon whose contour intersects every horizontal line (scan line)\n.   twice at the most (though, its top-most and/or the bottom edge could be horizontal).\n.   \n.   @param img Image.\n.   @param points Polygon vertices.\n.   @param color Polygon color.\n.   @param lineType Type of the polygon boundaries. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates."},
    {"fillPoly", (PyCFunction)pyopencv_cv_fillPoly, METH_VARARGS | METH_KEYWORDS, "fillPoly(img, pts, color[, lineType[, shift[, offset]]]) -> img\n.   @brief Fills the area bounded by one or more polygons.\n.   \n.   The function cv::fillPoly fills an area bounded by several polygonal contours. The function can fill\n.   complex areas, for example, areas with holes, contours with self-intersections (some of their\n.   parts), and so forth.\n.   \n.   @param img Image.\n.   @param pts Array of polygons where each polygon is represented as an array of points.\n.   @param color Polygon color.\n.   @param lineType Type of the polygon boundaries. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates.\n.   @param offset Optional offset of all points of the contours."},
    {"filter2D", (PyCFunction)pyopencv_cv_filter2D, METH_VARARGS | METH_KEYWORDS, "filter2D(src, ddepth, kernel[, dst[, anchor[, delta[, borderType]]]]) -> dst\n.   @brief Convolves an image with the kernel.\n.   \n.   The function applies an arbitrary linear filter to an image. In-place operation is supported. When\n.   the aperture is partially outside the image, the function interpolates outlier pixel values\n.   according to the specified border mode.\n.   \n.   The function does actually compute correlation, not the convolution:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\sum _{ \\stackrel{0\\leq x' < \\texttt{kernel.cols},}{0\\leq y' < \\texttt{kernel.rows}} }  \\texttt{kernel} (x',y')* \\texttt{src} (x+x'- \\texttt{anchor.x} ,y+y'- \\texttt{anchor.y} )\\f]\n.   \n.   That is, the kernel is not mirrored around the anchor point. If you need a real convolution, flip\n.   the kernel using #flip and set the new anchor to `(kernel.cols - anchor.x - 1, kernel.rows -\n.   anchor.y - 1)`.\n.   \n.   The function uses the DFT-based algorithm in case of sufficiently large kernels (~`11 x 11` or\n.   larger) and the direct algorithm for small kernels.\n.   \n.   @param src input image.\n.   @param dst output image of the same size and the same number of channels as src.\n.   @param ddepth desired depth of the destination image, see @ref filter_depths \"combinations\"\n.   @param kernel convolution kernel (or rather a correlation kernel), a single-channel floating point\n.   matrix; if you want to apply different kernels to different channels, split the image into\n.   separate color planes using split and process them individually.\n.   @param anchor anchor of the kernel that indicates the relative position of a filtered point within\n.   the kernel; the anchor should lie within the kernel; default value (-1,-1) means that the anchor\n.   is at the kernel center.\n.   @param delta optional value added to the filtered pixels before storing them in dst.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   @sa  sepFilter2D, dft, matchTemplate"},
    {"filterSpeckles", (PyCFunction)pyopencv_cv_filterSpeckles, METH_VARARGS | METH_KEYWORDS, "filterSpeckles(img, newVal, maxSpeckleSize, maxDiff[, buf]) -> img, buf\n.   @brief Filters off small noise blobs (speckles) in the disparity map\n.   \n.   @param img The input 16-bit signed disparity image\n.   @param newVal The disparity value used to paint-off the speckles\n.   @param maxSpeckleSize The maximum speckle size to consider it a speckle. Larger blobs are not\n.   affected by the algorithm\n.   @param maxDiff Maximum difference between neighbor disparity pixels to put them into the same\n.   blob. Note that since StereoBM, StereoSGBM and may be other algorithms return a fixed-point\n.   disparity map, where disparity values are multiplied by 16, this scale factor should be taken into\n.   account when specifying this parameter value.\n.   @param buf The optional temporary buffer to avoid memory allocation within the function."},
    {"findChessboardCorners", (PyCFunction)pyopencv_cv_findChessboardCorners, METH_VARARGS | METH_KEYWORDS, "findChessboardCorners(image, patternSize[, corners[, flags]]) -> retval, corners\n.   @brief Finds the positions of internal corners of the chessboard.\n.   \n.   @param image Source chessboard view. It must be an 8-bit grayscale or color image.\n.   @param patternSize Number of inner corners per a chessboard row and column\n.   ( patternSize = cvSize(points_per_row,points_per_colum) = cvSize(columns,rows) ).\n.   @param corners Output array of detected corners.\n.   @param flags Various operation flags that can be zero or a combination of the following values:\n.   -   **CALIB_CB_ADAPTIVE_THRESH** Use adaptive thresholding to convert the image to black\n.   and white, rather than a fixed threshold level (computed from the average image brightness).\n.   -   **CALIB_CB_NORMALIZE_IMAGE** Normalize the image gamma with equalizeHist before\n.   applying fixed or adaptive thresholding.\n.   -   **CALIB_CB_FILTER_QUADS** Use additional criteria (like contour area, perimeter,\n.   square-like shape) to filter out false quads extracted at the contour retrieval stage.\n.   -   **CALIB_CB_FAST_CHECK** Run a fast check on the image that looks for chessboard corners,\n.   and shortcut the call if none is found. This can drastically speed up the call in the\n.   degenerate condition when no chessboard is observed.\n.   \n.   The function attempts to determine whether the input image is a view of the chessboard pattern and\n.   locate the internal chessboard corners. The function returns a non-zero value if all of the corners\n.   are found and they are placed in a certain order (row by row, left to right in every row).\n.   Otherwise, if the function fails to find all the corners or reorder them, it returns 0. For example,\n.   a regular chessboard has 8 x 8 squares and 7 x 7 internal corners, that is, points where the black\n.   squares touch each other. The detected coordinates are approximate, and to determine their positions\n.   more accurately, the function calls cornerSubPix. You also may use the function cornerSubPix with\n.   different parameters if returned coordinates are not accurate enough.\n.   \n.   Sample usage of detecting and drawing chessboard corners: :\n.   @code\n.   Size patternsize(8,6); //interior number of corners\n.   Mat gray = ....; //source image\n.   vector<Point2f> corners; //this will be filled by the detected corners\n.   \n.   //CALIB_CB_FAST_CHECK saves a lot of time on images\n.   //that do not contain any chessboard corners\n.   bool patternfound = findChessboardCorners(gray, patternsize, corners,\n.   CALIB_CB_ADAPTIVE_THRESH + CALIB_CB_NORMALIZE_IMAGE\n.   + CALIB_CB_FAST_CHECK);\n.   \n.   if(patternfound)\n.   cornerSubPix(gray, corners, Size(11, 11), Size(-1, -1),\n.   TermCriteria(CV_TERMCRIT_EPS + CV_TERMCRIT_ITER, 30, 0.1));\n.   \n.   drawChessboardCorners(img, patternsize, Mat(corners), patternfound);\n.   @endcode\n.   @note The function requires white space (like a square-thick border, the wider the better) around\n.   the board to make the detection more robust in various environments. Otherwise, if there is no\n.   border and the background is dark, the outer black squares cannot be segmented properly and so the\n.   square grouping and ordering algorithm fails."},
    {"findCirclesGrid", (PyCFunction)pyopencv_cv_findCirclesGrid, METH_VARARGS | METH_KEYWORDS, "findCirclesGrid(image, patternSize, flags, blobDetector, parameters[, centers]) -> retval, centers\n.   @brief Finds centers in the grid of circles.\n.   \n.   @param image grid view of input circles; it must be an 8-bit grayscale or color image.\n.   @param patternSize number of circles per row and column\n.   ( patternSize = Size(points_per_row, points_per_colum) ).\n.   @param centers output array of detected centers.\n.   @param flags various operation flags that can be one of the following values:\n.   -   **CALIB_CB_SYMMETRIC_GRID** uses symmetric pattern of circles.\n.   -   **CALIB_CB_ASYMMETRIC_GRID** uses asymmetric pattern of circles.\n.   -   **CALIB_CB_CLUSTERING** uses a special algorithm for grid detection. It is more robust to\n.   perspective distortions but much more sensitive to background clutter.\n.   @param blobDetector feature detector that finds blobs like dark circles on light background.\n.   @param parameters struct for finding circles in a grid pattern.\n.   \n.   The function attempts to determine whether the input image contains a grid of circles. If it is, the\n.   function locates centers of the circles. The function returns a non-zero value if all of the centers\n.   have been found and they have been placed in a certain order (row by row, left to right in every\n.   row). Otherwise, if the function fails to find all the corners or reorder them, it returns 0.\n.   \n.   Sample usage of detecting and drawing the centers of circles: :\n.   @code\n.   Size patternsize(7,7); //number of centers\n.   Mat gray = ....; //source image\n.   vector<Point2f> centers; //this will be filled by the detected centers\n.   \n.   bool patternfound = findCirclesGrid(gray, patternsize, centers);\n.   \n.   drawChessboardCorners(img, patternsize, Mat(centers), patternfound);\n.   @endcode\n.   @note The function requires white space (like a square-thick border, the wider the better) around\n.   the board to make the detection more robust in various environments.\n\n\n\nfindCirclesGrid(image, patternSize[, centers[, flags[, blobDetector]]]) -> retval, centers\n.   @overload"},
    {"findCirclesGrid2", (PyCFunction)pyopencv_cv_findCirclesGrid2, METH_VARARGS | METH_KEYWORDS, "findCirclesGrid2(image, patternSize, flags, blobDetector, parameters[, centers]) -> retval, centers\n.   @overload"},
    {"findContours", (PyCFunction)pyopencv_cv_findContours, METH_VARARGS | METH_KEYWORDS, "findContours(image, mode, method[, contours[, hierarchy[, offset]]]) -> image, contours, hierarchy\n.   @brief Finds contours in a binary image.\n.   \n.   The function retrieves contours from the binary image using the algorithm @cite Suzuki85 . The contours\n.   are a useful tool for shape analysis and object detection and recognition. See squares.cpp in the\n.   OpenCV sample directory.\n.   @note Since opencv 3.2 source image is not modified by this function.\n.   \n.   @param image Source, an 8-bit single-channel image. Non-zero pixels are treated as 1's. Zero\n.   pixels remain 0's, so the image is treated as binary . You can use #compare, #inRange, #threshold ,\n.   #adaptiveThreshold, #Canny, and others to create a binary image out of a grayscale or color one.\n.   If mode equals to #RETR_CCOMP or #RETR_FLOODFILL, the input can also be a 32-bit integer image of labels (CV_32SC1).\n.   @param contours Detected contours. Each contour is stored as a vector of points (e.g.\n.   std::vector<std::vector<cv::Point> >).\n.   @param hierarchy Optional output vector (e.g. std::vector<cv::Vec4i>), containing information about the image topology. It has\n.   as many elements as the number of contours. For each i-th contour contours[i], the elements\n.   hierarchy[i][0] , hierarchy[i][1] , hierarchy[i][2] , and hierarchy[i][3] are set to 0-based indices\n.   in contours of the next and previous contours at the same hierarchical level, the first child\n.   contour and the parent contour, respectively. If for the contour i there are no next, previous,\n.   parent, or nested contours, the corresponding elements of hierarchy[i] will be negative.\n.   @param mode Contour retrieval mode, see #RetrievalModes\n.   @param method Contour approximation method, see #ContourApproximationModes\n.   @param offset Optional offset by which every contour point is shifted. This is useful if the\n.   contours are extracted from the image ROI and then they should be analyzed in the whole image\n.   context."},
    {"findEssentialMat", (PyCFunction)pyopencv_cv_findEssentialMat, METH_VARARGS | METH_KEYWORDS, "findEssentialMat(points1, points2, cameraMatrix[, method[, prob[, threshold[, mask]]]]) -> retval, mask\n.   @brief Calculates an essential matrix from the corresponding points in two images.\n.   \n.   @param points1 Array of N (N \\>= 5) 2D points from the first image. The point coordinates should\n.   be floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param cameraMatrix Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera matrix.\n.   @param method Method for computing an essential matrix.\n.   -   **RANSAC** for the RANSAC algorithm.\n.   -   **LMEDS** for the LMedS algorithm.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param mask Output array of N elements, every element of which is set to 0 for outliers and to 1\n.   for the other points. The array is computed only in the RANSAC and LMedS methods.\n.   \n.   This function estimates essential matrix based on the five-point algorithm solver in @cite Nister03 .\n.   @cite SteweniusCFS is also a related. The epipolar geometry is described by the following equation:\n.   \n.   \\f[[p_2; 1]^T K^{-T} E K^{-1} [p_1; 1] = 0\\f]\n.   \n.   where \\f$E\\f$ is an essential matrix, \\f$p_1\\f$ and \\f$p_2\\f$ are corresponding points in the first and the\n.   second images, respectively. The result of this function may be passed further to\n.   decomposeEssentialMat or recoverPose to recover the relative pose between cameras.\n\n\n\nfindEssentialMat(points1, points2[, focal[, pp[, method[, prob[, threshold[, mask]]]]]]) -> retval, mask\n.   @overload\n.   @param points1 Array of N (N \\>= 5) 2D points from the first image. The point coordinates should\n.   be floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param focal focal length of the camera. Note that this function assumes that points1 and points2\n.   are feature points from cameras with same focal length and principal point.\n.   @param pp principal point of the camera.\n.   @param method Method for computing a fundamental matrix.\n.   -   **RANSAC** for the RANSAC algorithm.\n.   -   **LMEDS** for the LMedS algorithm.\n.   @param threshold Parameter used for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param prob Parameter used for the RANSAC or LMedS methods only. It specifies a desirable level of\n.   confidence (probability) that the estimated matrix is correct.\n.   @param mask Output array of N elements, every element of which is set to 0 for outliers and to 1\n.   for the other points. The array is computed only in the RANSAC and LMedS methods.\n.   \n.   This function differs from the one above that it computes camera matrix from focal length and\n.   principal point:\n.   \n.   \\f[K =\n.   \\begin{bmatrix}\n.   f & 0 & x_{pp}  \\\\\n.   0 & f & y_{pp}  \\\\\n.   0 & 0 & 1\n.   \\end{bmatrix}\\f]"},
    {"findFundamentalMat", (PyCFunction)pyopencv_cv_findFundamentalMat, METH_VARARGS | METH_KEYWORDS, "findFundamentalMat(points1, points2[, method[, ransacReprojThreshold[, confidence[, mask]]]]) -> retval, mask\n.   @brief Calculates a fundamental matrix from the corresponding points in two images.\n.   \n.   @param points1 Array of N points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param method Method for computing a fundamental matrix.\n.   -   **CV_FM_7POINT** for a 7-point algorithm. \\f$N = 7\\f$\n.   -   **CV_FM_8POINT** for an 8-point algorithm. \\f$N \\ge 8\\f$\n.   -   **CV_FM_RANSAC** for the RANSAC algorithm. \\f$N \\ge 8\\f$\n.   -   **CV_FM_LMEDS** for the LMedS algorithm. \\f$N \\ge 8\\f$\n.   @param ransacReprojThreshold Parameter used only for RANSAC. It is the maximum distance from a point to an epipolar\n.   line in pixels, beyond which the point is considered an outlier and is not used for computing the\n.   final fundamental matrix. It can be set to something like 1-3, depending on the accuracy of the\n.   point localization, image resolution, and the image noise.\n.   @param confidence Parameter used for the RANSAC and LMedS methods only. It specifies a desirable level\n.   of confidence (probability) that the estimated matrix is correct.\n.   @param mask\n.   \n.   The epipolar geometry is described by the following equation:\n.   \n.   \\f[[p_2; 1]^T F [p_1; 1] = 0\\f]\n.   \n.   where \\f$F\\f$ is a fundamental matrix, \\f$p_1\\f$ and \\f$p_2\\f$ are corresponding points in the first and the\n.   second images, respectively.\n.   \n.   The function calculates the fundamental matrix using one of four methods listed above and returns\n.   the found fundamental matrix. Normally just one matrix is found. But in case of the 7-point\n.   algorithm, the function may return up to 3 solutions ( \\f$9 \\times 3\\f$ matrix that stores all 3\n.   matrices sequentially).\n.   \n.   The calculated fundamental matrix may be passed further to computeCorrespondEpilines that finds the\n.   epipolar lines corresponding to the specified points. It can also be passed to\n.   stereoRectifyUncalibrated to compute the rectification transformation. :\n.   @code\n.   // Example. Estimation of fundamental matrix using the RANSAC algorithm\n.   int point_count = 100;\n.   vector<Point2f> points1(point_count);\n.   vector<Point2f> points2(point_count);\n.   \n.   // initialize the points here ...\n.   for( int i = 0; i < point_count; i++ )\n.   {\n.   points1[i] = ...;\n.   points2[i] = ...;\n.   }\n.   \n.   Mat fundamental_matrix =\n.   findFundamentalMat(points1, points2, FM_RANSAC, 3, 0.99);\n.   @endcode"},
    {"findHomography", (PyCFunction)pyopencv_cv_findHomography, METH_VARARGS | METH_KEYWORDS, "findHomography(srcPoints, dstPoints[, method[, ransacReprojThreshold[, mask[, maxIters[, confidence]]]]]) -> retval, mask\n.   @brief Finds a perspective transformation between two planes.\n.   \n.   @param srcPoints Coordinates of the points in the original plane, a matrix of the type CV_32FC2\n.   or vector\\<Point2f\\> .\n.   @param dstPoints Coordinates of the points in the target plane, a matrix of the type CV_32FC2 or\n.   a vector\\<Point2f\\> .\n.   @param method Method used to compute a homography matrix. The following methods are possible:\n.   -   **0** - a regular method using all the points, i.e., the least squares method\n.   -   **RANSAC** - RANSAC-based robust method\n.   -   **LMEDS** - Least-Median robust method\n.   -   **RHO** - PROSAC-based robust method\n.   @param ransacReprojThreshold Maximum allowed reprojection error to treat a point pair as an inlier\n.   (used in the RANSAC and RHO methods only). That is, if\n.   \\f[\\| \\texttt{dstPoints} _i -  \\texttt{convertPointsHomogeneous} ( \\texttt{H} * \\texttt{srcPoints} _i) \\|_2  >  \\texttt{ransacReprojThreshold}\\f]\n.   then the point \\f$i\\f$ is considered as an outlier. If srcPoints and dstPoints are measured in pixels,\n.   it usually makes sense to set this parameter somewhere in the range of 1 to 10.\n.   @param mask Optional output mask set by a robust method ( RANSAC or LMEDS ). Note that the input\n.   mask values are ignored.\n.   @param maxIters The maximum number of RANSAC iterations.\n.   @param confidence Confidence level, between 0 and 1.\n.   \n.   The function finds and returns the perspective transformation \\f$H\\f$ between the source and the\n.   destination planes:\n.   \n.   \\f[s_i  \\vecthree{x'_i}{y'_i}{1} \\sim H  \\vecthree{x_i}{y_i}{1}\\f]\n.   \n.   so that the back-projection error\n.   \n.   \\f[\\sum _i \\left ( x'_i- \\frac{h_{11} x_i + h_{12} y_i + h_{13}}{h_{31} x_i + h_{32} y_i + h_{33}} \\right )^2+ \\left ( y'_i- \\frac{h_{21} x_i + h_{22} y_i + h_{23}}{h_{31} x_i + h_{32} y_i + h_{33}} \\right )^2\\f]\n.   \n.   is minimized. If the parameter method is set to the default value 0, the function uses all the point\n.   pairs to compute an initial homography estimate with a simple least-squares scheme.\n.   \n.   However, if not all of the point pairs ( \\f$srcPoints_i\\f$, \\f$dstPoints_i\\f$ ) fit the rigid perspective\n.   transformation (that is, there are some outliers), this initial estimate will be poor. In this case,\n.   you can use one of the three robust methods. The methods RANSAC, LMeDS and RHO try many different\n.   random subsets of the corresponding point pairs (of four pairs each, collinear pairs are discarded), estimate the homography matrix\n.   using this subset and a simple least-squares algorithm, and then compute the quality/goodness of the\n.   computed homography (which is the number of inliers for RANSAC or the least median re-projection error for\n.   LMeDS). The best subset is then used to produce the initial estimate of the homography matrix and\n.   the mask of inliers/outliers.\n.   \n.   Regardless of the method, robust or not, the computed homography matrix is refined further (using\n.   inliers only in case of a robust method) with the Levenberg-Marquardt method to reduce the\n.   re-projection error even more.\n.   \n.   The methods RANSAC and RHO can handle practically any ratio of outliers but need a threshold to\n.   distinguish inliers from outliers. The method LMeDS does not need any threshold but it works\n.   correctly only when there are more than 50% of inliers. Finally, if there are no outliers and the\n.   noise is rather small, use the default method (method=0).\n.   \n.   The function is used to find initial intrinsic and extrinsic matrices. Homography matrix is\n.   determined up to a scale. Thus, it is normalized so that \\f$h_{33}=1\\f$. Note that whenever an \\f$H\\f$ matrix\n.   cannot be estimated, an empty one will be returned.\n.   \n.   @sa\n.   getAffineTransform, estimateAffine2D, estimateAffinePartial2D, getPerspectiveTransform, warpPerspective,\n.   perspectiveTransform"},
    {"findNonZero", (PyCFunction)pyopencv_cv_findNonZero, METH_VARARGS | METH_KEYWORDS, "findNonZero(src[, idx]) -> idx\n.   @brief Returns the list of locations of non-zero pixels\n.   \n.   Given a binary matrix (likely returned from an operation such\n.   as threshold(), compare(), >, ==, etc, return all of\n.   the non-zero indices as a cv::Mat or std::vector<cv::Point> (x,y)\n.   For example:\n.   @code{.cpp}\n.   cv::Mat binaryImage; // input, binary image\n.   cv::Mat locations;   // output, locations of non-zero pixels\n.   cv::findNonZero(binaryImage, locations);\n.   \n.   // access pixel coordinates\n.   Point pnt = locations.at<Point>(i);\n.   @endcode\n.   or\n.   @code{.cpp}\n.   cv::Mat binaryImage; // input, binary image\n.   vector<Point> locations;   // output, locations of non-zero pixels\n.   cv::findNonZero(binaryImage, locations);\n.   \n.   // access pixel coordinates\n.   Point pnt = locations[i];\n.   @endcode\n.   @param src single-channel array (type CV_8UC1)\n.   @param idx the output array, type of cv::Mat or std::vector<Point>, corresponding to non-zero indices in the input"},
    {"findTransformECC", (PyCFunction)pyopencv_cv_findTransformECC, METH_VARARGS | METH_KEYWORDS, "findTransformECC(templateImage, inputImage, warpMatrix[, motionType[, criteria[, inputMask]]]) -> retval, warpMatrix\n.   @brief Finds the geometric transform (warp) between two images in terms of the ECC criterion @cite EP08 .\n.   \n.   @param templateImage single-channel template image; CV_8U or CV_32F array.\n.   @param inputImage single-channel input image which should be warped with the final warpMatrix in\n.   order to provide an image similar to templateImage, same type as temlateImage.\n.   @param warpMatrix floating-point \\f$2\\times 3\\f$ or \\f$3\\times 3\\f$ mapping matrix (warp).\n.   @param motionType parameter, specifying the type of motion:\n.   -   **MOTION_TRANSLATION** sets a translational motion model; warpMatrix is \\f$2\\times 3\\f$ with\n.   the first \\f$2\\times 2\\f$ part being the unity matrix and the rest two parameters being\n.   estimated.\n.   -   **MOTION_EUCLIDEAN** sets a Euclidean (rigid) transformation as motion model; three\n.   parameters are estimated; warpMatrix is \\f$2\\times 3\\f$.\n.   -   **MOTION_AFFINE** sets an affine motion model (DEFAULT); six parameters are estimated;\n.   warpMatrix is \\f$2\\times 3\\f$.\n.   -   **MOTION_HOMOGRAPHY** sets a homography as a motion model; eight parameters are\n.   estimated;\\`warpMatrix\\` is \\f$3\\times 3\\f$.\n.   @param criteria parameter, specifying the termination criteria of the ECC algorithm;\n.   criteria.epsilon defines the threshold of the increment in the correlation coefficient between two\n.   iterations (a negative criteria.epsilon makes criteria.maxcount the only termination criterion).\n.   Default values are shown in the declaration above.\n.   @param inputMask An optional mask to indicate valid values of inputImage.\n.   \n.   The function estimates the optimum transformation (warpMatrix) with respect to ECC criterion\n.   (@cite EP08), that is\n.   \n.   \\f[\\texttt{warpMatrix} = \\texttt{warpMatrix} = \\arg\\max_{W} \\texttt{ECC}(\\texttt{templateImage}(x,y),\\texttt{inputImage}(x',y'))\\f]\n.   \n.   where\n.   \n.   \\f[\\begin{bmatrix} x' \\\\ y' \\end{bmatrix} = W \\cdot \\begin{bmatrix} x \\\\ y \\\\ 1 \\end{bmatrix}\\f]\n.   \n.   (the equation holds with homogeneous coordinates for homography). It returns the final enhanced\n.   correlation coefficient, that is the correlation coefficient between the template image and the\n.   final warped input image. When a \\f$3\\times 3\\f$ matrix is given with motionType =0, 1 or 2, the third\n.   row is ignored.\n.   \n.   Unlike findHomography and estimateRigidTransform, the function findTransformECC implements an\n.   area-based alignment that builds on intensity similarities. In essence, the function updates the\n.   initial transformation that roughly aligns the images. If this information is missing, the identity\n.   warp (unity matrix) is used as an initialization. Note that if images undergo strong\n.   displacements/rotations, an initial transformation that roughly aligns the images is necessary\n.   (e.g., a simple euclidean/similarity transform that allows for the images showing the same image\n.   content approximately). Use inverse warping in the second image to take an image close to the first\n.   one, i.e. use the flag WARP_INVERSE_MAP with warpAffine or warpPerspective. See also the OpenCV\n.   sample image_alignment.cpp that demonstrates the use of the function. Note that the function throws\n.   an exception if algorithm does not converges.\n.   \n.   @sa\n.   estimateAffine2D, estimateAffinePartial2D, findHomography"},
    {"fitEllipse", (PyCFunction)pyopencv_cv_fitEllipse, METH_VARARGS | METH_KEYWORDS, "fitEllipse(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.   The function calculates the ellipse that fits (in a least-squares sense) a set of 2D points best of\n.   all. It returns the rotated rectangle in which the ellipse is inscribed. The first algorithm described by @cite Fitzgibbon95\n.   is used. Developer should keep in mind that it is possible that the returned\n.   ellipse/rotatedRect data contains negative indices, due to the data points being close to the\n.   border of the containing Mat element.\n.   \n.   @param points Input 2D point set, stored in std::vector\\<\\> or Mat"},
    {"fitEllipseAMS", (PyCFunction)pyopencv_cv_fitEllipseAMS, METH_VARARGS | METH_KEYWORDS, "fitEllipseAMS(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.   The function calculates the ellipse that fits a set of 2D points.\n.   It returns the rotated rectangle in which the ellipse is inscribed.\n.   The Approximate Mean Square (AMS) proposed by @cite Taubin1991 is used.\n.   \n.   For an ellipse, this basis set is \\f$ \\chi= \\left(x^2, x y, y^2, x, y, 1\\right) \\f$,\n.   which is a set of six free coefficients \\f$ A^T=\\left\\{A_{\\text{xx}},A_{\\text{xy}},A_{\\text{yy}},A_x,A_y,A_0\\right\\} \\f$.\n.   However, to specify an ellipse, all that is needed is five numbers; the major and minor axes lengths \\f$ (a,b) \\f$,\n.   the position \\f$ (x_0,y_0) \\f$, and the orientation \\f$ \\theta \\f$. This is because the basis set includes lines,\n.   quadratics, parabolic and hyperbolic functions as well as elliptical functions as possible fits.\n.   If the fit is found to be a parabolic or hyperbolic function then the standard #fitEllipse method is used.\n.   The AMS method restricts the fit to parabolic, hyperbolic and elliptical curves\n.   by imposing the condition that \\f$ A^T ( D_x^T D_x  +   D_y^T D_y) A = 1 \\f$ where\n.   the matrices \\f$ Dx \\f$ and \\f$ Dy \\f$ are the partial derivatives of the design matrix \\f$ D \\f$ with\n.   respect to x and y. The matrices are formed row by row applying the following to\n.   each of the points in the set:\n.   \\f{align*}{\n.   D(i,:)&=\\left\\{x_i^2, x_i y_i, y_i^2, x_i, y_i, 1\\right\\} &\n.   D_x(i,:)&=\\left\\{2 x_i,y_i,0,1,0,0\\right\\} &\n.   D_y(i,:)&=\\left\\{0,x_i,2 y_i,0,1,0\\right\\}\n.   \\f}\n.   The AMS method minimizes the cost function\n.   \\f{equation*}{\n.   \\epsilon ^2=\\frac{ A^T D^T D A }{ A^T (D_x^T D_x +  D_y^T D_y) A^T }\n.   \\f}\n.   \n.   The minimum cost is found by solving the generalized eigenvalue problem.\n.   \n.   \\f{equation*}{\n.   D^T D A = \\lambda  \\left( D_x^T D_x +  D_y^T D_y\\right) A\n.   \\f}\n.   \n.   @param points Input 2D point set, stored in std::vector\\<\\> or Mat"},
    {"fitEllipseDirect", (PyCFunction)pyopencv_cv_fitEllipseDirect, METH_VARARGS | METH_KEYWORDS, "fitEllipseDirect(points) -> retval\n.   @brief Fits an ellipse around a set of 2D points.\n.   \n.   The function calculates the ellipse that fits a set of 2D points.\n.   It returns the rotated rectangle in which the ellipse is inscribed.\n.   The Direct least square (Direct) method by @cite Fitzgibbon1999 is used.\n.   \n.   For an ellipse, this basis set is \\f$ \\chi= \\left(x^2, x y, y^2, x, y, 1\\right) \\f$,\n.   which is a set of six free coefficients \\f$ A^T=\\left\\{A_{\\text{xx}},A_{\\text{xy}},A_{\\text{yy}},A_x,A_y,A_0\\right\\} \\f$.\n.   However, to specify an ellipse, all that is needed is five numbers; the major and minor axes lengths \\f$ (a,b) \\f$,\n.   the position \\f$ (x_0,y_0) \\f$, and the orientation \\f$ \\theta \\f$. This is because the basis set includes lines,\n.   quadratics, parabolic and hyperbolic functions as well as elliptical functions as possible fits.\n.   The Direct method confines the fit to ellipses by ensuring that \\f$ 4 A_{xx} A_{yy}- A_{xy}^2 > 0 \\f$.\n.   The condition imposed is that \\f$ 4 A_{xx} A_{yy}- A_{xy}^2=1 \\f$ which satisfies the inequality\n.   and as the coefficients can be arbitrarily scaled is not overly restrictive.\n.   \n.   \\f{equation*}{\n.   \\epsilon ^2= A^T D^T D A \\quad \\text{with} \\quad A^T C A =1 \\quad \\text{and} \\quad C=\\left(\\begin{matrix}\n.   0 & 0  & 2  & 0  & 0  &  0  \\\\\n.   0 & -1  & 0  & 0  & 0  &  0 \\\\\n.   2 & 0  & 0  & 0  & 0  &  0 \\\\\n.   0 & 0  & 0  & 0  & 0  &  0 \\\\\n.   0 & 0  & 0  & 0  & 0  &  0 \\\\\n.   0 & 0  & 0  & 0  & 0  &  0\n.   \\end{matrix} \\right)\n.   \\f}\n.   \n.   The minimum cost is found by solving the generalized eigenvalue problem.\n.   \n.   \\f{equation*}{\n.   D^T D A = \\lambda  \\left( C\\right) A\n.   \\f}\n.   \n.   The system produces only one positive eigenvalue \\f$ \\lambda\\f$ which is chosen as the solution\n.   with its eigenvector \\f$\\mathbf{u}\\f$. These are used to find the coefficients\n.   \n.   \\f{equation*}{\n.   A = \\sqrt{\\frac{1}{\\mathbf{u}^T C \\mathbf{u}}}  \\mathbf{u}\n.   \\f}\n.   The scaling factor guarantees that  \\f$A^T C A =1\\f$.\n.   \n.   @param points Input 2D point set, stored in std::vector\\<\\> or Mat"},
    {"fitLine", (PyCFunction)pyopencv_cv_fitLine, METH_VARARGS | METH_KEYWORDS, "fitLine(points, distType, param, reps, aeps[, line]) -> line\n.   @brief Fits a line to a 2D or 3D point set.\n.   \n.   The function fitLine fits a line to a 2D or 3D point set by minimizing \\f$\\sum_i \\rho(r_i)\\f$ where\n.   \\f$r_i\\f$ is a distance between the \\f$i^{th}\\f$ point, the line and \\f$\\rho(r)\\f$ is a distance function, one\n.   of the following:\n.   -  DIST_L2\n.   \\f[\\rho (r) = r^2/2  \\quad \\text{(the simplest and the fastest least-squares method)}\\f]\n.   - DIST_L1\n.   \\f[\\rho (r) = r\\f]\n.   - DIST_L12\n.   \\f[\\rho (r) = 2  \\cdot ( \\sqrt{1 + \\frac{r^2}{2}} - 1)\\f]\n.   - DIST_FAIR\n.   \\f[\\rho \\left (r \\right ) = C^2  \\cdot \\left (  \\frac{r}{C} -  \\log{\\left(1 + \\frac{r}{C}\\right)} \\right )  \\quad \\text{where} \\quad C=1.3998\\f]\n.   - DIST_WELSCH\n.   \\f[\\rho \\left (r \\right ) =  \\frac{C^2}{2} \\cdot \\left ( 1 -  \\exp{\\left(-\\left(\\frac{r}{C}\\right)^2\\right)} \\right )  \\quad \\text{where} \\quad C=2.9846\\f]\n.   - DIST_HUBER\n.   \\f[\\rho (r) =  \\fork{r^2/2}{if \\(r < C\\)}{C \\cdot (r-C/2)}{otherwise} \\quad \\text{where} \\quad C=1.345\\f]\n.   \n.   The algorithm is based on the M-estimator ( <http://en.wikipedia.org/wiki/M-estimator> ) technique\n.   that iteratively fits the line using the weighted least-squares algorithm. After each iteration the\n.   weights \\f$w_i\\f$ are adjusted to be inversely proportional to \\f$\\rho(r_i)\\f$ .\n.   \n.   @param points Input vector of 2D or 3D points, stored in std::vector\\<\\> or Mat.\n.   @param line Output line parameters. In case of 2D fitting, it should be a vector of 4 elements\n.   (like Vec4f) - (vx, vy, x0, y0), where (vx, vy) is a normalized vector collinear to the line and\n.   (x0, y0) is a point on the line. In case of 3D fitting, it should be a vector of 6 elements (like\n.   Vec6f) - (vx, vy, vz, x0, y0, z0), where (vx, vy, vz) is a normalized vector collinear to the line\n.   and (x0, y0, z0) is a point on the line.\n.   @param distType Distance used by the M-estimator, see #DistanceTypes\n.   @param param Numerical parameter ( C ) for some types of distances. If it is 0, an optimal value\n.   is chosen.\n.   @param reps Sufficient accuracy for the radius (distance between the coordinate origin and the line).\n.   @param aeps Sufficient accuracy for the angle. 0.01 would be a good default value for reps and aeps."},
    {"flip", (PyCFunction)pyopencv_cv_flip, METH_VARARGS | METH_KEYWORDS, "flip(src, flipCode[, dst]) -> dst\n.   @brief Flips a 2D array around vertical, horizontal, or both axes.\n.   \n.   The function cv::flip flips the array in one of three different ways (row\n.   and column indices are 0-based):\n.   \\f[\\texttt{dst} _{ij} =\n.   \\left\\{\n.   \\begin{array}{l l}\n.   \\texttt{src} _{\\texttt{src.rows}-i-1,j} & if\\;  \\texttt{flipCode} = 0 \\\\\n.   \\texttt{src} _{i, \\texttt{src.cols} -j-1} & if\\;  \\texttt{flipCode} > 0 \\\\\n.   \\texttt{src} _{ \\texttt{src.rows} -i-1, \\texttt{src.cols} -j-1} & if\\; \\texttt{flipCode} < 0 \\\\\n.   \\end{array}\n.   \\right.\\f]\n.   The example scenarios of using the function are the following:\n.   *   Vertical flipping of the image (flipCode == 0) to switch between\n.   top-left and bottom-left image origin. This is a typical operation\n.   in video processing on Microsoft Windows\\* OS.\n.   *   Horizontal flipping of the image with the subsequent horizontal\n.   shift and absolute difference calculation to check for a\n.   vertical-axis symmetry (flipCode \\> 0).\n.   *   Simultaneous horizontal and vertical flipping of the image with\n.   the subsequent shift and absolute difference calculation to check\n.   for a central symmetry (flipCode \\< 0).\n.   *   Reversing the order of point arrays (flipCode \\> 0 or\n.   flipCode == 0).\n.   @param src input array.\n.   @param dst output array of the same size and type as src.\n.   @param flipCode a flag to specify how to flip the array; 0 means\n.   flipping around the x-axis and positive value (for example, 1) means\n.   flipping around y-axis. Negative value (for example, -1) means flipping\n.   around both axes.\n.   @sa transpose , repeat , completeSymm"},
    {"floodFill", (PyCFunction)pyopencv_cv_floodFill, METH_VARARGS | METH_KEYWORDS, "floodFill(image, mask, seedPoint, newVal[, loDiff[, upDiff[, flags]]]) -> retval, image, mask, rect\n.   @brief Fills a connected component with the given color.\n.   \n.   The function cv::floodFill fills a connected component starting from the seed point with the specified\n.   color. The connectivity is determined by the color/brightness closeness of the neighbor pixels. The\n.   pixel at \\f$(x,y)\\f$ is considered to belong to the repainted domain if:\n.   \n.   - in case of a grayscale image and floating range\n.   \\f[\\texttt{src} (x',y')- \\texttt{loDiff} \\leq \\texttt{src} (x,y)  \\leq \\texttt{src} (x',y')+ \\texttt{upDiff}\\f]\n.   \n.   \n.   - in case of a grayscale image and fixed range\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)- \\texttt{loDiff} \\leq \\texttt{src} (x,y)  \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)+ \\texttt{upDiff}\\f]\n.   \n.   \n.   - in case of a color image and floating range\n.   \\f[\\texttt{src} (x',y')_r- \\texttt{loDiff} _r \\leq \\texttt{src} (x,y)_r \\leq \\texttt{src} (x',y')_r+ \\texttt{upDiff} _r,\\f]\n.   \\f[\\texttt{src} (x',y')_g- \\texttt{loDiff} _g \\leq \\texttt{src} (x,y)_g \\leq \\texttt{src} (x',y')_g+ \\texttt{upDiff} _g\\f]\n.   and\n.   \\f[\\texttt{src} (x',y')_b- \\texttt{loDiff} _b \\leq \\texttt{src} (x,y)_b \\leq \\texttt{src} (x',y')_b+ \\texttt{upDiff} _b\\f]\n.   \n.   \n.   - in case of a color image and fixed range\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_r- \\texttt{loDiff} _r \\leq \\texttt{src} (x,y)_r \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_r+ \\texttt{upDiff} _r,\\f]\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_g- \\texttt{loDiff} _g \\leq \\texttt{src} (x,y)_g \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_g+ \\texttt{upDiff} _g\\f]\n.   and\n.   \\f[\\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_b- \\texttt{loDiff} _b \\leq \\texttt{src} (x,y)_b \\leq \\texttt{src} ( \\texttt{seedPoint} .x, \\texttt{seedPoint} .y)_b+ \\texttt{upDiff} _b\\f]\n.   \n.   \n.   where \\f$src(x',y')\\f$ is the value of one of pixel neighbors that is already known to belong to the\n.   component. That is, to be added to the connected component, a color/brightness of the pixel should\n.   be close enough to:\n.   - Color/brightness of one of its neighbors that already belong to the connected component in case\n.   of a floating range.\n.   - Color/brightness of the seed point in case of a fixed range.\n.   \n.   Use these functions to either mark a connected component with the specified color in-place, or build\n.   a mask and then extract the contour, or copy the region to another image, and so on.\n.   \n.   @param image Input/output 1- or 3-channel, 8-bit, or floating-point image. It is modified by the\n.   function unless the #FLOODFILL_MASK_ONLY flag is set in the second variant of the function. See\n.   the details below.\n.   @param mask Operation mask that should be a single-channel 8-bit image, 2 pixels wider and 2 pixels\n.   taller than image. Since this is both an input and output parameter, you must take responsibility\n.   of initializing it. Flood-filling cannot go across non-zero pixels in the input mask. For example,\n.   an edge detector output can be used as a mask to stop filling at edges. On output, pixels in the\n.   mask corresponding to filled pixels in the image are set to 1 or to the a value specified in flags\n.   as described below. Additionally, the function fills the border of the mask with ones to simplify\n.   internal processing. It is therefore possible to use the same mask in multiple calls to the function\n.   to make sure the filled areas do not overlap.\n.   @param seedPoint Starting point.\n.   @param newVal New value of the repainted domain pixels.\n.   @param loDiff Maximal lower brightness/color difference between the currently observed pixel and\n.   one of its neighbors belonging to the component, or a seed pixel being added to the component.\n.   @param upDiff Maximal upper brightness/color difference between the currently observed pixel and\n.   one of its neighbors belonging to the component, or a seed pixel being added to the component.\n.   @param rect Optional output parameter set by the function to the minimum bounding rectangle of the\n.   repainted domain.\n.   @param flags Operation flags. The first 8 bits contain a connectivity value. The default value of\n.   4 means that only the four nearest neighbor pixels (those that share an edge) are considered. A\n.   connectivity value of 8 means that the eight nearest neighbor pixels (those that share a corner)\n.   will be considered. The next 8 bits (8-16) contain a value between 1 and 255 with which to fill\n.   the mask (the default value is 1). For example, 4 | ( 255 \\<\\< 8 ) will consider 4 nearest\n.   neighbours and fill the mask with a value of 255. The following additional options occupy higher\n.   bits and therefore may be further combined with the connectivity and mask fill values using\n.   bit-wise or (|), see #FloodFillFlags.\n.   \n.   @note Since the mask is larger than the filled image, a pixel \\f$(x, y)\\f$ in image corresponds to the\n.   pixel \\f$(x+1, y+1)\\f$ in the mask .\n.   \n.   @sa findContours"},
    {"gemm", (PyCFunction)pyopencv_cv_gemm, METH_VARARGS | METH_KEYWORDS, "gemm(src1, src2, alpha, src3, beta[, dst[, flags]]) -> dst\n.   @brief Performs generalized matrix multiplication.\n.   \n.   The function cv::gemm performs generalized matrix multiplication similar to the\n.   gemm functions in BLAS level 3. For example,\n.   `gemm(src1, src2, alpha, src3, beta, dst, GEMM_1_T + GEMM_3_T)`\n.   corresponds to\n.   \\f[\\texttt{dst} =  \\texttt{alpha} \\cdot \\texttt{src1} ^T  \\cdot \\texttt{src2} +  \\texttt{beta} \\cdot \\texttt{src3} ^T\\f]\n.   \n.   In case of complex (two-channel) data, performed a complex matrix\n.   multiplication.\n.   \n.   The function can be replaced with a matrix expression. For example, the\n.   above call can be replaced with:\n.   @code{.cpp}\n.   dst = alpha*src1.t()*src2 + beta*src3.t();\n.   @endcode\n.   @param src1 first multiplied input matrix that could be real(CV_32FC1,\n.   CV_64FC1) or complex(CV_32FC2, CV_64FC2).\n.   @param src2 second multiplied input matrix of the same type as src1.\n.   @param alpha weight of the matrix product.\n.   @param src3 third optional delta matrix added to the matrix product; it\n.   should have the same type as src1 and src2.\n.   @param beta weight of src3.\n.   @param dst output matrix; it has the proper size and the same type as\n.   input matrices.\n.   @param flags operation flags (cv::GemmFlags)\n.   @sa mulTransposed , transform"},
    {"getAffineTransform", (PyCFunction)pyopencv_cv_getAffineTransform, METH_VARARGS | METH_KEYWORDS, "getAffineTransform(src, dst) -> retval\n."},
    {"getBuildInformation", (PyCFunction)pyopencv_cv_getBuildInformation, METH_VARARGS | METH_KEYWORDS, "getBuildInformation() -> retval\n.   @brief Returns full configuration time cmake output.\n.   \n.   Returned value is raw cmake output including version control system revision, compiler version,\n.   compiler flags, enabled modules and third party libraries, etc. Output format depends on target\n.   architecture."},
    {"getCPUTickCount", (PyCFunction)pyopencv_cv_getCPUTickCount, METH_VARARGS | METH_KEYWORDS, "getCPUTickCount() -> retval\n.   @brief Returns the number of CPU ticks.\n.   \n.   The function returns the current number of CPU ticks on some architectures (such as x86, x64,\n.   PowerPC). On other platforms the function is equivalent to getTickCount. It can also be used for\n.   very accurate time measurements, as well as for RNG initialization. Note that in case of multi-CPU\n.   systems a thread, from which getCPUTickCount is called, can be suspended and resumed at another CPU\n.   with its own counter. So, theoretically (and practically) the subsequent calls to the function do\n.   not necessary return the monotonously increasing values. Also, since a modern CPU varies the CPU\n.   frequency depending on the load, the number of CPU clocks spent in some code cannot be directly\n.   converted to time units. Therefore, getTickCount is generally a preferable solution for measuring\n.   execution time."},
    {"getDefaultNewCameraMatrix", (PyCFunction)pyopencv_cv_getDefaultNewCameraMatrix, METH_VARARGS | METH_KEYWORDS, "getDefaultNewCameraMatrix(cameraMatrix[, imgsize[, centerPrincipalPoint]]) -> retval\n.   @brief Returns the default new camera matrix.\n.   \n.   The function returns the camera matrix that is either an exact copy of the input cameraMatrix (when\n.   centerPrinicipalPoint=false ), or the modified one (when centerPrincipalPoint=true).\n.   \n.   In the latter case, the new camera matrix will be:\n.   \n.   \\f[\\begin{bmatrix} f_x && 0 && ( \\texttt{imgSize.width} -1)*0.5  \\\\ 0 && f_y && ( \\texttt{imgSize.height} -1)*0.5  \\\\ 0 && 0 && 1 \\end{bmatrix} ,\\f]\n.   \n.   where \\f$f_x\\f$ and \\f$f_y\\f$ are \\f$(0,0)\\f$ and \\f$(1,1)\\f$ elements of cameraMatrix, respectively.\n.   \n.   By default, the undistortion functions in OpenCV (see #initUndistortRectifyMap, #undistort) do not\n.   move the principal point. However, when you work with stereo, it is important to move the principal\n.   points in both views to the same y-coordinate (which is required by most of stereo correspondence\n.   algorithms), and may be to the same x-coordinate too. So, you can form the new camera matrix for\n.   each view where the principal points are located at the center.\n.   \n.   @param cameraMatrix Input camera matrix.\n.   @param imgsize Camera view image size in pixels.\n.   @param centerPrincipalPoint Location of the principal point in the new camera matrix. The\n.   parameter indicates whether this location should be at the image center or not."},
    {"getDerivKernels", (PyCFunction)pyopencv_cv_getDerivKernels, METH_VARARGS | METH_KEYWORDS, "getDerivKernels(dx, dy, ksize[, kx[, ky[, normalize[, ktype]]]]) -> kx, ky\n.   @brief Returns filter coefficients for computing spatial image derivatives.\n.   \n.   The function computes and returns the filter coefficients for spatial image derivatives. When\n.   `ksize=CV_SCHARR`, the Scharr \\f$3 \\times 3\\f$ kernels are generated (see #Scharr). Otherwise, Sobel\n.   kernels are generated (see #Sobel). The filters are normally passed to #sepFilter2D or to\n.   \n.   @param kx Output matrix of row filter coefficients. It has the type ktype .\n.   @param ky Output matrix of column filter coefficients. It has the type ktype .\n.   @param dx Derivative order in respect of x.\n.   @param dy Derivative order in respect of y.\n.   @param ksize Aperture size. It can be CV_SCHARR, 1, 3, 5, or 7.\n.   @param normalize Flag indicating whether to normalize (scale down) the filter coefficients or not.\n.   Theoretically, the coefficients should have the denominator \\f$=2^{ksize*2-dx-dy-2}\\f$. If you are\n.   going to filter floating-point images, you are likely to use the normalized kernels. But if you\n.   compute derivatives of an 8-bit image, store the results in a 16-bit image, and wish to preserve\n.   all the fractional bits, you may want to set normalize=false .\n.   @param ktype Type of filter coefficients. It can be CV_32f or CV_64F ."},
    {"getFontScaleFromHeight", (PyCFunction)pyopencv_cv_getFontScaleFromHeight, METH_VARARGS | METH_KEYWORDS, "getFontScaleFromHeight(fontFace, pixelHeight[, thickness]) -> retval\n.   @brief Calculates the font-specific size to use to achieve a given height in pixels.\n.   \n.   @param fontFace Font to use, see cv::HersheyFonts.\n.   @param pixelHeight Pixel height to compute the fontScale for\n.   @param thickness Thickness of lines used to render the text.See putText for details.\n.   @return The fontSize to use for cv::putText\n.   \n.   @see cv::putText"},
    {"getGaborKernel", (PyCFunction)pyopencv_cv_getGaborKernel, METH_VARARGS | METH_KEYWORDS, "getGaborKernel(ksize, sigma, theta, lambd, gamma[, psi[, ktype]]) -> retval\n.   @brief Returns Gabor filter coefficients.\n.   \n.   For more details about gabor filter equations and parameters, see: [Gabor\n.   Filter](http://en.wikipedia.org/wiki/Gabor_filter).\n.   \n.   @param ksize Size of the filter returned.\n.   @param sigma Standard deviation of the gaussian envelope.\n.   @param theta Orientation of the normal to the parallel stripes of a Gabor function.\n.   @param lambd Wavelength of the sinusoidal factor.\n.   @param gamma Spatial aspect ratio.\n.   @param psi Phase offset.\n.   @param ktype Type of filter coefficients. It can be CV_32F or CV_64F ."},
    {"getGaussianKernel", (PyCFunction)pyopencv_cv_getGaussianKernel, METH_VARARGS | METH_KEYWORDS, "getGaussianKernel(ksize, sigma[, ktype]) -> retval\n.   @brief Returns Gaussian filter coefficients.\n.   \n.   The function computes and returns the \\f$\\texttt{ksize} \\times 1\\f$ matrix of Gaussian filter\n.   coefficients:\n.   \n.   \\f[G_i= \\alpha *e^{-(i-( \\texttt{ksize} -1)/2)^2/(2* \\texttt{sigma}^2)},\\f]\n.   \n.   where \\f$i=0..\\texttt{ksize}-1\\f$ and \\f$\\alpha\\f$ is the scale factor chosen so that \\f$\\sum_i G_i=1\\f$.\n.   \n.   Two of such generated kernels can be passed to sepFilter2D. Those functions automatically recognize\n.   smoothing kernels (a symmetrical kernel with sum of weights equal to 1) and handle them accordingly.\n.   You may also use the higher-level GaussianBlur.\n.   @param ksize Aperture size. It should be odd ( \\f$\\texttt{ksize} \\mod 2 = 1\\f$ ) and positive.\n.   @param sigma Gaussian standard deviation. If it is non-positive, it is computed from ksize as\n.   `sigma = 0.3*((ksize-1)*0.5 - 1) + 0.8`.\n.   @param ktype Type of filter coefficients. It can be CV_32F or CV_64F .\n.   @sa  sepFilter2D, getDerivKernels, getStructuringElement, GaussianBlur"},
    {"getHardwareFeatureName", (PyCFunction)pyopencv_cv_getHardwareFeatureName, METH_VARARGS | METH_KEYWORDS, "getHardwareFeatureName(feature) -> retval\n.   @brief Returns feature name by ID\n.   \n.   Returns empty string if feature is not defined"},
    {"getNumThreads", (PyCFunction)pyopencv_cv_getNumThreads, METH_VARARGS | METH_KEYWORDS, "getNumThreads() -> retval\n.   @brief Returns the number of threads used by OpenCV for parallel regions.\n.   \n.   Always returns 1 if OpenCV is built without threading support.\n.   \n.   The exact meaning of return value depends on the threading framework used by OpenCV library:\n.   - `TBB` - The number of threads, that OpenCV will try to use for parallel regions. If there is\n.   any tbb::thread_scheduler_init in user code conflicting with OpenCV, then function returns\n.   default number of threads used by TBB library.\n.   - `OpenMP` - An upper bound on the number of threads that could be used to form a new team.\n.   - `Concurrency` - The number of threads, that OpenCV will try to use for parallel regions.\n.   - `GCD` - Unsupported; returns the GCD thread pool limit (512) for compatibility.\n.   - `C=` - The number of threads, that OpenCV will try to use for parallel regions, if before\n.   called setNumThreads with threads \\> 0, otherwise returns the number of logical CPUs,\n.   available for the process.\n.   @sa setNumThreads, getThreadNum"},
    {"getNumberOfCPUs", (PyCFunction)pyopencv_cv_getNumberOfCPUs, METH_VARARGS | METH_KEYWORDS, "getNumberOfCPUs() -> retval\n.   @brief Returns the number of logical CPUs available for the process."},
    {"getOptimalDFTSize", (PyCFunction)pyopencv_cv_getOptimalDFTSize, METH_VARARGS | METH_KEYWORDS, "getOptimalDFTSize(vecsize) -> retval\n.   @brief Returns the optimal DFT size for a given vector size.\n.   \n.   DFT performance is not a monotonic function of a vector size. Therefore, when you calculate\n.   convolution of two arrays or perform the spectral analysis of an array, it usually makes sense to\n.   pad the input data with zeros to get a bit larger array that can be transformed much faster than the\n.   original one. Arrays whose size is a power-of-two (2, 4, 8, 16, 32, ...) are the fastest to process.\n.   Though, the arrays whose size is a product of 2's, 3's, and 5's (for example, 300 = 5\\*5\\*3\\*2\\*2)\n.   are also processed quite efficiently.\n.   \n.   The function cv::getOptimalDFTSize returns the minimum number N that is greater than or equal to vecsize\n.   so that the DFT of a vector of size N can be processed efficiently. In the current implementation N\n.   = 2 ^p^ \\* 3 ^q^ \\* 5 ^r^ for some integer p, q, r.\n.   \n.   The function returns a negative number if vecsize is too large (very close to INT_MAX ).\n.   \n.   While the function cannot be used directly to estimate the optimal vector size for DCT transform\n.   (since the current DCT implementation supports only even-size vectors), it can be easily processed\n.   as getOptimalDFTSize((vecsize+1)/2)\\*2.\n.   @param vecsize vector size.\n.   @sa dft , dct , idft , idct , mulSpectrums"},
    {"getOptimalNewCameraMatrix", (PyCFunction)pyopencv_cv_getOptimalNewCameraMatrix, METH_VARARGS | METH_KEYWORDS, "getOptimalNewCameraMatrix(cameraMatrix, distCoeffs, imageSize, alpha[, newImgSize[, centerPrincipalPoint]]) -> retval, validPixROI\n.   @brief Returns the new camera matrix based on the free scaling parameter.\n.   \n.   @param cameraMatrix Input camera matrix.\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param imageSize Original image size.\n.   @param alpha Free scaling parameter between 0 (when all the pixels in the undistorted image are\n.   valid) and 1 (when all the source image pixels are retained in the undistorted image). See\n.   stereoRectify for details.\n.   @param newImgSize Image size after rectification. By default, it is set to imageSize .\n.   @param validPixROI Optional output rectangle that outlines all-good-pixels region in the\n.   undistorted image. See roi1, roi2 description in stereoRectify .\n.   @param centerPrincipalPoint Optional flag that indicates whether in the new camera matrix the\n.   principal point should be at the image center or not. By default, the principal point is chosen to\n.   best fit a subset of the source image (determined by alpha) to the corrected image.\n.   @return new_camera_matrix Output new camera matrix.\n.   \n.   The function computes and returns the optimal new camera matrix based on the free scaling parameter.\n.   By varying this parameter, you may retrieve only sensible pixels alpha=0 , keep all the original\n.   image pixels if there is valuable information in the corners alpha=1 , or get something in between.\n.   When alpha\\>0 , the undistorted result is likely to have some black pixels corresponding to\n.   \"virtual\" pixels outside of the captured distorted image. The original camera matrix, distortion\n.   coefficients, the computed new camera matrix, and newImageSize should be passed to\n.   initUndistortRectifyMap to produce the maps for remap ."},
    {"getPerspectiveTransform", (PyCFunction)pyopencv_cv_getPerspectiveTransform, METH_VARARGS | METH_KEYWORDS, "getPerspectiveTransform(src, dst) -> retval\n.   @brief Calculates a perspective transform from four pairs of the corresponding points.\n.   \n.   The function calculates the \\f$3 \\times 3\\f$ matrix of a perspective transform so that:\n.   \n.   \\f[\\begin{bmatrix} t_i x'_i \\\\ t_i y'_i \\\\ t_i \\end{bmatrix} = \\texttt{map_matrix} \\cdot \\begin{bmatrix} x_i \\\\ y_i \\\\ 1 \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[dst(i)=(x'_i,y'_i), src(i)=(x_i, y_i), i=0,1,2,3\\f]\n.   \n.   @param src Coordinates of quadrangle vertices in the source image.\n.   @param dst Coordinates of the corresponding quadrangle vertices in the destination image.\n.   \n.   @sa  findHomography, warpPerspective, perspectiveTransform"},
    {"getRectSubPix", (PyCFunction)pyopencv_cv_getRectSubPix, METH_VARARGS | METH_KEYWORDS, "getRectSubPix(image, patchSize, center[, patch[, patchType]]) -> patch\n.   @brief Retrieves a pixel rectangle from an image with sub-pixel accuracy.\n.   \n.   The function getRectSubPix extracts pixels from src:\n.   \n.   \\f[patch(x, y) = src(x +  \\texttt{center.x} - ( \\texttt{dst.cols} -1)*0.5, y +  \\texttt{center.y} - ( \\texttt{dst.rows} -1)*0.5)\\f]\n.   \n.   where the values of the pixels at non-integer coordinates are retrieved using bilinear\n.   interpolation. Every channel of multi-channel images is processed independently. Also\n.   the image should be a single channel or three channel image. While the center of the\n.   rectangle must be inside the image, parts of the rectangle may be outside.\n.   \n.   @param image Source image.\n.   @param patchSize Size of the extracted patch.\n.   @param center Floating point coordinates of the center of the extracted rectangle within the\n.   source image. The center must be inside the image.\n.   @param patch Extracted patch that has the size patchSize and the same number of channels as src .\n.   @param patchType Depth of the extracted pixels. By default, they have the same depth as src .\n.   \n.   @sa  warpAffine, warpPerspective"},
    {"getRotationMatrix2D", (PyCFunction)pyopencv_cv_getRotationMatrix2D, METH_VARARGS | METH_KEYWORDS, "getRotationMatrix2D(center, angle, scale) -> retval\n.   @brief Calculates an affine matrix of 2D rotation.\n.   \n.   The function calculates the following matrix:\n.   \n.   \\f[\\begin{bmatrix} \\alpha &  \\beta & (1- \\alpha )  \\cdot \\texttt{center.x} -  \\beta \\cdot \\texttt{center.y} \\\\ - \\beta &  \\alpha &  \\beta \\cdot \\texttt{center.x} + (1- \\alpha )  \\cdot \\texttt{center.y} \\end{bmatrix}\\f]\n.   \n.   where\n.   \n.   \\f[\\begin{array}{l} \\alpha =  \\texttt{scale} \\cdot \\cos \\texttt{angle} , \\\\ \\beta =  \\texttt{scale} \\cdot \\sin \\texttt{angle} \\end{array}\\f]\n.   \n.   The transformation maps the rotation center to itself. If this is not the target, adjust the shift.\n.   \n.   @param center Center of the rotation in the source image.\n.   @param angle Rotation angle in degrees. Positive values mean counter-clockwise rotation (the\n.   coordinate origin is assumed to be the top-left corner).\n.   @param scale Isotropic scale factor.\n.   \n.   @sa  getAffineTransform, warpAffine, transform"},
    {"getStructuringElement", (PyCFunction)pyopencv_cv_getStructuringElement, METH_VARARGS | METH_KEYWORDS, "getStructuringElement(shape, ksize[, anchor]) -> retval\n.   @brief Returns a structuring element of the specified size and shape for morphological operations.\n.   \n.   The function constructs and returns the structuring element that can be further passed to #erode,\n.   #dilate or #morphologyEx. But you can also construct an arbitrary binary mask yourself and use it as\n.   the structuring element.\n.   \n.   @param shape Element shape that could be one of #MorphShapes\n.   @param ksize Size of the structuring element.\n.   @param anchor Anchor position within the element. The default value \\f$(-1, -1)\\f$ means that the\n.   anchor is at the center. Note that only the shape of a cross-shaped element depends on the anchor\n.   position. In other cases the anchor just regulates how much the result of the morphological\n.   operation is shifted."},
    {"getTextSize", (PyCFunction)pyopencv_cv_getTextSize, METH_VARARGS | METH_KEYWORDS, "getTextSize(text, fontFace, fontScale, thickness) -> retval, baseLine\n.   @brief Calculates the width and height of a text string.\n.   \n.   The function cv::getTextSize calculates and returns the size of a box that contains the specified text.\n.   That is, the following code renders some text, the tight box surrounding it, and the baseline: :\n.   @code\n.   String text = \"Funny text inside the box\";\n.   int fontFace = FONT_HERSHEY_SCRIPT_SIMPLEX;\n.   double fontScale = 2;\n.   int thickness = 3;\n.   \n.   Mat img(600, 800, CV_8UC3, Scalar::all(0));\n.   \n.   int baseline=0;\n.   Size textSize = getTextSize(text, fontFace,\n.   fontScale, thickness, &baseline);\n.   baseline += thickness;\n.   \n.   // center the text\n.   Point textOrg((img.cols - textSize.width)/2,\n.   (img.rows + textSize.height)/2);\n.   \n.   // draw the box\n.   rectangle(img, textOrg + Point(0, baseline),\n.   textOrg + Point(textSize.width, -textSize.height),\n.   Scalar(0,0,255));\n.   // ... and the baseline first\n.   line(img, textOrg + Point(0, thickness),\n.   textOrg + Point(textSize.width, thickness),\n.   Scalar(0, 0, 255));\n.   \n.   // then put the text itself\n.   putText(img, text, textOrg, fontFace, fontScale,\n.   Scalar::all(255), thickness, 8);\n.   @endcode\n.   \n.   @param text Input text string.\n.   @param fontFace Font to use, see #HersheyFonts.\n.   @param fontScale Font scale factor that is multiplied by the font-specific base size.\n.   @param thickness Thickness of lines used to render the text. See #putText for details.\n.   @param[out] baseLine y-coordinate of the baseline relative to the bottom-most text\n.   point.\n.   @return The size of a box that contains the specified text.\n.   \n.   @see putText"},
    {"getThreadNum", (PyCFunction)pyopencv_cv_getThreadNum, METH_VARARGS | METH_KEYWORDS, "getThreadNum() -> retval\n.   @brief Returns the index of the currently executed thread within the current parallel region. Always\n.   returns 0 if called outside of parallel region.\n.   \n.   @deprecated Current implementation doesn't corresponding to this documentation.\n.   \n.   The exact meaning of the return value depends on the threading framework used by OpenCV library:\n.   - `TBB` - Unsupported with current 4.1 TBB release. Maybe will be supported in future.\n.   - `OpenMP` - The thread number, within the current team, of the calling thread.\n.   - `Concurrency` - An ID for the virtual processor that the current context is executing on (0\n.   for master thread and unique number for others, but not necessary 1,2,3,...).\n.   - `GCD` - System calling thread's ID. Never returns 0 inside parallel region.\n.   - `C=` - The index of the current parallel task.\n.   @sa setNumThreads, getNumThreads"},
    {"getTickCount", (PyCFunction)pyopencv_cv_getTickCount, METH_VARARGS | METH_KEYWORDS, "getTickCount() -> retval\n.   @brief Returns the number of ticks.\n.   \n.   The function returns the number of ticks after the certain event (for example, when the machine was\n.   turned on). It can be used to initialize RNG or to measure a function execution time by reading the\n.   tick count before and after the function call.\n.   @sa getTickFrequency, TickMeter"},
    {"getTickFrequency", (PyCFunction)pyopencv_cv_getTickFrequency, METH_VARARGS | METH_KEYWORDS, "getTickFrequency() -> retval\n.   @brief Returns the number of ticks per second.\n.   \n.   The function returns the number of ticks per second. That is, the following code computes the\n.   execution time in seconds:\n.   @code\n.   double t = (double)getTickCount();\n.   // do something ...\n.   t = ((double)getTickCount() - t)/getTickFrequency();\n.   @endcode\n.   @sa getTickCount, TickMeter"},
    {"getTrackbarPos", (PyCFunction)pyopencv_cv_getTrackbarPos, METH_VARARGS | METH_KEYWORDS, "getTrackbarPos(trackbarname, winname) -> retval\n.   @brief Returns the trackbar position.\n.   \n.   The function returns the current position of the specified trackbar.\n.   \n.   @note\n.   \n.   [__Qt Backend Only__] winname can be empty (or NULL) if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of the trackbar."},
    {"getValidDisparityROI", (PyCFunction)pyopencv_cv_getValidDisparityROI, METH_VARARGS | METH_KEYWORDS, "getValidDisparityROI(roi1, roi2, minDisparity, numberOfDisparities, SADWindowSize) -> retval\n."},
    {"getWindowImageRect", (PyCFunction)pyopencv_cv_getWindowImageRect, METH_VARARGS | METH_KEYWORDS, "getWindowImageRect(winname) -> retval\n.   @brief Provides rectangle of image in the window.\n.   \n.   The function getWindowImageRect returns the client screen coordinates, width and height of the image rendering area.\n.   \n.   @param winname Name of the window.\n.   \n.   @sa resizeWindow moveWindow"},
    {"getWindowProperty", (PyCFunction)pyopencv_cv_getWindowProperty, METH_VARARGS | METH_KEYWORDS, "getWindowProperty(winname, prop_id) -> retval\n.   @brief Provides parameters of a window.\n.   \n.   The function getWindowProperty returns properties of a window.\n.   \n.   @param winname Name of the window.\n.   @param prop_id Window property to retrieve. The following operation flags are available: (cv::WindowPropertyFlags)\n.   \n.   @sa setWindowProperty"},
    {"goodFeaturesToTrack", (PyCFunction)pyopencv_cv_goodFeaturesToTrack, METH_VARARGS | METH_KEYWORDS, "goodFeaturesToTrack(image, maxCorners, qualityLevel, minDistance[, corners[, mask[, blockSize[, useHarrisDetector[, k]]]]]) -> corners\n.   @brief Determines strong corners on an image.\n.   \n.   The function finds the most prominent corners in the image or in the specified image region, as\n.   described in @cite Shi94\n.   \n.   -   Function calculates the corner quality measure at every source image pixel using the\n.   #cornerMinEigenVal or #cornerHarris .\n.   -   Function performs a non-maximum suppression (the local maximums in *3 x 3* neighborhood are\n.   retained).\n.   -   The corners with the minimal eigenvalue less than\n.   \\f$\\texttt{qualityLevel} \\cdot \\max_{x,y} qualityMeasureMap(x,y)\\f$ are rejected.\n.   -   The remaining corners are sorted by the quality measure in the descending order.\n.   -   Function throws away each corner for which there is a stronger corner at a distance less than\n.   maxDistance.\n.   \n.   The function can be used to initialize a point-based tracker of an object.\n.   \n.   @note If the function is called with different values A and B of the parameter qualityLevel , and\n.   A \\> B, the vector of returned corners with qualityLevel=A will be the prefix of the output vector\n.   with qualityLevel=B .\n.   \n.   @param image Input 8-bit or floating-point 32-bit, single-channel image.\n.   @param corners Output vector of detected corners.\n.   @param maxCorners Maximum number of corners to return. If there are more corners than are found,\n.   the strongest of them is returned. `maxCorners <= 0` implies that no limit on the maximum is set\n.   and all detected corners are returned.\n.   @param qualityLevel Parameter characterizing the minimal accepted quality of image corners. The\n.   parameter value is multiplied by the best corner quality measure, which is the minimal eigenvalue\n.   (see #cornerMinEigenVal ) or the Harris function response (see #cornerHarris ). The corners with the\n.   quality measure less than the product are rejected. For example, if the best corner has the\n.   quality measure = 1500, and the qualityLevel=0.01 , then all the corners with the quality measure\n.   less than 15 are rejected.\n.   @param minDistance Minimum possible Euclidean distance between the returned corners.\n.   @param mask Optional region of interest. If the image is not empty (it needs to have the type\n.   CV_8UC1 and the same size as image ), it specifies the region in which the corners are detected.\n.   @param blockSize Size of an average block for computing a derivative covariation matrix over each\n.   pixel neighborhood. See cornerEigenValsAndVecs .\n.   @param useHarrisDetector Parameter indicating whether to use a Harris detector (see #cornerHarris)\n.   or #cornerMinEigenVal.\n.   @param k Free parameter of the Harris detector.\n.   \n.   @sa  cornerMinEigenVal, cornerHarris, calcOpticalFlowPyrLK, estimateRigidTransform,\n\n\n\ngoodFeaturesToTrack(image, maxCorners, qualityLevel, minDistance, mask, blockSize, gradientSize[, corners[, useHarrisDetector[, k]]]) -> corners\n."},
    {"grabCut", (PyCFunction)pyopencv_cv_grabCut, METH_VARARGS | METH_KEYWORDS, "grabCut(img, mask, rect, bgdModel, fgdModel, iterCount[, mode]) -> mask, bgdModel, fgdModel\n.   @brief Runs the GrabCut algorithm.\n.   \n.   The function implements the [GrabCut image segmentation algorithm](http://en.wikipedia.org/wiki/GrabCut).\n.   \n.   @param img Input 8-bit 3-channel image.\n.   @param mask Input/output 8-bit single-channel mask. The mask is initialized by the function when\n.   mode is set to #GC_INIT_WITH_RECT. Its elements may have one of the #GrabCutClasses.\n.   @param rect ROI containing a segmented object. The pixels outside of the ROI are marked as\n.   \"obvious background\". The parameter is only used when mode==#GC_INIT_WITH_RECT .\n.   @param bgdModel Temporary array for the background model. Do not modify it while you are\n.   processing the same image.\n.   @param fgdModel Temporary arrays for the foreground model. Do not modify it while you are\n.   processing the same image.\n.   @param iterCount Number of iterations the algorithm should make before returning the result. Note\n.   that the result can be refined with further calls with mode==#GC_INIT_WITH_MASK or\n.   mode==GC_EVAL .\n.   @param mode Operation mode that could be one of the #GrabCutModes"},
    {"groupRectangles", (PyCFunction)pyopencv_cv_groupRectangles, METH_VARARGS | METH_KEYWORDS, "groupRectangles(rectList, groupThreshold[, eps]) -> rectList, weights\n.   @overload"},
    {"haveOpenVX", (PyCFunction)pyopencv_cv_haveOpenVX, METH_VARARGS | METH_KEYWORDS, "haveOpenVX() -> retval\n."},
    {"hconcat", (PyCFunction)pyopencv_cv_hconcat, METH_VARARGS | METH_KEYWORDS, "hconcat(src[, dst]) -> dst\n.   @overload\n.   @code{.cpp}\n.   std::vector<cv::Mat> matrices = { cv::Mat(4, 1, CV_8UC1, cv::Scalar(1)),\n.   cv::Mat(4, 1, CV_8UC1, cv::Scalar(2)),\n.   cv::Mat(4, 1, CV_8UC1, cv::Scalar(3)),};\n.   \n.   cv::Mat out;\n.   cv::hconcat( matrices, out );\n.   //out:\n.   //[1, 2, 3;\n.   // 1, 2, 3;\n.   // 1, 2, 3;\n.   // 1, 2, 3]\n.   @endcode\n.   @param src input array or vector of matrices. all of the matrices must have the same number of rows and the same depth.\n.   @param dst output array. It has the same number of rows and depth as the src, and the sum of cols of the src.\n.   same depth."},
    {"idct", (PyCFunction)pyopencv_cv_idct, METH_VARARGS | METH_KEYWORDS, "idct(src[, dst[, flags]]) -> dst\n.   @brief Calculates the inverse Discrete Cosine Transform of a 1D or 2D array.\n.   \n.   idct(src, dst, flags) is equivalent to dct(src, dst, flags | DCT_INVERSE).\n.   @param src input floating-point single-channel array.\n.   @param dst output array of the same size and type as src.\n.   @param flags operation flags.\n.   @sa  dct, dft, idft, getOptimalDFTSize"},
    {"idft", (PyCFunction)pyopencv_cv_idft, METH_VARARGS | METH_KEYWORDS, "idft(src[, dst[, flags[, nonzeroRows]]]) -> dst\n.   @brief Calculates the inverse Discrete Fourier Transform of a 1D or 2D array.\n.   \n.   idft(src, dst, flags) is equivalent to dft(src, dst, flags | #DFT_INVERSE) .\n.   @note None of dft and idft scales the result by default. So, you should pass #DFT_SCALE to one of\n.   dft or idft explicitly to make these transforms mutually inverse.\n.   @sa dft, dct, idct, mulSpectrums, getOptimalDFTSize\n.   @param src input floating-point real or complex array.\n.   @param dst output array whose size and type depend on the flags.\n.   @param flags operation flags (see dft and #DftFlags).\n.   @param nonzeroRows number of dst rows to process; the rest of the rows have undefined content (see\n.   the convolution sample in dft description."},
    {"illuminationChange", (PyCFunction)pyopencv_cv_illuminationChange, METH_VARARGS | METH_KEYWORDS, "illuminationChange(src, mask[, dst[, alpha[, beta]]]) -> dst\n.   @brief Applying an appropriate non-linear transformation to the gradient field inside the selection and\n.   then integrating back with a Poisson solver, modifies locally the apparent illumination of an image.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param alpha Value ranges between 0-2.\n.   @param beta Value ranges between 0-2.\n.   \n.   This is useful to highlight under-exposed foreground objects or to reduce specular reflections."},
    {"imdecode", (PyCFunction)pyopencv_cv_imdecode, METH_VARARGS | METH_KEYWORDS, "imdecode(buf, flags) -> retval\n.   @brief Reads an image from a buffer in memory.\n.   \n.   The function imdecode reads an image from the specified buffer in the memory. If the buffer is too short or\n.   contains invalid data, the function returns an empty matrix ( Mat::data==NULL ).\n.   \n.   See cv::imread for the list of supported formats and flags description.\n.   \n.   @note In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   @param buf Input array or vector of bytes.\n.   @param flags The same flags as in cv::imread, see cv::ImreadModes."},
    {"imencode", (PyCFunction)pyopencv_cv_imencode, METH_VARARGS | METH_KEYWORDS, "imencode(ext, img[, params]) -> retval, buf\n.   @brief Encodes an image into a memory buffer.\n.   \n.   The function imencode compresses the image and stores it in the memory buffer that is resized to fit the\n.   result. See cv::imwrite for the list of supported formats and flags description.\n.   \n.   @param ext File extension that defines the output format.\n.   @param img Image to be written.\n.   @param buf Output buffer resized to fit the compressed image.\n.   @param params Format-specific parameters. See cv::imwrite and cv::ImwriteFlags."},
    {"imread", (PyCFunction)pyopencv_cv_imread, METH_VARARGS | METH_KEYWORDS, "imread(filename[, flags]) -> retval\n.   @brief Loads an image from a file.\n.   \n.   @anchor imread\n.   \n.   The function imread loads an image from the specified file and returns it. If the image cannot be\n.   read (because of missing file, improper permissions, unsupported or invalid format), the function\n.   returns an empty matrix ( Mat::data==NULL ).\n.   \n.   Currently, the following file formats are supported:\n.   \n.   -   Windows bitmaps - \\*.bmp, \\*.dib (always supported)\n.   -   JPEG files - \\*.jpeg, \\*.jpg, \\*.jpe (see the *Notes* section)\n.   -   JPEG 2000 files - \\*.jp2 (see the *Notes* section)\n.   -   Portable Network Graphics - \\*.png (see the *Notes* section)\n.   -   WebP - \\*.webp (see the *Notes* section)\n.   -   Portable image format - \\*.pbm, \\*.pgm, \\*.ppm \\*.pxm, \\*.pnm (always supported)\n.   -   Sun rasters - \\*.sr, \\*.ras (always supported)\n.   -   TIFF files - \\*.tiff, \\*.tif (see the *Notes* section)\n.   -   OpenEXR Image files - \\*.exr (see the *Notes* section)\n.   -   Radiance HDR - \\*.hdr, \\*.pic (always supported)\n.   -   Raster and Vector geospatial data supported by Gdal (see the *Notes* section)\n.   \n.   @note\n.   \n.   -   The function determines the type of an image by the content, not by the file extension.\n.   -   In the case of color images, the decoded images will have the channels stored in **B G R** order.\n.   -   On Microsoft Windows\\* OS and MacOSX\\*, the codecs shipped with an OpenCV image (libjpeg,\n.   libpng, libtiff, and libjasper) are used by default. So, OpenCV can always read JPEGs, PNGs,\n.   and TIFFs. On MacOSX, there is also an option to use native MacOSX image readers. But beware\n.   that currently these native image loaders give images with different pixel values because of\n.   the color management embedded into MacOSX.\n.   -   On Linux\\*, BSD flavors and other Unix-like open-source operating systems, OpenCV looks for\n.   codecs supplied with an OS image. Install the relevant packages (do not forget the development\n.   files, for example, \"libjpeg-dev\", in Debian\\* and Ubuntu\\*) to get the codec support or turn\n.   on the OPENCV_BUILD_3RDPARTY_LIBS flag in CMake.\n.   -   In the case you set *WITH_GDAL* flag to true in CMake and @ref IMREAD_LOAD_GDAL to load the image,\n.   then [GDAL](http://www.gdal.org) driver will be used in order to decode the image by supporting\n.   the following formats: [Raster](http://www.gdal.org/formats_list.html),\n.   [Vector](http://www.gdal.org/ogr_formats.html).\n.   -   If EXIF information are embedded in the image file, the EXIF orientation will be taken into account\n.   and thus the image will be rotated accordingly except if the flag @ref IMREAD_IGNORE_ORIENTATION is passed.\n.   @param filename Name of file to be loaded.\n.   @param flags Flag that can take values of cv::ImreadModes"},
    {"imreadmulti", (PyCFunction)pyopencv_cv_imreadmulti, METH_VARARGS | METH_KEYWORDS, "imreadmulti(filename[, mats[, flags]]) -> retval, mats\n.   @brief Loads a multi-page image from a file.\n.   \n.   The function imreadmulti loads a multi-page image from the specified file into a vector of Mat objects.\n.   @param filename Name of file to be loaded.\n.   @param flags Flag that can take values of cv::ImreadModes, default with cv::IMREAD_ANYCOLOR.\n.   @param mats A vector of Mat objects holding each page, if more than one.\n.   @sa cv::imread"},
    {"imshow", (PyCFunction)pyopencv_cv_imshow, METH_VARARGS | METH_KEYWORDS, "imshow(winname, mat) -> None\n.   @brief Displays an image in the specified window.\n.   \n.   The function imshow displays an image in the specified window. If the window was created with the\n.   cv::WINDOW_AUTOSIZE flag, the image is shown with its original size, however it is still limited by the screen resolution.\n.   Otherwise, the image is scaled to fit the window. The function may scale the image, depending on its depth:\n.   \n.   -   If the image is 8-bit unsigned, it is displayed as is.\n.   -   If the image is 16-bit unsigned or 32-bit integer, the pixels are divided by 256. That is, the\n.   value range [0,255\\*256] is mapped to [0,255].\n.   -   If the image is 32-bit or 64-bit floating-point, the pixel values are multiplied by 255. That is, the\n.   value range [0,1] is mapped to [0,255].\n.   \n.   If window was created with OpenGL support, cv::imshow also support ogl::Buffer , ogl::Texture2D and\n.   cuda::GpuMat as input.\n.   \n.   If the window was not created before this function, it is assumed creating a window with cv::WINDOW_AUTOSIZE.\n.   \n.   If you need to show an image that is bigger than the screen resolution, you will need to call namedWindow(\"\", WINDOW_NORMAL) before the imshow.\n.   \n.   @note This function should be followed by cv::waitKey function which displays the image for specified\n.   milliseconds. Otherwise, it won't display the image. For example, **waitKey(0)** will display the window\n.   infinitely until any keypress (it is suitable for image display). **waitKey(25)** will display a frame\n.   for 25 ms, after which display will be automatically closed. (If you put it in a loop to read\n.   videos, it will display the video frame-by-frame)\n.   \n.   @note\n.   \n.   [__Windows Backend Only__] Pressing Ctrl+C will copy the image to the clipboard.\n.   \n.   [__Windows Backend Only__] Pressing Ctrl+S will show a dialog to save the image.\n.   \n.   @param winname Name of the window.\n.   @param mat Image to be shown."},
    {"imwrite", (PyCFunction)pyopencv_cv_imwrite, METH_VARARGS | METH_KEYWORDS, "imwrite(filename, img[, params]) -> retval\n.   @brief Saves an image to a specified file.\n.   \n.   The function imwrite saves the image to the specified file. The image format is chosen based on the\n.   filename extension (see cv::imread for the list of extensions). Only 8-bit (or 16-bit unsigned (CV_16U)\n.   in case of PNG, JPEG 2000, and TIFF) single-channel or 3-channel (with 'BGR' channel order) images\n.   can be saved using this function. If the format, depth or channel order is different, use\n.   Mat::convertTo , and cv::cvtColor to convert it before saving. Or, use the universal FileStorage I/O\n.   functions to save the image to XML or YAML format.\n.   \n.   It is possible to store PNG images with an alpha channel using this function. To do this, create\n.   8-bit (or 16-bit) 4-channel image BGRA, where the alpha channel goes last. Fully transparent pixels\n.   should have alpha set to 0, fully opaque pixels should have alpha set to 255/65535.\n.   \n.   The sample below shows how to create such a BGRA image and store to PNG file. It also demonstrates how to set custom\n.   compression parameters :\n.   @include snippets/imgcodecs_imwrite.cpp\n.   @param filename Name of the file.\n.   @param img Image to be saved.\n.   @param params Format-specific parameters encoded as pairs (paramId_1, paramValue_1, paramId_2, paramValue_2, ... .) see cv::ImwriteFlags"},
    {"inRange", (PyCFunction)pyopencv_cv_inRange, METH_VARARGS | METH_KEYWORDS, "inRange(src, lowerb, upperb[, dst]) -> dst\n.   @brief  Checks if array elements lie between the elements of two other arrays.\n.   \n.   The function checks the range as follows:\n.   -   For every element of a single-channel input array:\n.   \\f[\\texttt{dst} (I)= \\texttt{lowerb} (I)_0  \\leq \\texttt{src} (I)_0 \\leq  \\texttt{upperb} (I)_0\\f]\n.   -   For two-channel arrays:\n.   \\f[\\texttt{dst} (I)= \\texttt{lowerb} (I)_0  \\leq \\texttt{src} (I)_0 \\leq  \\texttt{upperb} (I)_0  \\land \\texttt{lowerb} (I)_1  \\leq \\texttt{src} (I)_1 \\leq  \\texttt{upperb} (I)_1\\f]\n.   -   and so forth.\n.   \n.   That is, dst (I) is set to 255 (all 1 -bits) if src (I) is within the\n.   specified 1D, 2D, 3D, ... box and 0 otherwise.\n.   \n.   When the lower and/or upper boundary parameters are scalars, the indexes\n.   (I) at lowerb and upperb in the above formulas should be omitted.\n.   @param src first input array.\n.   @param lowerb inclusive lower boundary array or a scalar.\n.   @param upperb inclusive upper boundary array or a scalar.\n.   @param dst output array of the same size as src and CV_8U type."},
    {"initCameraMatrix2D", (PyCFunction)pyopencv_cv_initCameraMatrix2D, METH_VARARGS | METH_KEYWORDS, "initCameraMatrix2D(objectPoints, imagePoints, imageSize[, aspectRatio]) -> retval\n.   @brief Finds an initial camera matrix from 3D-2D point correspondences.\n.   \n.   @param objectPoints Vector of vectors of the calibration pattern points in the calibration pattern\n.   coordinate space. In the old interface all the per-view vectors are concatenated. See\n.   calibrateCamera for details.\n.   @param imagePoints Vector of vectors of the projections of the calibration pattern points. In the\n.   old interface all the per-view vectors are concatenated.\n.   @param imageSize Image size in pixels used to initialize the principal point.\n.   @param aspectRatio If it is zero or negative, both \\f$f_x\\f$ and \\f$f_y\\f$ are estimated independently.\n.   Otherwise, \\f$f_x = f_y * \\texttt{aspectRatio}\\f$ .\n.   \n.   The function estimates and returns an initial camera matrix for the camera calibration process.\n.   Currently, the function only supports planar calibration patterns, which are patterns where each\n.   object point has z-coordinate =0."},
    {"initUndistortRectifyMap", (PyCFunction)pyopencv_cv_initUndistortRectifyMap, METH_VARARGS | METH_KEYWORDS, "initUndistortRectifyMap(cameraMatrix, distCoeffs, R, newCameraMatrix, size, m1type[, map1[, map2]]) -> map1, map2\n.   @brief Computes the undistortion and rectification transformation map.\n.   \n.   The function computes the joint undistortion and rectification transformation and represents the\n.   result in the form of maps for remap. The undistorted image looks like original, as if it is\n.   captured with a camera using the camera matrix =newCameraMatrix and zero distortion. In case of a\n.   monocular camera, newCameraMatrix is usually equal to cameraMatrix, or it can be computed by\n.   #getOptimalNewCameraMatrix for a better control over scaling. In case of a stereo camera,\n.   newCameraMatrix is normally set to P1 or P2 computed by #stereoRectify .\n.   \n.   Also, this new camera is oriented differently in the coordinate space, according to R. That, for\n.   example, helps to align two heads of a stereo camera so that the epipolar lines on both images\n.   become horizontal and have the same y- coordinate (in case of a horizontally aligned stereo camera).\n.   \n.   The function actually builds the maps for the inverse mapping algorithm that is used by remap. That\n.   is, for each pixel \\f$(u, v)\\f$ in the destination (corrected and rectified) image, the function\n.   computes the corresponding coordinates in the source image (that is, in the original image from\n.   camera). The following process is applied:\n.   \\f[\n.   \\begin{array}{l}\n.   x  \\leftarrow (u - {c'}_x)/{f'}_x  \\\\\n.   y  \\leftarrow (v - {c'}_y)/{f'}_y  \\\\\n.   {[X\\,Y\\,W]} ^T  \\leftarrow R^{-1}*[x \\, y \\, 1]^T  \\\\\n.   x'  \\leftarrow X/W  \\\\\n.   y'  \\leftarrow Y/W  \\\\\n.   r^2  \\leftarrow x'^2 + y'^2 \\\\\n.   x''  \\leftarrow x' \\frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\n.   + 2p_1 x' y' + p_2(r^2 + 2 x'^2)  + s_1 r^2 + s_2 r^4\\\\\n.   y''  \\leftarrow y' \\frac{1 + k_1 r^2 + k_2 r^4 + k_3 r^6}{1 + k_4 r^2 + k_5 r^4 + k_6 r^6}\n.   + p_1 (r^2 + 2 y'^2) + 2 p_2 x' y' + s_3 r^2 + s_4 r^4 \\\\\n.   s\\vecthree{x'''}{y'''}{1} =\n.   \\vecthreethree{R_{33}(\\tau_x, \\tau_y)}{0}{-R_{13}((\\tau_x, \\tau_y)}\n.   {0}{R_{33}(\\tau_x, \\tau_y)}{-R_{23}(\\tau_x, \\tau_y)}\n.   {0}{0}{1} R(\\tau_x, \\tau_y) \\vecthree{x''}{y''}{1}\\\\\n.   map_x(u,v)  \\leftarrow x''' f_x + c_x  \\\\\n.   map_y(u,v)  \\leftarrow y''' f_y + c_y\n.   \\end{array}\n.   \\f]\n.   where \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   are the distortion coefficients.\n.   \n.   In case of a stereo camera, this function is called twice: once for each camera head, after\n.   stereoRectify, which in its turn is called after #stereoCalibrate. But if the stereo camera\n.   was not calibrated, it is still possible to compute the rectification transformations directly from\n.   the fundamental matrix using #stereoRectifyUncalibrated. For each camera, the function computes\n.   homography H as the rectification transformation in a pixel domain, not a rotation matrix R in 3D\n.   space. R can be computed from H as\n.   \\f[\\texttt{R} = \\texttt{cameraMatrix} ^{-1} \\cdot \\texttt{H} \\cdot \\texttt{cameraMatrix}\\f]\n.   where cameraMatrix can be chosen arbitrarily.\n.   \n.   @param cameraMatrix Input camera matrix \\f$A=\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param R Optional rectification transformation in the object space (3x3 matrix). R1 or R2 ,\n.   computed by #stereoRectify can be passed here. If the matrix is empty, the identity transformation\n.   is assumed. In cvInitUndistortMap R assumed to be an identity matrix.\n.   @param newCameraMatrix New camera matrix \\f$A'=\\vecthreethree{f_x'}{0}{c_x'}{0}{f_y'}{c_y'}{0}{0}{1}\\f$.\n.   @param size Undistorted image size.\n.   @param m1type Type of the first output map that can be CV_32FC1, CV_32FC2 or CV_16SC2, see #convertMaps\n.   @param map1 The first output map.\n.   @param map2 The second output map."},
    {"initWideAngleProjMap", (PyCFunction)pyopencv_cv_initWideAngleProjMap, METH_VARARGS | METH_KEYWORDS, "initWideAngleProjMap(cameraMatrix, distCoeffs, imageSize, destImageWidth, m1type[, map1[, map2[, projType[, alpha]]]]) -> retval, map1, map2\n."},
    {"inpaint", (PyCFunction)pyopencv_cv_inpaint, METH_VARARGS | METH_KEYWORDS, "inpaint(src, inpaintMask, inpaintRadius, flags[, dst]) -> dst\n.   @brief Restores the selected region in an image using the region neighborhood.\n.   \n.   @param src Input 8-bit, 16-bit unsigned or 32-bit float 1-channel or 8-bit 3-channel image.\n.   @param inpaintMask Inpainting mask, 8-bit 1-channel image. Non-zero pixels indicate the area that\n.   needs to be inpainted.\n.   @param dst Output image with the same size and type as src .\n.   @param inpaintRadius Radius of a circular neighborhood of each point inpainted that is considered\n.   by the algorithm.\n.   @param flags Inpainting method that could be one of the following:\n.   -   **INPAINT_NS** Navier-Stokes based method [Navier01]\n.   -   **INPAINT_TELEA** Method by Alexandru Telea @cite Telea04 .\n.   \n.   The function reconstructs the selected image area from the pixel near the area boundary. The\n.   function may be used to remove dust and scratches from a scanned photo, or to remove undesirable\n.   objects from still images or video. See <http://en.wikipedia.org/wiki/Inpainting> for more details.\n.   \n.   @note\n.   -   An example using the inpainting technique can be found at\n.   opencv_source_code/samples/cpp/inpaint.cpp\n.   -   (Python) An example using the inpainting technique can be found at\n.   opencv_source_code/samples/python/inpaint.py"},
    {"insertChannel", (PyCFunction)pyopencv_cv_insertChannel, METH_VARARGS | METH_KEYWORDS, "insertChannel(src, dst, coi) -> dst\n.   @brief Inserts a single channel to dst (coi is 0-based index)\n.   @param src input array\n.   @param dst output array\n.   @param coi index of channel for insertion\n.   @sa mixChannels, merge"},
    {"integral", (PyCFunction)pyopencv_cv_integral, METH_VARARGS | METH_KEYWORDS, "integral(src[, sum[, sdepth]]) -> sum\n.   @overload"},
    {"integral2", (PyCFunction)pyopencv_cv_integral2, METH_VARARGS | METH_KEYWORDS, "integral2(src[, sum[, sqsum[, sdepth[, sqdepth]]]]) -> sum, sqsum\n.   @overload"},
    {"integral3", (PyCFunction)pyopencv_cv_integral3, METH_VARARGS | METH_KEYWORDS, "integral3(src[, sum[, sqsum[, tilted[, sdepth[, sqdepth]]]]]) -> sum, sqsum, tilted\n.   @brief Calculates the integral of an image.\n.   \n.   The function calculates one or more integral images for the source image as follows:\n.   \n.   \\f[\\texttt{sum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)\\f]\n.   \n.   \\f[\\texttt{sqsum} (X,Y) =  \\sum _{x<X,y<Y}  \\texttt{image} (x,y)^2\\f]\n.   \n.   \\f[\\texttt{tilted} (X,Y) =  \\sum _{y<Y,abs(x-X+1) \\leq Y-y-1}  \\texttt{image} (x,y)\\f]\n.   \n.   Using these integral images, you can calculate sum, mean, and standard deviation over a specific\n.   up-right or rotated rectangular region of the image in a constant time, for example:\n.   \n.   \\f[\\sum _{x_1 \\leq x < x_2,  \\, y_1  \\leq y < y_2}  \\texttt{image} (x,y) =  \\texttt{sum} (x_2,y_2)- \\texttt{sum} (x_1,y_2)- \\texttt{sum} (x_2,y_1)+ \\texttt{sum} (x_1,y_1)\\f]\n.   \n.   It makes possible to do a fast blurring or fast block correlation with a variable window size, for\n.   example. In case of multi-channel images, sums for each channel are accumulated independently.\n.   \n.   As a practical example, the next figure shows the calculation of the integral of a straight\n.   rectangle Rect(3,3,3,2) and of a tilted rectangle Rect(5,1,2,3) . The selected pixels in the\n.   original image are shown, as well as the relative pixels in the integral images sum and tilted .\n.   \n.   ![integral calculation example](pics/integral.png)\n.   \n.   @param src input image as \\f$W \\times H\\f$, 8-bit or floating-point (32f or 64f).\n.   @param sum integral image as \\f$(W+1)\\times (H+1)\\f$ , 32-bit integer or floating-point (32f or 64f).\n.   @param sqsum integral image for squared pixel values; it is \\f$(W+1)\\times (H+1)\\f$, double-precision\n.   floating-point (64f) array.\n.   @param tilted integral for the image rotated by 45 degrees; it is \\f$(W+1)\\times (H+1)\\f$ array with\n.   the same data type as sum.\n.   @param sdepth desired depth of the integral and the tilted integral images, CV_32S, CV_32F, or\n.   CV_64F.\n.   @param sqdepth desired depth of the integral image of squared pixel values, CV_32F or CV_64F."},
    {"intersectConvexConvex", (PyCFunction)pyopencv_cv_intersectConvexConvex, METH_VARARGS | METH_KEYWORDS, "intersectConvexConvex(_p1, _p2[, _p12[, handleNested]]) -> retval, _p12\n."},
    {"invert", (PyCFunction)pyopencv_cv_invert, METH_VARARGS | METH_KEYWORDS, "invert(src[, dst[, flags]]) -> retval, dst\n.   @brief Finds the inverse or pseudo-inverse of a matrix.\n.   \n.   The function cv::invert inverts the matrix src and stores the result in dst\n.   . When the matrix src is singular or non-square, the function calculates\n.   the pseudo-inverse matrix (the dst matrix) so that norm(src\\*dst - I) is\n.   minimal, where I is an identity matrix.\n.   \n.   In case of the #DECOMP_LU method, the function returns non-zero value if\n.   the inverse has been successfully calculated and 0 if src is singular.\n.   \n.   In case of the #DECOMP_SVD method, the function returns the inverse\n.   condition number of src (the ratio of the smallest singular value to the\n.   largest singular value) and 0 if src is singular. The SVD method\n.   calculates a pseudo-inverse matrix if src is singular.\n.   \n.   Similarly to #DECOMP_LU, the method #DECOMP_CHOLESKY works only with\n.   non-singular square matrices that should also be symmetrical and\n.   positively defined. In this case, the function stores the inverted\n.   matrix in dst and returns non-zero. Otherwise, it returns 0.\n.   \n.   @param src input floating-point M x N matrix.\n.   @param dst output matrix of N x M size and the same type as src.\n.   @param flags inversion method (cv::DecompTypes)\n.   @sa solve, SVD"},
    {"invertAffineTransform", (PyCFunction)pyopencv_cv_invertAffineTransform, METH_VARARGS | METH_KEYWORDS, "invertAffineTransform(M[, iM]) -> iM\n.   @brief Inverts an affine transformation.\n.   \n.   The function computes an inverse affine transformation represented by \\f$2 \\times 3\\f$ matrix M:\n.   \n.   \\f[\\begin{bmatrix} a_{11} & a_{12} & b_1  \\\\ a_{21} & a_{22} & b_2 \\end{bmatrix}\\f]\n.   \n.   The result is also a \\f$2 \\times 3\\f$ matrix of the same type as M.\n.   \n.   @param M Original affine transformation.\n.   @param iM Output reverse affine transformation."},
    {"isContourConvex", (PyCFunction)pyopencv_cv_isContourConvex, METH_VARARGS | METH_KEYWORDS, "isContourConvex(contour) -> retval\n.   @brief Tests a contour convexity.\n.   \n.   The function tests whether the input contour is convex or not. The contour must be simple, that is,\n.   without self-intersections. Otherwise, the function output is undefined.\n.   \n.   @param contour Input vector of 2D points, stored in std::vector\\<\\> or Mat"},
    {"kmeans", (PyCFunction)pyopencv_cv_kmeans, METH_VARARGS | METH_KEYWORDS, "kmeans(data, K, bestLabels, criteria, attempts, flags[, centers]) -> retval, bestLabels, centers\n.   @brief Finds centers of clusters and groups input samples around the clusters.\n.   \n.   The function kmeans implements a k-means algorithm that finds the centers of cluster_count clusters\n.   and groups the input samples around the clusters. As an output, \\f$\\texttt{labels}_i\\f$ contains a\n.   0-based cluster index for the sample stored in the \\f$i^{th}\\f$ row of the samples matrix.\n.   \n.   @note\n.   -   (Python) An example on K-means clustering can be found at\n.   opencv_source_code/samples/python/kmeans.py\n.   @param data Data for clustering. An array of N-Dimensional points with float coordinates is needed.\n.   Examples of this array can be:\n.   -   Mat points(count, 2, CV_32F);\n.   -   Mat points(count, 1, CV_32FC2);\n.   -   Mat points(1, count, CV_32FC2);\n.   -   std::vector\\<cv::Point2f\\> points(sampleCount);\n.   @param K Number of clusters to split the set by.\n.   @param bestLabels Input/output integer array that stores the cluster indices for every sample.\n.   @param criteria The algorithm termination criteria, that is, the maximum number of iterations and/or\n.   the desired accuracy. The accuracy is specified as criteria.epsilon. As soon as each of the cluster\n.   centers moves by less than criteria.epsilon on some iteration, the algorithm stops.\n.   @param attempts Flag to specify the number of times the algorithm is executed using different\n.   initial labellings. The algorithm returns the labels that yield the best compactness (see the last\n.   function parameter).\n.   @param flags Flag that can take values of cv::KmeansFlags\n.   @param centers Output matrix of the cluster centers, one row per each cluster center.\n.   @return The function returns the compactness measure that is computed as\n.   \\f[\\sum _i  \\| \\texttt{samples} _i -  \\texttt{centers} _{ \\texttt{labels} _i} \\| ^2\\f]\n.   after every attempt. The best (minimum) value is chosen and the corresponding labels and the\n.   compactness value are returned by the function. Basically, you can use only the core of the\n.   function, set the number of attempts to 1, initialize labels each time using a custom algorithm,\n.   pass them with the ( flags = #KMEANS_USE_INITIAL_LABELS ) flag, and then choose the best\n.   (most-compact) clustering."},
    {"line", (PyCFunction)pyopencv_cv_line, METH_VARARGS | METH_KEYWORDS, "line(img, pt1, pt2, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a line segment connecting two points.\n.   \n.   The function line draws the line segment between pt1 and pt2 points in the image. The line is\n.   clipped by the image boundaries. For non-antialiased lines with integer coordinates, the 8-connected\n.   or 4-connected Bresenham algorithm is used. Thick lines are drawn with rounding endings. Antialiased\n.   lines are drawn using Gaussian filtering.\n.   \n.   @param img Image.\n.   @param pt1 First point of the line segment.\n.   @param pt2 Second point of the line segment.\n.   @param color Line color.\n.   @param thickness Line thickness.\n.   @param lineType Type of the line. See #LineTypes.\n.   @param shift Number of fractional bits in the point coordinates."},
    {"linearPolar", (PyCFunction)pyopencv_cv_linearPolar, METH_VARARGS | METH_KEYWORDS, "linearPolar(src, center, maxRadius, flags[, dst]) -> dst\n.   @brief Remaps an image to polar coordinates space.\n.   \n.   @anchor polar_remaps_reference_image\n.   ![Polar remaps reference](pics/polar_remap_doc.png)\n.   \n.   Transform the source image using the following transformation:\n.   \\f[\\begin{array}{l}\n.   dst( \\rho , \\phi ) = src(x,y) \\\\\n.   dst.size() \\leftarrow src.size()\n.   \\end{array}\\f]\n.   \n.   where\n.   \\f[\\begin{array}{l}\n.   I = (dx,dy) = (x - center.x,y - center.y) \\\\\n.   \\rho = Kx \\cdot \\texttt{magnitude} (I) ,\\\\\n.   \\phi = Ky \\cdot \\texttt{angle} (I)_{0..360 deg}\n.   \\end{array}\\f]\n.   \n.   and\n.   \\f[\\begin{array}{l}\n.   Kx = src.cols / maxRadius \\\\\n.   Ky = src.rows / 360\n.   \\end{array}\\f]\n.   \n.   \n.   @param src Source image\n.   @param dst Destination image. It will have same size and type as src.\n.   @param center The transformation center;\n.   @param maxRadius The radius of the bounding circle to transform. It determines the inverse magnitude scale parameter too.\n.   @param flags A combination of interpolation methods, see #InterpolationFlags\n.   \n.   @note\n.   -   The function can not operate in-place.\n.   -   To calculate magnitude and angle in degrees #cartToPolar is used internally thus angles are measured from 0 to 360 with accuracy about 0.3 degrees."},
    {"log", (PyCFunction)pyopencv_cv_log, METH_VARARGS | METH_KEYWORDS, "log(src[, dst]) -> dst\n.   @brief Calculates the natural logarithm of every array element.\n.   \n.   The function cv::log calculates the natural logarithm of every element of the input array:\n.   \\f[\\texttt{dst} (I) =  \\log (\\texttt{src}(I)) \\f]\n.   \n.   Output on zero, negative and special (NaN, Inf) values is undefined.\n.   \n.   @param src input array.\n.   @param dst output array of the same size and type as src .\n.   @sa exp, cartToPolar, polarToCart, phase, pow, sqrt, magnitude"},
    {"logPolar", (PyCFunction)pyopencv_cv_logPolar, METH_VARARGS | METH_KEYWORDS, "logPolar(src, center, M, flags[, dst]) -> dst\n.   @brief Remaps an image to semilog-polar coordinates space.\n.   \n.   Transform the source image using the following transformation (See @ref polar_remaps_reference_image \"Polar remaps reference image\"):\n.   \\f[\\begin{array}{l}\n.   dst( \\rho , \\phi ) = src(x,y) \\\\\n.   dst.size() \\leftarrow src.size()\n.   \\end{array}\\f]\n.   \n.   where\n.   \\f[\\begin{array}{l}\n.   I = (dx,dy) = (x - center.x,y - center.y) \\\\\n.   \\rho = M \\cdot log_e(\\texttt{magnitude} (I)) ,\\\\\n.   \\phi = Ky \\cdot \\texttt{angle} (I)_{0..360 deg} \\\\\n.   \\end{array}\\f]\n.   \n.   and\n.   \\f[\\begin{array}{l}\n.   M = src.cols / log_e(maxRadius) \\\\\n.   Ky = src.rows / 360 \\\\\n.   \\end{array}\\f]\n.   \n.   The function emulates the human \"foveal\" vision and can be used for fast scale and\n.   rotation-invariant template matching, for object tracking and so forth.\n.   @param src Source image\n.   @param dst Destination image. It will have same size and type as src.\n.   @param center The transformation center; where the output precision is maximal\n.   @param M Magnitude scale parameter. It determines the radius of the bounding circle to transform too.\n.   @param flags A combination of interpolation methods, see #InterpolationFlags\n.   \n.   @note\n.   -   The function can not operate in-place.\n.   -   To calculate magnitude and angle in degrees #cartToPolar is used internally thus angles are measured from 0 to 360 with accuracy about 0.3 degrees."},
    {"magnitude", (PyCFunction)pyopencv_cv_magnitude, METH_VARARGS | METH_KEYWORDS, "magnitude(x, y[, magnitude]) -> magnitude\n.   @brief Calculates the magnitude of 2D vectors.\n.   \n.   The function cv::magnitude calculates the magnitude of 2D vectors formed\n.   from the corresponding elements of x and y arrays:\n.   \\f[\\texttt{dst} (I) =  \\sqrt{\\texttt{x}(I)^2 + \\texttt{y}(I)^2}\\f]\n.   @param x floating-point array of x-coordinates of the vectors.\n.   @param y floating-point array of y-coordinates of the vectors; it must\n.   have the same size as x.\n.   @param magnitude output array of the same size and type as x.\n.   @sa cartToPolar, polarToCart, phase, sqrt"},
    {"matMulDeriv", (PyCFunction)pyopencv_cv_matMulDeriv, METH_VARARGS | METH_KEYWORDS, "matMulDeriv(A, B[, dABdA[, dABdB]]) -> dABdA, dABdB\n.   @brief Computes partial derivatives of the matrix product for each multiplied matrix.\n.   \n.   @param A First multiplied matrix.\n.   @param B Second multiplied matrix.\n.   @param dABdA First output derivative matrix d(A\\*B)/dA of size\n.   \\f$\\texttt{A.rows*B.cols} \\times {A.rows*A.cols}\\f$ .\n.   @param dABdB Second output derivative matrix d(A\\*B)/dB of size\n.   \\f$\\texttt{A.rows*B.cols} \\times {B.rows*B.cols}\\f$ .\n.   \n.   The function computes partial derivatives of the elements of the matrix product \\f$A*B\\f$ with regard to\n.   the elements of each of the two input matrices. The function is used to compute the Jacobian\n.   matrices in stereoCalibrate but can also be used in any other similar optimization function."},
    {"matchShapes", (PyCFunction)pyopencv_cv_matchShapes, METH_VARARGS | METH_KEYWORDS, "matchShapes(contour1, contour2, method, parameter) -> retval\n.   @brief Compares two shapes.\n.   \n.   The function compares two shapes. All three implemented methods use the Hu invariants (see #HuMoments)\n.   \n.   @param contour1 First contour or grayscale image.\n.   @param contour2 Second contour or grayscale image.\n.   @param method Comparison method, see #ShapeMatchModes\n.   @param parameter Method-specific parameter (not supported now)."},
    {"matchTemplate", (PyCFunction)pyopencv_cv_matchTemplate, METH_VARARGS | METH_KEYWORDS, "matchTemplate(image, templ, method[, result[, mask]]) -> result\n.   @brief Compares a template against overlapped image regions.\n.   \n.   The function slides through image , compares the overlapped patches of size \\f$w \\times h\\f$ against\n.   templ using the specified method and stores the comparison results in result . Here are the formulae\n.   for the available comparison methods ( \\f$I\\f$ denotes image, \\f$T\\f$ template, \\f$R\\f$ result ). The summation\n.   is done over template and/or the image patch: \\f$x' = 0...w-1, y' = 0...h-1\\f$\n.   \n.   After the function finishes the comparison, the best matches can be found as global minimums (when\n.   #TM_SQDIFF was used) or maximums (when #TM_CCORR or #TM_CCOEFF was used) using the\n.   #minMaxLoc function. In case of a color image, template summation in the numerator and each sum in\n.   the denominator is done over all of the channels and separate mean values are used for each channel.\n.   That is, the function can take a color template and a color image. The result will still be a\n.   single-channel image, which is easier to analyze.\n.   \n.   @param image Image where the search is running. It must be 8-bit or 32-bit floating-point.\n.   @param templ Searched template. It must be not greater than the source image and have the same\n.   data type.\n.   @param result Map of comparison results. It must be single-channel 32-bit floating-point. If image\n.   is \\f$W \\times H\\f$ and templ is \\f$w \\times h\\f$ , then result is \\f$(W-w+1) \\times (H-h+1)\\f$ .\n.   @param method Parameter specifying the comparison method, see #TemplateMatchModes\n.   @param mask Mask of searched template. It must have the same datatype and size with templ. It is\n.   not set by default. Currently, only the #TM_SQDIFF and #TM_CCORR_NORMED methods are supported."},
    {"max", (PyCFunction)pyopencv_cv_max, METH_VARARGS | METH_KEYWORDS, "max(src1, src2[, dst]) -> dst\n.   @brief Calculates per-element maximum of two arrays or an array and a scalar.\n.   \n.   The function cv::max calculates the per-element maximum of two arrays:\n.   \\f[\\texttt{dst} (I)= \\max ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.   or array and a scalar:\n.   \\f[\\texttt{dst} (I)= \\max ( \\texttt{src1} (I), \\texttt{value} )\\f]\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1 .\n.   @param dst output array of the same size and type as src1.\n.   @sa  min, compare, inRange, minMaxLoc, @ref MatrixExpressions"},
    {"mean", (PyCFunction)pyopencv_cv_mean, METH_VARARGS | METH_KEYWORDS, "mean(src[, mask]) -> retval\n.   @brief Calculates an average (mean) of array elements.\n.   \n.   The function cv::mean calculates the mean value M of array elements,\n.   independently for each channel, and return it:\n.   \\f[\\begin{array}{l} N =  \\sum _{I: \\; \\texttt{mask} (I) \\ne 0} 1 \\\\ M_c =  \\left ( \\sum _{I: \\; \\texttt{mask} (I) \\ne 0}{ \\texttt{mtx} (I)_c} \\right )/N \\end{array}\\f]\n.   When all the mask elements are 0's, the function returns Scalar::all(0)\n.   @param src input array that should have from 1 to 4 channels so that the result can be stored in\n.   Scalar_ .\n.   @param mask optional operation mask.\n.   @sa  countNonZero, meanStdDev, norm, minMaxLoc"},
    {"meanShift", (PyCFunction)pyopencv_cv_meanShift, METH_VARARGS | METH_KEYWORDS, "meanShift(probImage, window, criteria) -> retval, window\n.   @brief Finds an object on a back projection image.\n.   \n.   @param probImage Back projection of the object histogram. See calcBackProject for details.\n.   @param window Initial search window.\n.   @param criteria Stop criteria for the iterative search algorithm.\n.   returns\n.   :   Number of iterations CAMSHIFT took to converge.\n.   The function implements the iterative object search algorithm. It takes the input back projection of\n.   an object and the initial position. The mass center in window of the back projection image is\n.   computed and the search window center shifts to the mass center. The procedure is repeated until the\n.   specified number of iterations criteria.maxCount is done or until the window center shifts by less\n.   than criteria.epsilon. The algorithm is used inside CamShift and, unlike CamShift , the search\n.   window size or orientation do not change during the search. You can simply pass the output of\n.   calcBackProject to this function. But better results can be obtained if you pre-filter the back\n.   projection and remove the noise. For example, you can do this by retrieving connected components\n.   with findContours , throwing away contours with small area ( contourArea ), and rendering the\n.   remaining contours with drawContours."},
    {"meanStdDev", (PyCFunction)pyopencv_cv_meanStdDev, METH_VARARGS | METH_KEYWORDS, "meanStdDev(src[, mean[, stddev[, mask]]]) -> mean, stddev\n.   Calculates a mean and standard deviation of array elements.\n.   \n.   The function cv::meanStdDev calculates the mean and the standard deviation M\n.   of array elements independently for each channel and returns it via the\n.   output parameters:\n.   \\f[\\begin{array}{l} N =  \\sum _{I, \\texttt{mask} (I)  \\ne 0} 1 \\\\ \\texttt{mean} _c =  \\frac{\\sum_{ I: \\; \\texttt{mask}(I) \\ne 0} \\texttt{src} (I)_c}{N} \\\\ \\texttt{stddev} _c =  \\sqrt{\\frac{\\sum_{ I: \\; \\texttt{mask}(I) \\ne 0} \\left ( \\texttt{src} (I)_c -  \\texttt{mean} _c \\right )^2}{N}} \\end{array}\\f]\n.   When all the mask elements are 0's, the function returns\n.   mean=stddev=Scalar::all(0).\n.   @note The calculated standard deviation is only the diagonal of the\n.   complete normalized covariance matrix. If the full matrix is needed, you\n.   can reshape the multi-channel array M x N to the single-channel array\n.   M\\*N x mtx.channels() (only possible when the matrix is continuous) and\n.   then pass the matrix to calcCovarMatrix .\n.   @param src input array that should have from 1 to 4 channels so that the results can be stored in\n.   Scalar_ 's.\n.   @param mean output parameter: calculated mean value.\n.   @param stddev output parameter: calculated standard deviation.\n.   @param mask optional operation mask.\n.   @sa  countNonZero, mean, norm, minMaxLoc, calcCovarMatrix"},
    {"medianBlur", (PyCFunction)pyopencv_cv_medianBlur, METH_VARARGS | METH_KEYWORDS, "medianBlur(src, ksize[, dst]) -> dst\n.   @brief Blurs an image using the median filter.\n.   \n.   The function smoothes an image using the median filter with the \\f$\\texttt{ksize} \\times\n.   \\texttt{ksize}\\f$ aperture. Each channel of a multi-channel image is processed independently.\n.   In-place operation is supported.\n.   \n.   @note The median filter uses #BORDER_REPLICATE internally to cope with border pixels, see #BorderTypes\n.   \n.   @param src input 1-, 3-, or 4-channel image; when ksize is 3 or 5, the image depth should be\n.   CV_8U, CV_16U, or CV_32F, for larger aperture sizes, it can only be CV_8U.\n.   @param dst destination array of the same size and type as src.\n.   @param ksize aperture linear size; it must be odd and greater than 1, for example: 3, 5, 7 ...\n.   @sa  bilateralFilter, blur, boxFilter, GaussianBlur"},
    {"merge", (PyCFunction)pyopencv_cv_merge, METH_VARARGS | METH_KEYWORDS, "merge(mv[, dst]) -> dst\n.   @overload\n.   @param mv input vector of matrices to be merged; all the matrices in mv must have the same\n.   size and the same depth.\n.   @param dst output array of the same size and the same depth as mv[0]; The number of channels will\n.   be the total number of channels in the matrix array."},
    {"min", (PyCFunction)pyopencv_cv_min, METH_VARARGS | METH_KEYWORDS, "min(src1, src2[, dst]) -> dst\n.   @brief Calculates per-element minimum of two arrays or an array and a scalar.\n.   \n.   The function cv::min calculates the per-element minimum of two arrays:\n.   \\f[\\texttt{dst} (I)= \\min ( \\texttt{src1} (I), \\texttt{src2} (I))\\f]\n.   or array and a scalar:\n.   \\f[\\texttt{dst} (I)= \\min ( \\texttt{src1} (I), \\texttt{value} )\\f]\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @sa max, compare, inRange, minMaxLoc"},
    {"minAreaRect", (PyCFunction)pyopencv_cv_minAreaRect, METH_VARARGS | METH_KEYWORDS, "minAreaRect(points) -> retval\n.   @brief Finds a rotated rectangle of the minimum area enclosing the input 2D point set.\n.   \n.   The function calculates and returns the minimum-area bounding rectangle (possibly rotated) for a\n.   specified point set. Developer should keep in mind that the returned RotatedRect can contain negative\n.   indices when data is close to the containing Mat element boundary.\n.   \n.   @param points Input vector of 2D points, stored in std::vector\\<\\> or Mat"},
    {"minEnclosingCircle", (PyCFunction)pyopencv_cv_minEnclosingCircle, METH_VARARGS | METH_KEYWORDS, "minEnclosingCircle(points) -> center, radius\n.   @brief Finds a circle of the minimum area enclosing a 2D point set.\n.   \n.   The function finds the minimal enclosing circle of a 2D point set using an iterative algorithm.\n.   \n.   @param points Input vector of 2D points, stored in std::vector\\<\\> or Mat\n.   @param center Output center of the circle.\n.   @param radius Output radius of the circle."},
    {"minEnclosingTriangle", (PyCFunction)pyopencv_cv_minEnclosingTriangle, METH_VARARGS | METH_KEYWORDS, "minEnclosingTriangle(points[, triangle]) -> retval, triangle\n.   @brief Finds a triangle of minimum area enclosing a 2D point set and returns its area.\n.   \n.   The function finds a triangle of minimum area enclosing the given set of 2D points and returns its\n.   area. The output for a given 2D point set is shown in the image below. 2D points are depicted in\n.   *red* and the enclosing triangle in *yellow*.\n.   \n.   ![Sample output of the minimum enclosing triangle function](pics/minenclosingtriangle.png)\n.   \n.   The implementation of the algorithm is based on O'Rourke's @cite ORourke86 and Klee and Laskowski's\n.   @cite KleeLaskowski85 papers. O'Rourke provides a \\f$\\theta(n)\\f$ algorithm for finding the minimal\n.   enclosing triangle of a 2D convex polygon with n vertices. Since the #minEnclosingTriangle function\n.   takes a 2D point set as input an additional preprocessing step of computing the convex hull of the\n.   2D point set is required. The complexity of the #convexHull function is \\f$O(n log(n))\\f$ which is higher\n.   than \\f$\\theta(n)\\f$. Thus the overall complexity of the function is \\f$O(n log(n))\\f$.\n.   \n.   @param points Input vector of 2D points with depth CV_32S or CV_32F, stored in std::vector\\<\\> or Mat\n.   @param triangle Output vector of three 2D points defining the vertices of the triangle. The depth\n.   of the OutputArray must be CV_32F."},
    {"minMaxLoc", (PyCFunction)pyopencv_cv_minMaxLoc, METH_VARARGS | METH_KEYWORDS, "minMaxLoc(src[, mask]) -> minVal, maxVal, minLoc, maxLoc\n.   @brief Finds the global minimum and maximum in an array.\n.   \n.   The function cv::minMaxLoc finds the minimum and maximum element values and their positions. The\n.   extremums are searched across the whole array or, if mask is not an empty array, in the specified\n.   array region.\n.   \n.   The function do not work with multi-channel arrays. If you need to find minimum or maximum\n.   elements across all the channels, use Mat::reshape first to reinterpret the array as\n.   single-channel. Or you may extract the particular channel using either extractImageCOI , or\n.   mixChannels , or split .\n.   @param src input single-channel array.\n.   @param minVal pointer to the returned minimum value; NULL is used if not required.\n.   @param maxVal pointer to the returned maximum value; NULL is used if not required.\n.   @param minLoc pointer to the returned minimum location (in 2D case); NULL is used if not required.\n.   @param maxLoc pointer to the returned maximum location (in 2D case); NULL is used if not required.\n.   @param mask optional mask used to select a sub-array.\n.   @sa max, min, compare, inRange, extractImageCOI, mixChannels, split, Mat::reshape"},
    {"mixChannels", (PyCFunction)pyopencv_cv_mixChannels, METH_VARARGS | METH_KEYWORDS, "mixChannels(src, dst, fromTo) -> dst\n.   @overload\n.   @param src input array or vector of matrices; all of the matrices must have the same size and the\n.   same depth.\n.   @param dst output array or vector of matrices; all the matrices **must be allocated**; their size and\n.   depth must be the same as in src[0].\n.   @param fromTo array of index pairs specifying which channels are copied and where; fromTo[k\\*2] is\n.   a 0-based index of the input channel in src, fromTo[k\\*2+1] is an index of the output channel in\n.   dst; the continuous channel numbering is used: the first input image channels are indexed from 0 to\n.   src[0].channels()-1, the second input image channels are indexed from src[0].channels() to\n.   src[0].channels() + src[1].channels()-1, and so on, the same scheme is used for the output image\n.   channels; as a special case, when fromTo[k\\*2] is negative, the corresponding output channel is\n.   filled with zero ."},
    {"moments", (PyCFunction)pyopencv_cv_moments, METH_VARARGS | METH_KEYWORDS, "moments(array[, binaryImage]) -> retval\n.   @brief Calculates all of the moments up to the third order of a polygon or rasterized shape.\n.   \n.   The function computes moments, up to the 3rd order, of a vector shape or a rasterized shape. The\n.   results are returned in the structure cv::Moments.\n.   \n.   @param array Raster image (single-channel, 8-bit or floating-point 2D array) or an array (\n.   \\f$1 \\times N\\f$ or \\f$N \\times 1\\f$ ) of 2D points (Point or Point2f ).\n.   @param binaryImage If it is true, all non-zero image pixels are treated as 1's. The parameter is\n.   used for images only.\n.   @returns moments.\n.   \n.   @note Only applicable to contour moments calculations from Python bindings: Note that the numpy\n.   type for the input array should be either np.int32 or np.float32.\n.   \n.   @sa  contourArea, arcLength"},
    {"morphologyEx", (PyCFunction)pyopencv_cv_morphologyEx, METH_VARARGS | METH_KEYWORDS, "morphologyEx(src, op, kernel[, dst[, anchor[, iterations[, borderType[, borderValue]]]]]) -> dst\n.   @brief Performs advanced morphological transformations.\n.   \n.   The function cv::morphologyEx can perform advanced morphological transformations using an erosion and dilation as\n.   basic operations.\n.   \n.   Any of the operations can be done in-place. In case of multi-channel images, each channel is\n.   processed independently.\n.   \n.   @param src Source image. The number of channels can be arbitrary. The depth should be one of\n.   CV_8U, CV_16U, CV_16S, CV_32F or CV_64F.\n.   @param dst Destination image of the same size and type as source image.\n.   @param op Type of a morphological operation, see #MorphTypes\n.   @param kernel Structuring element. It can be created using #getStructuringElement.\n.   @param anchor Anchor position with the kernel. Negative values mean that the anchor is at the\n.   kernel center.\n.   @param iterations Number of times erosion and dilation are applied.\n.   @param borderType Pixel extrapolation method, see #BorderTypes\n.   @param borderValue Border value in case of a constant border. The default value has a special\n.   meaning.\n.   @sa  dilate, erode, getStructuringElement\n.   @note The number of iterations is the number of times erosion or dilatation operation will be applied.\n.   For instance, an opening operation (#MORPH_OPEN) with two iterations is equivalent to apply\n.   successively: erode -> erode -> dilate -> dilate (and not erode -> dilate -> erode -> dilate)."},
    {"moveWindow", (PyCFunction)pyopencv_cv_moveWindow, METH_VARARGS | METH_KEYWORDS, "moveWindow(winname, x, y) -> None\n.   @brief Moves window to the specified position\n.   \n.   @param winname Name of the window.\n.   @param x The new x-coordinate of the window.\n.   @param y The new y-coordinate of the window."},
    {"mulSpectrums", (PyCFunction)pyopencv_cv_mulSpectrums, METH_VARARGS | METH_KEYWORDS, "mulSpectrums(a, b, flags[, c[, conjB]]) -> c\n.   @brief Performs the per-element multiplication of two Fourier spectrums.\n.   \n.   The function cv::mulSpectrums performs the per-element multiplication of the two CCS-packed or complex\n.   matrices that are results of a real or complex Fourier transform.\n.   \n.   The function, together with dft and idft , may be used to calculate convolution (pass conjB=false )\n.   or correlation (pass conjB=true ) of two arrays rapidly. When the arrays are complex, they are\n.   simply multiplied (per element) with an optional conjugation of the second-array elements. When the\n.   arrays are real, they are assumed to be CCS-packed (see dft for details).\n.   @param a first input array.\n.   @param b second input array of the same size and type as src1 .\n.   @param c output array of the same size and type as src1 .\n.   @param flags operation flags; currently, the only supported flag is cv::DFT_ROWS, which indicates that\n.   each row of src1 and src2 is an independent 1D Fourier spectrum. If you do not want to use this flag, then simply add a `0` as value.\n.   @param conjB optional flag that conjugates the second input array before the multiplication (true)\n.   or not (false)."},
    {"mulTransposed", (PyCFunction)pyopencv_cv_mulTransposed, METH_VARARGS | METH_KEYWORDS, "mulTransposed(src, aTa[, dst[, delta[, scale[, dtype]]]]) -> dst\n.   @brief Calculates the product of a matrix and its transposition.\n.   \n.   The function cv::mulTransposed calculates the product of src and its\n.   transposition:\n.   \\f[\\texttt{dst} = \\texttt{scale} ( \\texttt{src} - \\texttt{delta} )^T ( \\texttt{src} - \\texttt{delta} )\\f]\n.   if aTa=true , and\n.   \\f[\\texttt{dst} = \\texttt{scale} ( \\texttt{src} - \\texttt{delta} ) ( \\texttt{src} - \\texttt{delta} )^T\\f]\n.   otherwise. The function is used to calculate the covariance matrix. With\n.   zero delta, it can be used as a faster substitute for general matrix\n.   product A\\*B when B=A'\n.   @param src input single-channel matrix. Note that unlike gemm, the\n.   function can multiply not only floating-point matrices.\n.   @param dst output square matrix.\n.   @param aTa Flag specifying the multiplication ordering. See the\n.   description below.\n.   @param delta Optional delta matrix subtracted from src before the\n.   multiplication. When the matrix is empty ( delta=noArray() ), it is\n.   assumed to be zero, that is, nothing is subtracted. If it has the same\n.   size as src , it is simply subtracted. Otherwise, it is \"repeated\" (see\n.   repeat ) to cover the full src and then subtracted. Type of the delta\n.   matrix, when it is not empty, must be the same as the type of created\n.   output matrix. See the dtype parameter description below.\n.   @param scale Optional scale factor for the matrix product.\n.   @param dtype Optional type of the output matrix. When it is negative,\n.   the output matrix will have the same type as src . Otherwise, it will be\n.   type=CV_MAT_DEPTH(dtype) that should be either CV_32F or CV_64F .\n.   @sa calcCovarMatrix, gemm, repeat, reduce"},
    {"multiply", (PyCFunction)pyopencv_cv_multiply, METH_VARARGS | METH_KEYWORDS, "multiply(src1, src2[, dst[, scale[, dtype]]]) -> dst\n.   @brief Calculates the per-element scaled product of two arrays.\n.   \n.   The function multiply calculates the per-element product of two arrays:\n.   \n.   \\f[\\texttt{dst} (I)= \\texttt{saturate} ( \\texttt{scale} \\cdot \\texttt{src1} (I)  \\cdot \\texttt{src2} (I))\\f]\n.   \n.   There is also a @ref MatrixExpressions -friendly variant of the first function. See Mat::mul .\n.   \n.   For a not-per-element matrix product, see gemm .\n.   \n.   @note Saturation is not applied when the output array has the depth\n.   CV_32S. You may even get result of an incorrect sign in the case of\n.   overflow.\n.   @param src1 first input array.\n.   @param src2 second input array of the same size and the same type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @param scale optional scale factor.\n.   @param dtype optional depth of the output array\n.   @sa add, subtract, divide, scaleAdd, addWeighted, accumulate, accumulateProduct, accumulateSquare,\n.   Mat::convertTo"},
    {"namedWindow", (PyCFunction)pyopencv_cv_namedWindow, METH_VARARGS | METH_KEYWORDS, "namedWindow(winname[, flags]) -> None\n.   @brief Creates a window.\n.   \n.   The function namedWindow creates a window that can be used as a placeholder for images and\n.   trackbars. Created windows are referred to by their names.\n.   \n.   If a window with the same name already exists, the function does nothing.\n.   \n.   You can call cv::destroyWindow or cv::destroyAllWindows to close the window and de-allocate any associated\n.   memory usage. For a simple program, you do not really have to call these functions because all the\n.   resources and windows of the application are closed automatically by the operating system upon exit.\n.   \n.   @note\n.   \n.   Qt backend supports additional flags:\n.   -   **WINDOW_NORMAL or WINDOW_AUTOSIZE:** WINDOW_NORMAL enables you to resize the\n.   window, whereas WINDOW_AUTOSIZE adjusts automatically the window size to fit the\n.   displayed image (see imshow ), and you cannot change the window size manually.\n.   -   **WINDOW_FREERATIO or WINDOW_KEEPRATIO:** WINDOW_FREERATIO adjusts the image\n.   with no respect to its ratio, whereas WINDOW_KEEPRATIO keeps the image ratio.\n.   -   **WINDOW_GUI_NORMAL or WINDOW_GUI_EXPANDED:** WINDOW_GUI_NORMAL is the old way to draw the window\n.   without statusbar and toolbar, whereas WINDOW_GUI_EXPANDED is a new enhanced GUI.\n.   By default, flags == WINDOW_AUTOSIZE | WINDOW_KEEPRATIO | WINDOW_GUI_EXPANDED\n.   \n.   @param winname Name of the window in the window caption that may be used as a window identifier.\n.   @param flags Flags of the window. The supported flags are: (cv::WindowFlags)"},
    {"norm", (PyCFunction)pyopencv_cv_norm, METH_VARARGS | METH_KEYWORDS, "norm(src1[, normType[, mask]]) -> retval\n.   @brief Calculates the  absolute norm of an array.\n.   \n.   This version of #norm calculates the absolute norm of src1. The type of norm to calculate is specified using #NormTypes.\n.   \n.   As example for one array consider the function \\f$r(x)= \\begin{pmatrix} x \\\\ 1-x \\end{pmatrix}, x \\in [-1;1]\\f$.\n.   The \\f$ L_{1}, L_{2} \\f$ and \\f$ L_{\\infty} \\f$ norm for the sample value \\f$r(-1) = \\begin{pmatrix} -1 \\\\ 2 \\end{pmatrix}\\f$\n.   is calculated as follows\n.   \\f{align*}\n.   \\| r(-1) \\|_{L_1} &= |-1| + |2| = 3 \\\\\n.   \\| r(-1) \\|_{L_2} &= \\sqrt{(-1)^{2} + (2)^{2}} = \\sqrt{5} \\\\\n.   \\| r(-1) \\|_{L_\\infty} &= \\max(|-1|,|2|) = 2\n.   \\f}\n.   and for \\f$r(0.5) = \\begin{pmatrix} 0.5 \\\\ 0.5 \\end{pmatrix}\\f$ the calculation is\n.   \\f{align*}\n.   \\| r(0.5) \\|_{L_1} &= |0.5| + |0.5| = 1 \\\\\n.   \\| r(0.5) \\|_{L_2} &= \\sqrt{(0.5)^{2} + (0.5)^{2}} = \\sqrt{0.5} \\\\\n.   \\| r(0.5) \\|_{L_\\infty} &= \\max(|0.5|,|0.5|) = 0.5.\n.   \\f}\n.   The following graphic shows all values for the three norm functions \\f$\\| r(x) \\|_{L_1}, \\| r(x) \\|_{L_2}\\f$ and \\f$\\| r(x) \\|_{L_\\infty}\\f$.\n.   It is notable that the \\f$ L_{1} \\f$ norm forms the upper and the \\f$ L_{\\infty} \\f$ norm forms the lower border for the example function \\f$ r(x) \\f$.\n.   ![Graphs for the different norm functions from the above example](pics/NormTypes_OneArray_1-2-INF.png)\n.   \n.   When the mask parameter is specified and it is not empty, the norm is\n.   \n.   If normType is not specified, #NORM_L2 is used.\n.   calculated only over the region specified by the mask.\n.   \n.   Multi-channel input arrays are treated as single-channel arrays, that is,\n.   the results for all channels are combined.\n.   \n.   Hamming norms can only be calculated with CV_8U depth arrays.\n.   \n.   @param src1 first input array.\n.   @param normType type of the norm (see #NormTypes).\n.   @param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.\n\n\n\nnorm(src1, src2[, normType[, mask]]) -> retval\n.   @brief Calculates an absolute difference norm or a relative difference norm.\n.   \n.   This version of cv::norm calculates the absolute difference norm\n.   or the relative difference norm of arrays src1 and src2.\n.   The type of norm to calculate is specified using #NormTypes.\n.   \n.   @param src1 first input array.\n.   @param src2 second input array of the same size and the same type as src1.\n.   @param normType type of the norm (see #NormTypes).\n.   @param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type."},
    {"normalize", (PyCFunction)pyopencv_cv_normalize, METH_VARARGS | METH_KEYWORDS, "normalize(src, dst[, alpha[, beta[, norm_type[, dtype[, mask]]]]]) -> dst\n.   @brief Normalizes the norm or value range of an array.\n.   \n.   The function cv::normalize normalizes scale and shift the input array elements so that\n.   \\f[\\| \\texttt{dst} \\| _{L_p}= \\texttt{alpha}\\f]\n.   (where p=Inf, 1 or 2) when normType=NORM_INF, NORM_L1, or NORM_L2, respectively; or so that\n.   \\f[\\min _I  \\texttt{dst} (I)= \\texttt{alpha} , \\, \\, \\max _I  \\texttt{dst} (I)= \\texttt{beta}\\f]\n.   \n.   when normType=NORM_MINMAX (for dense arrays only). The optional mask specifies a sub-array to be\n.   normalized. This means that the norm or min-n-max are calculated over the sub-array, and then this\n.   sub-array is modified to be normalized. If you want to only use the mask to calculate the norm or\n.   min-max but modify the whole array, you can use norm and Mat::convertTo.\n.   \n.   In case of sparse matrices, only the non-zero values are analyzed and transformed. Because of this,\n.   the range transformation for sparse matrices is not allowed since it can shift the zero level.\n.   \n.   Possible usage with some positive example data:\n.   @code{.cpp}\n.   vector<double> positiveData = { 2.0, 8.0, 10.0 };\n.   vector<double> normalizedData_l1, normalizedData_l2, normalizedData_inf, normalizedData_minmax;\n.   \n.   // Norm to probability (total count)\n.   // sum(numbers) = 20.0\n.   // 2.0      0.1     (2.0/20.0)\n.   // 8.0      0.4     (8.0/20.0)\n.   // 10.0     0.5     (10.0/20.0)\n.   normalize(positiveData, normalizedData_l1, 1.0, 0.0, NORM_L1);\n.   \n.   // Norm to unit vector: ||positiveData|| = 1.0\n.   // 2.0      0.15\n.   // 8.0      0.62\n.   // 10.0     0.77\n.   normalize(positiveData, normalizedData_l2, 1.0, 0.0, NORM_L2);\n.   \n.   // Norm to max element\n.   // 2.0      0.2     (2.0/10.0)\n.   // 8.0      0.8     (8.0/10.0)\n.   // 10.0     1.0     (10.0/10.0)\n.   normalize(positiveData, normalizedData_inf, 1.0, 0.0, NORM_INF);\n.   \n.   // Norm to range [0.0;1.0]\n.   // 2.0      0.0     (shift to left border)\n.   // 8.0      0.75    (6.0/8.0)\n.   // 10.0     1.0     (shift to right border)\n.   normalize(positiveData, normalizedData_minmax, 1.0, 0.0, NORM_MINMAX);\n.   @endcode\n.   \n.   @param src input array.\n.   @param dst output array of the same size as src .\n.   @param alpha norm value to normalize to or the lower range boundary in case of the range\n.   normalization.\n.   @param beta upper range boundary in case of the range normalization; it is not used for the norm\n.   normalization.\n.   @param norm_type normalization type (see cv::NormTypes).\n.   @param dtype when negative, the output array has the same type as src; otherwise, it has the same\n.   number of channels as src and the depth =CV_MAT_DEPTH(dtype).\n.   @param mask optional operation mask.\n.   @sa norm, Mat::convertTo, SparseMat::convertTo"},
    {"patchNaNs", (PyCFunction)pyopencv_cv_patchNaNs, METH_VARARGS | METH_KEYWORDS, "patchNaNs(a[, val]) -> a\n.   @brief converts NaN's to the given number"},
    {"pencilSketch", (PyCFunction)pyopencv_cv_pencilSketch, METH_VARARGS | METH_KEYWORDS, "pencilSketch(src[, dst1[, dst2[, sigma_s[, sigma_r[, shade_factor]]]]]) -> dst1, dst2\n.   @brief Pencil-like non-photorealistic line drawing\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst1 Output 8-bit 1-channel image.\n.   @param dst2 Output image with the same size and type as src.\n.   @param sigma_s Range between 0 to 200.\n.   @param sigma_r Range between 0 to 1.\n.   @param shade_factor Range between 0 to 0.1."},
    {"perspectiveTransform", (PyCFunction)pyopencv_cv_perspectiveTransform, METH_VARARGS | METH_KEYWORDS, "perspectiveTransform(src, m[, dst]) -> dst\n.   @brief Performs the perspective matrix transformation of vectors.\n.   \n.   The function cv::perspectiveTransform transforms every element of src by\n.   treating it as a 2D or 3D vector, in the following way:\n.   \\f[(x, y, z)  \\rightarrow (x'/w, y'/w, z'/w)\\f]\n.   where\n.   \\f[(x', y', z', w') =  \\texttt{mat} \\cdot \\begin{bmatrix} x & y & z & 1  \\end{bmatrix}\\f]\n.   and\n.   \\f[w =  \\fork{w'}{if \\(w' \\ne 0\\)}{\\infty}{otherwise}\\f]\n.   \n.   Here a 3D vector transformation is shown. In case of a 2D vector\n.   transformation, the z component is omitted.\n.   \n.   @note The function transforms a sparse set of 2D or 3D vectors. If you\n.   want to transform an image using perspective transformation, use\n.   warpPerspective . If you have an inverse problem, that is, you want to\n.   compute the most probable perspective transformation out of several\n.   pairs of corresponding points, you can use getPerspectiveTransform or\n.   findHomography .\n.   @param src input two-channel or three-channel floating-point array; each\n.   element is a 2D/3D vector to be transformed.\n.   @param dst output array of the same size and type as src.\n.   @param m 3x3 or 4x4 floating-point transformation matrix.\n.   @sa  transform, warpPerspective, getPerspectiveTransform, findHomography"},
    {"phase", (PyCFunction)pyopencv_cv_phase, METH_VARARGS | METH_KEYWORDS, "phase(x, y[, angle[, angleInDegrees]]) -> angle\n.   @brief Calculates the rotation angle of 2D vectors.\n.   \n.   The function cv::phase calculates the rotation angle of each 2D vector that\n.   is formed from the corresponding elements of x and y :\n.   \\f[\\texttt{angle} (I) =  \\texttt{atan2} ( \\texttt{y} (I), \\texttt{x} (I))\\f]\n.   \n.   The angle estimation accuracy is about 0.3 degrees. When x(I)=y(I)=0 ,\n.   the corresponding angle(I) is set to 0.\n.   @param x input floating-point array of x-coordinates of 2D vectors.\n.   @param y input array of y-coordinates of 2D vectors; it must have the\n.   same size and the same type as x.\n.   @param angle output array of vector angles; it has the same size and\n.   same type as x .\n.   @param angleInDegrees when true, the function calculates the angle in\n.   degrees, otherwise, they are measured in radians."},
    {"phaseCorrelate", (PyCFunction)pyopencv_cv_phaseCorrelate, METH_VARARGS | METH_KEYWORDS, "phaseCorrelate(src1, src2[, window]) -> retval, response\n.   @brief The function is used to detect translational shifts that occur between two images.\n.   \n.   The operation takes advantage of the Fourier shift theorem for detecting the translational shift in\n.   the frequency domain. It can be used for fast image registration as well as motion estimation. For\n.   more information please see <http://en.wikipedia.org/wiki/Phase_correlation>\n.   \n.   Calculates the cross-power spectrum of two supplied source arrays. The arrays are padded if needed\n.   with getOptimalDFTSize.\n.   \n.   The function performs the following equations:\n.   - First it applies a Hanning window (see <http://en.wikipedia.org/wiki/Hann_function>) to each\n.   image to remove possible edge effects. This window is cached until the array size changes to speed\n.   up processing time.\n.   - Next it computes the forward DFTs of each source array:\n.   \\f[\\mathbf{G}_a = \\mathcal{F}\\{src_1\\}, \\; \\mathbf{G}_b = \\mathcal{F}\\{src_2\\}\\f]\n.   where \\f$\\mathcal{F}\\f$ is the forward DFT.\n.   - It then computes the cross-power spectrum of each frequency domain array:\n.   \\f[R = \\frac{ \\mathbf{G}_a \\mathbf{G}_b^*}{|\\mathbf{G}_a \\mathbf{G}_b^*|}\\f]\n.   - Next the cross-correlation is converted back into the time domain via the inverse DFT:\n.   \\f[r = \\mathcal{F}^{-1}\\{R\\}\\f]\n.   - Finally, it computes the peak location and computes a 5x5 weighted centroid around the peak to\n.   achieve sub-pixel accuracy.\n.   \\f[(\\Delta x, \\Delta y) = \\texttt{weightedCentroid} \\{\\arg \\max_{(x, y)}\\{r\\}\\}\\f]\n.   - If non-zero, the response parameter is computed as the sum of the elements of r within the 5x5\n.   centroid around the peak location. It is normalized to a maximum of 1 (meaning there is a single\n.   peak) and will be smaller when there are multiple peaks.\n.   \n.   @param src1 Source floating point array (CV_32FC1 or CV_64FC1)\n.   @param src2 Source floating point array (CV_32FC1 or CV_64FC1)\n.   @param window Floating point array with windowing coefficients to reduce edge effects (optional).\n.   @param response Signal power within the 5x5 centroid around the peak, between 0 and 1 (optional).\n.   @returns detected phase shift (sub-pixel) between the two arrays.\n.   \n.   @sa dft, getOptimalDFTSize, idft, mulSpectrums createHanningWindow"},
    {"pointPolygonTest", (PyCFunction)pyopencv_cv_pointPolygonTest, METH_VARARGS | METH_KEYWORDS, "pointPolygonTest(contour, pt, measureDist) -> retval\n.   @brief Performs a point-in-contour test.\n.   \n.   The function determines whether the point is inside a contour, outside, or lies on an edge (or\n.   coincides with a vertex). It returns positive (inside), negative (outside), or zero (on an edge)\n.   value, correspondingly. When measureDist=false , the return value is +1, -1, and 0, respectively.\n.   Otherwise, the return value is a signed distance between the point and the nearest contour edge.\n.   \n.   See below a sample output of the function where each image pixel is tested against the contour:\n.   \n.   ![sample output](pics/pointpolygon.png)\n.   \n.   @param contour Input contour.\n.   @param pt Point tested against the contour.\n.   @param measureDist If true, the function estimates the signed distance from the point to the\n.   nearest contour edge. Otherwise, the function only checks if the point is inside a contour or not."},
    {"polarToCart", (PyCFunction)pyopencv_cv_polarToCart, METH_VARARGS | METH_KEYWORDS, "polarToCart(magnitude, angle[, x[, y[, angleInDegrees]]]) -> x, y\n.   @brief Calculates x and y coordinates of 2D vectors from their magnitude and angle.\n.   \n.   The function cv::polarToCart calculates the Cartesian coordinates of each 2D\n.   vector represented by the corresponding elements of magnitude and angle:\n.   \\f[\\begin{array}{l} \\texttt{x} (I) =  \\texttt{magnitude} (I) \\cos ( \\texttt{angle} (I)) \\\\ \\texttt{y} (I) =  \\texttt{magnitude} (I) \\sin ( \\texttt{angle} (I)) \\\\ \\end{array}\\f]\n.   \n.   The relative accuracy of the estimated coordinates is about 1e-6.\n.   @param magnitude input floating-point array of magnitudes of 2D vectors;\n.   it can be an empty matrix (=Mat()), in this case, the function assumes\n.   that all the magnitudes are =1; if it is not empty, it must have the\n.   same size and type as angle.\n.   @param angle input floating-point array of angles of 2D vectors.\n.   @param x output array of x-coordinates of 2D vectors; it has the same\n.   size and type as angle.\n.   @param y output array of y-coordinates of 2D vectors; it has the same\n.   size and type as angle.\n.   @param angleInDegrees when true, the input angles are measured in\n.   degrees, otherwise, they are measured in radians.\n.   @sa cartToPolar, magnitude, phase, exp, log, pow, sqrt"},
    {"polylines", (PyCFunction)pyopencv_cv_polylines, METH_VARARGS | METH_KEYWORDS, "polylines(img, pts, isClosed, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws several polygonal curves.\n.   \n.   @param img Image.\n.   @param pts Array of polygonal curves.\n.   @param isClosed Flag indicating whether the drawn polylines are closed or not. If they are closed,\n.   the function draws a line from the last vertex of each curve to its first vertex.\n.   @param color Polyline color.\n.   @param thickness Thickness of the polyline edges.\n.   @param lineType Type of the line segments. See #LineTypes\n.   @param shift Number of fractional bits in the vertex coordinates.\n.   \n.   The function cv::polylines draws one or more polygonal curves."},
    {"pow", (PyCFunction)pyopencv_cv_pow, METH_VARARGS | METH_KEYWORDS, "pow(src, power[, dst]) -> dst\n.   @brief Raises every array element to a power.\n.   \n.   The function cv::pow raises every element of the input array to power :\n.   \\f[\\texttt{dst} (I) =  \\fork{\\texttt{src}(I)^{power}}{if \\(\\texttt{power}\\) is integer}{|\\texttt{src}(I)|^{power}}{otherwise}\\f]\n.   \n.   So, for a non-integer power exponent, the absolute values of input array\n.   elements are used. However, it is possible to get true values for\n.   negative values using some extra operations. In the example below,\n.   computing the 5th root of array src shows:\n.   @code{.cpp}\n.   Mat mask = src < 0;\n.   pow(src, 1./5, dst);\n.   subtract(Scalar::all(0), dst, dst, mask);\n.   @endcode\n.   For some values of power, such as integer values, 0.5 and -0.5,\n.   specialized faster algorithms are used.\n.   \n.   Special values (NaN, Inf) are not handled.\n.   @param src input array.\n.   @param power exponent of power.\n.   @param dst output array of the same size and type as src.\n.   @sa sqrt, exp, log, cartToPolar, polarToCart"},
    {"preCornerDetect", (PyCFunction)pyopencv_cv_preCornerDetect, METH_VARARGS | METH_KEYWORDS, "preCornerDetect(src, ksize[, dst[, borderType]]) -> dst\n.   @brief Calculates a feature map for corner detection.\n.   \n.   The function calculates the complex spatial derivative-based function of the source image\n.   \n.   \\f[\\texttt{dst} = (D_x  \\texttt{src} )^2  \\cdot D_{yy}  \\texttt{src} + (D_y  \\texttt{src} )^2  \\cdot D_{xx}  \\texttt{src} - 2 D_x  \\texttt{src} \\cdot D_y  \\texttt{src} \\cdot D_{xy}  \\texttt{src}\\f]\n.   \n.   where \\f$D_x\\f$,\\f$D_y\\f$ are the first image derivatives, \\f$D_{xx}\\f$,\\f$D_{yy}\\f$ are the second image\n.   derivatives, and \\f$D_{xy}\\f$ is the mixed derivative.\n.   \n.   The corners can be found as local maximums of the functions, as shown below:\n.   @code\n.   Mat corners, dilated_corners;\n.   preCornerDetect(image, corners, 3);\n.   // dilation with 3x3 rectangular structuring element\n.   dilate(corners, dilated_corners, Mat(), 1);\n.   Mat corner_mask = corners == dilated_corners;\n.   @endcode\n.   \n.   @param src Source single-channel 8-bit of floating-point image.\n.   @param dst Output image that has the type CV_32F and the same size as src .\n.   @param ksize %Aperture size of the Sobel .\n.   @param borderType Pixel extrapolation method. See #BorderTypes."},
    {"projectPoints", (PyCFunction)pyopencv_cv_projectPoints, METH_VARARGS | METH_KEYWORDS, "projectPoints(objectPoints, rvec, tvec, cameraMatrix, distCoeffs[, imagePoints[, jacobian[, aspectRatio]]]) -> imagePoints, jacobian\n.   @brief Projects 3D points to an image plane.\n.   \n.   @param objectPoints Array of object points, 3xN/Nx3 1-channel or 1xN/Nx1 3-channel (or\n.   vector\\<Point3f\\> ), where N is the number of points in the view.\n.   @param rvec Rotation vector. See Rodrigues for details.\n.   @param tvec Translation vector.\n.   @param cameraMatrix Camera matrix \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. If the vector is empty, the zero distortion coefficients are assumed.\n.   @param imagePoints Output array of image points, 2xN/Nx2 1-channel or 1xN/Nx1 2-channel, or\n.   vector\\<Point2f\\> .\n.   @param jacobian Optional output 2Nx(10+\\<numDistCoeffs\\>) jacobian matrix of derivatives of image\n.   points with respect to components of the rotation vector, translation vector, focal lengths,\n.   coordinates of the principal point and the distortion coefficients. In the old interface different\n.   components of the jacobian are returned via different output parameters.\n.   @param aspectRatio Optional \"fixed aspect ratio\" parameter. If the parameter is not 0, the\n.   function assumes that the aspect ratio (*fx/fy*) is fixed and correspondingly adjusts the jacobian\n.   matrix.\n.   \n.   The function computes projections of 3D points to the image plane given intrinsic and extrinsic\n.   camera parameters. Optionally, the function computes Jacobians - matrices of partial derivatives of\n.   image points coordinates (as functions of all the input parameters) with respect to the particular\n.   parameters, intrinsic and/or extrinsic. The Jacobians are used during the global optimization in\n.   calibrateCamera, solvePnP, and stereoCalibrate . The function itself can also be used to compute a\n.   re-projection error given the current intrinsic and extrinsic parameters.\n.   \n.   @note By setting rvec=tvec=(0,0,0) or by setting cameraMatrix to a 3x3 identity matrix, or by\n.   passing zero distortion coefficients, you can get various useful partial cases of the function. This\n.   means that you can compute the distorted coordinates for a sparse set of points or apply a\n.   perspective transformation (and also compute the derivatives) in the ideal zero-distortion setup."},
    {"putText", (PyCFunction)pyopencv_cv_putText, METH_VARARGS | METH_KEYWORDS, "putText(img, text, org, fontFace, fontScale, color[, thickness[, lineType[, bottomLeftOrigin]]]) -> img\n.   @brief Draws a text string.\n.   \n.   The function cv::putText renders the specified text string in the image. Symbols that cannot be rendered\n.   using the specified font are replaced by question marks. See #getTextSize for a text rendering code\n.   example.\n.   \n.   @param img Image.\n.   @param text Text string to be drawn.\n.   @param org Bottom-left corner of the text string in the image.\n.   @param fontFace Font type, see #HersheyFonts.\n.   @param fontScale Font scale factor that is multiplied by the font-specific base size.\n.   @param color Text color.\n.   @param thickness Thickness of the lines used to draw a text.\n.   @param lineType Line type. See #LineTypes\n.   @param bottomLeftOrigin When true, the image data origin is at the bottom-left corner. Otherwise,\n.   it is at the top-left corner."},
    {"pyrDown", (PyCFunction)pyopencv_cv_pyrDown, METH_VARARGS | METH_KEYWORDS, "pyrDown(src[, dst[, dstsize[, borderType]]]) -> dst\n.   @brief Blurs an image and downsamples it.\n.   \n.   By default, size of the output image is computed as `Size((src.cols+1)/2, (src.rows+1)/2)`, but in\n.   any case, the following conditions should be satisfied:\n.   \n.   \\f[\\begin{array}{l} | \\texttt{dstsize.width} *2-src.cols| \\leq 2 \\\\ | \\texttt{dstsize.height} *2-src.rows| \\leq 2 \\end{array}\\f]\n.   \n.   The function performs the downsampling step of the Gaussian pyramid construction. First, it\n.   convolves the source image with the kernel:\n.   \n.   \\f[\\frac{1}{256} \\begin{bmatrix} 1 & 4 & 6 & 4 & 1  \\\\ 4 & 16 & 24 & 16 & 4  \\\\ 6 & 24 & 36 & 24 & 6  \\\\ 4 & 16 & 24 & 16 & 4  \\\\ 1 & 4 & 6 & 4 & 1 \\end{bmatrix}\\f]\n.   \n.   Then, it downsamples the image by rejecting even rows and columns.\n.   \n.   @param src input image.\n.   @param dst output image; it has the specified size and the same type as src.\n.   @param dstsize size of the output image.\n.   @param borderType Pixel extrapolation method, see #BorderTypes (#BORDER_CONSTANT isn't supported)"},
    {"pyrMeanShiftFiltering", (PyCFunction)pyopencv_cv_pyrMeanShiftFiltering, METH_VARARGS | METH_KEYWORDS, "pyrMeanShiftFiltering(src, sp, sr[, dst[, maxLevel[, termcrit]]]) -> dst\n.   @brief Performs initial step of meanshift segmentation of an image.\n.   \n.   The function implements the filtering stage of meanshift segmentation, that is, the output of the\n.   function is the filtered \"posterized\" image with color gradients and fine-grain texture flattened.\n.   At every pixel (X,Y) of the input image (or down-sized input image, see below) the function executes\n.   meanshift iterations, that is, the pixel (X,Y) neighborhood in the joint space-color hyperspace is\n.   considered:\n.   \n.   \\f[(x,y): X- \\texttt{sp} \\le x  \\le X+ \\texttt{sp} , Y- \\texttt{sp} \\le y  \\le Y+ \\texttt{sp} , ||(R,G,B)-(r,g,b)||   \\le \\texttt{sr}\\f]\n.   \n.   where (R,G,B) and (r,g,b) are the vectors of color components at (X,Y) and (x,y), respectively\n.   (though, the algorithm does not depend on the color space used, so any 3-component color space can\n.   be used instead). Over the neighborhood the average spatial value (X',Y') and average color vector\n.   (R',G',B') are found and they act as the neighborhood center on the next iteration:\n.   \n.   \\f[(X,Y)~(X',Y'), (R,G,B)~(R',G',B').\\f]\n.   \n.   After the iterations over, the color components of the initial pixel (that is, the pixel from where\n.   the iterations started) are set to the final value (average color at the last iteration):\n.   \n.   \\f[I(X,Y) <- (R*,G*,B*)\\f]\n.   \n.   When maxLevel \\> 0, the gaussian pyramid of maxLevel+1 levels is built, and the above procedure is\n.   run on the smallest layer first. After that, the results are propagated to the larger layer and the\n.   iterations are run again only on those pixels where the layer colors differ by more than sr from the\n.   lower-resolution layer of the pyramid. That makes boundaries of color regions sharper. Note that the\n.   results will be actually different from the ones obtained by running the meanshift procedure on the\n.   whole original image (i.e. when maxLevel==0).\n.   \n.   @param src The source 8-bit, 3-channel image.\n.   @param dst The destination image of the same format and the same size as the source.\n.   @param sp The spatial window radius.\n.   @param sr The color window radius.\n.   @param maxLevel Maximum level of the pyramid for the segmentation.\n.   @param termcrit Termination criteria: when to stop meanshift iterations."},
    {"pyrUp", (PyCFunction)pyopencv_cv_pyrUp, METH_VARARGS | METH_KEYWORDS, "pyrUp(src[, dst[, dstsize[, borderType]]]) -> dst\n.   @brief Upsamples an image and then blurs it.\n.   \n.   By default, size of the output image is computed as `Size(src.cols\\*2, (src.rows\\*2)`, but in any\n.   case, the following conditions should be satisfied:\n.   \n.   \\f[\\begin{array}{l} | \\texttt{dstsize.width} -src.cols*2| \\leq  ( \\texttt{dstsize.width}   \\mod  2)  \\\\ | \\texttt{dstsize.height} -src.rows*2| \\leq  ( \\texttt{dstsize.height}   \\mod  2) \\end{array}\\f]\n.   \n.   The function performs the upsampling step of the Gaussian pyramid construction, though it can\n.   actually be used to construct the Laplacian pyramid. First, it upsamples the source image by\n.   injecting even zero rows and columns and then convolves the result with the same kernel as in\n.   pyrDown multiplied by 4.\n.   \n.   @param src input image.\n.   @param dst output image. It has the specified size and the same type as src .\n.   @param dstsize size of the output image.\n.   @param borderType Pixel extrapolation method, see #BorderTypes (only #BORDER_DEFAULT is supported)"},
    {"randShuffle", (PyCFunction)pyopencv_cv_randShuffle, METH_VARARGS | METH_KEYWORDS, "randShuffle(dst[, iterFactor]) -> dst\n.   @brief Shuffles the array elements randomly.\n.   \n.   The function cv::randShuffle shuffles the specified 1D array by randomly choosing pairs of elements and\n.   swapping them. The number of such swap operations will be dst.rows\\*dst.cols\\*iterFactor .\n.   @param dst input/output numerical 1D array.\n.   @param iterFactor scale factor that determines the number of random swap operations (see the details\n.   below).\n.   @param rng optional random number generator used for shuffling; if it is zero, theRNG () is used\n.   instead.\n.   @sa RNG, sort"},
    {"randn", (PyCFunction)pyopencv_cv_randn, METH_VARARGS | METH_KEYWORDS, "randn(dst, mean, stddev) -> dst\n.   @brief Fills the array with normally distributed random numbers.\n.   \n.   The function cv::randn fills the matrix dst with normally distributed random numbers with the specified\n.   mean vector and the standard deviation matrix. The generated random numbers are clipped to fit the\n.   value range of the output array data type.\n.   @param dst output array of random numbers; the array must be pre-allocated and have 1 to 4 channels.\n.   @param mean mean value (expectation) of the generated random numbers.\n.   @param stddev standard deviation of the generated random numbers; it can be either a vector (in\n.   which case a diagonal standard deviation matrix is assumed) or a square matrix.\n.   @sa RNG, randu"},
    {"randu", (PyCFunction)pyopencv_cv_randu, METH_VARARGS | METH_KEYWORDS, "randu(dst, low, high) -> dst\n.   @brief Generates a single uniformly-distributed random number or an array of random numbers.\n.   \n.   Non-template variant of the function fills the matrix dst with uniformly-distributed\n.   random numbers from the specified range:\n.   \\f[\\texttt{low} _c  \\leq \\texttt{dst} (I)_c <  \\texttt{high} _c\\f]\n.   @param dst output array of random numbers; the array must be pre-allocated.\n.   @param low inclusive lower boundary of the generated random numbers.\n.   @param high exclusive upper boundary of the generated random numbers.\n.   @sa RNG, randn, theRNG"},
    {"recoverPose", (PyCFunction)pyopencv_cv_recoverPose, METH_VARARGS | METH_KEYWORDS, "recoverPose(E, points1, points2, cameraMatrix[, R[, t[, mask]]]) -> retval, R, t, mask\n.   @brief Recover relative camera rotation and translation from an estimated essential matrix and the\n.   corresponding points in two images, using cheirality check. Returns the number of inliers which pass\n.   the check.\n.   \n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param cameraMatrix Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera matrix.\n.   @param R Recovered relative rotation.\n.   @param t Recovered relative translation.\n.   @param mask Input/output mask for inliers in points1 and points2.\n.   :   If it is not empty, then it marks inliers in points1 and points2 for then given essential\n.   matrix E. Only these inliers will be used to recover pose. In the output mask only inliers\n.   which pass the cheirality check.\n.   This function decomposes an essential matrix using decomposeEssentialMat and then verifies possible\n.   pose hypotheses by doing cheirality check. The cheirality check basically means that the\n.   triangulated 3D points should have positive depth. Some details can be found in @cite Nister03 .\n.   \n.   This function can be used to process output E and mask from findEssentialMat. In this scenario,\n.   points1 and points2 are the same input for findEssentialMat. :\n.   @code\n.   // Example. Estimation of fundamental matrix using the RANSAC algorithm\n.   int point_count = 100;\n.   vector<Point2f> points1(point_count);\n.   vector<Point2f> points2(point_count);\n.   \n.   // initialize the points here ...\n.   for( int i = 0; i < point_count; i++ )\n.   {\n.   points1[i] = ...;\n.   points2[i] = ...;\n.   }\n.   \n.   // cametra matrix with both focal lengths = 1, and principal point = (0, 0)\n.   Mat cameraMatrix = Mat::eye(3, 3, CV_64F);\n.   \n.   Mat E, R, t, mask;\n.   \n.   E = findEssentialMat(points1, points2, cameraMatrix, RANSAC, 0.999, 1.0, mask);\n.   recoverPose(E, points1, points2, cameraMatrix, R, t, mask);\n.   @endcode\n\n\n\nrecoverPose(E, points1, points2[, R[, t[, focal[, pp[, mask]]]]]) -> retval, R, t, mask\n.   @overload\n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1 .\n.   @param R Recovered relative rotation.\n.   @param t Recovered relative translation.\n.   @param focal Focal length of the camera. Note that this function assumes that points1 and points2\n.   are feature points from cameras with same focal length and principal point.\n.   @param pp principal point of the camera.\n.   @param mask Input/output mask for inliers in points1 and points2.\n.   :   If it is not empty, then it marks inliers in points1 and points2 for then given essential\n.   matrix E. Only these inliers will be used to recover pose. In the output mask only inliers\n.   which pass the cheirality check.\n.   \n.   This function differs from the one above that it computes camera matrix from focal length and\n.   principal point:\n.   \n.   \\f[K =\n.   \\begin{bmatrix}\n.   f & 0 & x_{pp}  \\\\\n.   0 & f & y_{pp}  \\\\\n.   0 & 0 & 1\n.   \\end{bmatrix}\\f]\n\n\n\nrecoverPose(E, points1, points2, cameraMatrix, distanceThresh[, R[, t[, mask[, triangulatedPoints]]]]) -> retval, R, t, mask, triangulatedPoints\n.   @overload\n.   @param E The input essential matrix.\n.   @param points1 Array of N 2D points from the first image. The point coordinates should be\n.   floating-point (single or double precision).\n.   @param points2 Array of the second image points of the same size and format as points1.\n.   @param cameraMatrix Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   Note that this function assumes that points1 and points2 are feature points from cameras with the\n.   same camera matrix.\n.   @param R Recovered relative rotation.\n.   @param t Recovered relative translation.\n.   @param distanceThresh threshold distance which is used to filter out far away points (i.e. infinite points).\n.   @param mask Input/output mask for inliers in points1 and points2.\n.   :   If it is not empty, then it marks inliers in points1 and points2 for then given essential\n.   matrix E. Only these inliers will be used to recover pose. In the output mask only inliers\n.   which pass the cheirality check.\n.   @param triangulatedPoints 3d points which were reconstructed by triangulation."},
    {"rectangle", (PyCFunction)pyopencv_cv_rectangle, METH_VARARGS | METH_KEYWORDS, "rectangle(img, pt1, pt2, color[, thickness[, lineType[, shift]]]) -> img\n.   @brief Draws a simple, thick, or filled up-right rectangle.\n.   \n.   The function cv::rectangle draws a rectangle outline or a filled rectangle whose two opposite corners\n.   are pt1 and pt2.\n.   \n.   @param img Image.\n.   @param pt1 Vertex of the rectangle.\n.   @param pt2 Vertex of the rectangle opposite to pt1 .\n.   @param color Rectangle color or brightness (grayscale image).\n.   @param thickness Thickness of lines that make up the rectangle. Negative values, like #FILLED,\n.   mean that the function has to draw a filled rectangle.\n.   @param lineType Type of the line. See #LineTypes\n.   @param shift Number of fractional bits in the point coordinates."},
    {"rectify3Collinear", (PyCFunction)pyopencv_cv_rectify3Collinear, METH_VARARGS | METH_KEYWORDS, "rectify3Collinear(cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, cameraMatrix3, distCoeffs3, imgpt1, imgpt3, imageSize, R12, T12, R13, T13, alpha, newImgSize, flags[, R1[, R2[, R3[, P1[, P2[, P3[, Q]]]]]]]) -> retval, R1, R2, R3, P1, P2, P3, Q, roi1, roi2\n."},
    {"reduce", (PyCFunction)pyopencv_cv_reduce, METH_VARARGS | METH_KEYWORDS, "reduce(src, dim, rtype[, dst[, dtype]]) -> dst\n.   @brief Reduces a matrix to a vector.\n.   \n.   The function #reduce reduces the matrix to a vector by treating the matrix rows/columns as a set of\n.   1D vectors and performing the specified operation on the vectors until a single row/column is\n.   obtained. For example, the function can be used to compute horizontal and vertical projections of a\n.   raster image. In case of #REDUCE_MAX and #REDUCE_MIN , the output image should have the same type as the source one.\n.   In case of #REDUCE_SUM and #REDUCE_AVG , the output may have a larger element bit-depth to preserve accuracy.\n.   And multi-channel arrays are also supported in these two reduction modes.\n.   \n.   The following code demonstrates its usage for a single channel matrix.\n.   @snippet snippets/core_reduce.cpp example\n.   \n.   And the following code demonstrates its usage for a two-channel matrix.\n.   @snippet snippets/core_reduce.cpp example2\n.   \n.   @param src input 2D matrix.\n.   @param dst output vector. Its size and type is defined by dim and dtype parameters.\n.   @param dim dimension index along which the matrix is reduced. 0 means that the matrix is reduced to\n.   a single row. 1 means that the matrix is reduced to a single column.\n.   @param rtype reduction operation that could be one of #ReduceTypes\n.   @param dtype when negative, the output vector will have the same type as the input matrix,\n.   otherwise, its type will be CV_MAKE_TYPE(CV_MAT_DEPTH(dtype), src.channels()).\n.   @sa repeat"},
    {"remap", (PyCFunction)pyopencv_cv_remap, METH_VARARGS | METH_KEYWORDS, "remap(src, map1, map2, interpolation[, dst[, borderMode[, borderValue]]]) -> dst\n.   @brief Applies a generic geometrical transformation to an image.\n.   \n.   The function remap transforms the source image using the specified map:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} (map_x(x,y),map_y(x,y))\\f]\n.   \n.   where values of pixels with non-integer coordinates are computed using one of available\n.   interpolation methods. \\f$map_x\\f$ and \\f$map_y\\f$ can be encoded as separate floating-point maps\n.   in \\f$map_1\\f$ and \\f$map_2\\f$ respectively, or interleaved floating-point maps of \\f$(x,y)\\f$ in\n.   \\f$map_1\\f$, or fixed-point maps created by using convertMaps. The reason you might want to\n.   convert from floating to fixed-point representations of a map is that they can yield much faster\n.   (\\~2x) remapping operations. In the converted case, \\f$map_1\\f$ contains pairs (cvFloor(x),\n.   cvFloor(y)) and \\f$map_2\\f$ contains indices in a table of interpolation coefficients.\n.   \n.   This function cannot operate in-place.\n.   \n.   @param src Source image.\n.   @param dst Destination image. It has the same size as map1 and the same type as src .\n.   @param map1 The first map of either (x,y) points or just x values having the type CV_16SC2 ,\n.   CV_32FC1, or CV_32FC2. See convertMaps for details on converting a floating point\n.   representation to fixed-point for speed.\n.   @param map2 The second map of y values having the type CV_16UC1, CV_32FC1, or none (empty map\n.   if map1 is (x,y) points), respectively.\n.   @param interpolation Interpolation method (see #InterpolationFlags). The method #INTER_AREA is\n.   not supported by this function.\n.   @param borderMode Pixel extrapolation method (see #BorderTypes). When\n.   borderMode=#BORDER_TRANSPARENT, it means that the pixels in the destination image that\n.   corresponds to the \"outliers\" in the source image are not modified by the function.\n.   @param borderValue Value used in case of a constant border. By default, it is 0.\n.   @note\n.   Due to current implementation limitations the size of an input and output images should be less than 32767x32767."},
    {"repeat", (PyCFunction)pyopencv_cv_repeat, METH_VARARGS | METH_KEYWORDS, "repeat(src, ny, nx[, dst]) -> dst\n.   @brief Fills the output array with repeated copies of the input array.\n.   \n.   The function cv::repeat duplicates the input array one or more times along each of the two axes:\n.   \\f[\\texttt{dst} _{ij}= \\texttt{src} _{i\\mod src.rows, \\; j\\mod src.cols }\\f]\n.   The second variant of the function is more convenient to use with @ref MatrixExpressions.\n.   @param src input array to replicate.\n.   @param ny Flag to specify how many times the `src` is repeated along the\n.   vertical axis.\n.   @param nx Flag to specify how many times the `src` is repeated along the\n.   horizontal axis.\n.   @param dst output array of the same type as `src`.\n.   @sa cv::reduce"},
    {"reprojectImageTo3D", (PyCFunction)pyopencv_cv_reprojectImageTo3D, METH_VARARGS | METH_KEYWORDS, "reprojectImageTo3D(disparity, Q[, _3dImage[, handleMissingValues[, ddepth]]]) -> _3dImage\n.   @brief Reprojects a disparity image to 3D space.\n.   \n.   @param disparity Input single-channel 8-bit unsigned, 16-bit signed, 32-bit signed or 32-bit\n.   floating-point disparity image. If 16-bit signed format is used, the values are assumed to have no\n.   fractional bits.\n.   @param _3dImage Output 3-channel floating-point image of the same size as disparity . Each\n.   element of _3dImage(x,y) contains 3D coordinates of the point (x,y) computed from the disparity\n.   map.\n.   @param Q \\f$4 \\times 4\\f$ perspective transformation matrix that can be obtained with stereoRectify.\n.   @param handleMissingValues Indicates, whether the function should handle missing values (i.e.\n.   points where the disparity was not computed). If handleMissingValues=true, then pixels with the\n.   minimal disparity that corresponds to the outliers (see StereoMatcher::compute ) are transformed\n.   to 3D points with a very large Z value (currently set to 10000).\n.   @param ddepth The optional output array depth. If it is -1, the output image will have CV_32F\n.   depth. ddepth can also be set to CV_16S, CV_32S or CV_32F.\n.   \n.   The function transforms a single-channel disparity map to a 3-channel image representing a 3D\n.   surface. That is, for each pixel (x,y) and the corresponding disparity d=disparity(x,y) , it\n.   computes:\n.   \n.   \\f[\\begin{array}{l} [X \\; Y \\; Z \\; W]^T =  \\texttt{Q} *[x \\; y \\; \\texttt{disparity} (x,y) \\; 1]^T  \\\\ \\texttt{\\_3dImage} (x,y) = (X/W, \\; Y/W, \\; Z/W) \\end{array}\\f]\n.   \n.   The matrix Q can be an arbitrary \\f$4 \\times 4\\f$ matrix (for example, the one computed by\n.   stereoRectify). To reproject a sparse set of points {(x,y,d),...} to 3D space, use\n.   perspectiveTransform ."},
    {"resize", (PyCFunction)pyopencv_cv_resize, METH_VARARGS | METH_KEYWORDS, "resize(src, dsize[, dst[, fx[, fy[, interpolation]]]]) -> dst\n.   @brief Resizes an image.\n.   \n.   The function resize resizes the image src down to or up to the specified size. Note that the\n.   initial dst type or size are not taken into account. Instead, the size and type are derived from\n.   the `src`,`dsize`,`fx`, and `fy`. If you want to resize src so that it fits the pre-created dst,\n.   you may call the function as follows:\n.   @code\n.   // explicitly specify dsize=dst.size(); fx and fy will be computed from that.\n.   resize(src, dst, dst.size(), 0, 0, interpolation);\n.   @endcode\n.   If you want to decimate the image by factor of 2 in each direction, you can call the function this\n.   way:\n.   @code\n.   // specify fx and fy and let the function compute the destination image size.\n.   resize(src, dst, Size(), 0.5, 0.5, interpolation);\n.   @endcode\n.   To shrink an image, it will generally look best with #INTER_AREA interpolation, whereas to\n.   enlarge an image, it will generally look best with c#INTER_CUBIC (slow) or #INTER_LINEAR\n.   (faster but still looks OK).\n.   \n.   @param src input image.\n.   @param dst output image; it has the size dsize (when it is non-zero) or the size computed from\n.   src.size(), fx, and fy; the type of dst is the same as of src.\n.   @param dsize output image size; if it equals zero, it is computed as:\n.   \\f[\\texttt{dsize = Size(round(fx*src.cols), round(fy*src.rows))}\\f]\n.   Either dsize or both fx and fy must be non-zero.\n.   @param fx scale factor along the horizontal axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.width/src.cols}\\f]\n.   @param fy scale factor along the vertical axis; when it equals 0, it is computed as\n.   \\f[\\texttt{(double)dsize.height/src.rows}\\f]\n.   @param interpolation interpolation method, see #InterpolationFlags\n.   \n.   @sa  warpAffine, warpPerspective, remap"},
    {"resizeWindow", (PyCFunction)pyopencv_cv_resizeWindow, METH_VARARGS | METH_KEYWORDS, "resizeWindow(winname, width, height) -> None\n.   @brief Resizes window to the specified size\n.   \n.   @note\n.   \n.   -   The specified window size is for the image area. Toolbars are not counted.\n.   -   Only windows created without cv::WINDOW_AUTOSIZE flag can be resized.\n.   \n.   @param winname Window name.\n.   @param width The new window width.\n.   @param height The new window height.\n\n\n\nresizeWindow(winname, size) -> None\n.   @overload\n.   @param winname Window name.\n.   @param size The new window size."},
    {"rotate", (PyCFunction)pyopencv_cv_rotate, METH_VARARGS | METH_KEYWORDS, "rotate(src, rotateCode[, dst]) -> dst\n.   @brief Rotates a 2D array in multiples of 90 degrees.\n.   The function rotate rotates the array in one of three different ways:\n.   *   Rotate by 90 degrees clockwise (rotateCode = ROTATE_90).\n.   *   Rotate by 180 degrees clockwise (rotateCode = ROTATE_180).\n.   *   Rotate by 270 degrees clockwise (rotateCode = ROTATE_270).\n.   @param src input array.\n.   @param dst output array of the same type as src.  The size is the same with ROTATE_180,\n.   and the rows and cols are switched for ROTATE_90 and ROTATE_270.\n.   @param rotateCode an enum to specify how to rotate the array; see the enum RotateFlags\n.   @sa transpose , repeat , completeSymm, flip, RotateFlags"},
    {"rotatedRectangleIntersection", (PyCFunction)pyopencv_cv_rotatedRectangleIntersection, METH_VARARGS | METH_KEYWORDS, "rotatedRectangleIntersection(rect1, rect2[, intersectingRegion]) -> retval, intersectingRegion\n.   @brief Finds out if there is any intersection between two rotated rectangles.\n.   \n.   If there is then the vertices of the intersecting region are returned as well.\n.   \n.   Below are some examples of intersection configurations. The hatched pattern indicates the\n.   intersecting region and the red vertices are returned by the function.\n.   \n.   ![intersection examples](pics/intersection.png)\n.   \n.   @param rect1 First rectangle\n.   @param rect2 Second rectangle\n.   @param intersectingRegion The output array of the vertices of the intersecting region. It returns\n.   at most 8 vertices. Stored as std::vector\\<cv::Point2f\\> or cv::Mat as Mx1 of type CV_32FC2.\n.   @returns One of #RectanglesIntersectTypes"},
    {"sampsonDistance", (PyCFunction)pyopencv_cv_sampsonDistance, METH_VARARGS | METH_KEYWORDS, "sampsonDistance(pt1, pt2, F) -> retval\n.   @brief Calculates the Sampson Distance between two points.\n.   \n.   The function cv::sampsonDistance calculates and returns the first order approximation of the geometric error as:\n.   \\f[\n.   sd( \\texttt{pt1} , \\texttt{pt2} )=\n.   \\frac{(\\texttt{pt2}^t \\cdot \\texttt{F} \\cdot \\texttt{pt1})^2}\n.   {((\\texttt{F} \\cdot \\texttt{pt1})(0))^2 +\n.   ((\\texttt{F} \\cdot \\texttt{pt1})(1))^2 +\n.   ((\\texttt{F}^t \\cdot \\texttt{pt2})(0))^2 +\n.   ((\\texttt{F}^t \\cdot \\texttt{pt2})(1))^2}\n.   \\f]\n.   The fundamental matrix may be calculated using the cv::findFundamentalMat function. See @cite HartleyZ00 11.4.3 for details.\n.   @param pt1 first homogeneous 2d point\n.   @param pt2 second homogeneous 2d point\n.   @param F fundamental matrix\n.   @return The computed Sampson distance."},
    {"scaleAdd", (PyCFunction)pyopencv_cv_scaleAdd, METH_VARARGS | METH_KEYWORDS, "scaleAdd(src1, alpha, src2[, dst]) -> dst\n.   @brief Calculates the sum of a scaled array and another array.\n.   \n.   The function scaleAdd is one of the classical primitive linear algebra operations, known as DAXPY\n.   or SAXPY in [BLAS](http://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms). It calculates\n.   the sum of a scaled array and another array:\n.   \\f[\\texttt{dst} (I)= \\texttt{scale} \\cdot \\texttt{src1} (I) +  \\texttt{src2} (I)\\f]\n.   The function can also be emulated with a matrix expression, for example:\n.   @code{.cpp}\n.   Mat A(3, 3, CV_64F);\n.   ...\n.   A.row(0) = A.row(1)*2 + A.row(2);\n.   @endcode\n.   @param src1 first input array.\n.   @param alpha scale factor for the first array.\n.   @param src2 second input array of the same size and type as src1.\n.   @param dst output array of the same size and type as src1.\n.   @sa add, addWeighted, subtract, Mat::dot, Mat::convertTo"},
    {"seamlessClone", (PyCFunction)pyopencv_cv_seamlessClone, METH_VARARGS | METH_KEYWORDS, "seamlessClone(src, dst, mask, p, flags[, blend]) -> blend\n.   @brief Image editing tasks concern either global changes (color/intensity corrections, filters,\n.   deformations) or local changes concerned to a selection. Here we are interested in achieving local\n.   changes, ones that are restricted to a region manually selected (ROI), in a seamless and effortless\n.   manner. The extent of the changes ranges from slight distortions to complete replacement by novel\n.   content @cite PM03 .\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param p Point in dst image where object is placed.\n.   @param blend Output image with the same size and type as dst.\n.   @param flags Cloning method that could be one of the following:\n.   -   **NORMAL_CLONE** The power of the method is fully expressed when inserting objects with\n.   complex outlines into a new background\n.   -   **MIXED_CLONE** The classic method, color-based selection and alpha masking might be time\n.   consuming and often leaves an undesirable halo. Seamless cloning, even averaged with the\n.   original image, is not effective. Mixed seamless cloning based on a loose selection proves\n.   effective.\n.   -   **MONOCHROME_TRANSFER** Monochrome transfer allows the user to easily replace certain features of\n.   one object by alternative features."},
    {"selectROI", (PyCFunction)pyopencv_cv_selectROI, METH_VARARGS | METH_KEYWORDS, "selectROI(windowName, img[, showCrosshair[, fromCenter]]) -> retval\n.   @brief Selects ROI on the given image.\n.   Function creates a window and allows user to select a ROI using mouse.\n.   Controls: use `space` or `enter` to finish selection, use key `c` to cancel selection (function will return the zero cv::Rect).\n.   \n.   @param windowName name of the window where selection process will be shown.\n.   @param img image to select a ROI.\n.   @param showCrosshair if true crosshair of selection rectangle will be shown.\n.   @param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of\n.   selection rectangle will correspont to the initial mouse position.\n.   @return selected ROI or empty rect if selection canceled.\n.   \n.   @note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).\n.   After finish of work an empty callback will be set for the used window.\n\n\n\nselectROI(img[, showCrosshair[, fromCenter]]) -> retval\n.   @overload"},
    {"selectROIs", (PyCFunction)pyopencv_cv_selectROIs, METH_VARARGS | METH_KEYWORDS, "selectROIs(windowName, img[, showCrosshair[, fromCenter]]) -> boundingBoxes\n.   @brief Selects ROIs on the given image.\n.   Function creates a window and allows user to select a ROIs using mouse.\n.   Controls: use `space` or `enter` to finish current selection and start a new one,\n.   use `esc` to terminate multiple ROI selection process.\n.   \n.   @param windowName name of the window where selection process will be shown.\n.   @param img image to select a ROI.\n.   @param boundingBoxes selected ROIs.\n.   @param showCrosshair if true crosshair of selection rectangle will be shown.\n.   @param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of\n.   selection rectangle will correspont to the initial mouse position.\n.   \n.   @note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).\n.   After finish of work an empty callback will be set for the used window."},
    {"sepFilter2D", (PyCFunction)pyopencv_cv_sepFilter2D, METH_VARARGS | METH_KEYWORDS, "sepFilter2D(src, ddepth, kernelX, kernelY[, dst[, anchor[, delta[, borderType]]]]) -> dst\n.   @brief Applies a separable linear filter to an image.\n.   \n.   The function applies a separable linear filter to the image. That is, first, every row of src is\n.   filtered with the 1D kernel kernelX. Then, every column of the result is filtered with the 1D\n.   kernel kernelY. The final result shifted by delta is stored in dst .\n.   \n.   @param src Source image.\n.   @param dst Destination image of the same size and the same number of channels as src .\n.   @param ddepth Destination image depth, see @ref filter_depths \"combinations\"\n.   @param kernelX Coefficients for filtering each row.\n.   @param kernelY Coefficients for filtering each column.\n.   @param anchor Anchor position within the kernel. The default value \\f$(-1,-1)\\f$ means that the anchor\n.   is at the kernel center.\n.   @param delta Value added to the filtered results before storing them.\n.   @param borderType Pixel extrapolation method, see #BorderTypes\n.   @sa  filter2D, Sobel, GaussianBlur, boxFilter, blur"},
    {"setIdentity", (PyCFunction)pyopencv_cv_setIdentity, METH_VARARGS | METH_KEYWORDS, "setIdentity(mtx[, s]) -> mtx\n.   @brief Initializes a scaled identity matrix.\n.   \n.   The function cv::setIdentity initializes a scaled identity matrix:\n.   \\f[\\texttt{mtx} (i,j)= \\fork{\\texttt{value}}{ if \\(i=j\\)}{0}{otherwise}\\f]\n.   \n.   The function can also be emulated using the matrix initializers and the\n.   matrix expressions:\n.   @code\n.   Mat A = Mat::eye(4, 3, CV_32F)*5;\n.   // A will be set to [[5, 0, 0], [0, 5, 0], [0, 0, 5], [0, 0, 0]]\n.   @endcode\n.   @param mtx matrix to initialize (not necessarily square).\n.   @param s value to assign to diagonal elements.\n.   @sa Mat::zeros, Mat::ones, Mat::setTo, Mat::operator="},
    {"setNumThreads", (PyCFunction)pyopencv_cv_setNumThreads, METH_VARARGS | METH_KEYWORDS, "setNumThreads(nthreads) -> None\n.   @brief OpenCV will try to set the number of threads for the next parallel region.\n.   \n.   If threads == 0, OpenCV will disable threading optimizations and run all it's functions\n.   sequentially. Passing threads \\< 0 will reset threads number to system default. This function must\n.   be called outside of parallel region.\n.   \n.   OpenCV will try to run its functions with specified threads number, but some behaviour differs from\n.   framework:\n.   -   `TBB` - User-defined parallel constructions will run with the same threads number, if\n.   another is not specified. If later on user creates his own scheduler, OpenCV will use it.\n.   -   `OpenMP` - No special defined behaviour.\n.   -   `Concurrency` - If threads == 1, OpenCV will disable threading optimizations and run its\n.   functions sequentially.\n.   -   `GCD` - Supports only values \\<= 0.\n.   -   `C=` - No special defined behaviour.\n.   @param nthreads Number of threads used by OpenCV.\n.   @sa getNumThreads, getThreadNum"},
    {"setRNGSeed", (PyCFunction)pyopencv_cv_setRNGSeed, METH_VARARGS | METH_KEYWORDS, "setRNGSeed(seed) -> None\n.   @brief Sets state of default random number generator.\n.   \n.   The function cv::setRNGSeed sets state of default random number generator to custom value.\n.   @param seed new state for default random number generator\n.   @sa RNG, randu, randn"},
    {"setTrackbarMax", (PyCFunction)pyopencv_cv_setTrackbarMax, METH_VARARGS | METH_KEYWORDS, "setTrackbarMax(trackbarname, winname, maxval) -> None\n.   @brief Sets the trackbar maximum position.\n.   \n.   The function sets the maximum position of the specified trackbar in the specified window.\n.   \n.   @note\n.   \n.   [__Qt Backend Only__] winname can be empty (or NULL) if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param maxval New maximum position."},
    {"setTrackbarMin", (PyCFunction)pyopencv_cv_setTrackbarMin, METH_VARARGS | METH_KEYWORDS, "setTrackbarMin(trackbarname, winname, minval) -> None\n.   @brief Sets the trackbar minimum position.\n.   \n.   The function sets the minimum position of the specified trackbar in the specified window.\n.   \n.   @note\n.   \n.   [__Qt Backend Only__] winname can be empty (or NULL) if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param minval New minimum position."},
    {"setTrackbarPos", (PyCFunction)pyopencv_cv_setTrackbarPos, METH_VARARGS | METH_KEYWORDS, "setTrackbarPos(trackbarname, winname, pos) -> None\n.   @brief Sets the trackbar position.\n.   \n.   The function sets the position of the specified trackbar in the specified window.\n.   \n.   @note\n.   \n.   [__Qt Backend Only__] winname can be empty (or NULL) if the trackbar is attached to the control\n.   panel.\n.   \n.   @param trackbarname Name of the trackbar.\n.   @param winname Name of the window that is the parent of trackbar.\n.   @param pos New position."},
    {"setUseOpenVX", (PyCFunction)pyopencv_cv_setUseOpenVX, METH_VARARGS | METH_KEYWORDS, "setUseOpenVX(flag) -> None\n."},
    {"setUseOptimized", (PyCFunction)pyopencv_cv_setUseOptimized, METH_VARARGS | METH_KEYWORDS, "setUseOptimized(onoff) -> None\n.   @brief Enables or disables the optimized code.\n.   \n.   The function can be used to dynamically turn on and off optimized code (code that uses SSE2, AVX,\n.   and other instructions on the platforms that support it). It sets a global flag that is further\n.   checked by OpenCV functions. Since the flag is not checked in the inner OpenCV loops, it is only\n.   safe to call the function on the very top level in your application where you can be sure that no\n.   other OpenCV function is currently executed.\n.   \n.   By default, the optimized code is enabled unless you disable it in CMake. The current status can be\n.   retrieved using useOptimized.\n.   @param onoff The boolean flag specifying whether the optimized code should be used (onoff=true)\n.   or not (onoff=false)."},
    {"setWindowProperty", (PyCFunction)pyopencv_cv_setWindowProperty, METH_VARARGS | METH_KEYWORDS, "setWindowProperty(winname, prop_id, prop_value) -> None\n.   @brief Changes parameters of a window dynamically.\n.   \n.   The function setWindowProperty enables changing properties of a window.\n.   \n.   @param winname Name of the window.\n.   @param prop_id Window property to edit. The supported operation flags are: (cv::WindowPropertyFlags)\n.   @param prop_value New value of the window property. The supported flags are: (cv::WindowFlags)"},
    {"setWindowTitle", (PyCFunction)pyopencv_cv_setWindowTitle, METH_VARARGS | METH_KEYWORDS, "setWindowTitle(winname, title) -> None\n.   @brief Updates window title\n.   @param winname Name of the window.\n.   @param title New title."},
    {"solve", (PyCFunction)pyopencv_cv_solve, METH_VARARGS | METH_KEYWORDS, "solve(src1, src2[, dst[, flags]]) -> retval, dst\n.   @brief Solves one or more linear systems or least-squares problems.\n.   \n.   The function cv::solve solves a linear system or least-squares problem (the\n.   latter is possible with SVD or QR methods, or by specifying the flag\n.   #DECOMP_NORMAL ):\n.   \\f[\\texttt{dst} =  \\arg \\min _X \\| \\texttt{src1} \\cdot \\texttt{X} -  \\texttt{src2} \\|\\f]\n.   \n.   If #DECOMP_LU or #DECOMP_CHOLESKY method is used, the function returns 1\n.   if src1 (or \\f$\\texttt{src1}^T\\texttt{src1}\\f$ ) is non-singular. Otherwise,\n.   it returns 0. In the latter case, dst is not valid. Other methods find a\n.   pseudo-solution in case of a singular left-hand side part.\n.   \n.   @note If you want to find a unity-norm solution of an under-defined\n.   singular system \\f$\\texttt{src1}\\cdot\\texttt{dst}=0\\f$ , the function solve\n.   will not do the work. Use SVD::solveZ instead.\n.   \n.   @param src1 input matrix on the left-hand side of the system.\n.   @param src2 input matrix on the right-hand side of the system.\n.   @param dst output solution.\n.   @param flags solution (matrix inversion) method (#DecompTypes)\n.   @sa invert, SVD, eigen"},
    {"solveCubic", (PyCFunction)pyopencv_cv_solveCubic, METH_VARARGS | METH_KEYWORDS, "solveCubic(coeffs[, roots]) -> retval, roots\n.   @brief Finds the real roots of a cubic equation.\n.   \n.   The function solveCubic finds the real roots of a cubic equation:\n.   -   if coeffs is a 4-element vector:\n.   \\f[\\texttt{coeffs} [0] x^3 +  \\texttt{coeffs} [1] x^2 +  \\texttt{coeffs} [2] x +  \\texttt{coeffs} [3] = 0\\f]\n.   -   if coeffs is a 3-element vector:\n.   \\f[x^3 +  \\texttt{coeffs} [0] x^2 +  \\texttt{coeffs} [1] x +  \\texttt{coeffs} [2] = 0\\f]\n.   \n.   The roots are stored in the roots array.\n.   @param coeffs equation coefficients, an array of 3 or 4 elements.\n.   @param roots output array of real roots that has 1 or 3 elements.\n.   @return number of real roots. It can be 0, 1 or 2."},
    {"solveLP", (PyCFunction)pyopencv_cv_solveLP, METH_VARARGS | METH_KEYWORDS, "solveLP(Func, Constr, z) -> retval\n.   @brief Solve given (non-integer) linear programming problem using the Simplex Algorithm (Simplex Method).\n.   \n.   What we mean here by \"linear programming problem\" (or LP problem, for short) can be formulated as:\n.   \n.   \\f[\\mbox{Maximize } c\\cdot x\\\\\n.   \\mbox{Subject to:}\\\\\n.   Ax\\leq b\\\\\n.   x\\geq 0\\f]\n.   \n.   Where \\f$c\\f$ is fixed `1`-by-`n` row-vector, \\f$A\\f$ is fixed `m`-by-`n` matrix, \\f$b\\f$ is fixed `m`-by-`1`\n.   column vector and \\f$x\\f$ is an arbitrary `n`-by-`1` column vector, which satisfies the constraints.\n.   \n.   Simplex algorithm is one of many algorithms that are designed to handle this sort of problems\n.   efficiently. Although it is not optimal in theoretical sense (there exist algorithms that can solve\n.   any problem written as above in polynomial time, while simplex method degenerates to exponential\n.   time for some special cases), it is well-studied, easy to implement and is shown to work well for\n.   real-life purposes.\n.   \n.   The particular implementation is taken almost verbatim from **Introduction to Algorithms, third\n.   edition** by T. H. Cormen, C. E. Leiserson, R. L. Rivest and Clifford Stein. In particular, the\n.   Bland's rule <http://en.wikipedia.org/wiki/Bland%27s_rule> is used to prevent cycling.\n.   \n.   @param Func This row-vector corresponds to \\f$c\\f$ in the LP problem formulation (see above). It should\n.   contain 32- or 64-bit floating point numbers. As a convenience, column-vector may be also submitted,\n.   in the latter case it is understood to correspond to \\f$c^T\\f$.\n.   @param Constr `m`-by-`n+1` matrix, whose rightmost column corresponds to \\f$b\\f$ in formulation above\n.   and the remaining to \\f$A\\f$. It should contain 32- or 64-bit floating point numbers.\n.   @param z The solution will be returned here as a column-vector - it corresponds to \\f$c\\f$ in the\n.   formulation above. It will contain 64-bit floating point numbers.\n.   @return One of cv::SolveLPResult"},
    {"solveP3P", (PyCFunction)pyopencv_cv_solveP3P, METH_VARARGS | METH_KEYWORDS, "solveP3P(objectPoints, imagePoints, cameraMatrix, distCoeffs, flags[, rvecs[, tvecs]]) -> retval, rvecs, tvecs\n.   @brief Finds an object pose from 3 3D-2D point correspondences.\n.   \n.   @param objectPoints Array of object points in the object coordinate space, 3x3 1-channel or\n.   1x3/3x1 3-channel. vector\\<Point3f\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, 3x2 1-channel or 1x3/3x1 2-channel.\n.   vector\\<Point2f\\> can be also passed here.\n.   @param cameraMatrix Input camera matrix \\f$A = \\vecthreethree{fx}{0}{cx}{0}{fy}{cy}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvecs Output rotation vectors (see Rodrigues ) that, together with tvecs , brings points from\n.   the model coordinate system to the camera coordinate system. A P3P problem has up to 4 solutions.\n.   @param tvecs Output translation vectors.\n.   @param flags Method for solving a P3P problem:\n.   -   **SOLVEPNP_P3P** Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang\n.   \"Complete Solution Classification for the Perspective-Three-Point Problem\" (@cite gao2003complete).\n.   -   **SOLVEPNP_AP3P** Method is based on the paper of Tong Ke and Stergios I. Roumeliotis.\n.   \"An Efficient Algebraic Solution to the Perspective-Three-Point Problem\" (@cite Ke17).\n.   \n.   The function estimates the object pose given 3 object points, their corresponding image\n.   projections, as well as the camera matrix and the distortion coefficients."},
    {"solvePnP", (PyCFunction)pyopencv_cv_solvePnP, METH_VARARGS | METH_KEYWORDS, "solvePnP(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, flags]]]]) -> retval, rvec, tvec\n.   @brief Finds an object pose from 3D-2D point correspondences.\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.   1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3f\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2f\\> can be also passed here.\n.   @param cameraMatrix Input camera matrix \\f$A = \\vecthreethree{fx}{0}{cx}{0}{fy}{cy}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Output rotation vector (see @ref Rodrigues ) that, together with tvec , brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvec Output translation vector.\n.   @param useExtrinsicGuess Parameter used for #SOLVEPNP_ITERATIVE. If true (1), the function uses\n.   the provided rvec and tvec values as initial approximations of the rotation and translation\n.   vectors, respectively, and further optimizes them.\n.   @param flags Method for solving a PnP problem:\n.   -   **SOLVEPNP_ITERATIVE** Iterative method is based on Levenberg-Marquardt optimization. In\n.   this case the function finds such a pose that minimizes reprojection error, that is the sum\n.   of squared distances between the observed projections imagePoints and the projected (using\n.   projectPoints ) objectPoints .\n.   -   **SOLVEPNP_P3P** Method is based on the paper of X.S. Gao, X.-R. Hou, J. Tang, H.-F. Chang\n.   \"Complete Solution Classification for the Perspective-Three-Point Problem\" (@cite gao2003complete).\n.   In this case the function requires exactly four object and image points.\n.   -   **SOLVEPNP_AP3P** Method is based on the paper of T. Ke, S. Roumeliotis\n.   \"An Efficient Algebraic Solution to the Perspective-Three-Point Problem\" (@cite Ke17).\n.   In this case the function requires exactly four object and image points.\n.   -   **SOLVEPNP_EPNP** Method has been introduced by F.Moreno-Noguer, V.Lepetit and P.Fua in the\n.   paper \"EPnP: Efficient Perspective-n-Point Camera Pose Estimation\" (@cite lepetit2009epnp).\n.   -   **SOLVEPNP_DLS** Method is based on the paper of Joel A. Hesch and Stergios I. Roumeliotis.\n.   \"A Direct Least-Squares (DLS) Method for PnP\" (@cite hesch2011direct).\n.   -   **SOLVEPNP_UPNP** Method is based on the paper of A.Penate-Sanchez, J.Andrade-Cetto,\n.   F.Moreno-Noguer. \"Exhaustive Linearization for Robust Camera Pose and Focal Length\n.   Estimation\" (@cite penate2013exhaustive). In this case the function also estimates the parameters \\f$f_x\\f$ and \\f$f_y\\f$\n.   assuming that both have the same value. Then the cameraMatrix is updated with the estimated\n.   focal length.\n.   -   **SOLVEPNP_AP3P** Method is based on the paper of Tong Ke and Stergios I. Roumeliotis.\n.   \"An Efficient Algebraic Solution to the Perspective-Three-Point Problem\" (@cite Ke17). In this case the\n.   function requires exactly four object and image points.\n.   \n.   The function estimates the object pose given a set of object points, their corresponding image\n.   projections, as well as the camera matrix and the distortion coefficients, see the figure below\n.   (more precisely, the X-axis of the camera frame is pointing to the right, the Y-axis downward\n.   and the Z-axis forward).\n.   \n.   ![](pnp.jpg)\n.   \n.   Points expressed in the world frame \\f$ \\bf{X}_w \\f$ are projected into the image plane \\f$ \\left[ u, v \\right] \\f$\n.   using the perspective projection model \\f$ \\Pi \\f$ and the camera intrinsic parameters matrix \\f$ \\bf{A} \\f$:\n.   \n.   \\f[\n.   \\begin{align*}\n.   \\begin{bmatrix}\n.   u \\\\\n.   v \\\\\n.   1\n.   \\end{bmatrix} &=\n.   \\bf{A} \\hspace{0.1em} \\Pi \\hspace{0.2em} ^{c}\\bf{M}_w\n.   \\begin{bmatrix}\n.   X_{w} \\\\\n.   Y_{w} \\\\\n.   Z_{w} \\\\\n.   1\n.   \\end{bmatrix} \\\\\n.   \\begin{bmatrix}\n.   u \\\\\n.   v \\\\\n.   1\n.   \\end{bmatrix} &=\n.   \\begin{bmatrix}\n.   f_x & 0 & c_x \\\\\n.   0 & f_y & c_y \\\\\n.   0 & 0 & 1\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   1 & 0 & 0 & 0 \\\\\n.   0 & 1 & 0 & 0 \\\\\n.   0 & 0 & 1 & 0\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   r_{11} & r_{12} & r_{13} & t_x \\\\\n.   r_{21} & r_{22} & r_{23} & t_y \\\\\n.   r_{31} & r_{32} & r_{33} & t_z \\\\\n.   0 & 0 & 0 & 1\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X_{w} \\\\\n.   Y_{w} \\\\\n.   Z_{w} \\\\\n.   1\n.   \\end{bmatrix}\n.   \\end{align*}\n.   \\f]\n.   \n.   The estimated pose is thus the rotation (`rvec`) and the translation (`tvec`) vectors that allow to transform\n.   a 3D point expressed in the world frame into the camera frame:\n.   \n.   \\f[\n.   \\begin{align*}\n.   \\begin{bmatrix}\n.   X_c \\\\\n.   Y_c \\\\\n.   Z_c \\\\\n.   1\n.   \\end{bmatrix} &=\n.   \\hspace{0.2em} ^{c}\\bf{M}_w\n.   \\begin{bmatrix}\n.   X_{w} \\\\\n.   Y_{w} \\\\\n.   Z_{w} \\\\\n.   1\n.   \\end{bmatrix} \\\\\n.   \\begin{bmatrix}\n.   X_c \\\\\n.   Y_c \\\\\n.   Z_c \\\\\n.   1\n.   \\end{bmatrix} &=\n.   \\begin{bmatrix}\n.   r_{11} & r_{12} & r_{13} & t_x \\\\\n.   r_{21} & r_{22} & r_{23} & t_y \\\\\n.   r_{31} & r_{32} & r_{33} & t_z \\\\\n.   0 & 0 & 0 & 1\n.   \\end{bmatrix}\n.   \\begin{bmatrix}\n.   X_{w} \\\\\n.   Y_{w} \\\\\n.   Z_{w} \\\\\n.   1\n.   \\end{bmatrix}\n.   \\end{align*}\n.   \\f]\n.   \n.   @note\n.   -   An example of how to use solvePnP for planar augmented reality can be found at\n.   opencv_source_code/samples/python/plane_ar.py\n.   -   If you are using Python:\n.   - Numpy array slices won't work as input because solvePnP requires contiguous\n.   arrays (enforced by the assertion using cv::Mat::checkVector() around line 55 of\n.   modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.   - The P3P algorithm requires image points to be in an array of shape (N,1,2) due\n.   to its calling of cv::undistortPoints (around line 75 of modules/calib3d/src/solvepnp.cpp version 2.4.9)\n.   which requires 2-channel information.\n.   - Thus, given some data D = np.array(...) where D.shape = (N,M), in order to use a subset of\n.   it as, e.g., imagePoints, one must effectively copy it into a new array: imagePoints =\n.   np.ascontiguousarray(D[:,:2]).reshape((N,1,2))\n.   -   The methods **SOLVEPNP_DLS** and **SOLVEPNP_UPNP** cannot be used as the current implementations are\n.   unstable and sometimes give completely wrong results. If you pass one of these two\n.   flags, **SOLVEPNP_EPNP** method will be used instead.\n.   -   The minimum number of points is 4 in the general case. In the case of **SOLVEPNP_P3P** and **SOLVEPNP_AP3P**\n.   methods, it is required to use exactly 4 points (the first 3 points are used to estimate all the solutions\n.   of the P3P problem, the last one is used to retain the best solution that minimizes the reprojection error).\n.   -   With **SOLVEPNP_ITERATIVE** method and `useExtrinsicGuess=true`, the minimum number of points is 3 (3 points\n.   are sufficient to compute a pose but there are up to 4 solutions). The initial solution should be close to the\n.   global solution to converge."},
    {"solvePnPRansac", (PyCFunction)pyopencv_cv_solvePnPRansac, METH_VARARGS | METH_KEYWORDS, "solvePnPRansac(objectPoints, imagePoints, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess[, iterationsCount[, reprojectionError[, confidence[, inliers[, flags]]]]]]]]) -> retval, rvec, tvec, inliers\n.   @brief Finds an object pose from 3D-2D point correspondences using the RANSAC scheme.\n.   \n.   @param objectPoints Array of object points in the object coordinate space, Nx3 1-channel or\n.   1xN/Nx1 3-channel, where N is the number of points. vector\\<Point3f\\> can be also passed here.\n.   @param imagePoints Array of corresponding image points, Nx2 1-channel or 1xN/Nx1 2-channel,\n.   where N is the number of points. vector\\<Point2f\\> can be also passed here.\n.   @param cameraMatrix Input camera matrix \\f$A = \\vecthreethree{fx}{0}{cx}{0}{fy}{cy}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are\n.   assumed.\n.   @param rvec Output rotation vector (see Rodrigues ) that, together with tvec , brings points from\n.   the model coordinate system to the camera coordinate system.\n.   @param tvec Output translation vector.\n.   @param useExtrinsicGuess Parameter used for SOLVEPNP_ITERATIVE. If true (1), the function uses\n.   the provided rvec and tvec values as initial approximations of the rotation and translation\n.   vectors, respectively, and further optimizes them.\n.   @param iterationsCount Number of iterations.\n.   @param reprojectionError Inlier threshold value used by the RANSAC procedure. The parameter value\n.   is the maximum allowed distance between the observed and computed point projections to consider it\n.   an inlier.\n.   @param confidence The probability that the algorithm produces a useful result.\n.   @param inliers Output vector that contains indices of inliers in objectPoints and imagePoints .\n.   @param flags Method for solving a PnP problem (see solvePnP ).\n.   \n.   The function estimates an object pose given a set of object points, their corresponding image\n.   projections, as well as the camera matrix and the distortion coefficients. This function finds such\n.   a pose that minimizes reprojection error, that is, the sum of squared distances between the observed\n.   projections imagePoints and the projected (using projectPoints ) objectPoints. The use of RANSAC\n.   makes the function resistant to outliers.\n.   \n.   @note\n.   -   An example of how to use solvePNPRansac for object detection can be found at\n.   opencv_source_code/samples/cpp/tutorial_code/calib3d/real_time_pose_estimation/\n.   -   The default method used to estimate the camera pose for the Minimal Sample Sets step\n.   is #SOLVEPNP_EPNP. Exceptions are:\n.   - if you choose #SOLVEPNP_P3P or #SOLVEPNP_AP3P, these methods will be used.\n.   - if the number of input points is equal to 4, #SOLVEPNP_P3P is used.\n.   -   The method used to estimate the camera pose using all the inliers is defined by the\n.   flags parameters unless it is equal to #SOLVEPNP_P3P or #SOLVEPNP_AP3P. In this case,\n.   the method #SOLVEPNP_EPNP will be used instead."},
    {"solvePoly", (PyCFunction)pyopencv_cv_solvePoly, METH_VARARGS | METH_KEYWORDS, "solvePoly(coeffs[, roots[, maxIters]]) -> retval, roots\n.   @brief Finds the real or complex roots of a polynomial equation.\n.   \n.   The function cv::solvePoly finds real and complex roots of a polynomial equation:\n.   \\f[\\texttt{coeffs} [n] x^{n} +  \\texttt{coeffs} [n-1] x^{n-1} + ... +  \\texttt{coeffs} [1] x +  \\texttt{coeffs} [0] = 0\\f]\n.   @param coeffs array of polynomial coefficients.\n.   @param roots output (complex) array of roots.\n.   @param maxIters maximum number of iterations the algorithm does."},
    {"sort", (PyCFunction)pyopencv_cv_sort, METH_VARARGS | METH_KEYWORDS, "sort(src, flags[, dst]) -> dst\n.   @brief Sorts each row or each column of a matrix.\n.   \n.   The function cv::sort sorts each matrix row or each matrix column in\n.   ascending or descending order. So you should pass two operation flags to\n.   get desired behaviour. If you want to sort matrix rows or columns\n.   lexicographically, you can use STL std::sort generic function with the\n.   proper comparison predicate.\n.   \n.   @param src input single-channel array.\n.   @param dst output array of the same size and type as src.\n.   @param flags operation flags, a combination of #SortFlags\n.   @sa sortIdx, randShuffle"},
    {"sortIdx", (PyCFunction)pyopencv_cv_sortIdx, METH_VARARGS | METH_KEYWORDS, "sortIdx(src, flags[, dst]) -> dst\n.   @brief Sorts each row or each column of a matrix.\n.   \n.   The function cv::sortIdx sorts each matrix row or each matrix column in the\n.   ascending or descending order. So you should pass two operation flags to\n.   get desired behaviour. Instead of reordering the elements themselves, it\n.   stores the indices of sorted elements in the output array. For example:\n.   @code\n.   Mat A = Mat::eye(3,3,CV_32F), B;\n.   sortIdx(A, B, SORT_EVERY_ROW + SORT_ASCENDING);\n.   // B will probably contain\n.   // (because of equal elements in A some permutations are possible):\n.   // [[1, 2, 0], [0, 2, 1], [0, 1, 2]]\n.   @endcode\n.   @param src input single-channel array.\n.   @param dst output integer array of the same size as src.\n.   @param flags operation flags that could be a combination of cv::SortFlags\n.   @sa sort, randShuffle"},
    {"spatialGradient", (PyCFunction)pyopencv_cv_spatialGradient, METH_VARARGS | METH_KEYWORDS, "spatialGradient(src[, dx[, dy[, ksize[, borderType]]]]) -> dx, dy\n.   @brief Calculates the first order image derivative in both x and y using a Sobel operator\n.   \n.   Equivalent to calling:\n.   \n.   @code\n.   Sobel( src, dx, CV_16SC1, 1, 0, 3 );\n.   Sobel( src, dy, CV_16SC1, 0, 1, 3 );\n.   @endcode\n.   \n.   @param src input image.\n.   @param dx output image with first-order derivative in x.\n.   @param dy output image with first-order derivative in y.\n.   @param ksize size of Sobel kernel. It must be 3.\n.   @param borderType pixel extrapolation method, see #BorderTypes\n.   \n.   @sa Sobel"},
    {"split", (PyCFunction)pyopencv_cv_split, METH_VARARGS | METH_KEYWORDS, "split(m[, mv]) -> mv\n.   @overload\n.   @param m input multi-channel array.\n.   @param mv output vector of arrays; the arrays themselves are reallocated, if needed."},
    {"sqrBoxFilter", (PyCFunction)pyopencv_cv_sqrBoxFilter, METH_VARARGS | METH_KEYWORDS, "sqrBoxFilter(_src, ddepth, ksize[, _dst[, anchor[, normalize[, borderType]]]]) -> _dst\n.   @brief Calculates the normalized sum of squares of the pixel values overlapping the filter.\n.   \n.   For every pixel \\f$ (x, y) \\f$ in the source image, the function calculates the sum of squares of those neighboring\n.   pixel values which overlap the filter placed over the pixel \\f$ (x, y) \\f$.\n.   \n.   The unnormalized square box filter can be useful in computing local image statistics such as the the local\n.   variance and standard deviation around the neighborhood of a pixel.\n.   \n.   @param _src input image\n.   @param _dst output image of the same size and type as _src\n.   @param ddepth the output image depth (-1 to use src.depth())\n.   @param ksize kernel size\n.   @param anchor kernel anchor point. The default value of Point(-1, -1) denotes that the anchor is at the kernel\n.   center.\n.   @param normalize flag, specifying whether the kernel is to be normalized by it's area or not.\n.   @param borderType border mode used to extrapolate pixels outside of the image, see #BorderTypes\n.   @sa boxFilter"},
    {"sqrt", (PyCFunction)pyopencv_cv_sqrt, METH_VARARGS | METH_KEYWORDS, "sqrt(src[, dst]) -> dst\n.   @brief Calculates a square root of array elements.\n.   \n.   The function cv::sqrt calculates a square root of each input array element.\n.   In case of multi-channel arrays, each channel is processed\n.   independently. The accuracy is approximately the same as of the built-in\n.   std::sqrt .\n.   @param src input floating-point array.\n.   @param dst output array of the same size and type as src."},
    {"startWindowThread", (PyCFunction)pyopencv_cv_startWindowThread, METH_VARARGS | METH_KEYWORDS, "startWindowThread() -> retval\n."},
    {"stereoCalibrate", (PyCFunction)pyopencv_cv_stereoCalibrate, METH_VARARGS | METH_KEYWORDS, "stereoCalibrate(objectPoints, imagePoints1, imagePoints2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize[, R[, T[, E[, F[, flags[, criteria]]]]]]) -> retval, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, R, T, E, F\n."},
    {"stereoCalibrateExtended", (PyCFunction)pyopencv_cv_stereoCalibrateExtended, METH_VARARGS | METH_KEYWORDS, "stereoCalibrateExtended(objectPoints, imagePoints1, imagePoints2, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T[, E[, F[, perViewErrors[, flags[, criteria]]]]]) -> retval, cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, R, T, E, F, perViewErrors\n.   @brief Calibrates the stereo camera.\n.   \n.   @param objectPoints Vector of vectors of the calibration pattern points.\n.   @param imagePoints1 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the first camera.\n.   @param imagePoints2 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the second camera.\n.   @param cameraMatrix1 Input/output first camera matrix:\n.   \\f$\\vecthreethree{f_x^{(j)}}{0}{c_x^{(j)}}{0}{f_y^{(j)}}{c_y^{(j)}}{0}{0}{1}\\f$ , \\f$j = 0,\\, 1\\f$ . If\n.   any of CALIB_USE_INTRINSIC_GUESS , CALIB_FIX_ASPECT_RATIO ,\n.   CALIB_FIX_INTRINSIC , or CALIB_FIX_FOCAL_LENGTH are specified, some or all of the\n.   matrix components must be initialized. See the flags description for details.\n.   @param distCoeffs1 Input/output vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6 [, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$ of\n.   4, 5, 8, 12 or 14 elements. The output vector length depends on the flags.\n.   @param cameraMatrix2 Input/output second camera matrix. The parameter is similar to cameraMatrix1\n.   @param distCoeffs2 Input/output lens distortion coefficients for the second camera. The parameter\n.   is similar to distCoeffs1 .\n.   @param imageSize Size of the image used only to initialize intrinsic camera matrix.\n.   @param R Output rotation matrix between the 1st and the 2nd camera coordinate systems.\n.   @param T Output translation vector between the coordinate systems of the cameras.\n.   @param E Output essential matrix.\n.   @param F Output fundamental matrix.\n.   @param perViewErrors Output vector of the RMS re-projection error estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   **CALIB_FIX_INTRINSIC** Fix cameraMatrix? and distCoeffs? so that only R, T, E , and F\n.   matrices are estimated.\n.   -   **CALIB_USE_INTRINSIC_GUESS** Optimize some or all of the intrinsic parameters\n.   according to the specified flags. Initial values are provided by the user.\n.   -   **CALIB_USE_EXTRINSIC_GUESS** R, T contain valid initial values that are optimized further.\n.   Otherwise R, T are initialized to the median value of the pattern views (each dimension separately).\n.   -   **CALIB_FIX_PRINCIPAL_POINT** Fix the principal points during the optimization.\n.   -   **CALIB_FIX_FOCAL_LENGTH** Fix \\f$f^{(j)}_x\\f$ and \\f$f^{(j)}_y\\f$ .\n.   -   **CALIB_FIX_ASPECT_RATIO** Optimize \\f$f^{(j)}_y\\f$ . Fix the ratio \\f$f^{(j)}_x/f^{(j)}_y\\f$\n.   .\n.   -   **CALIB_SAME_FOCAL_LENGTH** Enforce \\f$f^{(0)}_x=f^{(1)}_x\\f$ and \\f$f^{(0)}_y=f^{(1)}_y\\f$ .\n.   -   **CALIB_ZERO_TANGENT_DIST** Set tangential distortion coefficients for each camera to\n.   zeros and fix there.\n.   -   **CALIB_FIX_K1,...,CALIB_FIX_K6** Do not change the corresponding radial\n.   distortion coefficient during the optimization. If CALIB_USE_INTRINSIC_GUESS is set,\n.   the coefficient from the supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   **CALIB_RATIONAL_MODEL** Enable coefficients k4, k5, and k6. To provide the backward\n.   compatibility, this extra flag should be explicitly specified to make the calibration\n.   function use the rational model and return 8 coefficients. If the flag is not set, the\n.   function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_THIN_PRISM_MODEL** Coefficients s1, s2, s3 and s4 are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the thin prism model and return 12 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_FIX_S1_S2_S3_S4** The thin prism distortion coefficients are not changed during\n.   the optimization. If CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   -   **CALIB_TILTED_MODEL** Coefficients tauX and tauY are enabled. To provide the\n.   backward compatibility, this extra flag should be explicitly specified to make the\n.   calibration function use the tilted sensor model and return 14 coefficients. If the flag is not\n.   set, the function computes and returns only 5 distortion coefficients.\n.   -   **CALIB_FIX_TAUX_TAUY** The coefficients of the tilted sensor model are not changed during\n.   the optimization. If CALIB_USE_INTRINSIC_GUESS is set, the coefficient from the\n.   supplied distCoeffs matrix is used. Otherwise, it is set to 0.\n.   @param criteria Termination criteria for the iterative optimization algorithm.\n.   \n.   The function estimates transformation between two cameras making a stereo pair. If you have a stereo\n.   camera where the relative position and orientation of two cameras is fixed, and if you computed\n.   poses of an object relative to the first camera and to the second camera, (R1, T1) and (R2, T2),\n.   respectively (this can be done with solvePnP ), then those poses definitely relate to each other.\n.   This means that, given ( \\f$R_1\\f$,\\f$T_1\\f$ ), it should be possible to compute ( \\f$R_2\\f$,\\f$T_2\\f$ ). You only\n.   need to know the position and orientation of the second camera relative to the first camera. This is\n.   what the described function does. It computes ( \\f$R\\f$,\\f$T\\f$ ) so that:\n.   \n.   \\f[R_2=R*R_1\\f]\n.   \\f[T_2=R*T_1 + T,\\f]\n.   \n.   Optionally, it computes the essential matrix E:\n.   \n.   \\f[E= \\vecthreethree{0}{-T_2}{T_1}{T_2}{0}{-T_0}{-T_1}{T_0}{0} *R\\f]\n.   \n.   where \\f$T_i\\f$ are components of the translation vector \\f$T\\f$ : \\f$T=[T_0, T_1, T_2]^T\\f$ . And the function\n.   can also compute the fundamental matrix F:\n.   \n.   \\f[F = cameraMatrix2^{-T} E cameraMatrix1^{-1}\\f]\n.   \n.   Besides the stereo-related information, the function can also perform a full calibration of each of\n.   two cameras. However, due to the high dimensionality of the parameter space and noise in the input\n.   data, the function can diverge from the correct solution. If the intrinsic parameters can be\n.   estimated with high accuracy for each of the cameras individually (for example, using\n.   calibrateCamera ), you are recommended to do so and then pass CALIB_FIX_INTRINSIC flag to the\n.   function along with the computed intrinsic parameters. Otherwise, if all the parameters are\n.   estimated at once, it makes sense to restrict some parameters, for example, pass\n.   CALIB_SAME_FOCAL_LENGTH and CALIB_ZERO_TANGENT_DIST flags, which is usually a\n.   reasonable assumption.\n.   \n.   Similarly to calibrateCamera , the function minimizes the total re-projection error for all the\n.   points in all the available views from both cameras. The function returns the final value of the\n.   re-projection error."},
    {"stereoRectify", (PyCFunction)pyopencv_cv_stereoRectify, METH_VARARGS | METH_KEYWORDS, "stereoRectify(cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T[, R1[, R2[, P1[, P2[, Q[, flags[, alpha[, newImageSize]]]]]]]]) -> R1, R2, P1, P2, Q, validPixROI1, validPixROI2\n.   @brief Computes rectification transforms for each head of a calibrated stereo camera.\n.   \n.   @param cameraMatrix1 First camera matrix.\n.   @param distCoeffs1 First camera distortion parameters.\n.   @param cameraMatrix2 Second camera matrix.\n.   @param distCoeffs2 Second camera distortion parameters.\n.   @param imageSize Size of the image used for stereo calibration.\n.   @param R Rotation matrix between the coordinate systems of the first and the second cameras.\n.   @param T Translation vector between coordinate systems of the cameras.\n.   @param R1 Output 3x3 rectification transform (rotation matrix) for the first camera.\n.   @param R2 Output 3x3 rectification transform (rotation matrix) for the second camera.\n.   @param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first\n.   camera.\n.   @param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second\n.   camera.\n.   @param Q Output \\f$4 \\times 4\\f$ disparity-to-depth mapping matrix (see reprojectImageTo3D ).\n.   @param flags Operation flags that may be zero or CALIB_ZERO_DISPARITY . If the flag is set,\n.   the function makes the principal points of each camera have the same pixel coordinates in the\n.   rectified views. And if the flag is not set, the function may still shift the images in the\n.   horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the\n.   useful image area.\n.   @param alpha Free scaling parameter. If it is -1 or absent, the function performs the default\n.   scaling. Otherwise, the parameter should be between 0 and 1. alpha=0 means that the rectified\n.   images are zoomed and shifted so that only valid pixels are visible (no black areas after\n.   rectification). alpha=1 means that the rectified image is decimated and shifted so that all the\n.   pixels from the original images from the cameras are retained in the rectified images (no source\n.   image pixels are lost). Obviously, any intermediate value yields an intermediate result between\n.   those two extreme cases.\n.   @param newImageSize New image resolution after rectification. The same size should be passed to\n.   initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)\n.   is passed (default), it is set to the original imageSize . Setting it to larger value can help you\n.   preserve details in the original image, especially when there is a big radial distortion.\n.   @param validPixROI1 Optional output rectangles inside the rectified images where all the pixels\n.   are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller\n.   (see the picture below).\n.   @param validPixROI2 Optional output rectangles inside the rectified images where all the pixels\n.   are valid. If alpha=0 , the ROIs cover the whole images. Otherwise, they are likely to be smaller\n.   (see the picture below).\n.   \n.   The function computes the rotation matrices for each camera that (virtually) make both camera image\n.   planes the same plane. Consequently, this makes all the epipolar lines parallel and thus simplifies\n.   the dense stereo correspondence problem. The function takes the matrices computed by stereoCalibrate\n.   as input. As output, it provides two rotation matrices and also two projection matrices in the new\n.   coordinates. The function distinguishes the following two cases:\n.   \n.   -   **Horizontal stereo**: the first and the second camera views are shifted relative to each other\n.   mainly along the x axis (with possible small vertical shift). In the rectified images, the\n.   corresponding epipolar lines in the left and right cameras are horizontal and have the same\n.   y-coordinate. P1 and P2 look like:\n.   \n.   \\f[\\texttt{P1} = \\begin{bmatrix} f & 0 & cx_1 & 0 \\\\ 0 & f & cy & 0 \\\\ 0 & 0 & 1 & 0 \\end{bmatrix}\\f]\n.   \n.   \\f[\\texttt{P2} = \\begin{bmatrix} f & 0 & cx_2 & T_x*f \\\\ 0 & f & cy & 0 \\\\ 0 & 0 & 1 & 0 \\end{bmatrix} ,\\f]\n.   \n.   where \\f$T_x\\f$ is a horizontal shift between the cameras and \\f$cx_1=cx_2\\f$ if\n.   CALIB_ZERO_DISPARITY is set.\n.   \n.   -   **Vertical stereo**: the first and the second camera views are shifted relative to each other\n.   mainly in vertical direction (and probably a bit in the horizontal direction too). The epipolar\n.   lines in the rectified images are vertical and have the same x-coordinate. P1 and P2 look like:\n.   \n.   \\f[\\texttt{P1} = \\begin{bmatrix} f & 0 & cx & 0 \\\\ 0 & f & cy_1 & 0 \\\\ 0 & 0 & 1 & 0 \\end{bmatrix}\\f]\n.   \n.   \\f[\\texttt{P2} = \\begin{bmatrix} f & 0 & cx & 0 \\\\ 0 & f & cy_2 & T_y*f \\\\ 0 & 0 & 1 & 0 \\end{bmatrix} ,\\f]\n.   \n.   where \\f$T_y\\f$ is a vertical shift between the cameras and \\f$cy_1=cy_2\\f$ if CALIB_ZERO_DISPARITY is\n.   set.\n.   \n.   As you can see, the first three columns of P1 and P2 will effectively be the new \"rectified\" camera\n.   matrices. The matrices, together with R1 and R2 , can then be passed to initUndistortRectifyMap to\n.   initialize the rectification map for each camera.\n.   \n.   See below the screenshot from the stereo_calib.cpp sample. Some red horizontal lines pass through\n.   the corresponding image regions. This means that the images are well rectified, which is what most\n.   stereo correspondence algorithms rely on. The green rectangles are roi1 and roi2 . You see that\n.   their interiors are all valid pixels.\n.   \n.   ![image](pics/stereo_undistort.jpg)"},
    {"stereoRectifyUncalibrated", (PyCFunction)pyopencv_cv_stereoRectifyUncalibrated, METH_VARARGS | METH_KEYWORDS, "stereoRectifyUncalibrated(points1, points2, F, imgSize[, H1[, H2[, threshold]]]) -> retval, H1, H2\n.   @brief Computes a rectification transform for an uncalibrated stereo camera.\n.   \n.   @param points1 Array of feature points in the first image.\n.   @param points2 The corresponding points in the second image. The same formats as in\n.   findFundamentalMat are supported.\n.   @param F Input fundamental matrix. It can be computed from the same set of point pairs using\n.   findFundamentalMat .\n.   @param imgSize Size of the image.\n.   @param H1 Output rectification homography matrix for the first image.\n.   @param H2 Output rectification homography matrix for the second image.\n.   @param threshold Optional threshold used to filter out the outliers. If the parameter is greater\n.   than zero, all the point pairs that do not comply with the epipolar geometry (that is, the points\n.   for which \\f$|\\texttt{points2[i]}^T*\\texttt{F}*\\texttt{points1[i]}|>\\texttt{threshold}\\f$ ) are\n.   rejected prior to computing the homographies. Otherwise, all the points are considered inliers.\n.   \n.   The function computes the rectification transformations without knowing intrinsic parameters of the\n.   cameras and their relative position in the space, which explains the suffix \"uncalibrated\". Another\n.   related difference from stereoRectify is that the function outputs not the rectification\n.   transformations in the object (3D) space, but the planar perspective transformations encoded by the\n.   homography matrices H1 and H2 . The function implements the algorithm @cite Hartley99 .\n.   \n.   @note\n.   While the algorithm does not need to know the intrinsic parameters of the cameras, it heavily\n.   depends on the epipolar geometry. Therefore, if the camera lenses have a significant distortion,\n.   it would be better to correct it before computing the fundamental matrix and calling this\n.   function. For example, distortion coefficients can be estimated for each head of stereo camera\n.   separately by using calibrateCamera . Then, the images can be corrected using undistort , or\n.   just the point coordinates can be corrected with undistortPoints ."},
    {"stylization", (PyCFunction)pyopencv_cv_stylization, METH_VARARGS | METH_KEYWORDS, "stylization(src[, dst[, sigma_s[, sigma_r]]]) -> dst\n.   @brief Stylization aims to produce digital imagery with a wide variety of effects not focused on\n.   photorealism. Edge-aware filters are ideal for stylization, as they can abstract regions of low\n.   contrast while preserving, or enhancing, high-contrast features.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param sigma_s Range between 0 to 200.\n.   @param sigma_r Range between 0 to 1."},
    {"subtract", (PyCFunction)pyopencv_cv_subtract, METH_VARARGS | METH_KEYWORDS, "subtract(src1, src2[, dst[, mask[, dtype]]]) -> dst\n.   @brief Calculates the per-element difference between two arrays or array and a scalar.\n.   \n.   The function subtract calculates:\n.   - Difference between two arrays, when both input arrays have the same size and the same number of\n.   channels:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) -  \\texttt{src2}(I)) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Difference between an array and a scalar, when src2 is constructed from Scalar or has the same\n.   number of elements as `src1.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1}(I) -  \\texttt{src2} ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - Difference between a scalar and an array, when src1 is constructed from Scalar or has the same\n.   number of elements as `src2.channels()`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src1} -  \\texttt{src2}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   - The reverse difference between a scalar and an array in the case of `SubRS`:\n.   \\f[\\texttt{dst}(I) =  \\texttt{saturate} ( \\texttt{src2} -  \\texttt{src1}(I) ) \\quad \\texttt{if mask}(I) \\ne0\\f]\n.   where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each\n.   channel is processed independently.\n.   \n.   The first function in the list above can be replaced with matrix expressions:\n.   @code{.cpp}\n.   dst = src1 - src2;\n.   dst -= src1; // equivalent to subtract(dst, src1, dst);\n.   @endcode\n.   The input arrays and the output array can all have the same or different depths. For example, you\n.   can subtract to 8-bit unsigned arrays and store the difference in a 16-bit signed array. Depth of\n.   the output array is determined by dtype parameter. In the second and third cases above, as well as\n.   in the first case, when src1.depth() == src2.depth(), dtype can be set to the default -1. In this\n.   case the output array will have the same depth as the input array, be it src1, src2 or both.\n.   @note Saturation is not applied when the output array has the depth CV_32S. You may even get\n.   result of an incorrect sign in the case of overflow.\n.   @param src1 first input array or a scalar.\n.   @param src2 second input array or a scalar.\n.   @param dst output array of the same size and the same number of channels as the input array.\n.   @param mask optional operation mask; this is an 8-bit single channel array that specifies elements\n.   of the output array to be changed.\n.   @param dtype optional depth of the output array\n.   @sa  add, addWeighted, scaleAdd, Mat::convertTo"},
    {"sumElems", (PyCFunction)pyopencv_cv_sumElems, METH_VARARGS | METH_KEYWORDS, "sumElems(src) -> retval\n.   @brief Calculates the sum of array elements.\n.   \n.   The function cv::sum calculates and returns the sum of array elements,\n.   independently for each channel.\n.   @param src input array that must have from 1 to 4 channels.\n.   @sa  countNonZero, mean, meanStdDev, norm, minMaxLoc, reduce"},
    {"textureFlattening", (PyCFunction)pyopencv_cv_textureFlattening, METH_VARARGS | METH_KEYWORDS, "textureFlattening(src, mask[, dst[, low_threshold[, high_threshold[, kernel_size]]]]) -> dst\n.   @brief By retaining only the gradients at edge locations, before integrating with the Poisson solver, one\n.   washes out the texture of the selected region, giving its contents a flat aspect. Here Canny Edge\n.   Detector is used.\n.   \n.   @param src Input 8-bit 3-channel image.\n.   @param mask Input 8-bit 1 or 3-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param low_threshold Range from 0 to 100.\n.   @param high_threshold Value \\> 100.\n.   @param kernel_size The size of the Sobel kernel to be used.\n.   \n.   **NOTE:**\n.   \n.   The algorithm assumes that the color of the source image is close to that of the destination. This\n.   assumption means that when the colors don't match, the source image color gets tinted toward the\n.   color of the destination image."},
    {"threshold", (PyCFunction)pyopencv_cv_threshold, METH_VARARGS | METH_KEYWORDS, "threshold(src, thresh, maxval, type[, dst]) -> retval, dst\n.   @brief Applies a fixed-level threshold to each array element.\n.   \n.   The function applies fixed-level thresholding to a multiple-channel array. The function is typically\n.   used to get a bi-level (binary) image out of a grayscale image ( #compare could be also used for\n.   this purpose) or for removing a noise, that is, filtering out pixels with too small or too large\n.   values. There are several types of thresholding supported by the function. They are determined by\n.   type parameter.\n.   \n.   Also, the special values #THRESH_OTSU or #THRESH_TRIANGLE may be combined with one of the\n.   above values. In these cases, the function determines the optimal threshold value using the Otsu's\n.   or Triangle algorithm and uses it instead of the specified thresh.\n.   \n.   @note Currently, the Otsu's and Triangle methods are implemented only for 8-bit single-channel images.\n.   \n.   @param src input array (multiple-channel, 8-bit or 32-bit floating point).\n.   @param dst output array of the same size  and type and the same number of channels as src.\n.   @param thresh threshold value.\n.   @param maxval maximum value to use with the #THRESH_BINARY and #THRESH_BINARY_INV thresholding\n.   types.\n.   @param type thresholding type (see #ThresholdTypes).\n.   @return the computed threshold value if Otsu's or Triangle methods used.\n.   \n.   @sa  adaptiveThreshold, findContours, compare, min, max"},
    {"trace", (PyCFunction)pyopencv_cv_trace, METH_VARARGS | METH_KEYWORDS, "trace(mtx) -> retval\n.   @brief Returns the trace of a matrix.\n.   \n.   The function cv::trace returns the sum of the diagonal elements of the\n.   matrix mtx .\n.   \\f[\\mathrm{tr} ( \\texttt{mtx} ) =  \\sum _i  \\texttt{mtx} (i,i)\\f]\n.   @param mtx input matrix."},
    {"transform", (PyCFunction)pyopencv_cv_transform, METH_VARARGS | METH_KEYWORDS, "transform(src, m[, dst]) -> dst\n.   @brief Performs the matrix transformation of every array element.\n.   \n.   The function cv::transform performs the matrix transformation of every\n.   element of the array src and stores the results in dst :\n.   \\f[\\texttt{dst} (I) =  \\texttt{m} \\cdot \\texttt{src} (I)\\f]\n.   (when m.cols=src.channels() ), or\n.   \\f[\\texttt{dst} (I) =  \\texttt{m} \\cdot [ \\texttt{src} (I); 1]\\f]\n.   (when m.cols=src.channels()+1 )\n.   \n.   Every element of the N -channel array src is interpreted as N -element\n.   vector that is transformed using the M x N or M x (N+1) matrix m to\n.   M-element vector - the corresponding element of the output array dst .\n.   \n.   The function may be used for geometrical transformation of\n.   N -dimensional points, arbitrary linear color space transformation (such\n.   as various kinds of RGB to YUV transforms), shuffling the image\n.   channels, and so forth.\n.   @param src input array that must have as many channels (1 to 4) as\n.   m.cols or m.cols-1.\n.   @param dst output array of the same size and depth as src; it has as\n.   many channels as m.rows.\n.   @param m transformation 2x2 or 2x3 floating-point matrix.\n.   @sa perspectiveTransform, getAffineTransform, estimateAffine2D, warpAffine, warpPerspective"},
    {"transpose", (PyCFunction)pyopencv_cv_transpose, METH_VARARGS | METH_KEYWORDS, "transpose(src[, dst]) -> dst\n.   @brief Transposes a matrix.\n.   \n.   The function cv::transpose transposes the matrix src :\n.   \\f[\\texttt{dst} (i,j) =  \\texttt{src} (j,i)\\f]\n.   @note No complex conjugation is done in case of a complex matrix. It\n.   should be done separately if needed.\n.   @param src input array.\n.   @param dst output array of the same type as src."},
    {"triangulatePoints", (PyCFunction)pyopencv_cv_triangulatePoints, METH_VARARGS | METH_KEYWORDS, "triangulatePoints(projMatr1, projMatr2, projPoints1, projPoints2[, points4D]) -> points4D\n.   @brief Reconstructs points by triangulation.\n.   \n.   @param projMatr1 3x4 projection matrix of the first camera.\n.   @param projMatr2 3x4 projection matrix of the second camera.\n.   @param projPoints1 2xN array of feature points in the first image. In case of c++ version it can\n.   be also a vector of feature points or two-channel matrix of size 1xN or Nx1.\n.   @param projPoints2 2xN array of corresponding points in the second image. In case of c++ version\n.   it can be also a vector of feature points or two-channel matrix of size 1xN or Nx1.\n.   @param points4D 4xN array of reconstructed points in homogeneous coordinates.\n.   \n.   The function reconstructs 3-dimensional points (in homogeneous coordinates) by using their\n.   observations with a stereo camera. Projections matrices can be obtained from stereoRectify.\n.   \n.   @note\n.   Keep in mind that all input data should be of float type in order for this function to work.\n.   \n.   @sa\n.   reprojectImageTo3D"},
    {"undistort", (PyCFunction)pyopencv_cv_undistort, METH_VARARGS | METH_KEYWORDS, "undistort(src, cameraMatrix, distCoeffs[, dst[, newCameraMatrix]]) -> dst\n.   @brief Transforms an image to compensate for lens distortion.\n.   \n.   The function transforms an image to compensate radial and tangential lens distortion.\n.   \n.   The function is simply a combination of #initUndistortRectifyMap (with unity R ) and #remap\n.   (with bilinear interpolation). See the former function for details of the transformation being\n.   performed.\n.   \n.   Those pixels in the destination image, for which there is no correspondent pixels in the source\n.   image, are filled with zeros (black color).\n.   \n.   A particular subset of the source image that will be visible in the corrected image can be regulated\n.   by newCameraMatrix. You can use #getOptimalNewCameraMatrix to compute the appropriate\n.   newCameraMatrix depending on your requirements.\n.   \n.   The camera matrix and the distortion parameters can be determined using #calibrateCamera. If\n.   the resolution of images is different from the resolution used at the calibration stage, \\f$f_x,\n.   f_y, c_x\\f$ and \\f$c_y\\f$ need to be scaled accordingly, while the distortion coefficients remain\n.   the same.\n.   \n.   @param src Input (distorted) image.\n.   @param dst Output (corrected) image that has the same size and type as src .\n.   @param cameraMatrix Input camera matrix \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param newCameraMatrix Camera matrix of the distorted image. By default, it is the same as\n.   cameraMatrix but you may additionally scale and shift the result by using a different matrix."},
    {"undistortPoints", (PyCFunction)pyopencv_cv_undistortPoints, METH_VARARGS | METH_KEYWORDS, "undistortPoints(src, cameraMatrix, distCoeffs[, dst[, R[, P]]]) -> dst\n.   @brief Computes the ideal point coordinates from the observed point coordinates.\n.   \n.   The function is similar to #undistort and #initUndistortRectifyMap but it operates on a\n.   sparse set of points instead of a raster image. Also the function performs a reverse transformation\n.   to projectPoints. In case of a 3D object, it does not reconstruct its 3D coordinates, but for a\n.   planar object, it does, up to a translation vector, if the proper R is specified.\n.   \n.   For each observed point coordinate \\f$(u, v)\\f$ the function computes:\n.   \\f[\n.   \\begin{array}{l}\n.   x^{\"}  \\leftarrow (u - c_x)/f_x  \\\\\n.   y^{\"}  \\leftarrow (v - c_y)/f_y  \\\\\n.   (x',y') = undistort(x^{\"},y^{\"}, \\texttt{distCoeffs}) \\\\\n.   {[X\\,Y\\,W]} ^T  \\leftarrow R*[x' \\, y' \\, 1]^T  \\\\\n.   x  \\leftarrow X/W  \\\\\n.   y  \\leftarrow Y/W  \\\\\n.   \\text{only performed if P is specified:} \\\\\n.   u'  \\leftarrow x {f'}_x + {c'}_x  \\\\\n.   v'  \\leftarrow y {f'}_y + {c'}_y\n.   \\end{array}\n.   \\f]\n.   \n.   where *undistort* is an approximate iterative algorithm that estimates the normalized original\n.   point coordinates out of the normalized distorted point coordinates (\"normalized\" means that the\n.   coordinates do not depend on the camera matrix).\n.   \n.   The function can be used for both a stereo camera head or a monocular camera (when R is empty).\n.   \n.   @param src Observed point coordinates, 1xN or Nx1 2-channel (CV_32FC2 or CV_64FC2).\n.   @param dst Output ideal point coordinates after undistortion and reverse perspective\n.   transformation. If matrix P is identity or omitted, dst will contain normalized point coordinates.\n.   @param cameraMatrix Camera matrix \\f$\\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ .\n.   @param distCoeffs Input vector of distortion coefficients\n.   \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6[, s_1, s_2, s_3, s_4[, \\tau_x, \\tau_y]]]])\\f$\n.   of 4, 5, 8, 12 or 14 elements. If the vector is NULL/empty, the zero distortion coefficients are assumed.\n.   @param R Rectification transformation in the object space (3x3 matrix). R1 or R2 computed by\n.   #stereoRectify can be passed here. If the matrix is empty, the identity transformation is used.\n.   @param P New camera matrix (3x3) or new projection matrix (3x4) \\f$\\begin{bmatrix} {f'}_x & 0 & {c'}_x & t_x \\\\ 0 & {f'}_y & {c'}_y & t_y \\\\ 0 & 0 & 1 & t_z \\end{bmatrix}\\f$. P1 or P2 computed by\n.   #stereoRectify can be passed here. If the matrix is empty, the identity new camera matrix is used."},
    {"undistortPointsIter", (PyCFunction)pyopencv_cv_undistortPointsIter, METH_VARARGS | METH_KEYWORDS, "undistortPointsIter(src, cameraMatrix, distCoeffs, R, P, criteria[, dst]) -> dst\n.   @overload\n.   @note Default version of #undistortPoints does 5 iterations to compute undistorted points."},
    {"useOpenVX", (PyCFunction)pyopencv_cv_useOpenVX, METH_VARARGS | METH_KEYWORDS, "useOpenVX() -> retval\n."},
    {"useOptimized", (PyCFunction)pyopencv_cv_useOptimized, METH_VARARGS | METH_KEYWORDS, "useOptimized() -> retval\n.   @brief Returns the status of optimized code usage.\n.   \n.   The function returns true if the optimized code is enabled. Otherwise, it returns false."},
    {"validateDisparity", (PyCFunction)pyopencv_cv_validateDisparity, METH_VARARGS | METH_KEYWORDS, "validateDisparity(disparity, cost, minDisparity, numberOfDisparities[, disp12MaxDisp]) -> disparity\n."},
    {"vconcat", (PyCFunction)pyopencv_cv_vconcat, METH_VARARGS | METH_KEYWORDS, "vconcat(src[, dst]) -> dst\n.   @overload\n.   @code{.cpp}\n.   std::vector<cv::Mat> matrices = { cv::Mat(1, 4, CV_8UC1, cv::Scalar(1)),\n.   cv::Mat(1, 4, CV_8UC1, cv::Scalar(2)),\n.   cv::Mat(1, 4, CV_8UC1, cv::Scalar(3)),};\n.   \n.   cv::Mat out;\n.   cv::vconcat( matrices, out );\n.   //out:\n.   //[1,   1,   1,   1;\n.   // 2,   2,   2,   2;\n.   // 3,   3,   3,   3]\n.   @endcode\n.   @param src input array or vector of matrices. all of the matrices must have the same number of cols and the same depth\n.   @param dst output array. It has the same number of cols and depth as the src, and the sum of rows of the src.\n.   same depth."},
    {"waitKey", (PyCFunction)pyopencv_cv_waitKey, METH_VARARGS | METH_KEYWORDS, "waitKey([, delay]) -> retval\n.   @brief Waits for a pressed key.\n.   \n.   The function waitKey waits for a key event infinitely (when \\f$\\texttt{delay}\\leq 0\\f$ ) or for delay\n.   milliseconds, when it is positive. Since the OS has a minimum time between switching threads, the\n.   function will not wait exactly delay ms, it will wait at least delay ms, depending on what else is\n.   running on your computer at that time. It returns the code of the pressed key or -1 if no key was\n.   pressed before the specified time had elapsed.\n.   \n.   @note\n.   \n.   This function is the only method in HighGUI that can fetch and handle events, so it needs to be\n.   called periodically for normal event processing unless HighGUI is used within an environment that\n.   takes care of event processing.\n.   \n.   @note\n.   \n.   The function only works if there is at least one HighGUI window created and the window is active.\n.   If there are several HighGUI windows, any of them can be active.\n.   \n.   @param delay Delay in milliseconds. 0 is the special value that means \"forever\"."},
    {"waitKeyEx", (PyCFunction)pyopencv_cv_waitKeyEx, METH_VARARGS | METH_KEYWORDS, "waitKeyEx([, delay]) -> retval\n.   @brief Similar to #waitKey, but returns full key code.\n.   \n.   @note\n.   \n.   Key code is implementation specific and depends on used backend: QT/GTK/Win32/etc"},
    {"warpAffine", (PyCFunction)pyopencv_cv_warpAffine, METH_VARARGS | METH_KEYWORDS, "warpAffine(src, M, dsize[, dst[, flags[, borderMode[, borderValue]]]]) -> dst\n.   @brief Applies an affine transformation to an image.\n.   \n.   The function warpAffine transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} ( \\texttt{M} _{11} x +  \\texttt{M} _{12} y +  \\texttt{M} _{13}, \\texttt{M} _{21} x +  \\texttt{M} _{22} y +  \\texttt{M} _{23})\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted\n.   with #invertAffineTransform and then put in the formula above instead of M. The function cannot\n.   operate in-place.\n.   \n.   @param src input image.\n.   @param dst output image that has the size dsize and the same type as src .\n.   @param M \\f$2\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (see #InterpolationFlags) and the optional\n.   flag #WARP_INVERSE_MAP that means that M is the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (see #BorderTypes); when\n.   borderMode=#BORDER_TRANSPARENT, it means that the pixels in the destination image corresponding to\n.   the \"outliers\" in the source image are not modified by the function.\n.   @param borderValue value used in case of a constant border; by default, it is 0.\n.   \n.   @sa  warpPerspective, resize, remap, getRectSubPix, transform"},
    {"warpPerspective", (PyCFunction)pyopencv_cv_warpPerspective, METH_VARARGS | METH_KEYWORDS, "warpPerspective(src, M, dsize[, dst[, flags[, borderMode[, borderValue]]]]) -> dst\n.   @brief Applies a perspective transformation to an image.\n.   \n.   The function warpPerspective transforms the source image using the specified matrix:\n.   \n.   \\f[\\texttt{dst} (x,y) =  \\texttt{src} \\left ( \\frac{M_{11} x + M_{12} y + M_{13}}{M_{31} x + M_{32} y + M_{33}} ,\n.   \\frac{M_{21} x + M_{22} y + M_{23}}{M_{31} x + M_{32} y + M_{33}} \\right )\\f]\n.   \n.   when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted with invert\n.   and then put in the formula above instead of M. The function cannot operate in-place.\n.   \n.   @param src input image.\n.   @param dst output image that has the size dsize and the same type as src .\n.   @param M \\f$3\\times 3\\f$ transformation matrix.\n.   @param dsize size of the output image.\n.   @param flags combination of interpolation methods (#INTER_LINEAR or #INTER_NEAREST) and the\n.   optional flag #WARP_INVERSE_MAP, that sets M as the inverse transformation (\n.   \\f$\\texttt{dst}\\rightarrow\\texttt{src}\\f$ ).\n.   @param borderMode pixel extrapolation method (#BORDER_CONSTANT or #BORDER_REPLICATE).\n.   @param borderValue value used in case of a constant border; by default, it equals 0.\n.   \n.   @sa  warpAffine, resize, remap, getRectSubPix, perspectiveTransform"},
    {"watershed", (PyCFunction)pyopencv_cv_watershed, METH_VARARGS | METH_KEYWORDS, "watershed(image, markers) -> markers\n.   @brief Performs a marker-based image segmentation using the watershed algorithm.\n.   \n.   The function implements one of the variants of watershed, non-parametric marker-based segmentation\n.   algorithm, described in @cite Meyer92 .\n.   \n.   Before passing the image to the function, you have to roughly outline the desired regions in the\n.   image markers with positive (\\>0) indices. So, every region is represented as one or more connected\n.   components with the pixel values 1, 2, 3, and so on. Such markers can be retrieved from a binary\n.   mask using #findContours and #drawContours (see the watershed.cpp demo). The markers are \"seeds\" of\n.   the future image regions. All the other pixels in markers , whose relation to the outlined regions\n.   is not known and should be defined by the algorithm, should be set to 0's. In the function output,\n.   each pixel in markers is set to a value of the \"seed\" components or to -1 at boundaries between the\n.   regions.\n.   \n.   @note Any two neighbor connected components are not necessarily separated by a watershed boundary\n.   (-1's pixels); for example, they can touch each other in the initial marker image passed to the\n.   function.\n.   \n.   @param image Input 8-bit 3-channel image.\n.   @param markers Input/output 32-bit single-channel image (map) of markers. It should have the same\n.   size as image .\n.   \n.   @sa findContours\n.   \n.   @ingroup imgproc_misc"},
    {NULL, NULL}
};

static ConstDef consts_cv[] = {
    {"ACCESS_FAST", cv::ACCESS_FAST},
    {"ACCESS_MASK", cv::ACCESS_MASK},
    {"ACCESS_READ", cv::ACCESS_READ},
    {"ACCESS_RW", cv::ACCESS_RW},
    {"ACCESS_WRITE", cv::ACCESS_WRITE},
    {"ADAPTIVE_THRESH_GAUSSIAN_C", cv::ADAPTIVE_THRESH_GAUSSIAN_C},
    {"ADAPTIVE_THRESH_MEAN_C", cv::ADAPTIVE_THRESH_MEAN_C},
    {"AKAZE_DESCRIPTOR_KAZE", cv::AKAZE::DESCRIPTOR_KAZE},
    {"AKAZE_DESCRIPTOR_KAZE_UPRIGHT", cv::AKAZE::DESCRIPTOR_KAZE_UPRIGHT},
    {"AKAZE_DESCRIPTOR_MLDB", cv::AKAZE::DESCRIPTOR_MLDB},
    {"AKAZE_DESCRIPTOR_MLDB_UPRIGHT", cv::AKAZE::DESCRIPTOR_MLDB_UPRIGHT},
    {"AgastFeatureDetector_AGAST_5_8", cv::AgastFeatureDetector::AGAST_5_8},
    {"AGAST_FEATURE_DETECTOR_AGAST_5_8", cv::AgastFeatureDetector::AGAST_5_8},
    {"AgastFeatureDetector_AGAST_7_12d", cv::AgastFeatureDetector::AGAST_7_12d},
    {"AGAST_FEATURE_DETECTOR_AGAST_7_12D", cv::AgastFeatureDetector::AGAST_7_12d},
    {"AgastFeatureDetector_AGAST_7_12s", cv::AgastFeatureDetector::AGAST_7_12s},
    {"AGAST_FEATURE_DETECTOR_AGAST_7_12S", cv::AgastFeatureDetector::AGAST_7_12s},
    {"AgastFeatureDetector_NONMAX_SUPPRESSION", cv::AgastFeatureDetector::NONMAX_SUPPRESSION},
    {"AGAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION", cv::AgastFeatureDetector::NONMAX_SUPPRESSION},
    {"AgastFeatureDetector_OAST_9_16", cv::AgastFeatureDetector::OAST_9_16},
    {"AGAST_FEATURE_DETECTOR_OAST_9_16", cv::AgastFeatureDetector::OAST_9_16},
    {"AgastFeatureDetector_THRESHOLD", cv::AgastFeatureDetector::THRESHOLD},
    {"AGAST_FEATURE_DETECTOR_THRESHOLD", cv::AgastFeatureDetector::THRESHOLD},
    {"BORDER_CONSTANT", cv::BORDER_CONSTANT},
    {"BORDER_DEFAULT", cv::BORDER_DEFAULT},
    {"BORDER_ISOLATED", cv::BORDER_ISOLATED},
    {"BORDER_REFLECT", cv::BORDER_REFLECT},
    {"BORDER_REFLECT101", cv::BORDER_REFLECT101},
    {"BORDER_REFLECT_101", cv::BORDER_REFLECT_101},
    {"BORDER_REPLICATE", cv::BORDER_REPLICATE},
    {"BORDER_TRANSPARENT", cv::BORDER_TRANSPARENT},
    {"BORDER_WRAP", cv::BORDER_WRAP},
    {"CALIB_CB_ADAPTIVE_THRESH", cv::CALIB_CB_ADAPTIVE_THRESH},
    {"CALIB_CB_ASYMMETRIC_GRID", cv::CALIB_CB_ASYMMETRIC_GRID},
    {"CALIB_CB_CLUSTERING", cv::CALIB_CB_CLUSTERING},
    {"CALIB_CB_FAST_CHECK", cv::CALIB_CB_FAST_CHECK},
    {"CALIB_CB_FILTER_QUADS", cv::CALIB_CB_FILTER_QUADS},
    {"CALIB_CB_NORMALIZE_IMAGE", cv::CALIB_CB_NORMALIZE_IMAGE},
    {"CALIB_CB_SYMMETRIC_GRID", cv::CALIB_CB_SYMMETRIC_GRID},
    {"CALIB_FIX_ASPECT_RATIO", cv::CALIB_FIX_ASPECT_RATIO},
    {"CALIB_FIX_FOCAL_LENGTH", cv::CALIB_FIX_FOCAL_LENGTH},
    {"CALIB_FIX_INTRINSIC", cv::CALIB_FIX_INTRINSIC},
    {"CALIB_FIX_K1", cv::CALIB_FIX_K1},
    {"CALIB_FIX_K2", cv::CALIB_FIX_K2},
    {"CALIB_FIX_K3", cv::CALIB_FIX_K3},
    {"CALIB_FIX_K4", cv::CALIB_FIX_K4},
    {"CALIB_FIX_K5", cv::CALIB_FIX_K5},
    {"CALIB_FIX_K6", cv::CALIB_FIX_K6},
    {"CALIB_FIX_PRINCIPAL_POINT", cv::CALIB_FIX_PRINCIPAL_POINT},
    {"CALIB_FIX_S1_S2_S3_S4", cv::CALIB_FIX_S1_S2_S3_S4},
    {"CALIB_FIX_TANGENT_DIST", cv::CALIB_FIX_TANGENT_DIST},
    {"CALIB_FIX_TAUX_TAUY", cv::CALIB_FIX_TAUX_TAUY},
    {"CALIB_RATIONAL_MODEL", cv::CALIB_RATIONAL_MODEL},
    {"CALIB_SAME_FOCAL_LENGTH", cv::CALIB_SAME_FOCAL_LENGTH},
    {"CALIB_THIN_PRISM_MODEL", cv::CALIB_THIN_PRISM_MODEL},
    {"CALIB_TILTED_MODEL", cv::CALIB_TILTED_MODEL},
    {"CALIB_USE_EXTRINSIC_GUESS", cv::CALIB_USE_EXTRINSIC_GUESS},
    {"CALIB_USE_INTRINSIC_GUESS", cv::CALIB_USE_INTRINSIC_GUESS},
    {"CALIB_USE_LU", cv::CALIB_USE_LU},
    {"CALIB_USE_QR", cv::CALIB_USE_QR},
    {"CALIB_ZERO_DISPARITY", cv::CALIB_ZERO_DISPARITY},
    {"CALIB_ZERO_TANGENT_DIST", cv::CALIB_ZERO_TANGENT_DIST},
    {"CAP_ANDROID", cv::CAP_ANDROID},
    {"CAP_ANY", cv::CAP_ANY},
    {"CAP_ARAVIS", cv::CAP_ARAVIS},
    {"CAP_AVFOUNDATION", cv::CAP_AVFOUNDATION},
    {"CAP_CMU1394", cv::CAP_CMU1394},
    {"CAP_DC1394", cv::CAP_DC1394},
    {"CAP_DSHOW", cv::CAP_DSHOW},
    {"CAP_FFMPEG", cv::CAP_FFMPEG},
    {"CAP_FIREWARE", cv::CAP_FIREWARE},
    {"CAP_FIREWIRE", cv::CAP_FIREWIRE},
    {"CAP_GIGANETIX", cv::CAP_GIGANETIX},
    {"CAP_GPHOTO2", cv::CAP_GPHOTO2},
    {"CAP_GSTREAMER", cv::CAP_GSTREAMER},
    {"CAP_IEEE1394", cv::CAP_IEEE1394},
    {"CAP_IMAGES", cv::CAP_IMAGES},
    {"CAP_INTELPERC", cv::CAP_INTELPERC},
    {"CAP_INTELPERC_DEPTH_GENERATOR", cv::CAP_INTELPERC_DEPTH_GENERATOR},
    {"CAP_INTELPERC_DEPTH_MAP", cv::CAP_INTELPERC_DEPTH_MAP},
    {"CAP_INTELPERC_GENERATORS_MASK", cv::CAP_INTELPERC_GENERATORS_MASK},
    {"CAP_INTELPERC_IMAGE", cv::CAP_INTELPERC_IMAGE},
    {"CAP_INTELPERC_IMAGE_GENERATOR", cv::CAP_INTELPERC_IMAGE_GENERATOR},
    {"CAP_INTELPERC_IR_MAP", cv::CAP_INTELPERC_IR_MAP},
    {"CAP_INTELPERC_UVDEPTH_MAP", cv::CAP_INTELPERC_UVDEPTH_MAP},
    {"CAP_INTEL_MFX", cv::CAP_INTEL_MFX},
    {"CAP_MODE_BGR", cv::CAP_MODE_BGR},
    {"CAP_MODE_GRAY", cv::CAP_MODE_GRAY},
    {"CAP_MODE_RGB", cv::CAP_MODE_RGB},
    {"CAP_MODE_YUYV", cv::CAP_MODE_YUYV},
    {"CAP_MSMF", cv::CAP_MSMF},
    {"CAP_OPENCV_MJPEG", cv::CAP_OPENCV_MJPEG},
    {"CAP_OPENNI", cv::CAP_OPENNI},
    {"CAP_OPENNI2", cv::CAP_OPENNI2},
    {"CAP_OPENNI2_ASUS", cv::CAP_OPENNI2_ASUS},
    {"CAP_OPENNI_ASUS", cv::CAP_OPENNI_ASUS},
    {"CAP_OPENNI_BGR_IMAGE", cv::CAP_OPENNI_BGR_IMAGE},
    {"CAP_OPENNI_DEPTH_GENERATOR", cv::CAP_OPENNI_DEPTH_GENERATOR},
    {"CAP_OPENNI_DEPTH_GENERATOR_BASELINE", cv::CAP_OPENNI_DEPTH_GENERATOR_BASELINE},
    {"CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH", cv::CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH},
    {"CAP_OPENNI_DEPTH_GENERATOR_PRESENT", cv::CAP_OPENNI_DEPTH_GENERATOR_PRESENT},
    {"CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION", cv::CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION},
    {"CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON", cv::CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON},
    {"CAP_OPENNI_DEPTH_MAP", cv::CAP_OPENNI_DEPTH_MAP},
    {"CAP_OPENNI_DISPARITY_MAP", cv::CAP_OPENNI_DISPARITY_MAP},
    {"CAP_OPENNI_DISPARITY_MAP_32F", cv::CAP_OPENNI_DISPARITY_MAP_32F},
    {"CAP_OPENNI_GENERATORS_MASK", cv::CAP_OPENNI_GENERATORS_MASK},
    {"CAP_OPENNI_GRAY_IMAGE", cv::CAP_OPENNI_GRAY_IMAGE},
    {"CAP_OPENNI_IMAGE_GENERATOR", cv::CAP_OPENNI_IMAGE_GENERATOR},
    {"CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE", cv::CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE},
    {"CAP_OPENNI_IMAGE_GENERATOR_PRESENT", cv::CAP_OPENNI_IMAGE_GENERATOR_PRESENT},
    {"CAP_OPENNI_IR_GENERATOR", cv::CAP_OPENNI_IR_GENERATOR},
    {"CAP_OPENNI_IR_GENERATOR_PRESENT", cv::CAP_OPENNI_IR_GENERATOR_PRESENT},
    {"CAP_OPENNI_IR_IMAGE", cv::CAP_OPENNI_IR_IMAGE},
    {"CAP_OPENNI_POINT_CLOUD_MAP", cv::CAP_OPENNI_POINT_CLOUD_MAP},
    {"CAP_OPENNI_QVGA_30HZ", cv::CAP_OPENNI_QVGA_30HZ},
    {"CAP_OPENNI_QVGA_60HZ", cv::CAP_OPENNI_QVGA_60HZ},
    {"CAP_OPENNI_SXGA_15HZ", cv::CAP_OPENNI_SXGA_15HZ},
    {"CAP_OPENNI_SXGA_30HZ", cv::CAP_OPENNI_SXGA_30HZ},
    {"CAP_OPENNI_VALID_DEPTH_MASK", cv::CAP_OPENNI_VALID_DEPTH_MASK},
    {"CAP_OPENNI_VGA_30HZ", cv::CAP_OPENNI_VGA_30HZ},
    {"CAP_PROP_APERTURE", cv::CAP_PROP_APERTURE},
    {"CAP_PROP_AUTOFOCUS", cv::CAP_PROP_AUTOFOCUS},
    {"CAP_PROP_AUTO_EXPOSURE", cv::CAP_PROP_AUTO_EXPOSURE},
    {"CAP_PROP_BACKLIGHT", cv::CAP_PROP_BACKLIGHT},
    {"CAP_PROP_BRIGHTNESS", cv::CAP_PROP_BRIGHTNESS},
    {"CAP_PROP_BUFFERSIZE", cv::CAP_PROP_BUFFERSIZE},
    {"CAP_PROP_CONTRAST", cv::CAP_PROP_CONTRAST},
    {"CAP_PROP_CONVERT_RGB", cv::CAP_PROP_CONVERT_RGB},
    {"CAP_PROP_DC1394_MAX", cv::CAP_PROP_DC1394_MAX},
    {"CAP_PROP_DC1394_MODE_AUTO", cv::CAP_PROP_DC1394_MODE_AUTO},
    {"CAP_PROP_DC1394_MODE_MANUAL", cv::CAP_PROP_DC1394_MODE_MANUAL},
    {"CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO", cv::CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO},
    {"CAP_PROP_DC1394_OFF", cv::CAP_PROP_DC1394_OFF},
    {"CAP_PROP_EXPOSURE", cv::CAP_PROP_EXPOSURE},
    {"CAP_PROP_EXPOSUREPROGRAM", cv::CAP_PROP_EXPOSUREPROGRAM},
    {"CAP_PROP_FOCUS", cv::CAP_PROP_FOCUS},
    {"CAP_PROP_FORMAT", cv::CAP_PROP_FORMAT},
    {"CAP_PROP_FOURCC", cv::CAP_PROP_FOURCC},
    {"CAP_PROP_FPS", cv::CAP_PROP_FPS},
    {"CAP_PROP_FRAME_COUNT", cv::CAP_PROP_FRAME_COUNT},
    {"CAP_PROP_FRAME_HEIGHT", cv::CAP_PROP_FRAME_HEIGHT},
    {"CAP_PROP_FRAME_WIDTH", cv::CAP_PROP_FRAME_WIDTH},
    {"CAP_PROP_GAIN", cv::CAP_PROP_GAIN},
    {"CAP_PROP_GAMMA", cv::CAP_PROP_GAMMA},
    {"CAP_PROP_GIGA_FRAME_HEIGH_MAX", cv::CAP_PROP_GIGA_FRAME_HEIGH_MAX},
    {"CAP_PROP_GIGA_FRAME_OFFSET_X", cv::CAP_PROP_GIGA_FRAME_OFFSET_X},
    {"CAP_PROP_GIGA_FRAME_OFFSET_Y", cv::CAP_PROP_GIGA_FRAME_OFFSET_Y},
    {"CAP_PROP_GIGA_FRAME_SENS_HEIGH", cv::CAP_PROP_GIGA_FRAME_SENS_HEIGH},
    {"CAP_PROP_GIGA_FRAME_SENS_WIDTH", cv::CAP_PROP_GIGA_FRAME_SENS_WIDTH},
    {"CAP_PROP_GIGA_FRAME_WIDTH_MAX", cv::CAP_PROP_GIGA_FRAME_WIDTH_MAX},
    {"CAP_PROP_GPHOTO2_COLLECT_MSGS", cv::CAP_PROP_GPHOTO2_COLLECT_MSGS},
    {"CAP_PROP_GPHOTO2_FLUSH_MSGS", cv::CAP_PROP_GPHOTO2_FLUSH_MSGS},
    {"CAP_PROP_GPHOTO2_PREVIEW", cv::CAP_PROP_GPHOTO2_PREVIEW},
    {"CAP_PROP_GPHOTO2_RELOAD_CONFIG", cv::CAP_PROP_GPHOTO2_RELOAD_CONFIG},
    {"CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE", cv::CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE},
    {"CAP_PROP_GPHOTO2_WIDGET_ENUMERATE", cv::CAP_PROP_GPHOTO2_WIDGET_ENUMERATE},
    {"CAP_PROP_GSTREAMER_QUEUE_LENGTH", cv::CAP_PROP_GSTREAMER_QUEUE_LENGTH},
    {"CAP_PROP_GUID", cv::CAP_PROP_GUID},
    {"CAP_PROP_HUE", cv::CAP_PROP_HUE},
    {"CAP_PROP_IMAGES_BASE", cv::CAP_PROP_IMAGES_BASE},
    {"CAP_PROP_IMAGES_LAST", cv::CAP_PROP_IMAGES_LAST},
    {"CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD", cv::CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD},
    {"CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ", cv::CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ},
    {"CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT", cv::CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT},
    {"CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE", cv::CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE},
    {"CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE", cv::CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE},
    {"CAP_PROP_INTELPERC_PROFILE_COUNT", cv::CAP_PROP_INTELPERC_PROFILE_COUNT},
    {"CAP_PROP_INTELPERC_PROFILE_IDX", cv::CAP_PROP_INTELPERC_PROFILE_IDX},
    {"CAP_PROP_IOS_DEVICE_EXPOSURE", cv::CAP_PROP_IOS_DEVICE_EXPOSURE},
    {"CAP_PROP_IOS_DEVICE_FLASH", cv::CAP_PROP_IOS_DEVICE_FLASH},
    {"CAP_PROP_IOS_DEVICE_FOCUS", cv::CAP_PROP_IOS_DEVICE_FOCUS},
    {"CAP_PROP_IOS_DEVICE_TORCH", cv::CAP_PROP_IOS_DEVICE_TORCH},
    {"CAP_PROP_IOS_DEVICE_WHITEBALANCE", cv::CAP_PROP_IOS_DEVICE_WHITEBALANCE},
    {"CAP_PROP_IRIS", cv::CAP_PROP_IRIS},
    {"CAP_PROP_ISO_SPEED", cv::CAP_PROP_ISO_SPEED},
    {"CAP_PROP_MODE", cv::CAP_PROP_MODE},
    {"CAP_PROP_MONOCHROME", cv::CAP_PROP_MONOCHROME},
    {"CAP_PROP_OPENNI2_MIRROR", cv::CAP_PROP_OPENNI2_MIRROR},
    {"CAP_PROP_OPENNI2_SYNC", cv::CAP_PROP_OPENNI2_SYNC},
    {"CAP_PROP_OPENNI_APPROX_FRAME_SYNC", cv::CAP_PROP_OPENNI_APPROX_FRAME_SYNC},
    {"CAP_PROP_OPENNI_BASELINE", cv::CAP_PROP_OPENNI_BASELINE},
    {"CAP_PROP_OPENNI_CIRCLE_BUFFER", cv::CAP_PROP_OPENNI_CIRCLE_BUFFER},
    {"CAP_PROP_OPENNI_FOCAL_LENGTH", cv::CAP_PROP_OPENNI_FOCAL_LENGTH},
    {"CAP_PROP_OPENNI_FRAME_MAX_DEPTH", cv::CAP_PROP_OPENNI_FRAME_MAX_DEPTH},
    {"CAP_PROP_OPENNI_GENERATOR_PRESENT", cv::CAP_PROP_OPENNI_GENERATOR_PRESENT},
    {"CAP_PROP_OPENNI_MAX_BUFFER_SIZE", cv::CAP_PROP_OPENNI_MAX_BUFFER_SIZE},
    {"CAP_PROP_OPENNI_MAX_TIME_DURATION", cv::CAP_PROP_OPENNI_MAX_TIME_DURATION},
    {"CAP_PROP_OPENNI_OUTPUT_MODE", cv::CAP_PROP_OPENNI_OUTPUT_MODE},
    {"CAP_PROP_OPENNI_REGISTRATION", cv::CAP_PROP_OPENNI_REGISTRATION},
    {"CAP_PROP_OPENNI_REGISTRATION_ON", cv::CAP_PROP_OPENNI_REGISTRATION_ON},
    {"CAP_PROP_PAN", cv::CAP_PROP_PAN},
    {"CAP_PROP_POS_AVI_RATIO", cv::CAP_PROP_POS_AVI_RATIO},
    {"CAP_PROP_POS_FRAMES", cv::CAP_PROP_POS_FRAMES},
    {"CAP_PROP_POS_MSEC", cv::CAP_PROP_POS_MSEC},
    {"CAP_PROP_PVAPI_BINNINGX", cv::CAP_PROP_PVAPI_BINNINGX},
    {"CAP_PROP_PVAPI_BINNINGY", cv::CAP_PROP_PVAPI_BINNINGY},
    {"CAP_PROP_PVAPI_DECIMATIONHORIZONTAL", cv::CAP_PROP_PVAPI_DECIMATIONHORIZONTAL},
    {"CAP_PROP_PVAPI_DECIMATIONVERTICAL", cv::CAP_PROP_PVAPI_DECIMATIONVERTICAL},
    {"CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE", cv::CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE},
    {"CAP_PROP_PVAPI_MULTICASTIP", cv::CAP_PROP_PVAPI_MULTICASTIP},
    {"CAP_PROP_PVAPI_PIXELFORMAT", cv::CAP_PROP_PVAPI_PIXELFORMAT},
    {"CAP_PROP_RECTIFICATION", cv::CAP_PROP_RECTIFICATION},
    {"CAP_PROP_ROLL", cv::CAP_PROP_ROLL},
    {"CAP_PROP_SAR_DEN", cv::CAP_PROP_SAR_DEN},
    {"CAP_PROP_SAR_NUM", cv::CAP_PROP_SAR_NUM},
    {"CAP_PROP_SATURATION", cv::CAP_PROP_SATURATION},
    {"CAP_PROP_SETTINGS", cv::CAP_PROP_SETTINGS},
    {"CAP_PROP_SHARPNESS", cv::CAP_PROP_SHARPNESS},
    {"CAP_PROP_SPEED", cv::CAP_PROP_SPEED},
    {"CAP_PROP_TEMPERATURE", cv::CAP_PROP_TEMPERATURE},
    {"CAP_PROP_TILT", cv::CAP_PROP_TILT},
    {"CAP_PROP_TRIGGER", cv::CAP_PROP_TRIGGER},
    {"CAP_PROP_TRIGGER_DELAY", cv::CAP_PROP_TRIGGER_DELAY},
    {"CAP_PROP_VIEWFINDER", cv::CAP_PROP_VIEWFINDER},
    {"CAP_PROP_WHITE_BALANCE_BLUE_U", cv::CAP_PROP_WHITE_BALANCE_BLUE_U},
    {"CAP_PROP_WHITE_BALANCE_RED_V", cv::CAP_PROP_WHITE_BALANCE_RED_V},
    {"CAP_PROP_XI_ACQ_BUFFER_SIZE", cv::CAP_PROP_XI_ACQ_BUFFER_SIZE},
    {"CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT", cv::CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT},
    {"CAP_PROP_XI_ACQ_FRAME_BURST_COUNT", cv::CAP_PROP_XI_ACQ_FRAME_BURST_COUNT},
    {"CAP_PROP_XI_ACQ_TIMING_MODE", cv::CAP_PROP_XI_ACQ_TIMING_MODE},
    {"CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT", cv::CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT},
    {"CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE", cv::CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE},
    {"CAP_PROP_XI_AEAG", cv::CAP_PROP_XI_AEAG},
    {"CAP_PROP_XI_AEAG_LEVEL", cv::CAP_PROP_XI_AEAG_LEVEL},
    {"CAP_PROP_XI_AEAG_ROI_HEIGHT", cv::CAP_PROP_XI_AEAG_ROI_HEIGHT},
    {"CAP_PROP_XI_AEAG_ROI_OFFSET_X", cv::CAP_PROP_XI_AEAG_ROI_OFFSET_X},
    {"CAP_PROP_XI_AEAG_ROI_OFFSET_Y", cv::CAP_PROP_XI_AEAG_ROI_OFFSET_Y},
    {"CAP_PROP_XI_AEAG_ROI_WIDTH", cv::CAP_PROP_XI_AEAG_ROI_WIDTH},
    {"CAP_PROP_XI_AE_MAX_LIMIT", cv::CAP_PROP_XI_AE_MAX_LIMIT},
    {"CAP_PROP_XI_AG_MAX_LIMIT", cv::CAP_PROP_XI_AG_MAX_LIMIT},
    {"CAP_PROP_XI_APPLY_CMS", cv::CAP_PROP_XI_APPLY_CMS},
    {"CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION", cv::CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION},
    {"CAP_PROP_XI_AUTO_WB", cv::CAP_PROP_XI_AUTO_WB},
    {"CAP_PROP_XI_AVAILABLE_BANDWIDTH", cv::CAP_PROP_XI_AVAILABLE_BANDWIDTH},
    {"CAP_PROP_XI_BINNING_HORIZONTAL", cv::CAP_PROP_XI_BINNING_HORIZONTAL},
    {"CAP_PROP_XI_BINNING_PATTERN", cv::CAP_PROP_XI_BINNING_PATTERN},
    {"CAP_PROP_XI_BINNING_SELECTOR", cv::CAP_PROP_XI_BINNING_SELECTOR},
    {"CAP_PROP_XI_BINNING_VERTICAL", cv::CAP_PROP_XI_BINNING_VERTICAL},
    {"CAP_PROP_XI_BPC", cv::CAP_PROP_XI_BPC},
    {"CAP_PROP_XI_BUFFERS_QUEUE_SIZE", cv::CAP_PROP_XI_BUFFERS_QUEUE_SIZE},
    {"CAP_PROP_XI_BUFFER_POLICY", cv::CAP_PROP_XI_BUFFER_POLICY},
    {"CAP_PROP_XI_CC_MATRIX_00", cv::CAP_PROP_XI_CC_MATRIX_00},
    {"CAP_PROP_XI_CC_MATRIX_01", cv::CAP_PROP_XI_CC_MATRIX_01},
    {"CAP_PROP_XI_CC_MATRIX_02", cv::CAP_PROP_XI_CC_MATRIX_02},
    {"CAP_PROP_XI_CC_MATRIX_03", cv::CAP_PROP_XI_CC_MATRIX_03},
    {"CAP_PROP_XI_CC_MATRIX_10", cv::CAP_PROP_XI_CC_MATRIX_10},
    {"CAP_PROP_XI_CC_MATRIX_11", cv::CAP_PROP_XI_CC_MATRIX_11},
    {"CAP_PROP_XI_CC_MATRIX_12", cv::CAP_PROP_XI_CC_MATRIX_12},
    {"CAP_PROP_XI_CC_MATRIX_13", cv::CAP_PROP_XI_CC_MATRIX_13},
    {"CAP_PROP_XI_CC_MATRIX_20", cv::CAP_PROP_XI_CC_MATRIX_20},
    {"CAP_PROP_XI_CC_MATRIX_21", cv::CAP_PROP_XI_CC_MATRIX_21},
    {"CAP_PROP_XI_CC_MATRIX_22", cv::CAP_PROP_XI_CC_MATRIX_22},
    {"CAP_PROP_XI_CC_MATRIX_23", cv::CAP_PROP_XI_CC_MATRIX_23},
    {"CAP_PROP_XI_CC_MATRIX_30", cv::CAP_PROP_XI_CC_MATRIX_30},
    {"CAP_PROP_XI_CC_MATRIX_31", cv::CAP_PROP_XI_CC_MATRIX_31},
    {"CAP_PROP_XI_CC_MATRIX_32", cv::CAP_PROP_XI_CC_MATRIX_32},
    {"CAP_PROP_XI_CC_MATRIX_33", cv::CAP_PROP_XI_CC_MATRIX_33},
    {"CAP_PROP_XI_CHIP_TEMP", cv::CAP_PROP_XI_CHIP_TEMP},
    {"CAP_PROP_XI_CMS", cv::CAP_PROP_XI_CMS},
    {"CAP_PROP_XI_COLOR_FILTER_ARRAY", cv::CAP_PROP_XI_COLOR_FILTER_ARRAY},
    {"CAP_PROP_XI_COLUMN_FPN_CORRECTION", cv::CAP_PROP_XI_COLUMN_FPN_CORRECTION},
    {"CAP_PROP_XI_COOLING", cv::CAP_PROP_XI_COOLING},
    {"CAP_PROP_XI_COUNTER_SELECTOR", cv::CAP_PROP_XI_COUNTER_SELECTOR},
    {"CAP_PROP_XI_COUNTER_VALUE", cv::CAP_PROP_XI_COUNTER_VALUE},
    {"CAP_PROP_XI_DATA_FORMAT", cv::CAP_PROP_XI_DATA_FORMAT},
    {"CAP_PROP_XI_DEBOUNCE_EN", cv::CAP_PROP_XI_DEBOUNCE_EN},
    {"CAP_PROP_XI_DEBOUNCE_POL", cv::CAP_PROP_XI_DEBOUNCE_POL},
    {"CAP_PROP_XI_DEBOUNCE_T0", cv::CAP_PROP_XI_DEBOUNCE_T0},
    {"CAP_PROP_XI_DEBOUNCE_T1", cv::CAP_PROP_XI_DEBOUNCE_T1},
    {"CAP_PROP_XI_DEBUG_LEVEL", cv::CAP_PROP_XI_DEBUG_LEVEL},
    {"CAP_PROP_XI_DECIMATION_HORIZONTAL", cv::CAP_PROP_XI_DECIMATION_HORIZONTAL},
    {"CAP_PROP_XI_DECIMATION_PATTERN", cv::CAP_PROP_XI_DECIMATION_PATTERN},
    {"CAP_PROP_XI_DECIMATION_SELECTOR", cv::CAP_PROP_XI_DECIMATION_SELECTOR},
    {"CAP_PROP_XI_DECIMATION_VERTICAL", cv::CAP_PROP_XI_DECIMATION_VERTICAL},
    {"CAP_PROP_XI_DEFAULT_CC_MATRIX", cv::CAP_PROP_XI_DEFAULT_CC_MATRIX},
    {"CAP_PROP_XI_DEVICE_MODEL_ID", cv::CAP_PROP_XI_DEVICE_MODEL_ID},
    {"CAP_PROP_XI_DEVICE_RESET", cv::CAP_PROP_XI_DEVICE_RESET},
    {"CAP_PROP_XI_DEVICE_SN", cv::CAP_PROP_XI_DEVICE_SN},
    {"CAP_PROP_XI_DOWNSAMPLING", cv::CAP_PROP_XI_DOWNSAMPLING},
    {"CAP_PROP_XI_DOWNSAMPLING_TYPE", cv::CAP_PROP_XI_DOWNSAMPLING_TYPE},
    {"CAP_PROP_XI_EXPOSURE", cv::CAP_PROP_XI_EXPOSURE},
    {"CAP_PROP_XI_EXPOSURE_BURST_COUNT", cv::CAP_PROP_XI_EXPOSURE_BURST_COUNT},
    {"CAP_PROP_XI_EXP_PRIORITY", cv::CAP_PROP_XI_EXP_PRIORITY},
    {"CAP_PROP_XI_FFS_ACCESS_KEY", cv::CAP_PROP_XI_FFS_ACCESS_KEY},
    {"CAP_PROP_XI_FFS_FILE_ID", cv::CAP_PROP_XI_FFS_FILE_ID},
    {"CAP_PROP_XI_FFS_FILE_SIZE", cv::CAP_PROP_XI_FFS_FILE_SIZE},
    {"CAP_PROP_XI_FRAMERATE", cv::CAP_PROP_XI_FRAMERATE},
    {"CAP_PROP_XI_FREE_FFS_SIZE", cv::CAP_PROP_XI_FREE_FFS_SIZE},
    {"CAP_PROP_XI_GAIN", cv::CAP_PROP_XI_GAIN},
    {"CAP_PROP_XI_GAIN_SELECTOR", cv::CAP_PROP_XI_GAIN_SELECTOR},
    {"CAP_PROP_XI_GAMMAC", cv::CAP_PROP_XI_GAMMAC},
    {"CAP_PROP_XI_GAMMAY", cv::CAP_PROP_XI_GAMMAY},
    {"CAP_PROP_XI_GPI_LEVEL", cv::CAP_PROP_XI_GPI_LEVEL},
    {"CAP_PROP_XI_GPI_MODE", cv::CAP_PROP_XI_GPI_MODE},
    {"CAP_PROP_XI_GPI_SELECTOR", cv::CAP_PROP_XI_GPI_SELECTOR},
    {"CAP_PROP_XI_GPO_MODE", cv::CAP_PROP_XI_GPO_MODE},
    {"CAP_PROP_XI_GPO_SELECTOR", cv::CAP_PROP_XI_GPO_SELECTOR},
    {"CAP_PROP_XI_HDR", cv::CAP_PROP_XI_HDR},
    {"CAP_PROP_XI_HDR_KNEEPOINT_COUNT", cv::CAP_PROP_XI_HDR_KNEEPOINT_COUNT},
    {"CAP_PROP_XI_HDR_T1", cv::CAP_PROP_XI_HDR_T1},
    {"CAP_PROP_XI_HDR_T2", cv::CAP_PROP_XI_HDR_T2},
    {"CAP_PROP_XI_HEIGHT", cv::CAP_PROP_XI_HEIGHT},
    {"CAP_PROP_XI_HOUS_BACK_SIDE_TEMP", cv::CAP_PROP_XI_HOUS_BACK_SIDE_TEMP},
    {"CAP_PROP_XI_HOUS_TEMP", cv::CAP_PROP_XI_HOUS_TEMP},
    {"CAP_PROP_XI_HW_REVISION", cv::CAP_PROP_XI_HW_REVISION},
    {"CAP_PROP_XI_IMAGE_BLACK_LEVEL", cv::CAP_PROP_XI_IMAGE_BLACK_LEVEL},
    {"CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH", cv::CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH},
    {"CAP_PROP_XI_IMAGE_DATA_FORMAT", cv::CAP_PROP_XI_IMAGE_DATA_FORMAT},
    {"CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA", cv::CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA},
    {"CAP_PROP_XI_IMAGE_IS_COLOR", cv::CAP_PROP_XI_IMAGE_IS_COLOR},
    {"CAP_PROP_XI_IMAGE_PAYLOAD_SIZE", cv::CAP_PROP_XI_IMAGE_PAYLOAD_SIZE},
    {"CAP_PROP_XI_IS_COOLED", cv::CAP_PROP_XI_IS_COOLED},
    {"CAP_PROP_XI_IS_DEVICE_EXIST", cv::CAP_PROP_XI_IS_DEVICE_EXIST},
    {"CAP_PROP_XI_KNEEPOINT1", cv::CAP_PROP_XI_KNEEPOINT1},
    {"CAP_PROP_XI_KNEEPOINT2", cv::CAP_PROP_XI_KNEEPOINT2},
    {"CAP_PROP_XI_LED_MODE", cv::CAP_PROP_XI_LED_MODE},
    {"CAP_PROP_XI_LED_SELECTOR", cv::CAP_PROP_XI_LED_SELECTOR},
    {"CAP_PROP_XI_LENS_APERTURE_VALUE", cv::CAP_PROP_XI_LENS_APERTURE_VALUE},
    {"CAP_PROP_XI_LENS_FEATURE", cv::CAP_PROP_XI_LENS_FEATURE},
    {"CAP_PROP_XI_LENS_FEATURE_SELECTOR", cv::CAP_PROP_XI_LENS_FEATURE_SELECTOR},
    {"CAP_PROP_XI_LENS_FOCAL_LENGTH", cv::CAP_PROP_XI_LENS_FOCAL_LENGTH},
    {"CAP_PROP_XI_LENS_FOCUS_DISTANCE", cv::CAP_PROP_XI_LENS_FOCUS_DISTANCE},
    {"CAP_PROP_XI_LENS_FOCUS_MOVE", cv::CAP_PROP_XI_LENS_FOCUS_MOVE},
    {"CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE", cv::CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE},
    {"CAP_PROP_XI_LENS_MODE", cv::CAP_PROP_XI_LENS_MODE},
    {"CAP_PROP_XI_LIMIT_BANDWIDTH", cv::CAP_PROP_XI_LIMIT_BANDWIDTH},
    {"CAP_PROP_XI_LUT_EN", cv::CAP_PROP_XI_LUT_EN},
    {"CAP_PROP_XI_LUT_INDEX", cv::CAP_PROP_XI_LUT_INDEX},
    {"CAP_PROP_XI_LUT_VALUE", cv::CAP_PROP_XI_LUT_VALUE},
    {"CAP_PROP_XI_MANUAL_WB", cv::CAP_PROP_XI_MANUAL_WB},
    {"CAP_PROP_XI_OFFSET_X", cv::CAP_PROP_XI_OFFSET_X},
    {"CAP_PROP_XI_OFFSET_Y", cv::CAP_PROP_XI_OFFSET_Y},
    {"CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH", cv::CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH},
    {"CAP_PROP_XI_OUTPUT_DATA_PACKING", cv::CAP_PROP_XI_OUTPUT_DATA_PACKING},
    {"CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE", cv::CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE},
    {"CAP_PROP_XI_RECENT_FRAME", cv::CAP_PROP_XI_RECENT_FRAME},
    {"CAP_PROP_XI_REGION_MODE", cv::CAP_PROP_XI_REGION_MODE},
    {"CAP_PROP_XI_REGION_SELECTOR", cv::CAP_PROP_XI_REGION_SELECTOR},
    {"CAP_PROP_XI_ROW_FPN_CORRECTION", cv::CAP_PROP_XI_ROW_FPN_CORRECTION},
    {"CAP_PROP_XI_SENSOR_BOARD_TEMP", cv::CAP_PROP_XI_SENSOR_BOARD_TEMP},
    {"CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ", cv::CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ},
    {"CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX", cv::CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX},
    {"CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH", cv::CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH},
    {"CAP_PROP_XI_SENSOR_FEATURE_SELECTOR", cv::CAP_PROP_XI_SENSOR_FEATURE_SELECTOR},
    {"CAP_PROP_XI_SENSOR_FEATURE_VALUE", cv::CAP_PROP_XI_SENSOR_FEATURE_VALUE},
    {"CAP_PROP_XI_SENSOR_MODE", cv::CAP_PROP_XI_SENSOR_MODE},
    {"CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT", cv::CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT},
    {"CAP_PROP_XI_SENSOR_TAPS", cv::CAP_PROP_XI_SENSOR_TAPS},
    {"CAP_PROP_XI_SHARPNESS", cv::CAP_PROP_XI_SHARPNESS},
    {"CAP_PROP_XI_SHUTTER_TYPE", cv::CAP_PROP_XI_SHUTTER_TYPE},
    {"CAP_PROP_XI_TARGET_TEMP", cv::CAP_PROP_XI_TARGET_TEMP},
    {"CAP_PROP_XI_TEST_PATTERN", cv::CAP_PROP_XI_TEST_PATTERN},
    {"CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR", cv::CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR},
    {"CAP_PROP_XI_TIMEOUT", cv::CAP_PROP_XI_TIMEOUT},
    {"CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT", cv::CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT},
    {"CAP_PROP_XI_TRG_DELAY", cv::CAP_PROP_XI_TRG_DELAY},
    {"CAP_PROP_XI_TRG_SELECTOR", cv::CAP_PROP_XI_TRG_SELECTOR},
    {"CAP_PROP_XI_TRG_SOFTWARE", cv::CAP_PROP_XI_TRG_SOFTWARE},
    {"CAP_PROP_XI_TRG_SOURCE", cv::CAP_PROP_XI_TRG_SOURCE},
    {"CAP_PROP_XI_TS_RST_MODE", cv::CAP_PROP_XI_TS_RST_MODE},
    {"CAP_PROP_XI_TS_RST_SOURCE", cv::CAP_PROP_XI_TS_RST_SOURCE},
    {"CAP_PROP_XI_USED_FFS_SIZE", cv::CAP_PROP_XI_USED_FFS_SIZE},
    {"CAP_PROP_XI_WB_KB", cv::CAP_PROP_XI_WB_KB},
    {"CAP_PROP_XI_WB_KG", cv::CAP_PROP_XI_WB_KG},
    {"CAP_PROP_XI_WB_KR", cv::CAP_PROP_XI_WB_KR},
    {"CAP_PROP_XI_WIDTH", cv::CAP_PROP_XI_WIDTH},
    {"CAP_PROP_ZOOM", cv::CAP_PROP_ZOOM},
    {"CAP_PVAPI", cv::CAP_PVAPI},
    {"CAP_PVAPI_DECIMATION_2OUTOF16", cv::CAP_PVAPI_DECIMATION_2OUTOF16},
    {"CAP_PVAPI_DECIMATION_2OUTOF4", cv::CAP_PVAPI_DECIMATION_2OUTOF4},
    {"CAP_PVAPI_DECIMATION_2OUTOF8", cv::CAP_PVAPI_DECIMATION_2OUTOF8},
    {"CAP_PVAPI_DECIMATION_OFF", cv::CAP_PVAPI_DECIMATION_OFF},
    {"CAP_PVAPI_FSTRIGMODE_FIXEDRATE", cv::CAP_PVAPI_FSTRIGMODE_FIXEDRATE},
    {"CAP_PVAPI_FSTRIGMODE_FREERUN", cv::CAP_PVAPI_FSTRIGMODE_FREERUN},
    {"CAP_PVAPI_FSTRIGMODE_SOFTWARE", cv::CAP_PVAPI_FSTRIGMODE_SOFTWARE},
    {"CAP_PVAPI_FSTRIGMODE_SYNCIN1", cv::CAP_PVAPI_FSTRIGMODE_SYNCIN1},
    {"CAP_PVAPI_FSTRIGMODE_SYNCIN2", cv::CAP_PVAPI_FSTRIGMODE_SYNCIN2},
    {"CAP_PVAPI_PIXELFORMAT_BAYER16", cv::CAP_PVAPI_PIXELFORMAT_BAYER16},
    {"CAP_PVAPI_PIXELFORMAT_BAYER8", cv::CAP_PVAPI_PIXELFORMAT_BAYER8},
    {"CAP_PVAPI_PIXELFORMAT_BGR24", cv::CAP_PVAPI_PIXELFORMAT_BGR24},
    {"CAP_PVAPI_PIXELFORMAT_BGRA32", cv::CAP_PVAPI_PIXELFORMAT_BGRA32},
    {"CAP_PVAPI_PIXELFORMAT_MONO16", cv::CAP_PVAPI_PIXELFORMAT_MONO16},
    {"CAP_PVAPI_PIXELFORMAT_MONO8", cv::CAP_PVAPI_PIXELFORMAT_MONO8},
    {"CAP_PVAPI_PIXELFORMAT_RGB24", cv::CAP_PVAPI_PIXELFORMAT_RGB24},
    {"CAP_PVAPI_PIXELFORMAT_RGBA32", cv::CAP_PVAPI_PIXELFORMAT_RGBA32},
    {"CAP_QT", cv::CAP_QT},
    {"CAP_UNICAP", cv::CAP_UNICAP},
    {"CAP_V4L", cv::CAP_V4L},
    {"CAP_V4L2", cv::CAP_V4L2},
    {"CAP_VFW", cv::CAP_VFW},
    {"CAP_WINRT", cv::CAP_WINRT},
    {"CAP_XIAPI", cv::CAP_XIAPI},
    {"CASCADE_DO_CANNY_PRUNING", cv::CASCADE_DO_CANNY_PRUNING},
    {"CASCADE_DO_ROUGH_SEARCH", cv::CASCADE_DO_ROUGH_SEARCH},
    {"CASCADE_FIND_BIGGEST_OBJECT", cv::CASCADE_FIND_BIGGEST_OBJECT},
    {"CASCADE_SCALE_IMAGE", cv::CASCADE_SCALE_IMAGE},
    {"CCL_DEFAULT", cv::CCL_DEFAULT},
    {"CCL_GRANA", cv::CCL_GRANA},
    {"CCL_WU", cv::CCL_WU},
    {"CC_STAT_AREA", cv::CC_STAT_AREA},
    {"CC_STAT_HEIGHT", cv::CC_STAT_HEIGHT},
    {"CC_STAT_LEFT", cv::CC_STAT_LEFT},
    {"CC_STAT_MAX", cv::CC_STAT_MAX},
    {"CC_STAT_TOP", cv::CC_STAT_TOP},
    {"CC_STAT_WIDTH", cv::CC_STAT_WIDTH},
    {"CHAIN_APPROX_NONE", cv::CHAIN_APPROX_NONE},
    {"CHAIN_APPROX_SIMPLE", cv::CHAIN_APPROX_SIMPLE},
    {"CHAIN_APPROX_TC89_KCOS", cv::CHAIN_APPROX_TC89_KCOS},
    {"CHAIN_APPROX_TC89_L1", cv::CHAIN_APPROX_TC89_L1},
    {"CMP_EQ", cv::CMP_EQ},
    {"CMP_GE", cv::CMP_GE},
    {"CMP_GT", cv::CMP_GT},
    {"CMP_LE", cv::CMP_LE},
    {"CMP_LT", cv::CMP_LT},
    {"CMP_NE", cv::CMP_NE},
    {"COLORMAP_AUTUMN", cv::COLORMAP_AUTUMN},
    {"COLORMAP_BONE", cv::COLORMAP_BONE},
    {"COLORMAP_COOL", cv::COLORMAP_COOL},
    {"COLORMAP_HOT", cv::COLORMAP_HOT},
    {"COLORMAP_HSV", cv::COLORMAP_HSV},
    {"COLORMAP_JET", cv::COLORMAP_JET},
    {"COLORMAP_OCEAN", cv::COLORMAP_OCEAN},
    {"COLORMAP_PARULA", cv::COLORMAP_PARULA},
    {"COLORMAP_PINK", cv::COLORMAP_PINK},
    {"COLORMAP_RAINBOW", cv::COLORMAP_RAINBOW},
    {"COLORMAP_SPRING", cv::COLORMAP_SPRING},
    {"COLORMAP_SUMMER", cv::COLORMAP_SUMMER},
    {"COLORMAP_WINTER", cv::COLORMAP_WINTER},
    {"COLORSPACE_BGR", cv::COLORSPACE_BGR},
    {"COLORSPACE_GRAY", cv::COLORSPACE_GRAY},
    {"COLORSPACE_RGBA", cv::COLORSPACE_RGBA},
    {"COLORSPACE_YUV444P", cv::COLORSPACE_YUV444P},
    {"COLOR_BGR2BGR555", cv::COLOR_BGR2BGR555},
    {"COLOR_BGR2BGR565", cv::COLOR_BGR2BGR565},
    {"COLOR_BGR2BGRA", cv::COLOR_BGR2BGRA},
    {"COLOR_BGR2GRAY", cv::COLOR_BGR2GRAY},
    {"COLOR_BGR2HLS", cv::COLOR_BGR2HLS},
    {"COLOR_BGR2HLS_FULL", cv::COLOR_BGR2HLS_FULL},
    {"COLOR_BGR2HSV", cv::COLOR_BGR2HSV},
    {"COLOR_BGR2HSV_FULL", cv::COLOR_BGR2HSV_FULL},
    {"COLOR_BGR2Lab", cv::COLOR_BGR2Lab},
    {"COLOR_BGR2LAB", cv::COLOR_BGR2Lab},
    {"COLOR_BGR2Luv", cv::COLOR_BGR2Luv},
    {"COLOR_BGR2LUV", cv::COLOR_BGR2Luv},
    {"COLOR_BGR2RGB", cv::COLOR_BGR2RGB},
    {"COLOR_BGR2RGBA", cv::COLOR_BGR2RGBA},
    {"COLOR_BGR2XYZ", cv::COLOR_BGR2XYZ},
    {"COLOR_BGR2YCrCb", cv::COLOR_BGR2YCrCb},
    {"COLOR_BGR2YCR_CB", cv::COLOR_BGR2YCrCb},
    {"COLOR_BGR2YUV", cv::COLOR_BGR2YUV},
    {"COLOR_BGR2YUV_I420", cv::COLOR_BGR2YUV_I420},
    {"COLOR_BGR2YUV_IYUV", cv::COLOR_BGR2YUV_IYUV},
    {"COLOR_BGR2YUV_YV12", cv::COLOR_BGR2YUV_YV12},
    {"COLOR_BGR5552BGR", cv::COLOR_BGR5552BGR},
    {"COLOR_BGR5552BGRA", cv::COLOR_BGR5552BGRA},
    {"COLOR_BGR5552GRAY", cv::COLOR_BGR5552GRAY},
    {"COLOR_BGR5552RGB", cv::COLOR_BGR5552RGB},
    {"COLOR_BGR5552RGBA", cv::COLOR_BGR5552RGBA},
    {"COLOR_BGR5652BGR", cv::COLOR_BGR5652BGR},
    {"COLOR_BGR5652BGRA", cv::COLOR_BGR5652BGRA},
    {"COLOR_BGR5652GRAY", cv::COLOR_BGR5652GRAY},
    {"COLOR_BGR5652RGB", cv::COLOR_BGR5652RGB},
    {"COLOR_BGR5652RGBA", cv::COLOR_BGR5652RGBA},
    {"COLOR_BGRA2BGR", cv::COLOR_BGRA2BGR},
    {"COLOR_BGRA2BGR555", cv::COLOR_BGRA2BGR555},
    {"COLOR_BGRA2BGR565", cv::COLOR_BGRA2BGR565},
    {"COLOR_BGRA2GRAY", cv::COLOR_BGRA2GRAY},
    {"COLOR_BGRA2RGB", cv::COLOR_BGRA2RGB},
    {"COLOR_BGRA2RGBA", cv::COLOR_BGRA2RGBA},
    {"COLOR_BGRA2YUV_I420", cv::COLOR_BGRA2YUV_I420},
    {"COLOR_BGRA2YUV_IYUV", cv::COLOR_BGRA2YUV_IYUV},
    {"COLOR_BGRA2YUV_YV12", cv::COLOR_BGRA2YUV_YV12},
    {"COLOR_BayerBG2BGR", cv::COLOR_BayerBG2BGR},
    {"COLOR_BAYER_BG2BGR", cv::COLOR_BayerBG2BGR},
    {"COLOR_BayerBG2BGRA", cv::COLOR_BayerBG2BGRA},
    {"COLOR_BAYER_BG2BGRA", cv::COLOR_BayerBG2BGRA},
    {"COLOR_BayerBG2BGR_EA", cv::COLOR_BayerBG2BGR_EA},
    {"COLOR_BAYER_BG2BGR_EA", cv::COLOR_BayerBG2BGR_EA},
    {"COLOR_BayerBG2BGR_VNG", cv::COLOR_BayerBG2BGR_VNG},
    {"COLOR_BAYER_BG2BGR_VNG", cv::COLOR_BayerBG2BGR_VNG},
    {"COLOR_BayerBG2GRAY", cv::COLOR_BayerBG2GRAY},
    {"COLOR_BAYER_BG2GRAY", cv::COLOR_BayerBG2GRAY},
    {"COLOR_BayerBG2RGB", cv::COLOR_BayerBG2RGB},
    {"COLOR_BAYER_BG2RGB", cv::COLOR_BayerBG2RGB},
    {"COLOR_BayerBG2RGBA", cv::COLOR_BayerBG2RGBA},
    {"COLOR_BAYER_BG2RGBA", cv::COLOR_BayerBG2RGBA},
    {"COLOR_BayerBG2RGB_EA", cv::COLOR_BayerBG2RGB_EA},
    {"COLOR_BAYER_BG2RGB_EA", cv::COLOR_BayerBG2RGB_EA},
    {"COLOR_BayerBG2RGB_VNG", cv::COLOR_BayerBG2RGB_VNG},
    {"COLOR_BAYER_BG2RGB_VNG", cv::COLOR_BayerBG2RGB_VNG},
    {"COLOR_BayerGB2BGR", cv::COLOR_BayerGB2BGR},
    {"COLOR_BAYER_GB2BGR", cv::COLOR_BayerGB2BGR},
    {"COLOR_BayerGB2BGRA", cv::COLOR_BayerGB2BGRA},
    {"COLOR_BAYER_GB2BGRA", cv::COLOR_BayerGB2BGRA},
    {"COLOR_BayerGB2BGR_EA", cv::COLOR_BayerGB2BGR_EA},
    {"COLOR_BAYER_GB2BGR_EA", cv::COLOR_BayerGB2BGR_EA},
    {"COLOR_BayerGB2BGR_VNG", cv::COLOR_BayerGB2BGR_VNG},
    {"COLOR_BAYER_GB2BGR_VNG", cv::COLOR_BayerGB2BGR_VNG},
    {"COLOR_BayerGB2GRAY", cv::COLOR_BayerGB2GRAY},
    {"COLOR_BAYER_GB2GRAY", cv::COLOR_BayerGB2GRAY},
    {"COLOR_BayerGB2RGB", cv::COLOR_BayerGB2RGB},
    {"COLOR_BAYER_GB2RGB", cv::COLOR_BayerGB2RGB},
    {"COLOR_BayerGB2RGBA", cv::COLOR_BayerGB2RGBA},
    {"COLOR_BAYER_GB2RGBA", cv::COLOR_BayerGB2RGBA},
    {"COLOR_BayerGB2RGB_EA", cv::COLOR_BayerGB2RGB_EA},
    {"COLOR_BAYER_GB2RGB_EA", cv::COLOR_BayerGB2RGB_EA},
    {"COLOR_BayerGB2RGB_VNG", cv::COLOR_BayerGB2RGB_VNG},
    {"COLOR_BAYER_GB2RGB_VNG", cv::COLOR_BayerGB2RGB_VNG},
    {"COLOR_BayerGR2BGR", cv::COLOR_BayerGR2BGR},
    {"COLOR_BAYER_GR2BGR", cv::COLOR_BayerGR2BGR},
    {"COLOR_BayerGR2BGRA", cv::COLOR_BayerGR2BGRA},
    {"COLOR_BAYER_GR2BGRA", cv::COLOR_BayerGR2BGRA},
    {"COLOR_BayerGR2BGR_EA", cv::COLOR_BayerGR2BGR_EA},
    {"COLOR_BAYER_GR2BGR_EA", cv::COLOR_BayerGR2BGR_EA},
    {"COLOR_BayerGR2BGR_VNG", cv::COLOR_BayerGR2BGR_VNG},
    {"COLOR_BAYER_GR2BGR_VNG", cv::COLOR_BayerGR2BGR_VNG},
    {"COLOR_BayerGR2GRAY", cv::COLOR_BayerGR2GRAY},
    {"COLOR_BAYER_GR2GRAY", cv::COLOR_BayerGR2GRAY},
    {"COLOR_BayerGR2RGB", cv::COLOR_BayerGR2RGB},
    {"COLOR_BAYER_GR2RGB", cv::COLOR_BayerGR2RGB},
    {"COLOR_BayerGR2RGBA", cv::COLOR_BayerGR2RGBA},
    {"COLOR_BAYER_GR2RGBA", cv::COLOR_BayerGR2RGBA},
    {"COLOR_BayerGR2RGB_EA", cv::COLOR_BayerGR2RGB_EA},
    {"COLOR_BAYER_GR2RGB_EA", cv::COLOR_BayerGR2RGB_EA},
    {"COLOR_BayerGR2RGB_VNG", cv::COLOR_BayerGR2RGB_VNG},
    {"COLOR_BAYER_GR2RGB_VNG", cv::COLOR_BayerGR2RGB_VNG},
    {"COLOR_BayerRG2BGR", cv::COLOR_BayerRG2BGR},
    {"COLOR_BAYER_RG2BGR", cv::COLOR_BayerRG2BGR},
    {"COLOR_BayerRG2BGRA", cv::COLOR_BayerRG2BGRA},
    {"COLOR_BAYER_RG2BGRA", cv::COLOR_BayerRG2BGRA},
    {"COLOR_BayerRG2BGR_EA", cv::COLOR_BayerRG2BGR_EA},
    {"COLOR_BAYER_RG2BGR_EA", cv::COLOR_BayerRG2BGR_EA},
    {"COLOR_BayerRG2BGR_VNG", cv::COLOR_BayerRG2BGR_VNG},
    {"COLOR_BAYER_RG2BGR_VNG", cv::COLOR_BayerRG2BGR_VNG},
    {"COLOR_BayerRG2GRAY", cv::COLOR_BayerRG2GRAY},
    {"COLOR_BAYER_RG2GRAY", cv::COLOR_BayerRG2GRAY},
    {"COLOR_BayerRG2RGB", cv::COLOR_BayerRG2RGB},
    {"COLOR_BAYER_RG2RGB", cv::COLOR_BayerRG2RGB},
    {"COLOR_BayerRG2RGBA", cv::COLOR_BayerRG2RGBA},
    {"COLOR_BAYER_RG2RGBA", cv::COLOR_BayerRG2RGBA},
    {"COLOR_BayerRG2RGB_EA", cv::COLOR_BayerRG2RGB_EA},
    {"COLOR_BAYER_RG2RGB_EA", cv::COLOR_BayerRG2RGB_EA},
    {"COLOR_BayerRG2RGB_VNG", cv::COLOR_BayerRG2RGB_VNG},
    {"COLOR_BAYER_RG2RGB_VNG", cv::COLOR_BayerRG2RGB_VNG},
    {"COLOR_COLORCVT_MAX", cv::COLOR_COLORCVT_MAX},
    {"COLOR_GRAY2BGR", cv::COLOR_GRAY2BGR},
    {"COLOR_GRAY2BGR555", cv::COLOR_GRAY2BGR555},
    {"COLOR_GRAY2BGR565", cv::COLOR_GRAY2BGR565},
    {"COLOR_GRAY2BGRA", cv::COLOR_GRAY2BGRA},
    {"COLOR_GRAY2RGB", cv::COLOR_GRAY2RGB},
    {"COLOR_GRAY2RGBA", cv::COLOR_GRAY2RGBA},
    {"COLOR_HLS2BGR", cv::COLOR_HLS2BGR},
    {"COLOR_HLS2BGR_FULL", cv::COLOR_HLS2BGR_FULL},
    {"COLOR_HLS2RGB", cv::COLOR_HLS2RGB},
    {"COLOR_HLS2RGB_FULL", cv::COLOR_HLS2RGB_FULL},
    {"COLOR_HSV2BGR", cv::COLOR_HSV2BGR},
    {"COLOR_HSV2BGR_FULL", cv::COLOR_HSV2BGR_FULL},
    {"COLOR_HSV2RGB", cv::COLOR_HSV2RGB},
    {"COLOR_HSV2RGB_FULL", cv::COLOR_HSV2RGB_FULL},
    {"COLOR_LBGR2Lab", cv::COLOR_LBGR2Lab},
    {"COLOR_LBGR2LAB", cv::COLOR_LBGR2Lab},
    {"COLOR_LBGR2Luv", cv::COLOR_LBGR2Luv},
    {"COLOR_LBGR2LUV", cv::COLOR_LBGR2Luv},
    {"COLOR_LRGB2Lab", cv::COLOR_LRGB2Lab},
    {"COLOR_LRGB2LAB", cv::COLOR_LRGB2Lab},
    {"COLOR_LRGB2Luv", cv::COLOR_LRGB2Luv},
    {"COLOR_LRGB2LUV", cv::COLOR_LRGB2Luv},
    {"COLOR_Lab2BGR", cv::COLOR_Lab2BGR},
    {"COLOR_LAB2BGR", cv::COLOR_Lab2BGR},
    {"COLOR_Lab2LBGR", cv::COLOR_Lab2LBGR},
    {"COLOR_LAB2LBGR", cv::COLOR_Lab2LBGR},
    {"COLOR_Lab2LRGB", cv::COLOR_Lab2LRGB},
    {"COLOR_LAB2LRGB", cv::COLOR_Lab2LRGB},
    {"COLOR_Lab2RGB", cv::COLOR_Lab2RGB},
    {"COLOR_LAB2RGB", cv::COLOR_Lab2RGB},
    {"COLOR_Luv2BGR", cv::COLOR_Luv2BGR},
    {"COLOR_LUV2BGR", cv::COLOR_Luv2BGR},
    {"COLOR_Luv2LBGR", cv::COLOR_Luv2LBGR},
    {"COLOR_LUV2LBGR", cv::COLOR_Luv2LBGR},
    {"COLOR_Luv2LRGB", cv::COLOR_Luv2LRGB},
    {"COLOR_LUV2LRGB", cv::COLOR_Luv2LRGB},
    {"COLOR_Luv2RGB", cv::COLOR_Luv2RGB},
    {"COLOR_LUV2RGB", cv::COLOR_Luv2RGB},
    {"COLOR_RGB2BGR", cv::COLOR_RGB2BGR},
    {"COLOR_RGB2BGR555", cv::COLOR_RGB2BGR555},
    {"COLOR_RGB2BGR565", cv::COLOR_RGB2BGR565},
    {"COLOR_RGB2BGRA", cv::COLOR_RGB2BGRA},
    {"COLOR_RGB2GRAY", cv::COLOR_RGB2GRAY},
    {"COLOR_RGB2HLS", cv::COLOR_RGB2HLS},
    {"COLOR_RGB2HLS_FULL", cv::COLOR_RGB2HLS_FULL},
    {"COLOR_RGB2HSV", cv::COLOR_RGB2HSV},
    {"COLOR_RGB2HSV_FULL", cv::COLOR_RGB2HSV_FULL},
    {"COLOR_RGB2Lab", cv::COLOR_RGB2Lab},
    {"COLOR_RGB2LAB", cv::COLOR_RGB2Lab},
    {"COLOR_RGB2Luv", cv::COLOR_RGB2Luv},
    {"COLOR_RGB2LUV", cv::COLOR_RGB2Luv},
    {"COLOR_RGB2RGBA", cv::COLOR_RGB2RGBA},
    {"COLOR_RGB2XYZ", cv::COLOR_RGB2XYZ},
    {"COLOR_RGB2YCrCb", cv::COLOR_RGB2YCrCb},
    {"COLOR_RGB2YCR_CB", cv::COLOR_RGB2YCrCb},
    {"COLOR_RGB2YUV", cv::COLOR_RGB2YUV},
    {"COLOR_RGB2YUV_I420", cv::COLOR_RGB2YUV_I420},
    {"COLOR_RGB2YUV_IYUV", cv::COLOR_RGB2YUV_IYUV},
    {"COLOR_RGB2YUV_YV12", cv::COLOR_RGB2YUV_YV12},
    {"COLOR_RGBA2BGR", cv::COLOR_RGBA2BGR},
    {"COLOR_RGBA2BGR555", cv::COLOR_RGBA2BGR555},
    {"COLOR_RGBA2BGR565", cv::COLOR_RGBA2BGR565},
    {"COLOR_RGBA2BGRA", cv::COLOR_RGBA2BGRA},
    {"COLOR_RGBA2GRAY", cv::COLOR_RGBA2GRAY},
    {"COLOR_RGBA2RGB", cv::COLOR_RGBA2RGB},
    {"COLOR_RGBA2YUV_I420", cv::COLOR_RGBA2YUV_I420},
    {"COLOR_RGBA2YUV_IYUV", cv::COLOR_RGBA2YUV_IYUV},
    {"COLOR_RGBA2YUV_YV12", cv::COLOR_RGBA2YUV_YV12},
    {"COLOR_RGBA2mRGBA", cv::COLOR_RGBA2mRGBA},
    {"COLOR_RGBA2M_RGBA", cv::COLOR_RGBA2mRGBA},
    {"COLOR_XYZ2BGR", cv::COLOR_XYZ2BGR},
    {"COLOR_XYZ2RGB", cv::COLOR_XYZ2RGB},
    {"COLOR_YCrCb2BGR", cv::COLOR_YCrCb2BGR},
    {"COLOR_YCR_CB2BGR", cv::COLOR_YCrCb2BGR},
    {"COLOR_YCrCb2RGB", cv::COLOR_YCrCb2RGB},
    {"COLOR_YCR_CB2RGB", cv::COLOR_YCrCb2RGB},
    {"COLOR_YUV2BGR", cv::COLOR_YUV2BGR},
    {"COLOR_YUV2BGRA_I420", cv::COLOR_YUV2BGRA_I420},
    {"COLOR_YUV2BGRA_IYUV", cv::COLOR_YUV2BGRA_IYUV},
    {"COLOR_YUV2BGRA_NV12", cv::COLOR_YUV2BGRA_NV12},
    {"COLOR_YUV2BGRA_NV21", cv::COLOR_YUV2BGRA_NV21},
    {"COLOR_YUV2BGRA_UYNV", cv::COLOR_YUV2BGRA_UYNV},
    {"COLOR_YUV2BGRA_UYVY", cv::COLOR_YUV2BGRA_UYVY},
    {"COLOR_YUV2BGRA_Y422", cv::COLOR_YUV2BGRA_Y422},
    {"COLOR_YUV2BGRA_YUNV", cv::COLOR_YUV2BGRA_YUNV},
    {"COLOR_YUV2BGRA_YUY2", cv::COLOR_YUV2BGRA_YUY2},
    {"COLOR_YUV2BGRA_YUYV", cv::COLOR_YUV2BGRA_YUYV},
    {"COLOR_YUV2BGRA_YV12", cv::COLOR_YUV2BGRA_YV12},
    {"COLOR_YUV2BGRA_YVYU", cv::COLOR_YUV2BGRA_YVYU},
    {"COLOR_YUV2BGR_I420", cv::COLOR_YUV2BGR_I420},
    {"COLOR_YUV2BGR_IYUV", cv::COLOR_YUV2BGR_IYUV},
    {"COLOR_YUV2BGR_NV12", cv::COLOR_YUV2BGR_NV12},
    {"COLOR_YUV2BGR_NV21", cv::COLOR_YUV2BGR_NV21},
    {"COLOR_YUV2BGR_UYNV", cv::COLOR_YUV2BGR_UYNV},
    {"COLOR_YUV2BGR_UYVY", cv::COLOR_YUV2BGR_UYVY},
    {"COLOR_YUV2BGR_Y422", cv::COLOR_YUV2BGR_Y422},
    {"COLOR_YUV2BGR_YUNV", cv::COLOR_YUV2BGR_YUNV},
    {"COLOR_YUV2BGR_YUY2", cv::COLOR_YUV2BGR_YUY2},
    {"COLOR_YUV2BGR_YUYV", cv::COLOR_YUV2BGR_YUYV},
    {"COLOR_YUV2BGR_YV12", cv::COLOR_YUV2BGR_YV12},
    {"COLOR_YUV2BGR_YVYU", cv::COLOR_YUV2BGR_YVYU},
    {"COLOR_YUV2GRAY_420", cv::COLOR_YUV2GRAY_420},
    {"COLOR_YUV2GRAY_I420", cv::COLOR_YUV2GRAY_I420},
    {"COLOR_YUV2GRAY_IYUV", cv::COLOR_YUV2GRAY_IYUV},
    {"COLOR_YUV2GRAY_NV12", cv::COLOR_YUV2GRAY_NV12},
    {"COLOR_YUV2GRAY_NV21", cv::COLOR_YUV2GRAY_NV21},
    {"COLOR_YUV2GRAY_UYNV", cv::COLOR_YUV2GRAY_UYNV},
    {"COLOR_YUV2GRAY_UYVY", cv::COLOR_YUV2GRAY_UYVY},
    {"COLOR_YUV2GRAY_Y422", cv::COLOR_YUV2GRAY_Y422},
    {"COLOR_YUV2GRAY_YUNV", cv::COLOR_YUV2GRAY_YUNV},
    {"COLOR_YUV2GRAY_YUY2", cv::COLOR_YUV2GRAY_YUY2},
    {"COLOR_YUV2GRAY_YUYV", cv::COLOR_YUV2GRAY_YUYV},
    {"COLOR_YUV2GRAY_YV12", cv::COLOR_YUV2GRAY_YV12},
    {"COLOR_YUV2GRAY_YVYU", cv::COLOR_YUV2GRAY_YVYU},
    {"COLOR_YUV2RGB", cv::COLOR_YUV2RGB},
    {"COLOR_YUV2RGBA_I420", cv::COLOR_YUV2RGBA_I420},
    {"COLOR_YUV2RGBA_IYUV", cv::COLOR_YUV2RGBA_IYUV},
    {"COLOR_YUV2RGBA_NV12", cv::COLOR_YUV2RGBA_NV12},
    {"COLOR_YUV2RGBA_NV21", cv::COLOR_YUV2RGBA_NV21},
    {"COLOR_YUV2RGBA_UYNV", cv::COLOR_YUV2RGBA_UYNV},
    {"COLOR_YUV2RGBA_UYVY", cv::COLOR_YUV2RGBA_UYVY},
    {"COLOR_YUV2RGBA_Y422", cv::COLOR_YUV2RGBA_Y422},
    {"COLOR_YUV2RGBA_YUNV", cv::COLOR_YUV2RGBA_YUNV},
    {"COLOR_YUV2RGBA_YUY2", cv::COLOR_YUV2RGBA_YUY2},
    {"COLOR_YUV2RGBA_YUYV", cv::COLOR_YUV2RGBA_YUYV},
    {"COLOR_YUV2RGBA_YV12", cv::COLOR_YUV2RGBA_YV12},
    {"COLOR_YUV2RGBA_YVYU", cv::COLOR_YUV2RGBA_YVYU},
    {"COLOR_YUV2RGB_I420", cv::COLOR_YUV2RGB_I420},
    {"COLOR_YUV2RGB_IYUV", cv::COLOR_YUV2RGB_IYUV},
    {"COLOR_YUV2RGB_NV12", cv::COLOR_YUV2RGB_NV12},
    {"COLOR_YUV2RGB_NV21", cv::COLOR_YUV2RGB_NV21},
    {"COLOR_YUV2RGB_UYNV", cv::COLOR_YUV2RGB_UYNV},
    {"COLOR_YUV2RGB_UYVY", cv::COLOR_YUV2RGB_UYVY},
    {"COLOR_YUV2RGB_Y422", cv::COLOR_YUV2RGB_Y422},
    {"COLOR_YUV2RGB_YUNV", cv::COLOR_YUV2RGB_YUNV},
    {"COLOR_YUV2RGB_YUY2", cv::COLOR_YUV2RGB_YUY2},
    {"COLOR_YUV2RGB_YUYV", cv::COLOR_YUV2RGB_YUYV},
    {"COLOR_YUV2RGB_YV12", cv::COLOR_YUV2RGB_YV12},
    {"COLOR_YUV2RGB_YVYU", cv::COLOR_YUV2RGB_YVYU},
    {"COLOR_YUV420p2BGR", cv::COLOR_YUV420p2BGR},
    {"COLOR_YUV420P2BGR", cv::COLOR_YUV420p2BGR},
    {"COLOR_YUV420p2BGRA", cv::COLOR_YUV420p2BGRA},
    {"COLOR_YUV420P2BGRA", cv::COLOR_YUV420p2BGRA},
    {"COLOR_YUV420p2GRAY", cv::COLOR_YUV420p2GRAY},
    {"COLOR_YUV420P2GRAY", cv::COLOR_YUV420p2GRAY},
    {"COLOR_YUV420p2RGB", cv::COLOR_YUV420p2RGB},
    {"COLOR_YUV420P2RGB", cv::COLOR_YUV420p2RGB},
    {"COLOR_YUV420p2RGBA", cv::COLOR_YUV420p2RGBA},
    {"COLOR_YUV420P2RGBA", cv::COLOR_YUV420p2RGBA},
    {"COLOR_YUV420sp2BGR", cv::COLOR_YUV420sp2BGR},
    {"COLOR_YUV420SP2BGR", cv::COLOR_YUV420sp2BGR},
    {"COLOR_YUV420sp2BGRA", cv::COLOR_YUV420sp2BGRA},
    {"COLOR_YUV420SP2BGRA", cv::COLOR_YUV420sp2BGRA},
    {"COLOR_YUV420sp2GRAY", cv::COLOR_YUV420sp2GRAY},
    {"COLOR_YUV420SP2GRAY", cv::COLOR_YUV420sp2GRAY},
    {"COLOR_YUV420sp2RGB", cv::COLOR_YUV420sp2RGB},
    {"COLOR_YUV420SP2RGB", cv::COLOR_YUV420sp2RGB},
    {"COLOR_YUV420sp2RGBA", cv::COLOR_YUV420sp2RGBA},
    {"COLOR_YUV420SP2RGBA", cv::COLOR_YUV420sp2RGBA},
    {"COLOR_mRGBA2RGBA", cv::COLOR_mRGBA2RGBA},
    {"COLOR_M_RGBA2RGBA", cv::COLOR_mRGBA2RGBA},
    {"CONTOURS_MATCH_I1", cv::CONTOURS_MATCH_I1},
    {"CONTOURS_MATCH_I2", cv::CONTOURS_MATCH_I2},
    {"CONTOURS_MATCH_I3", cv::CONTOURS_MATCH_I3},
    {"COVAR_COLS", cv::COVAR_COLS},
    {"COVAR_NORMAL", cv::COVAR_NORMAL},
    {"COVAR_ROWS", cv::COVAR_ROWS},
    {"COVAR_SCALE", cv::COVAR_SCALE},
    {"COVAR_SCRAMBLED", cv::COVAR_SCRAMBLED},
    {"COVAR_USE_AVG", cv::COVAR_USE_AVG},
    {"CirclesGridFinderParameters_ASYMMETRIC_GRID", cv::CirclesGridFinderParameters::ASYMMETRIC_GRID},
    {"CIRCLES_GRID_FINDER_PARAMETERS_ASYMMETRIC_GRID", cv::CirclesGridFinderParameters::ASYMMETRIC_GRID},
    {"CirclesGridFinderParameters_SYMMETRIC_GRID", cv::CirclesGridFinderParameters::SYMMETRIC_GRID},
    {"CIRCLES_GRID_FINDER_PARAMETERS_SYMMETRIC_GRID", cv::CirclesGridFinderParameters::SYMMETRIC_GRID},
    {"CvFeatureParams_HAAR", cv::CvFeatureParams::HAAR},
    {"CV_FEATURE_PARAMS_HAAR", cv::CvFeatureParams::HAAR},
    {"CvFeatureParams_HOG", cv::CvFeatureParams::HOG},
    {"CV_FEATURE_PARAMS_HOG", cv::CvFeatureParams::HOG},
    {"CvFeatureParams_LBP", cv::CvFeatureParams::LBP},
    {"CV_FEATURE_PARAMS_LBP", cv::CvFeatureParams::LBP},
    {"DCT_INVERSE", cv::DCT_INVERSE},
    {"DCT_ROWS", cv::DCT_ROWS},
    {"DECOMP_CHOLESKY", cv::DECOMP_CHOLESKY},
    {"DECOMP_EIG", cv::DECOMP_EIG},
    {"DECOMP_LU", cv::DECOMP_LU},
    {"DECOMP_NORMAL", cv::DECOMP_NORMAL},
    {"DECOMP_QR", cv::DECOMP_QR},
    {"DECOMP_SVD", cv::DECOMP_SVD},
    {"DFT_COMPLEX_INPUT", cv::DFT_COMPLEX_INPUT},
    {"DFT_COMPLEX_OUTPUT", cv::DFT_COMPLEX_OUTPUT},
    {"DFT_INVERSE", cv::DFT_INVERSE},
    {"DFT_REAL_OUTPUT", cv::DFT_REAL_OUTPUT},
    {"DFT_ROWS", cv::DFT_ROWS},
    {"DFT_SCALE", cv::DFT_SCALE},
    {"DIST_C", cv::DIST_C},
    {"DIST_FAIR", cv::DIST_FAIR},
    {"DIST_HUBER", cv::DIST_HUBER},
    {"DIST_L1", cv::DIST_L1},
    {"DIST_L12", cv::DIST_L12},
    {"DIST_L2", cv::DIST_L2},
    {"DIST_LABEL_CCOMP", cv::DIST_LABEL_CCOMP},
    {"DIST_LABEL_PIXEL", cv::DIST_LABEL_PIXEL},
    {"DIST_MASK_3", cv::DIST_MASK_3},
    {"DIST_MASK_5", cv::DIST_MASK_5},
    {"DIST_MASK_PRECISE", cv::DIST_MASK_PRECISE},
    {"DIST_USER", cv::DIST_USER},
    {"DIST_WELSCH", cv::DIST_WELSCH},
    {"DescriptorMatcher_BRUTEFORCE", cv::DescriptorMatcher::BRUTEFORCE},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE", cv::DescriptorMatcher::BRUTEFORCE},
    {"DescriptorMatcher_BRUTEFORCE_HAMMING", cv::DescriptorMatcher::BRUTEFORCE_HAMMING},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMING", cv::DescriptorMatcher::BRUTEFORCE_HAMMING},
    {"DescriptorMatcher_BRUTEFORCE_HAMMINGLUT", cv::DescriptorMatcher::BRUTEFORCE_HAMMINGLUT},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMINGLUT", cv::DescriptorMatcher::BRUTEFORCE_HAMMINGLUT},
    {"DescriptorMatcher_BRUTEFORCE_L1", cv::DescriptorMatcher::BRUTEFORCE_L1},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_L1", cv::DescriptorMatcher::BRUTEFORCE_L1},
    {"DescriptorMatcher_BRUTEFORCE_SL2", cv::DescriptorMatcher::BRUTEFORCE_SL2},
    {"DESCRIPTOR_MATCHER_BRUTEFORCE_SL2", cv::DescriptorMatcher::BRUTEFORCE_SL2},
    {"DescriptorMatcher_FLANNBASED", cv::DescriptorMatcher::FLANNBASED},
    {"DESCRIPTOR_MATCHER_FLANNBASED", cv::DescriptorMatcher::FLANNBASED},
    {"DrawMatchesFlags_DEFAULT", cv::DrawMatchesFlags::DEFAULT},
    {"DRAW_MATCHES_FLAGS_DEFAULT", cv::DrawMatchesFlags::DEFAULT},
    {"DrawMatchesFlags_DRAW_OVER_OUTIMG", cv::DrawMatchesFlags::DRAW_OVER_OUTIMG},
    {"DRAW_MATCHES_FLAGS_DRAW_OVER_OUTIMG", cv::DrawMatchesFlags::DRAW_OVER_OUTIMG},
    {"DrawMatchesFlags_DRAW_RICH_KEYPOINTS", cv::DrawMatchesFlags::DRAW_RICH_KEYPOINTS},
    {"DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS", cv::DrawMatchesFlags::DRAW_RICH_KEYPOINTS},
    {"DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS", cv::DrawMatchesFlags::NOT_DRAW_SINGLE_POINTS},
    {"DRAW_MATCHES_FLAGS_NOT_DRAW_SINGLE_POINTS", cv::DrawMatchesFlags::NOT_DRAW_SINGLE_POINTS},
    {"EVENT_FLAG_ALTKEY", cv::EVENT_FLAG_ALTKEY},
    {"EVENT_FLAG_CTRLKEY", cv::EVENT_FLAG_CTRLKEY},
    {"EVENT_FLAG_LBUTTON", cv::EVENT_FLAG_LBUTTON},
    {"EVENT_FLAG_MBUTTON", cv::EVENT_FLAG_MBUTTON},
    {"EVENT_FLAG_RBUTTON", cv::EVENT_FLAG_RBUTTON},
    {"EVENT_FLAG_SHIFTKEY", cv::EVENT_FLAG_SHIFTKEY},
    {"EVENT_LBUTTONDBLCLK", cv::EVENT_LBUTTONDBLCLK},
    {"EVENT_LBUTTONDOWN", cv::EVENT_LBUTTONDOWN},
    {"EVENT_LBUTTONUP", cv::EVENT_LBUTTONUP},
    {"EVENT_MBUTTONDBLCLK", cv::EVENT_MBUTTONDBLCLK},
    {"EVENT_MBUTTONDOWN", cv::EVENT_MBUTTONDOWN},
    {"EVENT_MBUTTONUP", cv::EVENT_MBUTTONUP},
    {"EVENT_MOUSEHWHEEL", cv::EVENT_MOUSEHWHEEL},
    {"EVENT_MOUSEMOVE", cv::EVENT_MOUSEMOVE},
    {"EVENT_MOUSEWHEEL", cv::EVENT_MOUSEWHEEL},
    {"EVENT_RBUTTONDBLCLK", cv::EVENT_RBUTTONDBLCLK},
    {"EVENT_RBUTTONDOWN", cv::EVENT_RBUTTONDOWN},
    {"EVENT_RBUTTONUP", cv::EVENT_RBUTTONUP},
    {"FILLED", cv::FILLED},
    {"FLOODFILL_FIXED_RANGE", cv::FLOODFILL_FIXED_RANGE},
    {"FLOODFILL_MASK_ONLY", cv::FLOODFILL_MASK_ONLY},
    {"FM_7POINT", cv::FM_7POINT},
    {"FM_8POINT", cv::FM_8POINT},
    {"FM_LMEDS", cv::FM_LMEDS},
    {"FM_RANSAC", cv::FM_RANSAC},
    {"FONT_HERSHEY_COMPLEX", cv::FONT_HERSHEY_COMPLEX},
    {"FONT_HERSHEY_COMPLEX_SMALL", cv::FONT_HERSHEY_COMPLEX_SMALL},
    {"FONT_HERSHEY_DUPLEX", cv::FONT_HERSHEY_DUPLEX},
    {"FONT_HERSHEY_PLAIN", cv::FONT_HERSHEY_PLAIN},
    {"FONT_HERSHEY_SCRIPT_COMPLEX", cv::FONT_HERSHEY_SCRIPT_COMPLEX},
    {"FONT_HERSHEY_SCRIPT_SIMPLEX", cv::FONT_HERSHEY_SCRIPT_SIMPLEX},
    {"FONT_HERSHEY_SIMPLEX", cv::FONT_HERSHEY_SIMPLEX},
    {"FONT_HERSHEY_TRIPLEX", cv::FONT_HERSHEY_TRIPLEX},
    {"FONT_ITALIC", cv::FONT_ITALIC},
    {"FastFeatureDetector_FAST_N", cv::FastFeatureDetector::FAST_N},
    {"FAST_FEATURE_DETECTOR_FAST_N", cv::FastFeatureDetector::FAST_N},
    {"FastFeatureDetector_NONMAX_SUPPRESSION", cv::FastFeatureDetector::NONMAX_SUPPRESSION},
    {"FAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION", cv::FastFeatureDetector::NONMAX_SUPPRESSION},
    {"FastFeatureDetector_THRESHOLD", cv::FastFeatureDetector::THRESHOLD},
    {"FAST_FEATURE_DETECTOR_THRESHOLD", cv::FastFeatureDetector::THRESHOLD},
    {"FastFeatureDetector_TYPE_5_8", cv::FastFeatureDetector::TYPE_5_8},
    {"FAST_FEATURE_DETECTOR_TYPE_5_8", cv::FastFeatureDetector::TYPE_5_8},
    {"FastFeatureDetector_TYPE_7_12", cv::FastFeatureDetector::TYPE_7_12},
    {"FAST_FEATURE_DETECTOR_TYPE_7_12", cv::FastFeatureDetector::TYPE_7_12},
    {"FastFeatureDetector_TYPE_9_16", cv::FastFeatureDetector::TYPE_9_16},
    {"FAST_FEATURE_DETECTOR_TYPE_9_16", cv::FastFeatureDetector::TYPE_9_16},
    {"FileNode_EMPTY", cv::FileNode::EMPTY},
    {"FILE_NODE_EMPTY", cv::FileNode::EMPTY},
    {"FileNode_FLOAT", cv::FileNode::FLOAT},
    {"FILE_NODE_FLOAT", cv::FileNode::FLOAT},
    {"FileNode_FLOW", cv::FileNode::FLOW},
    {"FILE_NODE_FLOW", cv::FileNode::FLOW},
    {"FileNode_INT", cv::FileNode::INT},
    {"FILE_NODE_INT", cv::FileNode::INT},
    {"FileNode_MAP", cv::FileNode::MAP},
    {"FILE_NODE_MAP", cv::FileNode::MAP},
    {"FileNode_NAMED", cv::FileNode::NAMED},
    {"FILE_NODE_NAMED", cv::FileNode::NAMED},
    {"FileNode_NONE", cv::FileNode::NONE},
    {"FILE_NODE_NONE", cv::FileNode::NONE},
    {"FileNode_REAL", cv::FileNode::REAL},
    {"FILE_NODE_REAL", cv::FileNode::REAL},
    {"FileNode_REF", cv::FileNode::REF},
    {"FILE_NODE_REF", cv::FileNode::REF},
    {"FileNode_SEQ", cv::FileNode::SEQ},
    {"FILE_NODE_SEQ", cv::FileNode::SEQ},
    {"FileNode_STR", cv::FileNode::STR},
    {"FILE_NODE_STR", cv::FileNode::STR},
    {"FileNode_STRING", cv::FileNode::STRING},
    {"FILE_NODE_STRING", cv::FileNode::STRING},
    {"FileNode_TYPE_MASK", cv::FileNode::TYPE_MASK},
    {"FILE_NODE_TYPE_MASK", cv::FileNode::TYPE_MASK},
    {"FileNode_USER", cv::FileNode::USER},
    {"FILE_NODE_USER", cv::FileNode::USER},
    {"FileStorage_APPEND", cv::FileStorage::APPEND},
    {"FILE_STORAGE_APPEND", cv::FileStorage::APPEND},
    {"FileStorage_BASE64", cv::FileStorage::BASE64},
    {"FILE_STORAGE_BASE64", cv::FileStorage::BASE64},
    {"FileStorage_FORMAT_AUTO", cv::FileStorage::FORMAT_AUTO},
    {"FILE_STORAGE_FORMAT_AUTO", cv::FileStorage::FORMAT_AUTO},
    {"FileStorage_FORMAT_JSON", cv::FileStorage::FORMAT_JSON},
    {"FILE_STORAGE_FORMAT_JSON", cv::FileStorage::FORMAT_JSON},
    {"FileStorage_FORMAT_MASK", cv::FileStorage::FORMAT_MASK},
    {"FILE_STORAGE_FORMAT_MASK", cv::FileStorage::FORMAT_MASK},
    {"FileStorage_FORMAT_XML", cv::FileStorage::FORMAT_XML},
    {"FILE_STORAGE_FORMAT_XML", cv::FileStorage::FORMAT_XML},
    {"FileStorage_FORMAT_YAML", cv::FileStorage::FORMAT_YAML},
    {"FILE_STORAGE_FORMAT_YAML", cv::FileStorage::FORMAT_YAML},
    {"FileStorage_INSIDE_MAP", cv::FileStorage::INSIDE_MAP},
    {"FILE_STORAGE_INSIDE_MAP", cv::FileStorage::INSIDE_MAP},
    {"FileStorage_MEMORY", cv::FileStorage::MEMORY},
    {"FILE_STORAGE_MEMORY", cv::FileStorage::MEMORY},
    {"FileStorage_NAME_EXPECTED", cv::FileStorage::NAME_EXPECTED},
    {"FILE_STORAGE_NAME_EXPECTED", cv::FileStorage::NAME_EXPECTED},
    {"FileStorage_READ", cv::FileStorage::READ},
    {"FILE_STORAGE_READ", cv::FileStorage::READ},
    {"FileStorage_UNDEFINED", cv::FileStorage::UNDEFINED},
    {"FILE_STORAGE_UNDEFINED", cv::FileStorage::UNDEFINED},
    {"FileStorage_VALUE_EXPECTED", cv::FileStorage::VALUE_EXPECTED},
    {"FILE_STORAGE_VALUE_EXPECTED", cv::FileStorage::VALUE_EXPECTED},
    {"FileStorage_WRITE", cv::FileStorage::WRITE},
    {"FILE_STORAGE_WRITE", cv::FileStorage::WRITE},
    {"FileStorage_WRITE_BASE64", cv::FileStorage::WRITE_BASE64},
    {"FILE_STORAGE_WRITE_BASE64", cv::FileStorage::WRITE_BASE64},
    {"Formatter_FMT_C", cv::Formatter::FMT_C},
    {"FORMATTER_FMT_C", cv::Formatter::FMT_C},
    {"Formatter_FMT_CSV", cv::Formatter::FMT_CSV},
    {"FORMATTER_FMT_CSV", cv::Formatter::FMT_CSV},
    {"Formatter_FMT_DEFAULT", cv::Formatter::FMT_DEFAULT},
    {"FORMATTER_FMT_DEFAULT", cv::Formatter::FMT_DEFAULT},
    {"Formatter_FMT_MATLAB", cv::Formatter::FMT_MATLAB},
    {"FORMATTER_FMT_MATLAB", cv::Formatter::FMT_MATLAB},
    {"Formatter_FMT_NUMPY", cv::Formatter::FMT_NUMPY},
    {"FORMATTER_FMT_NUMPY", cv::Formatter::FMT_NUMPY},
    {"Formatter_FMT_PYTHON", cv::Formatter::FMT_PYTHON},
    {"FORMATTER_FMT_PYTHON", cv::Formatter::FMT_PYTHON},
    {"GC_BGD", cv::GC_BGD},
    {"GC_EVAL", cv::GC_EVAL},
    {"GC_FGD", cv::GC_FGD},
    {"GC_INIT_WITH_MASK", cv::GC_INIT_WITH_MASK},
    {"GC_INIT_WITH_RECT", cv::GC_INIT_WITH_RECT},
    {"GC_PR_BGD", cv::GC_PR_BGD},
    {"GC_PR_FGD", cv::GC_PR_FGD},
    {"GEMM_1_T", cv::GEMM_1_T},
    {"GEMM_2_T", cv::GEMM_2_T},
    {"GEMM_3_T", cv::GEMM_3_T},
    {"HISTCMP_BHATTACHARYYA", cv::HISTCMP_BHATTACHARYYA},
    {"HISTCMP_CHISQR", cv::HISTCMP_CHISQR},
    {"HISTCMP_CHISQR_ALT", cv::HISTCMP_CHISQR_ALT},
    {"HISTCMP_CORREL", cv::HISTCMP_CORREL},
    {"HISTCMP_HELLINGER", cv::HISTCMP_HELLINGER},
    {"HISTCMP_INTERSECT", cv::HISTCMP_INTERSECT},
    {"HISTCMP_KL_DIV", cv::HISTCMP_KL_DIV},
    {"HOGDescriptor_DEFAULT_NLEVELS", cv::HOGDescriptor::DEFAULT_NLEVELS},
    {"HOGDESCRIPTOR_DEFAULT_NLEVELS", cv::HOGDescriptor::DEFAULT_NLEVELS},
    {"HOGDescriptor_L2Hys", cv::HOGDescriptor::L2Hys},
    {"HOGDESCRIPTOR_L2HYS", cv::HOGDescriptor::L2Hys},
    {"HOUGH_GRADIENT", cv::HOUGH_GRADIENT},
    {"HOUGH_MULTI_SCALE", cv::HOUGH_MULTI_SCALE},
    {"HOUGH_PROBABILISTIC", cv::HOUGH_PROBABILISTIC},
    {"HOUGH_STANDARD", cv::HOUGH_STANDARD},
    {"Hamming_normType", cv::Hamming::normType},
    {"HAMMING_NORM_TYPE", cv::Hamming::normType},
    {"IMREAD_ANYCOLOR", cv::IMREAD_ANYCOLOR},
    {"IMREAD_ANYDEPTH", cv::IMREAD_ANYDEPTH},
    {"IMREAD_COLOR", cv::IMREAD_COLOR},
    {"IMREAD_GRAYSCALE", cv::IMREAD_GRAYSCALE},
    {"IMREAD_IGNORE_ORIENTATION", cv::IMREAD_IGNORE_ORIENTATION},
    {"IMREAD_LOAD_GDAL", cv::IMREAD_LOAD_GDAL},
    {"IMREAD_REDUCED_COLOR_2", cv::IMREAD_REDUCED_COLOR_2},
    {"IMREAD_REDUCED_COLOR_4", cv::IMREAD_REDUCED_COLOR_4},
    {"IMREAD_REDUCED_COLOR_8", cv::IMREAD_REDUCED_COLOR_8},
    {"IMREAD_REDUCED_GRAYSCALE_2", cv::IMREAD_REDUCED_GRAYSCALE_2},
    {"IMREAD_REDUCED_GRAYSCALE_4", cv::IMREAD_REDUCED_GRAYSCALE_4},
    {"IMREAD_REDUCED_GRAYSCALE_8", cv::IMREAD_REDUCED_GRAYSCALE_8},
    {"IMREAD_UNCHANGED", cv::IMREAD_UNCHANGED},
    {"IMWRITE_EXR_TYPE", cv::IMWRITE_EXR_TYPE},
    {"IMWRITE_EXR_TYPE_FLOAT", cv::IMWRITE_EXR_TYPE_FLOAT},
    {"IMWRITE_EXR_TYPE_HALF", cv::IMWRITE_EXR_TYPE_HALF},
    {"IMWRITE_JPEG_CHROMA_QUALITY", cv::IMWRITE_JPEG_CHROMA_QUALITY},
    {"IMWRITE_JPEG_LUMA_QUALITY", cv::IMWRITE_JPEG_LUMA_QUALITY},
    {"IMWRITE_JPEG_OPTIMIZE", cv::IMWRITE_JPEG_OPTIMIZE},
    {"IMWRITE_JPEG_PROGRESSIVE", cv::IMWRITE_JPEG_PROGRESSIVE},
    {"IMWRITE_JPEG_QUALITY", cv::IMWRITE_JPEG_QUALITY},
    {"IMWRITE_JPEG_RST_INTERVAL", cv::IMWRITE_JPEG_RST_INTERVAL},
    {"IMWRITE_PAM_FORMAT_BLACKANDWHITE", cv::IMWRITE_PAM_FORMAT_BLACKANDWHITE},
    {"IMWRITE_PAM_FORMAT_GRAYSCALE", cv::IMWRITE_PAM_FORMAT_GRAYSCALE},
    {"IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA", cv::IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA},
    {"IMWRITE_PAM_FORMAT_NULL", cv::IMWRITE_PAM_FORMAT_NULL},
    {"IMWRITE_PAM_FORMAT_RGB", cv::IMWRITE_PAM_FORMAT_RGB},
    {"IMWRITE_PAM_FORMAT_RGB_ALPHA", cv::IMWRITE_PAM_FORMAT_RGB_ALPHA},
    {"IMWRITE_PAM_TUPLETYPE", cv::IMWRITE_PAM_TUPLETYPE},
    {"IMWRITE_PNG_BILEVEL", cv::IMWRITE_PNG_BILEVEL},
    {"IMWRITE_PNG_COMPRESSION", cv::IMWRITE_PNG_COMPRESSION},
    {"IMWRITE_PNG_STRATEGY", cv::IMWRITE_PNG_STRATEGY},
    {"IMWRITE_PNG_STRATEGY_DEFAULT", cv::IMWRITE_PNG_STRATEGY_DEFAULT},
    {"IMWRITE_PNG_STRATEGY_FILTERED", cv::IMWRITE_PNG_STRATEGY_FILTERED},
    {"IMWRITE_PNG_STRATEGY_FIXED", cv::IMWRITE_PNG_STRATEGY_FIXED},
    {"IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY", cv::IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY},
    {"IMWRITE_PNG_STRATEGY_RLE", cv::IMWRITE_PNG_STRATEGY_RLE},
    {"IMWRITE_PXM_BINARY", cv::IMWRITE_PXM_BINARY},
    {"IMWRITE_WEBP_QUALITY", cv::IMWRITE_WEBP_QUALITY},
    {"INPAINT_NS", cv::INPAINT_NS},
    {"INPAINT_TELEA", cv::INPAINT_TELEA},
    {"INTERSECT_FULL", cv::INTERSECT_FULL},
    {"INTERSECT_NONE", cv::INTERSECT_NONE},
    {"INTERSECT_PARTIAL", cv::INTERSECT_PARTIAL},
    {"INTER_AREA", cv::INTER_AREA},
    {"INTER_BITS", cv::INTER_BITS},
    {"INTER_BITS2", cv::INTER_BITS2},
    {"INTER_CUBIC", cv::INTER_CUBIC},
    {"INTER_LANCZOS4", cv::INTER_LANCZOS4},
    {"INTER_LINEAR", cv::INTER_LINEAR},
    {"INTER_LINEAR_EXACT", cv::INTER_LINEAR_EXACT},
    {"INTER_MAX", cv::INTER_MAX},
    {"INTER_NEAREST", cv::INTER_NEAREST},
    {"INTER_TAB_SIZE", cv::INTER_TAB_SIZE},
    {"INTER_TAB_SIZE2", cv::INTER_TAB_SIZE2},
    {"KAZE_DIFF_CHARBONNIER", cv::KAZE::DIFF_CHARBONNIER},
    {"KAZE_DIFF_PM_G1", cv::KAZE::DIFF_PM_G1},
    {"KAZE_DIFF_PM_G2", cv::KAZE::DIFF_PM_G2},
    {"KAZE_DIFF_WEICKERT", cv::KAZE::DIFF_WEICKERT},
    {"KMEANS_PP_CENTERS", cv::KMEANS_PP_CENTERS},
    {"KMEANS_RANDOM_CENTERS", cv::KMEANS_RANDOM_CENTERS},
    {"KMEANS_USE_INITIAL_LABELS", cv::KMEANS_USE_INITIAL_LABELS},
    {"LDR_SIZE", cv::LDR_SIZE},
    {"LINE_4", cv::LINE_4},
    {"LINE_8", cv::LINE_8},
    {"LINE_AA", cv::LINE_AA},
    {"LMEDS", cv::LMEDS},
    {"LSD_REFINE_ADV", cv::LSD_REFINE_ADV},
    {"LSD_REFINE_NONE", cv::LSD_REFINE_NONE},
    {"LSD_REFINE_STD", cv::LSD_REFINE_STD},
    {"MARKER_CROSS", cv::MARKER_CROSS},
    {"MARKER_DIAMOND", cv::MARKER_DIAMOND},
    {"MARKER_SQUARE", cv::MARKER_SQUARE},
    {"MARKER_STAR", cv::MARKER_STAR},
    {"MARKER_TILTED_CROSS", cv::MARKER_TILTED_CROSS},
    {"MARKER_TRIANGLE_DOWN", cv::MARKER_TRIANGLE_DOWN},
    {"MARKER_TRIANGLE_UP", cv::MARKER_TRIANGLE_UP},
    {"MIXED_CLONE", cv::MIXED_CLONE},
    {"MJPEG", cv::MJPEG},
    {"MONOCHROME_TRANSFER", cv::MONOCHROME_TRANSFER},
    {"MORPH_BLACKHAT", cv::MORPH_BLACKHAT},
    {"MORPH_CLOSE", cv::MORPH_CLOSE},
    {"MORPH_CROSS", cv::MORPH_CROSS},
    {"MORPH_DILATE", cv::MORPH_DILATE},
    {"MORPH_ELLIPSE", cv::MORPH_ELLIPSE},
    {"MORPH_ERODE", cv::MORPH_ERODE},
    {"MORPH_GRADIENT", cv::MORPH_GRADIENT},
    {"MORPH_HITMISS", cv::MORPH_HITMISS},
    {"MORPH_OPEN", cv::MORPH_OPEN},
    {"MORPH_RECT", cv::MORPH_RECT},
    {"MORPH_TOPHAT", cv::MORPH_TOPHAT},
    {"MOTION_AFFINE", cv::MOTION_AFFINE},
    {"MOTION_EUCLIDEAN", cv::MOTION_EUCLIDEAN},
    {"MOTION_HOMOGRAPHY", cv::MOTION_HOMOGRAPHY},
    {"MOTION_TRANSLATION", cv::MOTION_TRANSLATION},
    {"Mat_AUTO_STEP", cv::Mat::AUTO_STEP},
    {"MAT_AUTO_STEP", cv::Mat::AUTO_STEP},
    {"Mat_CONTINUOUS_FLAG", cv::Mat::CONTINUOUS_FLAG},
    {"MAT_CONTINUOUS_FLAG", cv::Mat::CONTINUOUS_FLAG},
    {"Mat_DEPTH_MASK", cv::Mat::DEPTH_MASK},
    {"MAT_DEPTH_MASK", cv::Mat::DEPTH_MASK},
    {"Mat_MAGIC_MASK", cv::Mat::MAGIC_MASK},
    {"MAT_MAGIC_MASK", cv::Mat::MAGIC_MASK},
    {"Mat_MAGIC_VAL", cv::Mat::MAGIC_VAL},
    {"MAT_MAGIC_VAL", cv::Mat::MAGIC_VAL},
    {"Mat_SUBMATRIX_FLAG", cv::Mat::SUBMATRIX_FLAG},
    {"MAT_SUBMATRIX_FLAG", cv::Mat::SUBMATRIX_FLAG},
    {"Mat_TYPE_MASK", cv::Mat::TYPE_MASK},
    {"MAT_TYPE_MASK", cv::Mat::TYPE_MASK},
    {"NORMAL_CLONE", cv::NORMAL_CLONE},
    {"NORMCONV_FILTER", cv::NORMCONV_FILTER},
    {"NORM_HAMMING", cv::NORM_HAMMING},
    {"NORM_HAMMING2", cv::NORM_HAMMING2},
    {"NORM_INF", cv::NORM_INF},
    {"NORM_L1", cv::NORM_L1},
    {"NORM_L2", cv::NORM_L2},
    {"NORM_L2SQR", cv::NORM_L2SQR},
    {"NORM_MINMAX", cv::NORM_MINMAX},
    {"NORM_RELATIVE", cv::NORM_RELATIVE},
    {"NORM_TYPE_MASK", cv::NORM_TYPE_MASK},
    {"OPTFLOW_FARNEBACK_GAUSSIAN", cv::OPTFLOW_FARNEBACK_GAUSSIAN},
    {"OPTFLOW_LK_GET_MIN_EIGENVALS", cv::OPTFLOW_LK_GET_MIN_EIGENVALS},
    {"OPTFLOW_USE_INITIAL_FLOW", cv::OPTFLOW_USE_INITIAL_FLOW},
    {"ORB_FAST_SCORE", cv::ORB::FAST_SCORE},
    {"ORB_HARRIS_SCORE", cv::ORB::HARRIS_SCORE},
    {"ORB_kBytes", cv::ORB::kBytes},
    {"ORB_K_BYTES", cv::ORB::kBytes},
    {"PCA_DATA_AS_COL", cv::PCA::DATA_AS_COL},
    {"PCA_DATA_AS_ROW", cv::PCA::DATA_AS_ROW},
    {"PCA_USE_AVG", cv::PCA::USE_AVG},
    {"PROJ_SPHERICAL_EQRECT", cv::PROJ_SPHERICAL_EQRECT},
    {"PROJ_SPHERICAL_ORTHO", cv::PROJ_SPHERICAL_ORTHO},
    {"Param_ALGORITHM", cv::Param::ALGORITHM},
    {"PARAM_ALGORITHM", cv::Param::ALGORITHM},
    {"Param_BOOLEAN", cv::Param::BOOLEAN},
    {"PARAM_BOOLEAN", cv::Param::BOOLEAN},
    {"Param_FLOAT", cv::Param::FLOAT},
    {"PARAM_FLOAT", cv::Param::FLOAT},
    {"Param_INT", cv::Param::INT},
    {"PARAM_INT", cv::Param::INT},
    {"Param_MAT", cv::Param::MAT},
    {"PARAM_MAT", cv::Param::MAT},
    {"Param_MAT_VECTOR", cv::Param::MAT_VECTOR},
    {"PARAM_MAT_VECTOR", cv::Param::MAT_VECTOR},
    {"Param_REAL", cv::Param::REAL},
    {"PARAM_REAL", cv::Param::REAL},
    {"Param_STRING", cv::Param::STRING},
    {"PARAM_STRING", cv::Param::STRING},
    {"Param_UCHAR", cv::Param::UCHAR},
    {"PARAM_UCHAR", cv::Param::UCHAR},
    {"Param_UINT64", cv::Param::UINT64},
    {"PARAM_UINT64", cv::Param::UINT64},
    {"Param_UNSIGNED_INT", cv::Param::UNSIGNED_INT},
    {"PARAM_UNSIGNED_INT", cv::Param::UNSIGNED_INT},
    {"QT_CHECKBOX", cv::QT_CHECKBOX},
    {"QT_FONT_BLACK", cv::QT_FONT_BLACK},
    {"QT_FONT_BOLD", cv::QT_FONT_BOLD},
    {"QT_FONT_DEMIBOLD", cv::QT_FONT_DEMIBOLD},
    {"QT_FONT_LIGHT", cv::QT_FONT_LIGHT},
    {"QT_FONT_NORMAL", cv::QT_FONT_NORMAL},
    {"QT_NEW_BUTTONBAR", cv::QT_NEW_BUTTONBAR},
    {"QT_PUSH_BUTTON", cv::QT_PUSH_BUTTON},
    {"QT_RADIOBOX", cv::QT_RADIOBOX},
    {"QT_STYLE_ITALIC", cv::QT_STYLE_ITALIC},
    {"QT_STYLE_NORMAL", cv::QT_STYLE_NORMAL},
    {"QT_STYLE_OBLIQUE", cv::QT_STYLE_OBLIQUE},
    {"RANSAC", cv::RANSAC},
    {"RECURS_FILTER", cv::RECURS_FILTER},
    {"REDUCE_AVG", cv::REDUCE_AVG},
    {"REDUCE_MAX", cv::REDUCE_MAX},
    {"REDUCE_MIN", cv::REDUCE_MIN},
    {"REDUCE_SUM", cv::REDUCE_SUM},
    {"RETR_CCOMP", cv::RETR_CCOMP},
    {"RETR_EXTERNAL", cv::RETR_EXTERNAL},
    {"RETR_FLOODFILL", cv::RETR_FLOODFILL},
    {"RETR_LIST", cv::RETR_LIST},
    {"RETR_TREE", cv::RETR_TREE},
    {"RHO", cv::RHO},
    {"RNG_NORMAL", cv::RNG::NORMAL},
    {"RNG_UNIFORM", cv::RNG::UNIFORM},
    {"ROTATE_180", cv::ROTATE_180},
    {"ROTATE_90_CLOCKWISE", cv::ROTATE_90_CLOCKWISE},
    {"ROTATE_90_COUNTERCLOCKWISE", cv::ROTATE_90_COUNTERCLOCKWISE},
    {"SOLVELP_MULTI", cv::SOLVELP_MULTI},
    {"SOLVELP_SINGLE", cv::SOLVELP_SINGLE},
    {"SOLVELP_UNBOUNDED", cv::SOLVELP_UNBOUNDED},
    {"SOLVELP_UNFEASIBLE", cv::SOLVELP_UNFEASIBLE},
    {"SOLVEPNP_AP3P", cv::SOLVEPNP_AP3P},
    {"SOLVEPNP_DLS", cv::SOLVEPNP_DLS},
    {"SOLVEPNP_EPNP", cv::SOLVEPNP_EPNP},
    {"SOLVEPNP_ITERATIVE", cv::SOLVEPNP_ITERATIVE},
    {"SOLVEPNP_MAX_COUNT", cv::SOLVEPNP_MAX_COUNT},
    {"SOLVEPNP_P3P", cv::SOLVEPNP_P3P},
    {"SOLVEPNP_UPNP", cv::SOLVEPNP_UPNP},
    {"SORT_ASCENDING", cv::SORT_ASCENDING},
    {"SORT_DESCENDING", cv::SORT_DESCENDING},
    {"SORT_EVERY_COLUMN", cv::SORT_EVERY_COLUMN},
    {"SORT_EVERY_ROW", cv::SORT_EVERY_ROW},
    {"SVD_FULL_UV", cv::SVD::FULL_UV},
    {"SVD_MODIFY_A", cv::SVD::MODIFY_A},
    {"SVD_NO_UV", cv::SVD::NO_UV},
    {"SparseMat_HASH_BIT", cv::SparseMat::HASH_BIT},
    {"SPARSE_MAT_HASH_BIT", cv::SparseMat::HASH_BIT},
    {"SparseMat_HASH_SCALE", cv::SparseMat::HASH_SCALE},
    {"SPARSE_MAT_HASH_SCALE", cv::SparseMat::HASH_SCALE},
    {"SparseMat_MAGIC_VAL", cv::SparseMat::MAGIC_VAL},
    {"SPARSE_MAT_MAGIC_VAL", cv::SparseMat::MAGIC_VAL},
    {"SparseMat_MAX_DIM", cv::SparseMat::MAX_DIM},
    {"SPARSE_MAT_MAX_DIM", cv::SparseMat::MAX_DIM},
    {"StereoBM_PREFILTER_NORMALIZED_RESPONSE", cv::StereoBM::PREFILTER_NORMALIZED_RESPONSE},
    {"STEREO_BM_PREFILTER_NORMALIZED_RESPONSE", cv::StereoBM::PREFILTER_NORMALIZED_RESPONSE},
    {"StereoBM_PREFILTER_XSOBEL", cv::StereoBM::PREFILTER_XSOBEL},
    {"STEREO_BM_PREFILTER_XSOBEL", cv::StereoBM::PREFILTER_XSOBEL},
    {"StereoMatcher_DISP_SCALE", cv::StereoMatcher::DISP_SCALE},
    {"STEREO_MATCHER_DISP_SCALE", cv::StereoMatcher::DISP_SCALE},
    {"StereoMatcher_DISP_SHIFT", cv::StereoMatcher::DISP_SHIFT},
    {"STEREO_MATCHER_DISP_SHIFT", cv::StereoMatcher::DISP_SHIFT},
    {"StereoSGBM_MODE_HH", cv::StereoSGBM::MODE_HH},
    {"STEREO_SGBM_MODE_HH", cv::StereoSGBM::MODE_HH},
    {"StereoSGBM_MODE_HH4", cv::StereoSGBM::MODE_HH4},
    {"STEREO_SGBM_MODE_HH4", cv::StereoSGBM::MODE_HH4},
    {"StereoSGBM_MODE_SGBM", cv::StereoSGBM::MODE_SGBM},
    {"STEREO_SGBM_MODE_SGBM", cv::StereoSGBM::MODE_SGBM},
    {"StereoSGBM_MODE_SGBM_3WAY", cv::StereoSGBM::MODE_SGBM_3WAY},
    {"STEREO_SGBM_MODE_SGBM_3WAY", cv::StereoSGBM::MODE_SGBM_3WAY},
    {"Stitcher_ERR_CAMERA_PARAMS_ADJUST_FAIL", cv::Stitcher::ERR_CAMERA_PARAMS_ADJUST_FAIL},
    {"STITCHER_ERR_CAMERA_PARAMS_ADJUST_FAIL", cv::Stitcher::ERR_CAMERA_PARAMS_ADJUST_FAIL},
    {"Stitcher_ERR_HOMOGRAPHY_EST_FAIL", cv::Stitcher::ERR_HOMOGRAPHY_EST_FAIL},
    {"STITCHER_ERR_HOMOGRAPHY_EST_FAIL", cv::Stitcher::ERR_HOMOGRAPHY_EST_FAIL},
    {"Stitcher_ERR_NEED_MORE_IMGS", cv::Stitcher::ERR_NEED_MORE_IMGS},
    {"STITCHER_ERR_NEED_MORE_IMGS", cv::Stitcher::ERR_NEED_MORE_IMGS},
    {"Stitcher_OK", cv::Stitcher::OK},
    {"STITCHER_OK", cv::Stitcher::OK},
    {"Stitcher_ORIG_RESOL", cv::Stitcher::ORIG_RESOL},
    {"STITCHER_ORIG_RESOL", cv::Stitcher::ORIG_RESOL},
    {"Stitcher_PANORAMA", cv::Stitcher::PANORAMA},
    {"STITCHER_PANORAMA", cv::Stitcher::PANORAMA},
    {"Stitcher_SCANS", cv::Stitcher::SCANS},
    {"STITCHER_SCANS", cv::Stitcher::SCANS},
    {"Subdiv2D_NEXT_AROUND_DST", cv::Subdiv2D::NEXT_AROUND_DST},
    {"SUBDIV2D_NEXT_AROUND_DST", cv::Subdiv2D::NEXT_AROUND_DST},
    {"Subdiv2D_NEXT_AROUND_LEFT", cv::Subdiv2D::NEXT_AROUND_LEFT},
    {"SUBDIV2D_NEXT_AROUND_LEFT", cv::Subdiv2D::NEXT_AROUND_LEFT},
    {"Subdiv2D_NEXT_AROUND_ORG", cv::Subdiv2D::NEXT_AROUND_ORG},
    {"SUBDIV2D_NEXT_AROUND_ORG", cv::Subdiv2D::NEXT_AROUND_ORG},
    {"Subdiv2D_NEXT_AROUND_RIGHT", cv::Subdiv2D::NEXT_AROUND_RIGHT},
    {"SUBDIV2D_NEXT_AROUND_RIGHT", cv::Subdiv2D::NEXT_AROUND_RIGHT},
    {"Subdiv2D_PREV_AROUND_DST", cv::Subdiv2D::PREV_AROUND_DST},
    {"SUBDIV2D_PREV_AROUND_DST", cv::Subdiv2D::PREV_AROUND_DST},
    {"Subdiv2D_PREV_AROUND_LEFT", cv::Subdiv2D::PREV_AROUND_LEFT},
    {"SUBDIV2D_PREV_AROUND_LEFT", cv::Subdiv2D::PREV_AROUND_LEFT},
    {"Subdiv2D_PREV_AROUND_ORG", cv::Subdiv2D::PREV_AROUND_ORG},
    {"SUBDIV2D_PREV_AROUND_ORG", cv::Subdiv2D::PREV_AROUND_ORG},
    {"Subdiv2D_PREV_AROUND_RIGHT", cv::Subdiv2D::PREV_AROUND_RIGHT},
    {"SUBDIV2D_PREV_AROUND_RIGHT", cv::Subdiv2D::PREV_AROUND_RIGHT},
    {"Subdiv2D_PTLOC_ERROR", cv::Subdiv2D::PTLOC_ERROR},
    {"SUBDIV2D_PTLOC_ERROR", cv::Subdiv2D::PTLOC_ERROR},
    {"Subdiv2D_PTLOC_INSIDE", cv::Subdiv2D::PTLOC_INSIDE},
    {"SUBDIV2D_PTLOC_INSIDE", cv::Subdiv2D::PTLOC_INSIDE},
    {"Subdiv2D_PTLOC_ON_EDGE", cv::Subdiv2D::PTLOC_ON_EDGE},
    {"SUBDIV2D_PTLOC_ON_EDGE", cv::Subdiv2D::PTLOC_ON_EDGE},
    {"Subdiv2D_PTLOC_OUTSIDE_RECT", cv::Subdiv2D::PTLOC_OUTSIDE_RECT},
    {"SUBDIV2D_PTLOC_OUTSIDE_RECT", cv::Subdiv2D::PTLOC_OUTSIDE_RECT},
    {"Subdiv2D_PTLOC_VERTEX", cv::Subdiv2D::PTLOC_VERTEX},
    {"SUBDIV2D_PTLOC_VERTEX", cv::Subdiv2D::PTLOC_VERTEX},
    {"THRESH_BINARY", cv::THRESH_BINARY},
    {"THRESH_BINARY_INV", cv::THRESH_BINARY_INV},
    {"THRESH_MASK", cv::THRESH_MASK},
    {"THRESH_OTSU", cv::THRESH_OTSU},
    {"THRESH_TOZERO", cv::THRESH_TOZERO},
    {"THRESH_TOZERO_INV", cv::THRESH_TOZERO_INV},
    {"THRESH_TRIANGLE", cv::THRESH_TRIANGLE},
    {"THRESH_TRUNC", cv::THRESH_TRUNC},
    {"TM_CCOEFF", cv::TM_CCOEFF},
    {"TM_CCOEFF_NORMED", cv::TM_CCOEFF_NORMED},
    {"TM_CCORR", cv::TM_CCORR},
    {"TM_CCORR_NORMED", cv::TM_CCORR_NORMED},
    {"TM_SQDIFF", cv::TM_SQDIFF},
    {"TM_SQDIFF_NORMED", cv::TM_SQDIFF_NORMED},
    {"TermCriteria_COUNT", cv::TermCriteria::COUNT},
    {"TERM_CRITERIA_COUNT", cv::TermCriteria::COUNT},
    {"TermCriteria_EPS", cv::TermCriteria::EPS},
    {"TERM_CRITERIA_EPS", cv::TermCriteria::EPS},
    {"TermCriteria_MAX_ITER", cv::TermCriteria::MAX_ITER},
    {"TERM_CRITERIA_MAX_ITER", cv::TermCriteria::MAX_ITER},
    {"TrackerKCF_CN", cv::TrackerKCF::CN},
    {"TRACKER_KCF_CN", cv::TrackerKCF::CN},
    {"TrackerKCF_CUSTOM", cv::TrackerKCF::CUSTOM},
    {"TRACKER_KCF_CUSTOM", cv::TrackerKCF::CUSTOM},
    {"TrackerKCF_GRAY", cv::TrackerKCF::GRAY},
    {"TRACKER_KCF_GRAY", cv::TrackerKCF::GRAY},
    {"TrackerSamplerCSC_MODE_DETECT", cv::TrackerSamplerCSC::MODE_DETECT},
    {"TRACKER_SAMPLER_CSC_MODE_DETECT", cv::TrackerSamplerCSC::MODE_DETECT},
    {"TrackerSamplerCSC_MODE_INIT_NEG", cv::TrackerSamplerCSC::MODE_INIT_NEG},
    {"TRACKER_SAMPLER_CSC_MODE_INIT_NEG", cv::TrackerSamplerCSC::MODE_INIT_NEG},
    {"TrackerSamplerCSC_MODE_INIT_POS", cv::TrackerSamplerCSC::MODE_INIT_POS},
    {"TRACKER_SAMPLER_CSC_MODE_INIT_POS", cv::TrackerSamplerCSC::MODE_INIT_POS},
    {"TrackerSamplerCSC_MODE_TRACK_NEG", cv::TrackerSamplerCSC::MODE_TRACK_NEG},
    {"TRACKER_SAMPLER_CSC_MODE_TRACK_NEG", cv::TrackerSamplerCSC::MODE_TRACK_NEG},
    {"TrackerSamplerCSC_MODE_TRACK_POS", cv::TrackerSamplerCSC::MODE_TRACK_POS},
    {"TRACKER_SAMPLER_CSC_MODE_TRACK_POS", cv::TrackerSamplerCSC::MODE_TRACK_POS},
    {"TrackerSamplerCS_MODE_CLASSIFY", cv::TrackerSamplerCS::MODE_CLASSIFY},
    {"TRACKER_SAMPLER_CS_MODE_CLASSIFY", cv::TrackerSamplerCS::MODE_CLASSIFY},
    {"TrackerSamplerCS_MODE_NEGATIVE", cv::TrackerSamplerCS::MODE_NEGATIVE},
    {"TRACKER_SAMPLER_CS_MODE_NEGATIVE", cv::TrackerSamplerCS::MODE_NEGATIVE},
    {"TrackerSamplerCS_MODE_POSITIVE", cv::TrackerSamplerCS::MODE_POSITIVE},
    {"TRACKER_SAMPLER_CS_MODE_POSITIVE", cv::TrackerSamplerCS::MODE_POSITIVE},
    {"UMatData_ASYNC_CLEANUP", cv::UMatData::ASYNC_CLEANUP},
    {"UMAT_DATA_ASYNC_CLEANUP", cv::UMatData::ASYNC_CLEANUP},
    {"UMatData_COPY_ON_MAP", cv::UMatData::COPY_ON_MAP},
    {"UMAT_DATA_COPY_ON_MAP", cv::UMatData::COPY_ON_MAP},
    {"UMatData_DEVICE_COPY_OBSOLETE", cv::UMatData::DEVICE_COPY_OBSOLETE},
    {"UMAT_DATA_DEVICE_COPY_OBSOLETE", cv::UMatData::DEVICE_COPY_OBSOLETE},
    {"UMatData_DEVICE_MEM_MAPPED", cv::UMatData::DEVICE_MEM_MAPPED},
    {"UMAT_DATA_DEVICE_MEM_MAPPED", cv::UMatData::DEVICE_MEM_MAPPED},
    {"UMatData_HOST_COPY_OBSOLETE", cv::UMatData::HOST_COPY_OBSOLETE},
    {"UMAT_DATA_HOST_COPY_OBSOLETE", cv::UMatData::HOST_COPY_OBSOLETE},
    {"UMatData_TEMP_COPIED_UMAT", cv::UMatData::TEMP_COPIED_UMAT},
    {"UMAT_DATA_TEMP_COPIED_UMAT", cv::UMatData::TEMP_COPIED_UMAT},
    {"UMatData_TEMP_UMAT", cv::UMatData::TEMP_UMAT},
    {"UMAT_DATA_TEMP_UMAT", cv::UMatData::TEMP_UMAT},
    {"UMatData_USER_ALLOCATED", cv::UMatData::USER_ALLOCATED},
    {"UMAT_DATA_USER_ALLOCATED", cv::UMatData::USER_ALLOCATED},
    {"UMat_AUTO_STEP", cv::UMat::AUTO_STEP},
    {"UMAT_AUTO_STEP", cv::UMat::AUTO_STEP},
    {"UMat_CONTINUOUS_FLAG", cv::UMat::CONTINUOUS_FLAG},
    {"UMAT_CONTINUOUS_FLAG", cv::UMat::CONTINUOUS_FLAG},
    {"UMat_DEPTH_MASK", cv::UMat::DEPTH_MASK},
    {"UMAT_DEPTH_MASK", cv::UMat::DEPTH_MASK},
    {"UMat_MAGIC_MASK", cv::UMat::MAGIC_MASK},
    {"UMAT_MAGIC_MASK", cv::UMat::MAGIC_MASK},
    {"UMat_MAGIC_VAL", cv::UMat::MAGIC_VAL},
    {"UMAT_MAGIC_VAL", cv::UMat::MAGIC_VAL},
    {"UMat_SUBMATRIX_FLAG", cv::UMat::SUBMATRIX_FLAG},
    {"UMAT_SUBMATRIX_FLAG", cv::UMat::SUBMATRIX_FLAG},
    {"UMat_TYPE_MASK", cv::UMat::TYPE_MASK},
    {"UMAT_TYPE_MASK", cv::UMat::TYPE_MASK},
    {"USAGE_ALLOCATE_DEVICE_MEMORY", cv::USAGE_ALLOCATE_DEVICE_MEMORY},
    {"USAGE_ALLOCATE_HOST_MEMORY", cv::USAGE_ALLOCATE_HOST_MEMORY},
    {"USAGE_ALLOCATE_SHARED_MEMORY", cv::USAGE_ALLOCATE_SHARED_MEMORY},
    {"USAGE_DEFAULT", cv::USAGE_DEFAULT},
    {"VIDEOWRITER_PROP_FRAMEBYTES", cv::VIDEOWRITER_PROP_FRAMEBYTES},
    {"VIDEOWRITER_PROP_NSTRIPES", cv::VIDEOWRITER_PROP_NSTRIPES},
    {"VIDEOWRITER_PROP_QUALITY", cv::VIDEOWRITER_PROP_QUALITY},
    {"WARP_FILL_OUTLIERS", cv::WARP_FILL_OUTLIERS},
    {"WARP_INVERSE_MAP", cv::WARP_INVERSE_MAP},
    {"WINDOW_AUTOSIZE", cv::WINDOW_AUTOSIZE},
    {"WINDOW_FREERATIO", cv::WINDOW_FREERATIO},
    {"WINDOW_FULLSCREEN", cv::WINDOW_FULLSCREEN},
    {"WINDOW_GUI_EXPANDED", cv::WINDOW_GUI_EXPANDED},
    {"WINDOW_GUI_NORMAL", cv::WINDOW_GUI_NORMAL},
    {"WINDOW_KEEPRATIO", cv::WINDOW_KEEPRATIO},
    {"WINDOW_NORMAL", cv::WINDOW_NORMAL},
    {"WINDOW_OPENGL", cv::WINDOW_OPENGL},
    {"WND_PROP_ASPECT_RATIO", cv::WND_PROP_ASPECT_RATIO},
    {"WND_PROP_AUTOSIZE", cv::WND_PROP_AUTOSIZE},
    {"WND_PROP_FULLSCREEN", cv::WND_PROP_FULLSCREEN},
    {"WND_PROP_OPENGL", cv::WND_PROP_OPENGL},
    {"WND_PROP_VISIBLE", cv::WND_PROP_VISIBLE},
    {"_InputArray_CUDA_GPU_MAT", cv::_InputArray::CUDA_GPU_MAT},
    {"_INPUT_ARRAY_CUDA_GPU_MAT", cv::_InputArray::CUDA_GPU_MAT},
    {"_InputArray_CUDA_HOST_MEM", cv::_InputArray::CUDA_HOST_MEM},
    {"_INPUT_ARRAY_CUDA_HOST_MEM", cv::_InputArray::CUDA_HOST_MEM},
    {"_InputArray_EXPR", cv::_InputArray::EXPR},
    {"_INPUT_ARRAY_EXPR", cv::_InputArray::EXPR},
    {"_InputArray_FIXED_SIZE", cv::_InputArray::FIXED_SIZE},
    {"_INPUT_ARRAY_FIXED_SIZE", cv::_InputArray::FIXED_SIZE},
    {"_InputArray_FIXED_TYPE", cv::_InputArray::FIXED_TYPE},
    {"_INPUT_ARRAY_FIXED_TYPE", cv::_InputArray::FIXED_TYPE},
    {"_InputArray_KIND_MASK", cv::_InputArray::KIND_MASK},
    {"_INPUT_ARRAY_KIND_MASK", cv::_InputArray::KIND_MASK},
    {"_InputArray_KIND_SHIFT", cv::_InputArray::KIND_SHIFT},
    {"_INPUT_ARRAY_KIND_SHIFT", cv::_InputArray::KIND_SHIFT},
    {"_InputArray_MAT", cv::_InputArray::MAT},
    {"_INPUT_ARRAY_MAT", cv::_InputArray::MAT},
    {"_InputArray_MATX", cv::_InputArray::MATX},
    {"_INPUT_ARRAY_MATX", cv::_InputArray::MATX},
    {"_InputArray_NONE", cv::_InputArray::NONE},
    {"_INPUT_ARRAY_NONE", cv::_InputArray::NONE},
    {"_InputArray_OPENGL_BUFFER", cv::_InputArray::OPENGL_BUFFER},
    {"_INPUT_ARRAY_OPENGL_BUFFER", cv::_InputArray::OPENGL_BUFFER},
    {"_InputArray_STD_ARRAY", cv::_InputArray::STD_ARRAY},
    {"_INPUT_ARRAY_STD_ARRAY", cv::_InputArray::STD_ARRAY},
    {"_InputArray_STD_ARRAY_MAT", cv::_InputArray::STD_ARRAY_MAT},
    {"_INPUT_ARRAY_STD_ARRAY_MAT", cv::_InputArray::STD_ARRAY_MAT},
    {"_InputArray_STD_BOOL_VECTOR", cv::_InputArray::STD_BOOL_VECTOR},
    {"_INPUT_ARRAY_STD_BOOL_VECTOR", cv::_InputArray::STD_BOOL_VECTOR},
    {"_InputArray_STD_VECTOR", cv::_InputArray::STD_VECTOR},
    {"_INPUT_ARRAY_STD_VECTOR", cv::_InputArray::STD_VECTOR},
    {"_InputArray_STD_VECTOR_CUDA_GPU_MAT", cv::_InputArray::STD_VECTOR_CUDA_GPU_MAT},
    {"_INPUT_ARRAY_STD_VECTOR_CUDA_GPU_MAT", cv::_InputArray::STD_VECTOR_CUDA_GPU_MAT},
    {"_InputArray_STD_VECTOR_MAT", cv::_InputArray::STD_VECTOR_MAT},
    {"_INPUT_ARRAY_STD_VECTOR_MAT", cv::_InputArray::STD_VECTOR_MAT},
    {"_InputArray_STD_VECTOR_UMAT", cv::_InputArray::STD_VECTOR_UMAT},
    {"_INPUT_ARRAY_STD_VECTOR_UMAT", cv::_InputArray::STD_VECTOR_UMAT},
    {"_InputArray_STD_VECTOR_VECTOR", cv::_InputArray::STD_VECTOR_VECTOR},
    {"_INPUT_ARRAY_STD_VECTOR_VECTOR", cv::_InputArray::STD_VECTOR_VECTOR},
    {"_InputArray_UMAT", cv::_InputArray::UMAT},
    {"_INPUT_ARRAY_UMAT", cv::_InputArray::UMAT},
    {"_OutputArray_DEPTH_MASK_16S", cv::_OutputArray::DEPTH_MASK_16S},
    {"_OUTPUT_ARRAY_DEPTH_MASK_16S", cv::_OutputArray::DEPTH_MASK_16S},
    {"_OutputArray_DEPTH_MASK_16U", cv::_OutputArray::DEPTH_MASK_16U},
    {"_OUTPUT_ARRAY_DEPTH_MASK_16U", cv::_OutputArray::DEPTH_MASK_16U},
    {"_OutputArray_DEPTH_MASK_32F", cv::_OutputArray::DEPTH_MASK_32F},
    {"_OUTPUT_ARRAY_DEPTH_MASK_32F", cv::_OutputArray::DEPTH_MASK_32F},
    {"_OutputArray_DEPTH_MASK_32S", cv::_OutputArray::DEPTH_MASK_32S},
    {"_OUTPUT_ARRAY_DEPTH_MASK_32S", cv::_OutputArray::DEPTH_MASK_32S},
    {"_OutputArray_DEPTH_MASK_64F", cv::_OutputArray::DEPTH_MASK_64F},
    {"_OUTPUT_ARRAY_DEPTH_MASK_64F", cv::_OutputArray::DEPTH_MASK_64F},
    {"_OutputArray_DEPTH_MASK_8S", cv::_OutputArray::DEPTH_MASK_8S},
    {"_OUTPUT_ARRAY_DEPTH_MASK_8S", cv::_OutputArray::DEPTH_MASK_8S},
    {"_OutputArray_DEPTH_MASK_8U", cv::_OutputArray::DEPTH_MASK_8U},
    {"_OUTPUT_ARRAY_DEPTH_MASK_8U", cv::_OutputArray::DEPTH_MASK_8U},
    {"_OutputArray_DEPTH_MASK_ALL", cv::_OutputArray::DEPTH_MASK_ALL},
    {"_OUTPUT_ARRAY_DEPTH_MASK_ALL", cv::_OutputArray::DEPTH_MASK_ALL},
    {"_OutputArray_DEPTH_MASK_ALL_BUT_8S", cv::_OutputArray::DEPTH_MASK_ALL_BUT_8S},
    {"_OUTPUT_ARRAY_DEPTH_MASK_ALL_BUT_8S", cv::_OutputArray::DEPTH_MASK_ALL_BUT_8S},
    {"_OutputArray_DEPTH_MASK_FLT", cv::_OutputArray::DEPTH_MASK_FLT},
    {"_OUTPUT_ARRAY_DEPTH_MASK_FLT", cv::_OutputArray::DEPTH_MASK_FLT},
    {"__UMAT_USAGE_FLAGS_32BIT", cv::__UMAT_USAGE_FLAGS_32BIT},
    {"db", cv::db},
    {"DB", cv::db},
    {"dc", cv::dc},
    {"DC", cv::dc},
    {"pc", cv::pc},
    {"PC", cv::pc},
    {"wb", cv::wb},
    {"WB", cv::wb},
    {NULL, 0}
};

static PyMethodDef methods_Error[] = {
    {NULL, NULL}
};

static ConstDef consts_Error[] = {
    {"BadAlign", cv::Error::BadAlign},
    {"BAD_ALIGN", cv::Error::BadAlign},
    {"BadAlphaChannel", cv::Error::BadAlphaChannel},
    {"BAD_ALPHA_CHANNEL", cv::Error::BadAlphaChannel},
    {"BadCOI", cv::Error::BadCOI},
    {"BAD_COI", cv::Error::BadCOI},
    {"BadCallBack", cv::Error::BadCallBack},
    {"BAD_CALL_BACK", cv::Error::BadCallBack},
    {"BadDataPtr", cv::Error::BadDataPtr},
    {"BAD_DATA_PTR", cv::Error::BadDataPtr},
    {"BadDepth", cv::Error::BadDepth},
    {"BAD_DEPTH", cv::Error::BadDepth},
    {"BadImageSize", cv::Error::BadImageSize},
    {"BAD_IMAGE_SIZE", cv::Error::BadImageSize},
    {"BadModelOrChSeq", cv::Error::BadModelOrChSeq},
    {"BAD_MODEL_OR_CH_SEQ", cv::Error::BadModelOrChSeq},
    {"BadNumChannel1U", cv::Error::BadNumChannel1U},
    {"BAD_NUM_CHANNEL1U", cv::Error::BadNumChannel1U},
    {"BadNumChannels", cv::Error::BadNumChannels},
    {"BAD_NUM_CHANNELS", cv::Error::BadNumChannels},
    {"BadOffset", cv::Error::BadOffset},
    {"BAD_OFFSET", cv::Error::BadOffset},
    {"BadOrder", cv::Error::BadOrder},
    {"BAD_ORDER", cv::Error::BadOrder},
    {"BadOrigin", cv::Error::BadOrigin},
    {"BAD_ORIGIN", cv::Error::BadOrigin},
    {"BadROISize", cv::Error::BadROISize},
    {"BAD_ROISIZE", cv::Error::BadROISize},
    {"BadStep", cv::Error::BadStep},
    {"BAD_STEP", cv::Error::BadStep},
    {"BadTileSize", cv::Error::BadTileSize},
    {"BAD_TILE_SIZE", cv::Error::BadTileSize},
    {"GpuApiCallError", cv::Error::GpuApiCallError},
    {"GPU_API_CALL_ERROR", cv::Error::GpuApiCallError},
    {"GpuNotSupported", cv::Error::GpuNotSupported},
    {"GPU_NOT_SUPPORTED", cv::Error::GpuNotSupported},
    {"HeaderIsNull", cv::Error::HeaderIsNull},
    {"HEADER_IS_NULL", cv::Error::HeaderIsNull},
    {"MaskIsTiled", cv::Error::MaskIsTiled},
    {"MASK_IS_TILED", cv::Error::MaskIsTiled},
    {"OpenCLApiCallError", cv::Error::OpenCLApiCallError},
    {"OPEN_CLAPI_CALL_ERROR", cv::Error::OpenCLApiCallError},
    {"OpenCLDoubleNotSupported", cv::Error::OpenCLDoubleNotSupported},
    {"OPEN_CLDOUBLE_NOT_SUPPORTED", cv::Error::OpenCLDoubleNotSupported},
    {"OpenCLInitError", cv::Error::OpenCLInitError},
    {"OPEN_CLINIT_ERROR", cv::Error::OpenCLInitError},
    {"OpenCLNoAMDBlasFft", cv::Error::OpenCLNoAMDBlasFft},
    {"OPEN_CLNO_AMDBLAS_FFT", cv::Error::OpenCLNoAMDBlasFft},
    {"OpenGlApiCallError", cv::Error::OpenGlApiCallError},
    {"OPEN_GL_API_CALL_ERROR", cv::Error::OpenGlApiCallError},
    {"OpenGlNotSupported", cv::Error::OpenGlNotSupported},
    {"OPEN_GL_NOT_SUPPORTED", cv::Error::OpenGlNotSupported},
    {"StsAssert", cv::Error::StsAssert},
    {"STS_ASSERT", cv::Error::StsAssert},
    {"StsAutoTrace", cv::Error::StsAutoTrace},
    {"STS_AUTO_TRACE", cv::Error::StsAutoTrace},
    {"StsBackTrace", cv::Error::StsBackTrace},
    {"STS_BACK_TRACE", cv::Error::StsBackTrace},
    {"StsBadArg", cv::Error::StsBadArg},
    {"STS_BAD_ARG", cv::Error::StsBadArg},
    {"StsBadFlag", cv::Error::StsBadFlag},
    {"STS_BAD_FLAG", cv::Error::StsBadFlag},
    {"StsBadFunc", cv::Error::StsBadFunc},
    {"STS_BAD_FUNC", cv::Error::StsBadFunc},
    {"StsBadMask", cv::Error::StsBadMask},
    {"STS_BAD_MASK", cv::Error::StsBadMask},
    {"StsBadMemBlock", cv::Error::StsBadMemBlock},
    {"STS_BAD_MEM_BLOCK", cv::Error::StsBadMemBlock},
    {"StsBadPoint", cv::Error::StsBadPoint},
    {"STS_BAD_POINT", cv::Error::StsBadPoint},
    {"StsBadSize", cv::Error::StsBadSize},
    {"STS_BAD_SIZE", cv::Error::StsBadSize},
    {"StsDivByZero", cv::Error::StsDivByZero},
    {"STS_DIV_BY_ZERO", cv::Error::StsDivByZero},
    {"StsError", cv::Error::StsError},
    {"STS_ERROR", cv::Error::StsError},
    {"StsFilterOffsetErr", cv::Error::StsFilterOffsetErr},
    {"STS_FILTER_OFFSET_ERR", cv::Error::StsFilterOffsetErr},
    {"StsFilterStructContentErr", cv::Error::StsFilterStructContentErr},
    {"STS_FILTER_STRUCT_CONTENT_ERR", cv::Error::StsFilterStructContentErr},
    {"StsInplaceNotSupported", cv::Error::StsInplaceNotSupported},
    {"STS_INPLACE_NOT_SUPPORTED", cv::Error::StsInplaceNotSupported},
    {"StsInternal", cv::Error::StsInternal},
    {"STS_INTERNAL", cv::Error::StsInternal},
    {"StsKernelStructContentErr", cv::Error::StsKernelStructContentErr},
    {"STS_KERNEL_STRUCT_CONTENT_ERR", cv::Error::StsKernelStructContentErr},
    {"StsNoConv", cv::Error::StsNoConv},
    {"STS_NO_CONV", cv::Error::StsNoConv},
    {"StsNoMem", cv::Error::StsNoMem},
    {"STS_NO_MEM", cv::Error::StsNoMem},
    {"StsNotImplemented", cv::Error::StsNotImplemented},
    {"STS_NOT_IMPLEMENTED", cv::Error::StsNotImplemented},
    {"StsNullPtr", cv::Error::StsNullPtr},
    {"STS_NULL_PTR", cv::Error::StsNullPtr},
    {"StsObjectNotFound", cv::Error::StsObjectNotFound},
    {"STS_OBJECT_NOT_FOUND", cv::Error::StsObjectNotFound},
    {"StsOk", cv::Error::StsOk},
    {"STS_OK", cv::Error::StsOk},
    {"StsOutOfRange", cv::Error::StsOutOfRange},
    {"STS_OUT_OF_RANGE", cv::Error::StsOutOfRange},
    {"StsParseError", cv::Error::StsParseError},
    {"STS_PARSE_ERROR", cv::Error::StsParseError},
    {"StsUnmatchedFormats", cv::Error::StsUnmatchedFormats},
    {"STS_UNMATCHED_FORMATS", cv::Error::StsUnmatchedFormats},
    {"StsUnmatchedSizes", cv::Error::StsUnmatchedSizes},
    {"STS_UNMATCHED_SIZES", cv::Error::StsUnmatchedSizes},
    {"StsUnsupportedFormat", cv::Error::StsUnsupportedFormat},
    {"STS_UNSUPPORTED_FORMAT", cv::Error::StsUnsupportedFormat},
    {"StsVecLengthErr", cv::Error::StsVecLengthErr},
    {"STS_VEC_LENGTH_ERR", cv::Error::StsVecLengthErr},
    {NULL, 0}
};

static PyMethodDef methods_aruco[] = {
    {"Board_create", (PyCFunction)pyopencv_cv_aruco_Board_create, METH_VARARGS | METH_KEYWORDS, "Board_create(objPoints, dictionary, ids) -> retval\n.   * @brief Provide way to create Board by passing nessesary data. Specially needed in Python.\n.   *\n.   * @param objPoints array of object points of all the marker corners in the board\n.   * @param dictionary the dictionary of markers employed for this board\n.   * @param ids vector of the identifiers of the markers in the board\n.   *"},
    {"CharucoBoard_create", (PyCFunction)pyopencv_cv_aruco_CharucoBoard_create, METH_VARARGS | METH_KEYWORDS, "CharucoBoard_create(squaresX, squaresY, squareLength, markerLength, dictionary) -> retval\n.   * @brief Create a CharucoBoard object\n.   *\n.   * @param squaresX number of chessboard squares in X direction\n.   * @param squaresY number of chessboard squares in Y direction\n.   * @param squareLength chessboard square side length (normally in meters)\n.   * @param markerLength marker side length (same unit than squareLength)\n.   * @param dictionary dictionary of markers indicating the type of markers.\n.   * The first markers in the dictionary are used to fill the white chessboard squares.\n.   * @return the output CharucoBoard object\n.   *\n.   * This functions creates a CharucoBoard object given the number of squares in each direction\n.   * and the size of the markers and chessboard squares."},
    {"DetectorParameters_create", (PyCFunction)pyopencv_cv_aruco_DetectorParameters_create, METH_VARARGS | METH_KEYWORDS, "DetectorParameters_create() -> retval\n."},
    {"Dictionary_create", (PyCFunction)pyopencv_cv_aruco_Dictionary_create, METH_VARARGS | METH_KEYWORDS, "Dictionary_create(nMarkers, markerSize) -> retval\n.   * @see generateCustomDictionary"},
    {"Dictionary_create_from", (PyCFunction)pyopencv_cv_aruco_Dictionary_create_from, METH_VARARGS | METH_KEYWORDS, "Dictionary_create_from(nMarkers, markerSize, baseDictionary) -> retval\n.   * @see generateCustomDictionary"},
    {"Dictionary_get", (PyCFunction)pyopencv_cv_aruco_Dictionary_get, METH_VARARGS | METH_KEYWORDS, "Dictionary_get(dict) -> retval\n.   * @see getPredefinedDictionary"},
    {"Dictionary_getBitsFromByteList", (PyCFunction)pyopencv_cv_aruco_Dictionary_getBitsFromByteList, METH_VARARGS | METH_KEYWORDS, "Dictionary_getBitsFromByteList(byteList, markerSize) -> retval\n.   * @brief Transform list of bytes to matrix of bits"},
    {"Dictionary_getByteListFromBits", (PyCFunction)pyopencv_cv_aruco_Dictionary_getByteListFromBits, METH_VARARGS | METH_KEYWORDS, "Dictionary_getByteListFromBits(bits) -> retval\n.   * @brief Transform matrix of bits to list of bytes in the 4 rotations"},
    {"GridBoard_create", (PyCFunction)pyopencv_cv_aruco_GridBoard_create, METH_VARARGS | METH_KEYWORDS, "GridBoard_create(markersX, markersY, markerLength, markerSeparation, dictionary[, firstMarker]) -> retval\n.   * @brief Create a GridBoard object\n.   *\n.   * @param markersX number of markers in X direction\n.   * @param markersY number of markers in Y direction\n.   * @param markerLength marker side length (normally in meters)\n.   * @param markerSeparation separation between two markers (same unit as markerLength)\n.   * @param dictionary dictionary of markers indicating the type of markers\n.   * @param firstMarker id of first marker in dictionary to use on board.\n.   * @return the output GridBoard object\n.   *\n.   * This functions creates a GridBoard object given the number of markers in each direction and\n.   * the marker size and marker separation."},
    {"calibrateCameraAruco", (PyCFunction)pyopencv_cv_aruco_calibrateCameraAruco, METH_VARARGS | METH_KEYWORDS, "calibrateCameraAruco(corners, ids, counter, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   @brief It's the same function as #calibrateCameraAruco but without calibration error estimation."},
    {"calibrateCameraArucoExtended", (PyCFunction)pyopencv_cv_aruco_calibrateCameraArucoExtended, METH_VARARGS | METH_KEYWORDS, "calibrateCameraArucoExtended(corners, ids, counter, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   * @brief Calibrate a camera using aruco markers\n.   *\n.   * @param corners vector of detected marker corners in all frames.\n.   * The corners should have the same format returned by detectMarkers (see #detectMarkers).\n.   * @param ids list of identifiers for each marker in corners\n.   * @param counter number of markers in each frame so that corners and ids can be split\n.   * @param board Marker Board layout\n.   * @param imageSize Size of the image used only to initialize the intrinsic camera matrix.\n.   * @param cameraMatrix Output 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If CV\\_CALIB\\_USE\\_INTRINSIC\\_GUESS\n.   * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be\n.   * initialized before calling the function.\n.   * @param distCoeffs Output vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view\n.   * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding\n.   * k-th translation vector (see the next output parameter description) brings the board pattern\n.   * from the model coordinate space (in which object points are specified) to the world coordinate\n.   * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).\n.   * @param tvecs Output vector of translation vectors estimated for each pattern view.\n.   * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.   * Order of deviations values:\n.   * \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.   * s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.   * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.   * Order of deviations values: \\f$(R_1, T_1, \\dotsc , R_M, T_M)\\f$ where M is number of pattern views,\n.   * \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.   * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.\n.   * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).\n.   * @param criteria Termination criteria for the iterative optimization algorithm.\n.   *\n.   * This function calibrates a camera using an Aruco Board. The function receives a list of\n.   * detected markers from several views of the Board. The process is similar to the chessboard\n.   * calibration in calibrateCamera(). The function returns the final re-projection error."},
    {"calibrateCameraCharuco", (PyCFunction)pyopencv_cv_aruco_calibrateCameraCharuco, METH_VARARGS | METH_KEYWORDS, "calibrateCameraCharuco(charucoCorners, charucoIds, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs\n.   @brief It's the same function as #calibrateCameraCharuco but without calibration error estimation."},
    {"calibrateCameraCharucoExtended", (PyCFunction)pyopencv_cv_aruco_calibrateCameraCharucoExtended, METH_VARARGS | METH_KEYWORDS, "calibrateCameraCharucoExtended(charucoCorners, charucoIds, board, imageSize, cameraMatrix, distCoeffs[, rvecs[, tvecs[, stdDeviationsIntrinsics[, stdDeviationsExtrinsics[, perViewErrors[, flags[, criteria]]]]]]]) -> retval, cameraMatrix, distCoeffs, rvecs, tvecs, stdDeviationsIntrinsics, stdDeviationsExtrinsics, perViewErrors\n.   * @brief Calibrate a camera using Charuco corners\n.   *\n.   * @param charucoCorners vector of detected charuco corners per frame\n.   * @param charucoIds list of identifiers for each corner in charucoCorners per frame\n.   * @param board Marker Board layout\n.   * @param imageSize input image size\n.   * @param cameraMatrix Output 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If CV\\_CALIB\\_USE\\_INTRINSIC\\_GUESS\n.   * and/or CV_CALIB_FIX_ASPECT_RATIO are specified, some or all of fx, fy, cx, cy must be\n.   * initialized before calling the function.\n.   * @param distCoeffs Output vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each board view\n.   * (e.g. std::vector<cv::Mat>>). That is, each k-th rotation vector together with the corresponding\n.   * k-th translation vector (see the next output parameter description) brings the board pattern\n.   * from the model coordinate space (in which object points are specified) to the world coordinate\n.   * space, that is, a real position of the board pattern in the k-th pattern view (k=0.. *M* -1).\n.   * @param tvecs Output vector of translation vectors estimated for each pattern view.\n.   * @param stdDeviationsIntrinsics Output vector of standard deviations estimated for intrinsic parameters.\n.   * Order of deviations values:\n.   * \\f$(f_x, f_y, c_x, c_y, k_1, k_2, p_1, p_2, k_3, k_4, k_5, k_6 , s_1, s_2, s_3,\n.   * s_4, \\tau_x, \\tau_y)\\f$ If one of parameters is not estimated, it's deviation is equals to zero.\n.   * @param stdDeviationsExtrinsics Output vector of standard deviations estimated for extrinsic parameters.\n.   * Order of deviations values: \\f$(R_1, T_1, \\dotsc , R_M, T_M)\\f$ where M is number of pattern views,\n.   * \\f$R_i, T_i\\f$ are concatenated 1x3 vectors.\n.   * @param perViewErrors Output vector of average re-projection errors estimated for each pattern view.\n.   * @param flags flags Different flags  for the calibration process (see #calibrateCamera for details).\n.   * @param criteria Termination criteria for the iterative optimization algorithm.\n.   *\n.   * This function calibrates a camera using a set of corners of a  Charuco Board. The function\n.   * receives a list of detected corners and its identifiers from several views of the Board.\n.   * The function returns the final re-projection error."},
    {"custom_dictionary", (PyCFunction)pyopencv_cv_aruco_custom_dictionary, METH_VARARGS | METH_KEYWORDS, "custom_dictionary(nMarkers, markerSize) -> retval\n.   * @see generateCustomDictionary"},
    {"custom_dictionary_from", (PyCFunction)pyopencv_cv_aruco_custom_dictionary_from, METH_VARARGS | METH_KEYWORDS, "custom_dictionary_from(nMarkers, markerSize, baseDictionary) -> retval\n.   * @brief Generates a new customizable marker dictionary\n.   *\n.   * @param nMarkers number of markers in the dictionary\n.   * @param markerSize number of bits per dimension of each markers\n.   * @param baseDictionary Include the markers in this dictionary at the beginning (optional)\n.   *\n.   * This function creates a new dictionary composed by nMarkers markers and each markers composed\n.   * by markerSize x markerSize bits. If baseDictionary is provided, its markers are directly\n.   * included and the rest are generated based on them. If the size of baseDictionary is higher\n.   * than nMarkers, only the first nMarkers in baseDictionary are taken and no new marker is added."},
    {"detectCharucoDiamond", (PyCFunction)pyopencv_cv_aruco_detectCharucoDiamond, METH_VARARGS | METH_KEYWORDS, "detectCharucoDiamond(image, markerCorners, markerIds, squareMarkerLengthRate[, diamondCorners[, diamondIds[, cameraMatrix[, distCoeffs]]]]) -> diamondCorners, diamondIds\n.   * @brief Detect ChArUco Diamond markers\n.   *\n.   * @param image input image necessary for corner subpixel.\n.   * @param markerCorners list of detected marker corners from detectMarkers function.\n.   * @param markerIds list of marker ids in markerCorners.\n.   * @param squareMarkerLengthRate rate between square and marker length:\n.   * squareMarkerLengthRate = squareLength/markerLength. The real units are not necessary.\n.   * @param diamondCorners output list of detected diamond corners (4 corners per diamond). The order\n.   * is the same than in marker corners: top left, top right, bottom right and bottom left. Similar\n.   * format than the corners returned by detectMarkers (e.g std::vector<std::vector<cv::Point2f> > ).\n.   * @param diamondIds ids of the diamonds in diamondCorners. The id of each diamond is in fact of\n.   * type Vec4i, so each diamond has 4 ids, which are the ids of the aruco markers composing the\n.   * diamond.\n.   * @param cameraMatrix Optional camera calibration matrix.\n.   * @param distCoeffs Optional camera distortion coefficients.\n.   *\n.   * This function detects Diamond markers from the previous detected ArUco markers. The diamonds\n.   * are returned in the diamondCorners and diamondIds parameters. If camera calibration parameters\n.   * are provided, the diamond search is based on reprojection. If not, diamond search is based on\n.   * homography. Homography is faster than reprojection but can slightly reduce the detection rate."},
    {"detectMarkers", (PyCFunction)pyopencv_cv_aruco_detectMarkers, METH_VARARGS | METH_KEYWORDS, "detectMarkers(image, dictionary[, corners[, ids[, parameters[, rejectedImgPoints[, cameraMatrix[, distCoeff]]]]]]) -> corners, ids, rejectedImgPoints\n.   * @brief Basic marker detection\n.   *\n.   * @param image input image\n.   * @param dictionary indicates the type of markers that will be searched\n.   * @param corners vector of detected marker corners. For each marker, its four corners\n.   * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,\n.   * the dimensions of this array is Nx4. The order of the corners is clockwise.\n.   * @param ids vector of identifiers of the detected markers. The identifier is of type int\n.   * (e.g. std::vector<int>). For N detected markers, the size of ids is also N.\n.   * The identifiers have the same order than the markers in the imgPoints array.\n.   * @param parameters marker detection parameters\n.   * @param rejectedImgPoints contains the imgPoints of those squares whose inner code has not a\n.   * correct codification. Useful for debugging purposes.\n.   * @param cameraMatrix optional input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeff optional vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   *\n.   * Performs marker detection in the input image. Only markers included in the specific dictionary\n.   * are searched. For each detected marker, it returns the 2D position of its corner in the image\n.   * and its corresponding identifier.\n.   * Note that this function does not perform pose estimation.\n.   * @sa estimatePoseSingleMarkers,  estimatePoseBoard\n.   *"},
    {"drawAxis", (PyCFunction)pyopencv_cv_aruco_drawAxis, METH_VARARGS | METH_KEYWORDS, "drawAxis(image, cameraMatrix, distCoeffs, rvec, tvec, length) -> image\n.   * @brief Draw coordinate system axis from pose estimation\n.   *\n.   * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.   * altered.\n.   * @param cameraMatrix input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvec rotation vector of the coordinate system that will be drawn. (@sa Rodrigues).\n.   * @param tvec translation vector of the coordinate system that will be drawn.\n.   * @param length length of the painted axis in the same unit than tvec (usually in meters)\n.   *\n.   * Given the pose estimation of a marker or board, this function draws the axis of the world\n.   * coordinate system, i.e. the system centered on the marker/board. Useful for debugging purposes."},
    {"drawDetectedCornersCharuco", (PyCFunction)pyopencv_cv_aruco_drawDetectedCornersCharuco, METH_VARARGS | METH_KEYWORDS, "drawDetectedCornersCharuco(image, charucoCorners[, charucoIds[, cornerColor]]) -> image\n.   * @brief Draws a set of Charuco corners\n.   * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.   * altered.\n.   * @param charucoCorners vector of detected charuco corners\n.   * @param charucoIds list of identifiers for each corner in charucoCorners\n.   * @param cornerColor color of the square surrounding each corner\n.   *\n.   * This function draws a set of detected Charuco corners. If identifiers vector is provided, it also\n.   * draws the id of each corner."},
    {"drawDetectedDiamonds", (PyCFunction)pyopencv_cv_aruco_drawDetectedDiamonds, METH_VARARGS | METH_KEYWORDS, "drawDetectedDiamonds(image, diamondCorners[, diamondIds[, borderColor]]) -> image\n.   * @brief Draw a set of detected ChArUco Diamond markers\n.   *\n.   * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.   * altered.\n.   * @param diamondCorners positions of diamond corners in the same format returned by\n.   * detectCharucoDiamond(). (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,\n.   * the dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.   * @param diamondIds vector of identifiers for diamonds in diamondCorners, in the same format\n.   * returned by detectCharucoDiamond() (e.g. std::vector<Vec4i>).\n.   * Optional, if not provided, ids are not painted.\n.   * @param borderColor color of marker borders. Rest of colors (text color and first corner color)\n.   * are calculated based on this one.\n.   *\n.   * Given an array of detected diamonds, this functions draws them in the image. The marker borders\n.   * are painted and the markers identifiers if provided.\n.   * Useful for debugging purposes."},
    {"drawDetectedMarkers", (PyCFunction)pyopencv_cv_aruco_drawDetectedMarkers, METH_VARARGS | METH_KEYWORDS, "drawDetectedMarkers(image, corners[, ids[, borderColor]]) -> image\n.   * @brief Draw detected markers in image\n.   *\n.   * @param image input/output image. It must have 1 or 3 channels. The number of channels is not\n.   * altered.\n.   * @param corners positions of marker corners on input image.\n.   * (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the dimensions of\n.   * this array should be Nx4. The order of the corners should be clockwise.\n.   * @param ids vector of identifiers for markers in markersCorners .\n.   * Optional, if not provided, ids are not painted.\n.   * @param borderColor color of marker borders. Rest of colors (text color and first corner color)\n.   * are calculated based on this one to improve visualization.\n.   *\n.   * Given an array of detected marker corners and its corresponding ids, this functions draws\n.   * the markers in the image. The marker borders are painted and the markers identifiers if provided.\n.   * Useful for debugging purposes."},
    {"drawMarker", (PyCFunction)pyopencv_cv_aruco_drawMarker, METH_VARARGS | METH_KEYWORDS, "drawMarker(dictionary, id, sidePixels[, img[, borderBits]]) -> img\n.   * @brief Draw a canonical marker image\n.   *\n.   * @param dictionary dictionary of markers indicating the type of markers\n.   * @param id identifier of the marker that will be returned. It has to be a valid id\n.   * in the specified dictionary.\n.   * @param sidePixels size of the image in pixels\n.   * @param img output image with the marker\n.   * @param borderBits width of the marker border.\n.   *\n.   * This function returns a marker image in its canonical form (i.e. ready to be printed)"},
    {"drawPlanarBoard", (PyCFunction)pyopencv_cv_aruco_drawPlanarBoard, METH_VARARGS | METH_KEYWORDS, "drawPlanarBoard(board, outSize[, img[, marginSize[, borderBits]]]) -> img\n.   * @brief Draw a planar board\n.   * @sa _drawPlanarBoardImpl\n.   *\n.   * @param board layout of the board that will be drawn. The board should be planar,\n.   * z coordinate is ignored\n.   * @param outSize size of the output image in pixels.\n.   * @param img output image with the board. The size of this image will be outSize\n.   * and the board will be on the center, keeping the board proportions.\n.   * @param marginSize minimum margins (in pixels) of the board in the output image\n.   * @param borderBits width of the marker borders.\n.   *\n.   * This function return the image of a planar board, ready to be printed. It assumes\n.   * the Board layout specified is planar by ignoring the z coordinates of the object points."},
    {"estimatePoseBoard", (PyCFunction)pyopencv_cv_aruco_estimatePoseBoard, METH_VARARGS | METH_KEYWORDS, "estimatePoseBoard(corners, ids, board, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess]]]) -> retval, rvec, tvec\n.   * @brief Pose estimation for a board of markers\n.   *\n.   * @param corners vector of already detected markers corners. For each marker, its four corners\n.   * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the\n.   * dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.   * @param ids list of identifiers for each marker in corners\n.   * @param board layout of markers in the board. The layout is composed by the marker identifiers\n.   * and the positions of each marker corner in the board reference system.\n.   * @param cameraMatrix input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board\n.   * (see cv::Rodrigues). Used as initial guess if not empty.\n.   * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.\n.   * @param useExtrinsicGuess defines whether initial guess for \\b rvec and \\b tvec will be used or not.\n.   * Used as initial guess if not empty.\n.   *\n.   * This function receives the detected markers and returns the pose of a marker board composed\n.   * by those markers.\n.   * A Board of marker has a single world coordinate system which is defined by the board layout.\n.   * The returned transformation is the one that transforms points from the board coordinate system\n.   * to the camera coordinate system.\n.   * Input markers that are not included in the board layout are ignored.\n.   * The function returns the number of markers from the input employed for the board pose estimation.\n.   * Note that returning a 0 means the pose has not been estimated."},
    {"estimatePoseCharucoBoard", (PyCFunction)pyopencv_cv_aruco_estimatePoseCharucoBoard, METH_VARARGS | METH_KEYWORDS, "estimatePoseCharucoBoard(charucoCorners, charucoIds, board, cameraMatrix, distCoeffs[, rvec[, tvec[, useExtrinsicGuess]]]) -> retval, rvec, tvec\n.   * @brief Pose estimation for a ChArUco board given some of their corners\n.   * @param charucoCorners vector of detected charuco corners\n.   * @param charucoIds list of identifiers for each corner in charucoCorners\n.   * @param board layout of ChArUco board.\n.   * @param cameraMatrix input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvec Output vector (e.g. cv::Mat) corresponding to the rotation vector of the board\n.   * (see cv::Rodrigues).\n.   * @param tvec Output vector (e.g. cv::Mat) corresponding to the translation vector of the board.\n.   * @param useExtrinsicGuess defines whether initial guess for \\b rvec and \\b tvec will be used or not.\n.   *\n.   * This function estimates a Charuco board pose from some detected corners.\n.   * The function checks if the input corners are enough and valid to perform pose estimation.\n.   * If pose estimation is valid, returns true, else returns false."},
    {"estimatePoseSingleMarkers", (PyCFunction)pyopencv_cv_aruco_estimatePoseSingleMarkers, METH_VARARGS | METH_KEYWORDS, "estimatePoseSingleMarkers(corners, markerLength, cameraMatrix, distCoeffs[, rvecs[, tvecs[, _objPoints]]]) -> rvecs, tvecs, _objPoints\n.   * @brief Pose estimation for single markers\n.   *\n.   * @param corners vector of already detected markers corners. For each marker, its four corners\n.   * are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers,\n.   * the dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.   * @sa detectMarkers\n.   * @param markerLength the length of the markers' side. The returning translation vectors will\n.   * be in the same unit. Normally, unit is meters.\n.   * @param cameraMatrix input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param rvecs array of output rotation vectors (@sa Rodrigues) (e.g. std::vector<cv::Vec3d>).\n.   * Each element in rvecs corresponds to the specific marker in imgPoints.\n.   * @param tvecs array of output translation vectors (e.g. std::vector<cv::Vec3d>).\n.   * Each element in tvecs corresponds to the specific marker in imgPoints.\n.   * @param _objPoints array of object points of all the marker corners\n.   *\n.   * This function receives the detected markers and returns their pose estimation respect to\n.   * the camera individually. So for each marker, one rotation and translation vector is returned.\n.   * The returned transformation is the one that transforms points from each marker coordinate system\n.   * to the camera coordinate system.\n.   * The marker corrdinate system is centered on the middle of the marker, with the Z axis\n.   * perpendicular to the marker plane.\n.   * The coordinates of the four corners of the marker in its own coordinate system are:\n.   * (-markerLength/2, markerLength/2, 0), (markerLength/2, markerLength/2, 0),\n.   * (markerLength/2, -markerLength/2, 0), (-markerLength/2, -markerLength/2, 0)"},
    {"getBoardObjectAndImagePoints", (PyCFunction)pyopencv_cv_aruco_getBoardObjectAndImagePoints, METH_VARARGS | METH_KEYWORDS, "getBoardObjectAndImagePoints(board, detectedCorners, detectedIds[, objPoints[, imgPoints]]) -> objPoints, imgPoints\n.   * @brief Given a board configuration and a set of detected markers, returns the corresponding\n.   * image points and object points to call solvePnP\n.   *\n.   * @param board Marker board layout.\n.   * @param detectedCorners List of detected marker corners of the board.\n.   * @param detectedIds List of identifiers for each marker.\n.   * @param objPoints Vector of vectors of board marker points in the board coordinate space.\n.   * @param imgPoints Vector of vectors of the projections of board marker corner points."},
    {"getPredefinedDictionary", (PyCFunction)pyopencv_cv_aruco_getPredefinedDictionary, METH_VARARGS | METH_KEYWORDS, "getPredefinedDictionary(dict) -> retval\n.   * @brief Returns one of the predefined dictionaries referenced by DICT_*."},
    {"interpolateCornersCharuco", (PyCFunction)pyopencv_cv_aruco_interpolateCornersCharuco, METH_VARARGS | METH_KEYWORDS, "interpolateCornersCharuco(markerCorners, markerIds, image, board[, charucoCorners[, charucoIds[, cameraMatrix[, distCoeffs[, minMarkers]]]]]) -> retval, charucoCorners, charucoIds\n.   * @brief Interpolate position of ChArUco board corners\n.   * @param markerCorners vector of already detected markers corners. For each marker, its four\n.   * corners are provided, (e.g std::vector<std::vector<cv::Point2f> > ). For N detected markers, the\n.   * dimensions of this array should be Nx4. The order of the corners should be clockwise.\n.   * @param markerIds list of identifiers for each marker in corners\n.   * @param image input image necesary for corner refinement. Note that markers are not detected and\n.   * should be sent in corners and ids parameters.\n.   * @param board layout of ChArUco board.\n.   * @param charucoCorners interpolated chessboard corners\n.   * @param charucoIds interpolated chessboard corners identifiers\n.   * @param cameraMatrix optional 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs optional vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param minMarkers number of adjacent markers that must be detected to return a charuco corner\n.   *\n.   * This function receives the detected markers and returns the 2D position of the chessboard corners\n.   * from a ChArUco board using the detected Aruco markers. If camera parameters are provided,\n.   * the process is based in an approximated pose estimation, else it is based on local homography.\n.   * Only visible corners are returned. For each corner, its corresponding identifier is\n.   * also returned in charucoIds.\n.   * The function returns the number of interpolated corners."},
    {"refineDetectedMarkers", (PyCFunction)pyopencv_cv_aruco_refineDetectedMarkers, METH_VARARGS | METH_KEYWORDS, "refineDetectedMarkers(image, board, detectedCorners, detectedIds, rejectedCorners[, cameraMatrix[, distCoeffs[, minRepDistance[, errorCorrectionRate[, checkAllOrders[, recoveredIdxs[, parameters]]]]]]]) -> detectedCorners, detectedIds, rejectedCorners, recoveredIdxs\n.   * @brief Refind not detected markers based on the already detected and the board layout\n.   *\n.   * @param image input image\n.   * @param board layout of markers in the board.\n.   * @param detectedCorners vector of already detected marker corners.\n.   * @param detectedIds vector of already detected marker identifiers.\n.   * @param rejectedCorners vector of rejected candidates during the marker detection process.\n.   * @param cameraMatrix optional input 3x3 floating-point camera matrix\n.   * \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$\n.   * @param distCoeffs optional vector of distortion coefficients\n.   * \\f$(k_1, k_2, p_1, p_2[, k_3[, k_4, k_5, k_6],[s_1, s_2, s_3, s_4]])\\f$ of 4, 5, 8 or 12 elements\n.   * @param minRepDistance minimum distance between the corners of the rejected candidate and the\n.   * reprojected marker in order to consider it as a correspondence.\n.   * @param errorCorrectionRate rate of allowed erroneous bits respect to the error correction\n.   * capability of the used dictionary. -1 ignores the error correction step.\n.   * @param checkAllOrders Consider the four posible corner orders in the rejectedCorners array.\n.   * If it set to false, only the provided corner order is considered (default true).\n.   * @param recoveredIdxs Optional array to returns the indexes of the recovered candidates in the\n.   * original rejectedCorners array.\n.   * @param parameters marker detection parameters\n.   *\n.   * This function tries to find markers that were not detected in the basic detecMarkers function.\n.   * First, based on the current detected marker and the board layout, the function interpolates\n.   * the position of the missing markers. Then it tries to find correspondence between the reprojected\n.   * markers and the rejected candidates based on the minRepDistance and errorCorrectionRate\n.   * parameters.\n.   * If camera parameters and distortion coefficients are provided, missing markers are reprojected\n.   * using projectPoint function. If not, missing marker projections are interpolated using global\n.   * homography, and all the marker corners in the board must have the same Z coordinate."},
    {NULL, NULL}
};

static ConstDef consts_aruco[] = {
    {"CORNER_REFINE_CONTOUR", cv::aruco::CORNER_REFINE_CONTOUR},
    {"CORNER_REFINE_NONE", cv::aruco::CORNER_REFINE_NONE},
    {"CORNER_REFINE_SUBPIX", cv::aruco::CORNER_REFINE_SUBPIX},
    {"DICT_4X4_100", cv::aruco::DICT_4X4_100},
    {"DICT_4X4_1000", cv::aruco::DICT_4X4_1000},
    {"DICT_4X4_250", cv::aruco::DICT_4X4_250},
    {"DICT_4X4_50", cv::aruco::DICT_4X4_50},
    {"DICT_5X5_100", cv::aruco::DICT_5X5_100},
    {"DICT_5X5_1000", cv::aruco::DICT_5X5_1000},
    {"DICT_5X5_250", cv::aruco::DICT_5X5_250},
    {"DICT_5X5_50", cv::aruco::DICT_5X5_50},
    {"DICT_6X6_100", cv::aruco::DICT_6X6_100},
    {"DICT_6X6_1000", cv::aruco::DICT_6X6_1000},
    {"DICT_6X6_250", cv::aruco::DICT_6X6_250},
    {"DICT_6X6_50", cv::aruco::DICT_6X6_50},
    {"DICT_7X7_100", cv::aruco::DICT_7X7_100},
    {"DICT_7X7_1000", cv::aruco::DICT_7X7_1000},
    {"DICT_7X7_250", cv::aruco::DICT_7X7_250},
    {"DICT_7X7_50", cv::aruco::DICT_7X7_50},
    {"DICT_ARUCO_ORIGINAL", cv::aruco::DICT_ARUCO_ORIGINAL},
    {NULL, 0}
};

static PyMethodDef methods_bgsegm[] = {
    {"createBackgroundSubtractorCNT", (PyCFunction)pyopencv_cv_bgsegm_createBackgroundSubtractorCNT, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorCNT([, minPixelStability[, useHistory[, maxPixelStability[, isParallel]]]]) -> retval\n.   @brief Creates a CNT Background Subtractor\n.   \n.   @param minPixelStability number of frames with same pixel color to consider stable\n.   @param useHistory determines if we're giving a pixel credit for being stable for a long time\n.   @param maxPixelStability maximum allowed credit for a pixel in history\n.   @param isParallel determines if we're parallelizing the algorithm"},
    {"createBackgroundSubtractorGMG", (PyCFunction)pyopencv_cv_bgsegm_createBackgroundSubtractorGMG, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorGMG([, initializationFrames[, decisionThreshold]]) -> retval\n.   @brief Creates a GMG Background Subtractor\n.   \n.   @param initializationFrames number of frames used to initialize the background models.\n.   @param decisionThreshold Threshold value, above which it is marked foreground, else background."},
    {"createBackgroundSubtractorGSOC", (PyCFunction)pyopencv_cv_bgsegm_createBackgroundSubtractorGSOC, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorGSOC([, mc[, nSamples[, replaceRate[, propagationRate[, hitsThreshold[, alpha[, beta[, blinkingSupressionDecay[, blinkingSupressionMultiplier[, noiseRemovalThresholdFacBG[, noiseRemovalThresholdFacFG]]]]]]]]]]]) -> retval\n.   @brief Creates an instance of BackgroundSubtractorGSOC algorithm.\n.   \n.   Implementation of the different yet better algorithm which is called GSOC, as it was implemented during GSOC and was not originated from any paper.\n.   \n.   @param mc Whether to use camera motion compensation.\n.   @param nSamples Number of samples to maintain at each point of the frame.\n.   @param replaceRate Probability of replacing the old sample - how fast the model will update itself.\n.   @param propagationRate Probability of propagating to neighbors.\n.   @param hitsThreshold How many positives the sample must get before it will be considered as a possible replacement.\n.   @param alpha Scale coefficient for threshold.\n.   @param beta Bias coefficient for threshold.\n.   @param blinkingSupressionDecay Blinking supression decay factor.\n.   @param blinkingSupressionMultiplier Blinking supression multiplier.\n.   @param noiseRemovalThresholdFacBG Strength of the noise removal for background points.\n.   @param noiseRemovalThresholdFacFG Strength of the noise removal for foreground points."},
    {"createBackgroundSubtractorLSBP", (PyCFunction)pyopencv_cv_bgsegm_createBackgroundSubtractorLSBP, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorLSBP([, mc[, nSamples[, LSBPRadius[, Tlower[, Tupper[, Tinc[, Tdec[, Rscale[, Rincdec[, noiseRemovalThresholdFacBG[, noiseRemovalThresholdFacFG[, LSBPthreshold[, minCount]]]]]]]]]]]]]) -> retval\n.   @brief Creates an instance of BackgroundSubtractorLSBP algorithm.\n.   \n.   Background Subtraction using Local SVD Binary Pattern. More details about the algorithm can be found at @cite LGuo2016\n.   \n.   @param mc Whether to use camera motion compensation.\n.   @param nSamples Number of samples to maintain at each point of the frame.\n.   @param LSBPRadius LSBP descriptor radius.\n.   @param Tlower Lower bound for T-values. See @cite LGuo2016 for details.\n.   @param Tupper Upper bound for T-values. See @cite LGuo2016 for details.\n.   @param Tinc Increase step for T-values. See @cite LGuo2016 for details.\n.   @param Tdec Decrease step for T-values. See @cite LGuo2016 for details.\n.   @param Rscale Scale coefficient for threshold values.\n.   @param Rincdec Increase/Decrease step for threshold values.\n.   @param noiseRemovalThresholdFacBG Strength of the noise removal for background points.\n.   @param noiseRemovalThresholdFacFG Strength of the noise removal for foreground points.\n.   @param LSBPthreshold Threshold for LSBP binary string.\n.   @param minCount Minimal number of matches for sample to be considered as foreground."},
    {"createBackgroundSubtractorMOG", (PyCFunction)pyopencv_cv_bgsegm_createBackgroundSubtractorMOG, METH_VARARGS | METH_KEYWORDS, "createBackgroundSubtractorMOG([, history[, nmixtures[, backgroundRatio[, noiseSigma]]]]) -> retval\n.   @brief Creates mixture-of-gaussian background subtractor\n.   \n.   @param history Length of the history.\n.   @param nmixtures Number of Gaussian mixtures.\n.   @param backgroundRatio Background ratio.\n.   @param noiseSigma Noise strength (standard deviation of the brightness or each color channel). 0\n.   means some automatic value."},
    {"createSyntheticSequenceGenerator", (PyCFunction)pyopencv_cv_bgsegm_createSyntheticSequenceGenerator, METH_VARARGS | METH_KEYWORDS, "createSyntheticSequenceGenerator(background, object[, amplitude[, wavelength[, wavespeed[, objspeed]]]]) -> retval\n.   @brief Creates an instance of SyntheticSequenceGenerator.\n.   \n.   @param background Background image for object.\n.   @param object Object image which will move slowly over the background.\n.   @param amplitude Amplitude of wave distortion applied to background.\n.   @param wavelength Length of waves in distortion applied to background.\n.   @param wavespeed How fast waves will move.\n.   @param objspeed How fast object will fly over background."},
    {NULL, NULL}
};

static ConstDef consts_bgsegm[] = {
    {"LSBP_CAMERA_MOTION_COMPENSATION_LK", cv::bgsegm::LSBP_CAMERA_MOTION_COMPENSATION_LK},
    {"LSBP_CAMERA_MOTION_COMPENSATION_NONE", cv::bgsegm::LSBP_CAMERA_MOTION_COMPENSATION_NONE},
    {NULL, 0}
};

static PyMethodDef methods_bioinspired[] = {
    {"RetinaFastToneMapping_create", (PyCFunction)pyopencv_cv_bioinspired_RetinaFastToneMapping_create, METH_VARARGS | METH_KEYWORDS, "RetinaFastToneMapping_create(inputSize) -> retval\n."},
    {"Retina_create", (PyCFunction)pyopencv_cv_bioinspired_Retina_create, METH_VARARGS | METH_KEYWORDS, "Retina_create(inputSize) -> retval\n.   @overload\n\n\n\nRetina_create(inputSize, colorMode[, colorSamplingMethod[, useRetinaLogSampling[, reductionFactor[, samplingStrenght]]]]) -> retval\n.   @brief Constructors from standardized interfaces : retreive a smart pointer to a Retina instance\n.   \n.   @param inputSize the input frame size\n.   @param colorMode the chosen processing mode : with or without color processing\n.   @param colorSamplingMethod specifies which kind of color sampling will be used :\n.   -   cv::bioinspired::RETINA_COLOR_RANDOM: each pixel position is either R, G or B in a random choice\n.   -   cv::bioinspired::RETINA_COLOR_DIAGONAL: color sampling is RGBRGBRGB..., line 2 BRGBRGBRG..., line 3, GBRGBRGBR...\n.   -   cv::bioinspired::RETINA_COLOR_BAYER: standard bayer sampling\n.   @param useRetinaLogSampling activate retina log sampling, if true, the 2 following parameters can\n.   be used\n.   @param reductionFactor only usefull if param useRetinaLogSampling=true, specifies the reduction\n.   factor of the output frame (as the center (fovea) is high resolution and corners can be\n.   underscaled, then a reduction of the output is allowed without precision leak\n.   @param samplingStrenght only usefull if param useRetinaLogSampling=true, specifies the strenght of\n.   the log scale that is applied"},
    {"TransientAreasSegmentationModule_create", (PyCFunction)pyopencv_cv_bioinspired_TransientAreasSegmentationModule_create, METH_VARARGS | METH_KEYWORDS, "TransientAreasSegmentationModule_create(inputSize) -> retval\n.   @brief allocator\n.   @param inputSize : size of the images input to segment (output will be the same size)"},
    {NULL, NULL}
};

static ConstDef consts_bioinspired[] = {
    {"RETINA_COLOR_BAYER", cv::bioinspired::RETINA_COLOR_BAYER},
    {"RETINA_COLOR_DIAGONAL", cv::bioinspired::RETINA_COLOR_DIAGONAL},
    {"RETINA_COLOR_RANDOM", cv::bioinspired::RETINA_COLOR_RANDOM},
    {NULL, 0}
};

static PyMethodDef methods_datasets[] = {
    {NULL, NULL}
};

static ConstDef consts_datasets[] = {
    {"LADYBUG", cv::datasets::LADYBUG},
    {"LEFT", cv::datasets::LEFT},
    {"NEG", cv::datasets::NEG},
    {"POS", cv::datasets::POS},
    {"RIGHT", cv::datasets::RIGHT},
    {"circle", cv::datasets::circle},
    {"CIRCLE", cv::datasets::circle},
    {"comehere", cv::datasets::comehere},
    {"COMEHERE", cv::datasets::comehere},
    {"cross", cv::datasets::cross},
    {"CROSS", cv::datasets::cross},
    {"dark", cv::datasets::dark},
    {"DARK", cv::datasets::dark},
    {"female", cv::datasets::female},
    {"FEMALE", cv::datasets::female},
    {"fist", cv::datasets::fist},
    {"FIST", cv::datasets::fist},
    {"flat", cv::datasets::flat},
    {"FLAT", cv::datasets::flat},
    {"humaneva_1", cv::datasets::humaneva_1},
    {"HUMANEVA_1", cv::datasets::humaneva_1},
    {"humaneva_2", cv::datasets::humaneva_2},
    {"HUMANEVA_2", cv::datasets::humaneva_2},
    {"index", cv::datasets::index},
    {"INDEX", cv::datasets::index},
    {"light", cv::datasets::light},
    {"LIGHT", cv::datasets::light},
    {"male", cv::datasets::male},
    {"MALE", cv::datasets::male},
    {"none", cv::datasets::none},
    {"NONE", cv::datasets::none},
    {"paperWithCharacters", cv::datasets::paperWithCharacters},
    {"PAPER_WITH_CHARACTERS", cv::datasets::paperWithCharacters},
    {"pat", cv::datasets::pat},
    {"PAT", cv::datasets::pat},
    {"rightleft", cv::datasets::rightleft},
    {"RIGHTLEFT", cv::datasets::rightleft},
    {"triangle", cv::datasets::triangle},
    {"TRIANGLE", cv::datasets::triangle},
    {"turnaround", cv::datasets::turnaround},
    {"TURNAROUND", cv::datasets::turnaround},
    {"updown", cv::datasets::updown},
    {"UPDOWN", cv::datasets::updown},
    {"wave", cv::datasets::wave},
    {"WAVE", cv::datasets::wave},
    {"whitePaper", cv::datasets::whitePaper},
    {"WHITE_PAPER", cv::datasets::whitePaper},
    {"woodenBoard", cv::datasets::woodenBoard},
    {"WOODEN_BOARD", cv::datasets::woodenBoard},
    {"z", cv::datasets::z},
    {"Z", cv::datasets::z},
    {NULL, 0}
};

static PyMethodDef methods_detail[] = {
    {NULL, NULL}
};

static ConstDef consts_detail[] = {
    {"Blender_FEATHER", cv::detail::Blender::FEATHER},
    {"BLENDER_FEATHER", cv::detail::Blender::FEATHER},
    {"Blender_MULTI_BAND", cv::detail::Blender::MULTI_BAND},
    {"BLENDER_MULTI_BAND", cv::detail::Blender::MULTI_BAND},
    {"Blender_NO", cv::detail::Blender::NO},
    {"BLENDER_NO", cv::detail::Blender::NO},
    {"DpSeamFinder_COLOR", cv::detail::DpSeamFinder::COLOR},
    {"DP_SEAM_FINDER_COLOR", cv::detail::DpSeamFinder::COLOR},
    {"DpSeamFinder_COLOR_GRAD", cv::detail::DpSeamFinder::COLOR_GRAD},
    {"DP_SEAM_FINDER_COLOR_GRAD", cv::detail::DpSeamFinder::COLOR_GRAD},
    {"ExposureCompensator_GAIN", cv::detail::ExposureCompensator::GAIN},
    {"EXPOSURE_COMPENSATOR_GAIN", cv::detail::ExposureCompensator::GAIN},
    {"ExposureCompensator_GAIN_BLOCKS", cv::detail::ExposureCompensator::GAIN_BLOCKS},
    {"EXPOSURE_COMPENSATOR_GAIN_BLOCKS", cv::detail::ExposureCompensator::GAIN_BLOCKS},
    {"ExposureCompensator_NO", cv::detail::ExposureCompensator::NO},
    {"EXPOSURE_COMPENSATOR_NO", cv::detail::ExposureCompensator::NO},
    {"GraphCutSeamFinderBase_COST_COLOR", cv::detail::GraphCutSeamFinderBase::COST_COLOR},
    {"GRAPH_CUT_SEAM_FINDER_BASE_COST_COLOR", cv::detail::GraphCutSeamFinderBase::COST_COLOR},
    {"GraphCutSeamFinderBase_COST_COLOR_GRAD", cv::detail::GraphCutSeamFinderBase::COST_COLOR_GRAD},
    {"GRAPH_CUT_SEAM_FINDER_BASE_COST_COLOR_GRAD", cv::detail::GraphCutSeamFinderBase::COST_COLOR_GRAD},
    {"Timelapser_AS_IS", cv::detail::Timelapser::AS_IS},
    {"TIMELAPSER_AS_IS", cv::detail::Timelapser::AS_IS},
    {"Timelapser_CROP", cv::detail::Timelapser::CROP},
    {"TIMELAPSER_CROP", cv::detail::Timelapser::CROP},
    {"WAVE_CORRECT_HORIZ", cv::detail::WAVE_CORRECT_HORIZ},
    {"WAVE_CORRECT_VERT", cv::detail::WAVE_CORRECT_VERT},
    {NULL, 0}
};

static PyMethodDef methods_face[] = {
    {"BIF_create", (PyCFunction)pyopencv_cv_face_BIF_create, METH_VARARGS | METH_KEYWORDS, "BIF_create([, num_bands[, num_rotations]]) -> retval\n.   * @param num_bands The number of filter bands (<=8) used for computing BIF.\n.   * @param num_rotations The number of image rotations for computing BIF.\n.   * @returns Object for computing BIF."},
    {"EigenFaceRecognizer_create", (PyCFunction)pyopencv_cv_face_EigenFaceRecognizer_create, METH_VARARGS | METH_KEYWORDS, "EigenFaceRecognizer_create([, num_components[, threshold]]) -> retval\n.   @param num_components The number of components (read: Eigenfaces) kept for this Principal\n.   Component Analysis. As a hint: There's no rule how many components (read: Eigenfaces) should be\n.   kept for good reconstruction capabilities. It is based on your input data, so experiment with the\n.   number. Keeping 80 components should almost always be sufficient.\n.   @param threshold The threshold applied in the prediction.\n.   \n.   ### Notes:\n.   \n.   -   Training and prediction must be done on grayscale images, use cvtColor to convert between the\n.   color spaces.\n.   -   **THE EIGENFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL\n.   SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your\n.   input data has the correct shape, else a meaningful exception is thrown. Use resize to resize\n.   the images.\n.   -   This model does not support updating.\n.   \n.   ### Model internal data:\n.   \n.   -   num_components see EigenFaceRecognizer::create.\n.   -   threshold see EigenFaceRecognizer::create.\n.   -   eigenvalues The eigenvalues for this Principal Component Analysis (ordered descending).\n.   -   eigenvectors The eigenvectors for this Principal Component Analysis (ordered by their\n.   eigenvalue).\n.   -   mean The sample mean calculated from the training data.\n.   -   projections The projections of the training data.\n.   -   labels The threshold applied in the prediction. If the distance to the nearest neighbor is\n.   larger than the threshold, this method returns -1."},
    {"FisherFaceRecognizer_create", (PyCFunction)pyopencv_cv_face_FisherFaceRecognizer_create, METH_VARARGS | METH_KEYWORDS, "FisherFaceRecognizer_create([, num_components[, threshold]]) -> retval\n.   @param num_components The number of components (read: Fisherfaces) kept for this Linear\n.   Discriminant Analysis with the Fisherfaces criterion. It's useful to keep all components, that\n.   means the number of your classes c (read: subjects, persons you want to recognize). If you leave\n.   this at the default (0) or set it to a value less-equal 0 or greater (c-1), it will be set to the\n.   correct number (c-1) automatically.\n.   @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor\n.   is larger than the threshold, this method returns -1.\n.   \n.   ### Notes:\n.   \n.   -   Training and prediction must be done on grayscale images, use cvtColor to convert between the\n.   color spaces.\n.   -   **THE FISHERFACES METHOD MAKES THE ASSUMPTION, THAT THE TRAINING AND TEST IMAGES ARE OF EQUAL\n.   SIZE.** (caps-lock, because I got so many mails asking for this). You have to make sure your\n.   input data has the correct shape, else a meaningful exception is thrown. Use resize to resize\n.   the images.\n.   -   This model does not support updating.\n.   \n.   ### Model internal data:\n.   \n.   -   num_components see FisherFaceRecognizer::create.\n.   -   threshold see FisherFaceRecognizer::create.\n.   -   eigenvalues The eigenvalues for this Linear Discriminant Analysis (ordered descending).\n.   -   eigenvectors The eigenvectors for this Linear Discriminant Analysis (ordered by their\n.   eigenvalue).\n.   -   mean The sample mean calculated from the training data.\n.   -   projections The projections of the training data.\n.   -   labels The labels corresponding to the projections."},
    {"LBPHFaceRecognizer_create", (PyCFunction)pyopencv_cv_face_LBPHFaceRecognizer_create, METH_VARARGS | METH_KEYWORDS, "LBPHFaceRecognizer_create([, radius[, neighbors[, grid_x[, grid_y[, threshold]]]]]) -> retval\n.   @param radius The radius used for building the Circular Local Binary Pattern. The greater the\n.   radius, the smoother the image but more spatial information you can get.\n.   @param neighbors The number of sample points to build a Circular Local Binary Pattern from. An\n.   appropriate value is to use `8` sample points. Keep in mind: the more sample points you include,\n.   the higher the computational cost.\n.   @param grid_x The number of cells in the horizontal direction, 8 is a common value used in\n.   publications. The more cells, the finer the grid, the higher the dimensionality of the resulting\n.   feature vector.\n.   @param grid_y The number of cells in the vertical direction, 8 is a common value used in\n.   publications. The more cells, the finer the grid, the higher the dimensionality of the resulting\n.   feature vector.\n.   @param threshold The threshold applied in the prediction. If the distance to the nearest neighbor\n.   is larger than the threshold, this method returns -1.\n.   \n.   ### Notes:\n.   \n.   -   The Circular Local Binary Patterns (used in training and prediction) expect the data given as\n.   grayscale images, use cvtColor to convert between the color spaces.\n.   -   This model supports updating.\n.   \n.   ### Model internal data:\n.   \n.   -   radius see LBPHFaceRecognizer::create.\n.   -   neighbors see LBPHFaceRecognizer::create.\n.   -   grid_x see LLBPHFaceRecognizer::create.\n.   -   grid_y see LBPHFaceRecognizer::create.\n.   -   threshold see LBPHFaceRecognizer::create.\n.   -   histograms Local Binary Patterns Histograms calculated from the given training data (empty if\n.   none was given).\n.   -   labels Labels corresponding to the calculated Local Binary Patterns Histograms."},
    {"StandardCollector_create", (PyCFunction)pyopencv_cv_face_StandardCollector_create, METH_VARARGS | METH_KEYWORDS, "StandardCollector_create([, threshold]) -> retval\n.   @brief Static constructor\n.   @param threshold set threshold"},
    {"drawFacemarks", (PyCFunction)pyopencv_cv_face_drawFacemarks, METH_VARARGS | METH_KEYWORDS, "drawFacemarks(image, points[, color]) -> image\n.   @brief Utility to draw the detected facial landmark points\n.   \n.   @param image The input image to be processed.\n.   @param points Contains the data of points which will be drawn.\n.   @param color The color of points in BGR format represented by cv::Scalar.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<Rect> faces;\n.   std::vector<std::vector<Point2f> > landmarks;\n.   facemark->getFaces(img, faces);\n.   facemark->fit(img, faces, landmarks);\n.   for(int j=0;j<rects.size();j++){\n.   face::drawFacemarks(frame, landmarks[j], Scalar(0,0,255));\n.   }\n.   @endcode"},
    {"getFacesHAAR", (PyCFunction)pyopencv_cv_face_getFacesHAAR, METH_VARARGS | METH_KEYWORDS, "getFacesHAAR(image, face_cascade_name[, faces]) -> retval, faces\n.   @brief Default face detector\n.   This function is mainly utilized by the implementation of a Facemark Algorithm.\n.   End users are advised to use function Facemark::getFaces which can be manually defined\n.   and circumvented to the algorithm by Facemark::setFaceDetector.\n.   \n.   @param image The input image to be processed.\n.   @param faces Output of the function which represent region of interest of the detected faces.\n.   Each face is stored in cv::Rect container.\n.   @param params detector parameters\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<cv::Rect> faces;\n.   CParams params(\"haarcascade_frontalface_alt.xml\");\n.   cv::face::getFaces(frame, faces, &params);\n.   for(int j=0;j<faces.size();j++){\n.   cv::rectangle(frame, faces[j], cv::Scalar(255,0,255));\n.   }\n.   cv::imshow(\"detection\", frame);\n.   @endcode"},
    {"loadDatasetList", (PyCFunction)pyopencv_cv_face_loadDatasetList, METH_VARARGS | METH_KEYWORDS, "loadDatasetList(imageList, annotationList, images, annotations) -> retval\n.   @brief A utility to load list of paths to training image and annotation file.\n.   @param imageList The specified file contains paths to the training images.\n.   @param annotationList The specified file contains paths to the training annotations.\n.   @param images The loaded paths of training images.\n.   @param annotations The loaded paths of annotation files.\n.   \n.   Example of usage:\n.   @code\n.   String imageFiles = \"images_path.txt\";\n.   String ptsFiles = \"annotations_path.txt\";\n.   std::vector<String> images_train;\n.   std::vector<String> landmarks_train;\n.   loadDatasetList(imageFiles,ptsFiles,images_train,landmarks_train);\n.   @endcode"},
    {"loadFacePoints", (PyCFunction)pyopencv_cv_face_loadFacePoints, METH_VARARGS | METH_KEYWORDS, "loadFacePoints(filename[, points[, offset]]) -> retval, points\n.   @brief A utility to load facial landmark information from a given file.\n.   \n.   @param filename The filename of file contains the facial landmarks data.\n.   @param points The loaded facial landmark points.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   std::vector<Point2f> points;\n.   face::loadFacePoints(\"filename.txt\", points, 0.0f);\n.   @endcode\n.   \n.   The annotation file should follow the default format which is\n.   @code\n.   version: 1\n.   n_points:  68\n.   {\n.   212.716603 499.771793\n.   230.232816 566.290071\n.   ...\n.   }\n.   @endcode\n.   where n_points is the number of points considered\n.   and each point is represented as its position in x and y."},
    {"loadTrainingData", (PyCFunction)pyopencv_cv_face_loadTrainingData, METH_VARARGS | METH_KEYWORDS, "loadTrainingData(filename, images[, facePoints[, delim[, offset]]]) -> retval, facePoints\n.   @brief A utility to load facial landmark dataset from a single file.\n.   \n.   @param filename The filename of a file that contains the dataset information.\n.   Each line contains the filename of an image followed by\n.   pairs of x and y values of facial landmarks points separated by a space.\n.   Example\n.   @code\n.   /home/user/ibug/image_003_1.jpg 336.820955 240.864510 334.238298 260.922709 335.266918 ...\n.   /home/user/ibug/image_005_1.jpg 376.158428 230.845712 376.736984 254.924635 383.265403 ...\n.   @endcode\n.   @param images A vector where each element represent the filename of image in the dataset.\n.   Images are not loaded by default to save the memory.\n.   @param facePoints The loaded landmark points for all training data.\n.   @param delim Delimiter between each element, the default value is a whitespace.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   cv::String imageFiles = \"../data/images_train.txt\";\n.   cv::String ptsFiles = \"../data/points_train.txt\";\n.   std::vector<String> images;\n.   std::vector<std::vector<Point2f> > facePoints;\n.   loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);\n.   @endcode\n\n\n\nloadTrainingData(imageList, groundTruth, images[, facePoints[, offset]]) -> retval, facePoints\n.   @brief A utility to load facial landmark information from the dataset.\n.   \n.   @param imageList A file contains the list of image filenames in the training dataset.\n.   @param groundTruth A file contains the list of filenames\n.   where the landmarks points information are stored.\n.   The content in each file should follow the standard format (see face::loadFacePoints).\n.   @param images A vector where each element represent the filename of image in the dataset.\n.   Images are not loaded by default to save the memory.\n.   @param facePoints The loaded landmark points for all training data.\n.   @param offset An offset value to adjust the loaded points.\n.   \n.   <B>Example of usage</B>\n.   @code\n.   cv::String imageFiles = \"../data/images_train.txt\";\n.   cv::String ptsFiles = \"../data/points_train.txt\";\n.   std::vector<String> images;\n.   std::vector<std::vector<Point2f> > facePoints;\n.   loadTrainingData(imageFiles, ptsFiles, images, facePoints, 0.0f);\n.   @endcode\n.   \n.   example of content in the images_train.txt\n.   @code\n.   /home/user/ibug/image_003_1.jpg\n.   /home/user/ibug/image_004_1.jpg\n.   /home/user/ibug/image_005_1.jpg\n.   /home/user/ibug/image_006.jpg\n.   @endcode\n.   \n.   example of content in the points_train.txt\n.   @code\n.   /home/user/ibug/image_003_1.pts\n.   /home/user/ibug/image_004_1.pts\n.   /home/user/ibug/image_005_1.pts\n.   /home/user/ibug/image_006.pts\n.   @endcode\n\n\n\nloadTrainingData(filename, trainlandmarks, trainimages) -> retval\n.   @brief This function extracts the data for training from .txt files which contains the corresponding image name and landmarks.\n.   *The first file in each file should give the path of the image whose\n.   *landmarks are being described in the file. Then in the subsequent\n.   *lines there should be coordinates of the landmarks in the image\n.   *i.e each line should be of the form x,y\n.   *where x represents the x coordinate of the landmark and y represents\n.   *the y coordinate of the landmark.\n.   *\n.   *For reference you can see the files as provided in the\n.   *<a href=\"http://www.ifp.illinois.edu/~vuongle2/helen/\">HELEN dataset</a>\n.   *\n.   * @param filename A vector of type cv::String containing name of the .txt files.\n.   * @param trainlandmarks A vector of type cv::Point2f that would store shape or landmarks of all images.\n.   * @param trainimages A vector of type cv::String which stores the name of images whose landmarks are tracked\n.   * @returns A boolean value. It returns true when it reads the data successfully and false otherwise"},
    {NULL, NULL}
};

static ConstDef consts_face[] = {
    {NULL, 0}
};

static PyMethodDef methods_fisheye[] = {
    {"calibrate", (PyCFunction)pyopencv_cv_fisheye_calibrate, METH_VARARGS | METH_KEYWORDS, "calibrate(objectPoints, imagePoints, image_size, K, D[, rvecs[, tvecs[, flags[, criteria]]]]) -> retval, K, D, rvecs, tvecs\n.   @brief Performs camera calibaration\n.   \n.   @param objectPoints vector of vectors of calibration pattern points in the calibration pattern\n.   coordinate space.\n.   @param imagePoints vector of vectors of the projections of calibration pattern points.\n.   imagePoints.size() and objectPoints.size() and imagePoints[i].size() must be equal to\n.   objectPoints[i].size() for each i.\n.   @param image_size Size of the image used only to initialize the intrinsic camera matrix.\n.   @param K Output 3x3 floating-point camera matrix\n.   \\f$A = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{1}\\f$ . If\n.   fisheye::CALIB_USE_INTRINSIC_GUESS/ is specified, some or all of fx, fy, cx, cy must be\n.   initialized before calling the function.\n.   @param D Output vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param rvecs Output vector of rotation vectors (see Rodrigues ) estimated for each pattern view.\n.   That is, each k-th rotation vector together with the corresponding k-th translation vector (see\n.   the next output parameter description) brings the calibration pattern from the model coordinate\n.   space (in which object points are specified) to the world coordinate space, that is, a real\n.   position of the calibration pattern in the k-th pattern view (k=0.. *M* -1).\n.   @param tvecs Output vector of translation vectors estimated for each pattern view.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   **fisheye::CALIB_USE_INTRINSIC_GUESS** cameraMatrix contains valid initial values of\n.   fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.   center ( imageSize is used), and focal distances are computed in a least-squares fashion.\n.   -   **fisheye::CALIB_RECOMPUTE_EXTRINSIC** Extrinsic will be recomputed after each iteration\n.   of intrinsic optimization.\n.   -   **fisheye::CALIB_CHECK_COND** The functions will check validity of condition number.\n.   -   **fisheye::CALIB_FIX_SKEW** Skew coefficient (alpha) is set to zero and stay zero.\n.   -   **fisheye::CALIB_FIX_K1..fisheye::CALIB_FIX_K4** Selected distortion coefficients\n.   are set to zeros and stay zero.\n.   -   **fisheye::CALIB_FIX_PRINCIPAL_POINT** The principal point is not changed during the global\n.   optimization. It stays at the center or at a different location specified when CALIB_USE_INTRINSIC_GUESS is set too.\n.   @param criteria Termination criteria for the iterative optimization algorithm."},
    {"distortPoints", (PyCFunction)pyopencv_cv_fisheye_distortPoints, METH_VARARGS | METH_KEYWORDS, "distortPoints(undistorted, K, D[, distorted[, alpha]]) -> distorted\n.   @brief Distorts 2D points using fisheye model.\n.   \n.   @param undistorted Array of object points, 1xN/Nx1 2-channel (or vector\\<Point2f\\> ), where N is\n.   the number of points in the view.\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param alpha The skew coefficient.\n.   @param distorted Output array of image points, 1xN/Nx1 2-channel, or vector\\<Point2f\\> .\n.   \n.   Note that the function assumes the camera matrix of the undistorted points to be identity.\n.   This means if you want to transform back points undistorted with undistortPoints() you have to\n.   multiply them with \\f$P^{-1}\\f$."},
    {"estimateNewCameraMatrixForUndistortRectify", (PyCFunction)pyopencv_cv_fisheye_estimateNewCameraMatrixForUndistortRectify, METH_VARARGS | METH_KEYWORDS, "estimateNewCameraMatrixForUndistortRectify(K, D, image_size, R[, P[, balance[, new_size[, fov_scale]]]]) -> P\n.   @brief Estimates new camera matrix for undistortion or rectification.\n.   \n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param image_size\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.   1-channel or 1x1 3-channel\n.   @param P New camera matrix (3x3) or new projection matrix (3x4)\n.   @param balance Sets the new focal length in range between the min focal length and the max focal\n.   length. Balance is in range of [0, 1].\n.   @param new_size\n.   @param fov_scale Divisor for new focal length."},
    {"initUndistortRectifyMap", (PyCFunction)pyopencv_cv_fisheye_initUndistortRectifyMap, METH_VARARGS | METH_KEYWORDS, "initUndistortRectifyMap(K, D, R, P, size, m1type[, map1[, map2]]) -> map1, map2\n.   @brief Computes undistortion and rectification maps for image transform by cv::remap(). If D is empty zero\n.   distortion is used, if R or P is empty identity matrixes are used.\n.   \n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.   1-channel or 1x1 3-channel\n.   @param P New camera matrix (3x3) or new projection matrix (3x4)\n.   @param size Undistorted image size.\n.   @param m1type Type of the first output map that can be CV_32FC1 or CV_16SC2 . See convertMaps()\n.   for details.\n.   @param map1 The first output map.\n.   @param map2 The second output map."},
    {"projectPoints", (PyCFunction)pyopencv_cv_fisheye_projectPoints, METH_VARARGS | METH_KEYWORDS, "projectPoints(objectPoints, rvec, tvec, K, D[, imagePoints[, alpha[, jacobian]]]) -> imagePoints, jacobian\n.   @overload"},
    {"stereoCalibrate", (PyCFunction)pyopencv_cv_fisheye_stereoCalibrate, METH_VARARGS | METH_KEYWORDS, "stereoCalibrate(objectPoints, imagePoints1, imagePoints2, K1, D1, K2, D2, imageSize[, R[, T[, flags[, criteria]]]]) -> retval, K1, D1, K2, D2, R, T\n.   @brief Performs stereo calibration\n.   \n.   @param objectPoints Vector of vectors of the calibration pattern points.\n.   @param imagePoints1 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the first camera.\n.   @param imagePoints2 Vector of vectors of the projections of the calibration pattern points,\n.   observed by the second camera.\n.   @param K1 Input/output first camera matrix:\n.   \\f$\\vecthreethree{f_x^{(j)}}{0}{c_x^{(j)}}{0}{f_y^{(j)}}{c_y^{(j)}}{0}{0}{1}\\f$ , \\f$j = 0,\\, 1\\f$ . If\n.   any of fisheye::CALIB_USE_INTRINSIC_GUESS , fisheye::CALIB_FIX_INTRINSIC are specified,\n.   some or all of the matrix components must be initialized.\n.   @param D1 Input/output vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$ of 4 elements.\n.   @param K2 Input/output second camera matrix. The parameter is similar to K1 .\n.   @param D2 Input/output lens distortion coefficients for the second camera. The parameter is\n.   similar to D1 .\n.   @param imageSize Size of the image used only to initialize intrinsic camera matrix.\n.   @param R Output rotation matrix between the 1st and the 2nd camera coordinate systems.\n.   @param T Output translation vector between the coordinate systems of the cameras.\n.   @param flags Different flags that may be zero or a combination of the following values:\n.   -   **fisheye::CALIB_FIX_INTRINSIC** Fix K1, K2? and D1, D2? so that only R, T matrices\n.   are estimated.\n.   -   **fisheye::CALIB_USE_INTRINSIC_GUESS** K1, K2 contains valid initial values of\n.   fx, fy, cx, cy that are optimized further. Otherwise, (cx, cy) is initially set to the image\n.   center (imageSize is used), and focal distances are computed in a least-squares fashion.\n.   -   **fisheye::CALIB_RECOMPUTE_EXTRINSIC** Extrinsic will be recomputed after each iteration\n.   of intrinsic optimization.\n.   -   **fisheye::CALIB_CHECK_COND** The functions will check validity of condition number.\n.   -   **fisheye::CALIB_FIX_SKEW** Skew coefficient (alpha) is set to zero and stay zero.\n.   -   **fisheye::CALIB_FIX_K1..4** Selected distortion coefficients are set to zeros and stay\n.   zero.\n.   @param criteria Termination criteria for the iterative optimization algorithm."},
    {"stereoRectify", (PyCFunction)pyopencv_cv_fisheye_stereoRectify, METH_VARARGS | METH_KEYWORDS, "stereoRectify(K1, D1, K2, D2, imageSize, R, tvec, flags[, R1[, R2[, P1[, P2[, Q[, newImageSize[, balance[, fov_scale]]]]]]]]) -> R1, R2, P1, P2, Q\n.   @brief Stereo rectification for fisheye camera model\n.   \n.   @param K1 First camera matrix.\n.   @param D1 First camera distortion parameters.\n.   @param K2 Second camera matrix.\n.   @param D2 Second camera distortion parameters.\n.   @param imageSize Size of the image used for stereo calibration.\n.   @param R Rotation matrix between the coordinate systems of the first and the second\n.   cameras.\n.   @param tvec Translation vector between coordinate systems of the cameras.\n.   @param R1 Output 3x3 rectification transform (rotation matrix) for the first camera.\n.   @param R2 Output 3x3 rectification transform (rotation matrix) for the second camera.\n.   @param P1 Output 3x4 projection matrix in the new (rectified) coordinate systems for the first\n.   camera.\n.   @param P2 Output 3x4 projection matrix in the new (rectified) coordinate systems for the second\n.   camera.\n.   @param Q Output \\f$4 \\times 4\\f$ disparity-to-depth mapping matrix (see reprojectImageTo3D ).\n.   @param flags Operation flags that may be zero or CALIB_ZERO_DISPARITY . If the flag is set,\n.   the function makes the principal points of each camera have the same pixel coordinates in the\n.   rectified views. And if the flag is not set, the function may still shift the images in the\n.   horizontal or vertical direction (depending on the orientation of epipolar lines) to maximize the\n.   useful image area.\n.   @param newImageSize New image resolution after rectification. The same size should be passed to\n.   initUndistortRectifyMap (see the stereo_calib.cpp sample in OpenCV samples directory). When (0,0)\n.   is passed (default), it is set to the original imageSize . Setting it to larger value can help you\n.   preserve details in the original image, especially when there is a big radial distortion.\n.   @param balance Sets the new focal length in range between the min focal length and the max focal\n.   length. Balance is in range of [0, 1].\n.   @param fov_scale Divisor for new focal length."},
    {"undistortImage", (PyCFunction)pyopencv_cv_fisheye_undistortImage, METH_VARARGS | METH_KEYWORDS, "undistortImage(distorted, K, D[, undistorted[, Knew[, new_size]]]) -> undistorted\n.   @brief Transforms an image to compensate for fisheye lens distortion.\n.   \n.   @param distorted image with fisheye lens distortion.\n.   @param undistorted Output image with compensated fisheye lens distortion.\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param Knew Camera matrix of the distorted image. By default, it is the identity matrix but you\n.   may additionally scale and shift the result by using a different matrix.\n.   @param new_size\n.   \n.   The function transforms an image to compensate radial and tangential lens distortion.\n.   \n.   The function is simply a combination of fisheye::initUndistortRectifyMap (with unity R ) and remap\n.   (with bilinear interpolation). See the former function for details of the transformation being\n.   performed.\n.   \n.   See below the results of undistortImage.\n.   -   a\\) result of undistort of perspective camera model (all possible coefficients (k_1, k_2, k_3,\n.   k_4, k_5, k_6) of distortion were optimized under calibration)\n.   -   b\\) result of fisheye::undistortImage of fisheye camera model (all possible coefficients (k_1, k_2,\n.   k_3, k_4) of fisheye distortion were optimized under calibration)\n.   -   c\\) original image was captured with fisheye lens\n.   \n.   Pictures a) and b) almost the same. But if we consider points of image located far from the center\n.   of image, we can notice that on image a) these points are distorted.\n.   \n.   ![image](pics/fisheye_undistorted.jpg)"},
    {"undistortPoints", (PyCFunction)pyopencv_cv_fisheye_undistortPoints, METH_VARARGS | METH_KEYWORDS, "undistortPoints(distorted, K, D[, undistorted[, R[, P]]]) -> undistorted\n.   @brief Undistorts 2D points using fisheye model\n.   \n.   @param distorted Array of object points, 1xN/Nx1 2-channel (or vector\\<Point2f\\> ), where N is the\n.   number of points in the view.\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{0}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, k_3, k_4)\\f$.\n.   @param R Rectification transformation in the object space: 3x3 1-channel, or vector: 3x1/1x3\n.   1-channel or 1x1 3-channel\n.   @param P New camera matrix (3x3) or new projection matrix (3x4)\n.   @param undistorted Output array of image points, 1xN/Nx1 2-channel, or vector\\<Point2f\\> ."},
    {NULL, NULL}
};

static ConstDef consts_fisheye[] = {
    {"CALIB_CHECK_COND", cv::fisheye::CALIB_CHECK_COND},
    {"CALIB_FIX_INTRINSIC", cv::fisheye::CALIB_FIX_INTRINSIC},
    {"CALIB_FIX_K1", cv::fisheye::CALIB_FIX_K1},
    {"CALIB_FIX_K2", cv::fisheye::CALIB_FIX_K2},
    {"CALIB_FIX_K3", cv::fisheye::CALIB_FIX_K3},
    {"CALIB_FIX_K4", cv::fisheye::CALIB_FIX_K4},
    {"CALIB_FIX_PRINCIPAL_POINT", cv::fisheye::CALIB_FIX_PRINCIPAL_POINT},
    {"CALIB_FIX_SKEW", cv::fisheye::CALIB_FIX_SKEW},
    {"CALIB_RECOMPUTE_EXTRINSIC", cv::fisheye::CALIB_RECOMPUTE_EXTRINSIC},
    {"CALIB_USE_INTRINSIC_GUESS", cv::fisheye::CALIB_USE_INTRINSIC_GUESS},
    {NULL, 0}
};

static PyMethodDef methods_flann[] = {
    {NULL, NULL}
};

static ConstDef consts_flann[] = {
    {NULL, 0}
};

static PyMethodDef methods_freetype[] = {
    {"createFreeType2", (PyCFunction)pyopencv_cv_freetype_createFreeType2, METH_VARARGS | METH_KEYWORDS, "createFreeType2() -> retval\n.   @brief Create FreeType2 Instance\n.   \n.   The function createFreeType2 create instance to draw UTF-8 strings."},
    {NULL, NULL}
};

static ConstDef consts_freetype[] = {
    {NULL, 0}
};

static PyMethodDef methods_ft[] = {
    {"FT02D_FL_process", (PyCFunction)pyopencv_cv_ft_FT02D_FL_process, METH_VARARGS | METH_KEYWORDS, "FT02D_FL_process(matrix, radius[, output]) -> output\n.   @brief Sligtly less accurate version of \\f$F^0\\f$-transfrom computation optimized for higher speed. The methods counts with linear basic function.\n.   @param matrix Input 3 channels matrix.\n.   @param radius Radius of the `ft::LINEAR` basic function.\n.   @param output Output array.\n.   \n.   This function computes F-transfrom and inverse F-transfotm using linear basic function in one step. It is ~10 times faster than `ft::FT02D_process` method."},
    {"FT02D_FL_process_float", (PyCFunction)pyopencv_cv_ft_FT02D_FL_process_float, METH_VARARGS | METH_KEYWORDS, "FT02D_FL_process_float(matrix, radius[, output]) -> output\n.   @brief Sligtly less accurate version of \\f$F^0\\f$-transfrom computation optimized for higher speed. The methods counts with linear basic function.\n.   @param matrix Input 3 channels matrix.\n.   @param radius Radius of the `ft::LINEAR` basic function.\n.   @param output Output array.\n.   \n.   This function computes F-transfrom and inverse F-transfotm using linear basic function in one step. It is ~9 times faster then `ft::FT02D_process` method and more accurate than `ft::FT02D_FL_process` method."},
    {"FT02D_components", (PyCFunction)pyopencv_cv_ft_FT02D_components, METH_VARARGS | METH_KEYWORDS, "FT02D_components(matrix, kernel[, components[, mask]]) -> components\n.   @brief Computes components of the array using direct \\f$F^0\\f$-transform.\n.   @param matrix Input array.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param components Output 32-bit float array for the components.\n.   @param mask Mask can be used for unwanted area marking.\n.   \n.   The function computes components using predefined kernel and mask."},
    {"FT02D_inverseFT", (PyCFunction)pyopencv_cv_ft_FT02D_inverseFT, METH_VARARGS | METH_KEYWORDS, "FT02D_inverseFT(components, kernel, width, height[, output]) -> output\n.   @brief Computes inverse \\f$F^0\\f$-transfrom.\n.   @param components Input 32-bit float single channel array for the components.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param output Output 32-bit float array.\n.   @param width Width of the output array.\n.   @param height Height of the output array.\n.   \n.   Computation of inverse F-transform."},
    {"FT02D_iteration", (PyCFunction)pyopencv_cv_ft_FT02D_iteration, METH_VARARGS | METH_KEYWORDS, "FT02D_iteration(matrix, kernel, mask, firstStop[, output[, maskOutput]]) -> retval, output, maskOutput\n.   @brief Computes \\f$F^0\\f$-transfrom and inverse \\f$F^0\\f$-transfrom at once and return state.\n.   @param matrix Input matrix.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param output Output 32-bit float array.\n.   @param mask Mask used for unwanted area marking.\n.   @param maskOutput Mask after one iteration.\n.   @param firstStop If **true** function returns -1 when first problem appears. In case of `false` the process is completed and summation of all problems returned.\n.   \n.   This function computes iteration of F-transfrom and inverse F-transfotm and handle image and mask change. The function is used in `ft::inpaint` function."},
    {"FT02D_process", (PyCFunction)pyopencv_cv_ft_FT02D_process, METH_VARARGS | METH_KEYWORDS, "FT02D_process(matrix, kernel[, output[, mask]]) -> output\n.   @brief Computes \\f$F^0\\f$-transfrom and inverse \\f$F^0\\f$-transfrom at once.\n.   @param matrix Input matrix.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param output Output 32-bit float array.\n.   @param mask Mask used for unwanted area marking.\n.   \n.   This function computes F-transfrom and inverse F-transfotm in one step. It is fully sufficient and optimized for `cv::Mat`."},
    {"FT12D_components", (PyCFunction)pyopencv_cv_ft_FT12D_components, METH_VARARGS | METH_KEYWORDS, "FT12D_components(matrix, kernel[, components]) -> components\n.   @brief Computes components of the array using direct \\f$F^1\\f$-transform.\n.   @param matrix Input array.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param components Output 32-bit float array for the components.\n.   \n.   The function computes linear components using predefined kernel."},
    {"FT12D_createPolynomMatrixHorizontal", (PyCFunction)pyopencv_cv_ft_FT12D_createPolynomMatrixHorizontal, METH_VARARGS | METH_KEYWORDS, "FT12D_createPolynomMatrixHorizontal(radius, chn[, matrix]) -> matrix\n.   @brief Creates horizontal matrix for \\f$F^1\\f$-transform computation.\n.   @param radius Radius of the basic function.\n.   @param matrix The horizontal matrix.\n.   @param chn Number of channels.\n.   \n.   The function creates helper horizontal matrix for \\f$F^1\\f$-transfrom processing. It is used for gradient computation."},
    {"FT12D_createPolynomMatrixVertical", (PyCFunction)pyopencv_cv_ft_FT12D_createPolynomMatrixVertical, METH_VARARGS | METH_KEYWORDS, "FT12D_createPolynomMatrixVertical(radius, chn[, matrix]) -> matrix\n.   @brief Creates vertical matrix for \\f$F^1\\f$-transform computation.\n.   @param radius Radius of the basic function.\n.   @param matrix The vertical matrix.\n.   @param chn Number of channels.\n.   \n.   The function creates helper vertical matrix for \\f$F^1\\f$-transfrom processing. It is used for gradient computation."},
    {"FT12D_inverseFT", (PyCFunction)pyopencv_cv_ft_FT12D_inverseFT, METH_VARARGS | METH_KEYWORDS, "FT12D_inverseFT(components, kernel, width, height[, output]) -> output\n.   @brief Computes inverse \\f$F^1\\f$-transfrom.\n.   @param components Input 32-bit float single channel array for the components.\n.   @param kernel Kernel used for processing. The same kernel as for components computation must be used.\n.   @param output Output 32-bit float array.\n.   @param width Width of the output array.\n.   @param height Height of the output array.\n.   \n.   Computation of inverse \\f$F^1\\f$-transform."},
    {"FT12D_polynomial", (PyCFunction)pyopencv_cv_ft_FT12D_polynomial, METH_VARARGS | METH_KEYWORDS, "FT12D_polynomial(matrix, kernel[, c00[, c10[, c01[, components[, mask]]]]]) -> c00, c10, c01, components\n.   @brief Computes elements of \\f$F^1\\f$-transform components.\n.   @param matrix Input array.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param c00 Elements represent average color.\n.   @param c10 Elements represent average vertical gradient.\n.   @param c01 Elements represent average horizontal gradient.\n.   @param components Output 32-bit float array for the components.\n.   @param mask Mask can be used for unwanted area marking.\n.   \n.   The function computes components and its elements using predefined kernel and mask."},
    {"FT12D_process", (PyCFunction)pyopencv_cv_ft_FT12D_process, METH_VARARGS | METH_KEYWORDS, "FT12D_process(matrix, kernel[, output[, mask]]) -> output\n.   @brief Computes \\f$F^1\\f$-transfrom and inverse \\f$F^1\\f$-transfrom at once.\n.   @param matrix Input matrix.\n.   @param kernel Kernel used for processing. Function `ft::createKernel` can be used.\n.   @param output Output 32-bit float array.\n.   @param mask Mask used for unwanted area marking.\n.   \n.   This function computes \\f$F^1\\f$-transfrom and inverse \\f$F^1\\f$-transfotm in one step. It is fully sufficient and optimized for `cv::Mat`.\n.   \n.   @note\n.   F-transform technique of first degreee is described in paper @cite Vlas:FT."},
    {"createKernel", (PyCFunction)pyopencv_cv_ft_createKernel, METH_VARARGS | METH_KEYWORDS, "createKernel(function, radius, chn[, kernel]) -> kernel\n.   @brief Creates kernel from general functions.\n.   @param function Function type could be one of the following:\n.   -   **LINEAR** Linear basic function.\n.   @param radius Radius of the basic function.\n.   @param kernel Final 32-bit kernel.\n.   @param chn Number of kernel channels.\n.   \n.   The function creates kernel from predefined functions."},
    {"createKernel1", (PyCFunction)pyopencv_cv_ft_createKernel1, METH_VARARGS | METH_KEYWORDS, "createKernel1(A, B, chn[, kernel]) -> kernel\n.   @brief Creates kernel from basic functions.\n.   @param A Basic function used in axis **x**.\n.   @param B Basic function used in axis **y**.\n.   @param kernel Final 32-bit kernel derived from **A** and **B**.\n.   @param chn Number of kernel channels.\n.   \n.   The function creates kernel usable for latter fuzzy image processing."},
    {"filter", (PyCFunction)pyopencv_cv_ft_filter, METH_VARARGS | METH_KEYWORDS, "filter(image, kernel[, output]) -> output\n.   @brief Image filtering\n.   @param image Input image.\n.   @param kernel Final 32-bit kernel.\n.   @param output Output 32-bit image.\n.   \n.   Filtering of the input image by means of F-transform."},
    {"inpaint", (PyCFunction)pyopencv_cv_ft_inpaint, METH_VARARGS | METH_KEYWORDS, "inpaint(image, mask, radius, function, algorithm[, output]) -> output\n.   @brief Image inpainting\n.   @param image Input image.\n.   @param mask Mask used for unwanted area marking.\n.   @param output Output 32-bit image.\n.   @param radius Radius of the basic function.\n.   @param function Function type could be one of the following:\n.   -   `ft::LINEAR` Linear basic function.\n.   @param algorithm Algorithm could be one of the following:\n.   -   `ft::ONE_STEP` One step algorithm.\n.   -   `ft::MULTI_STEP` This algorithm automaticaly increases radius of the basic function.\n.   -   `ft::ITERATIVE` Iterative algorithm running in more steps using partial computations.\n.   \n.   This function provides inpainting technique based on the fuzzy mathematic.\n.   \n.   @note\n.   The algorithms are described in paper @cite Perf:rec."},
    {NULL, NULL}
};

static ConstDef consts_ft[] = {
    {"ITERATIVE", cv::ft::ITERATIVE},
    {"LINEAR", cv::ft::LINEAR},
    {"MULTI_STEP", cv::ft::MULTI_STEP},
    {"ONE_STEP", cv::ft::ONE_STEP},
    {"SINUS", cv::ft::SINUS},
    {NULL, 0}
};

static PyMethodDef methods_hdf[] = {
    {"open", (PyCFunction)pyopencv_cv_hdf_open, METH_VARARGS | METH_KEYWORDS, "open(HDF5Filename) -> retval\n.   @brief Open or create hdf5 file\n.   @param HDF5Filename specify the HDF5 filename.\n.   \n.   Returns a pointer to the hdf5 object class\n.   \n.   @note If the specified file does not exist, it will be created using default properties.\n.   Otherwise, it is opened in read and write mode with default access properties.\n.   Any operations except dscreate() functions on object\n.   will be thread safe. Multiple datasets can be created inside a single hdf5 file, and can be accessed\n.   from the same hdf5 object from multiple instances as long read or write operations are done over\n.   non-overlapping regions of dataset. Single hdf5 file also can be opened by multiple instances,\n.   reads and writes can be instantiated at the same time as long as non-overlapping regions are involved. Object\n.   is released using close().\n.   \n.   - Example below opens and then releases the file.\n.   @code{.cpp}\n.   // open / auto create hdf5 file\n.   cv::Ptr<cv::hdf::HDF5> h5io = cv::hdf::open( \"mytest.h5\" );\n.   // ...\n.   // release\n.   h5io->close();\n.   @endcode\n.   \n.   ![Visualization of 10x10 CV_64FC2 (Hilbert matrix) using HDFView tool](pics/hdfview_demo.gif)\n.   \n.   - Text dump (3x3 Hilbert matrix) of hdf5 dataset using **h5dump** tool:\n.   @code{.txt}\n.   $ h5dump test.h5\n.   HDF5 \"test.h5\" {\n.   GROUP \"/\" {\n.   DATASET \"hilbert\" {\n.   DATATYPE  H5T_ARRAY { [2] H5T_IEEE_F64LE }\n.   DATASPACE  SIMPLE { ( 3, 3 ) / ( 3, 3 ) }\n.   DATA {\n.   (0,0): [ 1, -1 ], [ 0.5, -0.5 ], [ 0.333333, -0.333333 ],\n.   (1,0): [ 0.5, -0.5 ], [ 0.333333, -0.333333 ], [ 0.25, -0.25 ],\n.   (2,0): [ 0.333333, -0.333333 ], [ 0.25, -0.25 ], [ 0.2, -0.2 ]\n.   }\n.   }\n.   }\n.   }\n.   @endcode"},
    {NULL, NULL}
};

static ConstDef consts_hdf[] = {
    {NULL, 0}
};

static PyMethodDef methods_hfs[] = {
    {"HfsSegment_create", (PyCFunction)pyopencv_cv_hfs_HfsSegment_create, METH_VARARGS | METH_KEYWORDS, "HfsSegment_create(height, width[, segEgbThresholdI[, minRegionSizeI[, segEgbThresholdII[, minRegionSizeII[, spatialWeight[, slicSpixelSize[, numSlicIter]]]]]]]) -> retval\n.   @brief: create a hfs object\n.   * @param height: the height of the input image\n.   * @param width: the width of the input image\n.   * @param segEgbThresholdI: parameter segEgbThresholdI\n.   * @param minRegionSizeI: parameter minRegionSizeI\n.   * @param segEgbThresholdII: parameter segEgbThresholdII\n.   * @param minRegionSizeII: parameter minRegionSizeII\n.   * @param spatialWeight: parameter spatialWeight\n.   * @param slicSpixelSize: parameter slicSpixelSize\n.   * @param numSlicIter: parameter numSlicIter"},
    {NULL, NULL}
};

static ConstDef consts_hfs[] = {
    {NULL, 0}
};

static PyMethodDef methods_img_hash[] = {
    {"AverageHash_create", (PyCFunction)pyopencv_cv_img_hash_AverageHash_create, METH_VARARGS | METH_KEYWORDS, "AverageHash_create() -> retval\n."},
    {"BlockMeanHash_create", (PyCFunction)pyopencv_cv_img_hash_BlockMeanHash_create, METH_VARARGS | METH_KEYWORDS, "BlockMeanHash_create([, mode]) -> retval\n."},
    {"ColorMomentHash_create", (PyCFunction)pyopencv_cv_img_hash_ColorMomentHash_create, METH_VARARGS | METH_KEYWORDS, "ColorMomentHash_create() -> retval\n."},
    {"MarrHildrethHash_create", (PyCFunction)pyopencv_cv_img_hash_MarrHildrethHash_create, METH_VARARGS | METH_KEYWORDS, "MarrHildrethHash_create([, alpha[, scale]]) -> retval\n.   @param alpha int scale factor for marr wavelet (default=2).\n.   @param scale int level of scale factor (default = 1)"},
    {"PHash_create", (PyCFunction)pyopencv_cv_img_hash_PHash_create, METH_VARARGS | METH_KEYWORDS, "PHash_create() -> retval\n."},
    {"RadialVarianceHash_create", (PyCFunction)pyopencv_cv_img_hash_RadialVarianceHash_create, METH_VARARGS | METH_KEYWORDS, "RadialVarianceHash_create([, sigma[, numOfAngleLine]]) -> retval\n."},
    {"averageHash", (PyCFunction)pyopencv_cv_img_hash_averageHash, METH_VARARGS | METH_KEYWORDS, "averageHash(inputArr[, outputArr]) -> outputArr\n.   @brief Calculates img_hash::AverageHash in one call\n.   @param inputArr input image want to compute hash value, type should be CV_8UC4, CV_8UC3 or CV_8UC1.\n.   @param outputArr Hash value of input, it will contain 16 hex decimal number, return type is CV_8U"},
    {"blockMeanHash", (PyCFunction)pyopencv_cv_img_hash_blockMeanHash, METH_VARARGS | METH_KEYWORDS, "blockMeanHash(inputArr[, outputArr[, mode]]) -> outputArr\n.   @brief Computes block mean hash of the input image\n.   @param inputArr input image want to compute hash value, type should be CV_8UC4, CV_8UC3 or CV_8UC1.\n.   @param outputArr Hash value of input, it will contain 16 hex decimal number, return type is CV_8U\n.   @param mode"},
    {"colorMomentHash", (PyCFunction)pyopencv_cv_img_hash_colorMomentHash, METH_VARARGS | METH_KEYWORDS, "colorMomentHash(inputArr[, outputArr]) -> outputArr\n.   @brief Computes color moment hash of the input, the algorithm\n.   is come from the paper \"Perceptual  Hashing  for  Color  Images\n.   Using  Invariant Moments\"\n.   @param inputArr input image want to compute hash value,\n.   type should be CV_8UC4, CV_8UC3 or CV_8UC1.\n.   @param outputArr 42 hash values with type CV_64F(double)"},
    {"marrHildrethHash", (PyCFunction)pyopencv_cv_img_hash_marrHildrethHash, METH_VARARGS | METH_KEYWORDS, "marrHildrethHash(inputArr[, outputArr[, alpha[, scale]]]) -> outputArr\n.   @brief Computes average hash value of the input image\n.   @param inputArr input image want to compute hash value,\n.   type should be CV_8UC4, CV_8UC3, CV_8UC1.\n.   @param outputArr Hash value of input, it will contain 16 hex\n.   decimal number, return type is CV_8U\n.   @param alpha int scale factor for marr wavelet (default=2).\n.   @param scale int level of scale factor (default = 1)"},
    {"pHash", (PyCFunction)pyopencv_cv_img_hash_pHash, METH_VARARGS | METH_KEYWORDS, "pHash(inputArr[, outputArr]) -> outputArr\n.   @brief Computes pHash value of the input image\n.   @param inputArr input image want to compute hash value,\n.   type should be CV_8UC4, CV_8UC3, CV_8UC1.\n.   @param outputArr Hash value of input, it will contain 8 uchar value"},
    {"radialVarianceHash", (PyCFunction)pyopencv_cv_img_hash_radialVarianceHash, METH_VARARGS | METH_KEYWORDS, "radialVarianceHash(inputArr[, outputArr[, sigma[, numOfAngleLine]]]) -> outputArr\n.   @brief Computes radial variance hash of the input image\n.   @param inputArr input image want to compute hash value,\n.   type should be CV_8UC4, CV_8UC3, CV_8UC1.\n.   @param outputArr Hash value of input\n.   @param sigma Gaussian kernel standard deviation\n.   @param numOfAngleLine The number of angles to consider"},
    {NULL, NULL}
};

static ConstDef consts_img_hash[] = {
    {"BLOCK_MEAN_HASH_MODE_0", cv::img_hash::BLOCK_MEAN_HASH_MODE_0},
    {"BLOCK_MEAN_HASH_MODE_1", cv::img_hash::BLOCK_MEAN_HASH_MODE_1},
    {NULL, 0}
};

static PyMethodDef methods_instr[] = {
    {NULL, NULL}
};

static ConstDef consts_instr[] = {
    {"FLAGS_EXPAND_SAME_NAMES", cv::instr::FLAGS_EXPAND_SAME_NAMES},
    {"FLAGS_MAPPING", cv::instr::FLAGS_MAPPING},
    {"FLAGS_NONE", cv::instr::FLAGS_NONE},
    {"IMPL_IPP", cv::instr::IMPL_IPP},
    {"IMPL_OPENCL", cv::instr::IMPL_OPENCL},
    {"IMPL_PLAIN", cv::instr::IMPL_PLAIN},
    {"TYPE_FUN", cv::instr::TYPE_FUN},
    {"TYPE_GENERAL", cv::instr::TYPE_GENERAL},
    {"TYPE_MARKER", cv::instr::TYPE_MARKER},
    {"TYPE_WRAPPER", cv::instr::TYPE_WRAPPER},
    {NULL, 0}
};

static PyMethodDef methods_ipp[] = {
    {"getIppVersion", (PyCFunction)pyopencv_cv_ipp_getIppVersion, METH_VARARGS | METH_KEYWORDS, "getIppVersion() -> retval\n."},
    {"setUseIPP", (PyCFunction)pyopencv_cv_ipp_setUseIPP, METH_VARARGS | METH_KEYWORDS, "setUseIPP(flag) -> None\n."},
    {"setUseIPP_NE", (PyCFunction)pyopencv_cv_ipp_setUseIPP_NE, METH_VARARGS | METH_KEYWORDS, "setUseIPP_NE(flag) -> None\n."},
    {"useIPP", (PyCFunction)pyopencv_cv_ipp_useIPP, METH_VARARGS | METH_KEYWORDS, "useIPP() -> retval\n.   proxy for hal::Cholesky"},
    {"useIPP_NE", (PyCFunction)pyopencv_cv_ipp_useIPP_NE, METH_VARARGS | METH_KEYWORDS, "useIPP_NE() -> retval\n."},
    {NULL, NULL}
};

static ConstDef consts_ipp[] = {
    {NULL, 0}
};

static PyMethodDef methods_line_descriptor[] = {
    {NULL, NULL}
};

static ConstDef consts_line_descriptor[] = {
    {"DrawLinesMatchesFlags_DEFAULT", cv::line_descriptor::DrawLinesMatchesFlags::DEFAULT},
    {"DRAW_LINES_MATCHES_FLAGS_DEFAULT", cv::line_descriptor::DrawLinesMatchesFlags::DEFAULT},
    {"DrawLinesMatchesFlags_DRAW_OVER_OUTIMG", cv::line_descriptor::DrawLinesMatchesFlags::DRAW_OVER_OUTIMG},
    {"DRAW_LINES_MATCHES_FLAGS_DRAW_OVER_OUTIMG", cv::line_descriptor::DrawLinesMatchesFlags::DRAW_OVER_OUTIMG},
    {"DrawLinesMatchesFlags_NOT_DRAW_SINGLE_LINES", cv::line_descriptor::DrawLinesMatchesFlags::NOT_DRAW_SINGLE_LINES},
    {"DRAW_LINES_MATCHES_FLAGS_NOT_DRAW_SINGLE_LINES", cv::line_descriptor::DrawLinesMatchesFlags::NOT_DRAW_SINGLE_LINES},
    {NULL, 0}
};

static PyMethodDef methods_linemod[] = {
    {"Modality_create", (PyCFunction)pyopencv_cv_linemod_Modality_create, METH_VARARGS | METH_KEYWORDS, "Modality_create(modality_type) -> retval\n.   * \\brief Create modality by name.\n.   *\n.   * The following modality types are supported:\n.   * - \"ColorGradient\"\n.   * - \"DepthNormal\"\n\n\n\nModality_create(fn) -> retval\n.   * \\brief Load a modality from file."},
    {"colormap", (PyCFunction)pyopencv_cv_linemod_colormap, METH_VARARGS | METH_KEYWORDS, "colormap(quantized[, dst]) -> dst\n.   * \\brief Debug function to colormap a quantized image for viewing."},
    {"getDefaultLINE", (PyCFunction)pyopencv_cv_linemod_getDefaultLINE, METH_VARARGS | METH_KEYWORDS, "getDefaultLINE() -> retval\n.   * \\brief Factory function for detector using LINE algorithm with color gradients.\n.   *\n.   * Default parameter settings suitable for VGA images."},
    {"getDefaultLINEMOD", (PyCFunction)pyopencv_cv_linemod_getDefaultLINEMOD, METH_VARARGS | METH_KEYWORDS, "getDefaultLINEMOD() -> retval\n.   * \\brief Factory function for detector using LINE-MOD algorithm with color gradients\n.   * and depth normals.\n.   *\n.   * Default parameter settings suitable for VGA images."},
    {NULL, NULL}
};

static ConstDef consts_linemod[] = {
    {NULL, 0}
};

static PyMethodDef methods_ml[] = {
    {"ANN_MLP_create", (PyCFunction)pyopencv_cv_ml_ANN_MLP_create, METH_VARARGS | METH_KEYWORDS, "ANN_MLP_create() -> retval\n.   @brief Creates empty model\n.   \n.   Use StatModel::train to train the model, Algorithm::load\\<ANN_MLP\\>(filename) to load the pre-trained model.\n.   Note that the train method has optional flags: ANN_MLP::TrainFlags."},
    {"ANN_MLP_load", (PyCFunction)pyopencv_cv_ml_ANN_MLP_load, METH_VARARGS | METH_KEYWORDS, "ANN_MLP_load(filepath) -> retval\n.   @brief Loads and creates a serialized ANN from a file\n.   *\n.   * Use ANN::save to serialize and store an ANN to disk.\n.   * Load the ANN from this file again, by calling this function with the path to the file.\n.   *\n.   * @param filepath path to serialized ANN"},
    {"Boost_create", (PyCFunction)pyopencv_cv_ml_Boost_create, METH_VARARGS | METH_KEYWORDS, "Boost_create() -> retval\n.   Creates the empty model.\n.   Use StatModel::train to train the model, Algorithm::load\\<Boost\\>(filename) to load the pre-trained model."},
    {"Boost_load", (PyCFunction)pyopencv_cv_ml_Boost_load, METH_VARARGS | METH_KEYWORDS, "Boost_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized Boost from a file\n.   *\n.   * Use Boost::save to serialize and store an RTree to disk.\n.   * Load the Boost from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized Boost\n.   * @param nodeName name of node containing the classifier"},
    {"DTrees_create", (PyCFunction)pyopencv_cv_ml_DTrees_create, METH_VARARGS | METH_KEYWORDS, "DTrees_create() -> retval\n.   @brief Creates the empty model\n.   \n.   The static method creates empty decision tree with the specified parameters. It should be then\n.   trained using train method (see StatModel::train). Alternatively, you can load the model from\n.   file using Algorithm::load\\<DTrees\\>(filename)."},
    {"DTrees_load", (PyCFunction)pyopencv_cv_ml_DTrees_load, METH_VARARGS | METH_KEYWORDS, "DTrees_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized DTrees from a file\n.   *\n.   * Use DTree::save to serialize and store an DTree to disk.\n.   * Load the DTree from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized DTree\n.   * @param nodeName name of node containing the classifier"},
    {"EM_create", (PyCFunction)pyopencv_cv_ml_EM_create, METH_VARARGS | METH_KEYWORDS, "EM_create() -> retval\n.   Creates empty %EM model.\n.   The model should be trained then using StatModel::train(traindata, flags) method. Alternatively, you\n.   can use one of the EM::train\\* methods or load it from file using Algorithm::load\\<EM\\>(filename)."},
    {"EM_load", (PyCFunction)pyopencv_cv_ml_EM_load, METH_VARARGS | METH_KEYWORDS, "EM_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized EM from a file\n.   *\n.   * Use EM::save to serialize and store an EM to disk.\n.   * Load the EM from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized EM\n.   * @param nodeName name of node containing the classifier"},
    {"KNearest_create", (PyCFunction)pyopencv_cv_ml_KNearest_create, METH_VARARGS | METH_KEYWORDS, "KNearest_create() -> retval\n.   @brief Creates the empty model\n.   \n.   The static method creates empty %KNearest classifier. It should be then trained using StatModel::train method."},
    {"LogisticRegression_create", (PyCFunction)pyopencv_cv_ml_LogisticRegression_create, METH_VARARGS | METH_KEYWORDS, "LogisticRegression_create() -> retval\n.   @brief Creates empty model.\n.   \n.   Creates Logistic Regression model with parameters given."},
    {"LogisticRegression_load", (PyCFunction)pyopencv_cv_ml_LogisticRegression_load, METH_VARARGS | METH_KEYWORDS, "LogisticRegression_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized LogisticRegression from a file\n.   *\n.   * Use LogisticRegression::save to serialize and store an LogisticRegression to disk.\n.   * Load the LogisticRegression from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized LogisticRegression\n.   * @param nodeName name of node containing the classifier"},
    {"NormalBayesClassifier_create", (PyCFunction)pyopencv_cv_ml_NormalBayesClassifier_create, METH_VARARGS | METH_KEYWORDS, "NormalBayesClassifier_create() -> retval\n.   Creates empty model\n.   Use StatModel::train to train the model after creation."},
    {"NormalBayesClassifier_load", (PyCFunction)pyopencv_cv_ml_NormalBayesClassifier_load, METH_VARARGS | METH_KEYWORDS, "NormalBayesClassifier_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized NormalBayesClassifier from a file\n.   *\n.   * Use NormalBayesClassifier::save to serialize and store an NormalBayesClassifier to disk.\n.   * Load the NormalBayesClassifier from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized NormalBayesClassifier\n.   * @param nodeName name of node containing the classifier"},
    {"ParamGrid_create", (PyCFunction)pyopencv_cv_ml_ParamGrid_create, METH_VARARGS | METH_KEYWORDS, "ParamGrid_create([, minVal[, maxVal[, logstep]]]) -> retval\n.   @brief Creates a ParamGrid Ptr that can be given to the %SVM::trainAuto method\n.   \n.   @param minVal minimum value of the parameter grid\n.   @param maxVal maximum value of the parameter grid\n.   @param logstep Logarithmic step for iterating the statmodel parameter"},
    {"RTrees_create", (PyCFunction)pyopencv_cv_ml_RTrees_create, METH_VARARGS | METH_KEYWORDS, "RTrees_create() -> retval\n.   Creates the empty model.\n.   Use StatModel::train to train the model, StatModel::train to create and train the model,\n.   Algorithm::load to load the pre-trained model."},
    {"RTrees_load", (PyCFunction)pyopencv_cv_ml_RTrees_load, METH_VARARGS | METH_KEYWORDS, "RTrees_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized RTree from a file\n.   *\n.   * Use RTree::save to serialize and store an RTree to disk.\n.   * Load the RTree from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized RTree\n.   * @param nodeName name of node containing the classifier"},
    {"SVMSGD_create", (PyCFunction)pyopencv_cv_ml_SVMSGD_create, METH_VARARGS | METH_KEYWORDS, "SVMSGD_create() -> retval\n.   @brief Creates empty model.\n.   * Use StatModel::train to train the model. Since %SVMSGD has several parameters, you may want to\n.   * find the best parameters for your problem or use setOptimalParameters() to set some default parameters."},
    {"SVMSGD_load", (PyCFunction)pyopencv_cv_ml_SVMSGD_load, METH_VARARGS | METH_KEYWORDS, "SVMSGD_load(filepath[, nodeName]) -> retval\n.   @brief Loads and creates a serialized SVMSGD from a file\n.   *\n.   * Use SVMSGD::save to serialize and store an SVMSGD to disk.\n.   * Load the SVMSGD from this file again, by calling this function with the path to the file.\n.   * Optionally specify the node for the file containing the classifier\n.   *\n.   * @param filepath path to serialized SVMSGD\n.   * @param nodeName name of node containing the classifier"},
    {"SVM_create", (PyCFunction)pyopencv_cv_ml_SVM_create, METH_VARARGS | METH_KEYWORDS, "SVM_create() -> retval\n.   Creates empty model.\n.   Use StatModel::train to train the model. Since %SVM has several parameters, you may want to\n.   find the best parameters for your problem, it can be done with SVM::trainAuto."},
    {"SVM_getDefaultGridPtr", (PyCFunction)pyopencv_cv_ml_SVM_getDefaultGridPtr, METH_VARARGS | METH_KEYWORDS, "SVM_getDefaultGridPtr(param_id) -> retval\n.   @brief Generates a grid for %SVM parameters.\n.   \n.   @param param_id %SVM parameters IDs that must be one of the SVM::ParamTypes. The grid is\n.   generated for the parameter with this ID.\n.   \n.   The function generates a grid pointer for the specified parameter of the %SVM algorithm.\n.   The grid may be passed to the function SVM::trainAuto."},
    {"SVM_load", (PyCFunction)pyopencv_cv_ml_SVM_load, METH_VARARGS | METH_KEYWORDS, "SVM_load(filepath) -> retval\n.   @brief Loads and creates a serialized svm from a file\n.   *\n.   * Use SVM::save to serialize and store an SVM to disk.\n.   * Load the SVM from this file again, by calling this function with the path to the file.\n.   *\n.   * @param filepath path to serialized svm"},
    {"TrainData_create", (PyCFunction)pyopencv_cv_ml_TrainData_create, METH_VARARGS | METH_KEYWORDS, "TrainData_create(samples, layout, responses[, varIdx[, sampleIdx[, sampleWeights[, varType]]]]) -> retval\n.   @brief Creates training data from in-memory arrays.\n.   \n.   @param samples matrix of samples. It should have CV_32F type.\n.   @param layout see ml::SampleTypes.\n.   @param responses matrix of responses. If the responses are scalar, they should be stored as a\n.   single row or as a single column. The matrix should have type CV_32F or CV_32S (in the\n.   former case the responses are considered as ordered by default; in the latter case - as\n.   categorical)\n.   @param varIdx vector specifying which variables to use for training. It can be an integer vector\n.   (CV_32S) containing 0-based variable indices or byte vector (CV_8U) containing a mask of\n.   active variables.\n.   @param sampleIdx vector specifying which samples to use for training. It can be an integer\n.   vector (CV_32S) containing 0-based sample indices or byte vector (CV_8U) containing a mask\n.   of training samples.\n.   @param sampleWeights optional vector with weights for each sample. It should have CV_32F type.\n.   @param varType optional vector of type CV_8U and size `<number_of_variables_in_samples> +\n.   <number_of_variables_in_responses>`, containing types of each input and output variable. See\n.   ml::VariableTypes."},
    {"TrainData_getSubVector", (PyCFunction)pyopencv_cv_ml_TrainData_getSubVector, METH_VARARGS | METH_KEYWORDS, "TrainData_getSubVector(vec, idx) -> retval\n."},
    {NULL, NULL}
};

static ConstDef consts_ml[] = {
    {"ANN_MLP_ANNEAL", cv::ml::ANN_MLP::ANNEAL},
    {"ANN_MLP_BACKPROP", cv::ml::ANN_MLP::BACKPROP},
    {"ANN_MLP_GAUSSIAN", cv::ml::ANN_MLP::GAUSSIAN},
    {"ANN_MLP_IDENTITY", cv::ml::ANN_MLP::IDENTITY},
    {"ANN_MLP_LEAKYRELU", cv::ml::ANN_MLP::LEAKYRELU},
    {"ANN_MLP_NO_INPUT_SCALE", cv::ml::ANN_MLP::NO_INPUT_SCALE},
    {"ANN_MLP_NO_OUTPUT_SCALE", cv::ml::ANN_MLP::NO_OUTPUT_SCALE},
    {"ANN_MLP_RELU", cv::ml::ANN_MLP::RELU},
    {"ANN_MLP_RPROP", cv::ml::ANN_MLP::RPROP},
    {"ANN_MLP_SIGMOID_SYM", cv::ml::ANN_MLP::SIGMOID_SYM},
    {"ANN_MLP_UPDATE_WEIGHTS", cv::ml::ANN_MLP::UPDATE_WEIGHTS},
    {"Boost_DISCRETE", cv::ml::Boost::DISCRETE},
    {"BOOST_DISCRETE", cv::ml::Boost::DISCRETE},
    {"Boost_GENTLE", cv::ml::Boost::GENTLE},
    {"BOOST_GENTLE", cv::ml::Boost::GENTLE},
    {"Boost_LOGIT", cv::ml::Boost::LOGIT},
    {"BOOST_LOGIT", cv::ml::Boost::LOGIT},
    {"Boost_REAL", cv::ml::Boost::REAL},
    {"BOOST_REAL", cv::ml::Boost::REAL},
    {"COL_SAMPLE", cv::ml::COL_SAMPLE},
    {"DTrees_PREDICT_AUTO", cv::ml::DTrees::PREDICT_AUTO},
    {"DTREES_PREDICT_AUTO", cv::ml::DTrees::PREDICT_AUTO},
    {"DTrees_PREDICT_MASK", cv::ml::DTrees::PREDICT_MASK},
    {"DTREES_PREDICT_MASK", cv::ml::DTrees::PREDICT_MASK},
    {"DTrees_PREDICT_MAX_VOTE", cv::ml::DTrees::PREDICT_MAX_VOTE},
    {"DTREES_PREDICT_MAX_VOTE", cv::ml::DTrees::PREDICT_MAX_VOTE},
    {"DTrees_PREDICT_SUM", cv::ml::DTrees::PREDICT_SUM},
    {"DTREES_PREDICT_SUM", cv::ml::DTrees::PREDICT_SUM},
    {"EM_COV_MAT_DEFAULT", cv::ml::EM::COV_MAT_DEFAULT},
    {"EM_COV_MAT_DIAGONAL", cv::ml::EM::COV_MAT_DIAGONAL},
    {"EM_COV_MAT_GENERIC", cv::ml::EM::COV_MAT_GENERIC},
    {"EM_COV_MAT_SPHERICAL", cv::ml::EM::COV_MAT_SPHERICAL},
    {"EM_DEFAULT_MAX_ITERS", cv::ml::EM::DEFAULT_MAX_ITERS},
    {"EM_DEFAULT_NCLUSTERS", cv::ml::EM::DEFAULT_NCLUSTERS},
    {"EM_START_AUTO_STEP", cv::ml::EM::START_AUTO_STEP},
    {"EM_START_E_STEP", cv::ml::EM::START_E_STEP},
    {"EM_START_M_STEP", cv::ml::EM::START_M_STEP},
    {"KNearest_BRUTE_FORCE", cv::ml::KNearest::BRUTE_FORCE},
    {"KNEAREST_BRUTE_FORCE", cv::ml::KNearest::BRUTE_FORCE},
    {"KNearest_KDTREE", cv::ml::KNearest::KDTREE},
    {"KNEAREST_KDTREE", cv::ml::KNearest::KDTREE},
    {"LogisticRegression_BATCH", cv::ml::LogisticRegression::BATCH},
    {"LOGISTIC_REGRESSION_BATCH", cv::ml::LogisticRegression::BATCH},
    {"LogisticRegression_MINI_BATCH", cv::ml::LogisticRegression::MINI_BATCH},
    {"LOGISTIC_REGRESSION_MINI_BATCH", cv::ml::LogisticRegression::MINI_BATCH},
    {"LogisticRegression_REG_DISABLE", cv::ml::LogisticRegression::REG_DISABLE},
    {"LOGISTIC_REGRESSION_REG_DISABLE", cv::ml::LogisticRegression::REG_DISABLE},
    {"LogisticRegression_REG_L1", cv::ml::LogisticRegression::REG_L1},
    {"LOGISTIC_REGRESSION_REG_L1", cv::ml::LogisticRegression::REG_L1},
    {"LogisticRegression_REG_L2", cv::ml::LogisticRegression::REG_L2},
    {"LOGISTIC_REGRESSION_REG_L2", cv::ml::LogisticRegression::REG_L2},
    {"ROW_SAMPLE", cv::ml::ROW_SAMPLE},
    {"SVMSGD_ASGD", cv::ml::SVMSGD::ASGD},
    {"SVMSGD_HARD_MARGIN", cv::ml::SVMSGD::HARD_MARGIN},
    {"SVMSGD_SGD", cv::ml::SVMSGD::SGD},
    {"SVMSGD_SOFT_MARGIN", cv::ml::SVMSGD::SOFT_MARGIN},
    {"SVM_C", cv::ml::SVM::C},
    {"SVM_CHI2", cv::ml::SVM::CHI2},
    {"SVM_COEF", cv::ml::SVM::COEF},
    {"SVM_CUSTOM", cv::ml::SVM::CUSTOM},
    {"SVM_C_SVC", cv::ml::SVM::C_SVC},
    {"SVM_DEGREE", cv::ml::SVM::DEGREE},
    {"SVM_EPS_SVR", cv::ml::SVM::EPS_SVR},
    {"SVM_GAMMA", cv::ml::SVM::GAMMA},
    {"SVM_INTER", cv::ml::SVM::INTER},
    {"SVM_LINEAR", cv::ml::SVM::LINEAR},
    {"SVM_NU", cv::ml::SVM::NU},
    {"SVM_NU_SVC", cv::ml::SVM::NU_SVC},
    {"SVM_NU_SVR", cv::ml::SVM::NU_SVR},
    {"SVM_ONE_CLASS", cv::ml::SVM::ONE_CLASS},
    {"SVM_P", cv::ml::SVM::P},
    {"SVM_POLY", cv::ml::SVM::POLY},
    {"SVM_RBF", cv::ml::SVM::RBF},
    {"SVM_SIGMOID", cv::ml::SVM::SIGMOID},
    {"StatModel_COMPRESSED_INPUT", cv::ml::StatModel::COMPRESSED_INPUT},
    {"STAT_MODEL_COMPRESSED_INPUT", cv::ml::StatModel::COMPRESSED_INPUT},
    {"StatModel_PREPROCESSED_INPUT", cv::ml::StatModel::PREPROCESSED_INPUT},
    {"STAT_MODEL_PREPROCESSED_INPUT", cv::ml::StatModel::PREPROCESSED_INPUT},
    {"StatModel_RAW_OUTPUT", cv::ml::StatModel::RAW_OUTPUT},
    {"STAT_MODEL_RAW_OUTPUT", cv::ml::StatModel::RAW_OUTPUT},
    {"StatModel_UPDATE_MODEL", cv::ml::StatModel::UPDATE_MODEL},
    {"STAT_MODEL_UPDATE_MODEL", cv::ml::StatModel::UPDATE_MODEL},
    {"TEST_ERROR", cv::ml::TEST_ERROR},
    {"TRAIN_ERROR", cv::ml::TRAIN_ERROR},
    {"VAR_CATEGORICAL", cv::ml::VAR_CATEGORICAL},
    {"VAR_NUMERICAL", cv::ml::VAR_NUMERICAL},
    {"VAR_ORDERED", cv::ml::VAR_ORDERED},
    {NULL, 0}
};

static PyMethodDef methods_motempl[] = {
    {"calcGlobalOrientation", (PyCFunction)pyopencv_cv_motempl_calcGlobalOrientation, METH_VARARGS | METH_KEYWORDS, "calcGlobalOrientation(orientation, mask, mhi, timestamp, duration) -> retval\n.   @brief Calculates a global motion orientation in a selected region.\n.   \n.   @param orientation Motion gradient orientation image calculated by the function calcMotionGradient\n.   @param mask Mask image. It may be a conjunction of a valid gradient mask, also calculated by\n.   calcMotionGradient , and the mask of a region whose direction needs to be calculated.\n.   @param mhi Motion history image calculated by updateMotionHistory .\n.   @param timestamp Timestamp passed to updateMotionHistory .\n.   @param duration Maximum duration of a motion track in milliseconds, passed to updateMotionHistory\n.   \n.   The function calculates an average motion direction in the selected region and returns the angle\n.   between 0 degrees and 360 degrees. The average direction is computed from the weighted orientation\n.   histogram, where a recent motion has a larger weight and the motion occurred in the past has a\n.   smaller weight, as recorded in mhi ."},
    {"calcMotionGradient", (PyCFunction)pyopencv_cv_motempl_calcMotionGradient, METH_VARARGS | METH_KEYWORDS, "calcMotionGradient(mhi, delta1, delta2[, mask[, orientation[, apertureSize]]]) -> mask, orientation\n.   @brief Calculates a gradient orientation of a motion history image.\n.   \n.   @param mhi Motion history single-channel floating-point image.\n.   @param mask Output mask image that has the type CV_8UC1 and the same size as mhi . Its non-zero\n.   elements mark pixels where the motion gradient data is correct.\n.   @param orientation Output motion gradient orientation image that has the same type and the same\n.   size as mhi . Each pixel of the image is a motion orientation, from 0 to 360 degrees.\n.   @param delta1 Minimal (or maximal) allowed difference between mhi values within a pixel\n.   neighborhood.\n.   @param delta2 Maximal (or minimal) allowed difference between mhi values within a pixel\n.   neighborhood. That is, the function finds the minimum ( \\f$m(x,y)\\f$ ) and maximum ( \\f$M(x,y)\\f$ ) mhi\n.   values over \\f$3 \\times 3\\f$ neighborhood of each pixel and marks the motion orientation at \\f$(x, y)\\f$\n.   as valid only if\n.   \\f[\\min ( \\texttt{delta1}  ,  \\texttt{delta2}  )  \\le  M(x,y)-m(x,y)  \\le   \\max ( \\texttt{delta1}  , \\texttt{delta2} ).\\f]\n.   @param apertureSize Aperture size of the Sobel operator.\n.   \n.   The function calculates a gradient orientation at each pixel \\f$(x, y)\\f$ as:\n.   \n.   \\f[\\texttt{orientation} (x,y)= \\arctan{\\frac{d\\texttt{mhi}/dy}{d\\texttt{mhi}/dx}}\\f]\n.   \n.   In fact, fastAtan2 and phase are used so that the computed angle is measured in degrees and covers\n.   the full range 0..360. Also, the mask is filled to indicate pixels where the computed angle is\n.   valid.\n.   \n.   @note\n.   -   (Python) An example on how to perform a motion template technique can be found at\n.   opencv_source_code/samples/python2/motempl.py"},
    {"segmentMotion", (PyCFunction)pyopencv_cv_motempl_segmentMotion, METH_VARARGS | METH_KEYWORDS, "segmentMotion(mhi, timestamp, segThresh[, segmask]) -> segmask, boundingRects\n.   @brief Splits a motion history image into a few parts corresponding to separate independent motions (for\n.   example, left hand, right hand).\n.   \n.   @param mhi Motion history image.\n.   @param segmask Image where the found mask should be stored, single-channel, 32-bit floating-point.\n.   @param boundingRects Vector containing ROIs of motion connected components.\n.   @param timestamp Current time in milliseconds or other units.\n.   @param segThresh Segmentation threshold that is recommended to be equal to the interval between\n.   motion history \"steps\" or greater.\n.   \n.   The function finds all of the motion segments and marks them in segmask with individual values\n.   (1,2,...). It also computes a vector with ROIs of motion connected components. After that the motion\n.   direction for every component can be calculated with calcGlobalOrientation using the extracted mask\n.   of the particular component."},
    {"updateMotionHistory", (PyCFunction)pyopencv_cv_motempl_updateMotionHistory, METH_VARARGS | METH_KEYWORDS, "updateMotionHistory(silhouette, mhi, timestamp, duration) -> mhi\n.   @brief Updates the motion history image by a moving silhouette.\n.   \n.   @param silhouette Silhouette mask that has non-zero pixels where the motion occurs.\n.   @param mhi Motion history image that is updated by the function (single-channel, 32-bit\n.   floating-point).\n.   @param timestamp Current time in milliseconds or other units.\n.   @param duration Maximal duration of the motion track in the same units as timestamp .\n.   \n.   The function updates the motion history image as follows:\n.   \n.   \\f[\\texttt{mhi} (x,y)= \\forkthree{\\texttt{timestamp}}{if \\(\\texttt{silhouette}(x,y) \\ne 0\\)}{0}{if \\(\\texttt{silhouette}(x,y) = 0\\) and \\(\\texttt{mhi} < (\\texttt{timestamp} - \\texttt{duration})\\)}{\\texttt{mhi}(x,y)}{otherwise}\\f]\n.   \n.   That is, MHI pixels where the motion occurs are set to the current timestamp , while the pixels\n.   where the motion happened last time a long time ago are cleared.\n.   \n.   The function, together with calcMotionGradient and calcGlobalOrientation , implements a motion\n.   templates technique described in @cite Davis97 and @cite Bradski00 ."},
    {NULL, NULL}
};

static ConstDef consts_motempl[] = {
    {NULL, 0}
};

static PyMethodDef methods_multicalib[] = {
    {NULL, NULL}
};

static ConstDef consts_multicalib[] = {
    {"MultiCameraCalibration_OMNIDIRECTIONAL", cv::multicalib::MultiCameraCalibration::OMNIDIRECTIONAL},
    {"MULTI_CAMERA_CALIBRATION_OMNIDIRECTIONAL", cv::multicalib::MultiCameraCalibration::OMNIDIRECTIONAL},
    {"MultiCameraCalibration_PINHOLE", cv::multicalib::MultiCameraCalibration::PINHOLE},
    {"MULTI_CAMERA_CALIBRATION_PINHOLE", cv::multicalib::MultiCameraCalibration::PINHOLE},
    {NULL, 0}
};

static PyMethodDef methods_ocl[] = {
    {"finish", (PyCFunction)pyopencv_cv_ocl_finish, METH_VARARGS | METH_KEYWORDS, "finish() -> None\n."},
    {"haveAmdBlas", (PyCFunction)pyopencv_cv_ocl_haveAmdBlas, METH_VARARGS | METH_KEYWORDS, "haveAmdBlas() -> retval\n."},
    {"haveAmdFft", (PyCFunction)pyopencv_cv_ocl_haveAmdFft, METH_VARARGS | METH_KEYWORDS, "haveAmdFft() -> retval\n."},
    {"haveOpenCL", (PyCFunction)pyopencv_cv_ocl_haveOpenCL, METH_VARARGS | METH_KEYWORDS, "haveOpenCL() -> retval\n."},
    {"setUseOpenCL", (PyCFunction)pyopencv_cv_ocl_setUseOpenCL, METH_VARARGS | METH_KEYWORDS, "setUseOpenCL(flag) -> None\n."},
    {"useOpenCL", (PyCFunction)pyopencv_cv_ocl_useOpenCL, METH_VARARGS | METH_KEYWORDS, "useOpenCL() -> retval\n."},
    {NULL, NULL}
};

static ConstDef consts_ocl[] = {
    {"Device_EXEC_KERNEL", cv::ocl::Device::EXEC_KERNEL},
    {"DEVICE_EXEC_KERNEL", cv::ocl::Device::EXEC_KERNEL},
    {"Device_EXEC_NATIVE_KERNEL", cv::ocl::Device::EXEC_NATIVE_KERNEL},
    {"DEVICE_EXEC_NATIVE_KERNEL", cv::ocl::Device::EXEC_NATIVE_KERNEL},
    {"Device_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT", cv::ocl::Device::FP_CORRECTLY_ROUNDED_DIVIDE_SQRT},
    {"DEVICE_FP_CORRECTLY_ROUNDED_DIVIDE_SQRT", cv::ocl::Device::FP_CORRECTLY_ROUNDED_DIVIDE_SQRT},
    {"Device_FP_DENORM", cv::ocl::Device::FP_DENORM},
    {"DEVICE_FP_DENORM", cv::ocl::Device::FP_DENORM},
    {"Device_FP_FMA", cv::ocl::Device::FP_FMA},
    {"DEVICE_FP_FMA", cv::ocl::Device::FP_FMA},
    {"Device_FP_INF_NAN", cv::ocl::Device::FP_INF_NAN},
    {"DEVICE_FP_INF_NAN", cv::ocl::Device::FP_INF_NAN},
    {"Device_FP_ROUND_TO_INF", cv::ocl::Device::FP_ROUND_TO_INF},
    {"DEVICE_FP_ROUND_TO_INF", cv::ocl::Device::FP_ROUND_TO_INF},
    {"Device_FP_ROUND_TO_NEAREST", cv::ocl::Device::FP_ROUND_TO_NEAREST},
    {"DEVICE_FP_ROUND_TO_NEAREST", cv::ocl::Device::FP_ROUND_TO_NEAREST},
    {"Device_FP_ROUND_TO_ZERO", cv::ocl::Device::FP_ROUND_TO_ZERO},
    {"DEVICE_FP_ROUND_TO_ZERO", cv::ocl::Device::FP_ROUND_TO_ZERO},
    {"Device_FP_SOFT_FLOAT", cv::ocl::Device::FP_SOFT_FLOAT},
    {"DEVICE_FP_SOFT_FLOAT", cv::ocl::Device::FP_SOFT_FLOAT},
    {"Device_LOCAL_IS_GLOBAL", cv::ocl::Device::LOCAL_IS_GLOBAL},
    {"DEVICE_LOCAL_IS_GLOBAL", cv::ocl::Device::LOCAL_IS_GLOBAL},
    {"Device_LOCAL_IS_LOCAL", cv::ocl::Device::LOCAL_IS_LOCAL},
    {"DEVICE_LOCAL_IS_LOCAL", cv::ocl::Device::LOCAL_IS_LOCAL},
    {"Device_NO_CACHE", cv::ocl::Device::NO_CACHE},
    {"DEVICE_NO_CACHE", cv::ocl::Device::NO_CACHE},
    {"Device_NO_LOCAL_MEM", cv::ocl::Device::NO_LOCAL_MEM},
    {"DEVICE_NO_LOCAL_MEM", cv::ocl::Device::NO_LOCAL_MEM},
    {"Device_READ_ONLY_CACHE", cv::ocl::Device::READ_ONLY_CACHE},
    {"DEVICE_READ_ONLY_CACHE", cv::ocl::Device::READ_ONLY_CACHE},
    {"Device_READ_WRITE_CACHE", cv::ocl::Device::READ_WRITE_CACHE},
    {"DEVICE_READ_WRITE_CACHE", cv::ocl::Device::READ_WRITE_CACHE},
    {"Device_TYPE_ACCELERATOR", cv::ocl::Device::TYPE_ACCELERATOR},
    {"DEVICE_TYPE_ACCELERATOR", cv::ocl::Device::TYPE_ACCELERATOR},
    {"Device_TYPE_ALL", cv::ocl::Device::TYPE_ALL},
    {"DEVICE_TYPE_ALL", cv::ocl::Device::TYPE_ALL},
    {"Device_TYPE_CPU", cv::ocl::Device::TYPE_CPU},
    {"DEVICE_TYPE_CPU", cv::ocl::Device::TYPE_CPU},
    {"Device_TYPE_DEFAULT", cv::ocl::Device::TYPE_DEFAULT},
    {"DEVICE_TYPE_DEFAULT", cv::ocl::Device::TYPE_DEFAULT},
    {"Device_TYPE_DGPU", cv::ocl::Device::TYPE_DGPU},
    {"DEVICE_TYPE_DGPU", cv::ocl::Device::TYPE_DGPU},
    {"Device_TYPE_GPU", cv::ocl::Device::TYPE_GPU},
    {"DEVICE_TYPE_GPU", cv::ocl::Device::TYPE_GPU},
    {"Device_TYPE_IGPU", cv::ocl::Device::TYPE_IGPU},
    {"DEVICE_TYPE_IGPU", cv::ocl::Device::TYPE_IGPU},
    {"Device_UNKNOWN_VENDOR", cv::ocl::Device::UNKNOWN_VENDOR},
    {"DEVICE_UNKNOWN_VENDOR", cv::ocl::Device::UNKNOWN_VENDOR},
    {"Device_VENDOR_AMD", cv::ocl::Device::VENDOR_AMD},
    {"DEVICE_VENDOR_AMD", cv::ocl::Device::VENDOR_AMD},
    {"Device_VENDOR_INTEL", cv::ocl::Device::VENDOR_INTEL},
    {"DEVICE_VENDOR_INTEL", cv::ocl::Device::VENDOR_INTEL},
    {"Device_VENDOR_NVIDIA", cv::ocl::Device::VENDOR_NVIDIA},
    {"DEVICE_VENDOR_NVIDIA", cv::ocl::Device::VENDOR_NVIDIA},
    {"KernelArg_CONSTANT", cv::ocl::KernelArg::CONSTANT},
    {"KERNEL_ARG_CONSTANT", cv::ocl::KernelArg::CONSTANT},
    {"KernelArg_LOCAL", cv::ocl::KernelArg::LOCAL},
    {"KERNEL_ARG_LOCAL", cv::ocl::KernelArg::LOCAL},
    {"KernelArg_NO_SIZE", cv::ocl::KernelArg::NO_SIZE},
    {"KERNEL_ARG_NO_SIZE", cv::ocl::KernelArg::NO_SIZE},
    {"KernelArg_PTR_ONLY", cv::ocl::KernelArg::PTR_ONLY},
    {"KERNEL_ARG_PTR_ONLY", cv::ocl::KernelArg::PTR_ONLY},
    {"KernelArg_READ_ONLY", cv::ocl::KernelArg::READ_ONLY},
    {"KERNEL_ARG_READ_ONLY", cv::ocl::KernelArg::READ_ONLY},
    {"KernelArg_READ_WRITE", cv::ocl::KernelArg::READ_WRITE},
    {"KERNEL_ARG_READ_WRITE", cv::ocl::KernelArg::READ_WRITE},
    {"KernelArg_WRITE_ONLY", cv::ocl::KernelArg::WRITE_ONLY},
    {"KERNEL_ARG_WRITE_ONLY", cv::ocl::KernelArg::WRITE_ONLY},
    {"OCL_VECTOR_DEFAULT", cv::ocl::OCL_VECTOR_DEFAULT},
    {"OCL_VECTOR_MAX", cv::ocl::OCL_VECTOR_MAX},
    {"OCL_VECTOR_OWN", cv::ocl::OCL_VECTOR_OWN},
    {NULL, 0}
};

static PyMethodDef methods_ogl[] = {
    {NULL, NULL}
};

static ConstDef consts_ogl[] = {
    {"Buffer_ARRAY_BUFFER", cv::ogl::Buffer::ARRAY_BUFFER},
    {"BUFFER_ARRAY_BUFFER", cv::ogl::Buffer::ARRAY_BUFFER},
    {"Buffer_ELEMENT_ARRAY_BUFFER", cv::ogl::Buffer::ELEMENT_ARRAY_BUFFER},
    {"BUFFER_ELEMENT_ARRAY_BUFFER", cv::ogl::Buffer::ELEMENT_ARRAY_BUFFER},
    {"Buffer_PIXEL_PACK_BUFFER", cv::ogl::Buffer::PIXEL_PACK_BUFFER},
    {"BUFFER_PIXEL_PACK_BUFFER", cv::ogl::Buffer::PIXEL_PACK_BUFFER},
    {"Buffer_PIXEL_UNPACK_BUFFER", cv::ogl::Buffer::PIXEL_UNPACK_BUFFER},
    {"BUFFER_PIXEL_UNPACK_BUFFER", cv::ogl::Buffer::PIXEL_UNPACK_BUFFER},
    {"Buffer_READ_ONLY", cv::ogl::Buffer::READ_ONLY},
    {"BUFFER_READ_ONLY", cv::ogl::Buffer::READ_ONLY},
    {"Buffer_READ_WRITE", cv::ogl::Buffer::READ_WRITE},
    {"BUFFER_READ_WRITE", cv::ogl::Buffer::READ_WRITE},
    {"Buffer_WRITE_ONLY", cv::ogl::Buffer::WRITE_ONLY},
    {"BUFFER_WRITE_ONLY", cv::ogl::Buffer::WRITE_ONLY},
    {"LINES", cv::ogl::LINES},
    {"LINE_LOOP", cv::ogl::LINE_LOOP},
    {"LINE_STRIP", cv::ogl::LINE_STRIP},
    {"POINTS", cv::ogl::POINTS},
    {"POLYGON", cv::ogl::POLYGON},
    {"QUADS", cv::ogl::QUADS},
    {"QUAD_STRIP", cv::ogl::QUAD_STRIP},
    {"TRIANGLES", cv::ogl::TRIANGLES},
    {"TRIANGLE_FAN", cv::ogl::TRIANGLE_FAN},
    {"TRIANGLE_STRIP", cv::ogl::TRIANGLE_STRIP},
    {"Texture2D_DEPTH_COMPONENT", cv::ogl::Texture2D::DEPTH_COMPONENT},
    {"TEXTURE2D_DEPTH_COMPONENT", cv::ogl::Texture2D::DEPTH_COMPONENT},
    {"Texture2D_NONE", cv::ogl::Texture2D::NONE},
    {"TEXTURE2D_NONE", cv::ogl::Texture2D::NONE},
    {"Texture2D_RGB", cv::ogl::Texture2D::RGB},
    {"TEXTURE2D_RGB", cv::ogl::Texture2D::RGB},
    {"Texture2D_RGBA", cv::ogl::Texture2D::RGBA},
    {"TEXTURE2D_RGBA", cv::ogl::Texture2D::RGBA},
    {NULL, 0}
};

static PyMethodDef methods_omnidir[] = {
    {"calibrate", (PyCFunction)pyopencv_cv_omnidir_calibrate, METH_VARARGS | METH_KEYWORDS, "calibrate(objectPoints, imagePoints, size, K, xi, D, flags, criteria[, rvecs[, tvecs[, idx]]]) -> retval, K, xi, D, rvecs, tvecs, idx\n.   @brief Perform omnidirectional camera calibration, the default depth of outputs is CV_64F.\n.   \n.   @param objectPoints Vector of vector of Vec3f object points in world (pattern) coordinate.\n.   It also can be vector of Mat with size 1xN/Nx1 and type CV_32FC3. Data with depth of 64_F is also acceptable.\n.   @param imagePoints Vector of vector of Vec2f corresponding image points of objectPoints. It must be the same\n.   size and the same type with objectPoints.\n.   @param size Image size of calibration images.\n.   @param K Output calibrated camera matrix.\n.   @param xi Output parameter xi for CMei's model\n.   @param D Output distortion parameters \\f$(k_1, k_2, p_1, p_2)\\f$\n.   @param rvecs Output rotations for each calibration images\n.   @param tvecs Output translation for each calibration images\n.   @param flags The flags that control calibrate\n.   @param criteria Termination criteria for optimization\n.   @param idx Indices of images that pass initialization, which are really used in calibration. So the size of rvecs is the\n.   same as idx.total()."},
    {"initUndistortRectifyMap", (PyCFunction)pyopencv_cv_omnidir_initUndistortRectifyMap, METH_VARARGS | METH_KEYWORDS, "initUndistortRectifyMap(K, D, xi, R, P, size, mltype, flags[, map1[, map2]]) -> map1, map2\n.   @brief Computes undistortion and rectification maps for omnidirectional camera image transform by a rotation R.\n.   It output two maps that are used for cv::remap(). If D is empty then zero distortion is used,\n.   if R or P is empty then identity matrices are used.\n.   \n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{s}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$, with depth CV_32F or CV_64F\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, p_1, p_2)\\f$, with depth CV_32F or CV_64F\n.   @param xi The parameter xi for CMei's model\n.   @param R Rotation transform between the original and object space : 3x3 1-channel, or vector: 3x1/1x3, with depth CV_32F or CV_64F\n.   @param P New camera matrix (3x3) or new projection matrix (3x4)\n.   @param size Undistorted image size.\n.   @param mltype Type of the first output map that can be CV_32FC1 or CV_16SC2 . See convertMaps()\n.   for details.\n.   @param map1 The first output map.\n.   @param map2 The second output map.\n.   @param flags Flags indicates the rectification type,  RECTIFY_PERSPECTIVE, RECTIFY_CYLINDRICAL, RECTIFY_LONGLATI and RECTIFY_STEREOGRAPHIC\n.   are supported."},
    {"projectPoints", (PyCFunction)pyopencv_cv_omnidir_projectPoints, METH_VARARGS | METH_KEYWORDS, "projectPoints(objectPoints, rvec, tvec, K, xi, D[, imagePoints[, jacobian]]) -> imagePoints, jacobian\n.   @brief Projects points for omnidirectional camera using CMei's model\n.   \n.   @param objectPoints Object points in world coordinate, vector of vector of Vec3f or Mat of\n.   1xN/Nx1 3-channel of type CV_32F and N is the number of points. 64F is also acceptable.\n.   @param imagePoints Output array of image points, vector of vector of Vec2f or\n.   1xN/Nx1 2-channel of type CV_32F. 64F is also acceptable.\n.   @param rvec vector of rotation between world coordinate and camera coordinate, i.e., om\n.   @param tvec vector of translation between pattern coordinate and camera coordinate\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{s}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, p_1, p_2)\\f$.\n.   @param xi The parameter xi for CMei's model\n.   @param jacobian Optional output 2Nx16 of type CV_64F jacobian matrix, contains the derivatives of\n.   image pixel points wrt parameters including \\f$om, T, f_x, f_y, s, c_x, c_y, xi, k_1, k_2, p_1, p_2\\f$.\n.   This matrix will be used in calibration by optimization.\n.   \n.   The function projects object 3D points of world coordinate to image pixels, parameter by intrinsic\n.   and extrinsic parameters. Also, it optionally compute a by-product: the jacobian matrix containing\n.   contains the derivatives of image pixel points wrt intrinsic and extrinsic parameters."},
    {"stereoCalibrate", (PyCFunction)pyopencv_cv_omnidir_stereoCalibrate, METH_VARARGS | METH_KEYWORDS, "stereoCalibrate(objectPoints, imagePoints1, imagePoints2, imageSize1, imageSize2, K1, xi1, D1, K2, xi2, D2, flags, criteria[, rvec[, tvec[, rvecsL[, tvecsL[, idx]]]]]) -> retval, objectPoints, imagePoints1, imagePoints2, K1, xi1, D1, K2, xi2, D2, rvec, tvec, rvecsL, tvecsL, idx\n.   @brief Stereo calibration for omnidirectional camera model. It computes the intrinsic parameters for two\n.   cameras and the extrinsic parameters between two cameras. The default depth of outputs is CV_64F.\n.   \n.   @param objectPoints Object points in world (pattern) coordinate. Its type is vector<vector<Vec3f> >.\n.   It also can be vector of Mat with size 1xN/Nx1 and type CV_32FC3. Data with depth of 64_F is also acceptable.\n.   @param imagePoints1 The corresponding image points of the first camera, with type vector<vector<Vec2f> >.\n.   It must be the same size and the same type as objectPoints.\n.   @param imagePoints2 The corresponding image points of the second camera, with type vector<vector<Vec2f> >.\n.   It must be the same size and the same type as objectPoints.\n.   @param imageSize1 Image size of calibration images of the first camera.\n.   @param imageSize2 Image size of calibration images of the second camera.\n.   @param K1 Output camera matrix for the first camera.\n.   @param xi1 Output parameter xi of Mei's model for the first camera\n.   @param D1 Output distortion parameters \\f$(k_1, k_2, p_1, p_2)\\f$ for the first camera\n.   @param K2 Output camera matrix for the first camera.\n.   @param xi2 Output parameter xi of CMei's model for the second camera\n.   @param D2 Output distortion parameters \\f$(k_1, k_2, p_1, p_2)\\f$ for the second camera\n.   @param rvec Output rotation between the first and second camera\n.   @param tvec Output translation between the first and second camera\n.   @param rvecsL Output rotation for each image of the first camera\n.   @param tvecsL Output translation for each image of the first camera\n.   @param flags The flags that control stereoCalibrate\n.   @param criteria Termination criteria for optimization\n.   @param idx Indices of image pairs that pass initialization, which are really used in calibration. So the size of rvecs is the\n.   same as idx.total().\n.   @"},
    {"stereoReconstruct", (PyCFunction)pyopencv_cv_omnidir_stereoReconstruct, METH_VARARGS | METH_KEYWORDS, "stereoReconstruct(image1, image2, K1, D1, xi1, K2, D2, xi2, R, T, flag, numDisparities, SADWindowSize[, disparity[, image1Rec[, image2Rec[, newSize[, Knew[, pointCloud[, pointType]]]]]]]) -> disparity, image1Rec, image2Rec, pointCloud\n.   @brief Stereo 3D reconstruction from a pair of images\n.   \n.   @param image1 The first input image\n.   @param image2 The second input image\n.   @param K1 Input camera matrix of the first camera\n.   @param D1 Input distortion parameters \\f$(k_1, k_2, p_1, p_2)\\f$ for the first camera\n.   @param xi1 Input parameter xi for the first camera for CMei's model\n.   @param K2 Input camera matrix of the second camera\n.   @param D2 Input distortion parameters \\f$(k_1, k_2, p_1, p_2)\\f$ for the second camera\n.   @param xi2 Input parameter xi for the second camera for CMei's model\n.   @param R Rotation between the first and second camera\n.   @param T Translation between the first and second camera\n.   @param flag Flag of rectification type, RECTIFY_PERSPECTIVE or RECTIFY_LONGLATI\n.   @param numDisparities The parameter 'numDisparities' in StereoSGBM, see StereoSGBM for details.\n.   @param SADWindowSize The parameter 'SADWindowSize' in StereoSGBM, see StereoSGBM for details.\n.   @param disparity Disparity map generated by stereo matching\n.   @param image1Rec Rectified image of the first image\n.   @param image2Rec rectified image of the second image\n.   @param newSize Image size of rectified image, see omnidir::undistortImage\n.   @param Knew New camera matrix of rectified image, see omnidir::undistortImage\n.   @param pointCloud Point cloud of 3D reconstruction, with type CV_64FC3\n.   @param pointType Point cloud type, it can be XYZRGB or XYZ"},
    {"stereoRectify", (PyCFunction)pyopencv_cv_omnidir_stereoRectify, METH_VARARGS | METH_KEYWORDS, "stereoRectify(R, T[, R1[, R2]]) -> R1, R2\n.   @brief Stereo rectification for omnidirectional camera model. It computes the rectification rotations for two cameras\n.   \n.   @param R Rotation between the first and second camera\n.   @param T Translation between the first and second camera\n.   @param R1 Output 3x3 rotation matrix for the first camera\n.   @param R2 Output 3x3 rotation matrix for the second camera"},
    {"undistortImage", (PyCFunction)pyopencv_cv_omnidir_undistortImage, METH_VARARGS | METH_KEYWORDS, "undistortImage(distorted, K, D, xi, flags[, undistorted[, Knew[, new_size[, R]]]]) -> undistorted\n.   @brief Undistort omnidirectional images to perspective images\n.   \n.   @param distorted The input omnidirectional image.\n.   @param undistorted The output undistorted image.\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{s}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Input vector of distortion coefficients \\f$(k_1, k_2, p_1, p_2)\\f$.\n.   @param xi The parameter xi for CMei's model.\n.   @param flags Flags indicates the rectification type,  RECTIFY_PERSPECTIVE, RECTIFY_CYLINDRICAL, RECTIFY_LONGLATI and RECTIFY_STEREOGRAPHIC\n.   @param Knew Camera matrix of the distorted image. If it is not assigned, it is just K.\n.   @param new_size The new image size. By default, it is the size of distorted.\n.   @param R Rotation matrix between the input and output images. By default, it is identity matrix."},
    {"undistortPoints", (PyCFunction)pyopencv_cv_omnidir_undistortPoints, METH_VARARGS | METH_KEYWORDS, "undistortPoints(distorted, K, D, xi, R[, undistorted]) -> undistorted\n.   @brief Undistort 2D image points for omnidirectional camera using CMei's model\n.   \n.   @param distorted Array of distorted image points, vector of Vec2f\n.   or 1xN/Nx1 2-channel Mat of type CV_32F, 64F depth is also acceptable\n.   @param K Camera matrix \\f$K = \\vecthreethree{f_x}{s}{c_x}{0}{f_y}{c_y}{0}{0}{_1}\\f$.\n.   @param D Distortion coefficients \\f$(k_1, k_2, p_1, p_2)\\f$.\n.   @param xi The parameter xi for CMei's model\n.   @param R Rotation trainsform between the original and object space : 3x3 1-channel, or vector: 3x1/1x3\n.   1-channel or 1x1 3-channel\n.   @param undistorted array of normalized object points, vector of Vec2f/Vec2d or 1xN/Nx1 2-channel Mat with the same\n.   depth of distorted points."},
    {NULL, NULL}
};

static ConstDef consts_omnidir[] = {
    {"CALIB_FIX_CENTER", cv::omnidir::CALIB_FIX_CENTER},
    {"CALIB_FIX_GAMMA", cv::omnidir::CALIB_FIX_GAMMA},
    {"CALIB_FIX_K1", cv::omnidir::CALIB_FIX_K1},
    {"CALIB_FIX_K2", cv::omnidir::CALIB_FIX_K2},
    {"CALIB_FIX_P1", cv::omnidir::CALIB_FIX_P1},
    {"CALIB_FIX_P2", cv::omnidir::CALIB_FIX_P2},
    {"CALIB_FIX_SKEW", cv::omnidir::CALIB_FIX_SKEW},
    {"CALIB_FIX_XI", cv::omnidir::CALIB_FIX_XI},
    {"CALIB_USE_GUESS", cv::omnidir::CALIB_USE_GUESS},
    {"RECTIFY_CYLINDRICAL", cv::omnidir::RECTIFY_CYLINDRICAL},
    {"RECTIFY_LONGLATI", cv::omnidir::RECTIFY_LONGLATI},
    {"RECTIFY_PERSPECTIVE", cv::omnidir::RECTIFY_PERSPECTIVE},
    {"RECTIFY_STEREOGRAPHIC", cv::omnidir::RECTIFY_STEREOGRAPHIC},
    {"XYZ", cv::omnidir::XYZ},
    {"XYZRGB", cv::omnidir::XYZRGB},
    {NULL, 0}
};

static PyMethodDef methods_optflow[] = {
    {"calcOpticalFlowSF", (PyCFunction)pyopencv_cv_optflow_calcOpticalFlowSF, METH_VARARGS | METH_KEYWORDS, "calcOpticalFlowSF(from, to, layers, averaging_block_size, max_flow[, flow]) -> flow\n.   @overload\n\n\n\ncalcOpticalFlowSF(from, to, layers, averaging_block_size, max_flow, sigma_dist, sigma_color, postprocess_window, sigma_dist_fix, sigma_color_fix, occ_thr, upscale_averaging_radius, upscale_sigma_dist, upscale_sigma_color, speed_up_thr[, flow]) -> flow\n.   @brief Calculate an optical flow using \"SimpleFlow\" algorithm.\n.   \n.   @param from First 8-bit 3-channel image.\n.   @param to Second 8-bit 3-channel image of the same size as prev\n.   @param flow computed flow image that has the same size as prev and type CV_32FC2\n.   @param layers Number of layers\n.   @param averaging_block_size Size of block through which we sum up when calculate cost function\n.   for pixel\n.   @param max_flow maximal flow that we search at each level\n.   @param sigma_dist vector smooth spatial sigma parameter\n.   @param sigma_color vector smooth color sigma parameter\n.   @param postprocess_window window size for postprocess cross bilateral filter\n.   @param sigma_dist_fix spatial sigma for postprocess cross bilateralf filter\n.   @param sigma_color_fix color sigma for postprocess cross bilateral filter\n.   @param occ_thr threshold for detecting occlusions\n.   @param upscale_averaging_radius window size for bilateral upscale operation\n.   @param upscale_sigma_dist spatial sigma for bilateral upscale operation\n.   @param upscale_sigma_color color sigma for bilateral upscale operation\n.   @param speed_up_thr threshold to detect point with irregular flow - where flow should be\n.   recalculated after upscale\n.   \n.   See @cite Tao2012 . And site of project - <http://graphics.berkeley.edu/papers/Tao-SAN-2012-05/>.\n.   \n.   @note\n.   -   An example using the simpleFlow algorithm can be found at samples/simpleflow_demo.cpp"},
    {"calcOpticalFlowSparseToDense", (PyCFunction)pyopencv_cv_optflow_calcOpticalFlowSparseToDense, METH_VARARGS | METH_KEYWORDS, "calcOpticalFlowSparseToDense(from, to[, flow[, grid_step[, k[, sigma[, use_post_proc[, fgs_lambda[, fgs_sigma]]]]]]]) -> flow\n.   @brief Fast dense optical flow based on PyrLK sparse matches interpolation.\n.   \n.   @param from first 8-bit 3-channel or 1-channel image.\n.   @param to  second 8-bit 3-channel or 1-channel image of the same size as from\n.   @param flow computed flow image that has the same size as from and CV_32FC2 type\n.   @param grid_step stride used in sparse match computation. Lower values usually\n.   result in higher quality but slow down the algorithm.\n.   @param k number of nearest-neighbor matches considered, when fitting a locally affine\n.   model. Lower values can make the algorithm noticeably faster at the cost of\n.   some quality degradation.\n.   @param sigma parameter defining how fast the weights decrease in the locally-weighted affine\n.   fitting. Higher values can help preserve fine details, lower values can help to get rid\n.   of the noise in the output flow.\n.   @param use_post_proc defines whether the ximgproc::fastGlobalSmootherFilter() is used\n.   for post-processing after interpolation\n.   @param fgs_lambda see the respective parameter of the ximgproc::fastGlobalSmootherFilter()\n.   @param fgs_sigma  see the respective parameter of the ximgproc::fastGlobalSmootherFilter()"},
    {"createOptFlow_DIS", (PyCFunction)pyopencv_cv_optflow_createOptFlow_DIS, METH_VARARGS | METH_KEYWORDS, "createOptFlow_DIS([, preset]) -> retval\n.   @brief Creates an instance of DISOpticalFlow\n.   \n.   @param preset one of PRESET_ULTRAFAST, PRESET_FAST and PRESET_MEDIUM"},
    {"createOptFlow_DeepFlow", (PyCFunction)pyopencv_cv_optflow_createOptFlow_DeepFlow, METH_VARARGS | METH_KEYWORDS, "createOptFlow_DeepFlow() -> retval\n.   @brief DeepFlow optical flow algorithm implementation.\n.   \n.   The class implements the DeepFlow optical flow algorithm described in @cite Weinzaepfel2013 . See\n.   also <http://lear.inrialpes.fr/src/deepmatching/> .\n.   Parameters - class fields - that may be modified after creating a class instance:\n.   -   member float alpha\n.   Smoothness assumption weight\n.   -   member float delta\n.   Color constancy assumption weight\n.   -   member float gamma\n.   Gradient constancy weight\n.   -   member float sigma\n.   Gaussian smoothing parameter\n.   -   member int minSize\n.   Minimal dimension of an image in the pyramid (next, smaller images in the pyramid are generated\n.   until one of the dimensions reaches this size)\n.   -   member float downscaleFactor\n.   Scaling factor in the image pyramid (must be \\< 1)\n.   -   member int fixedPointIterations\n.   How many iterations on each level of the pyramid\n.   -   member int sorIterations\n.   Iterations of Succesive Over-Relaxation (solver)\n.   -   member float omega\n.   Relaxation factor in SOR"},
    {"createOptFlow_Farneback", (PyCFunction)pyopencv_cv_optflow_createOptFlow_Farneback, METH_VARARGS | METH_KEYWORDS, "createOptFlow_Farneback() -> retval\n."},
    {"createOptFlow_PCAFlow", (PyCFunction)pyopencv_cv_optflow_createOptFlow_PCAFlow, METH_VARARGS | METH_KEYWORDS, "createOptFlow_PCAFlow() -> retval\n.   @brief Creates an instance of PCAFlow"},
    {"createOptFlow_SimpleFlow", (PyCFunction)pyopencv_cv_optflow_createOptFlow_SimpleFlow, METH_VARARGS | METH_KEYWORDS, "createOptFlow_SimpleFlow() -> retval\n."},
    {"createOptFlow_SparseToDense", (PyCFunction)pyopencv_cv_optflow_createOptFlow_SparseToDense, METH_VARARGS | METH_KEYWORDS, "createOptFlow_SparseToDense() -> retval\n."},
    {"createVariationalFlowRefinement", (PyCFunction)pyopencv_cv_optflow_createVariationalFlowRefinement, METH_VARARGS | METH_KEYWORDS, "createVariationalFlowRefinement() -> retval\n.   @brief Creates an instance of VariationalRefinement"},
    {"readOpticalFlow", (PyCFunction)pyopencv_cv_optflow_readOpticalFlow, METH_VARARGS | METH_KEYWORDS, "readOpticalFlow(path) -> retval\n.   @brief Read a .flo file\n.   \n.   @param path Path to the file to be loaded\n.   \n.   The function readOpticalFlow loads a flow field from a file and returns it as a single matrix.\n.   Resulting Mat has a type CV_32FC2 - floating-point, 2-channel. First channel corresponds to the\n.   flow in the horizontal direction (u), second - vertical (v)."},
    {"writeOpticalFlow", (PyCFunction)pyopencv_cv_optflow_writeOpticalFlow, METH_VARARGS | METH_KEYWORDS, "writeOpticalFlow(path, flow) -> retval\n.   @brief Write a .flo to disk\n.   \n.   @param path Path to the file to be written\n.   @param flow Flow field to be stored\n.   \n.   The function stores a flow field in a file, returns true on success, false otherwise.\n.   The flow field must be a 2-channel, floating-point matrix (CV_32FC2). First channel corresponds\n.   to the flow in the horizontal direction (u), second - vertical (v)."},
    {NULL, NULL}
};

static ConstDef consts_optflow[] = {
    {"DISOpticalFlow_PRESET_FAST", cv::optflow::DISOpticalFlow::PRESET_FAST},
    {"DISOPTICAL_FLOW_PRESET_FAST", cv::optflow::DISOpticalFlow::PRESET_FAST},
    {"DISOpticalFlow_PRESET_MEDIUM", cv::optflow::DISOpticalFlow::PRESET_MEDIUM},
    {"DISOPTICAL_FLOW_PRESET_MEDIUM", cv::optflow::DISOpticalFlow::PRESET_MEDIUM},
    {"DISOpticalFlow_PRESET_ULTRAFAST", cv::optflow::DISOpticalFlow::PRESET_ULTRAFAST},
    {"DISOPTICAL_FLOW_PRESET_ULTRAFAST", cv::optflow::DISOpticalFlow::PRESET_ULTRAFAST},
    {"GPC_DESCRIPTOR_DCT", cv::optflow::GPC_DESCRIPTOR_DCT},
    {"GPC_DESCRIPTOR_WHT", cv::optflow::GPC_DESCRIPTOR_WHT},
    {NULL, 0}
};

static PyMethodDef methods_plot[] = {
    {"Plot2d_create", (PyCFunction)pyopencv_cv_plot_Plot2d_create, METH_VARARGS | METH_KEYWORDS, "Plot2d_create(data) -> retval\n.   * @brief Creates Plot2d object\n.   *\n.   * @param data \\f$1xN\\f$ or \\f$Nx1\\f$ matrix containing \\f$Y\\f$ values of points to plot. \\f$X\\f$ values\n.   * will be equal to indexes of correspondind elements in data matrix.\n\n\n\nPlot2d_create(dataX, dataY) -> retval\n.   * @brief Creates Plot2d object\n.   *\n.   * @param dataX \\f$1xN\\f$ or \\f$Nx1\\f$ matrix \\f$X\\f$ values of points to plot.\n.   * @param dataY \\f$1xN\\f$ or \\f$Nx1\\f$ matrix containing \\f$Y\\f$ values of points to plot."},
    {NULL, NULL}
};

static ConstDef consts_plot[] = {
    {NULL, 0}
};

static PyMethodDef methods_ppf_match_3d[] = {
    {"addNoisePC", (PyCFunction)pyopencv_cv_ppf_match_3d_addNoisePC, METH_VARARGS | METH_KEYWORDS, "addNoisePC(pc, scale) -> retval\n.   *  Adds a uniform noise in the given scale to the input point cloud\n.   *  @param [in] pc Input point cloud (CV_32F family).\n.   *  @param [in] scale Input scale of the noise. The larger the scale, the more noisy the output"},
    {"computeNormalsPC3d", (PyCFunction)pyopencv_cv_ppf_match_3d_computeNormalsPC3d, METH_VARARGS | METH_KEYWORDS, "computeNormalsPC3d(PC, NumNeighbors, FlipViewpoint, viewpoint[, PCNormals]) -> retval, PCNormals\n.   *  @brief Compute the normals of an arbitrary point cloud\n.   *  computeNormalsPC3d uses a plane fitting approach to smoothly compute\n.   *  local normals. Normals are obtained through the eigenvector of the covariance\n.   *  matrix, corresponding to the smallest eigen value.\n.   *  If PCNormals is provided to be an Nx6 matrix, then no new allocation\n.   *  is made, instead the existing memory is overwritten.\n.   *  @param [in] PC Input point cloud to compute the normals for.\n.   *  @param [out] PCNormals Output point cloud\n.   *  @param [in] NumNeighbors Number of neighbors to take into account in a local region\n.   *  @param [in] FlipViewpoint Should normals be flipped to a viewing direction?\n.   *  @param [in] viewpoint\n.   *  @return Returns 0 on success"},
    {"getRandomPose", (PyCFunction)pyopencv_cv_ppf_match_3d_getRandomPose, METH_VARARGS | METH_KEYWORDS, "getRandomPose(Pose) -> None\n.   *  Generate a random 4x4 pose matrix\n.   *  @param [out] Pose The random pose"},
    {"loadPLYSimple", (PyCFunction)pyopencv_cv_ppf_match_3d_loadPLYSimple, METH_VARARGS | METH_KEYWORDS, "loadPLYSimple(fileName[, withNormals]) -> retval\n.   *  @brief Load a PLY file\n.   *  @param [in] fileName The PLY model to read\n.   *  @param [in] withNormals Flag wheather the input PLY contains normal information,\n.   *  and whether it should be loaded or not\n.   *  @return Returns the matrix on successfull load"},
    {"samplePCByQuantization", (PyCFunction)pyopencv_cv_ppf_match_3d_samplePCByQuantization, METH_VARARGS | METH_KEYWORDS, "samplePCByQuantization(pc, xrange, yrange, zrange, sample_step_relative[, weightByCenter]) -> retval\n.   *  Sample a point cloud using uniform steps\n.   *  @param [in] pc Input point cloud\n.   *  @param [in] xrange X components (min and max) of the bounding box of the model\n.   *  @param [in] yrange Y components (min and max) of the bounding box of the model\n.   *  @param [in] zrange Z components (min and max) of the bounding box of the model\n.   *  @param [in] sample_step_relative The point cloud is sampled such that all points\n.   *  have a certain minimum distance. This minimum distance is determined relatively using\n.   *  the parameter sample_step_relative.\n.   *  @param [in] weightByCenter The contribution of the quantized data points can be weighted\n.   *  by the distance to the origin. This parameter enables/disables the use of weighting.\n.   *  @return Sampled point cloud"},
    {"transformPCPose", (PyCFunction)pyopencv_cv_ppf_match_3d_transformPCPose, METH_VARARGS | METH_KEYWORDS, "transformPCPose(pc, Pose) -> retval\n.   *  Transforms the point cloud with a given a homogeneous 4x4 pose matrix (in double precision)\n.   *  @param [in] pc Input point cloud (CV_32F family). Point clouds with 3 or 6 elements per\n.   *  row are expected. In the case where the normals are provided, they are also rotated to be\n.   *  compatible with the entire transformation\n.   *  @param [in] Pose 4x4 pose matrix, but linearized in row-major form.\n.   *  @return Transformed point cloud"},
    {"writePLY", (PyCFunction)pyopencv_cv_ppf_match_3d_writePLY, METH_VARARGS | METH_KEYWORDS, "writePLY(PC, fileName) -> None\n.   *  @brief Write a point cloud to PLY file\n.   *  @param [in] PC Input point cloud\n.   *  @param [in] fileName The PLY model file to write"},
    {"writePLYVisibleNormals", (PyCFunction)pyopencv_cv_ppf_match_3d_writePLYVisibleNormals, METH_VARARGS | METH_KEYWORDS, "writePLYVisibleNormals(PC, fileName) -> None\n.   *  @brief Used for debbuging pruposes, writes a point cloud to a PLY file with the tip\n.   *  of the normal vectors as visible red points\n.   *  @param [in] PC Input point cloud\n.   *  @param [in] fileName The PLY model file to write"},
    {NULL, NULL}
};

static ConstDef consts_ppf_match_3d[] = {
    {NULL, 0}
};

static PyMethodDef methods_reg[] = {
    {"MapTypeCaster_toAffine", (PyCFunction)pyopencv_cv_reg_MapTypeCaster_toAffine, METH_VARARGS | METH_KEYWORDS, "MapTypeCaster_toAffine(sourceMap) -> retval\n."},
    {"MapTypeCaster_toProjec", (PyCFunction)pyopencv_cv_reg_MapTypeCaster_toProjec, METH_VARARGS | METH_KEYWORDS, "MapTypeCaster_toProjec(sourceMap) -> retval\n."},
    {"MapTypeCaster_toShift", (PyCFunction)pyopencv_cv_reg_MapTypeCaster_toShift, METH_VARARGS | METH_KEYWORDS, "MapTypeCaster_toShift(sourceMap) -> retval\n."},
    {NULL, NULL}
};

static ConstDef consts_reg[] = {
    {NULL, 0}
};

static PyMethodDef methods_rgbd[] = {
    {"DepthCleaner_create", (PyCFunction)pyopencv_cv_rgbd_DepthCleaner_create, METH_VARARGS | METH_KEYWORDS, "DepthCleaner_create(depth[, window_size[, method]]) -> retval\n.   Constructor\n.   * @param depth the depth of the normals (only CV_32F or CV_64F)\n.   * @param window_size the window size to compute the normals: can only be 1,3,5 or 7\n.   * @param method one of the methods to use: RGBD_NORMALS_METHOD_SRI, RGBD_NORMALS_METHOD_FALS"},
    {"ICPOdometry_create", (PyCFunction)pyopencv_cv_rgbd_ICPOdometry_create, METH_VARARGS | METH_KEYWORDS, "ICPOdometry_create([, cameraMatrix[, minDepth[, maxDepth[, maxDepthDiff[, maxPointsPart[, iterCounts[, transformType]]]]]]]) -> retval\n.   Constructor.\n.   * @param cameraMatrix Camera matrix\n.   * @param minDepth Pixels with depth less than minDepth will not be used\n.   * @param maxDepth Pixels with depth larger than maxDepth will not be used\n.   * @param maxDepthDiff Correspondences between pixels of two given frames will be filtered out\n.   *                     if their depth difference is larger than maxDepthDiff\n.   * @param maxPointsPart The method uses a random pixels subset of size frameWidth x frameHeight x pointsPart\n.   * @param iterCounts Count of iterations on each pyramid level.\n.   * @param transformType Class of trasformation"},
    {"OdometryFrame_create", (PyCFunction)pyopencv_cv_rgbd_OdometryFrame_create, METH_VARARGS | METH_KEYWORDS, "OdometryFrame_create([, image[, depth[, mask[, normals[, ID]]]]]) -> retval\n."},
    {"Odometry_create", (PyCFunction)pyopencv_cv_rgbd_Odometry_create, METH_VARARGS | METH_KEYWORDS, "Odometry_create(odometryType) -> retval\n."},
    {"RgbdFrame_create", (PyCFunction)pyopencv_cv_rgbd_RgbdFrame_create, METH_VARARGS | METH_KEYWORDS, "RgbdFrame_create([, image[, depth[, mask[, normals[, ID]]]]]) -> retval\n."},
    {"RgbdICPOdometry_create", (PyCFunction)pyopencv_cv_rgbd_RgbdICPOdometry_create, METH_VARARGS | METH_KEYWORDS, "RgbdICPOdometry_create([, cameraMatrix[, minDepth[, maxDepth[, maxDepthDiff[, maxPointsPart[, iterCounts[, minGradientMagnitudes[, transformType]]]]]]]]) -> retval\n.   Constructor.\n.   * @param cameraMatrix Camera matrix\n.   * @param minDepth Pixels with depth less than minDepth will not be used\n.   * @param maxDepth Pixels with depth larger than maxDepth will not be used\n.   * @param maxDepthDiff Correspondences between pixels of two given frames will be filtered out\n.   *                     if their depth difference is larger than maxDepthDiff\n.   * @param maxPointsPart The method uses a random pixels subset of size frameWidth x frameHeight x pointsPart\n.   * @param iterCounts Count of iterations on each pyramid level.\n.   * @param minGradientMagnitudes For each pyramid level the pixels will be filtered out\n.   *                              if they have gradient magnitude less than minGradientMagnitudes[level].\n.   * @param transformType Class of trasformation"},
    {"RgbdNormals_create", (PyCFunction)pyopencv_cv_rgbd_RgbdNormals_create, METH_VARARGS | METH_KEYWORDS, "RgbdNormals_create(rows, cols, depth, K[, window_size[, method]]) -> retval\n.   Constructor\n.   * @param rows the number of rows of the depth image normals will be computed on\n.   * @param cols the number of cols of the depth image normals will be computed on\n.   * @param depth the depth of the normals (only CV_32F or CV_64F)\n.   * @param K the calibration matrix to use\n.   * @param window_size the window size to compute the normals: can only be 1,3,5 or 7\n.   * @param method one of the methods to use: RGBD_NORMALS_METHOD_SRI, RGBD_NORMALS_METHOD_FALS"},
    {"RgbdOdometry_create", (PyCFunction)pyopencv_cv_rgbd_RgbdOdometry_create, METH_VARARGS | METH_KEYWORDS, "RgbdOdometry_create([, cameraMatrix[, minDepth[, maxDepth[, maxDepthDiff[, iterCounts[, minGradientMagnitudes[, maxPointsPart[, transformType]]]]]]]]) -> retval\n.   Constructor.\n.   * @param cameraMatrix Camera matrix\n.   * @param minDepth Pixels with depth less than minDepth will not be used (in meters)\n.   * @param maxDepth Pixels with depth larger than maxDepth will not be used (in meters)\n.   * @param maxDepthDiff Correspondences between pixels of two given frames will be filtered out\n.   *                     if their depth difference is larger than maxDepthDiff (in meters)\n.   * @param iterCounts Count of iterations on each pyramid level.\n.   * @param minGradientMagnitudes For each pyramid level the pixels will be filtered out\n.   *                              if they have gradient magnitude less than minGradientMagnitudes[level].\n.   * @param maxPointsPart The method uses a random pixels subset of size frameWidth x frameHeight x pointsPart\n.   * @param transformType Class of transformation"},
    {"depthTo3d", (PyCFunction)pyopencv_cv_rgbd_depthTo3d, METH_VARARGS | METH_KEYWORDS, "depthTo3d(depth, K[, points3d[, mask]]) -> points3d\n.   Converts a depth image to an organized set of 3d points.\n.   * The coordinate system is x pointing left, y down and z away from the camera\n.   * @param depth the depth image (if given as short int CV_U, it is assumed to be the depth in millimeters\n.   *              (as done with the Microsoft Kinect), otherwise, if given as CV_32F or CV_64F, it is assumed in meters)\n.   * @param K The calibration matrix\n.   * @param points3d the resulting 3d points. They are of depth the same as `depth` if it is CV_32F or CV_64F, and the\n.   *        depth of `K` if `depth` is of depth CV_U\n.   * @param mask the mask of the points to consider (can be empty)"},
    {"depthTo3dSparse", (PyCFunction)pyopencv_cv_rgbd_depthTo3dSparse, METH_VARARGS | METH_KEYWORDS, "depthTo3dSparse(depth, in_K, in_points[, points3d]) -> points3d\n.   * @param depth the depth image\n.   * @param in_K\n.   * @param in_points the list of xy coordinates\n.   * @param points3d the resulting 3d points"},
    {"registerDepth", (PyCFunction)pyopencv_cv_rgbd_registerDepth, METH_VARARGS | METH_KEYWORDS, "registerDepth(unregisteredCameraMatrix, registeredCameraMatrix, registeredDistCoeffs, Rt, unregisteredDepth, outputImagePlaneSize[, registeredDepth[, depthDilation]]) -> registeredDepth\n.   Registers depth data to an external camera\n.   * Registration is performed by creating a depth cloud, transforming the cloud by\n.   * the rigid body transformation between the cameras, and then projecting the\n.   * transformed points into the RGB camera.\n.   *\n.   * uv_rgb = K_rgb * [R | t] * z * inv(K_ir) * uv_ir\n.   *\n.   * Currently does not check for negative depth values.\n.   *\n.   * @param unregisteredCameraMatrix the camera matrix of the depth camera\n.   * @param registeredCameraMatrix the camera matrix of the external camera\n.   * @param registeredDistCoeffs the distortion coefficients of the external camera\n.   * @param Rt the rigid body transform between the cameras. Transforms points from depth camera frame to external camera frame.\n.   * @param unregisteredDepth the input depth data\n.   * @param outputImagePlaneSize the image plane dimensions of the external camera (width, height)\n.   * @param registeredDepth the result of transforming the depth into the external camera\n.   * @param depthDilation whether or not the depth is dilated to avoid holes and occlusion errors (optional)"},
    {"rescaleDepth", (PyCFunction)pyopencv_cv_rgbd_rescaleDepth, METH_VARARGS | METH_KEYWORDS, "rescaleDepth(in, depth[, out]) -> out\n.   If the input image is of type CV_16UC1 (like the Kinect one), the image is converted to floats, divided\n.   * by 1000 to get a depth in meters, and the values 0 are converted to std::numeric_limits<float>::quiet_NaN()\n.   * Otherwise, the image is simply converted to floats\n.   * @param in the depth image (if given as short int CV_U, it is assumed to be the depth in millimeters\n.   *              (as done with the Microsoft Kinect), it is assumed in meters)\n.   * @param depth the desired output depth (floats or double)\n.   * @param out The rescaled float depth image"},
    {"warpFrame", (PyCFunction)pyopencv_cv_rgbd_warpFrame, METH_VARARGS | METH_KEYWORDS, "warpFrame(image, depth, mask, Rt, cameraMatrix, distCoeff[, warpedImage[, warpedDepth[, warpedMask]]]) -> warpedImage, warpedDepth, warpedMask\n.   Warp the image: compute 3d points from the depth, transform them using given transformation,\n.   * then project color point cloud to an image plane.\n.   * This function can be used to visualize results of the Odometry algorithm.\n.   * @param image The image (of CV_8UC1 or CV_8UC3 type)\n.   * @param depth The depth (of type used in depthTo3d fuction)\n.   * @param mask The mask of used pixels (of CV_8UC1), it can be empty\n.   * @param Rt The transformation that will be applied to the 3d points computed from the depth\n.   * @param cameraMatrix Camera matrix\n.   * @param distCoeff Distortion coefficients\n.   * @param warpedImage The warped image.\n.   * @param warpedDepth The warped depth.\n.   * @param warpedMask The warped mask."},
    {NULL, NULL}
};

static ConstDef consts_rgbd[] = {
    {"DepthCleaner_DEPTH_CLEANER_NIL", cv::rgbd::DepthCleaner::DEPTH_CLEANER_NIL},
    {"DEPTH_CLEANER_DEPTH_CLEANER_NIL", cv::rgbd::DepthCleaner::DEPTH_CLEANER_NIL},
    {"OdometryFrame_CACHE_ALL", cv::rgbd::OdometryFrame::CACHE_ALL},
    {"ODOMETRY_FRAME_CACHE_ALL", cv::rgbd::OdometryFrame::CACHE_ALL},
    {"OdometryFrame_CACHE_DST", cv::rgbd::OdometryFrame::CACHE_DST},
    {"ODOMETRY_FRAME_CACHE_DST", cv::rgbd::OdometryFrame::CACHE_DST},
    {"OdometryFrame_CACHE_SRC", cv::rgbd::OdometryFrame::CACHE_SRC},
    {"ODOMETRY_FRAME_CACHE_SRC", cv::rgbd::OdometryFrame::CACHE_SRC},
    {"Odometry_RIGID_BODY_MOTION", cv::rgbd::Odometry::RIGID_BODY_MOTION},
    {"ODOMETRY_RIGID_BODY_MOTION", cv::rgbd::Odometry::RIGID_BODY_MOTION},
    {"Odometry_ROTATION", cv::rgbd::Odometry::ROTATION},
    {"ODOMETRY_ROTATION", cv::rgbd::Odometry::ROTATION},
    {"Odometry_TRANSLATION", cv::rgbd::Odometry::TRANSLATION},
    {"ODOMETRY_TRANSLATION", cv::rgbd::Odometry::TRANSLATION},
    {"RgbdNormals_RGBD_NORMALS_METHOD_FALS", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_FALS},
    {"RGBD_NORMALS_RGBD_NORMALS_METHOD_FALS", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_FALS},
    {"RgbdNormals_RGBD_NORMALS_METHOD_LINEMOD", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_LINEMOD},
    {"RGBD_NORMALS_RGBD_NORMALS_METHOD_LINEMOD", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_LINEMOD},
    {"RgbdNormals_RGBD_NORMALS_METHOD_SRI", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_SRI},
    {"RGBD_NORMALS_RGBD_NORMALS_METHOD_SRI", cv::rgbd::RgbdNormals::RGBD_NORMALS_METHOD_SRI},
    {"RgbdPlane_RGBD_PLANE_METHOD_DEFAULT", cv::rgbd::RgbdPlane::RGBD_PLANE_METHOD_DEFAULT},
    {"RGBD_PLANE_RGBD_PLANE_METHOD_DEFAULT", cv::rgbd::RgbdPlane::RGBD_PLANE_METHOD_DEFAULT},
    {NULL, 0}
};

static PyMethodDef methods_saliency[] = {
    {"MotionSaliencyBinWangApr2014_create", (PyCFunction)pyopencv_cv_saliency_MotionSaliencyBinWangApr2014_create, METH_VARARGS | METH_KEYWORDS, "MotionSaliencyBinWangApr2014_create() -> retval\n."},
    {"ObjectnessBING_create", (PyCFunction)pyopencv_cv_saliency_ObjectnessBING_create, METH_VARARGS | METH_KEYWORDS, "ObjectnessBING_create() -> retval\n."},
    {"StaticSaliencyFineGrained_create", (PyCFunction)pyopencv_cv_saliency_StaticSaliencyFineGrained_create, METH_VARARGS | METH_KEYWORDS, "StaticSaliencyFineGrained_create() -> retval\n."},
    {"StaticSaliencySpectralResidual_create", (PyCFunction)pyopencv_cv_saliency_StaticSaliencySpectralResidual_create, METH_VARARGS | METH_KEYWORDS, "StaticSaliencySpectralResidual_create() -> retval\n."},
    {NULL, NULL}
};

static ConstDef consts_saliency[] = {
    {NULL, 0}
};

static PyMethodDef methods_structured_light[] = {
    {"GrayCodePattern_create", (PyCFunction)pyopencv_cv_structured_light_GrayCodePattern_create, METH_VARARGS | METH_KEYWORDS, "GrayCodePattern_create(width, height) -> retval\n.   @brief Constructor\n.   @param parameters GrayCodePattern parameters GrayCodePattern::Params: the width and the height of the projector."},
    {"SinusoidalPattern_create", (PyCFunction)pyopencv_cv_structured_light_SinusoidalPattern_create, METH_VARARGS | METH_KEYWORDS, "SinusoidalPattern_create([, parameters]) -> retval\n.   * @brief Constructor.\n.   * @param parameters SinusoidalPattern parameters SinusoidalPattern::Params: width, height of the projector and patterns parameters.\n.   *"},
    {NULL, NULL}
};

static ConstDef consts_structured_light[] = {
    {"DECODE_3D_UNDERWORLD", cv::structured_light::DECODE_3D_UNDERWORLD},
    {"FAPS", cv::structured_light::FAPS},
    {"FTP", cv::structured_light::FTP},
    {"PSP", cv::structured_light::PSP},
    {NULL, 0}
};

static PyMethodDef methods_videostab[] = {
    {NULL, NULL}
};

static ConstDef consts_videostab[] = {
    {"MM_AFFINE", cv::videostab::MM_AFFINE},
    {"MM_HOMOGRAPHY", cv::videostab::MM_HOMOGRAPHY},
    {"MM_RIGID", cv::videostab::MM_RIGID},
    {"MM_ROTATION", cv::videostab::MM_ROTATION},
    {"MM_SIMILARITY", cv::videostab::MM_SIMILARITY},
    {"MM_TRANSLATION", cv::videostab::MM_TRANSLATION},
    {"MM_TRANSLATION_AND_SCALE", cv::videostab::MM_TRANSLATION_AND_SCALE},
    {"MM_UNKNOWN", cv::videostab::MM_UNKNOWN},
    {NULL, 0}
};

static PyMethodDef methods_ximgproc[] = {
    {"AdaptiveManifoldFilter_create", (PyCFunction)pyopencv_cv_ximgproc_AdaptiveManifoldFilter_create, METH_VARARGS | METH_KEYWORDS, "AdaptiveManifoldFilter_create() -> retval\n."},
    {"PeiLinNormalization", (PyCFunction)pyopencv_cv_ximgproc_PeiLinNormalization, METH_VARARGS | METH_KEYWORDS, "PeiLinNormalization(I[, T]) -> T\n.   @overload"},
    {"RidgeDetectionFilter_create", (PyCFunction)pyopencv_cv_ximgproc_RidgeDetectionFilter_create, METH_VARARGS | METH_KEYWORDS, "RidgeDetectionFilter_create([, ddepth[, dx[, dy[, ksize[, out_dtype[, scale[, delta[, borderType]]]]]]]]) -> retval\n.   @brief Create pointer to the Ridge detection filter.\n.   @param ddepth  Specifies output image depth. Defualt is CV_32FC1\n.   @param dx Order of derivative x, default is 1\n.   @param dy  Order of derivative y, default is 1\n.   @param ksize Sobel kernel size , default is 3\n.   @param out_dtype Converted format for output, default is CV_8UC1\n.   @param scale Optional scale value for derivative values, default is 1\n.   @param delta  Optional bias added to output, default is 0\n.   @param borderType Pixel extrapolation method, default is BORDER_DEFAULT\n.   @see Sobel, threshold, getStructuringElement, morphologyEx.( for additional refinement)"},
    {"amFilter", (PyCFunction)pyopencv_cv_ximgproc_amFilter, METH_VARARGS | METH_KEYWORDS, "amFilter(joint, src, sigma_s, sigma_r[, dst[, adjust_outliers]]) -> dst\n.   @brief Simple one-line Adaptive Manifold Filter call.\n.   \n.   @param joint joint (also called as guided) image or array of images with any numbers of channels.\n.   \n.   @param src filtering image with any numbers of channels.\n.   \n.   @param dst output image.\n.   \n.   @param sigma_s spatial standard deviation.\n.   \n.   @param sigma_r color space standard deviation, it is similar to the sigma in the color space into\n.   bilateralFilter.\n.   \n.   @param adjust_outliers optional, specify perform outliers adjust operation or not, (Eq. 9) in the\n.   original paper.\n.   \n.   @note Joint images with CV_8U and CV_16U depth converted to images with CV_32F depth and [0; 1]\n.   color range before processing. Hence color space sigma sigma_r must be in [0; 1] range, unlike same\n.   sigmas in bilateralFilter and dtFilter functions. @sa bilateralFilter, dtFilter, guidedFilter"},
    {"anisotropicDiffusion", (PyCFunction)pyopencv_cv_ximgproc_anisotropicDiffusion, METH_VARARGS | METH_KEYWORDS, "anisotropicDiffusion(src, alpha, K, niters[, dst]) -> dst\n.   @brief Performs anisotropic diffusian on an image.\n.   \n.   The function applies Perona-Malik anisotropic diffusion to an image. This is the solution to the partial differential equation:\n.   \n.   \\f[{\\frac  {\\partial I}{\\partial t}}={\\mathrm  {div}}\\left(c(x,y,t)\\nabla I\\right)=\\nabla c\\cdot \\nabla I+c(x,y,t)\\Delta I\\f]\n.   \n.   Suggested functions for c(x,y,t) are:\n.   \n.   \\f[c\\left(\\|\\nabla I\\|\\right)=e^{{-\\left(\\|\\nabla I\\|/K\\right)^{2}}}\\f]\n.   \n.   or\n.   \n.   \\f[ c\\left(\\|\\nabla I\\|\\right)={\\frac {1}{1+\\left({\\frac  {\\|\\nabla I\\|}{K}}\\right)^{2}}} \\f]\n.   \n.   @param src Grayscale Source image.\n.   @param dst Destination image of the same size and the same number of channels as src .\n.   @param alpha The amount of time to step forward by on each iteration (normally, it's between 0 and 1).\n.   @param K sensitivity to the edges\n.   @param niters The number of iterations"},
    {"bilateralTextureFilter", (PyCFunction)pyopencv_cv_ximgproc_bilateralTextureFilter, METH_VARARGS | METH_KEYWORDS, "bilateralTextureFilter(src[, dst[, fr[, numIter[, sigmaAlpha[, sigmaAvg]]]]]) -> dst\n.   @brief Applies the bilateral texture filter to an image. It performs structure-preserving texture filter.\n.   For more details about this filter see @cite Cho2014.\n.   \n.   @param src Source image whose depth is 8-bit UINT or 32-bit FLOAT\n.   \n.   @param dst Destination image of the same size and type as src.\n.   \n.   @param fr Radius of kernel to be used for filtering. It should be positive integer\n.   \n.   @param numIter Number of iterations of algorithm, It should be positive integer\n.   \n.   @param sigmaAlpha Controls the sharpness of the weight transition from edges to smooth/texture regions, where\n.   a bigger value means sharper transition. When the value is negative, it is automatically calculated.\n.   \n.   @param sigmaAvg Range blur parameter for texture blurring. Larger value makes result to be more blurred. When the\n.   value is negative, it is automatically calculated as described in the paper.\n.   \n.   @sa rollingGuidanceFilter, bilateralFilter"},
    {"contourSampling", (PyCFunction)pyopencv_cv_ximgproc_contourSampling, METH_VARARGS | METH_KEYWORDS, "contourSampling(src, nbElt[, out]) -> out\n.   * @brief   Contour sampling .\n.   *\n.   * @param   src   contour type vector<Point> , vector<Point2f>  or vector<Point2d>\n.   * @param   out   Mat of type CV_64FC2 and nbElt rows\n.   * @param   nbElt number of points in out contour\n.   *"},
    {"covarianceEstimation", (PyCFunction)pyopencv_cv_ximgproc_covarianceEstimation, METH_VARARGS | METH_KEYWORDS, "covarianceEstimation(src, windowRows, windowCols[, dst]) -> dst\n.   @brief Computes the estimated covariance matrix of an image using the sliding\n.   window forumlation.\n.   \n.   @param src The source image. Input image must be of a complex type.\n.   @param dst The destination estimated covariance matrix. Output matrix will be size (windowRows*windowCols, windowRows*windowCols).\n.   @param windowRows The number of rows in the window.\n.   @param windowCols The number of cols in the window.\n.   The window size parameters control the accuracy of the estimation.\n.   The sliding window moves over the entire image from the top-left corner\n.   to the bottom right corner. Each location of the window represents a sample.\n.   If the window is the size of the image, then this gives the exact covariance matrix.\n.   For all other cases, the sizes of the window will impact the number of samples\n.   and the number of elements in the estimated covariance matrix."},
    {"createAMFilter", (PyCFunction)pyopencv_cv_ximgproc_createAMFilter, METH_VARARGS | METH_KEYWORDS, "createAMFilter(sigma_s, sigma_r[, adjust_outliers]) -> retval\n.   @brief Factory method, create instance of AdaptiveManifoldFilter and produce some initialization routines.\n.   \n.   @param sigma_s spatial standard deviation.\n.   \n.   @param sigma_r color space standard deviation, it is similar to the sigma in the color space into\n.   bilateralFilter.\n.   \n.   @param adjust_outliers optional, specify perform outliers adjust operation or not, (Eq. 9) in the\n.   original paper.\n.   \n.   For more details about Adaptive Manifold Filter parameters, see the original article @cite Gastal12 .\n.   \n.   @note Joint images with CV_8U and CV_16U depth converted to images with CV_32F depth and [0; 1]\n.   color range before processing. Hence color space sigma sigma_r must be in [0; 1] range, unlike same\n.   sigmas in bilateralFilter and dtFilter functions."},
    {"createContourFitting", (PyCFunction)pyopencv_cv_ximgproc_createContourFitting, METH_VARARGS | METH_KEYWORDS, "createContourFitting([, ctr[, fd]]) -> retval\n.   * @brief create ContourFitting algorithm object\n.   *\n.   * @param ctr number of Fourier descriptors equal to number of contour points after resampling.\n.   * @param fd Contour defining second shape (Target)."},
    {"createDTFilter", (PyCFunction)pyopencv_cv_ximgproc_createDTFilter, METH_VARARGS | METH_KEYWORDS, "createDTFilter(guide, sigmaSpatial, sigmaColor[, mode[, numIters]]) -> retval\n.   @brief Factory method, create instance of DTFilter and produce initialization routines.\n.   \n.   @param guide guided image (used to build transformed distance, which describes edge structure of\n.   guided image).\n.   \n.   @param sigmaSpatial \\f${\\sigma}_H\\f$ parameter in the original article, it's similar to the sigma in the\n.   coordinate space into bilateralFilter.\n.   \n.   @param sigmaColor \\f${\\sigma}_r\\f$ parameter in the original article, it's similar to the sigma in the\n.   color space into bilateralFilter.\n.   \n.   @param mode one form three modes DTF_NC, DTF_RF and DTF_IC which corresponds to three modes for\n.   filtering 2D signals in the article.\n.   \n.   @param numIters optional number of iterations used for filtering, 3 is quite enough.\n.   \n.   For more details about Domain Transform filter parameters, see the original article @cite Gastal11 and\n.   [Domain Transform filter homepage](http://www.inf.ufrgs.br/~eslgastal/DomainTransform/)."},
    {"createDisparityWLSFilter", (PyCFunction)pyopencv_cv_ximgproc_createDisparityWLSFilter, METH_VARARGS | METH_KEYWORDS, "createDisparityWLSFilter(matcher_left) -> retval\n.   @brief Convenience factory method that creates an instance of DisparityWLSFilter and sets up all the relevant\n.   filter parameters automatically based on the matcher instance. Currently supports only StereoBM and StereoSGBM.\n.   \n.   @param matcher_left stereo matcher instance that will be used with the filter"},
    {"createDisparityWLSFilterGeneric", (PyCFunction)pyopencv_cv_ximgproc_createDisparityWLSFilterGeneric, METH_VARARGS | METH_KEYWORDS, "createDisparityWLSFilterGeneric(use_confidence) -> retval\n.   @brief More generic factory method, create instance of DisparityWLSFilter and execute basic\n.   initialization routines. When using this method you will need to set-up the ROI, matchers and\n.   other parameters by yourself.\n.   \n.   @param use_confidence filtering with confidence requires two disparity maps (for the left and right views) and is\n.   approximately two times slower. However, quality is typically significantly better."},
    {"createEdgeAwareInterpolator", (PyCFunction)pyopencv_cv_ximgproc_createEdgeAwareInterpolator, METH_VARARGS | METH_KEYWORDS, "createEdgeAwareInterpolator() -> retval\n.   @brief Factory method that creates an instance of the\n.   EdgeAwareInterpolator."},
    {"createEdgeBoxes", (PyCFunction)pyopencv_cv_ximgproc_createEdgeBoxes, METH_VARARGS | METH_KEYWORDS, "createEdgeBoxes([, alpha[, beta[, eta[, minScore[, maxBoxes[, edgeMinMag[, edgeMergeThr[, clusterMinMag[, maxAspectRatio[, minBoxArea[, gamma[, kappa]]]]]]]]]]]]) -> retval\n.   @brief Creates a Edgeboxes\n.   \n.   @param alpha step size of sliding window search.\n.   @param beta nms threshold for object proposals.\n.   @param eta adaptation rate for nms threshold.\n.   @param minScore min score of boxes to detect.\n.   @param maxBoxes max number of boxes to detect.\n.   @param edgeMinMag edge min magnitude. Increase to trade off accuracy for speed.\n.   @param edgeMergeThr edge merge threshold. Increase to trade off accuracy for speed.\n.   @param clusterMinMag cluster min magnitude. Increase to trade off accuracy for speed.\n.   @param maxAspectRatio max aspect ratio of boxes.\n.   @param minBoxArea minimum area of boxes.\n.   @param gamma affinity sensitivity.\n.   @param kappa scale sensitivity."},
    {"createFastGlobalSmootherFilter", (PyCFunction)pyopencv_cv_ximgproc_createFastGlobalSmootherFilter, METH_VARARGS | METH_KEYWORDS, "createFastGlobalSmootherFilter(guide, lambda, sigma_color[, lambda_attenuation[, num_iter]]) -> retval\n.   @brief Factory method, create instance of FastGlobalSmootherFilter and execute the initialization routines.\n.   \n.   @param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.\n.   \n.   @param lambda parameter defining the amount of regularization\n.   \n.   @param sigma_color parameter, that is similar to color space sigma in bilateralFilter.\n.   \n.   @param lambda_attenuation internal parameter, defining how much lambda decreases after each iteration. Normally,\n.   it should be 0.25. Setting it to 1.0 may lead to streaking artifacts.\n.   \n.   @param num_iter number of iterations used for filtering, 3 is usually enough.\n.   \n.   For more details about Fast Global Smoother parameters, see the original paper @cite Min2014. However, please note that\n.   there are several differences. Lambda attenuation described in the paper is implemented a bit differently so do not\n.   expect the results to be identical to those from the paper; sigma_color values from the paper should be multiplied by 255.0 to\n.   achieve the same effect. Also, in case of image filtering where source and guide image are the same, authors\n.   propose to dynamically update the guide image after each iteration. To maximize the performance this feature\n.   was not implemented here."},
    {"createFastLineDetector", (PyCFunction)pyopencv_cv_ximgproc_createFastLineDetector, METH_VARARGS | METH_KEYWORDS, "createFastLineDetector([, _length_threshold[, _distance_threshold[, _canny_th1[, _canny_th2[, _canny_aperture_size[, _do_merge]]]]]]) -> retval\n.   @brief Creates a smart pointer to a FastLineDetector object and initializes it\n.   \n.   @param _length_threshold    10         - Segment shorter than this will be discarded\n.   @param _distance_threshold  1.41421356 - A point placed from a hypothesis line\n.   segment farther than this will be\n.   regarded as an outlier\n.   @param _canny_th1           50         - First threshold for\n.   hysteresis procedure in Canny()\n.   @param _canny_th2           50         - Second threshold for\n.   hysteresis procedure in Canny()\n.   @param _canny_aperture_size 3          - Aperturesize for the sobel\n.   operator in Canny()\n.   @param _do_merge            false      - If true, incremental merging of segments\n.   will be perfomred"},
    {"createGuidedFilter", (PyCFunction)pyopencv_cv_ximgproc_createGuidedFilter, METH_VARARGS | METH_KEYWORDS, "createGuidedFilter(guide, radius, eps) -> retval\n.   @brief Factory method, create instance of GuidedFilter and produce initialization routines.\n.   \n.   @param guide guided image (or array of images) with up to 3 channels, if it have more then 3\n.   channels then only first 3 channels will be used.\n.   \n.   @param radius radius of Guided Filter.\n.   \n.   @param eps regularization term of Guided Filter. \\f${eps}^2\\f$ is similar to the sigma in the color\n.   space into bilateralFilter.\n.   \n.   For more details about Guided Filter parameters, see the original article @cite Kaiming10 ."},
    {"createRFFeatureGetter", (PyCFunction)pyopencv_cv_ximgproc_createRFFeatureGetter, METH_VARARGS | METH_KEYWORDS, "createRFFeatureGetter() -> retval\n."},
    {"createRightMatcher", (PyCFunction)pyopencv_cv_ximgproc_createRightMatcher, METH_VARARGS | METH_KEYWORDS, "createRightMatcher(matcher_left) -> retval\n.   @brief Convenience method to set up the matcher for computing the right-view disparity map\n.   that is required in case of filtering with confidence.\n.   \n.   @param matcher_left main stereo matcher instance that will be used with the filter"},
    {"createStructuredEdgeDetection", (PyCFunction)pyopencv_cv_ximgproc_createStructuredEdgeDetection, METH_VARARGS | METH_KEYWORDS, "createStructuredEdgeDetection(model[, howToGetFeatures]) -> retval\n."},
    {"createSuperpixelLSC", (PyCFunction)pyopencv_cv_ximgproc_createSuperpixelLSC, METH_VARARGS | METH_KEYWORDS, "createSuperpixelLSC(image[, region_size[, ratio]]) -> retval\n.   @brief Class implementing the LSC (Linear Spectral Clustering) superpixels\n.   \n.   @param image Image to segment\n.   @param region_size Chooses an average superpixel size measured in pixels\n.   @param ratio Chooses the enforcement of superpixel compactness factor of superpixel\n.   \n.   The function initializes a SuperpixelLSC object for the input image. It sets the parameters of\n.   superpixel algorithm, which are: region_size and ruler. It preallocate some buffers for future\n.   computing iterations over the given image. An example of LSC is ilustrated in the following picture.\n.   For enanched results it is recommended for color images to preprocess image with little gaussian blur\n.   with a small 3 x 3 kernel and additional conversion into CieLAB color space.\n.   \n.   ![image](pics/superpixels_lsc.png)"},
    {"createSuperpixelSEEDS", (PyCFunction)pyopencv_cv_ximgproc_createSuperpixelSEEDS, METH_VARARGS | METH_KEYWORDS, "createSuperpixelSEEDS(image_width, image_height, image_channels, num_superpixels, num_levels[, prior[, histogram_bins[, double_step]]]) -> retval\n.   @brief Initializes a SuperpixelSEEDS object.\n.   \n.   @param image_width Image width.\n.   @param image_height Image height.\n.   @param image_channels Number of channels of the image.\n.   @param num_superpixels Desired number of superpixels. Note that the actual number may be smaller\n.   due to restrictions (depending on the image size and num_levels). Use getNumberOfSuperpixels() to\n.   get the actual number.\n.   @param num_levels Number of block levels. The more levels, the more accurate is the segmentation,\n.   but needs more memory and CPU time.\n.   @param prior enable 3x3 shape smoothing term if \\>0. A larger value leads to smoother shapes. prior\n.   must be in the range [0, 5].\n.   @param histogram_bins Number of histogram bins.\n.   @param double_step If true, iterate each block level twice for higher accuracy.\n.   \n.   The function initializes a SuperpixelSEEDS object for the input image. It stores the parameters of\n.   the image: image_width, image_height and image_channels. It also sets the parameters of the SEEDS\n.   superpixel algorithm, which are: num_superpixels, num_levels, use_prior, histogram_bins and\n.   double_step.\n.   \n.   The number of levels in num_levels defines the amount of block levels that the algorithm use in the\n.   optimization. The initialization is a grid, in which the superpixels are equally distributed through\n.   the width and the height of the image. The larger blocks correspond to the superpixel size, and the\n.   levels with smaller blocks are formed by dividing the larger blocks into 2 x 2 blocks of pixels,\n.   recursively until the smaller block level. An example of initialization of 4 block levels is\n.   illustrated in the following figure.\n.   \n.   ![image](pics/superpixels_blocks.png)"},
    {"createSuperpixelSLIC", (PyCFunction)pyopencv_cv_ximgproc_createSuperpixelSLIC, METH_VARARGS | METH_KEYWORDS, "createSuperpixelSLIC(image[, algorithm[, region_size[, ruler]]]) -> retval\n.   @brief Initialize a SuperpixelSLIC object\n.   \n.   @param image Image to segment\n.   @param algorithm Chooses the algorithm variant to use:\n.   SLIC segments image using a desired region_size, and in addition SLICO will optimize using adaptive compactness factor,\n.   while MSLIC will optimize using manifold methods resulting in more content-sensitive superpixels.\n.   @param region_size Chooses an average superpixel size measured in pixels\n.   @param ruler Chooses the enforcement of superpixel smoothness factor of superpixel\n.   \n.   The function initializes a SuperpixelSLIC object for the input image. It sets the parameters of choosed\n.   superpixel algorithm, which are: region_size and ruler. It preallocate some buffers for future\n.   computing iterations over the given image. For enanched results it is recommended for color images to\n.   preprocess image with little gaussian blur using a small 3 x 3 kernel and additional conversion into\n.   CieLAB color space. An example of SLIC versus SLICO and MSLIC is ilustrated in the following picture.\n.   \n.   ![image](pics/superpixels_slic.png)"},
    {"dtFilter", (PyCFunction)pyopencv_cv_ximgproc_dtFilter, METH_VARARGS | METH_KEYWORDS, "dtFilter(guide, src, sigmaSpatial, sigmaColor[, dst[, mode[, numIters]]]) -> dst\n.   @brief Simple one-line Domain Transform filter call. If you have multiple images to filter with the same\n.   guided image then use DTFilter interface to avoid extra computations on initialization stage.\n.   \n.   @param guide guided image (also called as joint image) with unsigned 8-bit or floating-point 32-bit\n.   depth and up to 4 channels.\n.   @param src filtering image with unsigned 8-bit or floating-point 32-bit depth and up to 4 channels.\n.   @param dst\n.   @param sigmaSpatial \\f${\\sigma}_H\\f$ parameter in the original article, it's similar to the sigma in the\n.   coordinate space into bilateralFilter.\n.   @param sigmaColor \\f${\\sigma}_r\\f$ parameter in the original article, it's similar to the sigma in the\n.   color space into bilateralFilter.\n.   @param mode one form three modes DTF_NC, DTF_RF and DTF_IC which corresponds to three modes for\n.   filtering 2D signals in the article.\n.   @param numIters optional number of iterations used for filtering, 3 is quite enough.\n.   @sa bilateralFilter, guidedFilter, amFilter"},
    {"fastGlobalSmootherFilter", (PyCFunction)pyopencv_cv_ximgproc_fastGlobalSmootherFilter, METH_VARARGS | METH_KEYWORDS, "fastGlobalSmootherFilter(guide, src, lambda, sigma_color[, dst[, lambda_attenuation[, num_iter]]]) -> dst\n.   @brief Simple one-line Fast Global Smoother filter call. If you have multiple images to filter with the same\n.   guide then use FastGlobalSmootherFilter interface to avoid extra computations.\n.   \n.   @param guide image serving as guide for filtering. It should have 8-bit depth and either 1 or 3 channels.\n.   \n.   @param src source image for filtering with unsigned 8-bit or signed 16-bit or floating-point 32-bit depth and up to 4 channels.\n.   \n.   @param dst destination image.\n.   \n.   @param lambda parameter defining the amount of regularization\n.   \n.   @param sigma_color parameter, that is similar to color space sigma in bilateralFilter.\n.   \n.   @param lambda_attenuation internal parameter, defining how much lambda decreases after each iteration. Normally,\n.   it should be 0.25. Setting it to 1.0 may lead to streaking artifacts.\n.   \n.   @param num_iter number of iterations used for filtering, 3 is usually enough."},
    {"fourierDescriptor", (PyCFunction)pyopencv_cv_ximgproc_fourierDescriptor, METH_VARARGS | METH_KEYWORDS, "fourierDescriptor(src[, dst[, nbElt[, nbFD]]]) -> dst\n.   * @brief   Fourier descriptors for planed closed curves\n.   *\n.   * For more details about this implementation, please see @cite PersoonFu1977\n.   *\n.   * @param   src   contour type vector<Point> , vector<Point2f>  or vector<Point2d>\n.   * @param   dst   Mat of type CV_64FC2 and nbElt rows A VERIFIER\n.   * @param   nbElt number of rows in dst or getOptimalDFTSize rows if nbElt=-1\n.   * @param   nbFD number of FD return in dst dst = [FD(1...nbFD/2) FD(nbFD/2-nbElt+1...:nbElt)]\n.   *"},
    {"guidedFilter", (PyCFunction)pyopencv_cv_ximgproc_guidedFilter, METH_VARARGS | METH_KEYWORDS, "guidedFilter(guide, src, radius, eps[, dst[, dDepth]]) -> dst\n.   @brief Simple one-line Guided Filter call.\n.   \n.   If you have multiple images to filter with the same guided image then use GuidedFilter interface to\n.   avoid extra computations on initialization stage.\n.   \n.   @param guide guided image (or array of images) with up to 3 channels, if it have more then 3\n.   channels then only first 3 channels will be used.\n.   \n.   @param src filtering image with any numbers of channels.\n.   \n.   @param dst output image.\n.   \n.   @param radius radius of Guided Filter.\n.   \n.   @param eps regularization term of Guided Filter. \\f${eps}^2\\f$ is similar to the sigma in the color\n.   space into bilateralFilter.\n.   \n.   @param dDepth optional depth of the output image.\n.   \n.   @sa bilateralFilter, dtFilter, amFilter"},
    {"jointBilateralFilter", (PyCFunction)pyopencv_cv_ximgproc_jointBilateralFilter, METH_VARARGS | METH_KEYWORDS, "jointBilateralFilter(joint, src, d, sigmaColor, sigmaSpace[, dst[, borderType]]) -> dst\n.   @brief Applies the joint bilateral filter to an image.\n.   \n.   @param joint Joint 8-bit or floating-point, 1-channel or 3-channel image.\n.   \n.   @param src Source 8-bit or floating-point, 1-channel or 3-channel image with the same depth as joint\n.   image.\n.   \n.   @param dst Destination image of the same size and type as src .\n.   \n.   @param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,\n.   it is computed from sigmaSpace .\n.   \n.   @param sigmaColor Filter sigma in the color space. A larger value of the parameter means that\n.   farther colors within the pixel neighborhood (see sigmaSpace ) will be mixed together, resulting in\n.   larger areas of semi-equal color.\n.   \n.   @param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that\n.   farther pixels will influence each other as long as their colors are close enough (see sigmaColor ).\n.   When d\\>0 , it specifies the neighborhood size regardless of sigmaSpace . Otherwise, d is\n.   proportional to sigmaSpace .\n.   \n.   @param borderType\n.   \n.   @note bilateralFilter and jointBilateralFilter use L1 norm to compute difference between colors.\n.   \n.   @sa bilateralFilter, amFilter"},
    {"l0Smooth", (PyCFunction)pyopencv_cv_ximgproc_l0Smooth, METH_VARARGS | METH_KEYWORDS, "l0Smooth(src[, dst[, lambda[, kappa]]]) -> dst\n.   @brief Global image smoothing via L0 gradient minimization.\n.   \n.   @param src source image for filtering with unsigned 8-bit or signed 16-bit or floating-point depth.\n.   \n.   @param dst destination image.\n.   \n.   @param lambda parameter defining the smooth term weight.\n.   \n.   @param kappa parameter defining the increasing factor of the weight of the gradient data term.\n.   \n.   For more details about L0 Smoother, see the original paper @cite xu2011image."},
    {"niBlackThreshold", (PyCFunction)pyopencv_cv_ximgproc_niBlackThreshold, METH_VARARGS | METH_KEYWORDS, "niBlackThreshold(_src, maxValue, type, blockSize, k[, _dst[, binarizationMethod]]) -> _dst\n.   @brief Performs thresholding on input images using Niblack's technique or some of the\n.   popular variations it inspired.\n.   \n.   The function transforms a grayscale image to a binary image according to the formulae:\n.   -   **THRESH_BINARY**\n.   \\f[dst(x,y) =  \\fork{\\texttt{maxValue}}{if \\(src(x,y) > T(x,y)\\)}{0}{otherwise}\\f]\n.   -   **THRESH_BINARY_INV**\n.   \\f[dst(x,y) =  \\fork{0}{if \\(src(x,y) > T(x,y)\\)}{\\texttt{maxValue}}{otherwise}\\f]\n.   where \\f$T(x,y)\\f$ is a threshold calculated individually for each pixel.\n.   \n.   The threshold value \\f$T(x, y)\\f$ is determined based on the binarization method chosen. For\n.   classic Niblack, it is the mean minus \\f$ k \\f$ times standard deviation of\n.   \\f$\\texttt{blockSize} \\times\\texttt{blockSize}\\f$ neighborhood of \\f$(x, y)\\f$.\n.   \n.   The function can't process the image in-place.\n.   \n.   @param _src Source 8-bit single-channel image.\n.   @param _dst Destination image of the same size and the same type as src.\n.   @param maxValue Non-zero value assigned to the pixels for which the condition is satisfied,\n.   used with the THRESH_BINARY and THRESH_BINARY_INV thresholding types.\n.   @param type Thresholding type, see cv::ThresholdTypes.\n.   @param blockSize Size of a pixel neighborhood that is used to calculate a threshold value\n.   for the pixel: 3, 5, 7, and so on.\n.   @param k The user-adjustable parameter used by Niblack and inspired techniques. For Niblack, this is\n.   normally a value between 0 and 1 that is multiplied with the standard deviation and subtracted from\n.   the mean.\n.   @param binarizationMethod Binarization method to use. By default, Niblack's technique is used.\n.   Other techniques can be specified, see cv::ximgproc::LocalBinarizationMethods.\n.   \n.   @sa  threshold, adaptiveThreshold"},
    {"rollingGuidanceFilter", (PyCFunction)pyopencv_cv_ximgproc_rollingGuidanceFilter, METH_VARARGS | METH_KEYWORDS, "rollingGuidanceFilter(src[, dst[, d[, sigmaColor[, sigmaSpace[, numOfIter[, borderType]]]]]]) -> dst\n.   @brief Applies the rolling guidance filter to an image.\n.   \n.   For more details, please see @cite zhang2014rolling\n.   \n.   @param src Source 8-bit or floating-point, 1-channel or 3-channel image.\n.   \n.   @param dst Destination image of the same size and type as src.\n.   \n.   @param d Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,\n.   it is computed from sigmaSpace .\n.   \n.   @param sigmaColor Filter sigma in the color space. A larger value of the parameter means that\n.   farther colors within the pixel neighborhood (see sigmaSpace ) will be mixed together, resulting in\n.   larger areas of semi-equal color.\n.   \n.   @param sigmaSpace Filter sigma in the coordinate space. A larger value of the parameter means that\n.   farther pixels will influence each other as long as their colors are close enough (see sigmaColor ).\n.   When d\\>0 , it specifies the neighborhood size regardless of sigmaSpace . Otherwise, d is\n.   proportional to sigmaSpace .\n.   \n.   @param numOfIter Number of iterations of joint edge-preserving filtering applied on the source image.\n.   \n.   @param borderType\n.   \n.   @note  rollingGuidanceFilter uses jointBilateralFilter as the edge-preserving filter.\n.   \n.   @sa jointBilateralFilter, bilateralFilter, amFilter"},
    {"thinning", (PyCFunction)pyopencv_cv_ximgproc_thinning, METH_VARARGS | METH_KEYWORDS, "thinning(src[, dst[, thinningType]]) -> dst\n.   @brief Applies a binary blob thinning operation, to achieve a skeletization of the input image.\n.   \n.   The function transforms a binary blob image into a skeletized form using the technique of Zhang-Suen.\n.   \n.   @param src Source 8-bit single-channel image, containing binary blobs, with blobs having 255 pixel values.\n.   @param dst Destination image of the same size and the same type as src. The function can work in-place.\n.   @param thinningType Value that defines which thinning algorithm should be used. See cv::ximgproc::ThinningTypes"},
    {"transformFD", (PyCFunction)pyopencv_cv_ximgproc_transformFD, METH_VARARGS | METH_KEYWORDS, "transformFD(src, t[, dst[, fdContour]]) -> dst\n.   * @brief   transform a contour\n.   *\n.   * @param   src   contour or Fourier Descriptors if fd is true\n.   * @param   t   transform Mat given by estimateTransformation\n.   * @param   dst   Mat of type CV_64FC2 and nbElt rows\n.   * @param   fdContour true src are Fourier Descriptors. fdContour false src is a contour\n.   *"},
    {"weightedMedianFilter", (PyCFunction)pyopencv_cv_ximgproc_weightedMedianFilter, METH_VARARGS | METH_KEYWORDS, "weightedMedianFilter(joint, src, r[, dst[, sigma[, weightType[, mask]]]]) -> dst\n.   * @brief   Applies weighted median filter to an image.\n.   *\n.   * For more details about this implementation, please see @cite zhang2014100+\n.   *\n.   * @param   joint       Joint 8-bit, 1-channel or 3-channel image.\n.   * @param   src         Source 8-bit or floating-point, 1-channel or 3-channel image.\n.   * @param   dst         Destination image.\n.   * @param   r           Radius of filtering kernel, should be a positive integer.\n.   * @param   sigma       Filter range standard deviation for the joint image.\n.   * @param   weightType  weightType The type of weight definition, see WMFWeightType\n.   * @param   mask        A 0-1 mask that has the same size with I. This mask is used to ignore the effect of some pixels. If the pixel value on mask is 0,\n.   *                           the pixel will be ignored when maintaining the joint-histogram. This is useful for applications like optical flow occlusion handling.\n.   *\n.   * @sa medianBlur, jointBilateralFilter"},
    {NULL, NULL}
};

static ConstDef consts_ximgproc[] = {
    {"AM_FILTER", cv::ximgproc::AM_FILTER},
    {"ARO_0_45", cv::ximgproc::ARO_0_45},
    {"ARO_315_0", cv::ximgproc::ARO_315_0},
    {"ARO_315_135", cv::ximgproc::ARO_315_135},
    {"ARO_315_45", cv::ximgproc::ARO_315_45},
    {"ARO_45_135", cv::ximgproc::ARO_45_135},
    {"ARO_45_90", cv::ximgproc::ARO_45_90},
    {"ARO_90_135", cv::ximgproc::ARO_90_135},
    {"ARO_CTR_HOR", cv::ximgproc::ARO_CTR_HOR},
    {"ARO_CTR_VER", cv::ximgproc::ARO_CTR_VER},
    {"BINARIZATION_NIBLACK", cv::ximgproc::BINARIZATION_NIBLACK},
    {"BINARIZATION_NICK", cv::ximgproc::BINARIZATION_NICK},
    {"BINARIZATION_SAUVOLA", cv::ximgproc::BINARIZATION_SAUVOLA},
    {"BINARIZATION_WOLF", cv::ximgproc::BINARIZATION_WOLF},
    {"DTF_IC", cv::ximgproc::DTF_IC},
    {"DTF_NC", cv::ximgproc::DTF_NC},
    {"DTF_RF", cv::ximgproc::DTF_RF},
    {"FHT_ADD", cv::ximgproc::FHT_ADD},
    {"FHT_AVE", cv::ximgproc::FHT_AVE},
    {"FHT_MAX", cv::ximgproc::FHT_MAX},
    {"FHT_MIN", cv::ximgproc::FHT_MIN},
    {"GUIDED_FILTER", cv::ximgproc::GUIDED_FILTER},
    {"HDO_DESKEW", cv::ximgproc::HDO_DESKEW},
    {"HDO_RAW", cv::ximgproc::HDO_RAW},
    {"MSLIC", cv::ximgproc::MSLIC},
    {"SLIC", cv::ximgproc::SLIC},
    {"SLICO", cv::ximgproc::SLICO},
    {"THINNING_GUOHALL", cv::ximgproc::THINNING_GUOHALL},
    {"THINNING_ZHANGSUEN", cv::ximgproc::THINNING_ZHANGSUEN},
    {"WMF_COS", cv::ximgproc::WMF_COS},
    {"WMF_EXP", cv::ximgproc::WMF_EXP},
    {"WMF_IV1", cv::ximgproc::WMF_IV1},
    {"WMF_IV2", cv::ximgproc::WMF_IV2},
    {"WMF_JAC", cv::ximgproc::WMF_JAC},
    {"WMF_OFF", cv::ximgproc::WMF_OFF},
    {NULL, 0}
};

static PyMethodDef methods_ximgproc_segmentation[] = {
    {"createGraphSegmentation", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createGraphSegmentation, METH_VARARGS | METH_KEYWORDS, "createGraphSegmentation([, sigma[, k[, min_size]]]) -> retval\n.   @brief Creates a graph based segmentor\n.   @param sigma The sigma parameter, used to smooth image\n.   @param k The k parameter of the algorythm\n.   @param min_size The minimum size of segments"},
    {"createSelectiveSearchSegmentation", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentation, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentation() -> retval\n.   @brief Create a new SelectiveSearchSegmentation class."},
    {"createSelectiveSearchSegmentationStrategyColor", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyColor, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentationStrategyColor() -> retval\n.   @brief Create a new color-based strategy"},
    {"createSelectiveSearchSegmentationStrategyFill", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyFill, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentationStrategyFill() -> retval\n.   @brief Create a new fill-based strategy"},
    {"createSelectiveSearchSegmentationStrategyMultiple", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyMultiple, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentationStrategyMultiple() -> retval\n.   @brief Create a new multiple strategy\n\n\n\ncreateSelectiveSearchSegmentationStrategyMultiple(s1) -> retval\n.   @brief Create a new multiple strategy and set one subtrategy\n.   @param s1 The first strategy\n\n\n\ncreateSelectiveSearchSegmentationStrategyMultiple(s1, s2) -> retval\n.   @brief Create a new multiple strategy and set two subtrategies, with equal weights\n.   @param s1 The first strategy\n.   @param s2 The second strategy\n\n\n\ncreateSelectiveSearchSegmentationStrategyMultiple(s1, s2, s3) -> retval\n.   @brief Create a new multiple strategy and set three subtrategies, with equal weights\n.   @param s1 The first strategy\n.   @param s2 The second strategy\n.   @param s3 The third strategy\n\n\n\ncreateSelectiveSearchSegmentationStrategyMultiple(s1, s2, s3, s4) -> retval\n.   @brief Create a new multiple strategy and set four subtrategies, with equal weights\n.   @param s1 The first strategy\n.   @param s2 The second strategy\n.   @param s3 The third strategy\n.   @param s4 The forth strategy"},
    {"createSelectiveSearchSegmentationStrategySize", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategySize, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentationStrategySize() -> retval\n.   @brief Create a new size-based strategy"},
    {"createSelectiveSearchSegmentationStrategyTexture", (PyCFunction)pyopencv_cv_ximgproc_segmentation_createSelectiveSearchSegmentationStrategyTexture, METH_VARARGS | METH_KEYWORDS, "createSelectiveSearchSegmentationStrategyTexture() -> retval\n.   @brief Create a new size-based strategy"},
    {NULL, NULL}
};

static ConstDef consts_ximgproc_segmentation[] = {
    {NULL, 0}
};

static PyMethodDef methods_xphoto[] = {
    {"applyChannelGains", (PyCFunction)pyopencv_cv_xphoto_applyChannelGains, METH_VARARGS | METH_KEYWORDS, "applyChannelGains(src, gainB, gainG, gainR[, dst]) -> dst\n.   @brief Implements an efficient fixed-point approximation for applying channel gains, which is\n.   the last step of multiple white balance algorithms.\n.   \n.   @param src Input three-channel image in the BGR color space (either CV_8UC3 or CV_16UC3)\n.   @param dst Output image of the same size and type as src.\n.   @param gainB gain for the B channel\n.   @param gainG gain for the G channel\n.   @param gainR gain for the R channel"},
    {"bm3dDenoising", (PyCFunction)pyopencv_cv_xphoto_bm3dDenoising, METH_VARARGS | METH_KEYWORDS, "bm3dDenoising(src, dstStep1[, dstStep2[, h[, templateWindowSize[, searchWindowSize[, blockMatchingStep1[, blockMatchingStep2[, groupSize[, slidingStep[, beta[, normType[, step[, transformType]]]]]]]]]]]]) -> dstStep1, dstStep2\n.   @brief Performs image denoising using the Block-Matching and 3D-filtering algorithm\n.   <http://www.cs.tut.fi/~foi/GCF-BM3D/BM3D_TIP_2007.pdf> with several computational\n.   optimizations. Noise expected to be a gaussian white noise.\n.   \n.   @param src Input 8-bit or 16-bit 1-channel image.\n.   @param dstStep1 Output image of the first step of BM3D with the same size and type as src.\n.   @param dstStep2 Output image of the second step of BM3D with the same size and type as src.\n.   @param h Parameter regulating filter strength. Big h value perfectly removes noise but also\n.   removes image details, smaller h value preserves details but also preserves some noise.\n.   @param templateWindowSize Size in pixels of the template patch that is used for block-matching.\n.   Should be power of 2.\n.   @param searchWindowSize Size in pixels of the window that is used to perform block-matching.\n.   Affect performance linearly: greater searchWindowsSize - greater denoising time.\n.   Must be larger than templateWindowSize.\n.   @param blockMatchingStep1 Block matching threshold for the first step of BM3D (hard thresholding),\n.   i.e. maximum distance for which two blocks are considered similar.\n.   Value expressed in euclidean distance.\n.   @param blockMatchingStep2 Block matching threshold for the second step of BM3D (Wiener filtering),\n.   i.e. maximum distance for which two blocks are considered similar.\n.   Value expressed in euclidean distance.\n.   @param groupSize Maximum size of the 3D group for collaborative filtering.\n.   @param slidingStep Sliding step to process every next reference block.\n.   @param beta Kaiser window parameter that affects the sidelobe attenuation of the transform of the\n.   window. Kaiser window is used in order to reduce border effects. To prevent usage of the window,\n.   set beta to zero.\n.   @param normType Norm used to calculate distance between blocks. L2 is slower than L1\n.   but yields more accurate results.\n.   @param step Step of BM3D to be executed. Possible variants are: step 1, step 2, both steps.\n.   @param transformType Type of the orthogonal transform used in collaborative filtering step.\n.   Currently only Haar transform is supported.\n.   \n.   This function expected to be applied to grayscale images. Advanced usage of this function\n.   can be manual denoising of colored image in different colorspaces.\n.   \n.   @sa\n.   fastNlMeansDenoising\n\n\n\nbm3dDenoising(src[, dst[, h[, templateWindowSize[, searchWindowSize[, blockMatchingStep1[, blockMatchingStep2[, groupSize[, slidingStep[, beta[, normType[, step[, transformType]]]]]]]]]]]]) -> dst\n.   @brief Performs image denoising using the Block-Matching and 3D-filtering algorithm\n.   <http://www.cs.tut.fi/~foi/GCF-BM3D/BM3D_TIP_2007.pdf> with several computational\n.   optimizations. Noise expected to be a gaussian white noise.\n.   \n.   @param src Input 8-bit or 16-bit 1-channel image.\n.   @param dst Output image with the same size and type as src.\n.   @param h Parameter regulating filter strength. Big h value perfectly removes noise but also\n.   removes image details, smaller h value preserves details but also preserves some noise.\n.   @param templateWindowSize Size in pixels of the template patch that is used for block-matching.\n.   Should be power of 2.\n.   @param searchWindowSize Size in pixels of the window that is used to perform block-matching.\n.   Affect performance linearly: greater searchWindowsSize - greater denoising time.\n.   Must be larger than templateWindowSize.\n.   @param blockMatchingStep1 Block matching threshold for the first step of BM3D (hard thresholding),\n.   i.e. maximum distance for which two blocks are considered similar.\n.   Value expressed in euclidean distance.\n.   @param blockMatchingStep2 Block matching threshold for the second step of BM3D (Wiener filtering),\n.   i.e. maximum distance for which two blocks are considered similar.\n.   Value expressed in euclidean distance.\n.   @param groupSize Maximum size of the 3D group for collaborative filtering.\n.   @param slidingStep Sliding step to process every next reference block.\n.   @param beta Kaiser window parameter that affects the sidelobe attenuation of the transform of the\n.   window. Kaiser window is used in order to reduce border effects. To prevent usage of the window,\n.   set beta to zero.\n.   @param normType Norm used to calculate distance between blocks. L2 is slower than L1\n.   but yields more accurate results.\n.   @param step Step of BM3D to be executed. Allowed are only BM3D_STEP1 and BM3D_STEPALL.\n.   BM3D_STEP2 is not allowed as it requires basic estimate to be present.\n.   @param transformType Type of the orthogonal transform used in collaborative filtering step.\n.   Currently only Haar transform is supported.\n.   \n.   This function expected to be applied to grayscale images. Advanced usage of this function\n.   can be manual denoising of colored image in different colorspaces.\n.   \n.   @sa\n.   fastNlMeansDenoising"},
    {"createGrayworldWB", (PyCFunction)pyopencv_cv_xphoto_createGrayworldWB, METH_VARARGS | METH_KEYWORDS, "createGrayworldWB() -> retval\n.   @brief Creates an instance of GrayworldWB"},
    {"createLearningBasedWB", (PyCFunction)pyopencv_cv_xphoto_createLearningBasedWB, METH_VARARGS | METH_KEYWORDS, "createLearningBasedWB([, path_to_model]) -> retval\n.   @brief Creates an instance of LearningBasedWB\n.   \n.   @param path_to_model Path to a .yml file with the model. If not specified, the default model is used"},
    {"createSimpleWB", (PyCFunction)pyopencv_cv_xphoto_createSimpleWB, METH_VARARGS | METH_KEYWORDS, "createSimpleWB() -> retval\n.   @brief Creates an instance of SimpleWB"},
    {"dctDenoising", (PyCFunction)pyopencv_cv_xphoto_dctDenoising, METH_VARARGS | METH_KEYWORDS, "dctDenoising(src, dst, sigma[, psize]) -> None\n.   @brief The function implements simple dct-based denoising\n.   \n.   <http://www.ipol.im/pub/art/2011/ys-dct/>.\n.   @param src source image\n.   @param dst destination image\n.   @param sigma expected noise standard deviation\n.   @param psize size of block side where dct is computed\n.   \n.   @sa\n.   fastNlMeansDenoising"},
    {"inpaint", (PyCFunction)pyopencv_cv_xphoto_inpaint, METH_VARARGS | METH_KEYWORDS, "inpaint(src, mask, dst, algorithmType) -> None\n.   @brief The function implements different single-image inpainting algorithms.\n.   \n.   See the original paper @cite He2012 for details.\n.   \n.   @param src source image, it could be of any type and any number of channels from 1 to 4. In case of\n.   3- and 4-channels images the function expect them in CIELab colorspace or similar one, where first\n.   color component shows intensity, while second and third shows colors. Nonetheless you can try any\n.   colorspaces.\n.   @param mask mask (CV_8UC1), where non-zero pixels indicate valid image area, while zero pixels\n.   indicate area to be inpainted\n.   @param dst destination image\n.   @param algorithmType see xphoto::InpaintTypes"},
    {NULL, NULL}
};

static ConstDef consts_xphoto[] = {
    {"BM3D_STEP1", cv::xphoto::BM3D_STEP1},
    {"BM3D_STEP2", cv::xphoto::BM3D_STEP2},
    {"BM3D_STEPALL", cv::xphoto::BM3D_STEPALL},
    {"HAAR", cv::xphoto::HAAR},
    {"INPAINT_SHIFTMAP", cv::xphoto::INPAINT_SHIFTMAP},
    {NULL, 0}
};

static void init_submodules(PyObject * root) 
{
  init_submodule(root, MODULESTR"", methods_cv, consts_cv);
  init_submodule(root, MODULESTR".Error", methods_Error, consts_Error);
  init_submodule(root, MODULESTR".aruco", methods_aruco, consts_aruco);
  init_submodule(root, MODULESTR".bgsegm", methods_bgsegm, consts_bgsegm);
  init_submodule(root, MODULESTR".bioinspired", methods_bioinspired, consts_bioinspired);
  init_submodule(root, MODULESTR".datasets", methods_datasets, consts_datasets);
  init_submodule(root, MODULESTR".detail", methods_detail, consts_detail);
  init_submodule(root, MODULESTR".face", methods_face, consts_face);
  init_submodule(root, MODULESTR".fisheye", methods_fisheye, consts_fisheye);
  init_submodule(root, MODULESTR".flann", methods_flann, consts_flann);
  init_submodule(root, MODULESTR".freetype", methods_freetype, consts_freetype);
  init_submodule(root, MODULESTR".ft", methods_ft, consts_ft);
  init_submodule(root, MODULESTR".hdf", methods_hdf, consts_hdf);
  init_submodule(root, MODULESTR".hfs", methods_hfs, consts_hfs);
  init_submodule(root, MODULESTR".img_hash", methods_img_hash, consts_img_hash);
  init_submodule(root, MODULESTR".instr", methods_instr, consts_instr);
  init_submodule(root, MODULESTR".ipp", methods_ipp, consts_ipp);
  init_submodule(root, MODULESTR".line_descriptor", methods_line_descriptor, consts_line_descriptor);
  init_submodule(root, MODULESTR".linemod", methods_linemod, consts_linemod);
  init_submodule(root, MODULESTR".ml", methods_ml, consts_ml);
  init_submodule(root, MODULESTR".motempl", methods_motempl, consts_motempl);
  init_submodule(root, MODULESTR".multicalib", methods_multicalib, consts_multicalib);
  init_submodule(root, MODULESTR".ocl", methods_ocl, consts_ocl);
  init_submodule(root, MODULESTR".ogl", methods_ogl, consts_ogl);
  init_submodule(root, MODULESTR".omnidir", methods_omnidir, consts_omnidir);
  init_submodule(root, MODULESTR".optflow", methods_optflow, consts_optflow);
  init_submodule(root, MODULESTR".plot", methods_plot, consts_plot);
  init_submodule(root, MODULESTR".ppf_match_3d", methods_ppf_match_3d, consts_ppf_match_3d);
  init_submodule(root, MODULESTR".reg", methods_reg, consts_reg);
  init_submodule(root, MODULESTR".rgbd", methods_rgbd, consts_rgbd);
  init_submodule(root, MODULESTR".saliency", methods_saliency, consts_saliency);
  init_submodule(root, MODULESTR".structured_light", methods_structured_light, consts_structured_light);
  init_submodule(root, MODULESTR".videostab", methods_videostab, consts_videostab);
  init_submodule(root, MODULESTR".ximgproc", methods_ximgproc, consts_ximgproc);
  init_submodule(root, MODULESTR".ximgproc.segmentation", methods_ximgproc_segmentation, consts_ximgproc_segmentation);
  init_submodule(root, MODULESTR".xphoto", methods_xphoto, consts_xphoto);
};
