/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000000001dc;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000000001dc;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000000ff24;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000000ff24;
  __m256i_out = __lasx_xvssub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op0[2]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op0[1]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op0[0]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_result[2]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_result[1]) = 0x2020202020202020;
  *((unsigned long *)&__m256i_result[0]) = 0x2020202020202020;
  __m256i_out = __lasx_xvssub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000430207f944;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000430207f944;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x000000bdfef907bc;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x000000bdfef907bc;
  __m256i_out = __lasx_xvssub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op0[2]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op0[0]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op1[2]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000010101010101;
  *((unsigned long *)&__m256i_op1[0]) = 0x0101000000010000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000080;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000040;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000000ff80;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000000ffc0;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x2b2b2b2b1bd68080;
  *((unsigned long *)&__m256i_op1[2]) = 0x2a2ad4d4f2d8807e;
  *((unsigned long *)&__m256i_op1[1]) = 0x2b2b2b2b1bd68080;
  *((unsigned long *)&__m256i_op1[0]) = 0x2a2ad4d4f2d8807e;
  *((unsigned long *)&__m256i_result[3]) = 0xd4d5d4d5e42a7f80;
  *((unsigned long *)&__m256i_result[2]) = 0xd5d62b2c0d287f82;
  *((unsigned long *)&__m256i_result[1]) = 0xd4d5d4d5e42a7f80;
  *((unsigned long *)&__m256i_result[0]) = 0xd5d62b2c0d287f82;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op0[2]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op0[1]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op0[0]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000080000001;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffff07b4ffff0707;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000b8070000a787;
  *((unsigned long *)&__m256i_op0[1]) = 0xffff07b4ffff0707;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000b8070000a787;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000504fffff3271;
  *((unsigned long *)&__m256i_op1[2]) = 0xffff47b4ffff5879;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000504fffff3271;
  *((unsigned long *)&__m256i_op1[0]) = 0xffff47b4ffff5879;
  *((unsigned long *)&__m256i_result[3]) = 0xffffb7650000d496;
  *((unsigned long *)&__m256i_result[2]) = 0x0001800000018000;
  *((unsigned long *)&__m256i_result[1]) = 0xffffb7650000d496;
  *((unsigned long *)&__m256i_result[0]) = 0x0001800000018000;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fff7fff00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fff7fff00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000fc300000fc40;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000fc300000fc40;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff000003c0;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fff7fff000003c0;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff81001dff9dff9e;
  *((unsigned long *)&__m256i_op0[2]) = 0xff81001dff9d003b;
  *((unsigned long *)&__m256i_op0[1]) = 0xff81001dff9dff9e;
  *((unsigned long *)&__m256i_op0[0]) = 0xff81001dff9d003b;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xff81001dff9dff9e;
  *((unsigned long *)&__m256i_result[2]) = 0xff81001dff9d003b;
  *((unsigned long *)&__m256i_result[1]) = 0xff81001dff9dff9e;
  *((unsigned long *)&__m256i_result[0]) = 0xff81001dff9d003b;
  __m256i_out = __lasx_xvssub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000000001fffe;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000001fffe;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000000001fffe;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000000001fffe;
  *((unsigned long *)&__m256i_result[3]) = 0x00ff00ff00fd0101;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff00ff00fd0101;
  *((unsigned long *)&__m256i_result[1]) = 0x00ff00ff00fd0101;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff00ff00fd0101;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000100000001;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x40f69fe73c26f4ee;
  *((unsigned long *)&__m256i_op0[2]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x40f69fe73c26f4ee;
  *((unsigned long *)&__m256i_op0[0]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000001fffffff9;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000001fffffff9;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000001fffffff9;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000001fffffff9;
  *((unsigned long *)&__m256i_result[3]) = 0x40f69fe63c26f4f5;
  *((unsigned long *)&__m256i_result[2]) = 0x7ff7ffff00000007;
  *((unsigned long *)&__m256i_result[1]) = 0x40f69fe63c26f4f5;
  *((unsigned long *)&__m256i_result[0]) = 0x7ff7ffff00000007;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffff00ffff8000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffff00ffff8000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x000000ff00007fff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x000000ff00007fff;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000001010800;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000001010800;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xfffffffffefef800;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xfffffffffefef800;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x007f0000007f0060;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x007f0000007f0060;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x007f0000007f0060;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x007f0000007f0060;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x4393a0a5bc606060;
  *((unsigned long *)&__m256i_op0[2]) = 0x43b32feea9000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x4393a0a5bc606060;
  *((unsigned long *)&__m256i_op0[0]) = 0x43b32feea9000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x3eab77367fff4848;
  *((unsigned long *)&__m256i_op1[2]) = 0x408480007fff0000;
  *((unsigned long *)&__m256i_op1[1]) = 0x3eab77367fff4848;
  *((unsigned long *)&__m256i_op1[0]) = 0x408480007fff0000;
  *((unsigned long *)&__m256i_result[3]) = 0x04e8296f3c611818;
  *((unsigned long *)&__m256i_result[2]) = 0x032eafee29010000;
  *((unsigned long *)&__m256i_result[1]) = 0x04e8296f3c611818;
  *((unsigned long *)&__m256i_result[0]) = 0x032eafee29010000;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0001ff91ff100000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0001ff91ff100000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000800080;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000202;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000800080;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000202;
  *((unsigned long *)&__m256i_result[3]) = 0x0000ffffff7fff80;
  *((unsigned long *)&__m256i_result[2]) = 0x0001ff91ff0ffdfe;
  *((unsigned long *)&__m256i_result[1]) = 0x0000ffffff7fff80;
  *((unsigned long *)&__m256i_result[0]) = 0x0001ff91ff0ffdfe;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7fffffff80000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffff80000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fffffffffffffff;
  __m256i_out = __lasx_xvssub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
