;; Scheduling description for Motorola PowerPC 7450 processor.
;;   Copyright (C) 2003-2024 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "ppc7450,ppc7450mciu,ppc7450fp,ppc7450vec")
(define_cpu_unit "iu1_7450,iu2_7450,iu3_7450" "ppc7450")
(define_cpu_unit "mciu_7450" "ppc7450mciu")
(define_cpu_unit "fpu_7450" "ppc7450fp")
(define_cpu_unit "lsu_7450,bpu_7450" "ppc7450")
(define_cpu_unit "du1_7450,du2_7450,du3_7450" "ppc7450")
(define_cpu_unit "vecsmpl_7450,veccmplx_7450,vecflt_7450,vecperm_7450" "ppc7450vec")
(define_cpu_unit "vdu1_7450,vdu2_7450" "ppc7450vec")


;; PPC7450  32-bit 3xIU, MCIU, LSU, SRU, FPU, BPU, 4xVEC
;; IU1,IU2,IU3 can perform all integer operations
;; MCIU performs imul and idiv, cr logical, SPR moves
;; LSU 2 stage pipelined
;; FPU 3 stage pipelined
;; It also has 4 vector units, one for each type of vector instruction.
;; However, we can only dispatch 2 instructions per cycle. 
;; Max issue 3 insns/clock cycle (includes 1 branch)
;; In-order execution

;; Branches go straight to the BPU.  All other insns are handled
;; by a dispatch unit which can issue a max of 3 insns per cycle.
(define_reservation "ppc7450_du" "du1_7450|du2_7450|du3_7450")
(define_reservation "ppc7450_vec_du" "vdu1_7450|vdu2_7450")

(define_insn_reservation "ppc7450-load" 3
  (and (eq_attr "type" "load,vecload")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450")

(define_insn_reservation "ppc7450-store" 3
  (and (eq_attr "type" "store,vecstore")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450")

(define_insn_reservation "ppc7450-fpload" 4
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450")

(define_insn_reservation "ppc7450-fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450*3")

(define_insn_reservation "ppc7450-llsc" 3
  (and (eq_attr "type" "load_l,store_c")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450")

(define_insn_reservation "ppc7450-sync" 35
  (and (eq_attr "type" "sync")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,lsu_7450")

(define_insn_reservation "ppc7450-integer" 1
  (and (ior (eq_attr "type" "integer,insert,trap,cntlz,isel")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "no")))
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,iu1_7450|iu2_7450|iu3_7450")

(define_insn_reservation "ppc7450-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,iu1_7450|iu2_7450|iu3_7450,iu1_7450|iu2_7450|iu3_7450")

(define_insn_reservation "ppc7450-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,iu1_7450|iu2_7450|iu3_7450,\
   iu1_7450|iu2_7450|iu3_7450,iu1_7450|iu2_7450|iu3_7450")

(define_insn_reservation "ppc7450-imul" 4
  (and (eq_attr "type" "mul")
       (eq_attr "size" "32")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,mciu_7450*2")

(define_insn_reservation "ppc7450-imul2" 3
  (and (eq_attr "type" "mul")
       (eq_attr "size" "8,16")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,mciu_7450")

(define_insn_reservation "ppc7450-idiv" 23
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,mciu_7450*23")

(define_insn_reservation "ppc7450-compare" 2
  (and (ior (eq_attr "type" "cmp")
	    (and (eq_attr "type" "add,logical,shift,exts")
		 (eq_attr "dot" "yes")))
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,(iu1_7450|iu2_7450|iu3_7450)")

(define_insn_reservation "ppc7450-fpcompare" 5
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,fpu_7450")

(define_insn_reservation "ppc7450-fp" 5
  (and (eq_attr "type" "fp,fpsimple,dmul")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,fpu_7450")

; Divides are not pipelined
(define_insn_reservation "ppc7450-sdiv" 21
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,fpu_7450*21")

(define_insn_reservation "ppc7450-ddiv" 35
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,fpu_7450*35")

(define_insn_reservation "ppc7450-mfcr" 2
  (and (eq_attr "type" "mfcr,mtcr")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,mciu_7450")

(define_insn_reservation "ppc7450-crlogical" 1
  (and (eq_attr "type" "cr_logical")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,mciu_7450")

(define_insn_reservation "ppc7450-mtjmpr" 2
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc7450"))
  "nothing,mciu_7450*2")

(define_insn_reservation "ppc7450-mfjmpr" 3
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "ppc7450"))
  "nothing,mciu_7450*2")

(define_insn_reservation "ppc7450-jmpreg" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppc7450"))
  "nothing,bpu_7450")

;; Altivec
(define_insn_reservation "ppc7450-vecsimple" 1
  (and (eq_attr "type" "vecsimple,veclogical,vecmove")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,ppc7450_vec_du,vecsmpl_7450")

(define_insn_reservation "ppc7450-veccomplex" 4
  (and (eq_attr "type" "veccomplex")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,ppc7450_vec_du,veccmplx_7450")

(define_insn_reservation "ppc7450-veccmp" 2
  (and (eq_attr "type" "veccmp,veccmpfx")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,ppc7450_vec_du,veccmplx_7450")

(define_insn_reservation "ppc7450-vecfloat" 4
  (and (eq_attr "type" "vecfloat")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,ppc7450_vec_du,vecflt_7450")

(define_insn_reservation "ppc7450-vecperm" 2
  (and (eq_attr "type" "vecperm")
       (eq_attr "cpu" "ppc7450"))
  "ppc7450_du,ppc7450_vec_du,vecperm_7450")

