/* { dg-do run { target { riscv_vector } } } */
/* { dg-options "-O2" } */

#include<cstdalign>
#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"
using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}

int main()
{
int return_value = 0;

size_t var_134 = 120u;
int8_t var_133 [] = {15, -2, 0, 0, -1, 0, 0, -2, 18, 0, 1, 0, 2, 10, 2, 0, 0, -9, 0, 0, 0, 0, 1, 0, 31, 2, 0, -5, 0, 3, -2, -17, -12, 0, 0, -1, 1, 47, -1, 0, 0, -1, 33, 0, 0, 1, 0, 0, -10, 0, 0, 61, 18, -3, 0, -1, 0, 0, 0, 14, 0, 3, 0, 0, 0, 0, 0, 0, -59, 0, 0, 55, 0, 11, 14, 0, 0, 0, 1, 0, 0, 0, -1, 17, 0, 2, 0, 0, -5, -1, 1, 0, 1, 6, 0, 0, 107, 0, 7, 0, 0, 0, 5, 7, 0, 0, 0, -1, 0, 0, -8, 0, 0, 0, -1, 0, -8, 1, 0, 0};
size_t var_131 = 9u;
int8_t var_130 [] = {60, -103, -44, -1, -43, 1, 0, -107, 72};
size_t var_128 = 38u;
int8_t var_127 [] = {44, 40, 108, -73, 76, -34, -25, 4, 54, 94, -10, -29, 12, 116, -121, -32, 30, 61, 127, 16, -34, -95, -90, 124, -4, 12, 124, 18, 123, -37, -56, -119, 9, 12, 57, 30, -20, 29};
size_t var_125 = 98u;
uint8_t var_124 [] = {53u, 28u, 220u, 181u, 243u, 150u, 238u, 37u, 119u, 182u, 29u, 252u, 15u, 156u, 34u, 201u, 75u, 149u, 173u, 112u, 255u, 58u, 51u, 176u, 22u, 103u, 44u, 150u, 225u, 31u, 190u, 70u, 125u, 112u, 57u, 3u, 191u, 131u, 48u, 89u, 168u, 58u, 104u, 228u, 15u, 80u, 128u, 101u, 161u, 132u, 24u, 17u, 113u, 126u, 25u, 23u, 93u, 18u, 241u, 203u, 255u, 142u, 113u, 233u, 129u, 137u, 248u, 173u, 40u, 23u, 161u, 100u, 242u, 77u, 206u, 18u, 162u, 57u, 44u, 215u, 2u, 43u, 61u, 116u, 166u, 21u, 188u, 74u, 234u, 245u, 45u, 44u, 17u, 240u, 46u, 58u, 89u, 254u};
size_t var_122 = 31u;
int8_t var_121 [] = {41, 69, -57, 102, 86, 103, -128, 4, -118, -1, 109, 40, 7, 27, 79, -63, 35, 73, 1, 42, -85, 126, 107, 53, -114, 39, 53, 10, -94, -20, 125};
int8_t var_119 [] = {-52, 85, -58, 27, 110, -67, -54, 4, -100, 95, -74, -42, -123, -17, -71, -112, 119, -22, -4, -77, -118, -10, 30, -74, 0, 103, -122, 124, 59, -99, 78, -46, -52, 94, 14, -74, -97, 25, -59, 3, 68, -15, -60, 83, 80, -113, -90, -118, 7, -38, -57, -114, 88, -76, 8, 44, 45, 12, -27, 83, 43, 77, -93, 79, 6, -17, 93, 33, 22, 6, 113, -5, -13, 20, -106, -36, -57, -21, -127, -89, 102, -62, -92, -124, 73, 118, 41, -120, 94, -100, 13, -34, -86, -103, 26, -57, -16, 22, -48, -71, 15, 40, 27, -125, -94, -93, -93, -3, -33, 60, 15, -29, -16, 70, -15, 30, 108, -105, 30, -65};
uint8_t var_118 [] = {197u, 206u, 42u, 228u, 104u, 250u, 255u, 186u};
uint8_t var_117 [] = {72u, 6u, 85u, 22u, 128u, 73u, 137u, 137u};
int8_t var_116 [] = {-120, -102, 100, 49, -110, -76, -69, -31};
float64_t var_115 [] = {f64(323207751474600524u), f64(1112891795445475562u), f64(6854607033647765885u), f64(832190058329784671u), f64(11148526509635847059u), f64(12649416344049588294u), f64(4028395243010811234u), f64(14477107254519158798u)};
// 4.6405235952544706e-287, 2.796915483405209e-234, 1.683358637102254e+150, 4.864756940016232e-253, -5.6687651516926024e-180, -1.1703726495306743e-79, 2.1797047987439956e-39, -1.7434285356776356e+43

float64_t var_114 [] = {f64(6662394577642063664u), f64(5311186693252893574u), f64(703524307981821023u), f64(10715555053454551221u), f64(1397370713219650317u), f64(2519636160457044144u), f64(2428017200744904391u), f64(8871119969217150037u)};
// 2.509669398494079e+137, 1.2060594553171986e+47, 1.2334815861468122e-261, -6.478620247525537e-209, 2.967271500782844e-215, 3.089416451843403e-140, 2.258590162692108e-146, 1.061330842742021e+285

uint32_t var_113 [] = {2501167418u, 4078952301u, 1289692095u, 3288851377u, 1031645594u, 2454418038u, 4057122694u, 4195826215u};
uint32_t var_112 [] = {997394066u, 745676460u, 1302867668u, 2496350675u, 681303275u, 2256531569u, 197606396u, 782587620u};
int32_t var_111 [] = {-1370843403, -1083808177, -2046227556, 1248210267, -995484329, 1657636018, 139507966, -406999593};
int8_t var_110 [] = {41, 69, -57, 102, 86, 103, -128, 4, -118, -1, 109, 40, 7, 27, 79, -63, 35, 73, 1, 42, -85, 126, 107, 53, -114, 39, 53, 10, -94, -20, 125};
int8_t var_109 [] = {92, 35, 58, -53, 94, -103, 114, 32, 39, 76, 104, 103, -20, 29, -103, -123, 4, -107, -21, 127, 58, -93, 14, 68, -77, -65, 101, 20, -75, 72, 5};
int8_t var_108 [] = {-50, -3, -122, 11, -110, -106, -120, -117, -27, 49, 99, -33, 2, -37, -91, -10, 101, -24, -95, -24, 115, 84, -114, 67, 27, -44, -122, -28, 108, 107, 41};
int8_t var_107 [] = {-78, 56, -90, 72, 16, 80, -71, -95, 3, 65, -116, 44, 54, 69, 22, -23, -10, 79, -1, 31, 114, 87, -57, -65, -61, 15, 32, 68, 76, 1, -46};
uint8_t var_106 [] = {53u, 28u, 220u, 181u, 243u, 150u, 238u, 37u, 119u, 182u, 29u, 252u, 15u, 156u, 34u, 201u, 75u, 149u, 173u, 112u, 255u, 58u, 51u, 176u, 22u, 103u, 44u, 150u, 225u, 31u, 190u, 70u, 125u, 112u, 57u, 3u, 191u, 131u, 48u, 89u, 168u, 58u, 104u, 228u, 15u, 80u, 128u, 101u, 161u, 132u, 24u, 17u, 113u, 126u, 25u, 23u, 93u, 18u, 241u, 203u, 255u, 142u, 113u, 233u, 129u, 137u, 248u, 173u, 40u, 23u, 161u, 100u, 242u, 77u, 206u, 18u, 162u, 57u, 44u, 215u, 2u, 43u, 61u, 116u, 166u, 21u, 188u, 74u, 234u, 245u, 45u, 44u, 17u, 240u, 46u, 58u, 89u, 254u};
uint8_t var_105 [] = {209u, 83u, 95u, 215u, 76u, 0u, 235u, 22u, 155u, 169u, 210u, 242u, 234u, 53u, 32u, 126u, 93u, 184u, 196u, 33u, 22u, 134u, 227u, 172u, 199u, 228u, 214u, 157u, 66u, 115u, 127u, 221u, 124u, 108u, 92u, 162u, 252u, 129u, 63u, 134u, 158u, 250u, 204u, 112u, 21u, 16u, 226u, 178u, 92u, 168u, 144u, 59u, 51u, 112u, 132u, 84u, 199u, 149u, 212u, 177u, 93u, 15u, 191u, 34u, 226u, 61u, 116u, 240u, 144u, 157u, 35u, 0u, 253u, 152u, 16u, 130u, 93u, 228u, 212u, 34u, 175u, 77u, 11u, 228u, 138u, 216u, 215u, 154u, 16u, 55u, 130u, 241u, 70u, 88u, 202u, 232u, 167u, 227u};
uint8_t var_104 [] = {51u, 198u, 54u, 22u, 54u, 109u, 241u, 76u, 225u, 21u, 43u, 183u, 71u, 250u, 207u, 44u, 152u, 213u, 120u, 189u, 216u, 199u, 160u, 137u, 139u, 156u, 242u, 195u, 203u, 157u, 173u, 238u, 36u, 236u, 14u, 66u, 233u, 220u, 212u, 206u, 88u, 160u, 94u, 235u, 46u, 107u, 124u, 71u, 244u, 166u, 151u, 133u, 4u, 253u, 133u, 158u, 21u, 209u, 239u, 228u, 236u, 153u, 230u, 9u, 68u, 166u, 227u, 8u, 188u, 160u, 107u, 71u, 176u, 135u, 33u, 234u, 227u, 37u, 237u, 185u, 136u, 79u, 111u, 252u, 190u, 236u, 95u, 246u, 251u, 46u, 114u, 142u, 231u, 150u, 52u, 158u, 216u, 61u};
int8_t var_103 [] = {44, 40, 108, -73, 76, -34, -25, 4, 54, 94, -10, -29, 12, 116, -121, -32, 30, 61, 127, 16, -34, -95, -90, 124, -4, 12, 124, 18, 123, -37, -56, -119, 9, 12, 57, 30, -20, 29};
int8_t var_102 [] = {-58, -3, 95, -113, -26, 109, 85, 110, -122, -108, 101, -113, 126, 80, -87, 88, 60, 124, -63, -128, -21, 118, 81, 124, 60, -103, 127, 70, 57, -19, 53, 51, -120, 33, -64, 119, 43, -34};
int8_t var_101 [] = {-22, -28, 99, -74, 40, -90, 17, -3, -110, -53, 80, -84, -114, 82, 112, 77, -54, -113, -87, 64, 106, 92, 120, 48, 25, -14, -19, 81, -98, -124, -58, -80, 6, 58, 108, 83, -69, -112};
int8_t var_100 [] = {46, 12, 5, 10, 55, 46, -54, -96, -12, -10, 121, -30, -5, 60, -76, -51, -87, 107, -54, -18, 112, -64, 46, 120, -5, -119, 30, -48, -51, 53, 108};
uint8_t var_99 [] = {130u, 12u, 38u, 148u, 237u, 176u, 183u, 136u, 155u, 156u, 201u, 58u, 26u, 167u, 105u, 117u, 25u, 125u, 29u, 163u, 29u, 169u, 151u, 180u, 73u, 173u, 94u, 121u, 183u, 48u, 208u};
uint8_t var_98 [] = {106u, 19u, 146u, 9u, 203u, 31u, 179u, 218u, 11u, 232u, 232u, 222u, 18u, 225u, 23u, 42u, 106u, 243u, 33u, 148u, 255u, 162u, 155u, 141u, 69u, 223u, 200u, 252u, 15u, 137u, 148u};
uint8_t var_97 [] = {169u, 101u, 247u, 228u, 25u, 209u, 126u, 155u, 250u, 136u, 194u, 138u, 145u, 248u, 73u, 129u, 113u, 84u, 187u, 38u, 199u, 246u, 203u, 87u, 216u, 198u, 112u, 192u, 134u, 171u, 42u, 93u, 133u, 7u, 224u, 21u, 201u, 53u, 23u, 53u, 115u, 218u, 190u, 133u, 200u, 46u, 173u, 144u, 159u, 21u, 11u, 146u, 13u, 76u, 255u, 107u, 126u, 108u, 27u, 163u, 113u, 57u, 85u, 237u, 243u, 47u, 242u, 40u, 206u, 107u, 191u, 11u, 34u, 210u, 143u, 214u, 164u, 192u, 59u, 144u, 78u, 91u, 2u, 105u, 109u, 58u, 63u, 204u, 39u, 66u, 158u, 135u, 205u, 68u, 114u, 10u, 233u, 113u, 181u, 184u, 16u, 170u, 226u, 212u, 91u, 136u, 41u, 159u, 143u, 78u, 26u, 246u, 63u, 221u, 192u, 150u, 238u, 128u, 128u, 46u};
int8_t var_96 [] = {-4, -35, -62, -104, -17, -25, -117, 125, -44, 20, 37, 46, 40, -95, 41, 70, 1, 71, -35, -60, 107, -68, 102, -102, -71, 52, 34, -111, -120, 107, -56, -103, 77, -63, -48, 90, 46, -111, -68, -38, 3, -110, 104, 82, -85, -102, 63, 54, 85, -7, 38, -36, 70, -95, 99, -78, 33, -86, 109, 2, -45, -83, -90, 16, -43, 101, -99, -32, -97, 73, -28, 90, -103, -34, -107, -51, 126, -98, -11, 0, 41, -83, 92, -10, -38, 97, -65, -27, -92, 17, 127, -127, 81, -6, -45, -38, -48, 30, 33, 35, 106, -44, 122, -8, 84, 1, -13, -67, -78, 90, -68, 92, 97, -103, -68, -17, 10, 28, -54, 9};
int8_t var_95 [] = {-90, -98, -55, 68, -7, -5, -21, -60, 92, -66, 103, 39, -50, 35, -28, -110, -23, 114, -40, -125, -123, -83, -59, 33, -56, 56, -19, -15, 33, 69, -76, -28, 97, 107, 55, -126, 61, 25, -69, 44, 65, -61, 14, -62, -121, -82, -106, -28, 17, 109, 66, -114, 74, -40, -94, 69, 19, -96, 88, -59, -68, -86, -97, -6, -107, 27, 26, 10, 95, -9, 80, -80, 19, -31, 102, 29, 37, -88, -86, 38, 59, 77, 110, 101, -126, -1, -28, -96, -25, 74, 76, 48, 77, 127, 100, 82, -64, 50, 22, -87, -17, 122, 106, 65, 36, 121, -38, 20, 123, -118, 0, -124, 30, 122, 79, -91, 107, -126, -113, -126};
int8_t var_94 [] = {-16, 42, -87, 90, 66, -72, 84, -76, -107, 14, -58, 48, 86, 89, -10, -122, -2, 39, 42, 124, 120, 105, 100, -121, 20, 56, -25, 65, 57, -30, -109, 8, 22, -52, 126, -30, -6, 101, -22, -14, 41, 41, 118, -124, -83, -42, 47, -105, -10, -34, -83, 25, 66, 125, -17, 125, -41, 69, 116, 39, -73, -76, -44, 107, -32, -90, 86, 108, -101, 35, 100, 55, 2, -123, 87, -57, 6, -120, -93, -45, -115, -37, -18, 3, -9, -41, 64, 79, 0, -109, 15, 86, 28, -98, 118, -95, 36, 71, -123, -14, 68, 120, 118, -123, 118, 54, -59, 63, 118, 6, -1, -48, 32, 84, -76, -67, 67, 101, -61, -3};
int8_t var_93 [] = {60, -103, -44, 107, -43, -39, -85, -107, 72, 37, 1, -30, 3, 77, 110, -21, -1, -69, -4, 55, 63, -104, -12, 107, 122, 79, -62, -38, 21, 24, -52, -34, -94, 67, -127, 0, 74, 93, -85, -12, -15, -10, 65, -89, -104, 122, 19, -29, -78, -12, 104, 121, 73, -111, -40, -57, 82, -74, -72, 54, -102, 105, 54, -106, 39, 127, -67, -53, -59, -3, 67, 55, -40, 11, 114, -59, -57, -123, -28, -8, -106, -65, -37, 33, 54, 96, 66, -27, -37, -47, 35, -55, 52, 102, 110, 107, 107, 89, 107, 93, 3, -6, 84, 113, -82, 57, 17, -3, 59, -125, -17, 47, -93, -80, -99, 111, -125, 18, 36, 75};
int8_t var_92 [] = {-90, 39, -97, 115, -95, -84, -45, -93, -13, -1, -119, -61, 125, -78, -3, -35, 19, 28, -109, 83, -10, 103, -77, -13, -17, 91, -108, -64, -106, 49, 75, 85, 63, -49, -41, 102, 103, -22, 43, -29, -79, -45, -63, 9, -85, -92, 66, 23, 88, 29, -16, -35, 14, 62, -79, 26, -83, 38, 88, -103, -39, 84, -2, 125, 20, -15, -68, -31, -104, -99, -2, -125, -36, -101, -101, -89, 58, -1, -127, 124, 19, 1, 94, 30, 102, -43, 56, 26, 89, 121, 61, -7, 92, 109, 108, 5, -93, -123, 43, -23, -42, 76, -89, -95, -14, -91, 43, 98, 104, -53, 9, 77, 36, 113, -6, -100, 98, 84, 75, 35};
int8_t var_91 [] = {90, -121, -65, 27, -14, 45, 4, -40, -70, -94, 20, 70, -121, -49, -23, 16, 124, -65, -74, 104, 77, 47, 71, 80, -35, -123, 59, -94, -43, -4, 127, -33, 88, 2, 53, 22, 101, -21, -10, -15, -41, 126, 66, 108, 27, 117, 1, -83, 89, 109, 114, -31, -107, 27, -77, 101, 16, 88, 93, -74, 99, -11, 32, -35, 124, 31, 118, 124, -87, 4, 13, -64, -26, -98, -10, 8, -101, -37, 121, 28, 1, 49, 36, 97, 29, -3, 65, 28, -96, 72, -67, -92, 126, -15, 53, -90, -124, 11, 59, -91, -127, -112, -111, 125, 98, 51, 45, -127, -115, 13, -107, 25, 28, 74, -53, 76, -28, 108, 18, -94};
int8_t var_90 [] = {11, 85, -127, 49, 107, -37, 66, 124, 60, -100, 5, 79, 15, -91, 56, -52, -115, 112, -28, -128, -43, -48, 77, 106, 17, 81, 118, 29, -120, -20, 44, 75, 81, -54, -4, -17, 82, 44, 92, 8, -106, 54, 32, -105, -32, 53, -102, -79, 89, -100, -80, -118, 35, 13, -47, 25, 111, -59, -50, 19, -47, -83, 52, -79, -1, 90, 120, -46, 42, 97, -76, 43, -16, -127, 94, 112, -14, -22, -86, 120, -116, 124, 108, 82, -99, 54, 84, -92, 38, 33, 46, -3, 0, -78, -92, -52, 63, -29, 55, -90, -26, -117, 125, 63, 113, 110, 71, -92, -13, -118, 53, 53, 123, -83, 122, -76, 44, 21, 32, -34};
int8_t var_89 [] = {-75, -70, 31, 76, 120, 116, -76, 95, -96};
int8_t var_88 [] = {6, 65, 93, -102, 118, -75, 24, -9, 111};
uint8_t var_87 [] = {120u, 177u, 163u, 176u, 160u, 16u, 235u, 224u, 168u, 198u, 166u, 121u, 182u, 42u, 113u, 93u, 16u, 123u, 174u, 42u, 43u, 205u, 132u, 40u, 88u, 190u, 96u, 11u, 144u, 187u, 111u, 246u, 235u, 75u, 163u, 20u, 163u, 231u, 163u, 94u, 30u, 186u, 167u, 88u, 123u, 130u, 230u, 8u, 203u, 208u, 222u, 231u, 25u, 143u, 40u, 176u, 44u, 182u, 75u, 184u, 167u, 143u, 237u, 182u, 235u, 32u, 81u, 127u, 85u, 219u, 38u, 4u, 45u, 117u, 219u, 234u, 11u, 231u, 103u, 33u, 199u, 214u, 100u, 166u, 23u, 64u, 37u, 234u, 59u, 81u, 111u, 100u, 241u, 204u, 159u, 44u, 196u, 60u, 92u, 90u, 30u, 61u, 252u, 45u, 8u, 121u, 139u, 4u, 144u, 113u, 39u, 28u, 194u, 227u, 98u, 82u, 237u, 15u, 44u, 96u};
uint8_t var_86 [] = {98u, 184u, 61u, 239u, 240u, 91u, 79u, 194u, 158u, 234u, 4u, 89u, 239u, 124u, 241u, 245u, 124u, 143u, 92u, 94u, 84u, 167u, 223u, 198u, 177u, 178u, 246u, 91u, 22u, 131u, 231u, 12u, 206u, 85u, 215u, 46u, 58u, 146u, 2u, 225u, 251u, 206u, 200u, 104u, 78u, 12u, 189u, 38u, 186u, 162u, 194u, 48u, 75u, 42u, 131u, 81u, 195u, 207u, 58u, 209u, 239u, 164u, 207u, 113u, 87u, 198u, 201u, 40u, 195u, 146u, 5u, 8u, 254u, 248u, 61u, 44u, 254u, 195u, 254u, 100u, 109u, 142u, 156u, 197u, 78u, 169u, 121u, 72u, 158u, 31u, 39u, 235u, 141u, 48u, 205u, 242u, 109u, 113u};
uint8_t var_85 [] = {128u, 227u, 109u, 98u, 165u, 57u, 151u, 127u, 141u, 112u, 125u, 27u, 13u, 104u, 216u, 83u, 225u, 180u, 211u, 113u, 32u, 194u, 151u, 47u, 81u, 223u, 51u, 145u, 133u, 6u, 120u, 56u, 252u, 40u, 47u, 145u, 214u, 159u, 80u, 253u, 16u, 33u, 36u, 69u, 82u, 20u, 222u, 113u, 144u, 68u, 204u, 207u, 7u, 128u, 142u, 38u, 3u, 142u, 149u, 25u, 91u, 91u, 153u, 64u, 227u, 135u, 222u, 165u, 120u, 56u, 120u, 249u, 233u, 100u, 204u, 127u, 200u, 213u, 145u, 193u, 237u, 3u, 204u, 214u, 116u, 115u, 251u, 64u, 45u, 52u, 72u, 5u, 188u, 219u, 228u, 36u, 238u, 195u};
int8_t var_84 [] = {87, 92, -88, 10, 92, 105, -7, -9, -62, -103, -20, 10, -44, -98, 69, 54, 29, -99, 46, 19, -13, 57, 50, -93, -87, 112, -14, 65, -62, -75, 27, 119, 54, -42, -98, 9, 29, 16, 32, 90, -126, 87, 28, -96, 21, -11, 9, 60, -58, -126, -58, 103, 15, 108, -38, 100, -42, 70, 125, -92, -118, -101, -18, -61, -115, 0, -29, 94, 113, 107, 86, 121, -96, -27, -45, 101, 89, 60, -6, -61, -78, -18, -76, 43, 122, -19, -47, 42, -4, 100, -59, 77, -110, 74, -42, 0, 126, -25, 95, 120, 47, -94, -77, 48, 47, -55, 82, -127, -99, -79, -101, -16, 117, 46, -67, 39, 60, 61, 16, 93};
int8_t var_83 [] = {97, 57, 34, -38, 36, -74, -60, 124, -6, 0, -40, 53, 75, -72, -69, -52, 115, -49, -115, -101, -7, 107, -37, 7, -55, 7, 39, -16, -7, -34, -44, -31, -126, -82, -7, -43, 109, -93, 103, 90, 114, -127, 125, -95, -1, 61, 109, -118, 21, 6, -81, 87, 79, -73, -89, 5, 93, 92, -52, 86, 11, 99, 91, 2, 88, -38, 110, 17, -27, -93, 124, 85, 34, 46, -101, 35, 58, 47, -29, 49, -12, 26, -1, 64, 27, 96, -77, 109, -127, -106, -46, -109, -37, 111, -116, -53, 126, 67, 32, 62, 56, -42, -123, 119, -28, 11, -49, -29, -74, -95, 39, -50, -123, 13, -12, 56, -89, 74, -64, -111};
int8_t var_82 [] = {110, -40, -24, 36, -44, 2, 46, -123, -3, -47, 61, 100, 35, 101, 67, 47, -1, 125, -71, 67, 81, -108, -16, 15, -71, -66, 19, -68, -101, 42, -51, 64, 54, 106, 64, 9, -26, -25, -63, -13, -23, -72, 19, -36, -16, 69, -89, 80, 92, 44, -110, 1, 59, -23, 84, 87, -120, -108, 69, 93, 122, 47, -37, 9, 28, -65, 37, -59, -95, -76, 78, 32, 100, 17, 108, -70, -115, -118, 16, 43, 11, 40, -40, 39, 71, -51, 14, 19, -38, 33, 44, 49, -19, 8, 95, 70, -93, -87};
int8_t var_81 [] = {-88, -43, 94, -41, -57, 97, -45, -100, 35, 17, -101, -117, 70, 26, -14, 14, 69, 67, -27, 120, -71, 73, 79, 124, 100, -80, 67, 105, -72, 82, -42, -96, -108, -10, 45, -29, -83, 113, 115, -49, -6, -20, -112, 0, 40, 70, -126, -87, -99, -14, -106, -96, 114, 65, 65, -65, -58, -87, 21, 3, -17, -29, 13, -53, -76, 41, 87, 12, -83, 27, -11, -43, 4, 66, -87, 116, 23, -28, 11, -52, 6, -67, -3, 54, 79, 60, -26, -76, -10, 32, 23, -2, 42, 30, 66, 26, 91, -125};
int8_t var_80 = 118;
int8_t var_79 = -73;
uint8_t var_78 = 99u;
uint8_t var_77 = 17u;
size_t var_76 = 24u;
uint8_t var_75 = 204u;
int8_t var_74 = 17;
int32_t var_73 = -305525697;
uint8_t var_72 = 9u;
int8_t var_71 = 5;
int8_t var_70 = -5;
int8_t var_69 = 126;
__riscv_vsetvl_e8m8(120);
vint8m8_t var_0 = __riscv_vle8_v_i8m8(var_119, 120);
// -52, 85, -58, 27, 110, -67, -54, 4, -100, 95, -74, -42, -123, -17, -71, -112, 119, -22, -4, -77, -118, -10, 30, -74, 0, 103, -122, 124, 59, -99, 78, -46, -52, 94, 14, -74, -97, 25, -59, 3, 68, -15, -60, 83, 80, -113, -90, -118, 7, -38, -57, -114, 88, -76, 8, 44, 45, 12, -27, 83, 43, 77, -93, 79, 6, -17, 93, 33, 22, 6, 113, -5, -13, 20, -106, -36, -57, -21, -127, -89, 102, -62, -92, -124, 73, 118, 41, -120, 94, -100, 13, -34, -86, -103, 26, -57, -16, 22, -48, -71, 15, 40, 27, -125, -94, -93, -93, -3, -33, 60, 15, -29, -16, 70, -15, 30, 108, -105, 30, -65

__riscv_vsetvl_e8mf2(8);
vuint8mf2_t var_21 = __riscv_vle8_v_u8mf2(var_118, 8);
// 197, 206, 42, 228, 104, 250, 255, 186

vuint8mf2_t var_22 = __riscv_vle8_v_u8mf2(var_117, 8);
// 72, 6, 85, 22, 128, 73, 137, 137

vint8mf2_t var_23 = __riscv_vle8_v_i8mf2(var_116, 8);
// -120, -102, 100, 49, -110, -76, -69, -31

vfloat64m4_t var_26 = __riscv_vle64_v_f64m4(var_115, 8);
// 4.6405235952544706e-287, 2.796915483405209e-234, 1.683358637102254e+150, 4.864756940016232e-253, -5.6687651516926024e-180, -1.1703726495306743e-79, 2.1797047987439956e-39, -1.7434285356776356e+43

vfloat64m4_t var_27 = __riscv_vle64_v_f64m4(var_114, 8);
// 2.509669398494079e+137, 1.2060594553171986e+47, 1.2334815861468122e-261, -6.478620247525537e-209, 2.967271500782844e-215, 3.089416451843403e-140, 2.258590162692108e-146, 1.061330842742021e+285

vuint32m2_t var_28 = __riscv_vle32_v_u32m2(var_113, 8);
// 2501167418, 4078952301, 1289692095, 3288851377, 1031645594, 2454418038, 4057122694, 4195826215

vuint32m2_t var_29 = __riscv_vle32_v_u32m2(var_112, 8);
// 997394066, 745676460, 1302867668, 2496350675, 681303275, 2256531569, 197606396, 782587620

vint32m2_t var_30 = __riscv_vle32_v_i32m2(var_111, 8);
// -1370843403, -1083808177, -2046227556, 1248210267, -995484329, 1657636018, 139507966, -406999593

__riscv_vsetvl_e8m8(31);
vint8m8_t var_32 = __riscv_vle8_v_i8m8(var_110, 31);
// 41, 69, -57, 102, 86, 103, -128, 4, -118, -1, 109, 40, 7, 27, 79, -63, 35, 73, 1, 42, -85, 126, 107, 53, -114, 39, 53, 10, -94, -20, 125

vint8m8_t var_34 = __riscv_vle8_v_i8m8(var_108, 31);
// -50, -3, -122, 11, -110, -106, -120, -117, -27, 49, 99, -33, 2, -37, -91, -10, 101, -24, -95, -24, 115, 84, -114, 67, 27, -44, -122, -28, 108, 107, 41

vint8m8_t var_35 = __riscv_vle8_v_i8m8(var_107, 31);
// -78, 56, -90, 72, 16, 80, -71, -95, 3, 65, -116, 44, 54, 69, 22, -23, -10, 79, -1, 31, 114, 87, -57, -65, -61, 15, 32, 68, 76, 1, -46

__riscv_vsetvl_e8m8(98);
vuint8m8_t var_36 = __riscv_vle8_v_u8m8(var_106, 98);
// 53, 28, 220, 181, 243, 150, 238, 37, 119, 182, 29, 252, 15, 156, 34, 201, 75, 149, 173, 112, 255, 58, 51, 176, 22, 103, 44, 150, 225, 31, 190, 70, 125, 112, 57, 3, 191, 131, 48, 89, 168, 58, 104, 228, 15, 80, 128, 101, 161, 132, 24, 17, 113, 126, 25, 23, 93, 18, 241, 203, 255, 142, 113, 233, 129, 137, 248, 173, 40, 23, 161, 100, 242, 77, 206, 18, 162, 57, 44, 215, 2, 43, 61, 116, 166, 21, 188, 74, 234, 245, 45, 44, 17, 240, 46, 58, 89, 254

vuint8m8_t var_37 = __riscv_vle8_v_u8m8(var_105, 98);
// 209, 83, 95, 215, 76, 0, 235, 22, 155, 169, 210, 242, 234, 53, 32, 126, 93, 184, 196, 33, 22, 134, 227, 172, 199, 228, 214, 157, 66, 115, 127, 221, 124, 108, 92, 162, 252, 129, 63, 134, 158, 250, 204, 112, 21, 16, 226, 178, 92, 168, 144, 59, 51, 112, 132, 84, 199, 149, 212, 177, 93, 15, 191, 34, 226, 61, 116, 240, 144, 157, 35, 0, 253, 152, 16, 130, 93, 228, 212, 34, 175, 77, 11, 228, 138, 216, 215, 154, 16, 55, 130, 241, 70, 88, 202, 232, 167, 227

__riscv_vsetvl_e8m8(38);
vint8m8_t var_39 = __riscv_vle8_v_i8m8(var_103, 38);
// 44, 40, 108, -73, 76, -34, -25, 4, 54, 94, -10, -29, 12, 116, -121, -32, 30, 61, 127, 16, -34, -95, -90, 124, -4, 12, 124, 18, 123, -37, -56, -119, 9, 12, 57, 30, -20, 29

vint8m8_t var_40 = __riscv_vle8_v_i8m8(var_102, 38);
// -58, -3, 95, -113, -26, 109, 85, 110, -122, -108, 101, -113, 126, 80, -87, 88, 60, 124, -63, -128, -21, 118, 81, 124, 60, -103, 127, 70, 57, -19, 53, 51, -120, 33, -64, 119, 43, -34

__riscv_vsetvl_e8m8(31);
vint8m8_t var_43 = __riscv_vle8_v_i8m8(var_100, 31);
// 46, 12, 5, 10, 55, 46, -54, -96, -12, -10, 121, -30, -5, 60, -76, -51, -87, 107, -54, -18, 112, -64, 46, 120, -5, -119, 30, -48, -51, 53, 108

vuint8m8_t var_44 = __riscv_vle8_v_u8m8(var_99, 31);
// 130, 12, 38, 148, 237, 176, 183, 136, 155, 156, 201, 58, 26, 167, 105, 117, 25, 125, 29, 163, 29, 169, 151, 180, 73, 173, 94, 121, 183, 48, 208

vuint8m8_t var_45 = __riscv_vle8_v_u8m8(var_98, 31);
// 106, 19, 146, 9, 203, 31, 179, 218, 11, 232, 232, 222, 18, 225, 23, 42, 106, 243, 33, 148, 255, 162, 155, 141, 69, 223, 200, 252, 15, 137, 148

__riscv_vsetvl_e8m8(120);
vuint8m8_t var_48 = __riscv_vle8_v_u8m8(var_97, 120);
// 169, 101, 247, 228, 25, 209, 126, 155, 250, 136, 194, 138, 145, 248, 73, 129, 113, 84, 187, 38, 199, 246, 203, 87, 216, 198, 112, 192, 134, 171, 42, 93, 133, 7, 224, 21, 201, 53, 23, 53, 115, 218, 190, 133, 200, 46, 173, 144, 159, 21, 11, 146, 13, 76, 255, 107, 126, 108, 27, 163, 113, 57, 85, 237, 243, 47, 242, 40, 206, 107, 191, 11, 34, 210, 143, 214, 164, 192, 59, 144, 78, 91, 2, 105, 109, 58, 63, 204, 39, 66, 158, 135, 205, 68, 114, 10, 233, 113, 181, 184, 16, 170, 226, 212, 91, 136, 41, 159, 143, 78, 26, 246, 63, 221, 192, 150, 238, 128, 128, 46

vint8m8_t var_49 = __riscv_vle8_v_i8m8(var_96, 120);
// -4, -35, -62, -104, -17, -25, -117, 125, -44, 20, 37, 46, 40, -95, 41, 70, 1, 71, -35, -60, 107, -68, 102, -102, -71, 52, 34, -111, -120, 107, -56, -103, 77, -63, -48, 90, 46, -111, -68, -38, 3, -110, 104, 82, -85, -102, 63, 54, 85, -7, 38, -36, 70, -95, 99, -78, 33, -86, 109, 2, -45, -83, -90, 16, -43, 101, -99, -32, -97, 73, -28, 90, -103, -34, -107, -51, 126, -98, -11, 0, 41, -83, 92, -10, -38, 97, -65, -27, -92, 17, 127, -127, 81, -6, -45, -38, -48, 30, 33, 35, 106, -44, 122, -8, 84, 1, -13, -67, -78, 90, -68, 92, 97, -103, -68, -17, 10, 28, -54, 9

vint8m8_t var_50 = __riscv_vle8_v_i8m8(var_95, 120);
// -90, -98, -55, 68, -7, -5, -21, -60, 92, -66, 103, 39, -50, 35, -28, -110, -23, 114, -40, -125, -123, -83, -59, 33, -56, 56, -19, -15, 33, 69, -76, -28, 97, 107, 55, -126, 61, 25, -69, 44, 65, -61, 14, -62, -121, -82, -106, -28, 17, 109, 66, -114, 74, -40, -94, 69, 19, -96, 88, -59, -68, -86, -97, -6, -107, 27, 26, 10, 95, -9, 80, -80, 19, -31, 102, 29, 37, -88, -86, 38, 59, 77, 110, 101, -126, -1, -28, -96, -25, 74, 76, 48, 77, 127, 100, 82, -64, 50, 22, -87, -17, 122, 106, 65, 36, 121, -38, 20, 123, -118, 0, -124, 30, 122, 79, -91, 107, -126, -113, -126

vint8m8_t var_51 = __riscv_vle8_v_i8m8(var_94, 120);
// -16, 42, -87, 90, 66, -72, 84, -76, -107, 14, -58, 48, 86, 89, -10, -122, -2, 39, 42, 124, 120, 105, 100, -121, 20, 56, -25, 65, 57, -30, -109, 8, 22, -52, 126, -30, -6, 101, -22, -14, 41, 41, 118, -124, -83, -42, 47, -105, -10, -34, -83, 25, 66, 125, -17, 125, -41, 69, 116, 39, -73, -76, -44, 107, -32, -90, 86, 108, -101, 35, 100, 55, 2, -123, 87, -57, 6, -120, -93, -45, -115, -37, -18, 3, -9, -41, 64, 79, 0, -109, 15, 86, 28, -98, 118, -95, 36, 71, -123, -14, 68, 120, 118, -123, 118, 54, -59, 63, 118, 6, -1, -48, 32, 84, -76, -67, 67, 101, -61, -3

vint8m8_t var_53 = __riscv_vle8_v_i8m8(var_93, 120);
// 60, -103, -44, 107, -43, -39, -85, -107, 72, 37, 1, -30, 3, 77, 110, -21, -1, -69, -4, 55, 63, -104, -12, 107, 122, 79, -62, -38, 21, 24, -52, -34, -94, 67, -127, 0, 74, 93, -85, -12, -15, -10, 65, -89, -104, 122, 19, -29, -78, -12, 104, 121, 73, -111, -40, -57, 82, -74, -72, 54, -102, 105, 54, -106, 39, 127, -67, -53, -59, -3, 67, 55, -40, 11, 114, -59, -57, -123, -28, -8, -106, -65, -37, 33, 54, 96, 66, -27, -37, -47, 35, -55, 52, 102, 110, 107, 107, 89, 107, 93, 3, -6, 84, 113, -82, 57, 17, -3, 59, -125, -17, 47, -93, -80, -99, 111, -125, 18, 36, 75

vint8m8_t var_54 = __riscv_vle8_v_i8m8(var_92, 120);
// -90, 39, -97, 115, -95, -84, -45, -93, -13, -1, -119, -61, 125, -78, -3, -35, 19, 28, -109, 83, -10, 103, -77, -13, -17, 91, -108, -64, -106, 49, 75, 85, 63, -49, -41, 102, 103, -22, 43, -29, -79, -45, -63, 9, -85, -92, 66, 23, 88, 29, -16, -35, 14, 62, -79, 26, -83, 38, 88, -103, -39, 84, -2, 125, 20, -15, -68, -31, -104, -99, -2, -125, -36, -101, -101, -89, 58, -1, -127, 124, 19, 1, 94, 30, 102, -43, 56, 26, 89, 121, 61, -7, 92, 109, 108, 5, -93, -123, 43, -23, -42, 76, -89, -95, -14, -91, 43, 98, 104, -53, 9, 77, 36, 113, -6, -100, 98, 84, 75, 35

vint8m8_t var_55 = __riscv_vle8_v_i8m8(var_91, 120);
// 90, -121, -65, 27, -14, 45, 4, -40, -70, -94, 20, 70, -121, -49, -23, 16, 124, -65, -74, 104, 77, 47, 71, 80, -35, -123, 59, -94, -43, -4, 127, -33, 88, 2, 53, 22, 101, -21, -10, -15, -41, 126, 66, 108, 27, 117, 1, -83, 89, 109, 114, -31, -107, 27, -77, 101, 16, 88, 93, -74, 99, -11, 32, -35, 124, 31, 118, 124, -87, 4, 13, -64, -26, -98, -10, 8, -101, -37, 121, 28, 1, 49, 36, 97, 29, -3, 65, 28, -96, 72, -67, -92, 126, -15, 53, -90, -124, 11, 59, -91, -127, -112, -111, 125, 98, 51, 45, -127, -115, 13, -107, 25, 28, 74, -53, 76, -28, 108, 18, -94

vint8m8_t var_56 = __riscv_vle8_v_i8m8(var_90, 120);
// 11, 85, -127, 49, 107, -37, 66, 124, 60, -100, 5, 79, 15, -91, 56, -52, -115, 112, -28, -128, -43, -48, 77, 106, 17, 81, 118, 29, -120, -20, 44, 75, 81, -54, -4, -17, 82, 44, 92, 8, -106, 54, 32, -105, -32, 53, -102, -79, 89, -100, -80, -118, 35, 13, -47, 25, 111, -59, -50, 19, -47, -83, 52, -79, -1, 90, 120, -46, 42, 97, -76, 43, -16, -127, 94, 112, -14, -22, -86, 120, -116, 124, 108, 82, -99, 54, 84, -92, 38, 33, 46, -3, 0, -78, -92, -52, 63, -29, 55, -90, -26, -117, 125, 63, 113, 110, 71, -92, -13, -118, 53, 53, 123, -83, 122, -76, 44, 21, 32, -34

__riscv_vsetvl_e8m8(9);
vint8m8_t var_57 = __riscv_vle8_v_i8m8(var_89, 9);
// -75, -70, 31, 76, 120, 116, -76, 95, -96

__riscv_vsetvl_e8m8(120);
vuint8m8_t var_59 = __riscv_vle8_v_u8m8(var_87, 120);
// 120, 177, 163, 176, 160, 16, 235, 224, 168, 198, 166, 121, 182, 42, 113, 93, 16, 123, 174, 42, 43, 205, 132, 40, 88, 190, 96, 11, 144, 187, 111, 246, 235, 75, 163, 20, 163, 231, 163, 94, 30, 186, 167, 88, 123, 130, 230, 8, 203, 208, 222, 231, 25, 143, 40, 176, 44, 182, 75, 184, 167, 143, 237, 182, 235, 32, 81, 127, 85, 219, 38, 4, 45, 117, 219, 234, 11, 231, 103, 33, 199, 214, 100, 166, 23, 64, 37, 234, 59, 81, 111, 100, 241, 204, 159, 44, 196, 60, 92, 90, 30, 61, 252, 45, 8, 121, 139, 4, 144, 113, 39, 28, 194, 227, 98, 82, 237, 15, 44, 96

__riscv_vsetvl_e8m8(98);
vuint8m8_t var_61 = __riscv_vle8_v_u8m8(var_86, 98);
// 98, 184, 61, 239, 240, 91, 79, 194, 158, 234, 4, 89, 239, 124, 241, 245, 124, 143, 92, 94, 84, 167, 223, 198, 177, 178, 246, 91, 22, 131, 231, 12, 206, 85, 215, 46, 58, 146, 2, 225, 251, 206, 200, 104, 78, 12, 189, 38, 186, 162, 194, 48, 75, 42, 131, 81, 195, 207, 58, 209, 239, 164, 207, 113, 87, 198, 201, 40, 195, 146, 5, 8, 254, 248, 61, 44, 254, 195, 254, 100, 109, 142, 156, 197, 78, 169, 121, 72, 158, 31, 39, 235, 141, 48, 205, 242, 109, 113

vuint8m8_t var_62 = __riscv_vle8_v_u8m8(var_85, 98);
// 128, 227, 109, 98, 165, 57, 151, 127, 141, 112, 125, 27, 13, 104, 216, 83, 225, 180, 211, 113, 32, 194, 151, 47, 81, 223, 51, 145, 133, 6, 120, 56, 252, 40, 47, 145, 214, 159, 80, 253, 16, 33, 36, 69, 82, 20, 222, 113, 144, 68, 204, 207, 7, 128, 142, 38, 3, 142, 149, 25, 91, 91, 153, 64, 227, 135, 222, 165, 120, 56, 120, 249, 233, 100, 204, 127, 200, 213, 145, 193, 237, 3, 204, 214, 116, 115, 251, 64, 45, 52, 72, 5, 188, 219, 228, 36, 238, 195

__riscv_vsetvl_e8m8(120);
vint8m8_t var_65 = __riscv_vle8_v_i8m8(var_83, 120);
// 97, 57, 34, -38, 36, -74, -60, 124, -6, 0, -40, 53, 75, -72, -69, -52, 115, -49, -115, -101, -7, 107, -37, 7, -55, 7, 39, -16, -7, -34, -44, -31, -126, -82, -7, -43, 109, -93, 103, 90, 114, -127, 125, -95, -1, 61, 109, -118, 21, 6, -81, 87, 79, -73, -89, 5, 93, 92, -52, 86, 11, 99, 91, 2, 88, -38, 110, 17, -27, -93, 124, 85, 34, 46, -101, 35, 58, 47, -29, 49, -12, 26, -1, 64, 27, 96, -77, 109, -127, -106, -46, -109, -37, 111, -116, -53, 126, 67, 32, 62, 56, -42, -123, 119, -28, 11, -49, -29, -74, -95, 39, -50, -123, 13, -12, 56, -89, 74, -64, -111

__riscv_vsetvl_e8m8(98);
vint8m8_t var_67 = __riscv_vle8_v_i8m8(var_82, 98);
// 110, -40, -24, 36, -44, 2, 46, -123, -3, -47, 61, 100, 35, 101, 67, 47, -1, 125, -71, 67, 81, -108, -16, 15, -71, -66, 19, -68, -101, 42, -51, 64, 54, 106, 64, 9, -26, -25, -63, -13, -23, -72, 19, -36, -16, 69, -89, 80, 92, 44, -110, 1, 59, -23, 84, 87, -120, -108, 69, 93, 122, 47, -37, 9, 28, -65, 37, -59, -95, -76, 78, 32, 100, 17, 108, -70, -115, -118, 16, 43, 11, 40, -40, 39, 71, -51, 14, 19, -38, 33, 44, 49, -19, 8, 95, 70, -93, -87

vint8m8_t var_68 = __riscv_vle8_v_i8m8(var_81, 98);
// -88, -43, 94, -41, -57, 97, -45, -100, 35, 17, -101, -117, 70, 26, -14, 14, 69, 67, -27, 120, -71, 73, 79, 124, 100, -80, 67, 105, -72, 82, -42, -96, -108, -10, 45, -29, -83, 113, 115, -49, -6, -20, -112, 0, 40, 70, -126, -87, -99, -14, -106, -96, 114, 65, 65, -65, -58, -87, 21, 3, -17, -29, 13, -53, -76, 41, 87, 12, -83, 27, -11, -43, 4, 66, -87, 116, 23, -28, 11, -52, 6, -67, -3, 54, 79, 60, -26, -76, -10, 32, 23, -2, 42, 30, 66, 26, 91, -125

__riscv_vsetvl_e8mf2(8);
vbool16_t var_20 = __riscv_vmadc_vx_i8mf2_b16(var_23, var_74, 8);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool16_t var_25 = __riscv_vmsleu_vv_u32m2_b16(var_28, var_29, 8);
// 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool16_t var_24 = __riscv_vmsge_vx_i32m2_b16(var_30, var_73, 8);
// 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(31);
vbool1_t var_31 = __riscv_vmsne_vv_i8m8_b1(var_34, var_35, 31);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

vbool1_t var_42 = __riscv_vmsltu_vx_u8m8_b1(var_45, var_72, 31);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(120);
vbool1_t var_47 = __riscv_vmseq_vv_i8m8_b1(var_49, var_50, 120);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool1_t var_46 = __riscv_vmsne_vx_i8m8_b1(var_51, var_71, 120);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

vbool1_t var_52 = __riscv_vmsbc_vv_i8m8_b1(var_55, var_56, 120);
// 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1

__riscv_vsetvl_e8m8(98);
vbool1_t var_60 = __riscv_vmseq_vv_u8m8_b1(var_61, var_62, 98);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(120);
vbool1_t var_63 = __riscv_vmadc_vx_i8m8_b1(var_65, var_70, 120);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

__riscv_vsetvl_e8m8(98);
vbool1_t var_66 = __riscv_vmseq_vx_i8m8_b1(var_68, var_69, 98);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8mf2(8);
vuint8mf2_t var_19 = __riscv_vasubu_vx_u8mf2_tumu(var_20, var_21, var_22, var_75, 8);
// 197, 206, 42, 228, 104, 250, 255, 186

vbool16_t var_18 = __riscv_vmfle_vv_f64m4_b16_mu(var_24, var_25, var_26, var_27, 8);
// 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(120);
vbool1_t var_11 = __riscv_vmsne_vx_u8m8_b1_mu(var_46, var_47, var_48, var_78, 120);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1

vint8m8_t var_10 = __riscv_vdiv_vx_i8m8_tumu(var_52, var_53, var_54, var_79, 120);
// 60, -103, -44, -1, -43, 1, 0, -107, 72, 37, 1, 0, 3, 77, 110, 0, 0, -69, 1, -1, 0, -1, 1, 0, 122, 79, 1, -38, 21, 24, -52, -34, -94, 0, 0, -1, 74, 93, -85, -12, -15, -10, 65, 0, 1, 122, 0, 0, -78, 0, 0, 121, 73, -111, 1, -57, 1, 0, -1, 54, 0, 105, 0, -106, 0, 0, 0, 0, -59, 1, 0, 55, 0, 11, 114, 1, 0, 0, 1, -1, 0, 0, -1, 33, -1, 96, 0, 0, -37, -47, 35, 0, 52, 102, -1, 0, 107, 1, 107, 0, 0, -6, 84, 113, 0, 1, 0, -1, -1, 0, -17, -1, 0, -1, -99, 1, -125, 18, -1, 0

__riscv_vsetvl_e8mf2(8);
vuint8mf2_t var_15 = __riscv_vmulhu_vv_u8mf2_tumu(var_18, var_19, var_19, var_19, 8);
// 197, 206, 6, 228, 104, 244, 255, 186

__riscv_vsetvl_e8m8(98);
vint8m8_t var_3 = __riscv_vnmsub_vv_i8m8_tumu(var_66, var_0, var_10, var_67, 98);
// -52, 85, -58, 27, 110, -67, -54, 4, -100, 95, -74, -42, -123, -17, -71, -112, 119, -22, -4, -77, -118, -10, 30, -74, 0, 103, -122, 124, 59, -99, 78, -46, -52, 94, 14, -74, -97, 25, -59, 3, 68, -15, -60, 83, 80, -113, -90, -118, 7, -38, -57, -114, 88, -76, 8, 44, 45, 12, -27, 83, 43, 77, -93, 79, 6, -17, 93, 33, 22, 6, 113, -5, -13, 20, -106, -36, -57, -21, -127, -89, 102, -62, -92, -124, 73, 118, 41, -120, 94, -100, 13, -34, -86, -103, 26, -57, -16, 22, -48, -71, 15, 40, 27, -125, -94, -93, -93, -3, -33, 60, 15, -29, -16, 70, -15, 30, 108, -105, 30, -65

int8_t var_7 = __riscv_vmv_x_s_i8m8_i8(var_10);
// 60

__riscv_vsetvl_e8m8(120);
vint8m8_t var_2 = __riscv_vrem_vv_i8m8_tumu(var_11, var_10, var_10, var_10, 120);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8mf2(8);
uint8_t var_13 = __riscv_vmv_x_s_u8mf2_u8(var_15);
// 197

__riscv_vsetvl_e8m8(31);
vint8m8_t var_12 = __riscv_vsll_vv_i8m8_tumu(var_42, var_3, var_43, var_44, 31);
// -52, 85, -58, 27, 110, -67, -54, 4, -100, 95, -74, -42, -123, -17, -71, -112, 119, -22, -4, -77, -118, -10, 30, -74, 0, 103, -122, 124, 59, -99, 78, -46, -52, 94, 14, -74, -97, 25, -59, 3, 68, -15, -60, 83, 80, -113, -90, -118, 7, -38, -57, -114, 88, -76, 8, 44, 45, 12, -27, 83, 43, 77, -93, 79, 6, -17, 93, 33, 22, 6, 113, -5, -13, 20, -106, -36, -57, -21, -127, -89, 102, -62, -92, -124, 73, 118, 41, -120, 94, -100, 13, -34, -86, -103, 26, -57, -16, 22, -48, -71, 15, 40, 27, -125, -94, -93, -93, -3, -33, 60, 15, -29, -16, 70, -15, 30, 108, -105, 30, -65

__riscv_vsetvl_e8m8(98);
vint8m8_t var_5 = __riscv_vsbc_vxm_i8m8(var_3, var_7, var_60, 98);
// -112, 25, -118, -33, 50, -127, -114, -56, 96, 35, 122, -102, 73, -77, 125, 84, 59, -82, -64, 119, 78, -70, -30, 122, -60, 43, 74, 64, -1, 97, 18, -106, -112, 34, -46, 122, 99, -35, -119, -57, 8, -75, -120, 23, 20, 83, 106, 78, -53, -98, -117, 82, 28, 120, -52, -16, -15, -48, -87, 23, -17, 17, 103, 19, -54, -77, 33, -27, -38, -54, 53, -65, -73, -40, 90, -96, -117, -81, 69, 107, 42, -122, 104, 72, 13, 58, -19, 76, 34, 96, -47, -94, 110, 93, -34, -117, -76, -38

__riscv_vsetvl_e8m8(120);
vint8m8_t var_1 = __riscv_vxor_vv_i8m8_tumu(var_11, var_0, var_2, var_2, 120);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vuint8m8_t var_8 = __riscv_vasubu_vx_u8m8(var_59, var_13, 120);
// 218, 246, 239, 246, 238, 166, 19, 14, 242, 1, 241, 218, 249, 179, 214, 204, 166, 219, 245, 179, 179, 4, 224, 178, 202, 253, 206, 163, 230, 251, 213, 25, 19, 195, 239, 168, 239, 17, 239, 205, 173, 251, 241, 202, 219, 223, 17, 162, 3, 6, 13, 17, 170, 229, 178, 246, 180, 249, 195, 250, 241, 229, 20, 249, 19, 174, 198, 221, 200, 11, 177, 160, 180, 216, 11, 19, 163, 17, 209, 174, 1, 9, 208, 241, 169, 190, 176, 19, 187, 198, 213, 208, 22, 4, 237, 180, 0, 188, 204, 203, 173, 188, 28, 180, 162, 218, 227, 160, 230, 214, 177, 172, 255, 15, 207, 199, 20, 165, 180, 206

__riscv_vsetvl_e8m8(31);
vint8m8_t var_17 = __riscv_vssra_vx_i8m8_tumu(var_31, var_12, var_32, var_76, 31);
// 41, 69, -57, 102, 86, 103, -128, 4, -118, -1, 109, 40, 7, 27, 79, -63, 35, 73, 1, 42, -85, 126, 107, 53, -114, 39, 53, 10, -94, -20, 125, -46, -52, 94, 14, -74, -97, 25, -59, 3, 68, -15, -60, 83, 80, -113, -90, -118, 7, -38, -57, -114, 88, -76, 8, 44, 45, 12, -27, 83, 43, 77, -93, 79, 6, -17, 93, 33, 22, 6, 113, -5, -13, 20, -106, -36, -57, -21, -127, -89, 102, -62, -92, -124, 73, 118, 41, -120, 94, -100, 13, -34, -86, -103, 26, -57, -16, 22, -48, -71, 15, 40, 27, -125, -94, -93, -93, -3, -33, 60, 15, -29, -16, 70, -15, 30, 108, -105, 30, -65

__riscv_vsetvl_e8m8(98);
vbool1_t var_6 = __riscv_vmseq_vv_i8m8_b1(var_5, var_10, 98);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e8m8(120);
vint8m8_t var_4 = __riscv_vssra_vv_i8m8_tumu(var_63, var_1, var_10, var_8, 120);
// 15, -2, 0, 0, -1, 0, 0, -2, 18, 0, 1, 0, 2, 10, 2, 0, 0, -9, 0, 0, 0, 0, 1, 0, 31, 2, 0, -5, 0, 3, -2, -17, -12, 0, 0, -1, 1, 47, -1, 0, 0, -1, 33, 0, 0, 1, 0, 0, -10, 0, 0, 61, 18, -3, 0, -1, 0, 0, 0, 14, 0, 3, 0, 0, 0, 0, 0, 0, -59, 0, 0, 55, 0, 11, 14, 0, 0, 0, 1, 0, 0, 0, -1, 17, 0, 2, 0, 0, -5, -1, 1, 0, 1, 6, 0, 0, 107, 0, 7, 0, 0, 0, 5, 7, 0, 0, 0, -1, 0, 0, -8, 0, 0, 0, -1, 0, -8, 1, 0, 0

__riscv_vsetvl_e8m8(31);
__riscv_vse8_v_i8m8(var_109, var_17, 31);
__riscv_vsetvl_e8m8(9);
vint8m8_t var_9 = __riscv_vmacc_vx_i8m8_tumu(var_6, var_10, var_80, var_57, 9);
// 60, -103, -44, -1, -43, 1, 0, -107, 72, 37, 1, 0, 3, 77, 110, 0, 0, -69, 1, -1, 0, -1, 1, 0, 122, 79, 1, -38, 21, 24, -52, -34, -94, 0, 0, -1, 74, 93, -85, -12, -15, -10, 65, 0, 1, 122, 0, 0, -78, 0, 0, 121, 73, -111, 1, -57, 1, 0, -1, 54, 0, 105, 0, -106, 0, 0, 0, 0, -59, 1, 0, 55, 0, 11, 114, 1, 0, 0, 1, -1, 0, 0, -1, 33, -1, 96, 0, 0, -37, -47, 35, 0, 52, 102, -1, 0, 107, 1, 107, 0, 0, -6, 84, 113, 0, 1, 0, -1, -1, 0, -17, -1, 0, -1, -99, 1, -125, 18, -1, 0

__riscv_vsetvl_e8m8(38);
vint8m8_t var_14 = __riscv_vmerge_vvm_i8m8(var_39, var_40, var_6, 38);
// 44, 40, 108, -73, 76, -34, -25, 4, 54, 94, -10, -29, 12, 116, -121, -32, 30, 61, 127, 16, -34, -95, -90, 124, -4, 12, 124, 18, 123, -37, -56, -119, 9, 12, 57, 30, -20, 29

__riscv_vsetvl_e8m8(98);
vuint8m8_t var_16 = __riscv_vslide1down_vx_u8m8_tumu(var_6, var_36, var_37, var_77, 98);
// 53, 28, 220, 181, 243, 150, 238, 37, 119, 182, 29, 252, 15, 156, 34, 201, 75, 149, 173, 112, 255, 58, 51, 176, 22, 103, 44, 150, 225, 31, 190, 70, 125, 112, 57, 3, 191, 131, 48, 89, 168, 58, 104, 228, 15, 80, 128, 101, 161, 132, 24, 17, 113, 126, 25, 23, 93, 18, 241, 203, 255, 142, 113, 233, 129, 137, 248, 173, 40, 23, 161, 100, 242, 77, 206, 18, 162, 57, 44, 215, 2, 43, 61, 116, 166, 21, 188, 74, 234, 245, 45, 44, 17, 240, 46, 58, 89, 254

__riscv_vsetvl_e8m8(120);
__riscv_vse8_v_i8m8(var_84, var_4, 120);
if(!check(var_109, var_121, var_122)) {cerr << "check 120 fails" << endl; return_value = 1;}
__riscv_vsetvl_e8m8(9);
__riscv_vse8_v_i8m8(var_88, var_9, 9);
__riscv_vsetvl_e8m8(38);
__riscv_vse8_v_i8m8(var_101, var_14, 38);
__riscv_vsetvl_e8m8(98);
__riscv_vse8_v_u8m8(var_104, var_16, 98);
if(!check(var_84, var_133, var_134)) {cerr << "check 132 fails" << endl; return_value = 1;}
if(!check(var_88, var_130, var_131)) {cerr << "check 129 fails" << endl; return_value = 1;}
if(!check(var_101, var_127, var_128)) {cerr << "check 126 fails" << endl; return_value = 1;}
if(!check(var_104, var_124, var_125)) {cerr << "check 123 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
