; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -S -passes=instsimplify %s | FileCheck %s

; Test that we're able to make use of assumes of fcmps with constants
; that aren't 0/inf/smallest-normal. Range checks can exclude certain
; classes.

declare void @llvm.assume(i1 noundef) #0
declare float @llvm.fabs.f32(float) #0

; --------------------------------------------------------------------
; Test assume x < -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_olt_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x <= -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ole_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_NEG1:%.*]] = fcmp ole float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.neg1 = fcmp ole float %arg, -1.0
  call void @llvm.assume(i1 %ole.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x > -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ogt_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_NEG1:%.*]] = fcmp ogt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.neg1 = fcmp ogt float %arg, -1.0
  call void @llvm.assume(i1 %ogt.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x >= -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_oge_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_NEG1:%.*]] = fcmp oge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.neg1 = fcmp oge float %arg, -1.0
  call void @llvm.assume(i1 %oge.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u>= -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_uge_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_NEG1:%.*]] = fcmp uge float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.neg1 = fcmp uge float %arg, -1.0
  call void @llvm.assume(i1 %uge.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u> -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ugt_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_NEG1:%.*]] = fcmp ugt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.neg1 = fcmp ugt float %arg, -1.0
  call void @llvm.assume(i1 %ugt.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u<= -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ule_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ule_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULE_NEG1:%.*]] = fcmp ule float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULE_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ule.neg1 = fcmp ule float %arg, -1.0
  call void @llvm.assume(i1 %ule.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u< -1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ult_neg1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ult_neg1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neg1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ULT_NEG1:%.*]] = fcmp ult float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ULT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ult.neg1 = fcmp ult float %arg, -1.0
  call void @llvm.assume(i1 %ult.neg1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x == 0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_oeq_0__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oeq_0__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OEQ_0:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OEQ_0]])
; CHECK-NEXT:    ret i1 true
;
  %oeq.0 = fcmp oeq float %arg, 0.0
  call void @llvm.assume(i1 %oeq.0)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oeq_0__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oeq_0__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OEQ_0:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OEQ_0]])
; CHECK-NEXT:    ret i1 true
;
  %oeq.0 = fcmp oeq float %arg, 0.0
  call void @llvm.assume(i1 %oeq.0)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_one_0__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_one_0__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OEQ_0:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OEQ_0]])
; CHECK-NEXT:    ret i1 false
;
  %oeq.0 = fcmp one float %arg, 0.0
  call void @llvm.assume(i1 %oeq.0)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ueq_0__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ueq_0__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OEQ_0:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OEQ_0]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %oeq.0 = fcmp ueq float %arg, 0.0
  call void @llvm.assume(i1 %oeq.0)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ueq_0__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ueq_0__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UEQ_0:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UEQ_0]])
; CHECK-NEXT:    ret i1 true
;
  %ueq.0 = fcmp ueq float %arg, 0.0
  call void @llvm.assume(i1 %ueq.0)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_one_0__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_one_0__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ONE_0:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ONE_0]])
; CHECK-NEXT:    ret i1 false
;
  %one.0 = fcmp one float %arg, 0.0
  call void @llvm.assume(i1 %one.0)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_one_0__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_one_0__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ONE_0:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ONE_0]])
; CHECK-NEXT:    ret i1 true
;
  %one.0 = fcmp one float %arg, 0.0
  call void @llvm.assume(i1 %one.0)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_une_0__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_une_0__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ONE_0:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ONE_0]])
; CHECK-NEXT:    ret i1 false
;
  %one.0 = fcmp une float %arg, 0.0
  call void @llvm.assume(i1 %one.0)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_une_0__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_une_0__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[ONE_0:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[ONE_0]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %one.0 = fcmp une float %arg, 0.0
  call void @llvm.assume(i1 %one.0)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x < 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_olt_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_olt_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_POS1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.pos1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x <= 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ole_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ole_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ole_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLE_POS1:%.*]] = fcmp ole float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ole.pos1 = fcmp ole float %arg, 1.0
  call void @llvm.assume(i1 %ole.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x > 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ogt_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ogt_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGT_POS1:%.*]] = fcmp ogt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ogt.pos1 = fcmp ogt float %arg, 1.0
  call void @llvm.assume(i1 %ogt.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x >= 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_oge_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_oge_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OGE_POS1:%.*]] = fcmp oge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %oge.pos1 = fcmp oge float %arg, 1.0
  call void @llvm.assume(i1 %oge.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u> 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_ugt_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_ugt_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_ugt_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGT_POS1:%.*]] = fcmp ugt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGT_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ugt.pos1 = fcmp ugt float %arg, 1.0
  call void @llvm.assume(i1 %ugt.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x u>= 1.0 with compares to 0
; --------------------------------------------------------------------

define i1 @assume_uge_pos1__oeq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__oeq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp oeq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ogt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ogt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ogt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__oge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__oge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp oge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__olt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__olt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp olt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ole_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ole_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 false
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ole float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__one_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__one_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp one float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ord_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ord_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ord float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ueq_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ueq_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ueq float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ugt_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ugt_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ugt float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__uge_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__uge_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp uge float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ult_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ult_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ult float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__ule_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__ule_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp ule float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__une_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__une_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    ret i1 true
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp une float %arg, 0.0
  ret i1 %cmp
}

define i1 @assume_uge_pos1__uno_0(float %arg) {
; CHECK-LABEL: define i1 @assume_uge_pos1__uno_0(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[UGE_POS1:%.*]] = fcmp uge float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[UGE_POS1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno float [[ARG]], 0.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uge.pos1 = fcmp uge float %arg, 1.0
  call void @llvm.assume(i1 %uge.pos1)
  %cmp = fcmp uno float %arg, 0.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Test assume x < -1.0 with compares to inf
; --------------------------------------------------------------------

define i1 @assume_olt_neg1__oeq_inf(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__oeq_inf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 false
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp oeq float %arg, 0x7FF0000000000000
  ret i1 %cmp
}

define i1 @assume_olt_neg1__one_inf(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__one_inf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    ret i1 true
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp one float %arg, 0x7FF0000000000000
  ret i1 %cmp
}

define i1 @assume_olt_neg1__oeq_ninf(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__oeq_ninf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp oeq float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_olt_neg1__one_ninf(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_neg1__one_ninf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_NEG1:%.*]] = fcmp olt float [[ARG]], -1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_NEG1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.neg1 = fcmp olt float %arg, -1.0
  call void @llvm.assume(i1 %olt.neg1)
  %cmp = fcmp one float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Other
; --------------------------------------------------------------------

define i1 @assume_olt_1__oeq_2(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_1__oeq_2(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_1:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 2.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.1 = fcmp olt float %arg, 1.0
  call void @llvm.assume(i1 %olt.1)
  %cmp = fcmp oeq float %arg, 2.0
  ret i1 %cmp
}

; Ideally would fold to false
define i1 @assume_ogt_2__oeq_2(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_2__oeq_2(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_1:%.*]] = fcmp ogt float [[ARG]], 2.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 2.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.1 = fcmp ogt float %arg, 2.0
  call void @llvm.assume(i1 %olt.1)
  %cmp = fcmp oeq float %arg, 2.0
  ret i1 %cmp
}

define i1 @assume_olt_2__olt_1(float %arg) {
; CHECK-LABEL: define i1 @assume_olt_2__olt_1(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[OLT_1:%.*]] = fcmp olt float [[ARG]], 2.000000e+00
; CHECK-NEXT:    call void @llvm.assume(i1 [[OLT_1]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[ARG]], 1.000000e+00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %olt.1 = fcmp olt float %arg, 2.0
  call void @llvm.assume(i1 %olt.1)
  %cmp = fcmp olt float %arg, 1.0
  ret i1 %cmp
}

; --------------------------------------------------------------------
; Negative infinity
; --------------------------------------------------------------------

define i1 @assume_ogt_neginf_one_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neginf_one_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_OGT_NEGINF:%.*]] = fcmp ogt float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGT_NEGINF]])
; CHECK-NEXT:    ret i1 true
;
  %cmp.ogt.neginf = fcmp ogt float %arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ogt.neginf)
  %cmp = fcmp one float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_ogt_neginf_oeq_posinf(float %arg) {
; CHECK-LABEL: define i1 @assume_ogt_neginf_oeq_posinf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_OGT_NEGINF:%.*]] = fcmp ogt float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGT_NEGINF]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0x7FF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp.ogt.neginf = fcmp ogt float %arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ogt.neginf)
  %cmp = fcmp oeq float %arg, 0x7FF0000000000000
  ret i1 %cmp
}

define i1 @assume_ule_neginf_oeq_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_ule_neginf_oeq_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_ULE_NEGINF:%.*]] = fcmp ule float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_ULE_NEGINF]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp.ule.neginf = fcmp ule float %arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ule.neginf)
  %cmp = fcmp oeq float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_ult_neginf_oeq_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_ult_neginf_oeq_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_ULT_NEGINF:%.*]] = fcmp ult float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_ULT_NEGINF]])
; CHECK-NEXT:    ret i1 false
;
  %cmp.ult.neginf = fcmp ult float %arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ult.neginf)
  %cmp = fcmp oeq float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_fabs_ogt_neginf_one_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_fabs_ogt_neginf_one_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS_ARG:%.*]] = call float @llvm.fabs.f32(float [[ARG]])
; CHECK-NEXT:    [[CMP_OGT_NEGINF:%.*]] = fcmp ogt float [[FABS_ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGT_NEGINF]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %fabs.arg = call float @llvm.fabs.f32(float %arg)
  %cmp.ogt.neginf = fcmp ogt float %fabs.arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ogt.neginf)
  %cmp = fcmp one float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_fabs_ogt_neginf_one_posinf(float %arg) {
; CHECK-LABEL: define i1 @assume_fabs_ogt_neginf_one_posinf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS_ARG:%.*]] = call float @llvm.fabs.f32(float [[ARG]])
; CHECK-NEXT:    [[CMP_OGT_NEGINF:%.*]] = fcmp ogt float [[FABS_ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGT_NEGINF]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one float [[ARG]], 0x7FF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %fabs.arg = call float @llvm.fabs.f32(float %arg)
  %cmp.ogt.neginf = fcmp ogt float %fabs.arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ogt.neginf)
  %cmp = fcmp one float %arg, 0x7FF0000000000000
  ret i1 %cmp
}

define i1 @assume_fabs_ule_neginf_oeq_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_fabs_ule_neginf_oeq_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[FABS_ARG:%.*]] = call float @llvm.fabs.f32(float [[ARG]])
; CHECK-NEXT:    [[CMP_OGT_NEGINF:%.*]] = fcmp ule float [[FABS_ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGT_NEGINF]])
; CHECK-NEXT:    ret i1 false
;
  %fabs.arg = call float @llvm.fabs.f32(float %arg)
  %cmp.ogt.neginf = fcmp ule float %fabs.arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.ogt.neginf)
  %cmp = fcmp oeq float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

define i1 @assume_oge_neginf_oeq_neginf(float %arg) {
; CHECK-LABEL: define i1 @assume_oge_neginf_oeq_neginf(
; CHECK-SAME: float [[ARG:%.*]]) {
; CHECK-NEXT:    [[CMP_OGE_NEGINF:%.*]] = fcmp oge float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP_OGE_NEGINF]])
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq float [[ARG]], 0xFFF0000000000000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp.oge.neginf = fcmp oge float %arg, 0xFFF0000000000000
  call void @llvm.assume(i1 %cmp.oge.neginf)
  %cmp = fcmp oeq float %arg, 0xFFF0000000000000
  ret i1 %cmp
}

attributes #0 = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: readwrite) }
