; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test 128-bit shift right logica in vector registers on z13
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Shift right logical immediate (general case).
define i128 @f1(i128 %a) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepib %v1, 100
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = lshr i128 %a, 100
  ret i128 %res
}

; Shift right logical immediate (< 8 bits).
define i128 @f2(i128 %a) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepib %v1, 7
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = lshr i128 %a, 7
  ret i128 %res
}

; Shift right logical immediate (full bytes).
define i128 @f3(i128 %a) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepib %v1, 32
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = lshr i128 %a, 32
  ret i128 %res
}

; Shift right logical variable.
define i128 @f4(i128 %a, i128 %sh) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r4)
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = lshr i128 %a, %sh
  ret i128 %res
}

; Test removal of AND mask with only bottom 7 bits set.
define i128 @f5(i128 %a, i128 %sh) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r4)
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %and = and i128 %sh, 127
  %shift = lshr i128 %a, %and
  ret i128 %shift
}

; Test removal of AND mask including but not limited to bottom 7 bits.
define i128 @f6(i128 %a, i128 %sh) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r0, 12(%r4)
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %and = and i128 %sh, 511
  %shift = lshr i128 %a, %and
  ret i128 %shift
}

; Test that AND is not removed when some lower 7 bits are not set.
define i128 @f7(i128 %a, i128 %sh) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lhi %r0, 63
; CHECK-NEXT:    n %r0, 12(%r4)
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %and = and i128 %sh, 63
  %shift = lshr i128 %a, %and
  ret i128 %shift
}

; Test that AND with two register operands is not affected.
define i128 @f8(i128 %a, i128 %b, i128 %sh) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r5), 3
; CHECK-NEXT:    vn %v1, %v2, %v1
; CHECK-NEXT:    vlgvf %r0, %v1, 3
; CHECK-NEXT:    vlvgp %v1, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v1, %v1, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v1
; CHECK-NEXT:    vsrl %v0, %v0, %v1
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %and = and i128 %sh, %b
  %shift = lshr i128 %a, %and
  ret i128 %shift
}

; Test that AND is not entirely removed if the result is reused.
define i128 @f9(i128 %a, i128 %sh) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    larl %r1, .LCPI8_0
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r1), 3
; CHECK-NEXT:    vn %v1, %v1, %v2
; CHECK-NEXT:    vlgvf %r0, %v1, 3
; CHECK-NEXT:    vlvgp %v2, %r0, %r0
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vrepb %v2, %v2, 15
; CHECK-NEXT:    vsrlb %v0, %v0, %v2
; CHECK-NEXT:    vsrl %v0, %v0, %v2
; CHECK-NEXT:    vaq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %and = and i128 %sh, 127
  %shift = lshr i128 %a, %and
  %reuse = add i128 %and, %shift
  ret i128 %reuse
}

