; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half>, <vscale x 1 x half>, metadata, metadata)
define <vscale x 1 x i1> @fcmps_oeq_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vv_nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vf_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %va, <vscale x 1 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_fv_nxv1f16(<vscale x 1 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f16(<vscale x 1 x half> %splat, <vscale x 1 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

declare <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half>, <vscale x 2 x half>, metadata, metadata)
define <vscale x 2 x i1> @fcmps_oeq_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vv_nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vf_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %va, <vscale x 2 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_fv_nxv2f16(<vscale x 2 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f16(<vscale x 2 x half> %splat, <vscale x 2 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

declare <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half>, <vscale x 4 x half>, metadata, metadata)
define <vscale x 4 x i1> @fcmps_oeq_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vv_nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vf_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %va, <vscale x 4 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_fv_nxv4f16(<vscale x 4 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f16(<vscale x 4 x half> %splat, <vscale x 4 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

declare <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half>, <vscale x 8 x half>, metadata, metadata)
define <vscale x 8 x i1> @fcmps_oeq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmnot.m v8, v10
; CHECK-NEXT:    vmorn.mm v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vf_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v10, fa0
; CHECK-NEXT:    vmnot.m v9, v12
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_fv_nxv8f16(<vscale x 8 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmnot.m v10, v12
; CHECK-NEXT:    vmfle.vv v11, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f16(<vscale x 8 x half> %splat, <vscale x 8 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

declare <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half>, <vscale x 16 x half>, metadata, metadata)
define <vscale x 16 x i1> @fcmps_oeq_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oeq_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oeq_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_vv_nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmnot.m v8, v12
; CHECK-NEXT:    vmorn.mm v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_vf_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v12, fa0
; CHECK-NEXT:    vmnot.m v9, v16
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %va, <vscale x 16 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_fv_nxv16f16(<vscale x 16 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmnot.m v12, v16
; CHECK-NEXT:    vmfle.vv v13, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v12, v13
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f16(<vscale x 16 x half> %splat, <vscale x 16 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

declare <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half>, <vscale x 32 x half>, metadata, metadata)
define <vscale x 32 x i1> @fcmps_oeq_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_oeq_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_oeq_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ogt_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ogt_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ogt_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_oge_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_oge_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_oge_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_olt_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_olt_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_olt_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ole_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ole_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ole_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_one_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_one_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_one_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ord_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ord_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ord_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v24, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ueq_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmnor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ueq_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ueq_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ugt_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ugt_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ugt_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uge_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uge_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uge_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ult_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ult_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ult_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ule_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ule_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_ule_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_une_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmnand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_une_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_une_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uno_vv_nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmnot.m v8, v16
; CHECK-NEXT:    vmorn.mm v0, v8, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uno_vf_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vv v24, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v16, fa0
; CHECK-NEXT:    vmnot.m v9, v24
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %va, <vscale x 32 x half> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

define <vscale x 32 x i1> @fcmps_uno_fv_nxv32f16(<vscale x 32 x half> %va, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmnot.m v16, v24
; CHECK-NEXT:    vmfle.vv v17, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v16, v17
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x half> poison, half %b, i32 0
  %splat = shufflevector <vscale x 32 x half> %head, <vscale x 32 x half> poison, <vscale x 32 x i32> zeroinitializer
  %1 = call <vscale x 32 x i1> @llvm.experimental.constrained.fcmps.nxv32f16(<vscale x 32 x half> %splat, <vscale x 32 x half> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 32 x i1> %1
}

declare <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float>, <vscale x 1 x float>, metadata, metadata)
define <vscale x 1 x i1> @fcmps_oeq_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vf_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_fv_nxv1f32(<vscale x 1 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f32(<vscale x 1 x float> %splat, <vscale x 1 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

declare <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float>, <vscale x 2 x float>, metadata, metadata)
define <vscale x 2 x i1> @fcmps_oeq_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vf_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_fv_nxv2f32(<vscale x 2 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f32(<vscale x 2 x float> %splat, <vscale x 2 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

declare <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float>, <vscale x 4 x float>, metadata, metadata)
define <vscale x 4 x i1> @fcmps_oeq_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmnot.m v8, v10
; CHECK-NEXT:    vmorn.mm v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vf_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v10, fa0
; CHECK-NEXT:    vmnot.m v9, v12
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_fv_nxv4f32(<vscale x 4 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmnot.m v10, v12
; CHECK-NEXT:    vmfle.vv v11, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f32(<vscale x 4 x float> %splat, <vscale x 4 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

declare <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float>, <vscale x 8 x float>, metadata, metadata)
define <vscale x 8 x i1> @fcmps_oeq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmnot.m v8, v12
; CHECK-NEXT:    vmorn.mm v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vf_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v12, fa0
; CHECK-NEXT:    vmnot.m v9, v16
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_fv_nxv8f32(<vscale x 8 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmnot.m v12, v16
; CHECK-NEXT:    vmfle.vv v13, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v12, v13
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f32(<vscale x 8 x float> %splat, <vscale x 8 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

declare <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float>, <vscale x 16 x float>, metadata, metadata)
define <vscale x 16 x i1> @fcmps_oeq_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oeq_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oeq_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ogt_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_oge_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_olt_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ole_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_one_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ord_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v24, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmnor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ueq_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ugt_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uge_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ult_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_ule_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmnand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_une_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmnot.m v8, v16
; CHECK-NEXT:    vmorn.mm v0, v8, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_vf_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vv v24, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v16, fa0
; CHECK-NEXT:    vmnot.m v9, v24
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x float> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i1> @fcmps_uno_fv_nxv16f32(<vscale x 16 x float> %va, float %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmnot.m v16, v24
; CHECK-NEXT:    vmfle.vv v17, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v16, v17
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x float> poison, float %b, i32 0
  %splat = shufflevector <vscale x 16 x float> %head, <vscale x 16 x float> poison, <vscale x 16 x i32> zeroinitializer
  %1 = call <vscale x 16 x i1> @llvm.experimental.constrained.fcmps.nxv16f32(<vscale x 16 x float> %splat, <vscale x 16 x float> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 16 x i1> %1
}

declare <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double>, <vscale x 1 x double>, metadata, metadata)
define <vscale x 1 x i1> @fcmps_oeq_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oeq_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ogt_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v9, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_oge_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_olt_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ole_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_one_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ord_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmand.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v10, v8, v9
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnor.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v9, v8, fa0
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ueq_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v9, v8, fa0
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ugt_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v8, v9
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uge_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ult_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vv v8, v9, v8
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfgt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_ule_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmflt.vf v8, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v10, v9, v8
; CHECK-NEXT:    vmfle.vv v8, v8, v9
; CHECK-NEXT:    vmnand.mm v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfge.vf v9, v8, fa0
; CHECK-NEXT:    vmfle.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_une_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vf v9, v8, fa0
; CHECK-NEXT:    vmfge.vf v8, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmfle.vv v9, v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_vf_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v8, v8
; CHECK-NEXT:    vmorn.mm v0, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

define <vscale x 1 x i1> @fcmps_uno_fv_nxv1f64(<vscale x 1 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.v.f v9, fa0
; CHECK-NEXT:    vmfle.vf v9, v9, fa0
; CHECK-NEXT:    vmnot.m v9, v9
; CHECK-NEXT:    vmfle.vv v8, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 1 x double> %head, <vscale x 1 x double> poison, <vscale x 1 x i32> zeroinitializer
  %1 = call <vscale x 1 x i1> @llvm.experimental.constrained.fcmps.nxv1f64(<vscale x 1 x double> %splat, <vscale x 1 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 1 x i1> %1
}

declare <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double>, <vscale x 2 x double>, metadata, metadata)
define <vscale x 2 x i1> @fcmps_oeq_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oeq_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ogt_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_oge_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_olt_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ole_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_one_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v10, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ord_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmflt.vv v13, v10, v8
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmfgt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ueq_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmflt.vf v11, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ugt_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v8, v10
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uge_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ult_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vv v12, v10, v8
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfgt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_ule_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmflt.vf v10, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v8
; CHECK-NEXT:    vmfle.vv v13, v8, v10
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfge.vf v10, v8, fa0
; CHECK-NEXT:    vmfle.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_une_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vf v10, v8, fa0
; CHECK-NEXT:    vmfge.vf v11, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v11, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vmfle.vv v12, v10, v10
; CHECK-NEXT:    vmfle.vv v10, v8, v8
; CHECK-NEXT:    vmnot.m v8, v10
; CHECK-NEXT:    vmorn.mm v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_vf_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v10, fa0
; CHECK-NEXT:    vmnot.m v9, v12
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

define <vscale x 2 x i1> @fcmps_uno_fv_nxv2f64(<vscale x 2 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.v.f v10, fa0
; CHECK-NEXT:    vmfle.vf v12, v10, fa0
; CHECK-NEXT:    vmnot.m v10, v12
; CHECK-NEXT:    vmfle.vv v11, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v10, v11
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 2 x double> %head, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %1 = call <vscale x 2 x i1> @llvm.experimental.constrained.fcmps.nxv2f64(<vscale x 2 x double> %splat, <vscale x 2 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 2 x i1> %1
}

declare <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double>, <vscale x 4 x double>, metadata, metadata)
define <vscale x 4 x i1> @fcmps_oeq_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oeq_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ogt_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_oge_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_olt_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ole_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_one_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ord_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmflt.vv v17, v12, v8
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ueq_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmflt.vf v13, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ugt_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uge_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ult_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_ule_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8
; CHECK-NEXT:    vmfle.vv v17, v8, v12
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0
; CHECK-NEXT:    vmfle.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_une_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0
; CHECK-NEXT:    vmfge.vf v13, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v13, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v12
; CHECK-NEXT:    vmfle.vv v12, v8, v8
; CHECK-NEXT:    vmnot.m v8, v12
; CHECK-NEXT:    vmorn.mm v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_vf_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v12, fa0
; CHECK-NEXT:    vmnot.m v9, v16
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

define <vscale x 4 x i1> @fcmps_uno_fv_nxv4f64(<vscale x 4 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vmfle.vf v16, v12, fa0
; CHECK-NEXT:    vmnot.m v12, v16
; CHECK-NEXT:    vmfle.vv v13, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v12, v13
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 4 x double> %head, <vscale x 4 x double> poison, <vscale x 4 x i32> zeroinitializer
  %1 = call <vscale x 4 x i1> @llvm.experimental.constrained.fcmps.nxv4f64(<vscale x 4 x double> %splat, <vscale x 4 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 4 x i1> %1
}

declare <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double>, <vscale x 8 x double>, metadata, metadata)
define <vscale x 8 x i1> @fcmps_oeq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oeq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ogt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_oge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"oge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_olt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"olt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ole_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ole", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_one_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"one", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v16, v24
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ord_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmand.mm v0, v24, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ord", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vmnor.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmfgt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ueq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmflt.vf v17, v8, fa0
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ugt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v8, v16
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"uge", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ult_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ult", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vv v24, v16, v8
; CHECK-NEXT:    vmnot.m v0, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfgt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_ule_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmflt.vf v16, v8, fa0
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"ule", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v8
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vmnand.mm v0, v25, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfge.vf v16, v8, fa0
; CHECK-NEXT:    vmfle.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_une_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vf v16, v8, fa0
; CHECK-NEXT:    vmfge.vf v17, v8, fa0
; CHECK-NEXT:    vmnand.mm v0, v17, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"une", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vmfle.vv v24, v16, v16
; CHECK-NEXT:    vmfle.vv v16, v8, v8
; CHECK-NEXT:    vmnot.m v8, v16
; CHECK-NEXT:    vmorn.mm v0, v8, v24
; CHECK-NEXT:    ret
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_vf_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vv v24, v8, v8
; CHECK-NEXT:    vmfle.vf v8, v16, fa0
; CHECK-NEXT:    vmnot.m v9, v24
; CHECK-NEXT:    vmorn.mm v0, v9, v8
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %splat, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}

define <vscale x 8 x i1> @fcmps_uno_fv_nxv8f64(<vscale x 8 x double> %va, double %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfle.vf v24, v16, fa0
; CHECK-NEXT:    vmnot.m v16, v24
; CHECK-NEXT:    vmfle.vv v17, v8, v8
; CHECK-NEXT:    vmorn.mm v0, v16, v17
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> poison, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> poison, <vscale x 8 x i32> zeroinitializer
  %1 = call <vscale x 8 x i1> @llvm.experimental.constrained.fcmps.nxv8f64(<vscale x 8 x double> %splat, <vscale x 8 x double> %va, metadata !"uno", metadata !"fpexcept.strict") strictfp
  ret <vscale x 8 x i1> %1
}
