; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s

; These two loads will CSE, we need to conservatively combine the range
; metadata. The final assembly should not contain an OR.
define i32 @f(ptr %p) {
; CHECK-LABEL: f:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a0, 0(a0)
; CHECK-NEXT:    lui a1, 294471
; CHECK-NEXT:    addi a1, a1, 1064
; CHECK-NEXT:    addw a0, a0, a1
; CHECK-NEXT:    ret
  %load = load i32, ptr %p, align 4, !range !0
  %load2 = load i32, ptr %p, align 4
  %add = add i32 1206154280, %load2
  ret i32 %add
}

; The mul and getelementptr will get removed in DAGCombine causing the loads
; to CSE after they are created.
define i32 @test(ptr %p, i32 %x, ptr %q) {
; CHECK-LABEL: test:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lw a1, 0(a0)
; CHECK-NEXT:    lui a0, 294471
; CHECK-NEXT:    addi a0, a0, 1064
; CHECK-NEXT:    addw a0, a1, a0
; CHECK-NEXT:    sw a1, 0(a2)
; CHECK-NEXT:    ret
  %load = load i32, ptr %p, align 4, !range !0
  %mul = mul i32 0, %x
  %a = getelementptr i32, ptr %p, i32 %mul
  %load2 = load i32, ptr %a, align 4
  %add = add i32 1206154280, %load2
  store i32 %load, ptr %q
  ret i32 %add
}

!0 = !{i32 1, i32 2, i32 3, i32 4}
