; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes='simplifycfg<hoist-common-insts>' -mtriple=amdgcn-- --fp-contract=fast -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX -check-prefix=FP-CONTRACT-FAST %s
; RUN: opt -S -passes='simplifycfg<hoist-common-insts>' -mtriple=amdgcn-- --fp-contract=off --enable-unsafe-fp-math -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX -check-prefix=UNSAFE-FP-MATH %s
; RUN: opt -S -passes='simplifycfg<hoist-common-insts>' -mtriple=amdgcn-- --fp-contract=off -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX -check-prefix=NO-UNSAFE-FP-MATH %s

define double @is_profitable_f64_contract(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define double @is_profitable_f64_contract(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0:[0-9]+]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load double, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq double [[Y]], 0.000000e+00
; GFX-NEXT:    [[X:%.*]] = load double, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load double, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract double [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi double [ [[ADD:%.*]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret double [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD]] = fadd contract double 1.000000e+00, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract double [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load double, ptr %ptr_y, align 8
  %cmp = fcmp oeq double %y, 0.000000e+00
  %x = load double, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load double, ptr %ptr_a, align 8
  %mul = fmul contract double %x, %a_1
  %add = fadd contract double 1.000000e+00, %mul
  ret double %add

if.else:                                          ; preds = %entry
  %a_2 = load double, ptr %ptr_a, align 8
  %mul1 = fmul contract double %x, %a_2
  %sub = fsub contract double %mul1, %y
  ret double %sub
}

define double @is_profitable_f64_modifiers(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define double @is_profitable_f64_modifiers(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load double, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq double [[Y]], 0.000000e+00
; GFX-NEXT:    [[X:%.*]] = load double, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load double, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract double [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi double [ [[ADD:%.*]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret double [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[FNEG:%.*]] = fneg double [[MUL]]
; GFX-NEXT:    [[ADD]] = fadd contract double 1.000000e+00, [[FNEG]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[FABS:%.*]] = call double @llvm.fabs.f64(double [[MUL]])
; GFX-NEXT:    [[SUB]] = fsub contract double [[FABS]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load double, ptr %ptr_y, align 8
  %cmp = fcmp oeq double %y, 0.000000e+00
  %x = load double, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load double, ptr %ptr_a, align 8
  %mul = fmul contract double %x, %a_1
  %fneg = fneg double %mul
  %add = fadd contract double 1.000000e+00, %fneg
  ret double %add

if.else:                                          ; preds = %entry
  %a_2 = load double, ptr %ptr_a, align 8
  %mul1 = fmul contract double %x, %a_2
  %fabs = call double @llvm.fabs.f64(double %mul1)
  %sub = fsub contract double %fabs, %y
  ret double %sub
}

define float @is_profitable_f32(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define float @is_profitable_f32(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load float, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq float [[Y]], 0.000000e+00
; GFX-NEXT:    [[X:%.*]] = load float, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load float, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract float [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi float [ [[MUL]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret float [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD:%.*]] = fadd contract float 1.000000e+00, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract float [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load float, ptr %ptr_y, align 8
  %cmp = fcmp oeq float %y, 0.000000e+00
  %x = load float, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else


if.then:                                          ; preds = %entry
  %a_1 = load float, ptr %ptr_a, align 8
  %mul = fmul contract float %x, %a_1
  %add = fadd contract float 1.000000e+00, %mul
  ret float %mul

if.else:                                          ; preds = %entry
  %a_2 = load float, ptr %ptr_a, align 8
  %mul1 = fmul contract float %x, %a_2
  %sub = fsub contract float %mul1, %y
  ret float %sub
}

define half @is_profitable_f16_preserve(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define half @is_profitable_f16_preserve(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load half, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq half [[Y]], 0xH0000
; GFX-NEXT:    [[X:%.*]] = load half, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load half, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract half [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi half [ [[MUL]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret half [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD:%.*]] = fadd contract half [[Y]], [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract half [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load half, ptr %ptr_y, align 8
  %cmp = fcmp oeq half %y, 0.000000e+00
  %x = load half, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load half, ptr %ptr_a, align 8
  %mul = fmul contract half %x, %a_1
  %add = fadd contract half %y, %mul
  ret half %mul

if.else:                                          ; preds = %entry
  %a_2 = load half, ptr %ptr_a, align 8
  %mul1 = fmul contract half %x, %a_2
  %sub = fsub contract half %mul1, %y
  ret half %sub
}

define half @is_profitable_f16_ieee(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #1 {
; GFX-LABEL: define half @is_profitable_f16_ieee(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR1:[0-9]+]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load half, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq half [[Y]], 0xH0000
; GFX-NEXT:    [[X:%.*]] = load half, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load half, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract half [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi half [ [[MUL]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret half [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD:%.*]] = fadd contract half [[Y]], [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract half [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load half, ptr %ptr_y, align 8
  %cmp = fcmp oeq half %y, 0.000000e+00
  %x = load half, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load half, ptr %ptr_a, align 8
  %mul = fmul contract half %x, %a_1
  %add = fadd contract half %y, %mul
  ret half %mul

if.else:                                          ; preds = %entry
  %a_2 = load half, ptr %ptr_a, align 8
  %mul1 = fmul contract half %x, %a_2
  %sub = fsub contract half %mul1, %y
  ret half %sub
}

define bfloat @is_profitable_bfloat_preserve(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define bfloat @is_profitable_bfloat_preserve(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load bfloat, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq bfloat [[Y]], 0xR0000
; GFX-NEXT:    [[X:%.*]] = load bfloat, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load bfloat, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract bfloat [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi bfloat [ [[MUL]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret bfloat [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD:%.*]] = fadd contract bfloat 0xR3F80, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract bfloat [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load bfloat, ptr %ptr_y, align 8
  %cmp = fcmp oeq bfloat %y, 0.000000e+00
  %x = load bfloat, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load bfloat, ptr %ptr_a, align 8
  %mul = fmul contract bfloat %x, %a_1
  %add = fadd contract bfloat 1.000000e+00, %mul
  ret bfloat %mul

if.else:                                          ; preds = %entry
  %a_2 = load bfloat, ptr %ptr_a, align 8
  %mul1 = fmul contract bfloat %x, %a_2
  %sub = fsub contract bfloat %mul1, %y
  ret bfloat %sub
}

define bfloat @is_profitable_bfloat_ieee(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #1 {
; GFX-LABEL: define bfloat @is_profitable_bfloat_ieee(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR1]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load bfloat, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq bfloat [[Y]], 0xR0000
; GFX-NEXT:    [[X:%.*]] = load bfloat, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load bfloat, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul contract bfloat [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi bfloat [ [[MUL]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret bfloat [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD:%.*]] = fadd contract bfloat 0xR3F80, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract bfloat [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load bfloat, ptr %ptr_y, align 8
  %cmp = fcmp oeq bfloat %y, 0.000000e+00
  %x = load bfloat, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load bfloat, ptr %ptr_a, align 8
  %mul = fmul contract bfloat %x, %a_1
  %add = fadd contract bfloat 1.000000e+00, %mul
  ret bfloat %mul

if.else:                                          ; preds = %entry
  %a_2 = load bfloat, ptr %ptr_a, align 8
  %mul1 = fmul contract bfloat %x, %a_2
  %sub = fsub contract bfloat %mul1, %y
  ret bfloat %sub
}

define double @is_profitable_constant(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #1 {
; GFX-LABEL: define double @is_profitable_constant(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR1]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load double, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq double [[Y]], 0.000000e+00
; GFX-NEXT:    [[X:%.*]] = load double, ptr [[PTR_X]], align 8
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi double [ [[ADD:%.*]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret double [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[MUL:%.*]] = fmul contract double 2.000000e+00, [[X]]
; GFX-NEXT:    [[ADD]] = fadd contract double 1.000000e+00, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[MUL1:%.*]] = fmul contract double 3.000000e+00, [[X]]
; GFX-NEXT:    [[SUB]] = fsub contract double [[MUL1]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load double, ptr %ptr_y, align 8
  %cmp = fcmp oeq double %y, 0.000000e+00
  %x = load double, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %mul = fmul contract double 2.000000e+00, %x
  %add = fadd contract double 1.000000e+00, %mul
  ret double %add

if.else:                                          ; preds = %entry
  %mul1 = fmul contract double 3.000000e+00, %x
  %sub = fsub contract double %mul1, %y
  ret double %sub
}

@v1_ptr = external addrspace(3) global ptr
@v2_ptr = external addrspace(3) global ptr

define <8 x half> @is_profitable_vector(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) {
; GFX-LABEL: define <8 x half> @is_profitable_vector(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR2:[0-9]+]] {
; GFX-NEXT:  [[ENTRY:.*:]]
; GFX-NEXT:    [[Y:%.*]] = load double, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[X:%.*]] = load <8 x half>, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[V1:%.*]] = load <8 x half>, ptr addrspace(3) @v1_ptr, align 16
; GFX-NEXT:    [[V2:%.*]] = load <8 x half>, ptr addrspace(3) @v2_ptr, align 16
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq double [[Y]], 0.000000e+00
; GFX-NEXT:    [[MUL:%.*]] = fmul contract <8 x half> [[V1]], [[X]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi <8 x half> [ [[ADD:%.*]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret <8 x half> [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[ADD]] = fadd contract <8 x half> [[V2]], [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub contract <8 x half> [[MUL]], [[V2]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
entry:
  %y = load double, ptr %ptr_y, align 8
  %x = load <8 x half>, ptr %ptr_x, align 8
  %v1 = load <8 x half>, ptr addrspace(3) @v1_ptr
  %v2 = load <8 x half>, ptr addrspace(3) @v2_ptr
  %cmp = fcmp oeq double %y, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %mul = fmul contract <8 x half> %v1, %x
  %add = fadd contract <8 x half> %v2, %mul
  ret <8 x half> %add

if.else:                                          ; preds = %entry
  %mul1 = fmul contract <8 x half> %v1, %x
  %sub = fsub contract <8 x half> %mul1, %v2
  ret <8 x half> %sub
}

define double @is_profitable_f64_nocontract(ptr dereferenceable(8) %ptr_x, ptr dereferenceable(8) %ptr_y, ptr dereferenceable(8) %ptr_a) #0 {
; GFX-LABEL: define double @is_profitable_f64_nocontract(
; GFX-SAME: ptr dereferenceable(8) [[PTR_X:%.*]], ptr dereferenceable(8) [[PTR_Y:%.*]], ptr dereferenceable(8) [[PTR_A:%.*]]) #[[ATTR0]] {
; GFX-NEXT:    [[Y:%.*]] = load double, ptr [[PTR_Y]], align 8
; GFX-NEXT:    [[CMP:%.*]] = fcmp oeq double [[Y]], 0.000000e+00
; GFX-NEXT:    [[X:%.*]] = load double, ptr [[PTR_X]], align 8
; GFX-NEXT:    [[A_1:%.*]] = load double, ptr [[PTR_A]], align 8
; GFX-NEXT:    [[MUL:%.*]] = fmul double [[X]], [[A_1]]
; GFX-NEXT:    br i1 [[CMP]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; GFX:       [[COMMON_RET:.*]]:
; GFX-NEXT:    [[COMMON_RET_OP:%.*]] = phi double [ [[PTR_ADD:%.*]], %[[IF_THEN]] ], [ [[SUB:%.*]], %[[IF_ELSE]] ]
; GFX-NEXT:    ret double [[COMMON_RET_OP]]
; GFX:       [[IF_THEN]]:
; GFX-NEXT:    [[PTR_ADD]] = fadd double 1.000000e+00, [[MUL]]
; GFX-NEXT:    br label %[[COMMON_RET]]
; GFX:       [[IF_ELSE]]:
; GFX-NEXT:    [[SUB]] = fsub double [[MUL]], [[Y]]
; GFX-NEXT:    br label %[[COMMON_RET]]
;
  %y = load double, ptr %ptr_y, align 8
  %cmp = fcmp oeq double %y, 0.000000e+00
  %x = load double, ptr %ptr_x, align 8
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %a_1 = load double, ptr %ptr_a, align 8
  %mul = fmul double %x, %a_1
  %ptr_add = fadd double 1.000000e+00, %mul
  ret double %ptr_add

if.else:                                          ; preds = %entry
  %a_2 = load double, ptr %ptr_a, align 8
  %mul1 = fmul double %x, %a_2
  %sub = fsub double %mul1, %y
  ret double %sub
}

attributes #0 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #1 = { nounwind "denormal-fp-math"="ieee,ieee" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; FP-CONTRACT-FAST: {{.*}}
; NO-UNSAFE-FP-MATH: {{.*}}
; UNSAFE-FP-MATH: {{.*}}
