; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -verify-machineinstrs | %ptxas-verify %}

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v32:32:32-v64:64:64-v128:128:128-n16:32:64"

declare i16 @llvm.ctlz.i16(i16, i1) readnone
declare i32 @llvm.ctlz.i32(i32, i1) readnone
declare i64 @llvm.ctlz.i64(i64, i1) readnone

; There should be no difference between llvm.ctlz.i32(%a, true) and
; llvm.ctlz.i32(%a, false), as ptx's clz(0) is defined to return 0.

define i32 @myctlz(i32 %a) {
; CHECK-LABEL: myctlz(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [myctlz_param_0];
; CHECK-NEXT:    clz.b32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.ctlz.i32(i32 %a, i1 false) readnone
  ret i32 %val
}
define i32 @myctlz_2(i32 %a) {
; CHECK-LABEL: myctlz_2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [myctlz_2_param_0];
; CHECK-NEXT:    clz.b32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.ctlz.i32(i32 %a, i1 true) readnone
  ret i32 %val
}

; PTX's clz.b64 returns a 32-bit value, but LLVM's intrinsic returns a 64-bit
; value, so here we have to zero-extend it.
define i64 @myctlz64(i64 %a) {
; CHECK-LABEL: myctlz64(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz64_param_0];
; CHECK-NEXT:    clz.b64 %r1, %rd1;
; CHECK-NEXT:    cvt.u64.u32 %rd2, %r1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = call i64 @llvm.ctlz.i64(i64 %a, i1 false) readnone
  ret i64 %val
}
define i64 @myctlz64_2(i64 %a) {
; CHECK-LABEL: myctlz64_2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz64_2_param_0];
; CHECK-NEXT:    clz.b64 %r1, %rd1;
; CHECK-NEXT:    cvt.u64.u32 %rd2, %r1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = call i64 @llvm.ctlz.i64(i64 %a, i1 true) readnone
  ret i64 %val
}

; Here we truncate the 64-bit value of LLVM's ctlz intrinsic to 32 bits, the
; natural return width of ptx's clz.b64 instruction.  No conversions should be
; necessary in the PTX.
define i32 @myctlz64_as_32(i64 %a) {
; CHECK-LABEL: myctlz64_as_32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz64_as_32_param_0];
; CHECK-NEXT:    clz.b64 %r1, %rd1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %val = call i64 @llvm.ctlz.i64(i64 %a, i1 false) readnone
  %trunc = trunc i64 %val to i32
  ret i32 %trunc
}
define i32 @myctlz64_as_32_2(i64 %a) {
; CHECK-LABEL: myctlz64_as_32_2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz64_as_32_2_param_0];
; CHECK-NEXT:    clz.b64 %r1, %rd1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %val = call i64 @llvm.ctlz.i64(i64 %a, i1 false) readnone
  %trunc = trunc i64 %val to i32
  ret i32 %trunc
}

; ctlz.i16 is implemented by extending the input to i32, computing the result,
; and then truncating the result back down to i16.  But the NVPTX ABI
; zero-extends i16 return values to i32, so the final truncation doesn't appear
; in this function.
define i16 @myctlz_ret16(i16 %a) {
; CHECK-LABEL: myctlz_ret16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %r1, [myctlz_ret16_param_0];
; CHECK-NEXT:    clz.b32 %r2, %r1;
; CHECK-NEXT:    add.s32 %r3, %r2, -16;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i16 @llvm.ctlz.i16(i16 %a, i1 false) readnone
  ret i16 %val
}
define i16 @myctlz_ret16_2(i16 %a) {
; CHECK-LABEL: myctlz_ret16_2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %r1, [myctlz_ret16_2_param_0];
; CHECK-NEXT:    shl.b32 %r2, %r1, 16;
; CHECK-NEXT:    clz.b32 %r3, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i16 @llvm.ctlz.i16(i16 %a, i1 true) readnone
  ret i16 %val
}

; Here we store the result of ctlz.16 into an i16 pointer, so the trunc should
; remain.
define void @myctlz_store16(i16 %a, ptr %b) {
; CHECK-LABEL: myctlz_store16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %r1, [myctlz_store16_param_0];
; CHECK-NEXT:    clz.b32 %r2, %r1;
; CHECK-NEXT:    add.s32 %r3, %r2, -16;
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz_store16_param_1];
; CHECK-NEXT:    st.b16 [%rd1], %r3;
; CHECK-NEXT:    ret;
  %val = call i16 @llvm.ctlz.i16(i16 %a, i1 false) readnone
  store i16 %val, ptr %b
  ret void
}
define void @myctlz_store16_2(i16 %a, ptr %b) {
; CHECK-LABEL: myctlz_store16_2(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %r1, [myctlz_store16_2_param_0];
; CHECK-NEXT:    clz.b32 %r2, %r1;
; CHECK-NEXT:    add.s32 %r3, %r2, -16;
; CHECK-NEXT:    ld.param.b64 %rd1, [myctlz_store16_2_param_1];
; CHECK-NEXT:    st.b16 [%rd1], %r3;
; CHECK-NEXT:    ret;
  %val = call i16 @llvm.ctlz.i16(i16 %a, i1 false) readnone
  store i16 %val, ptr %b
  ret void
}
