; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN:  llc -amdgpu-scalarize-global-loads=false -march=r600 -mcpu=redwood < %s | FileCheck --check-prefix=R600 %s

define amdgpu_kernel void @fneg_fabsf_fadd_f32(ptr addrspace(1) %out, float %x, float %y) {
; R600-LABEL: fneg_fabsf_fadd_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; R600-NEXT:     ADD * T1.X, KC0[2].W, -|KC0[2].Z|,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %fabs = call float @llvm.fabs.f32(float %x)
  %fsub = fsub float -0.000000e+00, %fabs
  %fadd = fadd float %y, %fsub
  store float %fadd, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @fneg_fabsf_fmul_f32(ptr addrspace(1) %out, float %x, float %y) {
; R600-LABEL: fneg_fabsf_fmul_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T1.X, T0.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     LSHR T0.X, KC0[2].Y, literal.x,
; R600-NEXT:     MUL_IEEE * T1.X, KC0[2].W, -|KC0[2].Z|,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %fabs = call float @llvm.fabs.f32(float %x)
  %fsub = fsub float -0.000000e+00, %fabs
  %fmul = fmul float %y, %fsub
  store float %fmul, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @fneg_fabsf_free_f32(ptr addrspace(1) %out, i32 %in) {
; R600-LABEL: fneg_fabsf_free_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[2].Z,
; R600-NEXT:     MOV * T0.W, |PV.W|,
; R600-NEXT:     MOV T0.X, -PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %bc = bitcast i32 %in to float
  %fabs = call float @llvm.fabs.f32(float %bc)
  %fsub = fsub float -0.000000e+00, %fabs
  store float %fsub, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fneg_fabsf_fn_free_f32(ptr addrspace(1) %out, i32 %in) {
; R600-LABEL: fneg_fabsf_fn_free_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[2].Z,
; R600-NEXT:     MOV * T0.W, |PV.W|,
; R600-NEXT:     MOV T0.X, -PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %bc = bitcast i32 %in to float
  %fabs = call float @fabsf(float %bc)
  %fsub = fsub float -0.000000e+00, %fabs
  store float %fsub, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fneg_fabsf_f32(ptr addrspace(1) %out, float %in) {
; R600-LABEL: fneg_fabsf_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[2].Z,
; R600-NEXT:     MOV * T0.W, |PV.W|,
; R600-NEXT:     MOV T0.X, -PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %fabs = call float @llvm.fabs.f32(float %in)
  %fsub = fsub float -0.000000e+00, %fabs
  store float %fsub, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v_fneg_fabsf_f32(ptr addrspace(1) %out, ptr addrspace(1) %in) {
; R600-LABEL: v_fneg_fabsf_f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 0, @8, KC0[CB0:0-32], KC1[]
; R600-NEXT:    TEX 0 @6
; R600-NEXT:    ALU 3, @9, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.X, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    Fetch clause starting at 6:
; R600-NEXT:     VTX_READ_32 T0.X, T0.X, 0, #1
; R600-NEXT:    ALU clause starting at 8:
; R600-NEXT:     MOV * T0.X, KC0[2].Z,
; R600-NEXT:    ALU clause starting at 9:
; R600-NEXT:     MOV * T0.W, |T0.X|,
; R600-NEXT:     MOV T0.X, -PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %val = load float, ptr addrspace(1) %in, align 4
  %fabs = call float @llvm.fabs.f32(float %val)
  %fsub = fsub float -0.000000e+00, %fabs
  store float %fsub, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @fneg_fabsf_v2f32(ptr addrspace(1) %out, <2 x float> %in) {
; R600-LABEL: fneg_fabsf_v2f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 7, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV T0.W, KC0[3].X,
; R600-NEXT:     MOV * T1.W, KC0[2].W,
; R600-NEXT:     MOV * T0.W, |PV.W|,
; R600-NEXT:     MOV T0.Y, -PV.W,
; R600-NEXT:     MOV * T0.W, |T1.W|,
; R600-NEXT:     MOV T0.X, -PV.W,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %in)
  %fsub = fsub <2 x float> <float -0.000000e+00, float -0.000000e+00>, %fabs
  store <2 x float> %fsub, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @fneg_fabsf_v4f32(ptr addrspace(1) %out, <4 x float> %in) {
; R600-LABEL: fneg_fabsf_v4f32:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 13, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T2.XYZW, T0.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, KC0[4].X,
; R600-NEXT:     MOV T0.W, |PV.W|,
; R600-NEXT:     MOV * T1.W, KC0[3].W,
; R600-NEXT:     MOV T0.Z, KC0[3].Z,
; R600-NEXT:     MOV T1.W, |PS|,
; R600-NEXT:     MOV * T2.W, -PV.W,
; R600-NEXT:     MOV T2.Z, -PV.W,
; R600-NEXT:     MOV T0.W, KC0[3].Y,
; R600-NEXT:     MOV * T1.W, |PV.Z|,
; R600-NEXT:     MOV T2.Y, -PS,
; R600-NEXT:     MOV * T0.W, |PV.W|,
; R600-NEXT:     MOV T2.X, -PV.W,
; R600-NEXT:     LSHR * T0.X, KC0[2].Y, literal.x,
; R600-NEXT:    2(2.802597e-45), 0(0.000000e+00)
  %fabs = call <4 x float> @llvm.fabs.v4f32(<4 x float> %in)
  %fsub = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %fabs
  store <4 x float> %fsub, ptr addrspace(1) %out
  ret void
}

declare float @fabsf(float) readnone
declare float @llvm.fabs.f32(float) readnone
declare <2 x float> @llvm.fabs.v2f32(<2 x float>) readnone
declare <4 x float> @llvm.fabs.v4f32(<4 x float>) readnone

