; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE4
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE4
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" -mtriple=x86_64-apple-darwin 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ

define i32 @reduce_i64(i32 %arg) {
; SSE2-LABEL: 'reduce_i64'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:17 Lat:10 SizeLat:17 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:32 Lat:18 SizeLat:32 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:62 Lat:34 SizeLat:62 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:122 Lat:66 SizeLat:122 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i64'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:17 Lat:10 SizeLat:17 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:32 Lat:18 SizeLat:32 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:62 Lat:34 SizeLat:62 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:34 CodeSize:122 Lat:66 SizeLat:122 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'reduce_i64'
; SSE4-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:9 SizeLat:5 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:6 Lat:16 SizeLat:8 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:10 Lat:30 SizeLat:14 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:18 Lat:58 SizeLat:26 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i64'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:4 Lat:9 SizeLat:6 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:7 Lat:17 SizeLat:11 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:13 Lat:26 SizeLat:23 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:25 Lat:44 SizeLat:47 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i64'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:9 SizeLat:5 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:17 SizeLat:9 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:24 SizeLat:12 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:38 SizeLat:18 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_i64'
; AVX512-NEXT:  Cost Model: Found costs of 0 for: %V1 = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:7 SizeLat:3 for: %V2 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:11 SizeLat:5 for: %V4 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:15 SizeLat:7 for: %V8 = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:18 SizeLat:8 for: %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V1  = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> undef)
  %V2  = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
  %V4  = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
  %V8  = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> undef)
  %V16 = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> undef)
  ret i32 undef
}

define i32 @reduce_i32(i32 %arg) {
; SSE2-LABEL: 'reduce_i32'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:6 SizeLat:7 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:13 Lat:11 SizeLat:13 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:18 Lat:15 SizeLat:18 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:28 Lat:23 SizeLat:28 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:48 Lat:39 SizeLat:48 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i32'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:6 SizeLat:7 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:13 Lat:11 SizeLat:13 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:18 Lat:15 SizeLat:18 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:28 Lat:23 SizeLat:28 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:48 Lat:39 SizeLat:48 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'reduce_i32'
; SSE4-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; SSE4-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; SSE4-NEXT:  Cost Model: Found costs of 6 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; SSE4-NEXT:  Cost Model: Found costs of 8 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; SSE4-NEXT:  Cost Model: Found costs of 12 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i32'
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:12 Lat:13 SizeLat:13 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:22 Lat:25 SizeLat:25 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i32'
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:8 SizeLat:9 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:10 SizeLat:13 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'reduce_i32'
; AVX512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:5 SizeLat:3 for: %V2 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:9 SizeLat:5 for: %V4 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:11 SizeLat:7 for: %V8 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:13 SizeLat:10 for: %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:10 Lat:14 SizeLat:11 for: %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2  = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
  %V4  = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
  %V8  = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
  %V16 = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> undef)
  %V32 = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> undef)
  ret i32 undef
}

define i32 @reduce_i16(i32 %arg) {
; SSE2-LABEL: 'reduce_i16'
; SSE2-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of 8 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of 10 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of 14 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i16'
; SSSE3-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 8 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 10 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of 14 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'reduce_i16'
; SSE4-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of 5 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of 7 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of 11 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i16'
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:11 Lat:12 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:21 Lat:24 SizeLat:24 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i16'
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:7 Lat:7 SizeLat:8 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:12 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'reduce_i16'
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:11 Lat:15 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:16 Lat:22 SizeLat:17 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'reduce_i16'
; AVX512BW-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 9 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'reduce_i16'
; AVX512DQ-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 4 for: %V8 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:11 Lat:15 SizeLat:12 for: %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:16 Lat:22 SizeLat:17 for: %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2  = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
  %V4  = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
  %V8  = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
  %V16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
  %V32 = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> undef)
  %V64 = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> undef)
  ret i32 undef
}

define i32 @reduce_i8(i32 %arg) {
; SSE2-LABEL: 'reduce_i8'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:6 SizeLat:7 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:13 Lat:11 SizeLat:13 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:19 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:25 Lat:21 SizeLat:25 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:30 Lat:25 SizeLat:30 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:40 Lat:33 SizeLat:40 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:60 Lat:49 SizeLat:60 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'reduce_i8'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:6 SizeLat:7 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:13 Lat:11 SizeLat:13 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:19 Lat:16 SizeLat:19 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:25 Lat:21 SizeLat:25 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:30 Lat:25 SizeLat:30 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:19 CodeSize:40 Lat:33 SizeLat:40 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:60 Lat:49 SizeLat:60 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE4-LABEL: 'reduce_i8'
; SSE4-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 7 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 9 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of 13 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; SSE4-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'reduce_i8'
; AVX1-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:13 Lat:14 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:23 Lat:26 SizeLat:26 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'reduce_i8'
; AVX2-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:9 SizeLat:10 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:11 Lat:11 SizeLat:14 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'reduce_i8'
; AVX512F-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:17 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:18 Lat:24 SizeLat:19 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'reduce_i8'
; AVX512BW-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 10 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 11 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'reduce_i8'
; AVX512DQ-NEXT:  Cost Model: Found costs of 3 for: %V2 = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 5 for: %V4 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 7 for: %V8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 6 for: %V16 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 8 for: %V32 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:13 Lat:17 SizeLat:14 for: %V64 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:18 Lat:24 SizeLat:19 for: %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %V2   = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> undef)
  %V4   = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
  %V8   = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
  %V16  = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
  %V32  = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
  %V64  = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
  %V128 = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> undef)
  ret i32 undef
}

declare i64 @llvm.vector.reduce.smax.v1i64(<1 x i64>)
declare i64 @llvm.vector.reduce.smax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smax.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.smax.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.smax.v16i64(<16 x i64>)

declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smax.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.smax.v16i32(<16 x i32>)
declare i32 @llvm.vector.reduce.smax.v32i32(<32 x i32>)

declare i16 @llvm.vector.reduce.smax.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smax.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.smax.v32i16(<32 x i16>)
declare i16 @llvm.vector.reduce.smax.v64i16(<64 x i16>)

declare i8 @llvm.vector.reduce.smax.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.smax.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smax.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.smax.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.smax.v64i8(<64 x i8>)
declare i8 @llvm.vector.reduce.smax.v128i8(<128 x i8>)
