; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; AND
;

define <8 x i8> @and_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: and_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = and <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @and_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: and_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = and <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @and_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: and_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    and z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = and <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @and_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: and_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = and <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @and_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: and_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = and <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @and_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: and_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    and z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = and <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @and_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: and_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = and <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @and_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: and_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = and <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @and_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: and_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    and z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    and w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    and w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = and <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @and_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: and_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    and x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = and <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @and_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: and_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    and x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    and x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = and <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @and_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: and_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    and z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: and_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    and x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    and x8, x9, x8
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    and x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    and x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = and <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

;
; OR
;

define <8 x i8> @or_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: or_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = or <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @or_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: or_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = or <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @or_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: or_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orr z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = or <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @or_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: or_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = or <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @or_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: or_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = or <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @or_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: or_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orr z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = or <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @or_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: or_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = or <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @or_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: or_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = or <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @or_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: or_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orr z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = or <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @or_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: or_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    orr x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = or <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @or_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: or_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    orr z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = or <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @or_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: or_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orr z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: or_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    orr x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    orr x8, x9, x8
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    orr x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    orr x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = or <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}

;
; XOR
;

define <8 x i8> @xor_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: xor_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = xor <8 x i8> %op1, %op2
  ret <8 x i8> %res
}

define <16 x i8> @xor_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = xor <16 x i8> %op1, %op2
  ret <16 x i8> %res
}

define void @xor_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: xor_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eor z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = xor <32 x i8> %op1, %op2
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @xor_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: xor_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = xor <4 x i16> %op1, %op2
  ret <4 x i16> %res
}

define <8 x i16> @xor_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = xor <8 x i16> %op1, %op2
  ret <8 x i16> %res
}

define void @xor_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: xor_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eor z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = xor <16 x i16> %op1, %op2
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @xor_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: xor_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = xor <2 x i32> %op1, %op2
  ret <2 x i32> %res
}

define <4 x i32> @xor_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = xor <4 x i32> %op1, %op2
  ret <4 x i32> %res
}

define void @xor_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: xor_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eor z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    eor w8, w10, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = xor <8 x i32> %op1, %op2
  store <8 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @xor_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: xor_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    eor x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = xor <1 x i64> %op1, %op2
  ret <1 x i64> %res
}

define <2 x i64> @xor_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: xor_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    eor z0.d, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = xor <2 x i64> %op1, %op2
  ret <2 x i64> %res
}

define void @xor_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: xor_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eor z1.d, z2.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: xor_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    eor x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    eor x8, x9, x8
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    eor x8, x10, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    eor x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = xor <4 x i64> %op1, %op2
  store <4 x i64> %res, ptr %a
  ret void
}
